# **실제 면접 질문 모음**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)
[![rlatjdwo555](https://avatars0.githubusercontent.com/u/28692938?s=100&v=4)](https://github.com/rlatjdwo555)
[![Stupid07](https://avatars1.githubusercontent.com/u/35564566?s=100&v=4)](https://github.com/Stupid07)

## 실제 면접 질문 모음
- 이 문서는 면접장에서 실제로 받은 질문들을 리스트화 시켜놓은 문서입니다.(2019년도 기준)
- 개인의 자기소개서 위주로 질문을 받았기에 동떨어진 내용이 있을 수 있습니다.
- 중복된 내용이 있을 수 있습니다.

## 기술 질문
### 자료구조, 알고리즘
- 자료구조중 많이 사용해본것과 사용한 이유
- 스택에 대한 설명이 주어지고 스택 2개를 큐처럼 구현
- 각 정렬의 시간복잡도 비교
- 퀵소트의 시간복잡도, 왜 그 시간복잡도인지, 개선방법
- 이진트리의 탐색 횟수
- A* 알고리즘(휴리스틱 기반 길찾기 알고리즘)
- 문서를 압축하는 다양한 알고리즘에 대해 설명
- 컨테이너를 정렬하는 알고리즘 손코딩
- Generic Queue 손코딩
- 아호코라식 알고리즘
- 힙의 삽입, 삭제 시간복잡도?

## 프로그래밍 언어
### 언어 공통
- 다형성이란?
- 오버로딩과 오버라이딩의 차이
- 오버로딩과 오버라이딩 개념에서 리턴 값은 같아야 되나?
- C와 Java의 차이
- Java와 JavaScript 중 어떤 언어가 더 좋은지?
- C, C++, C# 비교
- C랑 비교해서 Java가 언어적으로 나은 점은?
- 할 수 있는 언어들과 그 언어들의 차이
- 객체끼리 비교할 때 어떻게 같은 객체인지 아는지?
- 주력 언어가 무엇인지, 왜 그 언어를 선택했는지 설명
- 업캐스팅과 다운캐스팅
- Garbage Collection이 무엇인지 설명
- "Hello world"를 출력하는 코드를 실행시킬때 일어나는일 설명
- Clean Code와 Code Refactoring의 정의

### Java
- Reflection 설명
- 왜 getter, setter 함수를 써야하는지?
- 접근제한자 설명
- 객체지향이란 무엇인가?
- 다중 상속에 대해 설명
- Interface는 무엇이고 왜 쓰는지
- Interface와 abstract의 차이
- final에 대해 설명(용도 3가지, 왜 쓰는지)
- Java의 JVM에서 5가지 메모리 구조에 대해 설명
- Java에서 Minor Garbage Collection과 Major Garbage Collection의 동작 방식에 대해 설명
- Collections Framework에서 List, Set, Map 등의 특징
- Exception 발생은 컴파일 과정에서 하는지 실행 과정에서 하는지
- Generic에 대해 이전에 비해 어떤 이점이 있는지 설명
- JVM의 heap 영역 중 young영역에서 survivor부분이 survivor1과 survivor2로 나뉘어져있는 이유?
- JNI의 메모리상에서 변환되어서 실행되는 과정

### C, C++, C#
- C++ virtual 키워드
- C++ 가상함수의 원리
- Vector와 Array의 차이점
- C#의 generic과 C++의 template의 차이점 
- 박싱과 언박싱 in C#
- 얕은 복사와 깊은 복사의 차이
- new, malloc 차이

## 운영체제
- 안드로이드와 윈도우의 차이
- 프로세스와 스레드의 차이
- 메모리 구조에서 스택과 큐의 역할
- 뮤텍스와 세마포어의 차이
- 사용해본 운영체제는?
- 리눅스에서 아는 명령어?
- 리눅스에서 top 키워드?
- 페이지 교체 알고리즘 종류와 방식 설명
- context switching의 오버헤드의 주원인
- 유닉스의 fork 함수
- 데드락에 대해 설명, 해결 방법
- 메모리 단편화와 해결책
- 코드를 주고 lock을 꼭 걸어야 하는 위치 찾기
- 시스템 콜이란?
- 좀비 프로세스와 데몬 프로세스

## 컴퓨터 구조
- call by value, call by reference, call by address
- 버퍼 오버 플로우

## 웹
- Spring의 AOP에 대해 설명
- Spring의 장단점
- 브라우저의 주소창에 000.com을 치면 발생하는 일 최대한 자세히 설명
- 웹 사이트의 속도를 개선하는 방법
- 풀스택 개발자란 무엇?
- 프론트앤드와 백앤드 중에 고객에게 무엇이 더 중요하다고 생각하는지?
- HTTP Method의 종류 설명
- get, post 방식 차이
- MVC, MVVC, MVVM의 차이
- MSA란 무엇인가?
- Open API 결과가 수십만개 일때 어떻게 하면 속도를 개선할지
- Java 8에서 추가된 것
- 트래픽이 많아질때 대처법
- 어떤 기능을 구현하는데 서버에 용량이 부족하다. 어떻게 구현할 것인가?
- 로그를 왜 찍어야 하는지
- 로그를 어디다 저장하는게 좋은지
- HTML과 HTML5의 차이
- 로드밸런싱이란
- 로드밸런싱과 클러스터링 개념과 차이
- 프록시 서버에 대한 설명
- 리버스 프록시 서버를 왜 쓰는지 및 장단점
- 클라우드의 종류에 대해 설명

## 컴퓨터 네트워크
- http tcp udp에 대해 설명
- tcp udp의 차이
- tcp의 nagle 알고리즘
- 3-way handshake 과정에서 통신이 안되면 어떤일이 벌어질지 설명
- 4-way handshake(종료과정) 설명
- http통신을 api를 안쓰고 하려면?
- tcp, udp에서의 checksum의 특징 및 차이에 대해 설명
- tcp/ip에 대해 설명
- tcp flag 종류 설명
- OSI 7계층을 왜 나눴는지 설명
- http와 https의 차이

## 데이터베이스
- JOIN의 종류 설명
- DB Index 설명 및 왜 쓰는지
- DB Index의 트리 구조 설명
- 클러스터링 인덱스란?
- 클러스터링과 non-클러스터링의 차이
- collision 해결방법
- DB Isolation 설명
- 상황을 이해해서 ERD 설계 및 그리기
- 그린 ERD에 따라 처리 프로세스 설명
- Nosql과 RDBMS의 차이
- 정규화 개념과 각 단계별 설명
- 참조 무결성과 관련이 없는 항목
- 비관적 락과 낙관적 락에 대해 

## 소프트웨어 공학
- 아는 디자인패턴 10가지 설명
- 싱글톤이 무엇이고 왜 쓰는지?
- 싱글톤을 쓰면 멀티스레드 환경에서 스레드세이프 한지?
- 멀티스레드 환경과 단일스레드 환경에서 싱글톤 차이
- 싱글톤 외에 스레드세이프하게 구현할 수 있는 디자인 패턴
- 싱글톤에서 스레드세이프 하도록 손코딩
- 옵저버 패턴이 뭔지와 왜 쓰는지?
- 객체지향적으로 도형에 관한 클래스 손코딩
- API란 무엇인가?
- 라이브러리와 프레임워크의 차이
- 객체지향의 5대 원칙(SOLID)
- MSA에 대해 설명

## 신기술
- 최근 IT 신기술에 대해 아는 것을 설명
- AI란?
- AI, Data Transformation, BigData, Customer Experience 중 자신이 경험해본 내용이 있으면 설명
- 블록체인에 대해 간단하게 설명
- 딥러닝과 머신러닝 각자의 개념과 차이점 설명

## 수학, 그래픽스
- 벡터의 외적
- 짐벌락
- 랜더링 파이프라인
- AABB, OBB 충돌 판별
- 행렬 규칙 (덧셈법칙 곱셈법칙 결합법칙)

## 보안
- 공개키 비밀키

## 인성 질문
### 기본 질문
- 자기소개
- 지원동기
- 마지막 할말, 어필하고 싶은 점, 궁금한 것 

### 경험 관련
- 개발자를 선택한 이유
- 개발자로서 최종 목표
- 개발분야는 기술이 빠르게 변화하고 있어서 내가 쓰는 기술이 미래엔 쓰이지 않을 수 있는데 어떤식으로 대비하고 있는지
- 학교생활 외에 추가로 한 것?
- 평상시 쉴때 많이 하는 것
- 스트레스를 푸는 방법
- 쉴 때 뭐하는지?
- 가장 힘들었던 경험과 극복한 방법, 그를통해 얻은것
- 주로 정적인 활동을 선호하는데 동적인 활동은 싫어하는지?
- 살면서 가장 잘했거나 뿌듯했던 경험
- 살면서 부모님께 가장 큰 실망을 줬던 경험
- 살면서 가장 힘들었던 경험
- 최근에 공부하는것?
- 공부는 주로 어떤식으로 하는지?
- 최근에 하고있는 취업준비
- 자신의 현재 행복점수
- 업무를 수행할때 유연하게 대처하는 본인만의 방법
- 자신이 했던 경험을 바탕으로 시스템에 추가할 부분?
- 본인이 가장 잘하는 IT 역량은?
- 가장 좋아하는과목, 싫어하는과목, 학점 낮은과목
- 인생의 최종 목표
- 사용하는 스마트폰의 기종과 선택 이유
- Git을 사용해 봤는지?
- 오픈소스 기여해본적 있나요?
- IT 컨퍼런스에 참여한 적이 있는지?
- 개발이나 공부, 프로젝트를 진행하다보면 막히는 순간이 존재한다. 어떻게 해결하는지? 
- 막히다보면 어떻게 해도 안풀리는 순간이 존재한다. 이럴떄는 어떻게 해결하려고 하는지?
- SW 직군으로써 가져야 될 업에 대한 생각을 말해보라
- 기술 직군으로써 가장 중요한 능력은 무엇이라고 생각하는가?

### 성격 관련
- 성격의 장단점
- 자신이 생각하는 자기자신의 모습과 남들이 생각하는 자기자신의 모습
- 주변에서 자기를 뭐라고 부르는지?(별명)
- 자신만의 강점은? / 남들보다 이것만큼은 잘 할 수 있다?
- 자신의 장단점. 단점은 어떻게 극복중인가?
- 인재상에 자신이 부합하는 이유?
- 꼰대라는 단어를 정의해보라, 이러한 단어가 사용되는 현재, 문제가 무엇이라고 생각하는가?

### 프로젝트 관련
- 가장 기억에 남는 프로젝트?
- 팀 프로젝트에서 맡은 역할
- 팀 프로젝트에서 맡은 역할은?
- 팀 프로젝트에서 리더/팀원 중 주로 어떤 역할인지?
- 팀 프로젝트를 하면서 본인이 주도적으로 뭔가를 했던 경험
- 팀 프로젝트에서 팀원과 트러블 경험, 대처 방법
- 팀 프로젝트에서 가장 함께하기 싫은 사람의 유형은?
- 팀 프로젝트에서 가장 중요하다고 생각하는것
- 프로젝트진행시 코드 관리는 어떤식으로 하였는지?
- 개발자와 PM 역할 중에 선호하는 역할은?
- 프로젝트 경험 중 PM역할로 진행했던 것, 개발자로 진행했던 것 구체적으로 대답하고 차이점을 말해보라


### 기업 관련
- 기업에서 펼치는 사업중에 자신이 잘할 수 있는 부분과 연결지어 자기소개
- 기업에 대해 소개
- 기업에 지원한 이유
- 기업의 강점과 약점
- 기업에 대해 떠오르는 이미지
- 5, 10년후 본인은 어떤 모습일지?
- 지방근무가 있어도 괜찮은지?
- 이 회사에 온다면 어떤 일을 하고 싶은지?
- 좋은 회사란?
- 회사를 고르는 기준은 무엇인지? 그 중 가장 우선시 하는 부분은?
- 경쟁사 제품과 비교했을때 보완해야할 점
- 고객사에서 기능추가는 계속 끈질기게 요구하는 상황, 당신은 어떻게 대응할 생각인지 구체적으로 말해보라
- 당신이 가진 어떤점이 우리 기업에 도움이 될 것이라고 생각하는가?