<p align="center">
  <a href="https://thxmx-ui.netlify.app/">
    <img width="200" src="https://www.npmjs.com/npm-avatar/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdmF0YXJVUkwiOiJodHRwczovL3MuZ3JhdmF0YXIuY29tL2F2YXRhci8xODRhYjI2YmI1YWY5NWI0NDUwZDU5ZTkxMDJmZmU4Nj9zaXplPTQ5NiZkZWZhdWx0PXJldHJvIn0.jflG92OORasQnbyRID5jAj1Znw_6XUZvxBU90BIujI8">
  </a>
</p>

<h1 align="center">ThxmxUi</h1>

<div align="center">

A modern library for reactJS components

[![NPM version][npm-image]][npm-url] [![NPM downloads][download-image]][download-url]

[npm-image]: https://img.shields.io/npm/v/thxmx-ui?style=for-the-badge
[npm-url]: https://www.npmjs.com/package/thxmx-ui
[download-image]: https://img.shields.io/npm/dm/thxmx-ui.svg?style=for-the-badge
[download-url]: https://npmjs.org/package/thxmx-ui

</div>

<div align="center">

[![Make deployment](https://github.com/jnadroj/thxmx-ui/actions/workflows/deployment.yml/badge.svg)](https://github.com/jnadroj/thxmx-ui/actions/workflows/deployment.yml)

</div>

## 📚 Homepage

- Visit [here](https://thxmx-ui.netlify.app/)

![s2](<./public/assets/Screenshot%20(185).png>)

## ✨ Features

- 📦 An uncommonly high quality set of React components.
- 🛡 Written entirely in TypeScript with predictable static types.
- ⚙️ A full suite of design resources and tools to facilitate development.

## 📦 Install

```bash
npm install thxmx-ui
```

```bash
yarn add thxmx-ui
```

## 🔨 Usage

```tsx
import React, { FC } from 'react';
import { Button, Input } from 'thxmx-ui';

const App: FC = () => (
  <>
    <Input label="Label" hint="Hint" />
    <Button label="Print" color="primary" />
  </>
);

export default App;
```

## ⌨️ Development

### Node version

First of all let's use version 16 of node so we don't have compatibility problems, for this we can use [nvm](https://github.com/nvm-sh/nvm#installing-and-updating) just run in the repository folder the command:

```bash
$ nvm use
```

This command will look for the .nvmrc file and will find the version with which the project was created.

---

### Development environment

Use Gitpod, a free online dev environment for GitHub.

[![Open in Gitpod](https://gitpod.io/button/open-in-gitpod.svg)](https://gitpod.io/#https://github.com/jnadroj/thxmx-ui)

Or clone locally:

```bash
$ git clone git@github.com:jnadroj/thxmx-ui.git
$ cd thxmx-ui
$ npm install
$ npm run dev
```

Open your browser and visit http://127.0.0.1:3000

## Prerequisites 🛠️

Before you begin, ensure you have met the following requirements:

Make sure you have:

- Nodejs
- npm or yarn
- git

## Let's Contribute 👍

- Step 1 - Fork this repository.
- Step 2 - Clone the repository to your local machine.
- Step 3 - Resolve the bugs, mentions provided in the Issues section of the repository. Also add a description of what changes you have done.
- Step 4 - Add the changes to your repository.
- Step 5 - Create a PULL Request. And that's all.

## What you can contribute in this repo? 👊

- You can add your own competitive programming solutions.
- There are various topics like Functionality, Modal aspect of thxmx-ui etc. You can contribute in them
- You can contribute some Learning Resources in the READme.md File.
- You can modify previous solutions if you feel like your solution has better Time or Space complexity.

[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com)

## For more info about contribution visit :

<a href="https://github.com/jnadroj/thxmx-ui/blob/master/CONTRIBUTING.md">🔗 CONTRIBUTION.md</a>

## Contributors 💡

Thanks to the following people who have contributed to this project:

@jnadroj 📖
@Frey0-0 🐛
@eriandev 🐛
@krazykaushal 🐛
@kartikjoshi267 🐛
@Dorcastunmise 🐛

## Keywords 🤌

TypeScript javascript Library ReactJS Components Microsoft compiler language UI React-ui framework
frontend Design library-ui
