//edit js
export default{
  name: 'swiper',
  data: function () {
    return {
      tmpId:'swiper'+(''+Math.random()).split('.')[1],
      status:'default',
      pages:[],
      rowHeight:0,
      showPagination:false,
      showScrollbar:false,
      swiper:null
    }
  },
  props: {
    type: {
      type: String,
      default: 'content'
    },
    items: {
      type: Array,
      default: []
    },
    isRefresh: {
      type: Boolean,
      default: false
    },
    isMore: {
      type: Boolean,
      default: false
    },
    autoplay: {
      type: Boolean,
      default: false
    },
    autoBottom: {
      type: Boolean,
      default: true
    },
    col: {
      type: Number,
      default: 3
    },
    row: {
      type: Number,
      default: 2
    }
  },
  mounted(){
    this.$nextTick(()=>{
      this.init();
      this.itemsUpdate();
    });
  },
  destroyed(){
    if(this.swiper){
      try{
        this.swiper.destroy();
      }catch(e){
        
      }
    }
  },
  watch:{
    items(){
      this.itemsUpdate();
    }
  },
  methods:{
    init(){
      var that=this;
      var opt={
        direction: 'vertical'
      };
      if(this.type=='content'){
        opt.slidesPerView='auto';
        opt.updateOnWindowResize=true;
        opt.freeMode=true;
        opt.mousewheel=true;
        opt.scrollbar={
          el: '.swiper-scrollbar',
        };
        this.showScrollbar=true;
      }else if(this.type=='grid'){
        opt.direction='horizontal';
        opt.slidesPerView=1;
        opt.pagination={
          el: '.swiper-pagination',
        };
        this.showPagination=true;
      }else if(this.type=='slide'){
        opt.direction='horizontal';
        opt.loop=true;
        opt.freeMode=false;
        opt.autoplay=this.autoplay=='true'?true:false;
        this.showPagination=false;
      }
      opt.on={
        touchStart(event){
        },
        touchMove(event){
          //console.log(that.swiper.translate);
          if(that.swiper.translate>50){
            that.status='canrefresh';
          }else{
            that.status='default';
          }
        },
        touchEnd(event){
          if(that.type=='content'){
            if(that.status=='canrefresh'){
              that.$emit('refresh',that.swiper.translate);
              if(that.isRefresh){
                that.status='refreshing';
                setTimeout(()=>{
                  that.status='default';
                },2000);
              }
              return;
            }
            var _viewHeight = that.$refs.wrapper.offsetHeight;
            var _contentHeight = that.$refs.slide.offsetHeight;
            if(that.swiper.translate<=_viewHeight-_contentHeight-50 && that.swiper.translate<0){
              that.$emit('more',_viewHeight-_contentHeight-that.swiper.translate);
            }
          }
        }
      }
      this.swiper = new Swiper('#'+this.tmpId, opt);
    },
    itemsUpdate(){
      if(this.type=='grid'){
        var pages=[];
        var pagesize=this.row*this.col;
        var pagecount=Math.ceil(this.items.length/pagesize);
        var index=0;
        for(var i=0;i<pagecount;i++){
          var page=[];
          for(var r=0;r<this.row;r++){
            var row=[];
            for(var c=0;c<this.col;c++){
              if(index>=this.items.length){
                row.push({});
              }else{
                row.push(this.items[index]);
              }
              index++;
            }
            page.push(row);
          }
          pages.push(page);
        }
        this.pages=pages;
      }
      this.$nextTick(()=>{
        this.status='default';
        if(this.swiper){
          this.swiper.update();
        }
      });
    },
    update(){
      this.$nextTick(()=>{
        if(this.swiper){
          this.swiper.update();
        }
      });
    },
    bottom(){
      this.$nextTick(()=>{
        this.swiper.update();
        var _contentHeight = this.$refs.slide.offsetHeight;
        this.swiper.translateTo(-_contentHeight,100,false,false);
      });
    },
    append(items,pos){
      var pos=pos||'after';
      var newItems=this.items;
      if(pos=='before'){
        for(var i=0;i<items.length;i++){
          newItems.unshift(items[i]);
        }
        var translate=this.swiper.translate;
        var _contentHeight = this.$refs.slide.offsetHeight;
        this.items=newItems;
        this.$nextTick(()=>{
          this.swiper.update();
          var newHeight=this.$refs.slide.offsetHeight-_contentHeight;
          this.swiper.translateTo(translate-newHeight,0,false,false);
        });
      }else{
        for(var i=0;i<items.length;i++){
          newItems.push(items[i]);
        }
        this.items=newItems;
        this.bottom();
      }
    }
  }
}
