<?php

/* ========================================================================
 * $Id: pay.php 2641 2020-07-08 15:37:20Z onez $
 * 
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onez.cn
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */

!defined('IN_ONEZ') && exit('Access Denied');
$order=$G['this']->data()->open('temp.orders')->one("token='$orderno'");
include_once(dirname(dirname(__FILE__)).'/api.php');
$trade_order_id = $order['data']['orderno'];
$appid              = $PT['api_appid'];
$appsecret          = $PT['api_appsecret'];
$payment          = 'alipay';
$my_plugin_id =$order['data']['sitetoken'];

$data=array(
    'version'   => '1.1',//固定值，api 版本，目前暂时是1.1
    'lang'       => 'zh-cn', //必须的，zh-cn或en-us 或其他，根据语言显示页面
    'plugins'   => $my_plugin_id,//必须的，根据自己需要自定义插件ID，唯一的，匹配[a-zA-Z\d\-_]+
    'appid'     => $appid, //必须的，APPID
    'trade_order_id'=> $trade_order_id, //必须的，网站订单ID，唯一的，匹配[a-zA-Z\d\-_]+
    'payment'   => $payment,//必须的，支付接口标识：wechat(微信接口)|alipay(支付宝接口)
    'total_fee' => $order['data']['price'],//人民币，单位精确到分(测试账户只支持0.1元内付款)
    'title'     => $order['data']['subject'], //必须的，订单标题，长度32或以内
    'time'      => time(),//必须的，当前时间戳，根据此字段判断订单请求是否已超时，防止第三方攻击服务器
    'notify_url'=>  $this->url.'/php/notify.php', //必须的，支付成功异步回调接口
    'return_url'=> $this->url.'/php/success.php',//必须的，支付成功后的跳转地址
    'callback_url'=>$this->url.'/php/checkout.php',//必须的，支付发起地址（未支付或支付失败，系统会会跳到这个地址让用户修改支付信息）
'modal'=>NULL, //可空，支付模式 ，可选值( full:返回完整的支付网页; qrcode:返回二维码; 空值:返回支付跳转链接)
    'nonce_str' => str_shuffle(time())//必须的，随机字符串，作用：1.避免服务器缓存，2.防止安全密钥被猜测出来
);
#print_r($data);exit();
$hashkey =$appsecret;
$data['hash']     = XH_Payment_Api::generate_xh_hash($data,$hashkey);
$response     = XH_Payment_Api::http_post($url, json_encode($data));
$result       = $response?json_decode($response,true):null;
if(!$result){
  return onez('vue')->error('Internal server error');
}

$hash=XH_Payment_Api::generate_xh_hash($result,$hashkey);
if(!isset( $result['hash'])|| $hash!=$result['hash']){
  return onez('vue')->error('Invalid sign!');
}

if($result['errcode']!=0){
  return onez('vue')->error($result['errmsg']);
}
$A['qrcode']=$result['url_qrcode'];
$A['url']=$result['url'];
$A['result']='next';
if(onez('bs')->is_mobile()){
  $A['method']='location';
}
return $A;