<?php

/* ========================================================================
 * $Id: bs.money.php 5265 2020-06-17 21:38:49Z onez $
 * 
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onezphp.com
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */

!defined('IN_ONEZ') && exit('Access Denied');
#名称：财务模块
#标识：bs.money

class onezphp_bs_money extends onezphp{
  var $_type='money';
  function __construct(){
    
  }
  function type($type){
    $this->_type=$type;
    return $this;
  }
  function credit(){
    return $this->type('credit');
  }
  function money(){
    return $this->type('money');
  }
  function db(){
    global $G;
    return $G['this']->userdb()->open('member');
  }
  /**
  * 入账
  * 
  * @param undefined $userid
  * @param undefined $money
  * @param undefined $title
  * @param undefined $extra
  * 
  * @return
  */
  function addIn($userid,$money,$title,$extra=array()){
    global $G;
    $u=$this->db()->one("id='$userid'");
    $item=array();
    if($this->_type=='money'){
      $item['money1']=$u['money1']+$money;
      $this->db()->update($item,"id='$userid'");
    }elseif($this->_type=='credit'){
      $item['index1']=$u['index1']+$money;
      $this->db()->update($item,"id='$userid'");
    }
    
    if(!is_array($extra)){
      $extra=array();
    }
    $extra['title']=$title;
    $extra['money']=$money;
    $extra['userid']=$userid;
    $this->writeLog($extra);
    $this->report($userid,$money);
  }
  /**
  * 出账
  * 
  * @param undefined $userid
  * @param undefined $money
  * @param undefined $title
  * @param undefined $extra
  * 
  * @return
  */
  function addOut($userid,$money,$title,$extra=array()){
    #从余额扣除
    if($extra['deducted']){
      $u=$this->db()->one("id='$userid'");
      $item=array();
      if($this->_type=='money'){
        $item['money1']=$u['money1']-$money;
      }elseif($this->_type=='credit'){
        $item['index1']=$u['index1']-$money;
      }else{
        return;
      }
      $this->db()->update($item,"id='$userid'");
    }
    
    if(!is_array($extra)){
      $extra=array();
    }
    $extra['title']=$title;
    $extra['money']=-$money;
    $extra['userid']=$userid;
    $this->writeLog($extra);
    $this->report($userid,-$money);
  }
  /**
  * 写入财务记录
  * 
  * @param undefined $item
  * 
  * @return
  */
  function writeLog($item){
    global $G;
    $item['key1']=$item['title'];
    $item['key2']=$item['orderno'];
    $item['key3']=$this->_type;
    if($this->_type=='money'){
      $item['money1']=$item['money'];
    }else{
      $item['index1']=$item['money'];
    }
    $item['addtime']=time();
    $G['this']->data()->open('money.log')->insert($item);
  }
  function methods($token=false){
    $method=array();
    #总
    $method[]=array('total','total');
    #年
    $method[]=array('year',date('Y'));
    #月
    $method[]=array('month',date('Y-m'));
    #日
    $method[]=array('day',date('Y-m-d'));
    #周
    $method[]=array('year-week',date('oW'));
    #星期几
    $method[]=array('week',date('w'));
    #季度
    $method[]=array('quarter',date('Y').'-'.$this->getQuarterByMonth(time()));
    
    if($token!==false){
      foreach($method as $v){
        if($v[0]==$token){
          return $v;
        }
      }
    }
    
    return $method;
  }
  /**
  * 财务统计
  * 
  * @param undefined $userid
  * @param undefined $money
  * 
  * @return
  */
  function report($userid,$money){
    global $G;
    
    #统计类型
    $sorts=array();
    if($money>0){
      $sorts[]='in';
    }else{
      $sorts[]='out';
    }
    $sorts[]='total';
    
    foreach($this->methods() as $v){
      foreach($sorts as $sort){
        list($token,$type)=$v;
        $T=$G['this']->data()->open('money.report')->one("token='$token' and key1='$type' and key2='$sort' and key3='".$this->_type."' and userid='$userid'");
        if($sort=='total'){
          $money_=$money;
        }else{
          $money_=abs($money);
        }
        if($T){
          $item=array();
          if($this->_type=='money'){
            $item['money1']=$T['money1']+$money_;
          }else{
            $item['index1']=$T['index1']+$money_;
          }
          $G['this']->data()->open('money.report')->update($item,"id='$T[id]'");
        }else{
          $item=array();
          $item['token']=$token;
          $item['key1']=$type;
          $item['key2']=$sort;
          $item['key3']=$this->_type;
          $item['userid']=$userid;
          
          if($this->_type=='money'){
            $item['money1']=$money_;
          }else{
            $item['index1']=$money_;
          }
          $G['this']->data()->open('money.report')->insert($item);
        }
      }
    }
  }
  function getMoney($userid){
    $u=$this->db()->one("id='$userid'");
    return $u['money1'];
  }
  function getCredit($userid){
    global $G;
    $u=$this->db()->one("id='$userid'");
    return $u['index1']*1;
  }
  function getValue($userid,$token,$sort,$type=false){
    global $G;
    if($type===false){
      list($token,$type)=$this->methods($token);
    }
    $T=$G['this']->data()->open('money.report')->one("token='$token' and key1='$type' and key2='$sort' and key3='".$this->_type."' and userid='$userid'");
    if($this->_type=='money'){
      return number_format((float)$T['money1'],2,'.','');
    }else{
      return (int)$T['index1'];
    }
  }
  function getQuarterByMonth($time){
    $month = date('m',$time);
    $Q = ceil($month/3);
    return $Q;
  }
}