<?php

/* ========================================================================
 * $Id: env.php 4288 2020-07-07 12:00:07Z onez $
 * 
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onez.cn
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */

!defined('IN_ONEZ') && exit('Access Denied');
# 运行环境检测
# env
#请求数据
if($MODE=='$post'){
  $action=onez()->gp('action');
  if($action=='data'){
    $envs=array();
  	if(PHP_SHLIB_SUFFIX == 'dll') {
      $envs[]=array(
        'icon'=>'success',
        'label'=>'服务器操作系统',
        'value'=>php_uname(),
        //'summary'=>'建议使用 Linux 系统以提升程序性能',
      );
  	}else{
      $envs[]=array(
        'icon'=>'success',
        'label'=>'服务器操作系统',
        'value'=>php_uname(),
        'summary'=>'',
      );
    }
  	if(PHP_SAPI == 'isapi') {
      $envs[]=array(
        'icon'=>'fail',
        'label'=>'Web服务器环境',
        'value'=>$_SERVER['SERVER_SOFTWARE'],
        'summary'=>'建议使用 Apache 或 Nginx 以提升程序性能',
      );
  	}else{
      $envs[]=array(
        'icon'=>'success',
        'label'=>'Web服务器环境',
        'value'=>$_SERVER['SERVER_SOFTWARE'],
        'summary'=>'',
      );
    }
  	if(version_compare(PHP_VERSION, '5.4.0') == -1) {
      $envs[]=array(
        'icon'=>'close',
        'label'=>'PHP版本',
        'value'=>PHP_VERSION,
        'summary'=>'PHP版本必须为 5.4.0 以上. ',
      );
  	}else{
      $envs[]=array(
        'icon'=>'success',
        'label'=>'PHP版本',
        'value'=>PHP_VERSION,
        'summary'=>'',
      );
    }
    $envs[]=array(
      'icon'=>'success',
      'label'=>'程序安装目录',
      'value'=>ONEZ_ROOT,
      'summary'=>'',
    );
  	if(function_exists('disk_free_space')) {
      $envs[]=array(
        'icon'=>'success',
        'label'=>'磁盘空间',
        'value'=>floor(disk_free_space(ONEZ_ROOT) / (1024*1024)).'M',
        'summary'=>'',
      );
  	} else {
      $envs[]=array(
        'icon'=>'fail',
        'label'=>'磁盘空间',
        'value'=>'unknow',
        'summary'=>'',
      );
  	}

  	$r = extension_loaded('curl') && function_exists('curl_init');
  	if($r) {
      $envs[]=array(
        'icon'=>'success',
        'label'=>'cURL',
        'value'=>'支持',
        'summary'=>'',
      );
  	} else {
      $envs[]=array(
        'icon'=>'close',
        'label'=>'cURL',
        'value'=>'不支持',
        'summary'=>'您的PHP环境不支持cURL, 也不支持 allow_url_fopen, 系统无法正常运行.',
      );
  	}
  	$r = extension_loaded('openssl');
  	if($r) {
      $envs[]=array(
        'icon'=>'success',
        'label'=>'openSSL',
        'value'=>'支持',
        'summary'=>'',
      );
  	} else {
      $envs[]=array(
        'icon'=>'close',
        'label'=>'openSSL',
        'value'=>'不支持',
        'summary'=>'没有启用OpenSSL, 将无法访问云端接口, 系统无法正常运行.',
      );
  	}
    $paths=array('/cache','/config','/plugins');
    foreach($paths as $v){
    	if(onez('bs.install')->local_writeable(ONEZ_ROOT.$v)) {
        $envs[]=array(
          'icon'=>'success',
          'label'=>'读写判断: '.$v,
          'value'=>'可写',
          'summary'=>'',
        );
    	} else {
        $envs[]=array(
          'icon'=>'close',
          'label'=>'读写判断: '.$v,
          'value'=>'当前不可写',
          'summary'=>'本地目录无法写入, 系统无法正常运行.  ',
        );
    	}
    }
    $error=0;
    foreach($envs as $k=>$v){
      $v['status']=$v['icon'];
      if($v['icon']=='success'){
        $v['icon']='http://cdn.onez.cn/icons/2020/0707/2020070711380390980001.svg';
      }elseif($v['icon']=='fail'){
        $v['icon']='http://cdn.onez.cn/icons/2020/0707/2020070711384936770001.svg';
      }elseif($v['icon']=='close'){
        $v['icon']='http://cdn.onez.cn/icons/2020/0707/2020070711391355680001.svg';
        $error++;
      }
      $envs[$k]=$v;
    }
    $A['pagedata']['envs']=$envs;
    $A['pagedata']['error']=$error;
  }
  return;
}
?>
<template v-if="$pagedata && $pagedata.envs">
<van-cell v-for="item in pagedata.envs" :icon="item.icon" :title="item.label" :label="item.summary" :value="item.value" size="large" :class="'status-'+item.status" />
<div class="btns">
  <van-button type="primary" @click="prev">上一步</van-button>
  <van-button type="primary" @click="next" :disabled="pagedata.error>0">下一步</van-button>
</div>
</template>