<?php if (!empty($images)): ?>
    <div class="file-thumbnails">
        <?php foreach ($images as $file): ?>
            <div class="file-thumbnail">
                <a href="<?= $this->url->href('AttachmentController', 'show', ['project_id' => $project['id'], 'file_id' => $file['id']]) ?>" class="popover"><img src="<?= $this->url->href('AttachmentController', 'thumbnail', ['file_id' => $file['id'], 'project_id' => $project['id']]) ?>" title="<?= $this->text->e($file['name']) ?>" alt="<?= $this->text->e($file['name']) ?>"></a>
                <div class="file-thumbnail-content">
                    <div class="file-thumbnail-title">
                        <div class="dropdown">
                            <a href="#" class="dropdown-menu dropdown-menu-link-text"><?= $this->text->e($file['name']) ?> <i class="fa fa-caret-down"></i></a>
                            <ul>
                                <li>
                                    <i class="fa fa-download fa-fw"></i>
                                    <?= $this->url->link(t('Download'), 'AttachmentController', 'download', ['project_id' => $project['id'], 'file_id' => $file['id']]) ?>
                                </li>
                                <?php if ($this->user->hasProjectAccess('Project/ProjectFileController', 'remove', $project['id'])): ?>
                                    <li>
                                        <i class="fa fa-trash fa-fw"></i>
                                        <?= $this->url->link(t('Remove'), 'Project/ProjectFileController', 'remove', ['project_id' => $project['id'], 'file_id' => $file['id']], false, 'popover') ?>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </div>
                    <div class="file-thumbnail-description">
                    <span class="tooltip" title='<?= t('Uploaded: %s', $this->dt->datetime($file['date'])).'<br>'.t('Size: %s', $this->text->bytes($file['size'])) ?>'>
                        <i class="fa fa-info-circle"></i>
                    </span>
                        <?= t('Uploaded by %s', $file['user_name'] ?: $file['username']) ?>
                    </div>
                </div>
            </div>
        <?php endforeach ?>
    </div>
<?php endif ?>

