链接: https://t.zsxq.com/u7MFQz3

```
<?php
$filename = __DIR__ . '/tmp/' . $user['name'];
$data = $user['info'];

file_put_contents($filename, $data);
// ...一些处理
if (file_exists($filename)) {
	unlink($filename);
}
?>
```

## 法1
查看php源码，其实我们能发现，php读取、写入文件，都会调用php_stream_open_wrapper_ex来打开流（图1），而判断文件存在、重命名、删除文件等操作则无需打开文件流。
我们跟一跟php_stream_open_wrapper_ex就会发现，其实最后会使用tsrm_realpath函数来将filename给标准化成一个绝对路径。而文件删除等操作则不会，这就是二者的区别。
所以，如果我们传入的是文件名中包含一个不存在的路径，写入的时候因为会处理掉“../”等相对路径，所以不会出错；判断、删除的时候因为不会处理，所以就会出现“No such file or directory”的错误。
所以法1的答案是：

	name=xxxxx/../1.php

（这个方法是仅限Linux，因为Windows的文件操作API也会处理文件路径）


## 法2
name=1.php/.
这种方法可以阅读此文：链接：[php & apache2 &操作系统之间的一些黑魔法 | wonderkun's|blog](http://wonderkun.cc/index.html/?p=626)
原理我就不多说了，也是因为是否有php_stream_open_wrapper_ex导致的。


## 法3
Windows下方法：
```
info=webshell&name=1.php:test
info=webshell&name=1.ph<
```
依次发送上述两个请求，第一次请求:会截断文件名，导致创建一个新的空白文件1.php；第二次使用了一个通配符“<”，把内容写入了第一步创建的文件。
具体原理可以阅读这篇文章 链接：[pkav之当php懈垢windows通用上传缺陷 | wooyun-2014-071540](http://www.loner.fm/bugs/bug_detail.php?wybug_id=wooyun-2014-071540)

简单介绍了几种常用方法，都是以前说过的旧知识，也以此来告别旧的一年。祝大家新年里找到更多新知识~