"use strict";

import {
  specify
} from "../../../../../scripts/test/test-import.mjs";

var adapter = global.adapter;
var resolved = adapter.resolved;
var rejected = adapter.rejected;
var deferred = adapter.deferred;

exports.testFulfilled = function (value, test) {
    specify("already-fulfilled", function (done) {
        test(resolved(value), done);
    });

    specify("immediately-fulfilled", function (done) {
        var d = deferred();
        test(d.promise, done);
        d.resolve(value);
    });

    specify("eventually-fulfilled", function (done) {
        var d = deferred();
        test(d.promise, done);
        setTimeout(function () {
            d.resolve(value);
        }, 50);
    });
};

exports.testRejected = function (reason, test) {
    specify("already-rejected", function (done) {
        test(rejected(reason), done);
    });

    specify("immediately-rejected", function (done) {
        var d = deferred();
        test(d.promise, done);
        d.reject(reason);
    });

    specify("eventually-rejected", function (done) {
        var d = deferred();
        test(d.promise, done);
        setTimeout(function () {
            d.reject(reason);
        }, 50);
    });
};
