# Administración y aseguramiento de la información
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# PowerShell
¿Por qué un proceso ocupa tanto en memoria si el tamaño del .exe es menor?

-------------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

# Administración y aseguramiento de la información
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# PowerShell
¿Por qué un proceso ocupa tanto en memoria si el tamaño del .exe es menor?

-------------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

------------
------------

# Permisos en PowerShell
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Permisos-2
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-26.md
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md
* https://www.jesusninoc.com/03/30/eliminar-permisos-explicitos/

------------------
------------------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

## Discos
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-04.md

# Administración y aseguramiento de la información:
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.

## Instalar Windows Server
* https://www.microsoft.com/es-es/evalcenter/evaluate-windows-server-2016

## Repasar discos en Linux y Windows
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-17.md#comandos-para-trabajar-con-discos-en-linux
### Montar unidades en Windows
* http://www.vicente-navarro.com/blog/2010/10/28/unidades-montadas-y-enlaces-simbolicos-en-windows/

## RAID
* http://www.developandsys.es/aseguramiento-la-informacion/

### Crear un volumen distribuido y un RAID 5
- Un volumen distribuido combina áreas de espacio sin asignar de varios discos en un volumen lógico, lo que le permite usar de forma más eficaz todo el -espacio y todas las letras de unidad en un sistema de varios discos.
- Un RAID 5 es una matriz de tres o más discos duros que funcionan como una unidad lógica y que supera considerablemente a los soportes de datos individuales en términos de seguridad ante los fallos y velocidad de lectura.

--------------------
--------------------

# Permisos en Linux
## Permisos especiales en Linux
http://rm-rf.es/permisos-especiales-setuid-setgid-sticky-bit/

|Permiso|Explicación
|---|---
|- - - - - - - - -	= 0|Predeterminado, sin permisos especiales. No se requiere indicar.
|- - - - - - - - t	= 1|Bit de persistencia, sticky bit
|- - - - - s - - -	= 2|Bit sgid de grupo
|- - - - - s - - t	= 3|Bit sgid y sticky
|- - s - - - - - -	= 4|Bit suid
|- - s - - - - - t	= 5|Bit suid y sticky
|- - s - - s - - -	= 6|Bit suid y sgid
|- - s - - s - - t	= 7|Bit suid, sgid y sticky

- sticky: se utiliza para permitir que cualquiera pueda escribir y modificar sobre un archivo o directorio, pero que solo su propietario o root pueda eliminarlo. 
- suid: el bit SUID activo en un archivo significa que el que lo ejecute va a tener los mismos permisos que el que creó el archivo.
- sgid: el SGID es lo mismo que en el SUID, pero a nivel de grupo. Es decir, todo archivo que tenga activo el SGID, al ser ejecutado, tendrá los privilegios del grupo al que pertenece.

## Permisos en Linux (EJERCICOS AVANZADOS SOBRE PERMISOS)

### Permisos en Linux avanzados
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

### Asignar permisos mediante llamada a sistema chmod en C
* https://www.jesusninoc.com/2014/12/01/chmod-system-call-example/

---------
---------

# Ejercicios
## Logs
* https://www.jesusninoc.com/05/05/ejercicios-de-powershell-crear-una-funcion-que-valide-un-usuario-leyendo-el-nombre-y-el-password-en-hash-correcto-de-un-fichero-en-el-caso-de-que-el-login-sea-correcto-se-almacena-la-palabra-cor/

## Hash
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Realizar_funcion_hash_sobre_un_archivo

## Permisos
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Permisos

--------------
--------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

## Ejercicios propuestos con ficheros y directorios (Bash)

- Asignar permisos para una carpeta para cada usuario
- Asignar permisos para un fichero para cada usuario
- Asignar permisos para una carpeta para cada grupo
- Asignar permisos para un fichero para cada grupo

## Script con tareas sobre permisos (script.sh)

- Crear un directorio (directorio) y un fichero (fichero)
```Bash
    mkdir directorio
    touch fichero
```
- Asignar permisos a directorio y fichero iniciales
```Bash
    chmod 611 directorio -> chmod u=rw,go=x directorio
    chmod 611 fichero -> chmod u=rw,go=x fichero
```
- Asignar permisos a directorio y fichero de cambio
```Bash
    chmod 742 directorio
    chmod 742 fichero
```
- Cambiar el usuario dueño del fichero
```Bash
    chown root fichero
```
- Cambiar el grupo dueño del directorio
```Bash
    chgrp root directorio
```

------------
------------

# Administración y aseguramiento de la información:
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.
  
# Introducción a las copias de seguridad
## Incremental
* https://github.com/jesusninoc/PowerShell/blob/master/CopiasSeguridad/EjemplosCopiasSeguridad1.ps1
## Diferencial
* https://github.com/jesusninoc/PowerShell/blob/master/CopiasSeguridad/EjemplosCopiasSeguridad2.ps1
    
# PowerShell
## 10. Gestión del rendimiento en PowerShell para administradores de sistemas (nivel básico)
* https://www.jesusninoc.com/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/

## Ayuda para copias de seguridad
### Comprimir y descomprimir
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Comprimir
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Descomprimir
```PowerShell
Compress-Archive -LiteralPath C:\powershell\example.txt –CompressionLevel Optimal -DestinationPath C:\powershell\comprimido.zip
Expand-Archive -LiteralPath C:\powershell\comprimido.zip -DestinationPath C:\powershell\descomprimir
Compress-Archive -LiteralPath C:\powershell\example2.txt -Update -DestinationPath C:\powershell\comprimido.zip
```
### Cifrar
* https://www.jesusninoc.com/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

## Ejercicios sobre copias de seguridad
- Listar archivos por fecha
  * https://www.jesusninoc.com/12/01/ejercicios-de-powershell-listar-ficheros-cuya-fecha-de-ultima-escritura-de-ficheros-sea-de-mayor-que-menos-un-dia/

- Crear una función que realiza una copia de seguridad en el día de hoy
  * https://www.jesusninoc.com/12/14/ejercicios-de-powershell-crear-una-funcion-que-realiza-una-copia-de-seguridad-en-el-dia-de-hoy/

- Crear una función que realiza una copia de seguridad en el día de hoy de los archivos que se han modificado respecto del día de ayer
  * https://www.jesusninoc.com/12/15/ejercicios-de-powershell-crear-una-funcion-que-realiza-una-copia-de-seguridad-en-el-dia-de-hoy-de-los-archivos-que-se-han-modificado-respecto-del-dia-de-ayer/

- Copia de seguridad para cada día de la semana y ser capaz de recuperar
  ```PowerShell
  # Restaurar
  mkdir tuscosasperdidas
  cd .\tuscosasperdidas
  Get-ChildItem ../ | Copy-Item
  ```
- Crear una función que realiza una restauración de una copia de seguridad
  ```PowerShell
  function restaurar($fechahoy,$donderestaurar)
  {
      cd $donderestaurar
      Get-ChildItem ("..\"+$fechahoy) | Copy-Item
  }

  restaurar -fechahoy (Get-Date).ToString("yyyyMMdd") -donderestaurar restaurar
  ```
- Ser capaz de recuperar en función de lo que pide el usuario
  ```PowerShell
  # Restaurar en función de lo que pide el usuario
  $datosusar = Read-Host "Dime el nombre del arhcivo que tengo que recuperar"
  ls $datosusar* | Copy-Item
    ```
- Comprimir las copias de seguridad que se han realizado
  ```PowerShell
  # Comprimir el directorio con la fecha
  $fecha = (Get-Date).ToString("yyyyMMdd") + ".zip"
  Compress-Archive -LiteralPath .\20181119 –CompressionLevel Optimal -DestinationPath $fecha
  Compress-Archive -LiteralPath virus.exe -Update -DestinationPath $fecha
  ```

-------------------
-------------------

# Introducción a tareas de administración
https://www.jesusninoc.com/2017/09/01/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

## Agregar/Eliminar software
https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
## Actualización
https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
## Gestión de procesos
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/
## Programación de tareas
https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
## Usuarios
https://www.jesusninoc.com/2017/07/08/8-gestion-de-usuarios-en-powershell/
## Grupos
https://www.jesusninoc.com/2017/07/08/8-gestion-de-usuarios-en-powershell/
## Gestión del almacenamiento
* https://www.jesusninoc.com/2017/07/03/3-gestion-del-hardware-en-powershell/
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
## Gestión de la red
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
## Copias de seguridad
https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
## Reparación del sistema
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/
## Rendimiento del sistema
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

------------
------------

# Repaso
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-09-01.md (cómo vamos)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-01.md (proyectos)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-02.md (multimedia)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-03.md (virtualización)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-09.md#examen-1%C2%AA-recuperaci%C3%B3n (examen recuperación)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-09.md#introducci%C3%B3n-a-tareas-de-administraci%C3%B3n (tareas de administración)

---------------
---------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## ¿Qué es el número de sesiones de usuario?
* https://www.jesusninoc.com/01/12/introduccion-a-los-sistemas-operativos/#El_numero_de_sesiones

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## ¿Qué es el número de sesiones de usuario?
* https://www.jesusninoc.com/01/12/introduccion-a-los-sistemas-operativos/#El_numero_de_sesiones

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

-------------
-------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Ejercicios

### Crear una función que indica si existe o no un usuario
* https://www.jesusninoc.com/01/13/ejercicios-de-powershell-crear-una-funcion-que-indica-si-existe-o-no-un-usuario/

### Verificar que existe un usuario mediante el cmdlet Get-LocalUser
* https://www.jesusninoc.com/01/13/ejercicios-de-powershell-verificar-que-existe-un-usuario-mediante-el-cmdlet-get-localuser/
  
### Crear una función que dice si un usuario existe o no (mostrando si existe o no)
* https://www.jesusninoc.com/01/09/ejercicios-de-powershell-crear-una-funcion-que-dice-si-un-usuario-existe-o-no-mostrando-si-existe-o-no-con-read-host/

### Crear una función que dice si un usuario existe o no (mostrando si existe o no, con Read-Host y aceptar minúsculas)
* https://www.jesusninoc.com/01/10/ejercicios-de-powershell-crear-una-funcion-que-dice-si-un-usuario-existe-o-no-mostrando-si-existe-o-no-con-read-host-y-aceptar-minusculas/

### Crear una función que indica el SID de los usuarios
* https://www.jesusninoc.com/01/06/ejercicios-de-powershell-crear-una-funcion-que-indica-el-sid-de-los-usuarios/

### Iniciar un programa siendo otro usuario
* https://www.jesusninoc.com/01/11/ejercicios-de-powershell-iniciar-un-programa-siendo-otro-usuario/

### Crear una función que indique el nombre del usuario leyendo un SID
* https://www.jesusninoc.com/01/13/ejercicios-de-powershell-crear-una-funcion-que-indique-el-nombre-del-usuario-leyendo-un-sid/

### Crear una función que lea SID de un fichero e indique el nombre del usuario
* https://www.jesusninoc.com/01/13/ejercicios-de-powershell-crear-una-funcion-que-lea-sid-de-un-fichero-e-indique-el-nombre-del-usuario/

### Crear una función que lea los nombres de usuarios en un fichero e indique el SID de cada uno de ellos
* https://www.jesusninoc.com/01/13/ejercicios-de-powershell-crear-una-funcion-que-lea-los-nombres-de-usuarios-en-un-fichero-e-indique-el-sid-de-cada-uno-de-ellos/

-----------
-----------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## DESHABILITAR UAC DESDE POWERSHELL
* https://www.jesusninoc.com/01/15/deshabilitar-uac-desde-powershell/

## Ejercicios sobre usuarios en PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1

## Ejercicio para clase
### Buscar un usuario dentro del ordenador (o del Directorio Activo), el nombre del usuario se transmite por radio y llega a un sistema Linux (al que hay que conectarse por SSH)
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/#Ver_o_listar_usuarios
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1
* https://github.com/jesusninoc/ClasesSOM/blob/master/2019-02-14.md#ssh
* https://www.jesusninoc.com/09/24/ssh-desde-powershell/

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Ejercicios sobre usuarios en PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuariosFicheros.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjemplosCrearUsuariosGruposCarpetaCompartida.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjemplosCrearUsuariosGruposCarpetaCompartida2.ps1
* https://www.jesusninoc.com/2012/12/30/add-users-xml/
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
* https://www.jesusninoc.com/users/

## Crear usuarios leyendo de un fichero el user y password
```PowerShell
gc .\usuarios.txt | %{
    $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
    New-LocalUser $_.split(",")[0] -Password $pass
}
```

## Crear y eliminar usuarios
```PowerShell
"asir1,p@ssword1" > usuarios.txt
"asir2,p@ssword2" >> usuarios.txt
"asir3"  >> usuarios.txt

#####

gc .\usuarios.txt | %{
    $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
    New-LocalUser $_.split(",")[0] -Password $pass
}

######

gc .\fichero.txt | %{
    if($_.split(",").count -eq 1)
    {
        Remove-LocalUser $_.split(",")[0] -WhatIf
    }
    else
    {
        $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
        New-LocalUser $_.split(",")[0] -Password $pass -WhatIf
    }
}
```

## Analizar información sobre usuarios con PowerShell (1ª parte)
* https://www.youtube.com/watch?v=bZWs08BBjDc
## Analizar información sobre usuarios con PowerShell (2ª parte)
* https://www.youtube.com/watch?v=CCipPiIUVFY
## Crear, modificar y borrar usuarios con PowerShell
* https://www.youtube.com/watch?v=7sxxCnyRwcg
## Analizar información sobre grupos con PowerShell (1ª parte)
* https://www.youtube.com/watch?v=jaIQHD9Jlgc
## Analizar información sobre grupos con PowerShell (2ª parte)
* https://www.youtube.com/watch?v=qprY8B6uI50
## Crear, modificar, añadir usuario, quitar usuario y borrar grupo con PowerShell
* https://www.youtube.com/watch?v=eudt3H2o8z0

## Perfiles
* https://www.jesusninoc.com/07/22/listar-las-rutas-de-los-perfiles-de-los-usuarios/

## UTILIZAR JSON CON NOMBRES Y APELLIDOS ALEATORIOS
* https://www.jesusninoc.com/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

--------------
--------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Más ejercicios sobre usuarios en PowerShell

  - Ver el SID (Security Identifier) de un usuario en Windows con PowerShell
  - Verificar si existe un usuario en Windows 10 con PowerShell
  - Obtener los SID de las cuentas de usuario en Windows 10
  - Cmdlets relacionados con la gestión de cuentas locales en Windows 10
  - Creates a local user account
  - Creates a local security group
  - Gets local user accounts
  - Gets members from a local group
  - Gets the local security groups
  - Añadir usuarios a un grupo local en Windows 10 con PowerShell 5.1
  - Listar miembros de un grupo local en Windows 10 con PowerShell 5.1
  - Cambiar la contraseña a un usuario local en Windows 10 con PowerShell 5.1
  - Listar grupos locales en Windows 10 con PowerShell 5.1
  - Listar usuarios locales en Windows 10 con PowerShell 5.1
  - Eliminar un grupo local en Windows 10 con PowerShell 5.1
  - Crear un grupo local en Windows 10 con PowerShell 5.1
  - Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
  - Eliminar un usuario local en Windows 10 con PowerShell 5.1
  - Crear un usuario local en Windows 10 con PowerShell 5.1
  - Crear un usuario con contraseña leyendo los datos de un fichero
  - Cambiar contraseña a un usuario
  - Contar el número de grupos que hay en el sistema
  - Contar el número de usuarios que hay en el sistema
  - List local groups
  - List local users
  - Añadir un usuario a un grupo
  - Crear un grupo
  - Crear un usuario con contraseña
  - Usuario actual
  - Information about group accounts
  - Information about user accounts
  - Cmdlets relacionados con tareas básicas y de administración en el sistema operativo Windows
  - Reading username and password from file and do a login
  - Create users and groups, add a user to a group and share directory
  - Create users with passwords
  - Information about remote user

## CONVERTIR A JSON EL LISTADO DE USUARIOS QUE HAY EN EL SISTEMA EJECUTANDO UN CMDLET CON POWERSHELL
* https://www.jesusninoc.com/02/05/convertir-a-json-el-listado-de-usuarios-que-hay-en-el-sistema-ejecutando-un-cmdlet-con-powershell/

## UTILIZAR JSON CON NOMBRES Y APELLIDOS ALEATORIOS
* https://www.jesusninoc.com/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

## REGISTRAR Y MOSTRAR UN EVENTO EN POWERSHELL CUANDO SE CREA UN USUARIO
* https://www.jesusninoc.com/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

---------------------
---------------------

# Script para crear usuario automáticamente (y password generado aleatorio)

# Repaso a usuarios
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

# Preguntas examen
- Crear usuarios desde otro cmdlet
- Crear usuarios añadiendo algo
- Crear, exportar, crear en otra máquina
- Leer operaciones

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Gestión de usuarios en Windows (Server)

## Instalación de servicios de directorio

------------------
------------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Gestión de usuarios en Windows (Server)

## Instalación de servicios de directorio

--------------

# Administración de servicio de directorio

## Active Directory
* http://sec.cs.kent.ac.uk/x500book/
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-18.md
* http://www.developandsys.es/category/windows-server/active-directory/
* http://www.developandsys.es/gestion-objetos-active-directory/

### Instalación, configuración, objetos, relaciones de confianza, gpos, rodc, dc secundario (versión core)
* http://www.developandsys.es/category/windows-server/active-directory/

## OpenLDAP, Samba y Samba DC
* http://www.developandsys.es/?s=open+ldap
* http://www.developandsys.es/nfs-y-samba/

## Filtros LDAP

### UTILIZAR UN FILTRO LDAP PARA LOCALIZAR UN USUARIO
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
### UTILIZAR UN FILTRO LDAP PARA VERIFICAR LA HORA DEL ÚLTIMO INICIO DE SESIÓN DE LOS USUARIOS DEL ACTIVE DIRECTORY
* https://www.jesusninoc.com/07/05/utilizar-un-filtro-ldap-para-verificar-la-hora-del-ultimo-inicio-de-sesion-de-los-usuarios-del-active-directory/

## Crear usuarios leyendo desde un fichero (explicar fichero y bucle foreach)
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Ficheros
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Bucle_Foreach

## Cmdlets para Active Directory
* http://www.developandsys.es/gestion-objetos-active-directory/

## Crear en AD usuarios y OU leyendo de un fichero
```PowerShell
foreach($elemento in Get-Content .\crear.txt)
{
    $elemento
    New-ADUSer -Name $elemento -Sam $elemento -Path "OU=Localizacion,DC=Dominio,DC=Local" -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
    Start-Sleep -Seconds 5
}

foreach($elemento in Get-Content .\crear.txt)
{
    $elemento.split(",")[0]
}

foreach($elemento in Get-Content .\crear.txt)
{
    if($elemento.split(",")[0] -eq 1)
    {
        "crear ou " + $elemento.split(",")[1]
    }
    
    if($elemento.split(",")[0] -eq 2)
    {
        "crear user " + $elemento.split(",")[1]
        New-ADUSer -Name $elemento.split(",")[1] -Sam $elemento.split(",")[1] -Path "OU=Localizacion,DC=Dominio,DC=Local" -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
    }
}
```

--------------

# Passwords

## ENCONTRAR UN PASSWORD QUE CONTIENE LOS NÚMEROS DE LA PRIMERA FILA DEL TECLADO QWERTY GENERANDO COMBINACIONES ALEATORIAS
https://www.jesusninoc.com/01/20/encontrar-un-password-que-contiene-los-numeros-de-la-primera-fila-del-teclado-qwerty-generando-combinaciones-aleatorias/

## Contraseñas seguras con PowerShell
https://www.jesusninoc.com/contrasenas-seguras-con-powershell/

## Cracking Passwords Version 1.1
https://repo.zenk-security.com/Reversing%20.%20cracking/Cracking_Passwords_Guide.pdf

## Privilege Escalation without Automated Tools - InfoSec Resources
https://securitydocs.com/privilege-escalation-without-automated-tools-infosec-resources/38418/

--------------

# Random

## Ejercicio PowerShell: adivinar un número aleatorio que genera PowerShell

```PowerShell
#Generar un número aleatorio entre 1 y 100
Get-Random (1..100)
```
```PowerShell
#Pedir al usuario un número una vez e intentar adivinar el número aleatorio que se ha generado
$numeroadivinar=Get-Random (1..100)
$a=Read-Host "Intentar adivinar un número, introduzca número"
if($numeroadivinar -eq $a)
{
"Número adivinado"
}
```
```PowerShell
#Pedir al usuario números para intentar adivinar un número aleatorio entre 1 y 100
$numeroadivinar=Get-Random (1..100)
while($true)
{
$a=Read-Host "Intentar adivinar un número, introduzca número"
if($numeroadivinar -eq $a)
{
"Número adivinado"
#Si se adivina el número salir del bucle while con break
break
}
}
```
```PowerShell
#Pedir al usuario números para intentar adivinar un número aleatorio entre 1 y 100, ofrecer ayuda al usuario para adivinar el número
$numeroadivinar=Get-Random (1..100)
do
{
$a=Read-Host "Intentar adivinar un número, introduzca número"
switch($numeroadivinar)
{
{$_ -le $a -and $_ -ge 1}{Write-Host "No adivinado, el número es menor que $a" -ForegroundColor red}
{$_ -eq $a}{Write-Host "Número adivinado" -BackgroundColor Blue;break}
{$_ -ge $a -and $_ -le 100}{Write-Host "No adivinado, el número es mayor que $a" -ForegroundColor red}
}
#Si el número está adivinado acabar de preguntar al usuario
}while(!($numeroadivinar -eq $a))
```

## Más sobre random
### Generar letras aleatorias
https://www.jesusninoc.com/2017/10/11/generar-letras-aleatorias/

### Generate Random Text based on Length
https://www.commandlinefu.com/commands/view/24101/generate-random-text-based-on-length

### Ejercicios de PowerShell: mostrar y escribir una letra aleatoria por consola en el menor tiempo posible con PowerShell
https://www.jesusninoc.com/2017/09/02/ejercicios-de-powershell-mostrar-y-escribir-una-letra-aleatoria-por-consola-en-el-menor-tiempo-posible-con-powershell/

### Generar palabras aleatorias con letras aleatorias
https://www.jesusninoc.com/2017/01/07/generar-palabras-aleatorias-con-letras-aleatorias/

### Ejercicios de PowerShell: mostrar y escribir una palabra aleatoria por consola en el menor tiempo posible con PowerShell
https://www.jesusninoc.com/2017/09/05/ejercicios-de-powershell-mostrar-y-escribir-una-palabra-aleatoria-por-consola-en-el-menor-tiempo-posible-con-powershell/

### Ejercicios de PowerShell: crear el juego de piedra, papel o tijera
https://www.jesusninoc.com/2017/03/01/ejercicios-de-powershell-crear-el-juego-de-piedra-papel-o-tijera/

### Ejercicios de PowerShell: crear el juego de piedra, papel o tijera (script en una línea)
https://www.jesusninoc.com/2017/03/02/ejercicios-de-powershell-crear-el-juego-de-piedra-papel-o-tijera-script-en-una-linea/

### Tres en raya
```Java
private int[][] lineaGanadora = new int[][] { { 0, 1, 2 }, { 3, 4, 5 }, { 6, 7, 8 }, { 0, 3, 6 }, { 1, 4, 7 }, { 2, 5, 8 }, { 0, 4, 8 }, { 2, 4, 6 } };
```

--------------

# Ejercicio de password y random
## Crear usuarios con un password random e intentar adivinarlo con Cain y Abel
```PowerShell
(((1..9) | Get-Random -Count 4) -join "") + (((97..99) | Get-Random -Count 2 | % {[char]$_}) -join "") + (((65..67) | Get-Random -Count 2 | % {[char]$_}) -join "")
```
## Cain y Abel
* https://github.com/xchwarze/Cain

--------------

# Generar hash NTLM
* https://www.jesusninoc.com/01/26/creacion-de-hashes-de-contrasena-nt4/

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

------------

# Ejercicio de password y random
## Crear usuarios con un password random e intentar adivinarlo con Cain y Abel
```PowerShell
(((1..9) | Get-Random -Count 4) -join "") + (((97..99) | Get-Random -Count 2 | % {[char]$_}) -join "") + (((65..67) | Get-Random -Count 2 | % {[char]$_}) -join "")
```
## Cain y Abel
* https://github.com/xchwarze/Cain

--------------

# Generar hash NTLM
* https://www.jesusninoc.com/01/26/creacion-de-hashes-de-contrasena-nt4/

------------------
------------------

# Examen repaso de usuarios
- Crear usuarios leyendo de un fichero y después añadir la fecha al nombre
- Crear usuarios aleatorios en los que la primera letra sea la a y el resto aleatorio
- Adivinar un hash
- El jueves examen sobre qué hace el siguiente fragmento de código

-----------
-----------

# Gestión de usuarios en Linux

## Por pasos dentro de un script
```Bash
nano
```
## Ver si está creado un usuario
```Bash
grep usuario1 /etc/passwd | wc -l
```
## Crear una carpeta en /home 
```Bash
sudo mkdir nombreusuario
```
## Dar permisos a la carpeta del usuario 
```Bash
sudo chmod 764
```
## Crear el usuario y se le asigna el directorio donde va a trabajar y la shell 
```Bash
useradd -d /home/usuarionuevo -s /bin/bash Usuario
```
## Crear la contraseña a el usuario
```Bash
sudo passwd usuario
```
## Cambiar a la carpeta del nuevo usuario de propietario de usuario y grupo
```Bash
chgrp Usuario /home/usuarionuevo
chown Usuario /home/usuarionuevo
```
## Asignar los permisos heredados a la carpeta de el usuario para que tenga los permisos necesarios para trabajar 
```Bash
cd nombreusuario, umask 0011
```

---------------

# Repaso para realizar scripts en Linux

## Repaso scripting (extraer caracteres de cadenas)
```Bash
short=$(echo "${long}" | cut -c1-2)
short=$(echo "${long}" | head -c2)
short=$(echo "${long}" | awk '{print substr ($0, 0, 2)}')
short=$(echo "${long}" | sed 's/^\(..\).*/\1/')
```

## Partir una cadena por un cáracter determinado
```bash
echo 'hola:adios' | cut -d ':' -f1
```
## Mostrar campos específicos del fichero
```bash
echo "1 Juan Director Tecnología 3000€" > empleados.txt
echo "2 Pedro Becario Web 1000€" >> empleados.txt
awk '{print $2,$5;}' empleados.txt
```
## Sumar los valores de las columnas de un fichero
```bash
echo "1 100" > valor.txt
echo "2 300" >> valor.txt
cat valor.txt  | awk '{ sum += $2 } END { print sum }'
```
## Sumar los valores de las columnas de un fichero si se cumple una condición
```bash
echo "1 nivel1 100" > valor.txt
echo "2 nivel2 300" >> valor.txt
echo "3 nivel1 300" >> valor.txt
cat valor.txt  | awk ' $2 == "nivel1" { sum += $3 } END { print sum }'
```

## Ejemplos y trucos para el lenguaje de programación AWK
http://wiki.woop.es/AWK

--------------

# Utilizar xargs
Definir donde se van a definir los parámetros
```bash
ls | xargs -I ARG echo fichero ARG fichero
```
Definir donde se van a definir los parámetros
```bash
echo "después" | xargs echo "antes"
echo "antes" | xargs -i echo {} "después"
```
Mostrar los parámetros 1 y 2
```bash
cat fichero.txt | xargs -l bash -c 'echo this is first:$0 second:$1'
```
Asignar permisos leyendo desde un fichero el nombre y el permiso en octal
```bash
cat fichero.txt | xargs bash -c 'chmod $0 $1'
```

--------------
--------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Seguridad en Linux

## Linux Shell script to add a user with a password to the system
https://www.cyberciti.biz/tips/howto-write-shell-script-to-add-user.html

--------------

# Permisos en Windows

## Obtener los descriptores de seguridad de todos los ficheros de una unidad
https://www.jesusninoc.com/2016/09/10/obtener-los-descriptores-de-seguridad-de-todos-los-ficheros-de-una-unidad/

## Eliminar permisos explícitos
https://www.jesusninoc.com/2016/03/30/eliminar-permisos-explicitos/

## Añadir permiso NTFS a una carpeta
https://www.jesusninoc.com/2015/08/19/anadir-permiso-ntfs-a-una-carpeta/

## Crear un recurso compartido y asignar permisos al recurso
https://www.jesusninoc.com/2015/06/09/crear-un-recurso-compartido-y-asignar-permisos-al-recurso/

## Clonar permisos NTFS
https://www.jesusninoc.com/2015/01/23/clonar-permisos-ntfs/

## PENTESTER’S WINDOWS NTFS TRICKS COLLECTION
https://www.sec-consult.com/en/blog/2018/06/pentesters-windows-ntfs-tricks-collection/
  
--------------

# Examen

## Crear usuarios

### En PowerShell (en Windows Server leyendo los usarios de la configuración actual del Directorio Activo del Centro con Win32_UserAccount)
```PowerShell
Get-WmiObject Win32_UserAccount | % {
    Invoke-Command -ScriptBlock {New-LocalUser $_.name -WhatIf} -ComputerName .
}
```
### Leyendo los usuarios desde un fichero en Linux
```PowerShell
wsl cat /root/usuarios.txt | %{
    New-LocalUser $_ -whatif
}
```

### Crear usuarios en Linux, leyendo de un fichero
```Bash
cat usuarios.txt | xargs -I{} useradd {}
```

----------------
----------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Repaso ejercicios de usuarios en Linux
* https://www.jesusninoc.com/12/03/ejercicios-de-bash-ver-el-funcionamiento-de-awk/
* https://www.jesusninoc.com/11/16/ejercicios-de-bash-leer-contenido-de-un-fichero/
* https://www.jesusninoc.com/12/24/ejercicios-de-bash-sacar-solo-el-nombre-del-usuario-y-al-lado-cuantos-caracteres-tiene-ese-nombre/
* https://www.jesusninoc.com/02/06/ejercicios-de-bash-crear-usuarios-leyendo-desde-un-fichero/
* https://www.jesusninoc.com/01/04/ejercicios-de-bash-crear-usuarios-en-ubuntu-leyendo-de-un-fichero/

-------------
-------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Ejercicio de repaso sobre creación de usuarios
* https://www.jesusninoc.com/11/29/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-crear-un-usuario-desde-powershell/

----------------------

# Teoría de redes
* https://www.jesusninoc.com/04/26/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

------------------
------------------

# Tarea, hacer ping entre dos máquinas virtuales configurando la IP por comandos

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Teoría de redes
* https://www.jesusninoc.com/04/26/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

# Repaso básico de red

## Convertir a binario las direcciones MAC de los dispositivos de red
* https://www.jesusninoc.com/01/25/convertir-a-binario-las-direcciones-mac-de-los-dispositivos-de-red/

## Configurar IP en Windows
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Bash
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Conectar con Linux por SSH
https://www.jesusninoc.com/2017/09/26/ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/

## Guardar un fichero html preguntando al usuario qué título quiere
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html

start chrome .\web.html

## Crear y ejecutar un script de Bash realizando una conexión SSH desde PowerShell en Windows
https://www.jesusninoc.com/2017/09/22/crear-y-ejecutar-un-script-de-bash-realizando-una-conexion-ssh-desde-powershell-en-windows/

## Crear y ejecutar un script de Bash realizando una conexión SSH a un contenedor Docker desde PowerShell en Windows
https://www.jesusninoc.com/2017/10/21/crear-y-ejecutar-un-script-de-bash-realizando-una-conexion-ssh-a-un-contenedor-docker-desde-powershell-en-windows/

-----------------
-----------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Teoría red
* https://www.jesusninoc.com/04/26/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

# Conceptos de red
## TTL
Para evitar que una petición ping viaje de forma ilimitada por internet, en cada una de ellas se establece un Time To Live (TTL), que representa el número de saltos que ha dado el paquete de host en host por internet hasta alcanzar su destino. En cada salto, el TTL se decrementa en una unidad, y si en algún momento llega a 0 entonces el paquete se descarta y el host devuelve un error al origen.
## ¿Por que me cambia el valor TTL dependiendo de a quien haga ping?
https://foro.elhacker.net/redes/duda_iquestpor_que_me_cambia_el_valor_ttl_dependiendo_de_a_quien_haga_ping-t69071.0.html
## Cómo usar TRACERT para solucionar problemas de TCP/IP en Windows
https://support.microsoft.com/es-es/help/314868/how-to-use-tracert-to-troubleshoot-tcp-ip-problems-in-windows
## Ping continuado a servidores de tarificación por byte consumido
https://www.jesusninoc.com/2004/06/02/ping-continuado-a-servidores-de-tarificacion-por-byte-consumido/
## Modificar TTL para un solo registro en la zona DNS
http://nextadmin.blogspot.com.es/2014/10/modificar-ttl-para-un-solo-registro-en.html
## Cmdlets for TCP/IP Model Layers (Windows)
https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-11.md
## ifconfig vs ip (Linux) 
https://p5r.uk/blog/2010/ifconfig-ip-comparison.html
## Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
## Almacenar la información enviada entre un cliente y un servidor en una base de datos MySQL con PowerShell
https://www.jesusninoc.com/2017/01/15/almacenar-la-informacion-enviada-entre-un-cliente-y-un-servidor-en-una-base-de-datos-mysql-con-powershell/
## Modificar datagramas UDP con SoftPerfect Network Protocol Analyzer
https://www.jesusninoc.com/2016/03/19/modificar-datagramas-udp-con-softperfect-network-protocol-analyzer/
## Network
https://www.jesusninoc.com/network

---------
---------

# Ejercicio global

-------------
-------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Router
## Ideas para hacer con un router
- Ejecutar scripts
- Instalar aplicaciones
- Analizar información sobre llamadas (recibidas, realizadas, etc.)
- Enviar información desde el router (mail)
- Ver ficheros modificados
- Ver la IP asignada por el proveedor
- Ver la arquitectura del router
- Ejecutar scripts de Python
- Ejecutar código PHP
- Desensamblar aplicaciones

## busybox
For all the standard Unix utilities that the system didn't have.
https://busybox.net/downloads/BusyBox.html

## Binarios busybox
https://www.busybox.net/downloads/binaries/

## The Buildroot user manual
https://buildroot.org/downloads/manual/manual.html

## Busybox container and rootfs builder for minimal Docker base images with Python
https://github.com/odise/busybox-python

## Binario para mips
https://www.busybox.net/downloads/binaries/1.28.1-defconfig-multiarch/busybox-mips.log

## Router Mitrastar HGW-2501GN-R2: Shell e Ingeniería inversa (para crear firmwares modificadas, por ejemplo) (Actualizado)
http://blog.theliel.es/2015/10/router-mitrastar-hgw-2501gn-r2-shell-e-ingenieria-inversa-para-crear-firmwares-modificadas-por-ejemplo.html

## MitraStar DSL-100HN-T1/GPT-2541GNAC - Privilege Escalation
https://www.exploit-db.com/exploits/43061/

## Elevando privilegios en routers domésticos
http://jolama.es/temas/router-attack/index.php

## Enviar binario por SCP
### To copy files from the local system to a remote system:
```Bash
scp file... user@host.domain:path
```
### To copy files from a remote system to your local system:
```Bash
scp user@host.domain:path ... dest
```

----------
----------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Análisis de conexiones de red
https://www.jesusninoc.com/2017/05/01/analisis-de-conexiones-de-red/

--------------------

# Antivirus y virus
* https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
* https://www.jesusninoc.com/antivirus/

## Vulnerability
* https://www.jesusninoc.com/vulnerability/

## Una aproximación a los virus en PowerShell
* https://github.com/jesusninoc/Seguridad/blob/master/Una%20aproximaci%C3%B3n%20a%20los%20virus%20en%20PowerShell.md

## Virus examples
* https://www.symantec.com/security_response/landing/threats.jsp
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-012722-4614-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-031313-1110-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-112410-5327-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051114-5305-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052722-4205-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051817-0655-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052017-5535-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051210-1139-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052615-4530-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-012722-4614-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-111216-5350-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2009-061215-3706-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2009-063005-3448-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2010-100614-5201-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-031313-1110-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-112410-5327-99

## VirusTotal
* https://www.virustotal.com/#/home/upload

## Upload a suspected infected file (Retail)
* https://submit.symantec.com/websubmit/retail.cgi

# Ideas sobre comportamientos de troyanos
## Grabar audio
* http://www.jesusninoc.com/2015/06/27/grabar-audio-desde-la-linea-de-comandos/

## Keylogger
* https://www.jesusninoc.com/03/11/keylogger-sencillo-con-powershell/

# Enviar un cmdlet a un servidor y ejecutarlo
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()
```

## Cliente (manda un cmdlet al servidor)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

# Enviar un cmdlet a un servidor, ejecutarlo y mostrar el resultado de la ejecucción en el cliente
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente y devuelve el resultado de la ejecución al cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$respuesta=[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes($respuesta)
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

## Cliente (manda un cmdlet al servidor y muestra la respuesta que manda el servidor de lo que ha ejecutado)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Dispose()
```

# Repaso de PowerShell y red
* https://www.jesusninoc.com/02/13/iniciar-un-trabajo-en-segundo-plano-que-crea-un-formulario-desde-powershell-llamando-a-powershell-exe/
* https://www.jesusninoc.com/02/16/iniciar-varios-trabajos-en-segundo-plano-start-job-de-powershell-usando-una-variable-como-argumento-argumentlist/
* https://www.jesusninoc.com/12/23/crear-un-trabajo-start-job-en-powershell-y-recibirlo-receive-job/
* https://www.jesusninoc.com/02/16/iniciar-varios-formularios-como-trabajos-en-segundo-plano-start-job-de-powershell-usando-una-variable-como-argumento-argumentlist/
* https://www.jesusninoc.com/02/17/enviar-un-mensaje-udp-a-varios-ordenador-mediante-broadcast-desde-powershell-en-macos-hacerlo-de-forma-simple/
* https://www.jesusninoc.com/07/09/9-gestion-de-la-red-en-powershell/#Capa_de_transporte

------------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Análisis de conexiones de red
https://www.jesusninoc.com/2017/05/01/analisis-de-conexiones-de-red/

## Equivalencias entre comandos de red de Windows y cmdlets de PowerShell
https://www.jesusninoc.com/2016/02/04/equivalencias-entre-comandos-de-red-de-windows-y-cmdlets-de-powershell/

## Cmdlets for TCP/IP Model Layers
https://www.jesusninoc.com/2015/11/13/cmdlets-for-tcpip-model-layers/

## Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

# Ejercicio: enviar un mensaje entre todos los usuarios de clase
* https://www.jesusninoc.com/01/30/enviar-un-mensaje-udp-a-un-ordenador-desde-powershell/
* https://www.jesusninoc.com/08/26/enviar-un-mensaje-udp-a-un-ordenador-desde-powershell-en-macos-hacerlo-de-forma-simple/

-----------
-----------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Continuar con ejercicio enviar mensajes entre cliente y servidor
- Enviar algo entre Windows y Linux
- Enviar algo a todos los equipos

------------------
------------------

# Instalación silenciosa
* https://www.jesusninoc.com/02/17/realizar-la-instalacion-silenciosa-de-teamviewer-y-capturar-el-id-de-teamviewer-necesario-para-conectarse-al-equipo-desde-otro-equipo/
# Saber dónde me tengo que conectar
* https://www.jesusninoc.com/02/17/pasos-para-crear-un-servidor-y-un-cliente-en-powershell/
# Puerto abierto
* https://www.jesusninoc.com/02/20/ejercicios-de-powershell-comprobar-si-un-puerto-esta-abierto-o-no/
# Enviar credenciales
* https://www.jesusninoc.com/02/19/ejercicios-de-powershell-enviar-credenciales-entre-un-cliente-y-un-servidor-por-udp-y-ejecutar-una-aplicacion-en-el-servidor-con-dichos-credenciales/

---------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Ejemplos de redes básicos

```PowerShell
1..254|%{$_}
1..254|%{"192.168.1."+$_}
1..254|%{$ip="192.168.1."+$_;$ip}
1..254|%{$ip="192.168.1."+$_;ping $ip}
1..254|%{$ip="192.168.1."+$_;ping $ip;arp -a $ip}
1..254|%{$ip="192.168.1."+$_;$ip;arp -a | Select-String $ip}
```
```PowerShell
Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress
```
```PowerShell
[String]$a=(Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress)
$a.Substring(3,3)
```

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

------------------

# Instalación silenciosa
* https://www.jesusninoc.com/02/17/realizar-la-instalacion-silenciosa-de-teamviewer-y-capturar-el-id-de-teamviewer-necesario-para-conectarse-al-equipo-desde-otro-equipo/
# Saber dónde me tengo que conectar
* https://www.jesusninoc.com/02/17/pasos-para-crear-un-servidor-y-un-cliente-en-powershell/
# Puerto abierto
* https://www.jesusninoc.com/02/20/ejercicios-de-powershell-comprobar-si-un-puerto-esta-abierto-o-no/
# Enviar credenciales
* https://www.jesusninoc.com/02/19/ejercicios-de-powershell-enviar-credenciales-entre-un-cliente-y-un-servidor-por-udp-y-ejecutar-una-aplicacion-en-el-servidor-con-dichos-credenciales/

---------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Ejemplos de redes básicos

```PowerShell
1..254|%{$_}
1..254|%{"192.168.1."+$_}
1..254|%{$ip="192.168.1."+$_;$ip}
1..254|%{$ip="192.168.1."+$_;ping $ip}
1..254|%{$ip="192.168.1."+$_;ping $ip;arp -a $ip}
1..254|%{$ip="192.168.1."+$_;$ip;arp -a | Select-String $ip}
```
```PowerShell
Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress
```
```PowerShell
[String]$a=(Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress)
$a.Substring(3,3)
```

## Ejercicio sobre la red

Analizar la siguiente información utilizando la red:
- Aplicaciones instaladas
- Ver si hay IP repetida
- Comprobar si hay fallo en red por culpa de IP repetida
- Comprobar que los equipos se han creado correctamente con el nombre de dominio correcto
- Ver rango de IP en Wifi
- Ver rango de IP en VDI
- ¿Qué usuario ha iniciado sesión?
- Realizar un inventario de la red (PDQ Inventory Tracks It All https://www.pdq.com/pdq-inventory/)

```PowerShell
Invoke-Command -ScriptBlock{([System.Security.Principal.WindowsIdentity]::GetCurrent()).name} -ComputerName 192.168.1.56 -Credential (Get-Credential)
```
```PowerShell
$p = Get-WmiObject win32_process -filter "name='explorer.exe'" -ComputerName 192.168.1.56 -Credential (Get-Credential)
$p.getowner().user
```

--------------------

# Configurar un túnel utilizando un servidor SSH
https://www.jesusninoc.com/2016/02/08/configurar-un-tunel-utilizando-un-servidor-ssh/

--------------------

# Post Exploitation
## Post Exploitation Command List Wiki
https://github.com/mubix/post-exploitation/wiki

## Linux Post Exploitation Command List
https://github.com/mubix/post-exploitation/wiki/Linux-Post-Exploitation-Command-List

## Post Exploitation without Automated Tools (pdf) - InfoSec Resources
This book acts as an introduction to those who know how to use Metasploit and do not know what happens behind the screens.
http://resources.infosecinstitute.com/wp-content/uploads/Post-Exploitation-without-Automated-Tools1.pdf

--------------------

# Ejecutar PHP
## Ejecutar código PHP desde PowerShell
https://www.jesusninoc.com/2017/03/01/ejecutar-codigo-php-desde-powershell/
## Ejecutar un cmdlet de PowerShell desde PHP
https://www.jesusninoc.com/2018/01/06/ejecutar-un-cmdlet-de-powershell-desde-php/
## Ejecutar en PHP un cmdlet de PowerShell en Base64
https://www.jesusninoc.com/2018/02/21/ejecutar-en-php-un-cmdlet-de-powershell-en-base64/

--------
--------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Asuntos pendientes
- Enviar credenciales
  - https://www.jesusninoc.com/02/19/ejercicios-de-powershell-enviar-credenciales-entre-un-cliente-y-un-servidor-por-udp-y-ejecutar-una-aplicacion-en-el-servidor-con-dichos-credenciales/
- Resolver ejercicio servidor-cliente, realizar una petición desde el cliente y que el servidor devuelva una página web para cada usuario cliente
  - Enviar un mensaje UDP entre dos equipos desde PowerShell https://www.jesusninoc.com/01/30/enviar-un-mensaje-udp-entre-dos-equipos-desde-powershell/
  - Realizar una comunicación entre dos ordenadores por UDP desde PowerShell https://www.jesusninoc.com/01/30/realizar-una-comunicacion-entre-dos-ordenadores-por-udp-desde-powershell/
  - https://www.jesusninoc.com/02/03/enviar-el-nombre-un-usuario-al-servidor-por-udp/
  - https://www.jesusninoc.com/02/03/enviar-el-nombre-un-usuario-al-servidor-por-udp-y-que-el-servidor-abra-una-pagina-web-con-el-nombre-recibido/
  - https://www.jesusninoc.com/02/03/enviar-un-mensaje-a-un-servidor-con-udp-y-que-el-servidor-responda-con-hola-cliente-independientemente-del-nombre-del-usuario/
  - https://www.jesusninoc.com/02/03/enviar-un-nombre-usuario-a-un-servidor-con-udp-y-si-es-correcto-el-servidor-responde-al-cliente-con-el-contenido-de-una-pagina-web-que-el-cliente-abre-con-google-chrome/
- Tarea programada que escucha
  - https://www.jesusninoc.com/03/21/crear-una-tarea-programada-en-la-que-un-servidor-escucha-los-mensajes-que-se-convierten-en-audio-y-que-son-mandados-por-parte-de-los-cliente-con-powershell-la-comunicacion-entre-el-servidor-y-el-clie/
- Ejemplos de preguntas https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-13.md
- Ejemplos de situaciones https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-12.md

--------------------

# Acceso remoto

Utilities like Telnet and remote control programs like Symantec's PC Anywhere let you execute programs on remote systems, but they can be a pain to set up and require that you install client software on the remote systems that you wish to access. PsExec is a light-weight telnet-replacement that lets you execute processes on other systems, complete with full interactivity for console applications, without having to manually install client software. PsExec's most powerful uses include launching interactive command-prompts on remote systems and remote-enabling tools like IpConfig that otherwise do not have the ability to show information about remote systems.

https://docs.microsoft.com/en-us/sysinternals/downloads/psexec

## Ejemplo psexec
```PowerShell
psexec -u jesusninoc\administrador \\2017lti1-19 -i -d cmd /c notepad
psexec -u jesusninoc\administrador \\192.168.104.122 -i -d cmd /c powershell -encodedcommand RwBlAHQALQBEAGEAdABlAA=="
psExec.exe -i \\192.168.1.56 powershell f:\script.ps1 #script.ps1 tiene que existir en el equipo remoto
```

## Powershell + psExec
http://bertdotself.com/powershell-psexec/

## Acceso remoto desde Powershell
```PowerShell
Invoke-Command -Credential administrador -ComputerName 192.168.1.56 -ScriptBlock{hostname} 
```

## Netcat Cheat Sheet
https://www.sans.org/security-resources/sec560/netcat_cheat_sheet_v1.pdf

## Starts an interactive session with a remote computer (PowerShell)
```PowerShell
Enter-PSSession -ComputerName 2017lti1-19
```

## Crear una tarea programada en un equipo remoto
```PowerShell
1..254 | %{Invoke-Command -ComputerName ('192.168.1.'+$_) {Register-ScheduledTask Task01 -Action (New-ScheduledTaskAction -Execute "Cmd") -Principal (New-ScheduledTaskPrincipal -GroupId "BUILTIN\administradores" -RunLevel Highest) -Settings (New-ScheduledTaskSettingsSet -RestartCount 5 -RestartInterval 60)}}
```

## Copssh - OpenSSH for Windows
* https://itefix.net/copssh

--------------------

## Introducción a la automatización en PowerShell
https://www.jesusninoc.com/2017/03/06/introduccion-a-la-automatizacion-en-powershell/

## Automation
https://www.jesusninoc.com/automation/

## Mover el ratón a varias posiciones
https://www.jesusninoc.com/2015/01/18/mover-el-raton-a-varias-posiciones/

## Mover Notepad de una posición de la pantalla a otra y escribir un texto dentro del proceso
https://www.jesusninoc.com/2016/03/23/mover-notepad-de-una-posicion-de-la-pantalla-a-otra-y-escribir-un-texto-dentro-del-proceso/

## Mover un proceso en diagonal de una posición de la pantalla a otra y que siempre permanezca en primer plano
https://www.jesusninoc.com/2016/04/11/mover-un-proceso-en-diagonal-de-una-posicion-de-la-pantalla-a-otra-y-que-siempre-permanezca-en-primer-plano/

## Mover un proceso en horizontal de una posición de la pantalla a otra y que siempre permanezca en primer plano
https://www.jesusninoc.com/2016/02/28/mover-un-proceso-en-horizontal-de-una-posicion-de-la-pantalla-a-otra-y-que-siempre-permanezca-en-primer-plano/

## Activar y mover un proceso de una posición de la pantalla a otra
https://www.jesusninoc.com/2016/02/20/activar-y-mover-un-proceso-de-una-posicion-de-la-pantalla-a-otra/

## Mover un proceso de una posición de la pantalla a otra
https://www.jesusninoc.com/2016/02/03/mover-un-proceso-de-una-posicion-de-la-pantalla-a-otra/

--------------------

# Servidor de correo

## SMTP
https://www.jesusninoc.com/2015/01/12/instalar-hmailserver-imap-smtp-y-pop3/

--------------------

# Ideas sobre los comportamientos de los troyanos
## Grabar audio
* http://www.jesusninoc.com/2015/06/27/grabar-audio-desde-la-linea-de-comandos/

## Keylogger
* https://www.jesusninoc.com/03/11/keylogger-sencillo-con-powershell/

# Enviar un cmdlet a un servidor y ejecutarlo
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()
```

## Cliente (manda un cmdlet al servidor)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

# Enviar un cmdlet a un servidor, ejecutarlo y mostrar el resultado de la ejecución en el cliente
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente y devuelve el resultado de la ejecución al cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$respuesta=[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes($respuesta)
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

## Cliente (manda un cmdlet al servidor y muestra la respuesta que manda el servidor de lo que ha ejecutado)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Dispose()
```

--------------

# Simular ransomware
## Algoritmo de cifrado sencillo
https://www.jesusninoc.com/2016/03/06/algoritmo-de-cifrado-sencillo-2/
## Algoritmo de descifrado sencillo
https://www.jesusninoc.com/2016/03/07/algoritmo-de-descifrado-sencillo-2/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto
https://www.jesusninoc.com/2017/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto (enviar la clave utilizada en el algoritmo mediante una petición web a un servidor)
https://www.jesusninoc.com/2017/05/16/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto-enviar-la-clave-utilizada-en-el-algoritmo-mediante-una-peticion-web-a-un-servidor/
## Descifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto
https://www.jesusninoc.com/2017/05/18/descifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
## Cifrar utilizando una clave secreta
https://www.jesusninoc.com/2015/08/18/cifrar-utilizando-una-clave-secreta/
## Descifrar utilizando una clave secreta
https://www.jesusninoc.com/2015/08/20/descifrar-utilizando-una-clave-secreta/
## Aproximación al cifrado y descifrado en PowerShell
https://www.jesusninoc.com/2017/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

# Simular ransomware y subir por SSH
## Subir un fichero por SSH a un servidor Linux desde PowerShell en Windows
https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto y subirlo por SSH a un servidor Linux
https://www.jesusninoc.com/2017/11/13/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto-y-subirlo-por-ssh-a-un-servidor-linux/
## Utilizar tail -f en Windows Server 2003 con Copssh
https://www.jesusninoc.com/2009/05/21/utilizar-tail-f-en-windows-server-2003-con-copssh/

# SSH
## Configurar un túnel utilizando un servidor SSH
https://www.jesusninoc.com/2016/02/08/configurar-un-tunel-utilizando-un-servidor-ssh/
## Configurar Firefox para utilizar un túnel SSH como un proxy SOCKS
https://www.jesusninoc.com/2016/02/09/configurar-firefox-para-utilizar-un-tunel-ssh-como-un-proxy-socks/
## Realizar conexión con WinSCP utilizando un túnel SSH
https://www.jesusninoc.com/2016/02/12/realizar-conexion-con-winscp-utilizando-un-tunel-ssh/
## Conexión entre Bash Bunny y el equipo con PuTTY a través de la conexión de red IBM USB Remote NDIS Network Device
https://www.jesusninoc.com/2017/04/14/conexion-entre-bash-bunny-y-el-equipo-con-putty-a-traves-de-la-conexion-de-red-ibm-usb-remote-ndis-network-device/

---------------
---------------

# Administración de software de base

 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Sort IPv4 Addresses Correctly
http://community.idera.com/powershell/powertips/b/tips/posts/sort-ipv4-addresses-correctly

# Recorrer rango direcciones IP
* https://www.jesusninoc.com/2017/07/14/recorrer-un-rango-de-direcciones-ip/
* https://www.jesusninoc.com/2017/07/06/recorrer-direcciones-ip/
* https://github.com/jesusninoc/PowerShell/blob/master/Red/EjemplosRed.ps1

# Puertos abiertos
## Si está abierto parece que no hay resultado
```PowerShell
$tcpobject = New-Object System.Net.Sockets.TcpClient 
$connect = $tcpobject.BeginConnect("127.0.0.1",25,$null,$null)
    
# wait for the connection no longer than $timeoutMilliseconds 
$wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false)
$tcpobject.EndConnect($connect) 
```
## Si no está abierto hay resultado
```PowerShell
$tcpobject = New-Object System.Net.Sockets.TcpClient 
$connect = $tcpobject.BeginConnect("127.0.0.1",215,$null,$null)
    
# wait for the connection no longer than $timeoutMilliseconds 
$wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false)
$tcpobject.EndConnect($connect) 
```
## Scanning Ports
* https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/scanning-ports
```PowerShell
function Get-PortInfo
{
    param
    (
        [Parameter(Mandatory)]
        [Int]
        $Port,
    
        [Parameter(Mandatory)]
        [Int]
        $TimeoutMilliseconds,
        
        [String]
        $ComputerName = $env:COMPUTERNAME
    )
  
    # try and establish a connection to port async
    $tcpobject = New-Object System.Net.Sockets.TcpClient 
    $connect = $tcpobject.BeginConnect($computername,$port,$null,$null)
    
    # wait for the connection no longer than $timeoutMilliseconds 
    $wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false) 
    
    # return rich information
    $result = @{
        ComputerName = $ComputerName
    }
    
    if(!$wait) { 
        # timeout
        $tcpobject.Close() 
        $result.Online = $false
        $result.Error = 'Timeout'
    } else { 
        try { 
            # try and complete the connection
            $null = $tcpobject.EndConnect($connect)
            $result.Online = $true
        }
        catch { 
            $result.Online = $false
        } 
        $tcpobject.Close() 
    } 
    $tcpobject.Dispose()
    
    [PSCustomObject]$result
} 
```
--------------

# Ejercicios realizados
- https://www.jesusninoc.com/02/04/ejercicios-de-powershell-sacar-los-nombre-de-los-procesos-de-cada-conexion-de-red-tcp/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-sacar-el-nombre-del-proceso-que-abre-cada-conexion-de-red-tcp-junto-con-la-direccion-ip-remota/
- https://www.jesusninoc.com/02/05/sacar-el-nombre-del-proceso-que-abre-cada-conexion-de-red-udp-junto-con-la-direccion-ip-local/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-ver-los-puertos-locales-que-estan-abiertos-en-nuestro-equipo-tcp-y-udp/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-comprobar-los-puertos-tcp-abiertos-de-un-rango-a-otro-mediante-un-try-y-un-catch-e-indicar-si-esta-abierto-o-no-el-puerto-si-hace-lo-que-queremos/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-listar-las-direcciones-ip-remotas-que-utilizan-el-protocolo-tcp-e-indicar-la-resolucion-dns/

# Ejercicios propuestos
- Analizar la red del Centro, ¿qué detectas?, ¿DNS?
- Se puede comunicar dentro del la red por UDP, enviar el movimiento del ratón entre dos equipos.

------------------
------------------

# Tunel SSH
# Acceso remoto PowerShell
- Asegúrese de que el equipo remoto y el equipo local estén en la misma red y que la conexión entre ellos no esté bloqueada por ningún firewall o enrutador.
# Almacenar credenciales
* https://www.jesusninoc.com/03/01/ejercicios-de-powershell-almacenar-varios-credenciales-en-un-fichero-xml-y-utilizarlos-para-arrancar-un-proceso/

--------------
--------------

# Simular ransomware
## Algoritmo de cifrado sencillo
https://www.jesusninoc.com/2016/03/06/algoritmo-de-cifrado-sencillo-2/
## Algoritmo de descifrado sencillo
https://www.jesusninoc.com/2016/03/07/algoritmo-de-descifrado-sencillo-2/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto
https://www.jesusninoc.com/2017/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto (enviar la clave utilizada en el algoritmo mediante una petición web a un servidor)
https://www.jesusninoc.com/2017/05/16/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto-enviar-la-clave-utilizada-en-el-algoritmo-mediante-una-peticion-web-a-un-servidor/
## Descifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto
https://www.jesusninoc.com/2017/05/18/descifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
## Cifrar utilizando una clave secreta
https://www.jesusninoc.com/2015/08/18/cifrar-utilizando-una-clave-secreta/
## Descifrar utilizando una clave secreta
https://www.jesusninoc.com/2015/08/20/descifrar-utilizando-una-clave-secreta/
## Aproximación al cifrado y descifrado en PowerShell
https://www.jesusninoc.com/2017/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

# Simular ransomware y subir por SSH
## Subir un fichero por SSH a un servidor Linux desde PowerShell en Windows
https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto y subirlo por SSH a un servidor Linux
https://www.jesusninoc.com/2017/11/13/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto-y-subirlo-por-ssh-a-un-servidor-linux/
## Utilizar tail -f en Windows Server 2003 con Copssh
https://www.jesusninoc.com/2009/05/21/utilizar-tail-f-en-windows-server-2003-con-copssh/

# Administración de software de base

 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Repaso de ficheros de configuración en Linux

## Network
http://www.yolinux.com/TUTORIALS/LinuxTutorialNetworking.html

## Netplan configuration examples
https://netplan.io/examples

### To instead set a static IP address, use the addresses key, which takes a list of (IPv4 or IPv6), addresses along with the subnet prefix length (e.g. /24). Gateway and DNS information can be provided as well:

```Bash
network:
  version: 2
  renderer: networkd
  ethernets:
    enp3s0:
      addresses:
        - 10.10.10.2/24
      gateway4: 10.10.10.1
      nameservers:
          search: [mydomain, otherdomain]
          addresses: [10.10.10.1, 1.1.1.1]
```

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Firewall
## Enable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/16/enable-the-microsoft-windows-firewall/
## Disable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/15/disable-the-microsoft-windows-firewall/
## Ejemplos de reglas de firewall
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-deshabilitadas/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-en-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-no-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-de-salida-del-firewall-desde-powershell-de-windows-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-de-entrada-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
## Log del Firewall
```Cmd
%systemroot%\system32\LogFiles\Firewall\pfirewall.log
```

--------------
--------------

# Ejercicios de red
## Crear una función en la que le pasas una conexión de red y te dice qué proceso ejecuta (le puedes pasar una IP o un puerto)
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-crear-una-funcion-en-la-que-se-pasa-una-conexion-de-red-y-te-dice-proceso-ejecuta-se-puede-pasar-una-ip-o-un-puerto/
## Crear una función que agrupa los nombre obtenidos mediante una resolución DNS (sin mostrar errores)
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-crear-una-funcion-que-agrupa-los-nombre-obtenidos-mediante-una-resolucion-dns-sin-mostrar-errores/
## Mostrar los hilos que se están ejecutando y deducir si se pueden relacionar con sockets abiertos
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-mostrar-los-hilos-que-se-estan-ejecutando-y-deducir-si-se-pueden-relacionar-con-sockets-abiertos-tcp-o-udp/

# Ejercicios avanzados de red
## Simular el uso de certificado
* https://www.jesusninoc.com/01/23/enviar-un-mensajes-cifrado-con-cryptographic-message-syntax-cms-entre-un-cliente-y-un-servidor-mediante-udp-desde-powershell/
## Uso de certificado en conexión cliente servidor
* https://www.jesusninoc.com/03/11/cifrar-el-trafico-entre-un-cliente-y-un-servidor-mediante-el-protocolo-tcp-ip-con-un-certificado-x509-autofirmado-en-powershell/

--------------

# Scripting

## Repaso básico de Linux para la parte de scripting
* http://www.freeos.com/guides/lsst/ch02.html
* http://www.freeos.com/guides/lsst/ch02sec20.html

## Repaso básico de Windows para la parte de scripting
### Snippets in Windows PowerShell
https://www.jesusninoc.com/2014/03/19/snippets-in-windows-powershell/

------------------
------------------

# Administración de recursos compartidos:
- Instalación y configuración de servicios
- Administración del acceso a recursos. SMB/CIFS. SAMBA. NFS.
- Grupos de trabajo.
- Permisos de red. Permisos locales. Herencia. Permisos efectivos.

--------------

# Repaso discos

## LVM (Logical Volume Manager)

Un LVM se descompone en tres partes:
- Volúmenes físicos (PV): Son las particiones del disco duro con sistema de archivos LVM. (raid's)
- Grupos de volúmenes (VG): es la parte superior de la LVM. Es la "caja" en la que tenemos nuestros volúmenes lógicos (LV) y nuestros volúmenes físicos (PV). Se puede ver como una unidad administrativa en la que se engloban nuestros recursos. Hay que hacer notar que mientras un PV no se añada al VG, no podemos comenzar a usarlo.
- Volúmenes lógicos (LV): es el equivalente a una partición en un sistema tradicional. El LV es visible como un dispositivo estándar de bloques, por lo que puede contener un sistema de archivos (por ejemplo /home)

```Dibujo
               sda1        sdb    (PV:s, particiones o discos completos)
                     /
                    /
               linuxvg            (VG)
             /    |    
           /      |      
       ubuntu   arch     home     (LV:s)
         |        |       |
       ext4      ext4    xfs      (sistemas de archivos)
```

## Operaciones sobre discos en Windows:
- Crear particiones
- Borrar particiones
- Recuperar particiones eliminadas
- Cifrar
- Comprimir
- Convertir entre sistemas de archivos

## Discos dinámicos
http://windows.microsoft.com/es-es/windows-vista/what-are-basic-and-dynamic-disks

--------------

# Arranque
- BIOS
- POST
- Arranque (dual, BCD, BCDEdit, etc.)
- Arranque de procesos

## Arranque en Linux
### Proceso de arranque en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Arranque en Windows
### Proteger el proceso de arranque de Windows 10
https://docs.microsoft.com/es-es/windows/security/hardware-protection/secure-the-windows-10-boot-process
### Procesos de credenciales de autenticación de Windows
https://docs.microsoft.com/es-es/windows-server/security/windows-authentication/credentials-processes-in-windows-authentication

--------------

# Permisos en PowerShell

## 4. Gestión de archivos en PowerShell para administradores de sistemas
https://www.jesusninoc.com/2016/11/10/4-gestion-de-archivos-en-powershell-para-administradores-de-sistemas/

## Obtener los descriptores de seguridad de todos los ficheros de una unidad
https://www.jesusninoc.com/2016/09/10/obtener-los-descriptores-de-seguridad-de-todos-los-ficheros-de-una-unidad/

## Enumeración FileSystemRights: Define los derechos de acceso que se utilizará al crear reglas de acceso y auditoría
https://msdn.microsoft.com/es-es/library/system.security.accesscontrol.filesystemrights(v=vs.110).aspx

## Clonar permisos NTFS
https://www.jesusninoc.com/2015/01/23/clonar-permisos-ntfs/

## Eliminar permisos explícitos
https://www.jesusninoc.com/2016/03/30/eliminar-permisos-explicitos/

## Añadir permiso NTFS a una carpeta
https://www.jesusninoc.com/2015/08/19/anadir-permiso-ntfs-a-una-carpeta/

## Weekend Scripter: Use PowerShell to Get, Add, and Remove NTFS Permissions
https://blogs.technet.microsoft.com/heyscriptingguy/2014/11/22/weekend-scripter-use-powershell-to-get-add-and-remove-ntfs-permissions/

## Ejemplo de asignación de permisos
```PowerShell
New-Item -type directory -path C:\MyFolder
$Acl = Get-Acl "C:\MyFolder"
$Ar = New-Object  system.security.accesscontrol.filesystemaccessrule("username","FullControl","Allow")
$Acl.SetAccessRule($Ar)
Set-Acl "C:\MyFolder" $Acl
```

--------------

# Permisos en Linux
Why does the default umask value contains 4 digits?
The first digit in 0022 defines the special permission value. In case you want to set any special permission to every file/directory to be created then you can define the value accordingly.

For understanding all the special permission and their value follow the below link
- Understanding Special Permission SGID in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-sgid.html
- Understanding Special Permission SUID in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-suid.html
- Understanding Special Permission Sticky Bit in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-sticky.html

## Comando para ver permisos de un fichero
```Bash
stat -f "%Sp -> owner=%SHp group=%SMp other=%SLp" fichero.txt  
```

## Ejemplo sobre asignación de permisos al crear carpetas
### Creates a new directory called mydir whose parent is the current directory.
```Bash
mkdir examples
mkdir mydir
```
Create the mydir directory, and set its permissions such that all users may read, write, and execute the contents.
```Bash
mkdir -m a=rwx mydir
```
Creates the directory /home/chope/a/b/c. If the parent directory /home/chope/a/b does not already exist, mkdir will create that directory first.
```Bash
mkdir -p /home/chope/a/b/c
```

## Permisos avanzados en C
http://www.jesusninoc.com/2015/01/19/programacion-de-permisos/

--------------

# Integridad
## PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosProcesosAvanzado.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Ficheros/EjemploIntegridad.ps1
## Linux
* https://www.jesusninoc.com/2016/01/02/for-loop-examples/
* https://www.jesusninoc.com/2015/07/14/sentencia-condicional-if-else-2/
* https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

--------------

# Copias de seguridad

## En Windows
### 10. Gestión del rendimiento en PowerShell para administradores de sistemas
https://www.jesusninoc.com/2016/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/
### Copias de seguridad (explicación básica del concepto de copia de seguridad incremental y diferencial)
https://github.com/jesusninoc/PowerShell/tree/master/CopiasSeguridad

## En Linux
https://www.ochobitshacenunbyte.com/2017/07/10/copias-de-seguridad-con-dump-y-restore-en-linux/

--------------

# USB

## Memorias USB: riesgos, protección y acceso a los datos
https://www.securityartwork.es/2018/01/24/memoricas-usb-riesgos-proteccion-acceso-los-datos/

## Detectar si hay un dispositivo USB conectado y copiar el contenido en una carpeta temporal
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Detectar%20si%20hay%20un%20dispositivo%20USB%20conectado%20y%20copiar%20el%20contenido%20en%20una%20carpeta%20temporal.ps1


--------------

# ISO, WIM

## Crear ISO
https://gallery.technet.microsoft.com/scriptcenter/New-ISOFile-function-a8deeffd

## Crear una imagen WIM de un disco duro y expandirla después en un disco duro
https://www.jesusninoc.com/2015/08/02/crear-una-imagen-wim-de-un-disco-duro-y-expandirla-despues-en-un-disco-duro/

## Crear un WIM de un USB (copia de seguridad) copiarlo a una carpeta compartida (controlar los permisos de red y NTFS), tener en cuenta:
- Crear WIM
- Ver ficheros USB
- Crear carpeta compartida
- Copia de seguridad
- Realizar firma del fichero obtenido

--------------

# Posibles preguntas para el examen

- Pedir un proceso
  - Comprobar la ruta y el hash (hay un listado de hash para los programas que hay en el sistema)
  - Comprobar si hay algún drivers cambiado (hay un listado de hash para los drivers)
- Instalar programas en Ubuntu leyendo desde un fichero
- Ver versión de programas instalados, los antiguos hay que actualizarlos
- Actualización
- Control de acceso a programas
- Controladores, drivers
- Instalar y actualizar
- Qué proceso realizas para crear un usuario
- Crear y añadir usuarios
- El usuario con más privilegios
- Habilitar usuarios
- Seguridad en contraseñas
- Permisos, herencia, permisos efectivos
- Cambiar dueño usuario
- Carpetas compartidas

------------------
------------------

# Examen liberatorio

## Pregunta 1. Crear usuarios leyendo de un fichero el nombre de los usuarios que se van a crear y los credenciales que se van a utilizar
* https://www.jesusninoc.com/03/13/ejercicios-de-powershell-restaurar-usuarios-que-se-han-creado-anteriormente-se-almacenan-en-un-fichero-y-se-vuelven-a-crear/
* https://www.jesusninoc.com/04/08/almacenar-y-utilizar-credenciales-mediante-json/
* https://www.jesusninoc.com/12/08/utilizar-credenciales-en-formato-json-que-han-sido-exportados-con-get-credential-y-arrancar-el-programa-notepad-en-powershell/
* https://www.jesusninoc.com/12/07/exportar-credenciales-con-get-credential-en-un-fichero-json-con-powershell/
* https://www.jesusninoc.com/03/01/ejercicios-de-powershell-almacenar-varios-credenciales-en-un-fichero-xml-y-utilizarlos-para-arrancar-un-proceso/
* https://www.jesusninoc.com/06/24/verificar-si-existe-un-usuario-en-windows-10-con-powershell/
* https://www.jesusninoc.com/02/27/validar-usuarios-en-el-directorio-activo-pidiendo-al-usuario-el-nombre-y-la-contrasena/

## Pregunta 2. Realizar una copia de seguridad comprimida en una carpeta compartida con las dll que utilza un proceso
* https://www.jesusninoc.com/03/05/create-a-share-on-linux-and-access-it-from-windows/
* https://www.jesusninoc.com/04/30/ejercicios-de-powershell-crear-una-carpeta-compartida-mapearla-y-utilizarla/
* https://www.jesusninoc.com/06/14/conectarse-a-una-carpeta-compartida-con-powershell/
* https://www.jesusninoc.com/05/27/ejercicios-de-powershell-analizar-ficheros-dll-en-todos-los-equipos-de-la-red-comprobar-que-ha-cambiado-una-integridad-y-copiar-el-fichero-que-ha-cambiado/

--------------
--------------

# Corrección del examen liberatorio
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-03-11.md#pregunta-1-crear-usuarios-leyendo-de-un-fichero-el-nombre-de-los-usuarios-que-se-van-a-crear-y-los-credenciales-que-se-van-a-utilizar

# Ejercicios sobre corrección del examen liberatorio
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-una-funcion-que-almacene-los-usuarios-que-estan-en-el-equipo-y-los-guarde-en-formato-qr/
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-un-qr-con-los-nombres-de-los-usuarios-que-hay-en-el-sistema-y-crear-los-usuarios-nuevamente-leyendo-el-codigo-qr-generado-anteriormente/
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-usuarios-en-linux-leyendo-desde-un-codigo-qr-en-powershell-el-nombre-de-los-usuarios-se-obtiene-listando-usuarios-en-el-sistema-desde-powershell-y-convirtiendo-a-codig/

------------
------------

# Linux

## Repaso de usuarios
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#listar-informaci%C3%B3n-sobre-usuarios-y-grupos-en-bash-con-repaso-sobre-comandos
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-04.md#crear-usuarios-en-ubuntu-mediante-wsl
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-09.md#crear-usuarios-en-ubuntu

## Repaso scripting Linux
* https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjerciciosFicherosBuscar.sh
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-05-24-Enunciado.sh
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-22.md#repaso-para-realizar-scripts-en-linux
* https://blog.carreralinux.com.ar/2016/07/unir-y-ordenar-lineas-en-archivos-de-texto/
* https://likegeeks.com/es/comando-awk/

## Repaso enlaces duros y simbólicos
* https://geekland.eu/que-son-para-que-sirven-enlaces-duros-y-simbolicos/

## Más repaso scripts
* https://github.com/jesusninoc/Scripts

------------
------------

# Corrección del examen liberatorio
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-03-11.md#pregunta-2-realizar-una-copia-de-seguridad-comprimida-en-una-carpeta-compartida-con-las-dll-que-utilza-un-proceso

# Ejercicios sobre corrección del examen liberatorio
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-realizar-una-copia-de-seguridad-de-las-dll-que-utiliza-un-proceso-y-comprimir-la-copia-dentro-de-una-carpeta-compartida/

------------
------------

# Linux (vamos por la parte de valores $* en la presentación)

## Ejercios resueltos
* https://www.jesusninoc.com/03/18/ejercicios-wsl-crear-en-windows-con-powershell-y-wsl-los-mismos-usuarios-que-tenemos-en-linux/
* https://www.jesusninoc.com/03/18/ejercicios-de-wsl-realizar-una-suma-en-wsl-llamando-a-un-script-de-bash-donde-le-pasamos-dos-valores/
* https://www.jesusninoc.com/03/18/ejercicios-de-wsl-realizar-una-suma-en-wsl-llamando-a-un-script-donde-le-pasamos-dos-valores-desde-powershell/
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-crear-un-interfaz-simple-que-realice-la-operacion-de-suma-resta-y-multiplicacion/
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-crear-un-interfaz-simple-que-realice-la-operacion-de-suma-resta-y-multiplicacion-mediante-la-llamada-a-un-script-en-bash-utilizando-wsl/

## Más repaso scripts
* https://github.com/jesusninoc/Scripts

-----------
-----------

# Examen segunda evaluación

1. Leer un usuario desde un servidor web (HTML, XML, JSON) crearlo y meterlo en el grupo de administradores (no te olvides del password).
2. Detectar mediante una función que el usuario pertenece al grupo de administradores.
```PowerShell
Get-LocalGroupMember administradores
```
El siguiente enlace es una solución de monitorización algo compleja: registrar y mostrar un evento en PowerShell cuando se crea un usuario
https://www.jesusninoc.com/2018/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

3. Detectar en el perfil de usuario algún fichero que contenga información (guarda y comprime el fichero).
```PowerShell
Get-ChildItem C:\Users\juan\NTUSER.DAT
```
4. Intentar utilizar las credenciales de un usuario y verificar que funciona (guarda en un fichero la captura).
* https://www.jesusninoc.com/2016/08/16/almacenar-credenciales/
* https://www.jesusninoc.com/2016/09/20/almacenar-y-utilizar-credenciales/
* https://www.jesusninoc.com/2017/04/08/almacenar-y-utilizar-credenciales-mediante-json/
5. Realizar alguna tarea como administrador y verificar que funciona (guarda en un fichero).
* https://www.jesusninoc.com/2016/08/17/utilizar-credenciales-almacenados/
6. Dejar una puerta trasera para poder conectarse desde SSH en Linux.
* https://itefix.net/copssh

--------------------------

# Simulacro de examen segunda evaluación

# Parte 1
## Crear un usuario utilizando el protocolo UDP
### Server
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Close()
```
### Client
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('New-LocalUser usuario2 -Password (ConvertTo-SecureString "11234aaa@@€dsf" -asplaintext -force)')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

## Ayuda
### Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
* https://www.jesusninoc.com/11/23/crear-un-usuario-local-con-contrasena-en-windows-10-con-powershell-5-1/
### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
* https://www.jesusninoc.com/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
### Lanzar una excepción en la función si algo va mal
```PowerShell
function Copy-Log
{
  "Doing prerequisites"
  "Testing whether target path exists"
  "If target path does not exist, bail out"
  throw "Target path does not exist"
  "Copy log files to target path"
  "Delete log files in original location"
}
```
# Parte 2
## Detectar que se ha creado un usuario sin darnos cuenta
- Por red
- Por IP
```PowerShell
Get-NetUDPEndpoint | %{
    if(($_ -match "192.168.104.39") -or ($_ -match "10.0.2.13") -or ($_ -match "127.0.0.1"))
    {
    }
    else
    {
        $_
    }
}
```
- Registro de la acción de crear usuarios
```PowerShell
#Ejecutar PowerShell como administrador
Register-WmiEvent -Query "select * from __InstanceCreationEvent where TargetInstance isa 'Win32_NtLogEvent' and TargetInstance.logfile = 'Security' and (TargetInstance.EventCode = '4720')" -Action {Write-Host $event.SourceEventArgs.NewEvent.TargetInstance.insertionstrings}
```
- Listar la fecha de creación de usuarios
```PowerShell
$checktime = (get-date).adddays(-1000)
get-aduser -searchbase "CN=Users ,DC=retared,DC=local" -Properties whencreated -filter {whencreated -ge $checktime}
```
- Contar número de usuarios
```PowerShell
(Get-LocalUser).count
```

------------
------------

# Repaso examen 2ª evaluación

## Posibles preguntas

- Crear un sistema para realizar instalaciones de programas en Linux desde PowerShell
  - El sistema tiene que comprobar si hay que realizar instalaciones al arrancar el sistema operativo

- Crear un sistema que da de alta usuarios en el sistema operativo
  - El sistema tiene que ser una tarea programada

- Ejemplos de preguntas rápidas
  - ¿Cómo bloqueas un programa en Windows para que no pueda ejecutarlo un usuario?
  - ¿Qué contiene el fichero ntuser.dat?

- Script OWASP
  - WordPress username enumeration with PowerShell https://jesusninoc.com/wp-json/wp/v2/users/
  - WordPress https://www.jesusninoc.com/wordpress/

------------
------------

# Examen segunda evaluación

## Tener en cuenta
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-26.md

## Configurar al usuario todo lo que necesita leyendo de un fichero (programas, carpetas, etc.), realizar el siguiente proceso:
- Copiar la información y configuración que hay sobre un usuario
	- Programas
	- DLL
- Crear para cada nuevo usuario que entra en el sistema (teniendo en cuenta el punto anterior):
	- Usuario
	- Grupo
	- Carpeta compartida
	
## Teniendo en cuenta la pregunta anterior, realizar un script que permita enviar información desde los clientes (no depender del servidor)
  
### Ayuda
- Guardar información sobre usuarios para hacer una recuperación
- Guardar información sobre programas y paquetes
- Configuración IP, DNS
- Tener en cuenta funciones complejas
- Se puede mejorar el script con Linux
- Tener en cuenta el AD
- Filtro LDAP
- Comunicar por UDP
- Información sobre programas
	- C:\Program Files
	- C:\Users\administrador.RETARED\AppData\Local
	- C:\Windows\prefetch
- Carpetas compartidas para guardar información de una copia de seguridad
 	- https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-16.md
 	- https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-11.md
- UDP
	- https://www.jesusninoc.com/11/10/realizar-conexiones-tcp-udp-con-powershell/

-----------

# Examen segunda evaluación

## Realizar un programa que permita utilizar el siguiente fichero
```
juan|ventas,compras|office|\\servidor1\ventas\juan|Total
```

## Ideas
### Perfiles móviles
http://www.developandsys.es/perfiles-moviles-server/
### Mapeo de unidades red Windows Server
http://www.developandsys.es/mapeo-unidades-red-windows-server/

-----------

# Resolver la siguiente situación mediante scripts

## Los usuarios de una red funcionan con un sistema muy básico, tienen usuarios creados en cada equipo y comparten archivos mediante carpetas compartidas. Tu tarea es extraer los usuarios de los equipos y centralizar todo en un solo servidor con un Directorio Activo.

### Ayuda
- Crear una carpeta compartida, mapearla y utilizarla
```PowerShell
New-SmbShare -Name asir -Path c:/asir1 –FullAccess juan -ReadAccess todos
New-PSDrive -Name “asir” -PSProvider FileSystem -Root \\localhost\asir
cd asir:/ 
```

### Soluciones
* https://github.com/AlexRivero14/COVID-19
* https://github.com/PabloQueipo/ISO/blob/master/Pr%C3%A1ctica%2026%20MARZO.md
* https://github.com/DanielCebri/ISO-/blob/master/31032020.md

------------------
------------------

# Examen liberatorio

- Carpeta caliente que recibe un fichero comprimido y crea los usuarios, grupos y OU que están en dicho fichero.

# Repaso del mes
## Script para realizar tareas básicas y avanzadas
https://github.com/jesusninoc/Scripts/blob/master/Realizar%20tareas%20b%C3%A1sicas%20y%20avanzadas.sh
## Cmdlets relacionados con tareas básicas y de administración en el sistema operativo Windows
https://www.jesusninoc.com/2015/04/28/cmdlets-relacionados-con-tareas-basicas-y-de-administracion-en-el-sistema-operativo-windows/

# Repaso del BOE
- Administración de software de base
- Administración de recursos compartidos

# Repaso de las tareas de administración III
### Gestión del almacenamiento
* https://www.jesusninoc.com/2017/07/03/3-gestion-del-hardware-en-powershell/
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
### Gestión de la red
* https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
### Copias de seguridad
* https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

---------------------

# Realizar un script que sea una tarea programada que almacene información sobre la situación actual del sistema operativo (Windows y Linux), teniendo en cuenta:
- Programas instalados
- Actualizaciones
- Usuarios y grupos

## Además de almacenar información, el script tiene que permitir hacer una recuperación con la información almacenada, por ejemplo restaurar usuarios leyendo de un fichero los usuarios y grupos a los que pertenecen.

## Ideas que se pueden aplicar al script:
- Almacenar los .exe de los programas
- Almacenar los ficheros .dll de los programas
- Almacenar los instaladores .msi de los programas instalados
- Realizar un proceso de firma (hash) a los programas instalados
- Utilizar expresiones regulares

----------------------

# Hyper-V: Backup VMs to a shared folder with Windows Server Backup and a Scheduled Task-
https://sid-500.com/2018/03/11/hyper-v-backup-vms-to-a-shared-folder-with-windows-server-backup-and-a-scheduled-task/
```PowerShell
$Action=New-ScheduledTaskAction -Execute 'C:\Temp\backupVM.bat'
$Trigger=New-ScheduledTaskTrigger -Weekly -DaysOfWeek Saturday -At 11am
$Set=New-ScheduledTaskSettingsSet
$Principal=New-ScheduledTaskPrincipal -UserId 'sid-500\administrator' -LogonType S4U
$Task=New-ScheduledTask -Action $Action -Trigger $Trigger -Settings $Set -Principal $Principal
Register-ScheduledTask -TaskName "Backup VM" -InputObject $Task -Force
```

# Linux – Tigger commands and tasks during file system changes
https://www.capatek-tutorials.com/linux/linux-tigger-commands-tasks-file-system-changes/

# Scheduled Task with Daily Trigger and Repetition Interval
https://stackoverflow.com/questions/20108886/scheduled-task-with-daily-trigger-and-repetition-interval
```PowerShell
$trigger = New-ScheduledTaskTrigger `
    -Once `
    -At (Get-Date) `
    -RepetitionInterval (New-TimeSpan -Minutes 5) `
    -RepetitionDuration ([System.TimeSpan]::MaxValue)
```

---------------------

# ¿Cómo detectar que ha aparecido un equipo en la red WIFI?
- Mostrar un mensaje en PowerShell cuando aparece un equipo WIFI en la red
```PowerShell
```

---------------------

# ¿Cómo detectar que se está ejecutando un proceso?
- Conocer procesos
- Firmas de procesos
- Mostrar un mensaje en PowerShell cuando se ejecuta y se para un programa (por ejemplo se ejecuta powershell)
```PowerShell
Start-Process powershell.exe "-command ps"
```
- Localizar el proceso que está relacionado con el puerto de carpetas compartidas
```PowerShell
netstat -ano
```
- Contar procesos
- Contar hilos
- Analizar la red
- Auditar
- Registro
- Registro y logs de carpetas compartida
- Explorer
- Keylogger
- Volcado de procesos
- Capturar la pantalla
- Get-Counter

-------------------

# PowerShell
## Detectar si hay un dispositivo USB conectado y copiar el contenido en una carpeta temporal
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Detectar%20si%20hay%20un%20dispositivo%20USB%20conectado%20y%20copiar%20el%20contenido%20en%20una%20carpeta%20temporal.ps1

## Discover a webcam
https://www.jesusninoc.com/2017/10/17/discover-a-webcam/

## Ver los teléfonos móviles que se han conectado al sistema operativo
https://www.jesusninoc.com/2016/12/01/ver-los-telefonos-moviles-que-se-han-conectado-al-sistema-operativo/

## Conocer el estado del ratón
https://www.jesusninoc.com/2016/10/05/conocer-el-estado-del-raton/

## Activar un dispositivo Plug and Play con PowerShell
https://www.jesusninoc.com/2018/03/08/activar-un-dispositivo-plug-and-play-con-powershell/

## Desactivar un dispositivo Plug and Play con PowerShell
https://www.jesusninoc.com/2018/02/08/desactivar-un-dispositivo-plug-and-play-con-powershell/

## Show UDID of iPhone
https://www.commandlinefu.com/commands/view/15421/show-udid-of-iphone

# Linux
## Setting Up NFS Share on Windows
https://support.microfocus.com/kb/doc.php?id=7020834

## Montar una carpeta compartida de Windows en Linux
https://blog.desdelinux.net/montar-unidades-smb-desde-consola/

## dd command
https://www.computerhope.com/unix/dd.htm

Caution: Use dd cautiously — improper usage or entering the wrong values could inadvertently wipe, destroy, or overwrite the data on your hard drive.

### Create a ISO disc image from the CD in the computer
```Bash
dd if=/dev/sr0 of=/home/hope/exampleCD.iso bs=2048 conv=noerror,sync
```

### Create an img file of the /dev/sda hard drive. To restore that image type: dd if=disk1.img of=/dev/sda
```Bash
dd if=/dev/sda of=~/disk1.img
```

### Copy the contents from the if= drive /dev/sda to the of= drive /dev/sdb.
```Bash
dd if=/dev/sda of=/dev/sdb
```

## How to dd a remote disk using SSH on local machine and save to a local disk
https://unix.stackexchange.com/questions/132797/how-to-dd-a-remote-disk-using-ssh-on-local-machine-and-save-to-a-local-disk

### run from remote computer
```Bash
$ dd if=/dev/sda | gzip -1 - | ssh user@local dd of=image.gz
```

### run from local computer
```Bash
$ ssh user@remote "dd if=/dev/sda | gzip -1 -" | dd of=image.gz
```

-----------
-----------

# Repaso

## Registrar y mostrar un evento en PowerShell cuando se ejecuta un programa
https://www.jesusninoc.com/2018/02/14/registrar-y-mostrar-un-evento-en-powershell-cuando-se-ejecuta-un-programa/

## Registrar y mostrar un evento en PowerShell cuando se crea un usuario
https://www.jesusninoc.com/2018/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

# Registry

A central hierarchical database used in Microsoft Windows, used to store information that is necessary to configure the system for one or more users, applications and hardware devices.

https://www.jesusninoc.com/registry/

## Ejemplos en PowerShell de gestión del registro de Windows

### Ver información en el Registro de Windows sobre las Variables de entorno
https://www.jesusninoc.com/2015/03/23/ver-informacion-en-el-registro-de-windows-sobre-las-variables-de-entorno/
### Ver información en el Registro de Windows sobre el estado de los servicios
https://www.jesusninoc.com/2015/03/22/ver-informacion-en-el-registro-de-windows-sobre-el-estado-de-los-servicios/

## Ejercicios en PowerShell de gestión del registro de Windows
https://github.com/jesusninoc/PowerShell/tree/master/Registro

## Herramienta para analizar el registro (Process Monitor v3.40)
Process Monitor is an advanced monitoring tool for Windows that shows real-time file system, Registry and process/thread activity. It combines the features of two legacy Sysinternals utilities, Filemon and Regmon, and adds an extensive list of enhancements including rich and non-destructive filtering, comprehensive event properties such session IDs and user names, reliable process information, full thread stacks with integrated symbol support for each operation, simultaneous logging to a file, and much more. Its uniquely powerful features will make Process Monitor a core utility in your system troubleshooting and malware hunting toolkit.
https://www.jesusninoc.com/2018/02/11/process-monitor-v3-40/

# Expresiones regulares
https://ss64.com/ps/syntax-regex.html

## Regular Expressions Unfettered
https://developer.apple.com/library/content/documentation/OpenSource/Conceptual/ShellScripting/RegularExpressionsUnfettered/RegularExpressionsUnfettered.html

## Ejemplos de utilización de expresiones regulars
https://www.regular-expressions.info/examples.html

## Searching IP addresses in text files
https://www.jesusninoc.com/2014/11/24/searching-ip-addresses-in-text-files/

## Searching URLs in text files
https://www.jesusninoc.com/2014/11/19/searching-urls-text-files/

## Searching the Registry: IP addresses
https://www.jesusninoc.com/2014/11/12/searching-registry-ip-addresses/

## Searching the Registry: URLs
https://www.jesusninoc.com/2014/11/14/searching-registry-urls/

## Online regex tester
https://regex101.com/

# Registry

A central hierarchical database used in Microsoft Windows, used to store information that is necessary to configure the system for one or more users, applications and hardware devices.

https://www.jesusninoc.com/registry/

## Ejemplos en PowerShell de gestión del registro de Windows

### Ver información en el Registro de Windows sobre las Variables de entorno
https://www.jesusninoc.com/2015/03/23/ver-informacion-en-el-registro-de-windows-sobre-las-variables-de-entorno/
### Ver información en el Registro de Windows sobre el estado de los servicios
https://www.jesusninoc.com/2015/03/22/ver-informacion-en-el-registro-de-windows-sobre-el-estado-de-los-servicios/

## Ejercicios en PowerShell de gestión del registro de Windows
https://github.com/jesusninoc/PowerShell/tree/master/Registro

## Herramienta para analizar el registro (Process Monitor v3.40)
Process Monitor is an advanced monitoring tool for Windows that shows real-time file system, Registry and process/thread activity. It combines the features of two legacy Sysinternals utilities, Filemon and Regmon, and adds an extensive list of enhancements including rich and non-destructive filtering, comprehensive event properties such session IDs and user names, reliable process information, full thread stacks with integrated symbol support for each operation, simultaneous logging to a file, and much more. Its uniquely powerful features will make Process Monitor a core utility in your system troubleshooting and malware hunting toolkit.
https://www.jesusninoc.com/2018/02/11/process-monitor-v3-40/

# Expresiones regulares
https://ss64.com/ps/syntax-regex.html

## Regular Expressions Unfettered
https://developer.apple.com/library/content/documentation/OpenSource/Conceptual/ShellScripting/RegularExpressionsUnfettered/RegularExpressionsUnfettered.html

## Ejemplos de utilización de expresiones regulars
https://www.regular-expressions.info/examples.html

## Searching IP addresses in text files
https://www.jesusninoc.com/2014/11/24/searching-ip-addresses-in-text-files/

## Searching URLs in text files
https://www.jesusninoc.com/2014/11/19/searching-urls-text-files/

## Searching the Registry: IP addresses
https://www.jesusninoc.com/2014/11/12/searching-registry-ip-addresses/

## Searching the Registry: URLs
https://www.jesusninoc.com/2014/11/14/searching-registry-urls/

## Online regex tester
https://regex101.com/

------------------

# Converting PowerShell to Batch
http://community.idera.com/powershell/powertips/b/tips/posts/converting-powershell-to-batch

# Formas de descargar y ejecutar ficheros desde un servidor en PowerShell
https://www.jesusninoc.com/2016/11/15/formas-de-descargar-y-ejecutar-ficheros-desde-un-servidor-en-powershell/

# Permitir conexiones remotas
https://www.jesusninoc.com/2016/05/08/permitir-conexiones-remotas/

# Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
https://www.jesusninoc.com/2016/11/23/crear-un-usuario-local-con-contrasena-en-windows-10-con-powershell-5-1/

# Conectarse por SSH al router de fibra óptica MitraStar de Movistar desde PowerShell
https://www.jesusninoc.com/2017/11/16/conectarse-por-ssh-al-router-de-fibra-optica-mitrastar-de-movistar-desde-powershell/

# Datos URIs
https://developer.mozilla.org/es/docs/Web/HTTP/Basics_of_HTTP/Datos_URIs

# Bash Bunny Phishing Attack With Hamsters - Hak5 2306
https://www.youtube.com/watch?v=TYR2a2XoK3A

# Realizar una redirección con JavaScript utilizando Start-Process y Google Chrome
https://www.jesusninoc.com/2017/02/06/realizar-una-redireccion-con-javascript-utilizando-start-process-y-google-chrome-2/

# Ejecutar un Batch que descarga un script desde una URL, el script ejecuta un payload de ejecución de comandos arbitrarios que permite realizar un volcado de memoria RAM

* Converting PowerShell to Batch
http://community.idera.com/powershell/powertips/b/tips/posts/converting-powershell-to-batch

* Formas de descargar y ejecutar ficheros desde un servidor en PowerShell
https://www.jesusninoc.com/2016/11/15/formas-de-descargar-y-ejecutar-ficheros-desde-un-servidor-en-powershell/

* Cargar en memoria y ejecutar un payload de ejecución de comandos arbitrarios en PowerShell
https://www.jesusninoc.com/2017/02/16/cargar-en-memoria-y-ejecutar-un-payload-de-ejecucion-de-comandos-arbitrarios-en-powershell/

* Crear un fichero de volcado de memoria de un proceso
https://www.jesusninoc.com/2016/03/04/crear-un-fichero-de-volcado-de-memoria-de-un-proceso/

## Más ideas

* Keylogger sencillo con PowerShell
https://www.jesusninoc.com/2017/03/11/keylogger-sencillo-con-powershell/

* Enviar datos a un formulario de Google Docs desde PowerShell
https://www.jesusninoc.com/2017/03/11/enviar-datos-a-un-formulario-de-google-docs-desde-powershell/

# Recuperación del sistema operativo
- Copia del sistema operativo en red (carpeta compartida).
- Crear disco de recuperación.

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Introducción

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Introducción

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

## Encontrarse a uno mismo
```PowerShell
Get-EventLog Security | Where-Object Message -Match "asir1joselui"
```

## Ejemplos de introducción a monitorizar
```PowerShell
# (INCORRECTO) Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
Get-CimInstance -ClassName Win32_StartupCommand  | select Caption, @{n='NombreP';e={(Get-Process -name $_.Caption | Select Name).name}}

# Comprobar que se está ejecutando un programa que se arranca al inicio del arranque del sistema operativo
Get-Process -Name MSOSYNC

# (CORRECTO 1) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

Get-Process -Name $acumul

# (CORRECTO 2) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
function comprobar($programa){
    Get-Process -Name $programa -ErrorAction Ignore
}

Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        comprobar $temperal[$temperal.Count-1]

}

# (CORRECTO 3) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

$acumul | %{
    $_
    ((Get-Process).name.toupper()).contains($_.toupper())
}
```

## Ejercicio: registrar un evento cuando se logre realizar una conexión entre un cliente y un servidor mediante UDP (almacenar la dirección IP de la conexión del cliente o del servidor)
* https://www.jesusninoc.com/05/08/ejercicios-de-powershell-registrar-un-evento-cuando-se-logre-realizar-una-conexion-entre-un-cliente-y-un-servidor-mediante-udp-almacenar-la-direccion-ip-de-la-conexion-del-cliente-o-del-servidor/

### Solución (otra forma de verlo, el cliente manda crear un log al servidor)

#### Cliente
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "192.168.43.108" -Category 2 -RawData 10,20')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
#### Servidor
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
Invoke-Expression ([Text.Encoding]::ASCII.GetString($content))
```

-------------------
-------------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------------

# Monitorizar procesos
## 7. Gestión de procesos en PowerShell
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

## System Monitor
System Monitor (Sysmon) is a Windows system service and device driver that, once installed on a system, remains resident across system reboots to monitor and log system activity to the Windows event log. It provides detailed information about process creations, network connections, and changes to file creation time. By collecting the events it generates using Windows Event Collection or SIEM agents and subsequently analyzing them, you can identify malicious or anomalous activity and understand how intruders and malware operate on your network.
* https://www.fwhibbit.es/sysmon-el-gran-hermano-de-windows-y-el-super-sysmonview

Install with default settings (process images hashed with sha1 and no network monitoring)
```MD-DOS
sysmon -accepteula –i
```
Install with md5 and sha256 hashing of process created and monitoring network connections
```MD-DOS
sysmon -accepteula –i –h md5,sha256 –n
```
Install Sysmon with a configuration file (as described below)
```MD-DOS
sysmon –accepteula –i c:\windows\config.xml
```
Uninstall
```MD-DOS
sysmon –u
```
Dump the current configuration
```MD-DOS
sysmon –c
```
Change the configuration to use all hashes, no network monitoring and monitoring of DLLs in Lsass
```MD-DOS
sysmon –c –h * –l lsass.exe
```
Change the configuration of sysmon with a configuration file (as described below)
```MD-DOS
sysmon –c c:\windows\config.xml
```
Change the configuration to default settings
```MD-DOS
sysmon –c --
```
Show the configuration schema
```MD-DOS
sysmon -s
```

## Sources, configuration and how to detect evil things utilizing Microsoft Sysmon
https://github.com/MHaggis/sysmon-dfir

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------

# Logs

## Logs en Windows

### PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

### List event log
https://www.jesusninoc.com/2018/03/27/list-event-log

### Write-EventLog
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/write-eventlog?view=powershell-5.1

### Escribir y ver un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Almacenar información convertida a byte en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/05/almacenar-informacion-convertida-a-byte-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Ejecutar la información que se encuentra en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/06/ejecutar-la-informacion-que-se-encuentra-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Windows Event Log to the Dark Side — Storing Payloads and Configurations
https://medium.com/@5yx/windows-event-log-to-the-dark-side-storing-payloads-and-configurations-9c8ad92637f2

### Active Directory: Configuring Event Log Subscriptions (Forwarding)
https://sid-500.com/2018/04/23/active-directory-configuring-event-log-subscriptions-forwarding/

### HOW TO DETECT PASS-THE-HASH ATTACKS
https://blog.stealthbits.com/how-to-detect-pass-the-hash-attacks/

## Logs en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-13.md#registros-de-sucesos

```Bash
cd /var/log
ls
```

- /var/log/message: registro de mensajes generales del sistema
- /var/log/auth.log: log de autenticación
- /var/log/kern.log: registro del kernel
- /var/log/cron.log: registro de cron
- /var/log/maillog: registro del servidor de mails
- /var/log/qmail/ : registro de Qmail
- /var/log/httpd/: registro de errores y accesos a Apache
- /var/log/lighttpd: registro de errores y accesos a Lighttpd
- /var/log/boot.log : registro de inicio del sistema
- /var/log/mysqld.log: registro de la base de datos MySQL
- /var/log/secure: log de autenticación
- /var/log/utmp or /var/log/wtmp : registro de logins

### Analizar logs en Linux
#### Regular Expressions
```Bash
 grep -a "user juanito" /var/log/auth.log
```
#### Tail
```Bash
$ tail -f /var/log/auth.log | grep -a 'invalid'
```
#### Cut
```Bash
grep "authentication failure" /var/log/auth.log | cut -d '=' -f 8
```
#### Awk
```Bash
awk '/sshd.*invalid user/ { print $9 }' /var/log/auth.log
```

------------------
------------------

# Repaso Linux

* https://www.jesusninoc.com/02/03/curso-de-bash-scripting-con-ejemplos/
* https://github.com/jesusninoc/Bash/blob/master/Introduccion/EjemplosIntroducci%C3%B3n.sh
* https://github.com/jesusninoc/Bash/blob/master/Introduccion/EjemplosOperacionesCadenas.sh
* https://github.com/jesusninoc/Bash/tree/master/Examenes
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-15.md
* https://github.com/jesusninoc/Bash/tree/master/Permisos
* https://github.com/jesusninoc/Bash/tree/master/Ficheros
* https://github.com/jesusninoc/Bash/tree/master/Repaso
* https://github.com/jesusninoc/Bash/tree/master/Monitorizacion
* https://github.com/jesusninoc/Bash

---------
---------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Introducción

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

## Encontrarse a uno mismo
```PowerShell
Get-EventLog Security | Where-Object Message -Match "asir1joselui"
```

## Ejemplos de introducción a monitorizar
```PowerShell
# (INCORRECTO) Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
Get-CimInstance -ClassName Win32_StartupCommand  | select Caption, @{n='NombreP';e={(Get-Process -name $_.Caption | Select Name).name}}

# Comprobar que se está ejecutando un programa que se arranca al inicio del arranque del sistema operativo
Get-Process -Name MSOSYNC

# (CORRECTO 1) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

Get-Process -Name $acumul

# (CORRECTO 2) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
function comprobar($programa){
    Get-Process -Name $programa -ErrorAction Ignore
}

Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        comprobar $temperal[$temperal.Count-1]

}

# (CORRECTO 3) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

$acumul | %{
    $_
    ((Get-Process).name.toupper()).contains($_.toupper())
}
```

## Ejercicio: registrar un evento cuando se logre realizar una conexión entre un cliente y un servidor mediante UDP (almacenar la dirección IP de la conexión del cliente o del servidor)
* https://www.jesusninoc.com/05/08/ejercicios-de-powershell-registrar-un-evento-cuando-se-logre-realizar-una-conexion-entre-un-cliente-y-un-servidor-mediante-udp-almacenar-la-direccion-ip-de-la-conexion-del-cliente-o-del-servidor/

### Solución (otra forma de verlo, el cliente manda crear un log al servidor)

#### Cliente
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "192.168.43.108" -Category 2 -RawData 10,20')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
#### Servidor
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
Invoke-Expression ([Text.Encoding]::ASCII.GetString($content))
```

-------------------
-------------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------------

# Monitorizar procesos
## 7. Gestión de procesos en PowerShell
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

## System Monitor
System Monitor (Sysmon) is a Windows system service and device driver that, once installed on a system, remains resident across system reboots to monitor and log system activity to the Windows event log. It provides detailed information about process creations, network connections, and changes to file creation time. By collecting the events it generates using Windows Event Collection or SIEM agents and subsequently analyzing them, you can identify malicious or anomalous activity and understand how intruders and malware operate on your network.
* https://www.fwhibbit.es/sysmon-el-gran-hermano-de-windows-y-el-super-sysmonview

Install with default settings (process images hashed with sha1 and no network monitoring)
```MD-DOS
sysmon -accepteula –i
```
Install with md5 and sha256 hashing of process created and monitoring network connections
```MD-DOS
sysmon -accepteula –i –h md5,sha256 –n
```
Install Sysmon with a configuration file (as described below)
```MD-DOS
sysmon –accepteula –i c:\windows\config.xml
```
Uninstall
```MD-DOS
sysmon –u
```
Dump the current configuration
```MD-DOS
sysmon –c
```
Change the configuration to use all hashes, no network monitoring and monitoring of DLLs in Lsass
```MD-DOS
sysmon –c –h * –l lsass.exe
```
Change the configuration of sysmon with a configuration file (as described below)
```MD-DOS
sysmon –c c:\windows\config.xml
```
Change the configuration to default settings
```MD-DOS
sysmon –c --
```
Show the configuration schema
```MD-DOS
sysmon -s
```

## Sources, configuration and how to detect evil things utilizing Microsoft Sysmon
https://github.com/MHaggis/sysmon-dfir

# Introducción al examen liberatorio

## Opción 1

### El departamento de recursos humanos envía el siguiente fichero...
```
nombre;apellido;password;grupo;ou;appbloqueada
juan;sinmiedo;P@ss1wordA;asir;asir;notepad
laura;valiente;P@ss1wordA;af;af;mspaint
```

#### - Nivel 1: crear un script que permita realizar todas las tareas que aparecen en el fichero.
#### - Nivel 2: crear un script que permita realizar las operaciones de forma ordenada.
#### - Nivel 3: crear un script que permita realizar las operaciones utilizando UDP.

## Opción 2

### Crear la estructura de red del Centro leyendo de un fichero, teniendo en cuenta:
- Hay seis grupos de clases, seis unidades organizativas
- Hay que crear usuarios y grupos para cada clase
- Hay que deshabilitar usuarios y moverlos a la unidad organizativa de los deshabilitados
- Borrar unidades organizativas
- Crear una carpeta para cada usuario

------------
------------

# Trabajo para optar al 10 y a MH
### Utilizando sockets comunicar un cliente con un servidor y aplicar el mayor número de conceptos vistos durante el curso:
- Crear una herramienta de control remoto.
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

--------------

## Ayuda
### Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

## Ayuda avanzada
### Pedir el nombre de un proceso y mostrar información del proceso mediante PowerShell con Node-PowerShell, EJS (Embedded JavaScript), Body-parser y Express
https://www.jesusninoc.com/2018/06/10/pedir-el-nombre-de-un-proceso-y-mostrar-informacion-del-proceso-mediante-powershell-con-node-powershell-ejs-body-parser-y-express-node-js/

### Build a Weather Website in 30 minutes with Node.js + Express + OpenWeather
https://codeburst.io/build-a-weather-website-in-30-minutes-with-node-js-express-openweather-a317f904897b

--------------

## Ejemplo de trabajo

### Realizar operaciones en un equipo remoto

```PowerShell
cls
write-host "Ip del ordenador remoto"
$ipR=read-host

##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('cls')"
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

while (1)
{

cls

Write-Host "Seleccione una opcion"

echo "1 - Sistema de archivos"
echo "2 - Agregar/eliminar software"
echo "3 - Actualizacion"
echo "4 - Gestion de procesos"
echo "5 - Programacion de tareas"
echo "6 - Gestion de usuarios"
echo "7 - Gestion de almacenamiento"
echo "8 - Gestion de red"
echo "9 - Copias de seguridad"
echo "10 - Reparacion del sistema"
echo "11 - Rendimiento del sistema"
echo "12 - Salir"

$prue1 = Read-Host
switch ( $prue1 )
    {
        1{
            cls
            Write-Host "Seleccione una opcion"
            echo "1 - Listar"
            echo "2 - Crear"
            echo "3 - Abrir"
            echo "4 - Eliminar"
            $selcec=Read-Host
            switch ( $selcec )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=[Text.Encoding]::ASCII.GetBytes('Get-ChildItem')
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                2{
                    $type=Read-Host "Escriba que tipo desea crear (File o Directory)"
                    $name=Read-Host "Escriba el nombre del $type"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Item -ItemType $type -Name $name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                3{
                    $name1=Read-Host "Nombre del archivo que desea abrir"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('start $name1')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                4{
                    ls
                    $name2=Read-Host "¿Qué desea eliminar?"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-Item $name2')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }                   
        }
        2{
            cls
            $nombre=Read-Host "Introduzca nombre del .msi que desee instalar"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('msiexec.exe /package C:\windows\Installer\($nombre)')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        Pause
        }
        3{
            cls
            echo "1 - Instalar"
            echo "2 - Desinstalar"
            Write-Host "Seleccione una opción"
            $actuali=Read-Host
            switch ($actuali)
            {
                1{
                    Write-Host "Como desea que se realize"
                    echo "1 - Normal"
                    echo "2 - En silencio"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            Write-Host "Escriba el nombre de la actualizacion"
                            $nombre=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                           
                        }
                        2{
                            Write-Host "Eliga la opción desea"
                            echo "1 - No reiniciarse al terminar"
                            echo "2 - Pedir confirmación antes de reiniciar"
                            echo "3 - Obligar a que se cierren todas las aplicaciones y se reinicie"
                            $Smodo=Read-Host
                            $Nombre=Read-Host
                            switch($Smodo)
                            {
                                1{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()
                                    
                                }
                                2{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /warnrestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                                3{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /forcerestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                            }
                        }
                    }
                }
                2{
                    cls
                    echo "1 - Normal"
                    echo "2 - Paquete asociado con el número de actualización"
                    Write-Host "Seleccione una opción"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                        2{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall /kb')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                    }
            }
            }
            puase
        }
        4{
            cls
            echo "1 - Iniciar un proceso"
            echo "2 - Mostrar solo Nombres"
            echo "3 - Mostrar proceso de cierto programa"

            $sele=Read-Host
            switch ( $sele )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                } 
                2 {
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | select Name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3 {
                    $selprog=Read-Host "Escriba el nombre del programa"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | Select-String $selprog')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
        5{
            cls
            $program=Read-Host "que programa desea abrir"
            $time=Read-Host "a que hora"
            $nomre=Read-Host "escriba el nombre de la tarea"
            $action=New-ScheduledTaskAction -Execute $program
            $trigger=New-ScheduledTaskTrigger -Daily -At $time
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Register-ScheduledTask -Action $action -Trigger $trigger -TaskName $nomre')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()           
            Pause
            
        }
        6{
            cls
            echo "1 - Crear usuario"
            echo "2 - Eliminar usuario"
            echo "3 - Crear grupo"
            echo "4 - Ver miembros de un grupo"
            echo "5 - Eliminar grupo"
            $opcion=Read-Host "Eliga una opcion"
            switch ($opcion)
            {
            1{
                $nameuser=Read-Host "Nomre del nuevo usuario"
                $pass=Read-Host "Introduzca contraseña"
                $pass1=ConvertTo-SecureString $pass -asplaintext -force
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalUser $nameuser -Password $pass1')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            2{
                $usuer=Read-Host "Nombre del usuario"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-LocalUser -Name $usuer')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            3{
                $group=Read-Host "Nombre para el grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalGroup -Name $group')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            4{
                $Ngroup=Read-Host "Nombre del grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Ngroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            5{
                $Rgroup=Read-Host "Nombre del grupo que vaya a eliminar"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Rgroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            }
        }
        7{
            cls
            echo "1 - Particionar"
            echo "2 - Desfragmentar"
            echo "3 - Convertir sistemas de archivo"
            echo "4 - Cifrar"
            echo "5 - Descifrar"
            Write-Host  "Seleccione una opción"
            $almacenamiento=Read-Host
            switch ($almacenamiento)
            {
                1{
                    Write-Host "ADVERTENCIA: Nunca poner el numero '0'"
                    $NumeroD=Read-Host "Introduzca número del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Partition -DiskNumber $NumeroD -UseMaximumSize -AssignDriveLetter')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    $letra=Read-Host "Letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Optimize-Volume $letra -Defrag')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Disable-BitLocker 
                    Pause
                }
                3{
                    $letra=Read-Host "Letra del disco"
                    $tipo=Read-Host "Que formato desea"                    
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Format-Volume -DriveLetter $letra -FileSystem $tipo')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                4{
                    $letra=Read-Host "Inroduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Enable-BitLocker -MountPoint $letra -RecoveryPasswordProtector -UsedSpaceOnly -Verbose')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                5{
                    $letra=Read-Host "Introduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Disable-BitLocker -MountPoint $letra')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
            }
              
        }
        }
        8{
            cls
            echo "1 - Saber ip"
            echo "2 - Hacer ping"
            $op=Read-Host "Seleccione una opcion"
            Switch ( $op )
            {
            1{
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ipconfig')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            2{
                $ip=Read-Host "Introduzca IPv4"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ping $ip')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            }
        }
        9{
            cls
            Write-Host "Se recomienda que ponga la ruta y para quedarsela usted la meta en una carpeta compartida"
            $namea=Read-Host "Nombre del archivo que desea hacer copia de seguridad"
            $ruta=Read-Host "Ruta donde desea que este la copia de seguridad"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Copy-Item $namea $ruta')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()            
            Pause
        }
        10{
            cls
            Write-Host "Seleccione una opción"
            echo "1 - Ver puntos de restauracion"
            echo "2 - Restaurar un punto"
            $opcion=Read-Host
            switch ($opcion)
            {
                1{        
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                }
                2{
                    Write-Host "Seleccione una opción"
                    echo "1 - Ultimo punto"
                    echo "2 - Restaura cierto punto"
                    $opcion=Read-Host
                    switch ($opcion)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint -LastStatus')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }

                        2{
                            Write-Host "Ponga el numero de restauración"
                            $punto=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Restore-Computer -RestorePoint $punto')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()                   
                        }
                    }
                }
            }
            Pause
        }
        11{
            cls
            echo "1 - Monitorizar procesos"
            echo "2 - Monitorizar procesos Avanzado"
            echo "3 - Ver todos los nombres de los contadores de rendimiento"
            $seleccionar=Read-Host "Seleccione una opción"
            switch ( $seleccionar )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port
                    )
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Counter -ListSet * | Sort-Object CounterSetName | Format-Table CounterSetName')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
}
if( $prue1 -eq "12" )
        {
            cls
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('break')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            break
        }
}
```

-----------
-----------

# Modelos de examen de la asignatura de Implantación de Sistemas Operativos (ISO) de 1º de Administración de Sistemas Informáticos en Red (ASIR) tercera evaluación
- Modelo 1 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-1
- Modelo 2 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-2
- Modelo 3 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-3
- Modelo 4 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-4
- Modelo 5 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-5
- Modelo 6 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-6

-----------------

# Modelo 1

## Tener en cuenta:
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## 1. Analizar ficheros DLL en todos los equipos de la red
```PowerShell
123..125 | %{"192.168.104." + $_}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
$ruta
}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.jes"
ls $ruta
}

1..40 |  %{Invoke-Command -ComputerName ("192.168.204." + $_) -ScriptBlock {hostname}}

Invoke-Command -ComputerName dc1 -ScriptBlock {hostname}

gc .\equipos1.txt | % {
    $llistar="\\"+$_+"\c$"
    ls $llistar | select name,FullName
} | Group-Object name | select Count,Group | where count -eq 1
```
### Enable and Use Remote Commands in Windows PowerShell
https://technet.microsoft.com/en-us/library/ff700227.aspx
### How to Add a Computer to the TrustedHosts List
```PowerShell
set-item wsman:\localhost\Client\TrustedHosts -value "ABANTO"
```
### Listar funciones exportadas de un archivo DLL con DUMPBIN desde PowerShell
https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/

## 2. Analizar ficheros DLL en todos los equipos de la red, comprobar que ha cambiado una integridad y copiar el fichero que ha cambiado
### En PowerShell
```PowerShell
mkdir dlls

cd dlls

"dll1" | Out-File dll1.dll
"dll2" | Out-File dll2.dll

# Recorrrer una a una dll
ls *.dll | %{$_}

# Hacer hash de cada dll
ls *.dll | %{Get-FileHash $_.FullName | Select-Object Hash}

# Hacer hash de cada dll ruta por red
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path}

# Guardar hash
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path | Out-File listado.txt -Append}

# Ver listado
gc .\listado.txt

# Modificar dll y detectar el cambio, después mover la dll, solución: el hash de cada dll no se encuentra en el fichero listado.txt, eso quiere decir que se ha modificado y hay que copiar a la carpeta compartida en Linux
# Modificar dll
"dll6" | Out-File dll1.dll

ls '\\localhost\c$\Users\juan\dlls' *.dll | %{
    if((gc .\listado.txt) -match (Get-FileHash $_.FullName | Select-Object Hash).hash)
    {
    }
    else
    {
        $_.Name
        "Dll se ha modificado"
    }
}


# Meter el código anterior en el recorrido que cada alumno tenga
123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
ls $ruta -recurse
}

# Almacenar el hash de la dll para todos los equipos de la red
foreach($equipo in gc .\equipos1.txt) {
    $llistar="\\"+$equipo+"\c$"
    ls $llistar -recurse *.dll | %{
        $valorse = Get-FileHash ($_ | select FullName).FullName
        $valorse.path+"|"+$valorse.Hash | Out-File hasehees.txt
    }
}

# Verificar si una dll no ha cambiado su hash
gc .\hasehees.txt | %{
    if($_.split("|")[0].contains("jawt.dll"))
    {
        if($_.split("|")[1] -eq (Get-FileHash "\\ABANTOS21\c$\Cache\pc-client.exe-16.3.0.37857\runtime\jre\bin\jawt.dll" | select hash).hash)
        {
            "CORRECTO"
        }
    }
}
```
#### Se puede crear una dll y modificar una función para comprobar que la integridad falla
* https://www.jesusninoc.com/11/26/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-ejecute-un-cmdlet-de-powershell/
* https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/
* https://www.jesusninoc.com/04/21/obtener-los-nombres-de-las-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell-explicacion-paso-a-paso-del-script/

### En Linux
https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

## 3. Puedes saber qué fichero DLL están funcionando en el equipo utilizando la red
```PowerShell
(Get-Process -ComputerName .).Modules
(Get-Process -ComputerName .).Modules | where ModuleName -eq  sxs.dll
```

## 4. Detectar que una aplicación tiene tráfico de red (filtro por puerto)
### Tshark Command Examples
https://linuxsimba.com/tshark-examples

```PowerShell
$filterUDP = ''
$filterTCP = ''
ps | where ProcessName -eq 'chrome' | %{
    Get-NetUDPEndpoint | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterUDP = $filterUDP+'(udp.port == '+$_.LocalPort+') or'
    }
    
    Get-NetTCPConnection | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterTCP = $filterTCP+'(tcp.port == '+$_.LocalPort+') or'
    }
    
    
}
$filterUDP = $filterUDP.substring(0, $filterUDP.Length-3)
$filterTCP = $filterTCP.substring(0, $filterTCP.Length-3)

$filter = $filterUDP+' or '+$filterTCP

net use \\192.168.104.129\Prueba-share-samba /user:root 1234

.\tshark.exe -i 'ethernet 2' -Y $filter > \\192.168.104.129\Prueba-share-samba\test.txt
```

-----------------

# Modelo 2

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web periódico

### Eres el nuevo administrador de sistemas del diario el Universo. El diario funciona así: los periodistas sus ficheros HTML a sus carpetas en la red mediante un interfaz web (una Intranet). Cada periodista ve sus propios ficheros y no ve los de sus compañeros. Por ejemplo: Juan crea la página 1 del periódico y sube dicha página al servidor web.

## Resuelve lo siguiente:
1) Junta todas las páginas del periódico de todos los periodistas.
```PowerShell
mkdir usuario1; cd usuario1
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina1.html
cd ..
mkdir usuario2; cd usuario2
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina2.html
cd ..

ls *.html -recurse | %{
    $periodidcocomp = $periodidcocomp + (gc $_)
}

$periodidcocomp | out-file periodicocompleto.html
```
2) Haz copias de seguridad para diferentes momentos del día y al final del día haz copia de todo el periódico completo.
```PowerShell
(Get-Date).ToString("yyyyMMddhh")

$fecha = (Get-Date).ToString("yyyyMMddhh")
mkdir ($fecha) -force
cd $fecha

ls *.html -recurse | %{
    copy $_ $fecha
}
```
3) Incidencia. Alguien ha mandado imprimir el periódico entero. Tienes que pararlo porque no es el momento de imprimirlo.
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
#$perio = gc .\periodicocompleto.html
$b=[Text.Encoding]::ASCII.GetBytes("gc perio.html | out-printer")
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
##Server
while(1)
{
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
if([Text.Encoding]::ASCII.GetString($content) | select-string "print")
{
    "ha mandado imprimir"
}
}
```
4) Opcional. El periódico automático. Crear cada página HTML utilizando una base de datos
* https://www.jesusninoc.com/09/20/crear-un-fichero-html-con-el-contenido-de-la-tabla-posts-de-wordpress-con-powershell/

-----------------

# Modelo 3

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
- Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
```PowerShell
Get-EventLog -LogName security | select Message | select-string "\\localhost\ejemplo"
```
- Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
    - https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/
    - https://www.jesusninoc.com/03/12/select-files-between-two-dates-and-copy-them/
  - Dejar programada la acción.
    - https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
  - Comprimir y descomprimir
    - https://www.jesusninoc.com/03/15/create-new-compress-archive-file/
    - https://www.jesusninoc.com/02/14/descomprimir-archivos/
  - Cifrar el contenido, método sencillo o complicado.
    - https://www.jesusninoc.com/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación
  - Funciones simples y complejas
```PowerShell
##########################
# Funciones simples
##########################
function crearestructura()
{
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force

    $fecha = (Get-Date).ToString("yyyyMMdd")
    cd copia
    mkdir ($fecha) -force
}

crearestructura

function copiararchivos()
{
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha -force
    }
}

copiararchivos

function recuperar
{
  param($fichero)
  begin
  {
  }
  process
  {
    Expand-Archive -LiteralPath $fichero -DestinationPath desco\
  }
  end
  {
  }
}

recuperar .\comprimido.zip

##############################################################################

##########################
# Función compleja
##########################
function copiaseguridad
{
  param()
  begin
  {
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force
    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir copia\$fecha -force
  }
  process
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha\ -force
    }
  }
  end
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls copia\$fecha
    Compress-Archive -LiteralPath copia\$fecha –CompressionLevel Optimal -DestinationPath comprimido.zip -Force
  }
}
copiaseguridad
```
- Se ha producido una infección en un sistema operativo Windows,
  - ¿qué elementos comprobarías para detectar dicha infección?
      - https://www.jesusninoc.com/07/11/analisis-de-procesos-y-conexiones-de-red-con-powershell/
  - ¿cómo impides que se produzcan infecciones el sistema operativo?
  - ¿Windows dispone de herramientas centralizadas para evitarlo?

```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```
  
- Explica todo el proceso para realizar una clonación.
- Explica todo lo que sepas sobre permisos en Windows.
- ¿Cómo puedes hacer una sincronización en Linux?, ¿puedes hacerla entre equipos?, ¿cómo?
- ¿Un driver falla, qué haces para arrancar el sistema?
- ¿Un componente gráfico, qué haces para arrancar el sistema?
- Se puede lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
- Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
    - https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
- Explica para qué sirven las auditoría y qué relación tiene con los permisos.
- ¿Qué hace el siguiente script? (explica en detalle el código)
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

-----------------

# Modelo 4

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 5

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 6


## Explicar y realizar un script para cada una de las siguientes situaciones:

1. Cómo puedes saber quién accede a una carpeta compartida en Linux.
2. Realiza un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
    - Windows o Linux.
    - Dejar programada la acción.
    - Cifrar el contenido, método sencillo o complicado.
    - Dejar la carpeta oculta, comando attrib.
    - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
3. Puedes explicar algún sistema distribuido que relacione las cosas que hemos visto en clase.
4. ¿Cómo puedes hacer una sincronización en Linux?, ¿cómo?
5. Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?

## Ayuda
### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS)
https://www.jesusninoc.com/06/04/listar-procesos-de-powershell-con-node-powershell-nodejs/

### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS) Y MOSTRARLOS EN UNA WEB CON EXPRESS
https://www.jesusninoc.com/07/15/listar-procesos-de-powershell-con-node-powershell-node-js-y-mostrarlos-en-una-web-con-express/

### Ejemplo de NODE.JS (Crear una página web con información sobre cada equipo)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()
 
let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('$ComputerSystem=Get-WmiObject Win32_ComputerSystem;$BaseBoard=Get-WmiObject Win32_BaseBoard;$BIOS=Get-WmiObject Win32_BIOS;$Processor=Get-WmiObject Win32_Processor;[PSCustomObject]@{ Model = $ComputerSystem.Model; ManufacturerBoard = $BaseBoard.Manufacturer; BIOSVersion = $BIOS.SMbiosbiosversion; BIOSSerialNumber = $BIOS.serialnumber; ManufacturerProcessor=$Processor.Manufacturer; MaxClockSpeed=$Processor.MaxClockSpeed} | ConvertTo-Html')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});
 
app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

### Ejemplo de NODE.JS (Crear una página web con información sobre procesos)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()

let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('Get-Process | ConvertTo-Html -Property Name, Path, Company')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/procesos', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});

let ps2 = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps2.addCommand('Get-Service | ConvertTo-Html -Property Name, Path, Company')
ps2.invoke()
.then(output => {
  console.log(output);
  app.get('/servicios', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps2.dispose();
});

app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

------------
------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------

# PCAP (container of PCAP captures mapped to the relevant attack tactic)
* https://github.com/sbousseaden/PCAP-ATTACK

--------------------

# USB
## USBPcap – USB Packet capture for Windows
https://www.jesusninoc.com/2016/05/01/usbpcap-usb-packet-capture-for-windows/
## Wireshark and USB
https://isc.sans.edu/forums/diary/Wireshark+and+USB/23457/
## Hackers exploit casino's smart thermometer to steal database info
https://mashable.com/2018/04/15/casino-smart-thermometer-hacked/
## Logran robar datos de un ordenador a través del cableado eléctrico
https://www.redeszone.net/2018/04/13/logran-robar-datos-ordenador-traves-del-cableado-electrico/

----------
----------

# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Rendimiento del hardware
* https://www.jesusninoc.com/02/27/obtener-un-informe-detallado-del-consumo-de-la-bateria-en-windows-desde-powershell/

---------
---------

# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Casos de introducción
## - Preparar un equipo
* https://www.jesusninoc.com/04/22/instalacion-de-sistemas-operativos/
## - Analizar licencias
* https://www.jesusninoc.com/12/02/obtener-serial-de-windows-con-powershell/
## - Administración remota
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-01-16.md
## - Inventario
* https://www.jesusninoc.com/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/
## - Reemplazar espacios en fichero JPG
## - Detectar un problema de red
## - Detectar en los logs que hay intentos de obtener el fichero passwd
* https://www.jesusninoc.com/05/08/consulta-para-ver-intentos-de-obtener-el-fichero-passwd/
### Solución con una query
```PowerShell
.\LogParser.exe "SELECT * FROM 'C:\xampp\apache\logs\access.log' where text like '%passwd%'"
```

------------
------------

# Introducción al examen liberatorio

## Opción 1

### El departamento de recursos humanos envía el siguiente fichero...
```
nombre;apellido;password;grupo;ou;appbloqueada
juan;sinmiedo;P@ss1wordA;asir;asir;notepad
laura;valiente;P@ss1wordA;af;af;mspaint
```

#### - Nivel 1: crear un script que permita realizar todas las tareas que aparecen en el fichero.
#### - Nivel 2: crear un script que permita realizar las operaciones de forma ordenada.
#### - Nivel 3: crear un script que permita realizar las operaciones utilizando UDP.

## Opción 2

### Crear la estructura de red del Centro leyendo de un fichero, teniendo en cuenta:
- Hay seis grupos de clases, seis unidades organizativas
- Hay que crear usuarios y grupos para cada clase
- Hay que deshabilitar usuarios y moverlos a la unidad organizativa de los deshabilitados
- Borrar unidades organizativas
- Crear una carpeta para cada usuario

------------
------------

# Trabajo para optar al 10 y a MH
### Utilizando sockets comunicar un cliente con un servidor y aplicar el mayor número de conceptos vistos durante el curso:
- Crear una herramienta de control remoto.
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

--------------

## Ayuda
### Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

## Ayuda avanzada
### Pedir el nombre de un proceso y mostrar información del proceso mediante PowerShell con Node-PowerShell, EJS (Embedded JavaScript), Body-parser y Express
https://www.jesusninoc.com/2018/06/10/pedir-el-nombre-de-un-proceso-y-mostrar-informacion-del-proceso-mediante-powershell-con-node-powershell-ejs-body-parser-y-express-node-js/

### Build a Weather Website in 30 minutes with Node.js + Express + OpenWeather
https://codeburst.io/build-a-weather-website-in-30-minutes-with-node-js-express-openweather-a317f904897b

--------------

## Ejemplo de trabajo

### Realizar operaciones en un equipo remoto

```PowerShell
cls
write-host "Ip del ordenador remoto"
$ipR=read-host

##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('cls')"
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

while (1)
{

cls

Write-Host "Seleccione una opcion"

echo "1 - Sistema de archivos"
echo "2 - Agregar/eliminar software"
echo "3 - Actualizacion"
echo "4 - Gestion de procesos"
echo "5 - Programacion de tareas"
echo "6 - Gestion de usuarios"
echo "7 - Gestion de almacenamiento"
echo "8 - Gestion de red"
echo "9 - Copias de seguridad"
echo "10 - Reparacion del sistema"
echo "11 - Rendimiento del sistema"
echo "12 - Salir"

$prue1 = Read-Host
switch ( $prue1 )
    {
        1{
            cls
            Write-Host "Seleccione una opcion"
            echo "1 - Listar"
            echo "2 - Crear"
            echo "3 - Abrir"
            echo "4 - Eliminar"
            $selcec=Read-Host
            switch ( $selcec )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=[Text.Encoding]::ASCII.GetBytes('Get-ChildItem')
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                2{
                    $type=Read-Host "Escriba que tipo desea crear (File o Directory)"
                    $name=Read-Host "Escriba el nombre del $type"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Item -ItemType $type -Name $name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                3{
                    $name1=Read-Host "Nombre del archivo que desea abrir"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('start $name1')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                4{
                    ls
                    $name2=Read-Host "¿Qué desea eliminar?"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-Item $name2')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }                   
        }
        2{
            cls
            $nombre=Read-Host "Introduzca nombre del .msi que desee instalar"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('msiexec.exe /package C:\windows\Installer\($nombre)')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        Pause
        }
        3{
            cls
            echo "1 - Instalar"
            echo "2 - Desinstalar"
            Write-Host "Seleccione una opción"
            $actuali=Read-Host
            switch ($actuali)
            {
                1{
                    Write-Host "Como desea que se realize"
                    echo "1 - Normal"
                    echo "2 - En silencio"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            Write-Host "Escriba el nombre de la actualizacion"
                            $nombre=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                           
                        }
                        2{
                            Write-Host "Eliga la opción desea"
                            echo "1 - No reiniciarse al terminar"
                            echo "2 - Pedir confirmación antes de reiniciar"
                            echo "3 - Obligar a que se cierren todas las aplicaciones y se reinicie"
                            $Smodo=Read-Host
                            $Nombre=Read-Host
                            switch($Smodo)
                            {
                                1{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()
                                    
                                }
                                2{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /warnrestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                                3{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /forcerestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                            }
                        }
                    }
                }
                2{
                    cls
                    echo "1 - Normal"
                    echo "2 - Paquete asociado con el número de actualización"
                    Write-Host "Seleccione una opción"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                        2{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall /kb')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                    }
            }
            }
            puase
        }
        4{
            cls
            echo "1 - Iniciar un proceso"
            echo "2 - Mostrar solo Nombres"
            echo "3 - Mostrar proceso de cierto programa"

            $sele=Read-Host
            switch ( $sele )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                } 
                2 {
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | select Name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3 {
                    $selprog=Read-Host "Escriba el nombre del programa"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | Select-String $selprog')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
        5{
            cls
            $program=Read-Host "que programa desea abrir"
            $time=Read-Host "a que hora"
            $nomre=Read-Host "escriba el nombre de la tarea"
            $action=New-ScheduledTaskAction -Execute $program
            $trigger=New-ScheduledTaskTrigger -Daily -At $time
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Register-ScheduledTask -Action $action -Trigger $trigger -TaskName $nomre')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()           
            Pause
            
        }
        6{
            cls
            echo "1 - Crear usuario"
            echo "2 - Eliminar usuario"
            echo "3 - Crear grupo"
            echo "4 - Ver miembros de un grupo"
            echo "5 - Eliminar grupo"
            $opcion=Read-Host "Eliga una opcion"
            switch ($opcion)
            {
            1{
                $nameuser=Read-Host "Nomre del nuevo usuario"
                $pass=Read-Host "Introduzca contraseña"
                $pass1=ConvertTo-SecureString $pass -asplaintext -force
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalUser $nameuser -Password $pass1')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            2{
                $usuer=Read-Host "Nombre del usuario"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-LocalUser -Name $usuer')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            3{
                $group=Read-Host "Nombre para el grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalGroup -Name $group')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            4{
                $Ngroup=Read-Host "Nombre del grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Ngroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            5{
                $Rgroup=Read-Host "Nombre del grupo que vaya a eliminar"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Rgroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            }
        }
        7{
            cls
            echo "1 - Particionar"
            echo "2 - Desfragmentar"
            echo "3 - Convertir sistemas de archivo"
            echo "4 - Cifrar"
            echo "5 - Descifrar"
            Write-Host  "Seleccione una opción"
            $almacenamiento=Read-Host
            switch ($almacenamiento)
            {
                1{
                    Write-Host "ADVERTENCIA: Nunca poner el numero '0'"
                    $NumeroD=Read-Host "Introduzca número del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Partition -DiskNumber $NumeroD -UseMaximumSize -AssignDriveLetter')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    $letra=Read-Host "Letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Optimize-Volume $letra -Defrag')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Disable-BitLocker 
                    Pause
                }
                3{
                    $letra=Read-Host "Letra del disco"
                    $tipo=Read-Host "Que formato desea"                    
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Format-Volume -DriveLetter $letra -FileSystem $tipo')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                4{
                    $letra=Read-Host "Inroduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Enable-BitLocker -MountPoint $letra -RecoveryPasswordProtector -UsedSpaceOnly -Verbose')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                5{
                    $letra=Read-Host "Introduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Disable-BitLocker -MountPoint $letra')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
            }
              
        }
        }
        8{
            cls
            echo "1 - Saber ip"
            echo "2 - Hacer ping"
            $op=Read-Host "Seleccione una opcion"
            Switch ( $op )
            {
            1{
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ipconfig')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            2{
                $ip=Read-Host "Introduzca IPv4"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ping $ip')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            }
        }
        9{
            cls
            Write-Host "Se recomienda que ponga la ruta y para quedarsela usted la meta en una carpeta compartida"
            $namea=Read-Host "Nombre del archivo que desea hacer copia de seguridad"
            $ruta=Read-Host "Ruta donde desea que este la copia de seguridad"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Copy-Item $namea $ruta')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()            
            Pause
        }
        10{
            cls
            Write-Host "Seleccione una opción"
            echo "1 - Ver puntos de restauracion"
            echo "2 - Restaurar un punto"
            $opcion=Read-Host
            switch ($opcion)
            {
                1{        
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                }
                2{
                    Write-Host "Seleccione una opción"
                    echo "1 - Ultimo punto"
                    echo "2 - Restaura cierto punto"
                    $opcion=Read-Host
                    switch ($opcion)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint -LastStatus')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }

                        2{
                            Write-Host "Ponga el numero de restauración"
                            $punto=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Restore-Computer -RestorePoint $punto')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()                   
                        }
                    }
                }
            }
            Pause
        }
        11{
            cls
            echo "1 - Monitorizar procesos"
            echo "2 - Monitorizar procesos Avanzado"
            echo "3 - Ver todos los nombres de los contadores de rendimiento"
            $seleccionar=Read-Host "Seleccione una opción"
            switch ( $seleccionar )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port
                    )
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Counter -ListSet * | Sort-Object CounterSetName | Format-Table CounterSetName')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
}
if( $prue1 -eq "12" )
        {
            cls
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('break')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            break
        }
}
```

-----------
-----------

# Modelos de examen de la asignatura de Implantación de Sistemas Operativos (ISO) de 1º de Administración de Sistemas Informáticos en Red (ASIR) tercera evaluación
- Modelo 1 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-1
- Modelo 2 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-2
- Modelo 3 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-3
- Modelo 4 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-4
- Modelo 5 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-5
- Modelo 6 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-6

-----------------

# Modelo 1

## Tener en cuenta:
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## 1. Analizar ficheros DLL en todos los equipos de la red
```PowerShell
123..125 | %{"192.168.104." + $_}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
$ruta
}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.jes"
ls $ruta
}

1..40 |  %{Invoke-Command -ComputerName ("192.168.204." + $_) -ScriptBlock {hostname}}

Invoke-Command -ComputerName dc1 -ScriptBlock {hostname}

gc .\equipos1.txt | % {
    $llistar="\\"+$_+"\c$"
    ls $llistar | select name,FullName
} | Group-Object name | select Count,Group | where count -eq 1
```
### Enable and Use Remote Commands in Windows PowerShell
https://technet.microsoft.com/en-us/library/ff700227.aspx
### How to Add a Computer to the TrustedHosts List
```PowerShell
set-item wsman:\localhost\Client\TrustedHosts -value "ABANTO"
```
### Listar funciones exportadas de un archivo DLL con DUMPBIN desde PowerShell
https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/

## 2. Analizar ficheros DLL en todos los equipos de la red, comprobar que ha cambiado una integridad y copiar el fichero que ha cambiado
### En PowerShell
```PowerShell
mkdir dlls

cd dlls

"dll1" | Out-File dll1.dll
"dll2" | Out-File dll2.dll

# Recorrrer una a una dll
ls *.dll | %{$_}

# Hacer hash de cada dll
ls *.dll | %{Get-FileHash $_.FullName | Select-Object Hash}

# Hacer hash de cada dll ruta por red
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path}

# Guardar hash
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path | Out-File listado.txt -Append}

# Ver listado
gc .\listado.txt

# Modificar dll y detectar el cambio, después mover la dll, solución: el hash de cada dll no se encuentra en el fichero listado.txt, eso quiere decir que se ha modificado y hay que copiar a la carpeta compartida en Linux
# Modificar dll
"dll6" | Out-File dll1.dll

ls '\\localhost\c$\Users\juan\dlls' *.dll | %{
    if((gc .\listado.txt) -match (Get-FileHash $_.FullName | Select-Object Hash).hash)
    {
    }
    else
    {
        $_.Name
        "Dll se ha modificado"
    }
}


# Meter el código anterior en el recorrido que cada alumno tenga
123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
ls $ruta -recurse
}

# Almacenar el hash de la dll para todos los equipos de la red
foreach($equipo in gc .\equipos1.txt) {
    $llistar="\\"+$equipo+"\c$"
    ls $llistar -recurse *.dll | %{
        $valorse = Get-FileHash ($_ | select FullName).FullName
        $valorse.path+"|"+$valorse.Hash | Out-File hasehees.txt
    }
}

# Verificar si una dll no ha cambiado su hash
gc .\hasehees.txt | %{
    if($_.split("|")[0].contains("jawt.dll"))
    {
        if($_.split("|")[1] -eq (Get-FileHash "\\ABANTOS21\c$\Cache\pc-client.exe-16.3.0.37857\runtime\jre\bin\jawt.dll" | select hash).hash)
        {
            "CORRECTO"
        }
    }
}
```
#### Se puede crear una dll y modificar una función para comprobar que la integridad falla
* https://www.jesusninoc.com/11/26/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-ejecute-un-cmdlet-de-powershell/
* https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/
* https://www.jesusninoc.com/04/21/obtener-los-nombres-de-las-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell-explicacion-paso-a-paso-del-script/

### En Linux
https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

## 3. Puedes saber qué fichero DLL están funcionando en el equipo utilizando la red
```PowerShell
(Get-Process -ComputerName .).Modules
(Get-Process -ComputerName .).Modules | where ModuleName -eq  sxs.dll
```

## 4. Detectar que una aplicación tiene tráfico de red (filtro por puerto)
### Tshark Command Examples
https://linuxsimba.com/tshark-examples

```PowerShell
$filterUDP = ''
$filterTCP = ''
ps | where ProcessName -eq 'chrome' | %{
    Get-NetUDPEndpoint | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterUDP = $filterUDP+'(udp.port == '+$_.LocalPort+') or'
    }
    
    Get-NetTCPConnection | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterTCP = $filterTCP+'(tcp.port == '+$_.LocalPort+') or'
    }
    
    
}
$filterUDP = $filterUDP.substring(0, $filterUDP.Length-3)
$filterTCP = $filterTCP.substring(0, $filterTCP.Length-3)

$filter = $filterUDP+' or '+$filterTCP

net use \\192.168.104.129\Prueba-share-samba /user:root 1234

.\tshark.exe -i 'ethernet 2' -Y $filter > \\192.168.104.129\Prueba-share-samba\test.txt
```

------------
------------

# Modelo 2

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web periódico

### Eres el nuevo administrador de sistemas del diario el Universo. El diario funciona así: los periodistas crean sus ficheros HTML en sus carpetas en la red mediante un interfaz web (una Intranet). Cada periodista ve sus propios ficheros y no ve los de sus compañeros. Por ejemplo: Juan crea la página 1 del periódico y sube dicha página al servidor web.

## Resuelve lo siguiente:
1) Junta todas las páginas del periódico de todos los periodistas.
```PowerShell
mkdir usuario1; cd usuario1
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina1.html
cd ..
mkdir usuario2; cd usuario2
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina2.html
cd ..

ls *.html -recurse | %{
    $periodidcocomp = $periodidcocomp + (gc $_)
}

$periodidcocomp | out-file periodicocompleto.html
```
2) Haz copias de seguridad para diferentes momentos del día y al final del día haz copia de todo el periódico completo.
```PowerShell
(Get-Date).ToString("yyyyMMddhh")

$fecha = (Get-Date).ToString("yyyyMMddhh")
mkdir ($fecha) -force
cd $fecha

ls *.html -recurse | %{
    copy $_ $fecha
}
```
3) Incidencia. Alguien ha mandado imprimir el periódico entero. Tienes que pararlo porque no es el momento de imprimirlo.
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
#$perio = gc .\periodicocompleto.html
$b=[Text.Encoding]::ASCII.GetBytes("gc perio.html | out-printer")
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
##Server
while(1)
{
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
if([Text.Encoding]::ASCII.GetString($content) | select-string "print")
{
    "ha mandado imprimir"
}
}
```
4) Opcional. El periódico automático. Crear cada página HTML utilizando una base de datos
* https://www.jesusninoc.com/09/20/crear-un-fichero-html-con-el-contenido-de-la-tabla-posts-de-wordpress-con-powershell/

-----------------

# Modelo 3

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
- Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
```PowerShell
Get-EventLog -LogName security | select Message | select-string "\\localhost\ejemplo"
```
- Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
    - https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/
    - https://www.jesusninoc.com/03/12/select-files-between-two-dates-and-copy-them/
  - Dejar programada la acción.
    - https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
  - Comprimir y descomprimir
    - https://www.jesusninoc.com/03/15/create-new-compress-archive-file/
    - https://www.jesusninoc.com/02/14/descomprimir-archivos/
  - Cifrar el contenido, método sencillo o complicado.
    - https://www.jesusninoc.com/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación
  - Funciones simples y complejas
```PowerShell
##########################
# Funciones simples
##########################
function crearestructura()
{
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force

    $fecha = (Get-Date).ToString("yyyyMMdd")
    cd copia
    mkdir ($fecha) -force
}

crearestructura

function copiararchivos()
{
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha -force
    }
}

copiararchivos

function recuperar
{
  param($fichero)
  begin
  {
  }
  process
  {
    Expand-Archive -LiteralPath $fichero -DestinationPath desco\
  }
  end
  {
  }
}

recuperar .\comprimido.zip

##############################################################################

##########################
# Función compleja
##########################
function copiaseguridad
{
  param()
  begin
  {
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force
    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir copia\$fecha -force
  }
  process
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha\ -force
    }
  }
  end
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls copia\$fecha
    Compress-Archive -LiteralPath copia\$fecha –CompressionLevel Optimal -DestinationPath comprimido.zip -Force
  }
}
copiaseguridad
```
- Se ha producido una infección en un sistema operativo Windows,
  - ¿qué elementos comprobarías para detectar dicha infección?
      - https://www.jesusninoc.com/07/11/analisis-de-procesos-y-conexiones-de-red-con-powershell/
  - ¿cómo impides que se produzcan infecciones el sistema operativo?
  - ¿Windows dispone de herramientas centralizadas para evitarlo?

```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```
  
- Explica todo el proceso para realizar una clonación.
- Explica todo lo que sepas sobre permisos en Windows.
- ¿Cómo puedes hacer una sincronización en Linux?, ¿puedes hacerla entre equipos?, ¿cómo?
- ¿Un driver falla, qué haces para arrancar el sistema?
- ¿Un componente gráfico, qué haces para arrancar el sistema?
- Se puede lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
- Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
    - https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
- Explica para qué sirven las auditoría y qué relación tiene con los permisos.
- ¿Qué hace el siguiente script? (explica en detalle el código)
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

-----------------

# Modelo 4

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 5

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 6


## Explicar y realizar un script para cada una de las siguientes situaciones:

1. Cómo puedes saber quién accede a una carpeta compartida en Linux.
2. Realiza un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
    - Windows o Linux.
    - Dejar programada la acción.
    - Cifrar el contenido, método sencillo o complicado.
    - Dejar la carpeta oculta, comando attrib.
    - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
3. Puedes explicar algún sistema distribuido que relacione las cosas que hemos visto en clase.
4. ¿Cómo puedes hacer una sincronización en Linux?, ¿cómo?
5. Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?

## Ayuda
### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS)
https://www.jesusninoc.com/06/04/listar-procesos-de-powershell-con-node-powershell-nodejs/

### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS) Y MOSTRARLOS EN UNA WEB CON EXPRESS
https://www.jesusninoc.com/07/15/listar-procesos-de-powershell-con-node-powershell-node-js-y-mostrarlos-en-una-web-con-express/

### Ejemplo de NODE.JS (Crear una página web con información sobre cada equipo)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()
 
let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('$ComputerSystem=Get-WmiObject Win32_ComputerSystem;$BaseBoard=Get-WmiObject Win32_BaseBoard;$BIOS=Get-WmiObject Win32_BIOS;$Processor=Get-WmiObject Win32_Processor;[PSCustomObject]@{ Model = $ComputerSystem.Model; ManufacturerBoard = $BaseBoard.Manufacturer; BIOSVersion = $BIOS.SMbiosbiosversion; BIOSSerialNumber = $BIOS.serialnumber; ManufacturerProcessor=$Processor.Manufacturer; MaxClockSpeed=$Processor.MaxClockSpeed} | ConvertTo-Html')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});
 
app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

### Ejemplo de NODE.JS (Crear una página web con información sobre procesos)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()

let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('Get-Process | ConvertTo-Html -Property Name, Path, Company')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/procesos', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});

let ps2 = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps2.addCommand('Get-Service | ConvertTo-Html -Property Name, Path, Company')
ps2.invoke()
.then(output => {
  console.log(output);
  app.get('/servicios', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps2.dispose();
});

app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

------------
------------

# Examen liberatorio

- El proceso que más consume tiene un cambio de integridad, crear una función que realiza dicha comprobación.
- Crear un log de sistema cuando hay un cambio de integridad.
- Un software que se va a instalar tiene un ejecutable cuya integridad es errónea.
- Detectar que un equipo no se ha añadido a un Dominio.
- Mostrar un objeto con toda la información de todos los elementos que hay en un Directorio Activo.
- Detectar cómo se ha propagado un virus en carpetas compartidas generando una entrada en un log del sistema.
- Comprobar que ha cambiado un permiso utlizando auditoría.
- Mostrar un mensaje si el tamaño de una carpeta compatida supera el 80%.
- Crear una entrada en un registro del visor de eventos si hay un intento de acceso a un puerto que está cerrado.

------------
------------

# Correción examen liberatorio

- El proceso que más consume tiene un cambio de integridad, crear una función que realiza dicha comprobación.
```PowerShell
(Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash | Out-File inte.txt

$resultado = (Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash
if((Get-Content .\inte.txt) -eq $resultado)
{
    "es igual"
}
else
{
    "no es igual"
}
```
- Crear un log de sistema cuando hay un cambio de integridad.
```PowerShell
(Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash | Out-File inte.txt

function comprobar ($integridadbuena)
{
    $resultado = (Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash
    if($integridadbuena -eq $resultado)
    {
        "es igual"
    }
    else
    {
       Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" 
       -EventID 916 -EntryType Information -Message "Cambio integridad" 
       -Category 2 -RawData 10,20
    }
}

comprobar (Get-Content .\inte.txt)
```
- Un software que se va a instalar tiene un ejecutable cuya integridad es errónea.
```PowerShell
foreach($programa in ls "C:\Program Files (x86)\Cisco Packet Tracer 6.1.1sv\bin\*.exe")
{
    (Get-FileHash $programa).path+","+(Get-FileHash $programa).hash | Out-File resultahas.txt -Append
}
```
- Detectar que un equipo no se ha añadido a un Dominio.
```PowerShell
$equipo = ""

function comprobar ($equipo)
{
    $ComputerName = $env:COMPUTERNAME
    $computer = [ADSI]"WinNT://$($ComputerName),computer"
    foreach($equipito in $computer)
    {
        if($equipito.Path -match $equipo)
        {
            "es igual"
        }
    }
}

comprobar FP_LHR_19
```
- Mostrar un objeto con toda la información de todos los elementos que hay en un Directorio Activo.
```PowerShell
[PSCustomObject]@{
 usuarios = Get-LocalUser
 grupos = Get-LocalGroup
}
```
- Detectar cómo se ha propagado un virus en carpetas compartidas generando una entrada en un log del sistema.
- Comprobar que ha cambiado un permiso utlizando auditoría.
- Mostrar un mensaje si el tamaño de una carpeta compatida supera el 80%.
```PowerShell
$total = 100

if((Get-ChildItem C:\Users\adminfp\Desktop\fallo | Measure-Object Length -Sum).Sum -lt $total*0.8)
{
    "menor"
}
```
- Crear una entrada en un registro del visor de eventos si hay un intento de acceso a un puerto que está cerrado.

------------------
------------------

# Examen liberatorio

- Leer fichero
- Clasificación de informes

------------
------------

# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Casos de introducción
## - Preparar un equipo
* https://www.jesusninoc.com/04/22/instalacion-de-sistemas-operativos/
## - Analizar licencias
* https://www.jesusninoc.com/12/02/obtener-serial-de-windows-con-powershell/
## - Administración remota
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-01-16.md
## - Inventario
* https://www.jesusninoc.com/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/
## - Batería
* https://www.jesusninoc.com/02/27/obtener-un-informe-detallado-del-consumo-de-la-bateria-en-windows-desde-powershell/
## - Reemplazar espacios en fichero JPG
## - Detectar un problema de red
## - Detectar en los logs que hay intentos de obtener el fichero passwd
* https://www.jesusninoc.com/05/08/consulta-para-ver-intentos-de-obtener-el-fichero-passwd/
### Solución con una query
```PowerShell
.\LogParser.exe "SELECT * FROM 'C:\xampp\apache\logs\access.log' where text like '%passwd%'"
```

------------------
------------------

# Introducción al examen final

## Opción 1

### El departamento de recursos humanos envía el siguiente fichero...
```
nombre;apellido;password;grupo;ou;appbloqueada
juan;sinmiedo;P@ss1wordA;asir;asir;notepad
laura;valiente;P@ss1wordA;af;af;mspaint
```

#### - Nivel 1: crear un script que permita realizar todas las tareas que aparecen en el fichero.
#### - Nivel 2: crear un script que permita realizar las operaciones de forma ordenada.
#### - Nivel 3: crear un script que permita realizar las operaciones utilizando UDP.

## Opción 2

### Crear la estructura de red del Centro leyendo de un fichero, teniendo en cuenta:
- Hay seis grupos de clases, seis unidades organizativas
- Hay que crear usuarios y grupos para cada clase
- Hay que deshabilitar usuarios y moverlos a la unidad organizativa de los deshabilitados
- Borrar unidades organizativas
- Crear una carpeta para cada usuario

------------
------------

# Trabajo para optar al 10 y a MH
### Utilizando sockets comunicar un cliente con un servidor y aplicar el mayor número de conceptos vistos durante el curso:
- Crear una herramienta de control remoto.
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

--------------

## Ayuda
### Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

## Ayuda avanzada
### Pedir el nombre de un proceso y mostrar información del proceso mediante PowerShell con Node-PowerShell, EJS (Embedded JavaScript), Body-parser y Express
https://www.jesusninoc.com/2018/06/10/pedir-el-nombre-de-un-proceso-y-mostrar-informacion-del-proceso-mediante-powershell-con-node-powershell-ejs-body-parser-y-express-node-js/

### Build a Weather Website in 30 minutes with Node.js + Express + OpenWeather
https://codeburst.io/build-a-weather-website-in-30-minutes-with-node-js-express-openweather-a317f904897b

--------------

## Ejemplo de trabajo

### Realizar operaciones en un equipo remoto

```PowerShell
cls
write-host "Ip del ordenador remoto"
$ipR=read-host

##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('cls')"
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

while (1)
{

cls

Write-Host "Seleccione una opcion"

echo "1 - Sistema de archivos"
echo "2 - Agregar/eliminar software"
echo "3 - Actualizacion"
echo "4 - Gestion de procesos"
echo "5 - Programacion de tareas"
echo "6 - Gestion de usuarios"
echo "7 - Gestion de almacenamiento"
echo "8 - Gestion de red"
echo "9 - Copias de seguridad"
echo "10 - Reparacion del sistema"
echo "11 - Rendimiento del sistema"
echo "12 - Salir"

$prue1 = Read-Host
switch ( $prue1 )
    {
        1{
            cls
            Write-Host "Seleccione una opcion"
            echo "1 - Listar"
            echo "2 - Crear"
            echo "3 - Abrir"
            echo "4 - Eliminar"
            $selcec=Read-Host
            switch ( $selcec )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=[Text.Encoding]::ASCII.GetBytes('Get-ChildItem')
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                2{
                    $type=Read-Host "Escriba que tipo desea crear (File o Directory)"
                    $name=Read-Host "Escriba el nombre del $type"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Item -ItemType $type -Name $name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                3{
                    $name1=Read-Host "Nombre del archivo que desea abrir"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('start $name1')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                4{
                    ls
                    $name2=Read-Host "¿Qué desea eliminar?"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-Item $name2')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }                   
        }
        2{
            cls
            $nombre=Read-Host "Introduzca nombre del .msi que desee instalar"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('msiexec.exe /package C:\windows\Installer\($nombre)')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        Pause
        }
        3{
            cls
            echo "1 - Instalar"
            echo "2 - Desinstalar"
            Write-Host "Seleccione una opción"
            $actuali=Read-Host
            switch ($actuali)
            {
                1{
                    Write-Host "Como desea que se realize"
                    echo "1 - Normal"
                    echo "2 - En silencio"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            Write-Host "Escriba el nombre de la actualizacion"
                            $nombre=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                           
                        }
                        2{
                            Write-Host "Eliga la opción desea"
                            echo "1 - No reiniciarse al terminar"
                            echo "2 - Pedir confirmación antes de reiniciar"
                            echo "3 - Obligar a que se cierren todas las aplicaciones y se reinicie"
                            $Smodo=Read-Host
                            $Nombre=Read-Host
                            switch($Smodo)
                            {
                                1{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()
                                    
                                }
                                2{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /warnrestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                                3{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /forcerestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                            }
                        }
                    }
                }
                2{
                    cls
                    echo "1 - Normal"
                    echo "2 - Paquete asociado con el número de actualización"
                    Write-Host "Seleccione una opción"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                        2{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall /kb')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                    }
            }
            }
            puase
        }
        4{
            cls
            echo "1 - Iniciar un proceso"
            echo "2 - Mostrar solo Nombres"
            echo "3 - Mostrar proceso de cierto programa"

            $sele=Read-Host
            switch ( $sele )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                } 
                2 {
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | select Name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3 {
                    $selprog=Read-Host "Escriba el nombre del programa"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | Select-String $selprog')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
        5{
            cls
            $program=Read-Host "que programa desea abrir"
            $time=Read-Host "a que hora"
            $nomre=Read-Host "escriba el nombre de la tarea"
            $action=New-ScheduledTaskAction -Execute $program
            $trigger=New-ScheduledTaskTrigger -Daily -At $time
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Register-ScheduledTask -Action $action -Trigger $trigger -TaskName $nomre')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()           
            Pause
            
        }
        6{
            cls
            echo "1 - Crear usuario"
            echo "2 - Eliminar usuario"
            echo "3 - Crear grupo"
            echo "4 - Ver miembros de un grupo"
            echo "5 - Eliminar grupo"
            $opcion=Read-Host "Eliga una opcion"
            switch ($opcion)
            {
            1{
                $nameuser=Read-Host "Nomre del nuevo usuario"
                $pass=Read-Host "Introduzca contraseña"
                $pass1=ConvertTo-SecureString $pass -asplaintext -force
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalUser $nameuser -Password $pass1')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            2{
                $usuer=Read-Host "Nombre del usuario"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-LocalUser -Name $usuer')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            3{
                $group=Read-Host "Nombre para el grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalGroup -Name $group')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            4{
                $Ngroup=Read-Host "Nombre del grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Ngroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            5{
                $Rgroup=Read-Host "Nombre del grupo que vaya a eliminar"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Rgroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            }
        }
        7{
            cls
            echo "1 - Particionar"
            echo "2 - Desfragmentar"
            echo "3 - Convertir sistemas de archivo"
            echo "4 - Cifrar"
            echo "5 - Descifrar"
            Write-Host  "Seleccione una opción"
            $almacenamiento=Read-Host
            switch ($almacenamiento)
            {
                1{
                    Write-Host "ADVERTENCIA: Nunca poner el numero '0'"
                    $NumeroD=Read-Host "Introduzca número del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Partition -DiskNumber $NumeroD -UseMaximumSize -AssignDriveLetter')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    $letra=Read-Host "Letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Optimize-Volume $letra -Defrag')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Disable-BitLocker 
                    Pause
                }
                3{
                    $letra=Read-Host "Letra del disco"
                    $tipo=Read-Host "Que formato desea"                    
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Format-Volume -DriveLetter $letra -FileSystem $tipo')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                4{
                    $letra=Read-Host "Inroduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Enable-BitLocker -MountPoint $letra -RecoveryPasswordProtector -UsedSpaceOnly -Verbose')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                5{
                    $letra=Read-Host "Introduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Disable-BitLocker -MountPoint $letra')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
            }
              
        }
        }
        8{
            cls
            echo "1 - Saber ip"
            echo "2 - Hacer ping"
            $op=Read-Host "Seleccione una opcion"
            Switch ( $op )
            {
            1{
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ipconfig')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            2{
                $ip=Read-Host "Introduzca IPv4"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ping $ip')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            }
        }
        9{
            cls
            Write-Host "Se recomienda que ponga la ruta y para quedarsela usted la meta en una carpeta compartida"
            $namea=Read-Host "Nombre del archivo que desea hacer copia de seguridad"
            $ruta=Read-Host "Ruta donde desea que este la copia de seguridad"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Copy-Item $namea $ruta')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()            
            Pause
        }
        10{
            cls
            Write-Host "Seleccione una opción"
            echo "1 - Ver puntos de restauracion"
            echo "2 - Restaurar un punto"
            $opcion=Read-Host
            switch ($opcion)
            {
                1{        
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                }
                2{
                    Write-Host "Seleccione una opción"
                    echo "1 - Ultimo punto"
                    echo "2 - Restaura cierto punto"
                    $opcion=Read-Host
                    switch ($opcion)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint -LastStatus')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }

                        2{
                            Write-Host "Ponga el numero de restauración"
                            $punto=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Restore-Computer -RestorePoint $punto')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()                   
                        }
                    }
                }
            }
            Pause
        }
        11{
            cls
            echo "1 - Monitorizar procesos"
            echo "2 - Monitorizar procesos Avanzado"
            echo "3 - Ver todos los nombres de los contadores de rendimiento"
            $seleccionar=Read-Host "Seleccione una opción"
            switch ( $seleccionar )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port
                    )
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Counter -ListSet * | Sort-Object CounterSetName | Format-Table CounterSetName')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
}
if( $prue1 -eq "12" )
        {
            cls
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('break')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            break
        }
}
```

-----------
-----------

# Modelos de examen de la asignatura de Implantación de Sistemas Operativos (ISO) de 1º de Administración de Sistemas Informáticos en Red (ASIR) tercera evaluación
- Modelo 1 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-1
- Modelo 2 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-2
- Modelo 3 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-3
- Modelo 4 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-4
- Modelo 5 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-5
- Modelo 6 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-6

-----------------

# Modelo 1

## Tener en cuenta:
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## 1. Analizar ficheros DLL en todos los equipos de la red
```PowerShell
123..125 | %{"192.168.104." + $_}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
$ruta
}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.jes"
ls $ruta
}

1..40 |  %{Invoke-Command -ComputerName ("192.168.204." + $_) -ScriptBlock {hostname}}

Invoke-Command -ComputerName dc1 -ScriptBlock {hostname}

gc .\equipos1.txt | % {
    $llistar="\\"+$_+"\c$"
    ls $llistar | select name,FullName
} | Group-Object name | select Count,Group | where count -eq 1
```
### Enable and Use Remote Commands in Windows PowerShell
https://technet.microsoft.com/en-us/library/ff700227.aspx
### How to Add a Computer to the TrustedHosts List
```PowerShell
set-item wsman:\localhost\Client\TrustedHosts -value "ABANTO"
```
### Listar funciones exportadas de un archivo DLL con DUMPBIN desde PowerShell
https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/

## 2. Analizar ficheros DLL en todos los equipos de la red, comprobar que ha cambiado una integridad y copiar el fichero que ha cambiado
### En PowerShell
```PowerShell
mkdir dlls

cd dlls

"dll1" | Out-File dll1.dll
"dll2" | Out-File dll2.dll

# Recorrrer una a una dll
ls *.dll | %{$_}

# Hacer hash de cada dll
ls *.dll | %{Get-FileHash $_.FullName | Select-Object Hash}

# Hacer hash de cada dll ruta por red
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path}

# Guardar hash
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path | Out-File listado.txt -Append}

# Ver listado
gc .\listado.txt

# Modificar dll y detectar el cambio, después mover la dll, solución: el hash de cada dll no se encuentra en el fichero listado.txt, eso quiere decir que se ha modificado y hay que copiar a la carpeta compartida en Linux
# Modificar dll
"dll6" | Out-File dll1.dll

ls '\\localhost\c$\Users\juan\dlls' *.dll | %{
    if((gc .\listado.txt) -match (Get-FileHash $_.FullName | Select-Object Hash).hash)
    {
    }
    else
    {
        $_.Name
        "Dll se ha modificado"
    }
}


# Meter el código anterior en el recorrido que cada alumno tenga
123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
ls $ruta -recurse
}

# Almacenar el hash de la dll para todos los equipos de la red
foreach($equipo in gc .\equipos1.txt) {
    $llistar="\\"+$equipo+"\c$"
    ls $llistar -recurse *.dll | %{
        $valorse = Get-FileHash ($_ | select FullName).FullName
        $valorse.path+"|"+$valorse.Hash | Out-File hasehees.txt
    }
}

# Verificar si una dll no ha cambiado su hash
gc .\hasehees.txt | %{
    if($_.split("|")[0].contains("jawt.dll"))
    {
        if($_.split("|")[1] -eq (Get-FileHash "\\ABANTOS21\c$\Cache\pc-client.exe-16.3.0.37857\runtime\jre\bin\jawt.dll" | select hash).hash)
        {
            "CORRECTO"
        }
    }
}
```
#### Se puede crear una dll y modificar una función para comprobar que la integridad falla
* https://www.jesusninoc.com/11/26/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-ejecute-un-cmdlet-de-powershell/
* https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/
* https://www.jesusninoc.com/04/21/obtener-los-nombres-de-las-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell-explicacion-paso-a-paso-del-script/

### En Linux
https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

## 3. Puedes saber qué fichero DLL están funcionando en el equipo utilizando la red
```PowerShell
(Get-Process -ComputerName .).Modules
(Get-Process -ComputerName .).Modules | where ModuleName -eq  sxs.dll
```

## 4. Detectar que una aplicación tiene tráfico de red (filtro por puerto)
### Tshark Command Examples
https://linuxsimba.com/tshark-examples

```PowerShell
$filterUDP = ''
$filterTCP = ''
ps | where ProcessName -eq 'chrome' | %{
    Get-NetUDPEndpoint | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterUDP = $filterUDP+'(udp.port == '+$_.LocalPort+') or'
    }
    
    Get-NetTCPConnection | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterTCP = $filterTCP+'(tcp.port == '+$_.LocalPort+') or'
    }
    
    
}
$filterUDP = $filterUDP.substring(0, $filterUDP.Length-3)
$filterTCP = $filterTCP.substring(0, $filterTCP.Length-3)

$filter = $filterUDP+' or '+$filterTCP

net use \\192.168.104.129\Prueba-share-samba /user:root 1234

.\tshark.exe -i 'ethernet 2' -Y $filter > \\192.168.104.129\Prueba-share-samba\test.txt
```

-----------------

# Modelo 2

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web periódico

### Eres el nuevo administrador de sistemas del diario el Universo. El diario funciona así: los periodistas sus ficheros HTML a sus carpetas en la red mediante un interfaz web (una Intranet). Cada periodista ve sus propios ficheros y no ve los de sus compañeros. Por ejemplo: Juan crea la página 1 del periódico y sube dicha página al servidor web.

## Resuelve lo siguiente:
1) Junta todas las páginas del periódico de todos los periodistas.
```PowerShell
mkdir usuario1; cd usuario1
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina1.html
cd ..
mkdir usuario2; cd usuario2
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina2.html
cd ..

ls *.html -recurse | %{
    $periodidcocomp = $periodidcocomp + (gc $_)
}

$periodidcocomp | out-file periodicocompleto.html
```
2) Haz copias de seguridad para diferentes momentos del día y al final del día haz copia de todo el periódico completo.
```PowerShell
(Get-Date).ToString("yyyyMMddhh")

$fecha = (Get-Date).ToString("yyyyMMddhh")
mkdir ($fecha) -force
cd $fecha

ls *.html -recurse | %{
    copy $_ $fecha
}
```
3) Incidencia. Alguien ha mandado imprimir el periódico entero. Tienes que pararlo porque no es el momento de imprimirlo.
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
#$perio = gc .\periodicocompleto.html
$b=[Text.Encoding]::ASCII.GetBytes("gc perio.html | out-printer")
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
##Server
while(1)
{
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
if([Text.Encoding]::ASCII.GetString($content) | select-string "print")
{
    "ha mandado imprimir"
}
}
```
4) Opcional. El periódico automático. Crear cada página HTML utilizando una base de datos
* https://www.jesusninoc.com/09/20/crear-un-fichero-html-con-el-contenido-de-la-tabla-posts-de-wordpress-con-powershell/

-----------------

# Modelo 3

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
- Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
```PowerShell
Get-EventLog -LogName security | select Message | select-string "\\localhost\ejemplo"
```
- Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
    - https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/
    - https://www.jesusninoc.com/03/12/select-files-between-two-dates-and-copy-them/
  - Dejar programada la acción.
    - https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
  - Comprimir y descomprimir
    - https://www.jesusninoc.com/03/15/create-new-compress-archive-file/
    - https://www.jesusninoc.com/02/14/descomprimir-archivos/
  - Cifrar el contenido, método sencillo o complicado.
    - https://www.jesusninoc.com/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación
  - Funciones simples y complejas
```PowerShell
##########################
# Funciones simples
##########################
function crearestructura()
{
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force

    $fecha = (Get-Date).ToString("yyyyMMdd")
    cd copia
    mkdir ($fecha) -force
}

crearestructura

function copiararchivos()
{
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha -force
    }
}

copiararchivos

function recuperar
{
  param($fichero)
  begin
  {
  }
  process
  {
    Expand-Archive -LiteralPath $fichero -DestinationPath desco\
  }
  end
  {
  }
}

recuperar .\comprimido.zip

##############################################################################

##########################
# Función compleja
##########################
function copiaseguridad
{
  param()
  begin
  {
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force
    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir copia\$fecha -force
  }
  process
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha\ -force
    }
  }
  end
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls copia\$fecha
    Compress-Archive -LiteralPath copia\$fecha –CompressionLevel Optimal -DestinationPath comprimido.zip -Force
  }
}
copiaseguridad
```
- Se ha producido una infección en un sistema operativo Windows,
  - ¿qué elementos comprobarías para detectar dicha infección?
      - https://www.jesusninoc.com/07/11/analisis-de-procesos-y-conexiones-de-red-con-powershell/
  - ¿cómo impides que se produzcan infecciones el sistema operativo?
  - ¿Windows dispone de herramientas centralizadas para evitarlo?

```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```
  
- Explica todo el proceso para realizar una clonación.
- Explica todo lo que sepas sobre permisos en Windows.
- ¿Cómo puedes hacer una sincronización en Linux?, ¿puedes hacerla entre equipos?, ¿cómo?
- ¿Un driver falla, qué haces para arrancar el sistema?
- ¿Un componente gráfico, qué haces para arrancar el sistema?
- Se puede lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
- Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
    - https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
- Explica para qué sirven las auditoría y qué relación tiene con los permisos.
- ¿Qué hace el siguiente script? (explica en detalle el código)
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

-----------------

# Modelo 4

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 5

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 6


## Explicar y realizar un script para cada una de las siguientes situaciones:

1. Cómo puedes saber quién accede a una carpeta compartida en Linux.
2. Realiza un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
    - Windows o Linux.
    - Dejar programada la acción.
    - Cifrar el contenido, método sencillo o complicado.
    - Dejar la carpeta oculta, comando attrib.
    - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
3. Puedes explicar algún sistema distribuido que relacione las cosas que hemos visto en clase.
4. ¿Cómo puedes hacer una sincronización en Linux?, ¿cómo?
5. Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?

## Ayuda
### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS)
https://www.jesusninoc.com/06/04/listar-procesos-de-powershell-con-node-powershell-nodejs/

### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS) Y MOSTRARLOS EN UNA WEB CON EXPRESS
https://www.jesusninoc.com/07/15/listar-procesos-de-powershell-con-node-powershell-node-js-y-mostrarlos-en-una-web-con-express/

### Ejemplo de NODE.JS (Crear una página web con información sobre cada equipo)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()
 
let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('$ComputerSystem=Get-WmiObject Win32_ComputerSystem;$BaseBoard=Get-WmiObject Win32_BaseBoard;$BIOS=Get-WmiObject Win32_BIOS;$Processor=Get-WmiObject Win32_Processor;[PSCustomObject]@{ Model = $ComputerSystem.Model; ManufacturerBoard = $BaseBoard.Manufacturer; BIOSVersion = $BIOS.SMbiosbiosversion; BIOSSerialNumber = $BIOS.serialnumber; ManufacturerProcessor=$Processor.Manufacturer; MaxClockSpeed=$Processor.MaxClockSpeed} | ConvertTo-Html')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});
 
app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

### Ejemplo de NODE.JS (Crear una página web con información sobre procesos)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()

let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('Get-Process | ConvertTo-Html -Property Name, Path, Company')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/procesos', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});

let ps2 = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps2.addCommand('Get-Service | ConvertTo-Html -Property Name, Path, Company')
ps2.invoke()
.then(output => {
  console.log(output);
  app.get('/servicios', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps2.dispose();
});

app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

------------
------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------

# PCAP (container of PCAP captures mapped to the relevant attack tactic)
* https://github.com/sbousseaden/PCAP-ATTACK

--------------------

# USB
## USBPcap – USB Packet capture for Windows
https://www.jesusninoc.com/2016/05/01/usbpcap-usb-packet-capture-for-windows/
## Wireshark and USB
https://isc.sans.edu/forums/diary/Wireshark+and+USB/23457/
## Hackers exploit casino's smart thermometer to steal database info
https://mashable.com/2018/04/15/casino-smart-thermometer-hacked/
## Logran robar datos de un ordenador a través del cableado eléctrico
https://www.redeszone.net/2018/04/13/logran-robar-datos-ordenador-traves-del-cableado-electrico/

----------
----------

# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Rendimiento del hardware
* https://www.jesusninoc.com/02/27/obtener-un-informe-detallado-del-consumo-de-la-bateria-en-windows-desde-powershell/

---------
---------

# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Casos de introducción
## - Preparar un equipo
* https://www.jesusninoc.com/04/22/instalacion-de-sistemas-operativos/
## - Analizar licencias
* https://www.jesusninoc.com/12/02/obtener-serial-de-windows-con-powershell/
## - Administración remota
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-01-16.md
## - Inventario
* https://www.jesusninoc.com/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/
## - Reemplazar espacios en fichero JPG
## - Detectar un problema de red
## - Detectar en los logs que hay intentos de obtener el fichero passwd
* https://www.jesusninoc.com/05/08/consulta-para-ver-intentos-de-obtener-el-fichero-passwd/
### Solución con una query
```PowerShell
.\LogParser.exe "SELECT * FROM 'C:\xampp\apache\logs\access.log' where text like '%passwd%'"
```

------------
------------

# Introducción al examen liberatorio

## Opción 1

### El departamento de recursos humanos envía el siguiente fichero...
```
nombre;apellido;password;grupo;ou;appbloqueada
juan;sinmiedo;P@ss1wordA;asir;asir;notepad
laura;valiente;P@ss1wordA;af;af;mspaint
```

#### - Nivel 1: crear un script que permita realizar todas las tareas que aparecen en el fichero.
#### - Nivel 2: crear un script que permita realizar las operaciones de forma ordenada.
#### - Nivel 3: crear un script que permita realizar las operaciones utilizando UDP.

## Opción 2

### Crear la estructura de red del Centro leyendo de un fichero, teniendo en cuenta:
- Hay seis grupos de clases, seis unidades organizativas
- Hay que crear usuarios y grupos para cada clase
- Hay que deshabilitar usuarios y moverlos a la unidad organizativa de los deshabilitados
- Borrar unidades organizativas
- Crear una carpeta para cada usuario

------------
------------

# Trabajo para optar al 10 y a MH
### Utilizando sockets comunicar un cliente con un servidor y aplicar el mayor número de conceptos vistos durante el curso:
- Crear una herramienta de control remoto.
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

--------------

## Ayuda
### Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

## Ayuda avanzada
### Pedir el nombre de un proceso y mostrar información del proceso mediante PowerShell con Node-PowerShell, EJS (Embedded JavaScript), Body-parser y Express
https://www.jesusninoc.com/2018/06/10/pedir-el-nombre-de-un-proceso-y-mostrar-informacion-del-proceso-mediante-powershell-con-node-powershell-ejs-body-parser-y-express-node-js/

### Build a Weather Website in 30 minutes with Node.js + Express + OpenWeather
https://codeburst.io/build-a-weather-website-in-30-minutes-with-node-js-express-openweather-a317f904897b

--------------

## Ejemplo de trabajo

### Realizar operaciones en un equipo remoto

```PowerShell
cls
write-host "Ip del ordenador remoto"
$ipR=read-host

##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('cls')"
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

while (1)
{

cls

Write-Host "Seleccione una opcion"

echo "1 - Sistema de archivos"
echo "2 - Agregar/eliminar software"
echo "3 - Actualizacion"
echo "4 - Gestion de procesos"
echo "5 - Programacion de tareas"
echo "6 - Gestion de usuarios"
echo "7 - Gestion de almacenamiento"
echo "8 - Gestion de red"
echo "9 - Copias de seguridad"
echo "10 - Reparacion del sistema"
echo "11 - Rendimiento del sistema"
echo "12 - Salir"

$prue1 = Read-Host
switch ( $prue1 )
    {
        1{
            cls
            Write-Host "Seleccione una opcion"
            echo "1 - Listar"
            echo "2 - Crear"
            echo "3 - Abrir"
            echo "4 - Eliminar"
            $selcec=Read-Host
            switch ( $selcec )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=[Text.Encoding]::ASCII.GetBytes('Get-ChildItem')
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                2{
                    $type=Read-Host "Escriba que tipo desea crear (File o Directory)"
                    $name=Read-Host "Escriba el nombre del $type"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Item -ItemType $type -Name $name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                3{
                    $name1=Read-Host "Nombre del archivo que desea abrir"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('start $name1')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                4{
                    ls
                    $name2=Read-Host "¿Qué desea eliminar?"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-Item $name2')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }                   
        }
        2{
            cls
            $nombre=Read-Host "Introduzca nombre del .msi que desee instalar"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('msiexec.exe /package C:\windows\Installer\($nombre)')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        Pause
        }
        3{
            cls
            echo "1 - Instalar"
            echo "2 - Desinstalar"
            Write-Host "Seleccione una opción"
            $actuali=Read-Host
            switch ($actuali)
            {
                1{
                    Write-Host "Como desea que se realize"
                    echo "1 - Normal"
                    echo "2 - En silencio"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            Write-Host "Escriba el nombre de la actualizacion"
                            $nombre=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                           
                        }
                        2{
                            Write-Host "Eliga la opción desea"
                            echo "1 - No reiniciarse al terminar"
                            echo "2 - Pedir confirmación antes de reiniciar"
                            echo "3 - Obligar a que se cierren todas las aplicaciones y se reinicie"
                            $Smodo=Read-Host
                            $Nombre=Read-Host
                            switch($Smodo)
                            {
                                1{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()
                                    
                                }
                                2{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /warnrestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                                3{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /forcerestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                            }
                        }
                    }
                }
                2{
                    cls
                    echo "1 - Normal"
                    echo "2 - Paquete asociado con el número de actualización"
                    Write-Host "Seleccione una opción"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                        2{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall /kb')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                    }
            }
            }
            puase
        }
        4{
            cls
            echo "1 - Iniciar un proceso"
            echo "2 - Mostrar solo Nombres"
            echo "3 - Mostrar proceso de cierto programa"

            $sele=Read-Host
            switch ( $sele )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                } 
                2 {
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | select Name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3 {
                    $selprog=Read-Host "Escriba el nombre del programa"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | Select-String $selprog')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
        5{
            cls
            $program=Read-Host "que programa desea abrir"
            $time=Read-Host "a que hora"
            $nomre=Read-Host "escriba el nombre de la tarea"
            $action=New-ScheduledTaskAction -Execute $program
            $trigger=New-ScheduledTaskTrigger -Daily -At $time
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Register-ScheduledTask -Action $action -Trigger $trigger -TaskName $nomre')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()           
            Pause
            
        }
        6{
            cls
            echo "1 - Crear usuario"
            echo "2 - Eliminar usuario"
            echo "3 - Crear grupo"
            echo "4 - Ver miembros de un grupo"
            echo "5 - Eliminar grupo"
            $opcion=Read-Host "Eliga una opcion"
            switch ($opcion)
            {
            1{
                $nameuser=Read-Host "Nomre del nuevo usuario"
                $pass=Read-Host "Introduzca contraseña"
                $pass1=ConvertTo-SecureString $pass -asplaintext -force
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalUser $nameuser -Password $pass1')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            2{
                $usuer=Read-Host "Nombre del usuario"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-LocalUser -Name $usuer')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            3{
                $group=Read-Host "Nombre para el grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalGroup -Name $group')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            4{
                $Ngroup=Read-Host "Nombre del grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Ngroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            5{
                $Rgroup=Read-Host "Nombre del grupo que vaya a eliminar"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Rgroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            }
        }
        7{
            cls
            echo "1 - Particionar"
            echo "2 - Desfragmentar"
            echo "3 - Convertir sistemas de archivo"
            echo "4 - Cifrar"
            echo "5 - Descifrar"
            Write-Host  "Seleccione una opción"
            $almacenamiento=Read-Host
            switch ($almacenamiento)
            {
                1{
                    Write-Host "ADVERTENCIA: Nunca poner el numero '0'"
                    $NumeroD=Read-Host "Introduzca número del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Partition -DiskNumber $NumeroD -UseMaximumSize -AssignDriveLetter')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    $letra=Read-Host "Letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Optimize-Volume $letra -Defrag')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Disable-BitLocker 
                    Pause
                }
                3{
                    $letra=Read-Host "Letra del disco"
                    $tipo=Read-Host "Que formato desea"                    
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Format-Volume -DriveLetter $letra -FileSystem $tipo')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                4{
                    $letra=Read-Host "Inroduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Enable-BitLocker -MountPoint $letra -RecoveryPasswordProtector -UsedSpaceOnly -Verbose')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                5{
                    $letra=Read-Host "Introduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Disable-BitLocker -MountPoint $letra')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
            }
              
        }
        }
        8{
            cls
            echo "1 - Saber ip"
            echo "2 - Hacer ping"
            $op=Read-Host "Seleccione una opcion"
            Switch ( $op )
            {
            1{
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ipconfig')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            2{
                $ip=Read-Host "Introduzca IPv4"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ping $ip')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            }
        }
        9{
            cls
            Write-Host "Se recomienda que ponga la ruta y para quedarsela usted la meta en una carpeta compartida"
            $namea=Read-Host "Nombre del archivo que desea hacer copia de seguridad"
            $ruta=Read-Host "Ruta donde desea que este la copia de seguridad"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Copy-Item $namea $ruta')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()            
            Pause
        }
        10{
            cls
            Write-Host "Seleccione una opción"
            echo "1 - Ver puntos de restauracion"
            echo "2 - Restaurar un punto"
            $opcion=Read-Host
            switch ($opcion)
            {
                1{        
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                }
                2{
                    Write-Host "Seleccione una opción"
                    echo "1 - Ultimo punto"
                    echo "2 - Restaura cierto punto"
                    $opcion=Read-Host
                    switch ($opcion)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint -LastStatus')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }

                        2{
                            Write-Host "Ponga el numero de restauración"
                            $punto=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Restore-Computer -RestorePoint $punto')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()                   
                        }
                    }
                }
            }
            Pause
        }
        11{
            cls
            echo "1 - Monitorizar procesos"
            echo "2 - Monitorizar procesos Avanzado"
            echo "3 - Ver todos los nombres de los contadores de rendimiento"
            $seleccionar=Read-Host "Seleccione una opción"
            switch ( $seleccionar )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port
                    )
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Counter -ListSet * | Sort-Object CounterSetName | Format-Table CounterSetName')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
}
if( $prue1 -eq "12" )
        {
            cls
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('break')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            break
        }
}
```

-----------
-----------

# Modelos de examen de la asignatura de Implantación de Sistemas Operativos (ISO) de 1º de Administración de Sistemas Informáticos en Red (ASIR) tercera evaluación
- Modelo 1 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-1
- Modelo 2 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-2
- Modelo 3 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-3
- Modelo 4 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-4
- Modelo 5 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-5
- Modelo 6 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-6

-----------------

# Modelo 1

## Tener en cuenta:
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## 1. Analizar ficheros DLL en todos los equipos de la red
```PowerShell
123..125 | %{"192.168.104." + $_}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
$ruta
}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.jes"
ls $ruta
}

1..40 |  %{Invoke-Command -ComputerName ("192.168.204." + $_) -ScriptBlock {hostname}}

Invoke-Command -ComputerName dc1 -ScriptBlock {hostname}

gc .\equipos1.txt | % {
    $llistar="\\"+$_+"\c$"
    ls $llistar | select name,FullName
} | Group-Object name | select Count,Group | where count -eq 1
```
### Enable and Use Remote Commands in Windows PowerShell
https://technet.microsoft.com/en-us/library/ff700227.aspx
### How to Add a Computer to the TrustedHosts List
```PowerShell
set-item wsman:\localhost\Client\TrustedHosts -value "ABANTO"
```
### Listar funciones exportadas de un archivo DLL con DUMPBIN desde PowerShell
https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/

## 2. Analizar ficheros DLL en todos los equipos de la red, comprobar que ha cambiado una integridad y copiar el fichero que ha cambiado
### En PowerShell
```PowerShell
mkdir dlls

cd dlls

"dll1" | Out-File dll1.dll
"dll2" | Out-File dll2.dll

# Recorrrer una a una dll
ls *.dll | %{$_}

# Hacer hash de cada dll
ls *.dll | %{Get-FileHash $_.FullName | Select-Object Hash}

# Hacer hash de cada dll ruta por red
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path}

# Guardar hash
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path | Out-File listado.txt -Append}

# Ver listado
gc .\listado.txt

# Modificar dll y detectar el cambio, después mover la dll, solución: el hash de cada dll no se encuentra en el fichero listado.txt, eso quiere decir que se ha modificado y hay que copiar a la carpeta compartida en Linux
# Modificar dll
"dll6" | Out-File dll1.dll

ls '\\localhost\c$\Users\juan\dlls' *.dll | %{
    if((gc .\listado.txt) -match (Get-FileHash $_.FullName | Select-Object Hash).hash)
    {
    }
    else
    {
        $_.Name
        "Dll se ha modificado"
    }
}


# Meter el código anterior en el recorrido que cada alumno tenga
123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
ls $ruta -recurse
}

# Almacenar el hash de la dll para todos los equipos de la red
foreach($equipo in gc .\equipos1.txt) {
    $llistar="\\"+$equipo+"\c$"
    ls $llistar -recurse *.dll | %{
        $valorse = Get-FileHash ($_ | select FullName).FullName
        $valorse.path+"|"+$valorse.Hash | Out-File hasehees.txt
    }
}

# Verificar si una dll no ha cambiado su hash
gc .\hasehees.txt | %{
    if($_.split("|")[0].contains("jawt.dll"))
    {
        if($_.split("|")[1] -eq (Get-FileHash "\\ABANTOS21\c$\Cache\pc-client.exe-16.3.0.37857\runtime\jre\bin\jawt.dll" | select hash).hash)
        {
            "CORRECTO"
        }
    }
}
```
#### Se puede crear una dll y modificar una función para comprobar que la integridad falla
* https://www.jesusninoc.com/11/26/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-ejecute-un-cmdlet-de-powershell/
* https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/
* https://www.jesusninoc.com/04/21/obtener-los-nombres-de-las-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell-explicacion-paso-a-paso-del-script/

### En Linux
https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

## 3. Puedes saber qué fichero DLL están funcionando en el equipo utilizando la red
```PowerShell
(Get-Process -ComputerName .).Modules
(Get-Process -ComputerName .).Modules | where ModuleName -eq  sxs.dll
```

## 4. Detectar que una aplicación tiene tráfico de red (filtro por puerto)
### Tshark Command Examples
https://linuxsimba.com/tshark-examples

```PowerShell
$filterUDP = ''
$filterTCP = ''
ps | where ProcessName -eq 'chrome' | %{
    Get-NetUDPEndpoint | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterUDP = $filterUDP+'(udp.port == '+$_.LocalPort+') or'
    }
    
    Get-NetTCPConnection | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterTCP = $filterTCP+'(tcp.port == '+$_.LocalPort+') or'
    }
    
    
}
$filterUDP = $filterUDP.substring(0, $filterUDP.Length-3)
$filterTCP = $filterTCP.substring(0, $filterTCP.Length-3)

$filter = $filterUDP+' or '+$filterTCP

net use \\192.168.104.129\Prueba-share-samba /user:root 1234

.\tshark.exe -i 'ethernet 2' -Y $filter > \\192.168.104.129\Prueba-share-samba\test.txt
```

------------
------------

# Modelo 2

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web periódico

### Eres el nuevo administrador de sistemas del diario el Universo. El diario funciona así: los periodistas crean sus ficheros HTML en sus carpetas en la red mediante un interfaz web (una Intranet). Cada periodista ve sus propios ficheros y no ve los de sus compañeros. Por ejemplo: Juan crea la página 1 del periódico y sube dicha página al servidor web.

## Resuelve lo siguiente:
1) Junta todas las páginas del periódico de todos los periodistas.
```PowerShell
mkdir usuario1; cd usuario1
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina1.html
cd ..
mkdir usuario2; cd usuario2
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina2.html
cd ..

ls *.html -recurse | %{
    $periodidcocomp = $periodidcocomp + (gc $_)
}

$periodidcocomp | out-file periodicocompleto.html
```
2) Haz copias de seguridad para diferentes momentos del día y al final del día haz copia de todo el periódico completo.
```PowerShell
(Get-Date).ToString("yyyyMMddhh")

$fecha = (Get-Date).ToString("yyyyMMddhh")
mkdir ($fecha) -force
cd $fecha

ls *.html -recurse | %{
    copy $_ $fecha
}
```
3) Incidencia. Alguien ha mandado imprimir el periódico entero. Tienes que pararlo porque no es el momento de imprimirlo.
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
#$perio = gc .\periodicocompleto.html
$b=[Text.Encoding]::ASCII.GetBytes("gc perio.html | out-printer")
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
##Server
while(1)
{
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
if([Text.Encoding]::ASCII.GetString($content) | select-string "print")
{
    "ha mandado imprimir"
}
}
```
4) Opcional. El periódico automático. Crear cada página HTML utilizando una base de datos
* https://www.jesusninoc.com/09/20/crear-un-fichero-html-con-el-contenido-de-la-tabla-posts-de-wordpress-con-powershell/

-----------------

# Modelo 3

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
- Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
```PowerShell
Get-EventLog -LogName security | select Message | select-string "\\localhost\ejemplo"
```
- Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
    - https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/
    - https://www.jesusninoc.com/03/12/select-files-between-two-dates-and-copy-them/
  - Dejar programada la acción.
    - https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
  - Comprimir y descomprimir
    - https://www.jesusninoc.com/03/15/create-new-compress-archive-file/
    - https://www.jesusninoc.com/02/14/descomprimir-archivos/
  - Cifrar el contenido, método sencillo o complicado.
    - https://www.jesusninoc.com/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación
  - Funciones simples y complejas
```PowerShell
##########################
# Funciones simples
##########################
function crearestructura()
{
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force

    $fecha = (Get-Date).ToString("yyyyMMdd")
    cd copia
    mkdir ($fecha) -force
}

crearestructura

function copiararchivos()
{
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha -force
    }
}

copiararchivos

function recuperar
{
  param($fichero)
  begin
  {
  }
  process
  {
    Expand-Archive -LiteralPath $fichero -DestinationPath desco\
  }
  end
  {
  }
}

recuperar .\comprimido.zip

##############################################################################

##########################
# Función compleja
##########################
function copiaseguridad
{
  param()
  begin
  {
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force
    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir copia\$fecha -force
  }
  process
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha\ -force
    }
  }
  end
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls copia\$fecha
    Compress-Archive -LiteralPath copia\$fecha –CompressionLevel Optimal -DestinationPath comprimido.zip -Force
  }
}
copiaseguridad
```
- Se ha producido una infección en un sistema operativo Windows,
  - ¿qué elementos comprobarías para detectar dicha infección?
      - https://www.jesusninoc.com/07/11/analisis-de-procesos-y-conexiones-de-red-con-powershell/
  - ¿cómo impides que se produzcan infecciones el sistema operativo?
  - ¿Windows dispone de herramientas centralizadas para evitarlo?

```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```
  
- Explica todo el proceso para realizar una clonación.
- Explica todo lo que sepas sobre permisos en Windows.
- ¿Cómo puedes hacer una sincronización en Linux?, ¿puedes hacerla entre equipos?, ¿cómo?
- ¿Un driver falla, qué haces para arrancar el sistema?
- ¿Un componente gráfico, qué haces para arrancar el sistema?
- Se puede lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
- Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
    - https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
- Explica para qué sirven las auditoría y qué relación tiene con los permisos.
- ¿Qué hace el siguiente script? (explica en detalle el código)
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

-----------------

# Modelo 4

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 5

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 6


## Explicar y realizar un script para cada una de las siguientes situaciones:

1. Cómo puedes saber quién accede a una carpeta compartida en Linux.
2. Realiza un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
    - Windows o Linux.
    - Dejar programada la acción.
    - Cifrar el contenido, método sencillo o complicado.
    - Dejar la carpeta oculta, comando attrib.
    - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
3. Puedes explicar algún sistema distribuido que relacione las cosas que hemos visto en clase.
4. ¿Cómo puedes hacer una sincronización en Linux?, ¿cómo?
5. Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?

## Ayuda
### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS)
https://www.jesusninoc.com/06/04/listar-procesos-de-powershell-con-node-powershell-nodejs/

### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS) Y MOSTRARLOS EN UNA WEB CON EXPRESS
https://www.jesusninoc.com/07/15/listar-procesos-de-powershell-con-node-powershell-node-js-y-mostrarlos-en-una-web-con-express/

### Ejemplo de NODE.JS (Crear una página web con información sobre cada equipo)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()
 
let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('$ComputerSystem=Get-WmiObject Win32_ComputerSystem;$BaseBoard=Get-WmiObject Win32_BaseBoard;$BIOS=Get-WmiObject Win32_BIOS;$Processor=Get-WmiObject Win32_Processor;[PSCustomObject]@{ Model = $ComputerSystem.Model; ManufacturerBoard = $BaseBoard.Manufacturer; BIOSVersion = $BIOS.SMbiosbiosversion; BIOSSerialNumber = $BIOS.serialnumber; ManufacturerProcessor=$Processor.Manufacturer; MaxClockSpeed=$Processor.MaxClockSpeed} | ConvertTo-Html')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});
 
app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

### Ejemplo de NODE.JS (Crear una página web con información sobre procesos)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()

let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('Get-Process | ConvertTo-Html -Property Name, Path, Company')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/procesos', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});

let ps2 = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps2.addCommand('Get-Service | ConvertTo-Html -Property Name, Path, Company')
ps2.invoke()
.then(output => {
  console.log(output);
  app.get('/servicios', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps2.dispose();
});

app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

------------
------------

# Examen liberatorio

- El proceso que más consume tiene un cambio de integridad, crear una función que realiza dicha comprobación.
- Crear un log de sistema cuando hay un cambio de integridad.
- Un software que se va a instalar tiene un ejecutable cuya integridad es errónea.
- Detectar que un equipo no se ha añadido a un Dominio.
- Mostrar un objeto con toda la información de todos los elementos que hay en un Directorio Activo.
- Detectar cómo se ha propagado un virus en carpetas compartidas generando una entrada en un log del sistema.
- Comprobar que ha cambiado un permiso utlizando auditoría.
- Mostrar un mensaje si el tamaño de una carpeta compatida supera el 80%.
- Crear una entrada en un registro del visor de eventos si hay un intento de acceso a un puerto que está cerrado.

------------
------------

# Correción examen liberatorio

- El proceso que más consume tiene un cambio de integridad, crear una función que realiza dicha comprobación.
```PowerShell
(Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash | Out-File inte.txt

$resultado = (Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash
if((Get-Content .\inte.txt) -eq $resultado)
{
    "es igual"
}
else
{
    "no es igual"
}
```
- Crear un log de sistema cuando hay un cambio de integridad.
```PowerShell
(Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash | Out-File inte.txt

function comprobar ($integridadbuena)
{
    $resultado = (Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash
    if($integridadbuena -eq $resultado)
    {
        "es igual"
    }
    else
    {
       Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" 
       -EventID 916 -EntryType Information -Message "Cambio integridad" 
       -Category 2 -RawData 10,20
    }
}

comprobar (Get-Content .\inte.txt)
```
- Un software que se va a instalar tiene un ejecutable cuya integridad es errónea.
```PowerShell
foreach($programa in ls "C:\Program Files (x86)\Cisco Packet Tracer 6.1.1sv\bin\*.exe")
{
    (Get-FileHash $programa).path+","+(Get-FileHash $programa).hash | Out-File resultahas.txt -Append
}
```
- Detectar que un equipo no se ha añadido a un Dominio.
```PowerShell
$equipo = ""

function comprobar ($equipo)
{
    $ComputerName = $env:COMPUTERNAME
    $computer = [ADSI]"WinNT://$($ComputerName),computer"
    foreach($equipito in $computer)
    {
        if($equipito.Path -match $equipo)
        {
            "es igual"
        }
    }
}

comprobar FP_LHR_19
```
- Mostrar un objeto con toda la información de todos los elementos que hay en un Directorio Activo.
```PowerShell
[PSCustomObject]@{
 usuarios = Get-LocalUser
 grupos = Get-LocalGroup
}
```
- Detectar cómo se ha propagado un virus en carpetas compartidas generando una entrada en un log del sistema.
- Comprobar que ha cambiado un permiso utlizando auditoría.
- Mostrar un mensaje si el tamaño de una carpeta compatida supera el 80%.
```PowerShell
$total = 100

if((Get-ChildItem C:\Users\adminfp\Desktop\fallo | Measure-Object Length -Sum).Sum -lt $total*0.8)
{
    "menor"
}
```
- Crear una entrada en un registro del visor de eventos si hay un intento de acceso a un puerto que está cerrado.

# Aplicación en Python con Flask para gestión de archivos mediante comandos del sistema
* https://www.jesusninoc.com/05/20/aplicacion-en-python-con-flask-para-gestion-de-archivos-mediante-comandos-del-sistema/

# Aplicación en Python con Flask y Bootstrap para la gestión de procesos mediante comandos del sistema
* https://www.jesusninoc.com/05/21/aplicacion-en-python-con-flask-y-bootstrap-para-la-gestion-de-procesos-mediante-comandos-del-sistema/

# Servidor en Python con Flask para recibir y almacenar credenciales (con método GET)
* https://www.jesusninoc.com/05/22/servidor-en-python-con-flask-para-recibir-y-almacenar-credenciales-con-metodo-get/

# Servidor en Python con Flask para recibir y almacenar credenciales (con método POST)
* https://www.jesusninoc.com/05/22/servidor-en-python-con-flask-para-recibir-y-almacenar-credenciales-con-metodo-post/
