# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------------

# Sistema de archivos

## Introducción a sistema de archivos
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

# Sistema de archivos: discos
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Discos

## Comandos para trabajar con discos en Linux
* https://www.jesusninoc.com/10/28/comandos-para-trabajar-con-discos-en-linux-2/

---------------
---------------

# Examen de octubre corrección

1. Crear una carpeta cuyo nombre sea la fecha de hoy y meter dentro de la carpeta un fichero con información sobre el proceso Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-una-carpeta-cuyo-nombre-sea-la-fecha-de-hoy-y-meter-dentro-de-la-carpeta-un-fichero-con-informacion-sobre-el-proceso-notepad/

 - 1.1. Crear una carpeta cuyo nombre sea la fecha de hoy https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-una-carpeta-cuyo-nombre-sea-la-fecha-de-hoy/

 - 1.2. Crear un fichero con información sobre el proceso Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-un-fichero-con-informacion-sobre-el-proceso-notepad/

2. Mostrar los hilos que tiene Notepad y almacenar los números de identificador de hilo en un fichero https://www.jesusninoc.com/10/28/ejercicios-de-powershell-mostrar-los-hilos-que-tiene-notepad-y-almacenar-los-numeros-de-identificador-de-hilo-en-un-fichero/

 - 2.1. Mostrar los hilos que tiene Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-mostrar-los-hilos-que-tiene-notepad/

3. Abrir 5 veces Notepad y almacenar información sobre el proceso Notepad en un fichero https://www.jesusninoc.com/10/28/ejercicios-de-powershell-abrir-5-veces-notepad-y-almacenar-informacion-sobre-el-proceso-notepad-en-un-fichero/

 - 3.1. Abrir 5 veces Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-abrir-5-veces-notepad/

 - 3.2. Almacenar información sobre el proceso Notepad en un fichero https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-un-fichero-con-informacion-sobre-el-proceso-notepad/

-----------
-----------

#  IF en PowerShell
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Sentencias_condicionales

# Ejemplos con IF

## Pedir al usuario un nombre de usuario y un password
* https://www.jesusninoc.com/11/23/ejercicios-de-powershell-pedir-al-usuario-un-nombre-de-usuario-y-un-password/

## Pedir al usuario un nombre de usuario y un password y comprobar si es "juan"
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-pedir-al-usuario-un-nombre-de-usuario-y-un-password-y-comprobar-si-es-juan/

## Pedir al usuario un nombre de usuario y un password y comprobar si es "juan". Introducir pass y ver si es correcto
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-pedir-al-usuario-un-nombre-de-usuario-y-un-password-y-comprobar-si-es-juan-introducir-pass-y-ver-si-es-correcto/

---------------

# Switch en PowerShell
* https://www.jesusninoc.com/2016/08/09/sentencia-condicional-switch/

# Ejemplos
## Ejemplos sobre operaciones con switch
```PowerShell
$a=Read-Host "Introduzca operación"
switch($a){
'+'{
echo Suma
break
}
}
```
## Pedir una operación y si es "suma" realizar una suma
```PowerShell
$a=Read-Host "Introduzca operación"
switch($a){
'+'{
suma
break
}
}

function suma()
{
2+3
}
```

-----------
-----------

# Ejercicios

## Crear dos ficheros TXT, convertirlos a PDF y juntarlos con Poppler
* https://www.jesusninoc.com/11/26/ejercicios-de-powershell-crear-dos-ficheros-txt-convertirlos-a-pdf-y-juntarlos-con-poppler-utilizando-wsl/

## Crear cinco directorios y dentro de cada directorio crear 10 ficheros
* https://www.jesusninoc.com/11/28/ejercicios-de-powershell-crear-cinco-directorios-y-dentro-de-cada-directorio-crear-10-ficheros/

## Crear una estructura de directorios
* https://www.jesusninoc.com/11/28/ejercicios-de-powershell-crear-una-estructura-de-directorios/

## Crear una estructura de directorios (pero solo los números pares)
* https://www.jesusninoc.com/11/28/ejercicios-de-powershell-crear-una-estructura-de-directorios-pero-solo-los-numeros-pares/

## Crear una estructura de directorios (pero solo los números impares)
* https://www.jesusninoc.com/11/30/ejercicios-de-powershell-crear-una-estructura-de-directorios-pero-solo-los-numeros-impares/

## Leer operaciones de un fichero y realizarlas

### Estructura del fichero asignaturas.txt (0 crear fichero, 1 crear directorio)
```
iso,0
aso,1
```

### Leer del fichero que tiene las asignaturas
```PowerShell
$fichero=get-content asignaturas.txt
$fichero | % {
$_
}
```

### Leer del fichero que tiene las asignaturas y obtener solo la operación que hay que realizar
```PowerShell
$fichero=get-content asignaturas.txt
$fichero | % {
$_.split(',')[1]
}
```

### Leer el fichero y detectar la operación a realizar utilizando el switch
```PowerShell
$fichero = Get-Content asignaturas.txt
$fichero | % {
    $operacion = $_.split(",")
    switch($operacion[1]){
        '0'{
            echo "crear fichero"
            New-Item -Name $operacion[0] -ItemType File -Force
            break
        }
        '1'{
            echo "crear directorio"
            mkdir $operacion[0] -Force
            break
        }
    }
}
```

----------------
----------------

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.

---------------

# Linux

## A First Script
* https://www.shellscript.sh/first.html

## Ejercicios con ficheros y directorios (Bash)

```Bash
#Crear o modificar un archivo
vi nombre
```
```Bash
#Crear un directorio
mkdir
```
```Bash
#Ver el contenido de un archivo
cat
```
```Bash
#Acceder al contenido de un directorio
cd
```
```Bash
#Listar el contenido de un directorio
ls
```
```Bash
#Ver la estructura de un directorio
tree
```
```Bash
#Eliminar un archivo
rm
```
```Bash
#Eliminar un directorio
rmdir
```
```Bash
#Copiar un archivo o un directorio
cp
```
```Bash
#Mover un archivo o un directorio
mv
```
```Bash
#Renombrar un archivo o un directorio
mv
```
```Bash
#Establecer permisos en un archivo o un directorio
chmod
```
```Bash
#Comprimir y descomprimir un archivo o un directorio
gzip
```
```Bash
#Imprimir un archivo
lpr
```

## Ejercicios propuestos con ficheros y directorios (Bash)

- Crear un directorio para cada usuario
- Crear un fichero para cada usuario
- Añadir contenido a cada fichero creado para cada usuario
- Eliminar un directorio
- Renombrar un directorio
- Mover archivos de una carpeta a otra

## Ejercicios resueltos con ficheros y directorios (Bash)

1. Crear fichero que tenga tu nombre
```Bash	
 	echo Alejandro > fichero.txt
	#-------------------------
	who | awk '{print $1}' > fichero.txt
```
2. Ver el contenido de un fichero cuyo nombre esta guardado en otro fichero
```Bash
	cat `cat fichero.txt`
	#--------------------
	fich1= cat fichero
	cat $fich1
```
3. Listar contenido de un directorio y almacenarlo en un fichero
```Bash	
	ls directorio > listaDeDirectorio.txt
	cat listadeDirectorio.txt
```
4. Eliminar un fichero leyendo el nombre de este desde otro fichero
```Bash
	echo fichero1.txt > fichero2.txt

	rm `cat ficher2.txt`
	#------------------------------
	fic=cat ficher2.txt
	rm $fic
```
5. Eliminar directorio leyendo el nombre desde este desde otro fichero.	
```Bash
	echo directorio > fichero.txt
	
	mkdir `cat fichero.txt`
	
	rm -r `cat fichero.txt`
	#------------------------------
	direc=cat fichero.txt
	
	mkdir $direc
	rm -r $direc
```
6. Comprimir un directorio
```Bash
	gzip fichero
```
