| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
- Ficheros necesarios para el arranque de los principales sistemas operativos.
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
- Actualización y mantenimiento de controladores de dispositivos.
  - Automatizar la actualización de controladores.
  - Volver a una versión anterior de un controlador.
  - Actualización manual de los controladores.
  
------------------

# Linux

## Variables
https://www.jesusninoc.com/2015/01/04/curso-de-bash-scripting-con-ejemplos/

### Variables 1: enteros, caracteres y cadenas de caracteres
https://www.jesusninoc.com/2014/10/28/variables-1-enteros-caracteres-y-cadenas-de-caracteres/
### Variables 2: concatenar, extraer, medir cadenas
https://www.jesusninoc.com/2014/10/24/variables-2-concatenar-extraer-elementos-y-medir-la-longitud-de-un-array/
### Variables 3: almacenar la ejecución de un comando
https://www.jesusninoc.com/2014/10/23/variables-3-almacenar-la-ejecucion-de-un-comando/
### Variables 4: almacenar en fichero
https://www.jesusninoc.com/2014/10/22/variables-4-almacenar-en-fichero/
### Variables 5: leer de un fichero
https://www.jesusninoc.com/2014/10/21/variables-5-leer-de-un-fichero/
### Variables 6: etiquetas HTML
https://www.jesusninoc.com/2014/10/20/variables-6-etiquetas-html/
### Variables 7: ordenar y eliminar elementos duplicados
https://www.jesusninoc.com/2014/10/19/variables-7-ordenar-y-eliminar-elementos-duplicados-2/
### Variables 8: eliminar caracteres en blanco
https://www.jesusninoc.com/2014/10/18/variables-8-eliminar-caracteres-en-blanco/

## Bucle
Example C for loop syntax
```Bash
for (( i=1; i <= 10; i++ ))
do
echo "Number $i"
done
```

## Ejercicio: ejecutar el comando almacenado en un fichero
* https://github.com/jesusninoc/Bash/blob/master/Introduccion/EjemplosIntroducci%C3%B3n.sh

```Bash
echo "ps" > fichero
echo "ls" >> fichero
`cat fichero | head -n 1`
```

```Bash
echo "ps" > fichero
echo "ls" >> fichero

while read linea
do
echo $linea
`echo $linea` >> resultado
done < fichero

cat resultado
```

------------------

# PowerShell
## Repaso bucle ForEach
* https://github.com/jesusninoc/PowerShell/blob/master/Bucles/RepasoBucleForEach.ps1

------------------

# Linux + PowerShell

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Instalar y ejecutar SSH para PowerShell
```PowerShell
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
New-SSHSession -ComputerName 10.20.104.35 -Credential (Get-Credential)

$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```

## SSH sobre PowerShell
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```

## SSH en Windows 10
* https://www.illuminiastudios.com/dev-diaries/ssh-on-windows-subsystem-for-linux/

----------------
----------------

# Apartado pendiente tema anterior
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.

---------
---------

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------------

# Sistema de archivos

## Introducción a sistema de archivos
https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

# Sistema de archivos: discos

## Comandos para trabajar con discos en PowerShell
https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

# Ejercicio
- Crear varios discos virtuales leyendo desde un fichero la información (nombre), los discos hay que particionarlos y formatearlos. Añadir a cada disco duro información sobre los procesos e hilos que se están ejecutando.
## Ayuda
* https://docs.microsoft.com/es-es/windows/deployment/windows-10-poc 
* https://github.com/jesusninoc/ClasesSOM/blob/master/2019-02-26.md#crear-un-disco-virtual-en-windows
* https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-server-2012-R2-and-2012/gg252593%28v%3dws.11%29
* https://docs.microsoft.com/es-es/windows/deployment/windows-10-poc
* https://github.com/jesusninoc/ClasesSOM/blob/master/2019-02-26.md#ejercicios

## Script
* https://www.jesusninoc.com/11/05/ejercicios-de-powershell-crear-varios-discos-virtuales-leyendo-desde-un-fichero-la-informacion-nombre-los-discos-hay-que-particionarlos-y-formatearlos-anadir-a-cada-disco-duro-informacion-sobre-l/

-------------
-------------

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Bajo | 1º ASIR | Informática | Primera evaluación |

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------------

# Ejercicio sobre discos en Windows de forma automática (hablar de Hyper-V)

---------------------

# Sistema de archivos

## Introducción a sistema de archivos
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

# Sistema de archivos: discos
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Discos

## Comandos para trabajar con discos en Linux
* https://www.jesusninoc.com/10/28/comandos-para-trabajar-con-discos-en-linux-2/

----------------
----------------

# Examen de diciembre (repaso)

## Tener en cuenta:
- Utilizar ficheros para leer la información
- Almacenar información en ficheros de log
- Utilizar variables
- Foreach

## Preguntas:
### - Leer identificadores de procesos y comprobar que tienen un proceso
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-leer-identificadores-de-procesos-y-comprobar-que-tienen-un-proceso/

### - Detectar si hay un tipo de proceso y producto de software que se llame "Acrobat"
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-detectar-si-hay-un-tipo-de-proceso-y-producto-de-software-que-se-llame-acrobat/

### - Detectar que se está consumiendo tráfico de red por parte de un proceso
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-detectar-que-se-esta-consumiendo-trafico-de-red-por-parte-de-un-proceso/

### - Detectar que un proceso está utilizando el posicionamiento GPS
```PowerShell
Get-Process | select *
Get-Process -name chrome | Select-Object path
Get-WmiObject win32_process | select *
(Get-WmiObject win32_process | select CommandLine).CommandLine | Select-String "gp"
(Get-WmiObject win32_process | select CommandLine).CommandLine | Select-String "gps"
```

-------------
-------------

# Repaso de examen
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-11-05.md#examen-de-noviembre
## Solución complicada
* https://github.com/jesusninoc/ClasesSAD/blob/master/2020-11-06.md#caso-me-est%C3%A1n-espiando
