# Instalación de software libre y propietario

- Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
  - Particionado del disco duro.
  - En sistemas Windows determinar la partición donde instalaremos el S.O.
  - En sistemas Linux determinar las particiones para los distintos puntos de montaje.
  - Controladores (drivers) de almacenamiento necesarios.
- Instalación de sistemas operativos.
  - Requisitos hardware, versiones y licencias.
  - Soporte utilizado para la instalación: CD/DVD, Pendrive, LAN.
  - Datos necesarios para la instalación: usuarios, contraseñas, nombre del equipo, direcciones IP, número de licencia, etc.

----------------

# Obtener información sobre el pocesador en PowerShell

## Información sobre el procesador
* https://www.jesusninoc.com/12/22/ejercicios-de-powershell-obtener-informacion-sobre-el-procesador/

## Información sobre la arquitectura
* https://www.jesusninoc.com/12/01/ejercicios-de-powershell-obtener-informacion-sobre-la-arquitectura/

## Información sobre la organización
* https://www.jesusninoc.com/12/02/ejercicios-de-powershell-obtener-informacion-sobre-la-organizacion/

## Información sobre la realización
* https://www.jesusninoc.com/12/07/ejercicios-de-powershell-obtener-informacion-sobre-la-realizacion/

## Información sobre los procesadores
* https://www.jesusninoc.com/10/13/mostrar-informacion-sobre-los-procesadores/

## Número de cores
* https://www.jesusninoc.com/10/02/ejercicios-de-powershell-informacion-sobre-el-numero-de-cores/

## Carga del procesador
* https://www.jesusninoc.com/10/03/ejercicios-de-powershell-ver-la-carga-del-procesador/

## Ejercicios
### Información sobre el procesador
* https://www.jesusninoc.com/01/13/ver-informacion-del-procesador-en-windows-desde-powershell/

### Procesador es Intel o no?
* https://www.jesusninoc.com/10/16/ejercicios-de-powershell-saber-si-un-procesador-es-intel-o-no/

---------------------
---------------------

# Instalación de software libre y propietario

- Gestión de varios sistemas operativos en un ordenador.
  - Requisitos previos. Administración del espacio del disco. Particionado y redimensionado.
  - Problemas con el registro maestro de arranque (MBR). Elegir un gestor de arranque compatible con todos los sistemas operativos a instalar.
  - Preparar las particiones de los S.O. para permitir su arranque.
  - Analizar el orden en la instalación de los sistemas operativos.
- Gestores de arranque.
  - Código de arranque maestro (Master Boot Code).
  - Formatos tabla de particiones. Master Boot Record (MBR) y Guid Partition Table (GPT).
  - Configuración de los gestores de arranque de los sistemas operativos libres y propietarios.
  - Reparación del gestor de arranque.
  - Sustitución del gestor de arranque estándar por otro más completo.

---------------------

# Arranque
- BIOS
- POST
- Arranque (dual, BCD, BCDEdit, etc.)
- Arranque de procesos

## Arranque en Linux
### Proceso de arranque en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Arranque en Windows
### Master Boot Record
https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-2000-server/cc976786(v=technet.10)
### Proteger el proceso de arranque de Windows 10
https://docs.microsoft.com/es-es/windows/security/hardware-protection/secure-the-windows-10-boot-process
### Procesos de credenciales de autenticación de Windows
https://docs.microsoft.com/es-es/windows-server/security/windows-authentication/credentials-processes-in-windows-authentication

-------------
-------------

# Repaso de comunicación por red entre Windows y Linux
* https://www.jesusninoc.com/10/26/crear-una-comunicacion-entre-un-cliente-en-powershell-de-windows-y-un-servidor-en-bash-de-linux-utilizando-tcpip/

-------------
-------------

# Prueba
* https://www.youtube.com/watch?v=CibNbK9sp8A

---------------
---------------

# Introducción al sistema de archivos

## Ejemplos básicos sobre el sistema de archivos en PowerShell
* https://www.jesusninoc.com/11/03/ejercicios-de-powershell-ejercicios-basicos-sobre-el-sistema-de-archivos-en-powershell/

## Ejercicios sobre sistemas de archivos (mezclado con procesos)
* https://www.jesusninoc.com/11/04/ejercicios-de-powershell-ejercicios-sobre-sistemas-de-archivos-mezclado-con-procesos/

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Ejercicios sobre hilos

## Almacenar información sobre los hilos
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar información sobre los hilos del proceso Notepad 
* https://www.jesusninoc.com/11/17/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-del-proceso-notepad/

## Mostrar información sobre los hilos de todos los procesos que se están ejecutando (qué proceso ejecuta el hilo)
* https://www.jesusninoc.com/11/19/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-de-todos-los-procesos-que-se-estan-ejecutando-que-proceso-ejecuta-el-hilo/

## Listar hilos de cada proceso
* https://www.jesusninoc.com/07/22/listar-los-hilos-de-un-proceso/

## Almacenar información sobre hilos de forma continuada
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar los hilos de cada proceso utilizando WMI y el cmdlet Get-Process
* https://www.jesusninoc.com/11/23/ejercicios-de-powershell-mostrar-los-hilos-de-cada-proceso-utilizando-wmi-y-el-cmdlet-get-process/

## Relación entre servicios y procesos
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

## Ayuda de servicios con procesos
```PowerShell
foreach($elementos in (Get-WmiObject -Class Win32_Service))
{
    $elementos
}
Get-WmiObject -Class Win32_Service | %{
Write-Host $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```

## Ayuda de procesos WMI con procesos
```PowerShell
Get-WmiObject Win32_Process | %{
    $_.Handles,$_.ProcessHandle,(Get-Process -Id $_.ProcessHandle).ProcessName
}
Get-WmiObject Win32_Process | %{
    (Get-Process -Id $_.ProcessId),$_.ProcessName,$_.Handle,$_.ProcessId
}
```

## Almacenar el número de procesos e hilos en un fichero junto con la fecha (el script se ejecuta cada cinco segundos)
* https://www.jesusninoc.com/11/26/ejercicios-de-powershell-almacenar-el-numero-de-procesos-e-hilos-en-un-fichero-junto-con-la-fecha-el-script-se-ejecuta-cada-cinco-segundos/

# Servicios y relación con procesos
## No funciona porque no puede convertir ProcessID
```PowerShell
Get-WmiObject -Class Win32_Service | Select-Object Name,ProcessID, (Get-Process -Id ProcessID).name
```
## Sí funciona
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

# Procesos y ruta de ejecución del proceso
* https://www.jesusninoc.com/11/29/ejercicios-de-powershell-procesos-y-ruta-de-ejecucion-del-proceso/

# Ejercicios de PowerShell: saber la ruta de los servicios que se están ejecutando
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-saber-la-ruta-de-los-servicios-que-se-estan-ejecutando/

# Ejercicios de PowerShell: de la lista de hilos que se están ejecutando indicar si alguno es un hilo de un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-hilos-que-se-estan-ejecutando-indicar-si-alguno-es-un-hilo-de-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de la lista de procesos que se están ejecutando indicar si alguno es un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-procesos-que-se-estan-ejecutando-indicar-si-alguno-es-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de los servicios que se están ejecutando indicar el nombre del proceso
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-los-servicios-que-se-estan-ejecutando-indicar-el-nombre-del-proceso/

# Ejercicios de PowerShell: mostrar el padre de un hilo
* https://www.jesusninoc.com/09/29/ejercicios-de-powershell-mostrar-el-padre-de-un-hilo/

------------
------------

# Ejecutar comandos en PowerShell y Bash
## Bash
```Bash
echo ps
echo 'ps'
echo `ps`
```
## PowerShell
```PowerShell
$hola="Get-Process -Name notepad"
Invoke-Expression ($hola)
```

## Mezcla de comandos entre PowerShell y Bash
```PowerShell
for($i=1;$i -le 5;$i=$i+1)
{
    $multi=($i*100) 
    $nombre="fichero$i"
    $resultado=Invoke-SSHCommand -Index 0 ('echo' + $multi + ' >' + $nombre)
    $resultado.Output 
}
```
