# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Repaso de PowerShell
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/

# Ejercicios de repaso
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-los-procesos-ordenados-por-cpu-cuyo-nombre-indica-el-usuario-utilizar-un-fichero-para-almacenar-dicho-nombre/
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-los-procesos-cuyo-nombre-y-tiempo-de-consumo-de-cpu-indica-el-usuario-y-ordenarlos-por-cpu-utilizar-dos-ficheros-para-almacenar-el-nombre-y-el-tiempo-de-consumo/
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-un-numero-de-procesos-por-nombre-que-indica-el-usuario-y-ordenarlos-por-cpu/

-----------------
-----------------

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Creación y destrucción de procesos
## Creación de procesos (apartado Crear procesos)
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/
## Destrucción de procesos (apartado Matar procesos)
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

# Bash: agrupar
https://es.stackoverflow.com/questions/413298/agrupar-y-sumar-datos-de-un-csv-con-bash-o-awk

# Más información sobre procesos
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

--------------------

# Ejercicio con Base64
## Ejercicio resuelto de CREAR TABLA DE BASE64
https://www.jesusninoc.com/2017/02/11/tabla-de-caracteres-base64/

## EJECUTAR UN START-PROCESS (CREAR UN PROCESO)
```PowerShell
Start-Process -FilePath powershell.exe -ArgumentList '-encodedcommand RwBlAHQALQBQAHIAbwBjAGUAcwBzAA=='
```

## Ejecutar un cmdlet codificado en Base64
https://www.jesusninoc.com/2016/09/24/ejecutar-un-cmdlet-convertido-en-base64/

# Para repasar
- https://github.com/jesnino/PowerShell
- https://github.com/jesnino/PowerShell/tree/master/Repaso
- https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Ejercicios PowerShell hilos y procesos
* https://www.jesusninoc.com/01/01/ejercicios-de-powershell-ejercicios-de-hilos/

## Obtener el nombre de un proceso y el número de hilos de cada proceso
* https://www.jesusninoc.com/09/28/ejercicios-de-powershell-obtener-el-nombre-de-un-proceso-y-el-numero-de-hilos-de-cada-proceso/

## Obtener el identificador del hilo junto con el nombre del proceso que lo creó
* https://www.jesusninoc.com/09/28/ejercicios-de-powershell-obtener-el-identificador-del-hilo-junto-con-el-nombre-del-proceso-que-lo-creo/

## Ejercicios de PowerShell: conocer los procesos padres y abuelos (padres de padres) de todos los hilos que se están ejecutando en el sistema
* https://www.jesusninoc.com/09/28/ejercicios-de-powershell-conocer-los-procesos-padres-y-abuelos-padres-de-padres-de-todos-los-hilos-que-se-estan-ejecutando-en-el-sistema/

## Ejercicios de PowerShell: pedir al usuario un número de hilo y mostrar el nombre del proceso padre que crea el hilo y el abuelo 
* https://www.jesusninoc.com/09/28/ejercicios-de-powershell-pedir-al-usuario-un-numero-de-hilo-y-mostrar-el-nombre-del-proceso-padre-que-crea-el-hilo-y-el-abuelo/

-----------------
-----------------

# Corrección del examen (proceso de mayor tiempo de consumo de CPU):
- Utilizando variables
- Utilizando if
- Utilizando foreach

------------------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Memoria

## Ejercicios PowerShell sobre variables

### Mostrar un char desde un int
```PowerShell
[Int]'A'[0]
```
### Mostrar un int desde un char
```PowerShell
[Char]65
```
### Ejecutar un cmdlet leyendo desde un fichero el cmdlet
```PowerShell
"gps" | Out-File ejecutar.txt
Invoke-Expression (gc .\ejecutar.txt)
```
### Modificar el contenido de un fichero
```PowerShell
1 | Out-File ejemplo1.txt
(gc ejemplo1.txt)+"modificado" | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
### Modificar el contenido de un fichero (leer un número de un fichero y sumar un número, después almacenar el valor)
* https://www.jesusninoc.com/11/13/ejercicios-de-powershell-modificar-el-contenido-de-un-fichero-leer-un-numero-de-un-fichero-y-sumar-un-numero-despues-almacenar-el-valor/
### Modificar el contenido de un fichero (leer un número de un fichero y restar un número, después almacenar el valor)
* https://www.jesusninoc.com/11/15/ejercicios-de-powershell-modificar-el-contenido-de-un-fichero-utilizando-variables-leer-un-numero-de-un-fichero-y-restar-un-numero-despues-almacenar-el-valor/
### Modificar el contenido de un fichero utilizando variables (leer un número de un fichero y restar un número, después almacenar el valor)
* https://www.jesusninoc.com/11/15/ejercicios-de-powershell-modificar-el-contenido-de-un-fichero-utilizando-variables-leer-un-numero-de-un-fichero-y-restar-un-numero-despues-almacenar-el-valor/
### Listar la mitad de un número de procesos y ordenarlos (el usuario introduce los valores en variables y los almacena en ficheros)
```PowerShell
$first = Read-Host "intro first"
$first | Out-File first.txt

$orden = Read-Host "intro orden"
$orden | Out-File orden.txt
gps | select -First ([Int ]$first / 2) | sort $orden
```

### Guardar un valor aleatorio en un fichero
```PowerShell
(Get-Random (1..5)) | Out-File aleatorio.txt
```
