# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Ejercicio de almacenar en un fichero los procesos que se están ejecutando y la fecha actual

## Solución simple:
* https://www.jesusninoc.com/09/14/ejercicios-de-powershell-almacenar-en-un-fichero-los-procesos-que-se-estan-ejecutando-y-la-fecha-actual/#Solucion_simple

## Solución avanzada creando alias:
* https://www.jesusninoc.com/09/14/ejercicios-de-powershell-almacenar-en-un-fichero-los-procesos-que-se-estan-ejecutando-y-la-fecha-actual/#Solucion_avanzada_creando_alias

## Solución con ofuscación:
* https://www.jesusninoc.com/09/06/utilizar-alias-ofuscacion-en-powershell/

# Cmdlets básicos en PowerShell
## 1. Introducción a PowerShell (nivel intermedio)
* https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/
## Operadores de comparación
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Operaciones_de_comparacion  

# Ejercicios sencillos
## Ejercicios básicos sobre procesos
- Listar procesos por propiedades.
- Listar todos los procesos.
- Mostrar los 5 primeros procesos.
- Mostrar los 5 últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Agrupa los procesos y muestras los que sean svchost.
- Ordena el consumo de CPU de forma descendente.
- Abre 5 notepad, ordena por el consumo de CPU.
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
- Obtener los 5 primeros procesos ordenados.
- Listar los procesos que tengan consumo alto de tiempo de CPU.
- Listar los procesos junto el fabricante.
- Mostrar información sobre el proceso notepad.

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

https://www.jesusninoc.com/temarios-de-asignaturas/ -> https://www.jesusninoc.com/09/01/tecnico-superior-en-administracion-de-sistemas-informaticos-en-red/ -> https://www.jesusninoc.com/12/07/instalacion-de-software-libre-y-propietario-implantacion-de-sistemas-operativos/#Funciones_de_un_sistema_operativo

-----------------

# Funciones del sistema operativo:
- Procesos
- Recursos
- Interfaces de usuario

# Ejercicios sencillos

## Ejercicios básicos sobre procesos (qué palabra necesitas: listar, agrupar, seleccionar, abrir, ordenar)
- Listar procesos por propiedades.
- Listar todos los procesos.
- Mostrar los 5 primeros procesos.
- Mostrar los 5 últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Agrupa los procesos y muestras los que sean svchost.
- Ordena el consumo de CPU de forma descendente.
- Abre 5 notepad, ordena por el consumo de CPU.
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
- Obtener los 5 primeros procesos ordenados.
- Listar los procesos que tengan consumo alto de tiempo de CPU.
- Listar los procesos junto el fabricante.
- Mostrar información sobre el proceso notepad.

------------------

# Ejercicios nivel medio

## Guardar en un fichero la versión de Windows utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-de-windows-utilizando-un-cmdlet/

## Guardar en un fichero la versión del núcleo de Linux utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-del-nucleo-de-linux-wsl-utilizando-un-cmdlet-de-powershell/

## Ejercicio propuesto
### Comparar la ejecución de procesos en dos momentos distintos (arrancar Notepad)
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/#Comparar

-------------------

# Ejercicios propuestos

## Juntar dos ficheros con información (fichero con fecha y fichero con procesos que se ejecutan):
* https://www.jesusninoc.com/11/02/ejercicios-de-powershell-juntar-dos-ficheros-con-informacion-fichero-con-fecha-y-fichero-con-procesos-que-se-ejecutan/

## Ejecutar un comando que se encuentra escrito en una cadena:
* https://www.jesusninoc.com/11/03/ejercicios-de-powershell-ejecutar-un-comando-que-se-encuentra-escrito-en-una-cadena/

## Mostrar los procesos con un Where:
* https://www.jesusninoc.com/11/04/ejercicios-de-powershell-mostrar-informacion-sobre-un-proceso-que-se-esta-ejecutando-con-un-where/

## Abrir procesos leyendo desde un fichero (en un fichero aparece el número de veces que se abre el proceso y en otro fichero aparece el nombre del proceso que queremos abrir)
* https://www.jesusninoc.com/11/05/ejercicios-de-powershell-abrir-procesos-leyendo-desde-un-fichero-en-un-fichero-aparece-el-numero-de-veces-que-se-abre-el-proceso-y-en-otro-fichero-aparece-el-nombre-del-proceso-que-queremos-abrir/

## Parar el proceso leyendo desde un fichero el nombre del proceso que vamos a parar (el nombre del proceso que vamos a parar se almacena mediante un Out-File siendo el primer proceso)
* https://www.jesusninoc.com/11/06/ejercicios-de-powershell-parar-el-proceso-leyendo-desde-un-fichero-el-nombre-del-proceso-que-vamos-a-parar-el-nombre-del-proceso-que-vamos-a-parar-se-almacena-mediante-un-out-file-siendo-el-primer-p/

------------------

# Ejercicios básicos sobre procesos en PowerShell (con alias)
* https://www.jesusninoc.com/09/22/ejercicios-de-powershell-ejercicios-basicos-sobre-procesos-en-powershell-con-alias/

-----------

# Ejercicios básicos sobre procesos en Linux
* https://www.jesusninoc.com/03/11/ejercicios-basicos-sobre-procesos-en-linux/

# Ejercicios avanzados
* Convertir 1. Introducción a PowerShell (nivel intermedio) en WSL
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario y almacena en un fichero

### Ayuda:
```PowerShell
ps | sort cpu
```
```PowerShell
ps | sort cpu | select -First 5
ps | sort cpu -Descending | select -First 5
```
```PowerShell
ps | select -First 5 | sort cpu
ps | select -First 5 | sort cpu -Descending
```
```PowerShell
ps | select -First (Read-Host) | sort (Read-Host)
ps | select -First (gc numero) | sort (gc buscar)
```
```PowerShell
$guardarnumero = Read-Host "Dime número de procesos a listar"
$guardarnumero | Out-File numerodeprocesos.txt
Get-Content .\numerodeprocesos.txt

$guardarvalor = Read-Host "Dime por qué valor ordenar"
$guardarvalor | Out-File numerodevalores.txt
Get-Content .\numerodevalores.txt

Get-Process | Select-Object -First (Get-Content .\numerodeprocesos.txt) | Sort-Object (Get-Content .\numerodevalores.txt)
```

--------------------
--------------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Repaso de PowerShell
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/

# Ejercicios de repaso
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-los-procesos-ordenados-por-cpu-cuyo-nombre-indica-el-usuario-utilizar-un-fichero-para-almacenar-dicho-nombre/
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-los-procesos-cuyo-nombre-y-tiempo-de-consumo-de-cpu-indica-el-usuario-y-ordenarlos-por-cpu-utilizar-dos-ficheros-para-almacenar-el-nombre-y-el-tiempo-de-consumo/
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-un-numero-de-procesos-por-nombre-que-indica-el-usuario-y-ordenarlos-por-cpu/

------------
------------

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

-----------------

# Funciones del sistema operativo:
- Procesos
- Recursos
- Interfaces de usuario

# Ejercicios sencillos

## Ejercicios básicos sobre procesos (qué palabra necesitas: listar, agrupar, seleccionar, abrir, ordenar)
- Listar procesos por propiedades.
- Listar todos los procesos.
- Mostrar los 5 primeros procesos.
- Mostrar los 5 últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Agrupa los procesos y muestras los que sean svchost.
- Ordena el consumo de CPU de forma descendente.
- Abre 5 notepad, ordena por el consumo de CPU.
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
- Obtener los 5 primeros procesos ordenados.
- Listar los procesos que tengan consumo alto de tiempo de CPU.
- Listar los procesos junto el fabricante.
- Mostrar información sobre el proceso notepad.

------------------

# Ejercicios nivel medio

## Guardar en un fichero la versión de Windows utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-de-windows-utilizando-un-cmdlet/

## Guardar en un fichero la versión del núcleo de Linux utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-del-nucleo-de-linux-wsl-utilizando-un-cmdlet-de-powershell/

## Ejercicio propuesto
### Comparar la ejecución de procesos en dos momentos distintos (arrancar Notepad)
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/#Comparar

-------------------

# Ejercicios propuestos

## Juntar dos ficheros con información (fichero con fecha y fichero con procesos que se ejecutan):
* https://www.jesusninoc.com/11/02/ejercicios-de-powershell-juntar-dos-ficheros-con-informacion-fichero-con-fecha-y-fichero-con-procesos-que-se-ejecutan/

## Ejecutar un comando que se encuentra escrito en una cadena:
* https://www.jesusninoc.com/11/03/ejercicios-de-powershell-ejecutar-un-comando-que-se-encuentra-escrito-en-una-cadena/

## Mostrar los procesos con un Where:
* https://www.jesusninoc.com/11/04/ejercicios-de-powershell-mostrar-informacion-sobre-un-proceso-que-se-esta-ejecutando-con-un-where/

## Abrir procesos leyendo desde un fichero (en un fichero aparece el número de veces que se abre el proceso y en otro fichero aparece el nombre del proceso que queremos abrir)
* https://www.jesusninoc.com/11/05/ejercicios-de-powershell-abrir-procesos-leyendo-desde-un-fichero-en-un-fichero-aparece-el-numero-de-veces-que-se-abre-el-proceso-y-en-otro-fichero-aparece-el-nombre-del-proceso-que-queremos-abrir/

## Parar el proceso leyendo desde un fichero el nombre del proceso que vamos a parar (el nombre del proceso que vamos a parar se almacena mediante un Out-File siendo el primer proceso)
* https://www.jesusninoc.com/11/06/ejercicios-de-powershell-parar-el-proceso-leyendo-desde-un-fichero-el-nombre-del-proceso-que-vamos-a-parar-el-nombre-del-proceso-que-vamos-a-parar-se-almacena-mediante-un-out-file-siendo-el-primer-p/

------------------

# Ejercicios básicos sobre procesos en PowerShell (con alias)
* https://www.jesusninoc.com/09/22/ejercicios-de-powershell-ejercicios-basicos-sobre-procesos-en-powershell-con-alias/

-----------

# Ejercicios básicos sobre procesos en Linux
* https://www.jesusninoc.com/03/11/ejercicios-basicos-sobre-procesos-en-linux/

# Ejercicios avanzados
* Convertir 1. Introducción a PowerShell (nivel intermedio) en WSL
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario y almacena en un fichero

### Ayuda:
```PowerShell
ps | sort cpu
```
```PowerShell
ps | sort cpu | select -First 5
ps | sort cpu -Descending | select -First 5
```
```PowerShell
ps | select -First 5 | sort cpu
ps | select -First 5 | sort cpu -Descending
```
```PowerShell
ps | select -First (Read-Host) | sort (Read-Host)
ps | select -First (gc numero) | sort (gc buscar)
```
```PowerShell
$guardarnumero = Read-Host "Dime número de procesos a listar"
$guardarnumero | Out-File numerodeprocesos.txt
Get-Content .\numerodeprocesos.txt

$guardarvalor = Read-Host "Dime por qué valor ordenar"
$guardarvalor | Out-File numerodevalores.txt
Get-Content .\numerodevalores.txt

Get-Process | Select-Object -First (Get-Content .\numerodeprocesos.txt) | Sort-Object (Get-Content .\numerodevalores.txt)
```
