# Instalación de software libre y propietario (sistemas operativos, Windows, Linux, scripting, PowerShell, virtualización, resolución de incidencias)

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.
- Arquitectura de un sistema operativo. Sistemas por lotes (batch). Sistemas por lotes con multiprogramación. Sistemas de tiempo compartido. Sistemas distribuidos.
- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.
- Tipos de sistemas operativos.
  - Monousuario o multiusuario
  - Centralizado o distribuido
  - Monotarea o multitarea
  - Uniprocesador o multiprocesador
  - Instalables y/o autoarrancables.
- Sistemas operativos libres.
- Sistemas operativos propietarios.
- Tipos de aplicaciones. Software de sistema. Software de programación. Software de aplicación.
- Licencias y tipos de licencias. Según los derechos que cada autor se reserva sobre su obra. Según su destinatario.
- Máquinas virtuales (M.V.)
  - Concepto de virtualización del hardware y características de los principales productos software libre y propietario, para el uso de máquinas virtuales.
  - Creación y personalización de M.V.
  - Ventajas e inconvenientes de la virtualización.
- Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
  - Particionado del disco duro.
  - En sistemas Windows determinar la partición donde instalaremos el S.O.
  - En sistemas Linux determinar las particiones para los distintos puntos de montaje.
  - Controladores (drivers) de almacenamiento necesarios.
- Instalación de sistemas operativos.
  - Requisitos hardware, versiones y licencias.
  - Soporte utilizado para la instalación: CD/DVD, Pendrive, LAN.
  - Datos necesarios para la instalación: usuarios, contraseñas, nombre del equipo, direcciones IP, número de licencia, etc.
- Gestión de varios sistemas operativos en un ordenador.
  - Requisitos previos. Administración del espacio del disco. Particionado y redimensionado.
  - Problemas con el registro maestro de arranque (MBR). Elegir un gestor de arranque compatible con todos los sistemas operativos a instalar.
  - Preparar las particiones de los S.O. para permitir su arranque.
  - Analizar el orden en la instalación de los sistemas operativos.
- Gestores de arranque.
  - Código de arranque maestro (Master Boot Code).
  - Formatos tabla de particiones. Master Boot Record (MBR) y Guid Partition Table (GPT).
  - Configuración de los gestores de arranque de los sistemas operativos libres y propietarios.
  - Reparación del gestor de arranque.
  - Sustitución del gestor de arranque estándar por otro más completo.
- Instalación/desinstalación de aplicaciones. Requisitos hardware y software, versiones y licencias.
- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
- Ficheros necesarios para el arranque de los principales sistemas operativos.
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
- Actualización y mantenimiento de controladores de dispositivos.
  - Automatizar la actualización de controladores.
  - Volver a una versión anterior de un controlador.
  - Actualización manual de los controladores.

# Instalación de software libre y propietario

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.

# Núcleo
## Comandos Kernel
* https://www.jesusninoc.com/09/09/comandos-informacion-sobre-el-kernel-de-linux/

## Comandos versión Windows
* https://www.jesusninoc.com/09/09/obtener-informacion-sobre-la-version-de-windows-con-powershell/

# Cmdlets básicos en PowerShell
## 1. Introducción a PowerShell para administradores de sistemas (nivel básico)
* https://www.jesusninoc.com/2016/09/26/1-introduccion-a-powershell-para-administradores-de-sistemas/
## 1. Introducción a PowerShell (nivel intermedio)
* https://amzn.to/4dCe3pi

--------------------
--------------------

# Instalación de software libre y propietario

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.
- Arquitectura de un sistema operativo. Sistemas por lotes (batch). Sistemas por lotes con multiprogramación. Sistemas de tiempo compartido. Sistemas distribuidos.

# Repaso día anterior

## Concepto de núcleo

## Instalar Ubuntu en VirtualBox

## 1. Introducción a PowerShell (nivel intermedio)
* https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/

## Ejercicios
## Guardar en un fichero la versión de Windows utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-de-windows-utilizando-un-cmdlet/

## Guardar en un fichero la versión del núcleo de Linux utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-del-nucleo-de-linux-wsl-utilizando-un-cmdlet-de-powershell/

## Ejercicio propuesto
### Comparar la ejecución de procesos en dos momentos distintos (arrancar Notepad)
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/#Comparar

---------------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Ejercicio de almacenar en un fichero los procesos que se están ejecutando y la fecha actual

## Solución simple:
* https://www.jesusninoc.com/09/14/ejercicios-de-powershell-almacenar-en-un-fichero-los-procesos-que-se-estan-ejecutando-y-la-fecha-actual/#Solucion_simple

## Solución avanzada creando alias:
* https://www.jesusninoc.com/09/14/ejercicios-de-powershell-almacenar-en-un-fichero-los-procesos-que-se-estan-ejecutando-y-la-fecha-actual/#Solucion_avanzada_creando_alias

## Solución con ofuscación:
* https://www.jesusninoc.com/09/06/utilizar-alias-ofuscacion-en-powershell/

# Cmdlets básicos en PowerShell
## 1. Introducción a PowerShell (nivel intermedio)
* https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/
## Operadores de comparación
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Operaciones_de_comparacion  

# Ejercicios sencillos
## Ejercicios básicos sobre procesos
- Listar procesos por propiedades.
- Listar todos los procesos.
- Mostrar los 5 primeros procesos.
- Mostrar los 5 últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Agrupa los procesos y muestras los que sean svchost.
- Ordena el consumo de CPU de forma descendente.
- Abre 5 notepad, ordena por el consumo de CPU.
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
- Obtener los 5 primeros procesos ordenados.
- Listar los procesos que tengan consumo alto de tiempo de CPU.
- Listar los procesos junto el fabricante.
- Mostrar información sobre el proceso notepad.
