# Instalación de software libre y propietario (sistemas operativos, Windows, Linux, scripting, PowerShell, virtualización, resolución de incidencias)

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.
- Arquitectura de un sistema operativo. Sistemas por lotes (batch). Sistemas por lotes con multiprogramación. Sistemas de tiempo compartido. Sistemas distribuidos.
- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.
- Tipos de sistemas operativos.
  - Monousuario o multiusuario
  - Centralizado o distribuido
  - Monotarea o multitarea
  - Uniprocesador o multiprocesador
  - Instalables y/o autoarrancables.
- Sistemas operativos libres.
- Sistemas operativos propietarios.
- Tipos de aplicaciones. Software de sistema. Software de programación. Software de aplicación.
- Licencias y tipos de licencias. Según los derechos que cada autor se reserva sobre su obra. Según su destinatario.
- Máquinas virtuales (M.V.)
  - Concepto de virtualización del hardware y características de los principales productos software libre y propietario, para el uso de máquinas virtuales.
  - Creación y personalización de M.V.
  - Ventajas e inconvenientes de la virtualización.
- Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
  - Particionado del disco duro.
  - En sistemas Windows determinar la partición donde instalaremos el S.O.
  - En sistemas Linux determinar las particiones para los distintos puntos de montaje.
  - Controladores (drivers) de almacenamiento necesarios.
- Instalación de sistemas operativos.
  - Requisitos hardware, versiones y licencias.
  - Soporte utilizado para la instalación: CD/DVD, Pendrive, LAN.
  - Datos necesarios para la instalación: usuarios, contraseñas, nombre del equipo, direcciones IP, número de licencia, etc.
- Gestión de varios sistemas operativos en un ordenador.
  - Requisitos previos. Administración del espacio del disco. Particionado y redimensionado.
  - Problemas con el registro maestro de arranque (MBR). Elegir un gestor de arranque compatible con todos los sistemas operativos a instalar.
  - Preparar las particiones de los S.O. para permitir su arranque.
  - Analizar el orden en la instalación de los sistemas operativos.
- Gestores de arranque.
  - Código de arranque maestro (Master Boot Code).
  - Formatos tabla de particiones. Master Boot Record (MBR) y Guid Partition Table (GPT).
  - Configuración de los gestores de arranque de los sistemas operativos libres y propietarios.
  - Reparación del gestor de arranque.
  - Sustitución del gestor de arranque estándar por otro más completo.
- Instalación/desinstalación de aplicaciones. Requisitos hardware y software, versiones y licencias.
- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
- Ficheros necesarios para el arranque de los principales sistemas operativos.
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
- Actualización y mantenimiento de controladores de dispositivos.
  - Automatizar la actualización de controladores.
  - Volver a una versión anterior de un controlador.
  - Actualización manual de los controladores.

# Instalación de software libre y propietario

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.

# Núcleo
## Comandos Kernel
* https://www.jesusninoc.com/09/09/comandos-informacion-sobre-el-kernel-de-linux/

## Comandos versión Windows
* https://www.jesusninoc.com/09/09/obtener-informacion-sobre-la-version-de-windows-con-powershell/

# Cmdlets básicos en PowerShell
## 1. Introducción a PowerShell para administradores de sistemas (nivel básico)
* https://www.jesusninoc.com/2016/09/26/1-introduccion-a-powershell-para-administradores-de-sistemas/
## 1. Introducción a PowerShell (nivel intermedio)
* https://amzn.to/4dCe3pi

--------------------
--------------------

# Instalación de software libre y propietario

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.
- Arquitectura de un sistema operativo. Sistemas por lotes (batch). Sistemas por lotes con multiprogramación. Sistemas de tiempo compartido. Sistemas distribuidos.

# Repaso día anterior

## Concepto de núcleo

## Instalar Ubuntu en VirtualBox

## 1. Introducción a PowerShell (nivel intermedio)
* https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/

## Ejercicios
## Guardar en un fichero la versión de Windows utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-de-windows-utilizando-un-cmdlet/

## Guardar en un fichero la versión del núcleo de Linux utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-del-nucleo-de-linux-wsl-utilizando-un-cmdlet-de-powershell/

## Ejercicio propuesto
### Comparar la ejecución de procesos en dos momentos distintos (arrancar Notepad)
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/#Comparar

---------------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Ejercicio de almacenar en un fichero los procesos que se están ejecutando y la fecha actual

## Solución simple:
* https://www.jesusninoc.com/09/14/ejercicios-de-powershell-almacenar-en-un-fichero-los-procesos-que-se-estan-ejecutando-y-la-fecha-actual/#Solucion_simple

## Solución avanzada creando alias:
* https://www.jesusninoc.com/09/14/ejercicios-de-powershell-almacenar-en-un-fichero-los-procesos-que-se-estan-ejecutando-y-la-fecha-actual/#Solucion_avanzada_creando_alias

## Solución con ofuscación:
* https://www.jesusninoc.com/09/06/utilizar-alias-ofuscacion-en-powershell/

# Cmdlets básicos en PowerShell
## 1. Introducción a PowerShell (nivel intermedio)
* https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/
## Operadores de comparación
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Operaciones_de_comparacion  

# Ejercicios sencillos
## Ejercicios básicos sobre procesos
- Listar procesos por propiedades.
- Listar todos los procesos.
- Mostrar los 5 primeros procesos.
- Mostrar los 5 últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Agrupa los procesos y muestras los que sean svchost.
- Ordena el consumo de CPU de forma descendente.
- Abre 5 notepad, ordena por el consumo de CPU.
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
- Obtener los 5 primeros procesos ordenados.
- Listar los procesos que tengan consumo alto de tiempo de CPU.
- Listar los procesos junto el fabricante.
- Mostrar información sobre el proceso notepad.

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

https://www.jesusninoc.com/temarios-de-asignaturas/ -> https://www.jesusninoc.com/09/01/tecnico-superior-en-administracion-de-sistemas-informaticos-en-red/ -> https://www.jesusninoc.com/12/07/instalacion-de-software-libre-y-propietario-implantacion-de-sistemas-operativos/#Funciones_de_un_sistema_operativo

-----------------

# Funciones del sistema operativo:
- Procesos
- Recursos
- Interfaces de usuario

# Ejercicios sencillos

## Ejercicios básicos sobre procesos (qué palabra necesitas: listar, agrupar, seleccionar, abrir, ordenar)
- Listar procesos por propiedades.
- Listar todos los procesos.
- Mostrar los 5 primeros procesos.
- Mostrar los 5 últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Agrupa los procesos y muestras los que sean svchost.
- Ordena el consumo de CPU de forma descendente.
- Abre 5 notepad, ordena por el consumo de CPU.
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
- Obtener los 5 primeros procesos ordenados.
- Listar los procesos que tengan consumo alto de tiempo de CPU.
- Listar los procesos junto el fabricante.
- Mostrar información sobre el proceso notepad.

------------------

# Ejercicios nivel medio

## Guardar en un fichero la versión de Windows utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-de-windows-utilizando-un-cmdlet/

## Guardar en un fichero la versión del núcleo de Linux utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-del-nucleo-de-linux-wsl-utilizando-un-cmdlet-de-powershell/

## Ejercicio propuesto
### Comparar la ejecución de procesos en dos momentos distintos (arrancar Notepad)
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/#Comparar

-------------------

# Ejercicios propuestos

## Juntar dos ficheros con información (fichero con fecha y fichero con procesos que se ejecutan):
* https://www.jesusninoc.com/11/02/ejercicios-de-powershell-juntar-dos-ficheros-con-informacion-fichero-con-fecha-y-fichero-con-procesos-que-se-ejecutan/

## Ejecutar un comando que se encuentra escrito en una cadena:
* https://www.jesusninoc.com/11/03/ejercicios-de-powershell-ejecutar-un-comando-que-se-encuentra-escrito-en-una-cadena/

## Mostrar los procesos con un Where:
* https://www.jesusninoc.com/11/04/ejercicios-de-powershell-mostrar-informacion-sobre-un-proceso-que-se-esta-ejecutando-con-un-where/

## Abrir procesos leyendo desde un fichero (en un fichero aparece el número de veces que se abre el proceso y en otro fichero aparece el nombre del proceso que queremos abrir)
* https://www.jesusninoc.com/11/05/ejercicios-de-powershell-abrir-procesos-leyendo-desde-un-fichero-en-un-fichero-aparece-el-numero-de-veces-que-se-abre-el-proceso-y-en-otro-fichero-aparece-el-nombre-del-proceso-que-queremos-abrir/

## Parar el proceso leyendo desde un fichero el nombre del proceso que vamos a parar (el nombre del proceso que vamos a parar se almacena mediante un Out-File siendo el primer proceso)
* https://www.jesusninoc.com/11/06/ejercicios-de-powershell-parar-el-proceso-leyendo-desde-un-fichero-el-nombre-del-proceso-que-vamos-a-parar-el-nombre-del-proceso-que-vamos-a-parar-se-almacena-mediante-un-out-file-siendo-el-primer-p/

------------------

# Ejercicios básicos sobre procesos en PowerShell (con alias)
* https://www.jesusninoc.com/09/22/ejercicios-de-powershell-ejercicios-basicos-sobre-procesos-en-powershell-con-alias/

-----------

# Ejercicios básicos sobre procesos en Linux
* https://www.jesusninoc.com/03/11/ejercicios-basicos-sobre-procesos-en-linux/

# Ejercicios avanzados
* Convertir 1. Introducción a PowerShell (nivel intermedio) en WSL
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario y almacena en un fichero

### Ayuda:
```PowerShell
ps | sort cpu
```
```PowerShell
ps | sort cpu | select -First 5
ps | sort cpu -Descending | select -First 5
```
```PowerShell
ps | select -First 5 | sort cpu
ps | select -First 5 | sort cpu -Descending
```
```PowerShell
ps | select -First (Read-Host) | sort (Read-Host)
ps | select -First (gc numero) | sort (gc buscar)
```
```PowerShell
$guardarnumero = Read-Host "Dime número de procesos a listar"
$guardarnumero | Out-File numerodeprocesos.txt
Get-Content .\numerodeprocesos.txt

$guardarvalor = Read-Host "Dime por qué valor ordenar"
$guardarvalor | Out-File numerodevalores.txt
Get-Content .\numerodevalores.txt

Get-Process | Select-Object -First (Get-Content .\numerodeprocesos.txt) | Sort-Object (Get-Content .\numerodevalores.txt)
```

--------------------
--------------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Repaso de PowerShell
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/

# Ejercicios de repaso
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-los-procesos-ordenados-por-cpu-cuyo-nombre-indica-el-usuario-utilizar-un-fichero-para-almacenar-dicho-nombre/
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-los-procesos-cuyo-nombre-y-tiempo-de-consumo-de-cpu-indica-el-usuario-y-ordenarlos-por-cpu-utilizar-dos-ficheros-para-almacenar-el-nombre-y-el-tiempo-de-consumo/
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-un-numero-de-procesos-por-nombre-que-indica-el-usuario-y-ordenarlos-por-cpu/

------------
------------

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

-----------------

# Funciones del sistema operativo:
- Procesos
- Recursos
- Interfaces de usuario

# Ejercicios sencillos

## Ejercicios básicos sobre procesos (qué palabra necesitas: listar, agrupar, seleccionar, abrir, ordenar)
- Listar procesos por propiedades.
- Listar todos los procesos.
- Mostrar los 5 primeros procesos.
- Mostrar los 5 últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Agrupa los procesos y muestras los que sean svchost.
- Ordena el consumo de CPU de forma descendente.
- Abre 5 notepad, ordena por el consumo de CPU.
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
- Obtener los 5 primeros procesos ordenados.
- Listar los procesos que tengan consumo alto de tiempo de CPU.
- Listar los procesos junto el fabricante.
- Mostrar información sobre el proceso notepad.

------------------

# Ejercicios nivel medio

## Guardar en un fichero la versión de Windows utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-de-windows-utilizando-un-cmdlet/

## Guardar en un fichero la versión del núcleo de Linux utilizando un cmdlet
* https://www.jesusninoc.com/09/14/guardar-en-un-fichero-la-version-del-nucleo-de-linux-wsl-utilizando-un-cmdlet-de-powershell/

## Ejercicio propuesto
### Comparar la ejecución de procesos en dos momentos distintos (arrancar Notepad)
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/#Comparar

-------------------

# Ejercicios propuestos

## Juntar dos ficheros con información (fichero con fecha y fichero con procesos que se ejecutan):
* https://www.jesusninoc.com/11/02/ejercicios-de-powershell-juntar-dos-ficheros-con-informacion-fichero-con-fecha-y-fichero-con-procesos-que-se-ejecutan/

## Ejecutar un comando que se encuentra escrito en una cadena:
* https://www.jesusninoc.com/11/03/ejercicios-de-powershell-ejecutar-un-comando-que-se-encuentra-escrito-en-una-cadena/

## Mostrar los procesos con un Where:
* https://www.jesusninoc.com/11/04/ejercicios-de-powershell-mostrar-informacion-sobre-un-proceso-que-se-esta-ejecutando-con-un-where/

## Abrir procesos leyendo desde un fichero (en un fichero aparece el número de veces que se abre el proceso y en otro fichero aparece el nombre del proceso que queremos abrir)
* https://www.jesusninoc.com/11/05/ejercicios-de-powershell-abrir-procesos-leyendo-desde-un-fichero-en-un-fichero-aparece-el-numero-de-veces-que-se-abre-el-proceso-y-en-otro-fichero-aparece-el-nombre-del-proceso-que-queremos-abrir/

## Parar el proceso leyendo desde un fichero el nombre del proceso que vamos a parar (el nombre del proceso que vamos a parar se almacena mediante un Out-File siendo el primer proceso)
* https://www.jesusninoc.com/11/06/ejercicios-de-powershell-parar-el-proceso-leyendo-desde-un-fichero-el-nombre-del-proceso-que-vamos-a-parar-el-nombre-del-proceso-que-vamos-a-parar-se-almacena-mediante-un-out-file-siendo-el-primer-p/

------------------

# Ejercicios básicos sobre procesos en PowerShell (con alias)
* https://www.jesusninoc.com/09/22/ejercicios-de-powershell-ejercicios-basicos-sobre-procesos-en-powershell-con-alias/

-----------

# Ejercicios básicos sobre procesos en Linux
* https://www.jesusninoc.com/03/11/ejercicios-basicos-sobre-procesos-en-linux/

# Ejercicios avanzados
* Convertir 1. Introducción a PowerShell (nivel intermedio) en WSL
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario y almacena en un fichero

### Ayuda:
```PowerShell
ps | sort cpu
```
```PowerShell
ps | sort cpu | select -First 5
ps | sort cpu -Descending | select -First 5
```
```PowerShell
ps | select -First 5 | sort cpu
ps | select -First 5 | sort cpu -Descending
```
```PowerShell
ps | select -First (Read-Host) | sort (Read-Host)
ps | select -First (gc numero) | sort (gc buscar)
```
```PowerShell
$guardarnumero = Read-Host "Dime número de procesos a listar"
$guardarnumero | Out-File numerodeprocesos.txt
Get-Content .\numerodeprocesos.txt

$guardarvalor = Read-Host "Dime por qué valor ordenar"
$guardarvalor | Out-File numerodevalores.txt
Get-Content .\numerodevalores.txt

Get-Process | Select-Object -First (Get-Content .\numerodeprocesos.txt) | Sort-Object (Get-Content .\numerodevalores.txt)
```

--------------------
--------------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Repaso de PowerShell
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/

# Ejercicios de repaso
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-los-procesos-ordenados-por-cpu-cuyo-nombre-indica-el-usuario-utilizar-un-fichero-para-almacenar-dicho-nombre/
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-los-procesos-cuyo-nombre-y-tiempo-de-consumo-de-cpu-indica-el-usuario-y-ordenarlos-por-cpu-utilizar-dos-ficheros-para-almacenar-el-nombre-y-el-tiempo-de-consumo/
* https://www.jesusninoc.com/09/23/ejercicios-de-powershell-mostrar-un-numero-de-procesos-por-nombre-que-indica-el-usuario-y-ordenarlos-por-cpu/

-----------------
-----------------

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Creación y destrucción de procesos
## Creación de procesos (apartado Crear procesos)
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/
## Destrucción de procesos (apartado Matar procesos)
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

# Bash: agrupar
https://es.stackoverflow.com/questions/413298/agrupar-y-sumar-datos-de-un-csv-con-bash-o-awk

# Más información sobre procesos
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

--------------------

# Ejercicio con Base64
## Ejercicio resuelto de CREAR TABLA DE BASE64
https://www.jesusninoc.com/2017/02/11/tabla-de-caracteres-base64/

## EJECUTAR UN START-PROCESS (CREAR UN PROCESO)
```PowerShell
Start-Process -FilePath powershell.exe -ArgumentList '-encodedcommand RwBlAHQALQBQAHIAbwBjAGUAcwBzAA=='
```

## Ejecutar un cmdlet codificado en Base64
https://www.jesusninoc.com/2016/09/24/ejecutar-un-cmdlet-convertido-en-base64/

# Para repasar
- https://github.com/jesnino/PowerShell
- https://github.com/jesnino/PowerShell/tree/master/Repaso
- https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Ejercicios PowerShell hilos y procesos
* https://www.jesusninoc.com/01/01/ejercicios-de-powershell-ejercicios-de-hilos/

## Obtener el nombre de un proceso y el número de hilos de cada proceso
* https://www.jesusninoc.com/09/28/ejercicios-de-powershell-obtener-el-nombre-de-un-proceso-y-el-numero-de-hilos-de-cada-proceso/

## Obtener el identificador del hilo junto con el nombre del proceso que lo creó
* https://www.jesusninoc.com/09/28/ejercicios-de-powershell-obtener-el-identificador-del-hilo-junto-con-el-nombre-del-proceso-que-lo-creo/

## Ejercicios de PowerShell: conocer los procesos padres y abuelos (padres de padres) de todos los hilos que se están ejecutando en el sistema
* https://www.jesusninoc.com/09/28/ejercicios-de-powershell-conocer-los-procesos-padres-y-abuelos-padres-de-padres-de-todos-los-hilos-que-se-estan-ejecutando-en-el-sistema/

## Ejercicios de PowerShell: pedir al usuario un número de hilo y mostrar el nombre del proceso padre que crea el hilo y el abuelo 
* https://www.jesusninoc.com/09/28/ejercicios-de-powershell-pedir-al-usuario-un-numero-de-hilo-y-mostrar-el-nombre-del-proceso-padre-que-crea-el-hilo-y-el-abuelo/

-----------------
-----------------

# Corrección del examen (proceso de mayor tiempo de consumo de CPU):
- Utilizando variables
- Utilizando if
- Utilizando foreach

------------------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Memoria

## Ejercicios PowerShell sobre variables

### Mostrar un char desde un int
```PowerShell
[Int]'A'[0]
```
### Mostrar un int desde un char
```PowerShell
[Char]65
```
### Ejecutar un cmdlet leyendo desde un fichero el cmdlet
```PowerShell
"gps" | Out-File ejecutar.txt
Invoke-Expression (gc .\ejecutar.txt)
```
### Modificar el contenido de un fichero
```PowerShell
1 | Out-File ejemplo1.txt
(gc ejemplo1.txt)+"modificado" | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
### Modificar el contenido de un fichero (leer un número de un fichero y sumar un número, después almacenar el valor)
* https://www.jesusninoc.com/11/13/ejercicios-de-powershell-modificar-el-contenido-de-un-fichero-leer-un-numero-de-un-fichero-y-sumar-un-numero-despues-almacenar-el-valor/
### Modificar el contenido de un fichero (leer un número de un fichero y restar un número, después almacenar el valor)
* https://www.jesusninoc.com/11/15/ejercicios-de-powershell-modificar-el-contenido-de-un-fichero-utilizando-variables-leer-un-numero-de-un-fichero-y-restar-un-numero-despues-almacenar-el-valor/
### Modificar el contenido de un fichero utilizando variables (leer un número de un fichero y restar un número, después almacenar el valor)
* https://www.jesusninoc.com/11/15/ejercicios-de-powershell-modificar-el-contenido-de-un-fichero-utilizando-variables-leer-un-numero-de-un-fichero-y-restar-un-numero-despues-almacenar-el-valor/
### Listar la mitad de un número de procesos y ordenarlos (el usuario introduce los valores en variables y los almacena en ficheros)
```PowerShell
$first = Read-Host "intro first"
$first | Out-File first.txt

$orden = Read-Host "intro orden"
$orden | Out-File orden.txt
gps | select -First ([Int ]$first / 2) | sort $orden
```

### Guardar un valor aleatorio en un fichero
```PowerShell
(Get-Random (1..5)) | Out-File aleatorio.txt
```

---------------
---------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Ejercicios sobre hilos

## Almacenar información sobre los hilos
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar información sobre los hilos del proceso Notepad 
* https://www.jesusninoc.com/11/17/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-del-proceso-notepad/

## Mostrar información sobre los hilos de todos los procesos que se están ejecutando (qué proceso ejecuta el hilo)
* https://www.jesusninoc.com/11/19/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-de-todos-los-procesos-que-se-estan-ejecutando-que-proceso-ejecuta-el-hilo/

## Listar hilos de cada proceso
* https://www.jesusninoc.com/07/22/listar-los-hilos-de-un-proceso/

## Almacenar información sobre hilos de forma continuada
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar los hilos de cada proceso utilizando WMI y el cmdlet Get-Process
* https://www.jesusninoc.com/11/23/ejercicios-de-powershell-mostrar-los-hilos-de-cada-proceso-utilizando-wmi-y-el-cmdlet-get-process/

## Relación entre servicios y procesos
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

## Ayuda de servicios con procesos
```PowerShell
foreach($elementos in (Get-WmiObject -Class Win32_Service))
{
    $elementos
}

Get-WmiObject -Class Win32_Service | %{
Write-Host $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```

## Ayuda de procesos WMI con procesos
```PowerShell
Get-WmiObject Win32_Process | %{
    $_.Handles,$_.ProcessHandle,(Get-Process -Id $_.ProcessHandle).ProcessName
}

Get-WmiObject Win32_Process | %{
    (Get-Process -Id $_.ProcessId),$_.ProcessName,$_.Handle,$_.ProcessId
}
```

## Almacenar el número de procesos e hilos en un fichero junto con la fecha (el script se ejecuta cada cinco segundos)
* https://www.jesusninoc.com/11/26/ejercicios-de-powershell-almacenar-el-numero-de-procesos-e-hilos-en-un-fichero-junto-con-la-fecha-el-script-se-ejecuta-cada-cinco-segundos/

# Servicios y relación con procesos
## No funciona porque no puede convertir ProcessID
```PowerShell
Get-WmiObject -Class Win32_Service | Select-Object Name,ProcessID, (Get-Process -Id ProcessID).name
```
## Sí funciona
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

# Procesos y ruta de ejecución del proceso
* https://www.jesusninoc.com/11/29/ejercicios-de-powershell-procesos-y-ruta-de-ejecucion-del-proceso/

# Ejercicios de PowerShell: saber la ruta de los servicios que se están ejecutando
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-saber-la-ruta-de-los-servicios-que-se-estan-ejecutando/

# Ejercicios de PowerShell: de la lista de hilos que se están ejecutando indicar si alguno es un hilo de un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-hilos-que-se-estan-ejecutando-indicar-si-alguno-es-un-hilo-de-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de la lista de procesos que se están ejecutando indicar si alguno es un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-procesos-que-se-estan-ejecutando-indicar-si-alguno-es-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de los servicios que se están ejecutando indicar el nombre del proceso
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-los-servicios-que-se-estan-ejecutando-indicar-el-nombre-del-proceso/

# Ejercicios de PowerShell: mostrar el padre de un hilo
* https://www.jesusninoc.com/09/29/ejercicios-de-powershell-mostrar-el-padre-de-un-hilo/

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Servicios y relación con procesos
## No funciona porque no puede convertir ProcessID
```PowerShell
Get-WmiObject -Class Win32_Service | Select-Object Name,ProcessID, (Get-Process -Id ProcessID).name
```
## Sí funciona
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

# Procesos y ruta de ejecución del proceso
* https://www.jesusninoc.com/11/29/ejercicios-de-powershell-procesos-y-ruta-de-ejecucion-del-proceso/

# Ejercicios de PowerShell: saber la ruta de los servicios que se están ejecutando
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-saber-la-ruta-de-los-servicios-que-se-estan-ejecutando/

# Ejercicios de PowerShell: de la lista de hilos que se están ejecutando indicar si alguno es un hilo de un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-hilos-que-se-estan-ejecutando-indicar-si-alguno-es-un-hilo-de-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de la lista de procesos que se están ejecutando indicar si alguno es un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-procesos-que-se-estan-ejecutando-indicar-si-alguno-es-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de los servicios que se están ejecutando indicar el nombre del proceso
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-los-servicios-que-se-estan-ejecutando-indicar-el-nombre-del-proceso/

# Ejercicios de PowerShell: mostrar el padre de un hilo
* https://www.jesusninoc.com/09/29/ejercicios-de-powershell-mostrar-el-padre-de-un-hilo/

-------------
-------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Repasar tema PowerShell
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/

# ¿Me están espiando?
* https://www.jesusninoc.com/me-estan-espiando/

--------------------

# Memoria

## Adjunto ejercicio visto en mi equipo sobre compartir memoria
- Utilizar zonas de memoria compartida en Linux mediante WSL desde PowerShell
https://www.jesusninoc.com/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/
- Uso de las funciones ftok(), shmget(), shmat() y shmctl() (ejemplo)
https://www.jesusninoc.com/11/22/uso-de-las-funciones-ftok-shmget-shmat-y-shmctl-ejemplo/
- Uso de las funciones ftok(), shmget(), shmat() y shmctl()
https://www.jesusninoc.com/2014/11/22/uso-de-las-funciones-ftok-shmget-shmat-y-shmctl/

### Listar los procesos leyendo de una zona de memoria (almacenar un valor que se utiliza para listar un número de procesos)
#### Código para crear la zona de memoria y almacenar el valor, por ejemplo introducir 5
* https://www.jesusninoc.com/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/

#### Código para leer la zona de memoria (se listan los procesos, si se ha introducido un 5, se listan 5 procesos)
* https://www.jesusninoc.com/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/

-----------------
-----------------

# Instalación de software libre y propietario

- Máquinas virtuales (M.V.)
  - Concepto de virtualización del hardware y características de los principales productos software libre y propietario, para el uso de máquinas virtuales.
  - Creación y personalización de M.V.
  - Ventajas e inconvenientes de la virtualización.

-----------------
-----------------

# Parte especial de la clase (conexión con Linux)

## SSH

### Instalar y ejecutar SSH para PowerShell
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-ssh/

### Conexión después de haber desconectado y quitado el módulo Posh-SSH (hay que volver a importarlo)
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-ssh/

### Ejemplo: obtener información sobre la versión de Linux
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-ssh/

### JuiceSSH - SSH Client
* https://play.google.com/store/apps/details?id=com.sonelli.juicessh

### JuiceSSH Performance Plugin
* https://play.google.com/store/apps/details?id=com.sonelli.juicessh.performancemonitor
* https://www.jesusninoc.com/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
* https://www.jesusninoc.com/2015/02/25/creating-reverse-shell/
* https://www.jesusninoc.com/2015/02/26/creating-shell/

## Ejecutar un comando remotamente utilizando un servidor web creado en PowerShell
* https://www.jesusninoc.com/12/18/ejercicios-de-powershell-ejecutar-un-comando-remotamente-utilizando-un-servidor-web-creado-en-powershell/

# Instalación de software libre y propietario

- Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
  - Particionado del disco duro.
  - En sistemas Windows determinar la partición donde instalaremos el S.O.
  - En sistemas Linux determinar las particiones para los distintos puntos de montaje.
  - Controladores (drivers) de almacenamiento necesarios.
- Instalación de sistemas operativos.
  - Requisitos hardware, versiones y licencias.
  - Soporte utilizado para la instalación: CD/DVD, Pendrive, LAN.
  - Datos necesarios para la instalación: usuarios, contraseñas, nombre del equipo, direcciones IP, número de licencia, etc.

----------------

# Obtener información sobre el pocesador en PowerShell

## Información sobre el procesador
* https://www.jesusninoc.com/12/22/ejercicios-de-powershell-obtener-informacion-sobre-el-procesador/

## Información sobre la arquitectura
* https://www.jesusninoc.com/12/01/ejercicios-de-powershell-obtener-informacion-sobre-la-arquitectura/

## Información sobre la organización
* https://www.jesusninoc.com/12/02/ejercicios-de-powershell-obtener-informacion-sobre-la-organizacion/

## Información sobre la realización
* https://www.jesusninoc.com/12/07/ejercicios-de-powershell-obtener-informacion-sobre-la-realizacion/

## Información sobre los procesadores
* https://www.jesusninoc.com/10/13/mostrar-informacion-sobre-los-procesadores/

## Número de cores
* https://www.jesusninoc.com/10/02/ejercicios-de-powershell-informacion-sobre-el-numero-de-cores/

## Carga del procesador
* https://www.jesusninoc.com/10/03/ejercicios-de-powershell-ver-la-carga-del-procesador/

## Ejercicios
### Información sobre el procesador
* https://www.jesusninoc.com/01/13/ver-informacion-del-procesador-en-windows-desde-powershell/

### Procesador es Intel o no?
* https://www.jesusninoc.com/10/16/ejercicios-de-powershell-saber-si-un-procesador-es-intel-o-no/

---------------------
---------------------

# Instalación de software libre y propietario

- Gestión de varios sistemas operativos en un ordenador.
  - Requisitos previos. Administración del espacio del disco. Particionado y redimensionado.
  - Problemas con el registro maestro de arranque (MBR). Elegir un gestor de arranque compatible con todos los sistemas operativos a instalar.
  - Preparar las particiones de los S.O. para permitir su arranque.
  - Analizar el orden en la instalación de los sistemas operativos.
- Gestores de arranque.
  - Código de arranque maestro (Master Boot Code).
  - Formatos tabla de particiones. Master Boot Record (MBR) y Guid Partition Table (GPT).
  - Configuración de los gestores de arranque de los sistemas operativos libres y propietarios.
  - Reparación del gestor de arranque.
  - Sustitución del gestor de arranque estándar por otro más completo.

---------------------

# Arranque
- BIOS
- POST
- Arranque (dual, BCD, BCDEdit, etc.)
- Arranque de procesos

## Arranque en Linux
### Proceso de arranque en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Arranque en Windows
### Master Boot Record
https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-2000-server/cc976786(v=technet.10)
### Proteger el proceso de arranque de Windows 10
https://docs.microsoft.com/es-es/windows/security/hardware-protection/secure-the-windows-10-boot-process
### Procesos de credenciales de autenticación de Windows
https://docs.microsoft.com/es-es/windows-server/security/windows-authentication/credentials-processes-in-windows-authentication

-------------
-------------

# Repaso de comunicación por red entre Windows y Linux
* https://www.jesusninoc.com/10/26/crear-una-comunicacion-entre-un-cliente-en-powershell-de-windows-y-un-servidor-en-bash-de-linux-utilizando-tcpip/

-------------
-------------

# Prueba
* https://www.youtube.com/watch?v=CibNbK9sp8A

---------------
---------------

# Introducción al sistema de archivos

## Ejemplos básicos sobre el sistema de archivos en PowerShell
* https://www.jesusninoc.com/11/03/ejercicios-de-powershell-ejercicios-basicos-sobre-el-sistema-de-archivos-en-powershell/

## Ejercicios sobre sistemas de archivos (mezclado con procesos)
* https://www.jesusninoc.com/11/04/ejercicios-de-powershell-ejercicios-sobre-sistemas-de-archivos-mezclado-con-procesos/

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Ejercicios sobre hilos

## Almacenar información sobre los hilos
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar información sobre los hilos del proceso Notepad 
* https://www.jesusninoc.com/11/17/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-del-proceso-notepad/

## Mostrar información sobre los hilos de todos los procesos que se están ejecutando (qué proceso ejecuta el hilo)
* https://www.jesusninoc.com/11/19/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-de-todos-los-procesos-que-se-estan-ejecutando-que-proceso-ejecuta-el-hilo/

## Listar hilos de cada proceso
* https://www.jesusninoc.com/07/22/listar-los-hilos-de-un-proceso/

## Almacenar información sobre hilos de forma continuada
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar los hilos de cada proceso utilizando WMI y el cmdlet Get-Process
* https://www.jesusninoc.com/11/23/ejercicios-de-powershell-mostrar-los-hilos-de-cada-proceso-utilizando-wmi-y-el-cmdlet-get-process/

## Relación entre servicios y procesos
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

## Ayuda de servicios con procesos
```PowerShell
foreach($elementos in (Get-WmiObject -Class Win32_Service))
{
    $elementos
}
Get-WmiObject -Class Win32_Service | %{
Write-Host $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```

## Ayuda de procesos WMI con procesos
```PowerShell
Get-WmiObject Win32_Process | %{
    $_.Handles,$_.ProcessHandle,(Get-Process -Id $_.ProcessHandle).ProcessName
}
Get-WmiObject Win32_Process | %{
    (Get-Process -Id $_.ProcessId),$_.ProcessName,$_.Handle,$_.ProcessId
}
```

## Almacenar el número de procesos e hilos en un fichero junto con la fecha (el script se ejecuta cada cinco segundos)
* https://www.jesusninoc.com/11/26/ejercicios-de-powershell-almacenar-el-numero-de-procesos-e-hilos-en-un-fichero-junto-con-la-fecha-el-script-se-ejecuta-cada-cinco-segundos/

# Servicios y relación con procesos
## No funciona porque no puede convertir ProcessID
```PowerShell
Get-WmiObject -Class Win32_Service | Select-Object Name,ProcessID, (Get-Process -Id ProcessID).name
```
## Sí funciona
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

# Procesos y ruta de ejecución del proceso
* https://www.jesusninoc.com/11/29/ejercicios-de-powershell-procesos-y-ruta-de-ejecucion-del-proceso/

# Ejercicios de PowerShell: saber la ruta de los servicios que se están ejecutando
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-saber-la-ruta-de-los-servicios-que-se-estan-ejecutando/

# Ejercicios de PowerShell: de la lista de hilos que se están ejecutando indicar si alguno es un hilo de un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-hilos-que-se-estan-ejecutando-indicar-si-alguno-es-un-hilo-de-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de la lista de procesos que se están ejecutando indicar si alguno es un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-procesos-que-se-estan-ejecutando-indicar-si-alguno-es-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de los servicios que se están ejecutando indicar el nombre del proceso
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-los-servicios-que-se-estan-ejecutando-indicar-el-nombre-del-proceso/

# Ejercicios de PowerShell: mostrar el padre de un hilo
* https://www.jesusninoc.com/09/29/ejercicios-de-powershell-mostrar-el-padre-de-un-hilo/

------------
------------

# Ejecutar comandos en PowerShell y Bash
## Bash
```Bash
echo ps
echo 'ps'
echo `ps`
```
## PowerShell
```PowerShell
$hola="Get-Process -Name notepad"
Invoke-Expression ($hola)
```

## Mezcla de comandos entre PowerShell y Bash
```PowerShell
for($i=1;$i -le 5;$i=$i+1)
{
    $multi=($i*100) 
    $nombre="fichero$i"
    $resultado=Invoke-SSHCommand -Index 0 ('echo' + $multi + ' >' + $nombre)
    $resultado.Output 
}
```

---------------
---------------

# Introducción al sistema de archivos

## Ejemplos básicos sobre el sistema de archivos en PowerShell
* https://www.jesusninoc.com/11/03/ejercicios-de-powershell-ejercicios-basicos-sobre-el-sistema-de-archivos-en-powershell/

## Ejercicios sobre sistemas de archivos (mezclado con procesos)
* https://www.jesusninoc.com/11/04/ejercicios-de-powershell-ejercicios-sobre-sistemas-de-archivos-mezclado-con-procesos/

---------------
---------------

# Repaso de discos
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Discos_virtuales
* https://www.jesusninoc.com/10/25/crear-una-imagen-de-un-disco-virtual/

---------------
---------------

# Parte especial de la clase (conexión con Linux)

## SSH

### Instalar y ejecutar SSH para PowerShell
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.11 -Credential (Get-Credential)
```

### Conexión después de haber desconectado y quitado el módulo Posh-SSH (hay que volver a importarlo)
```PowerShell
Set-ExecutionPolicy -ExecutionPolicy Unrestricted

Import-Module Posh-SSH

New-SSHSession -ComputerName 10.20.104.19 -Credential (Get-Credential)

Get-SSHSession

(Invoke-SSHCommand -Index 0 "uname -r").output

(Invoke-SSHCommand -Index 0 "lscpu").output | Out-File informacionunubntu.txt -Append
(Invoke-SSHCommand -Index 0 "lshw").output | Out-File informacionunubntu.txt -Append
(Invoke-SSHCommand -Index 0 "nproc").output | Out-File informacionunubntu.txt -Append
```

### Ejemplo: obtener información sobre la versión de Linux
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.14 -Credential (Get-Credential)
Get-SSHSession
Invoke-SSHCommand -Index 0 "uname"
```

### Ejemplo: obtener información sobre la CPU
```PowerShell
# Realizar la conexión SSH
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -Computer
# Obtener información sobre el procesador desde Linux mediante una conexión SSH
(Invoke-SSHCommand -Index 0 "bash -c lscpu | grep '32-bit'")
(Invoke-SSHCommand -Index 0 "bash -c lscpu | grep '32-bit' | cut -d':' -f2  | cut -d'-' -f1 ").output
# ¿Es intel?
(Invoke-SSHCommand -Index 0 "lscpu").output
if((Invoke-SSHCommand -Index 0 "lscpu").output -match "Intel"){"Intel"}else{"No es Intel"}
(Invoke-SSHCommand -Index 0 "lscpu").output | select-string "cache"
```

### JuiceSSH - SSH Client
https://play.google.com/store/apps/details?id=com.sonelli.juicessh

### JuiceSSH Performance Plugin
https://play.google.com/store/apps/details?id=com.sonelli.juicessh.performancemonitor

### Guardar un fichero html preguntando al usuario qué título quiere
```PowerShell
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html
start chrome .\web.html
```

### Configurar IP en Windows
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

### Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## WSL
### Obtener información sobre la versión de Linux con WSL
```PowerShell
wsl uname -r
wsl uname -a
wsl cat /proc/version
```

### Información sobre la arquitectura
```PowerShell
(Invoke-SSHCommand -Index 0 "bash -c ""lscpu | grep 'Architecture'""").output
```

### Almacenar en un fichero información sobre la CPU mediante WSL desde PowerShell
```PowerShell
bash -c lscpu | Select-String "Architecture:","Model name:" | Out-File bonito.txt
[String]$var = bash -c lscpu | Select-String "Model name:"
$var.split("@")[1] | Out-File bonito.txt -Append
notepad .\bonito.txt
```

### 3. Gestión del hardware en Linux (nivel intermedio)
https://www.jesusninoc.com/03/03/3-gestion-del-hardware-en-linux-nivel-intermedio/

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Instalar con PowerShell
* https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/

## Leer de un fichero nombres de programas e instalarlos (ejercicio)
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-leer-de-un-fichero-nombres-de-programas-e-instalarlos-2/

# Actualizar en Windows
* https://docs.microsoft.com/en-us/windows/desktop/msi/command-line-options
* https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/

## Ejercicios sobre actualizaciones en PowerShell
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-actualizaciones-en-powershell/

# Instalar en Bash
* https://help.ubuntu.com/community/AptGet/Howto

# Actualizar en Linux
### This command upgrades all installed packages. This is the equivalent of "Mark all upgrades" in Synaptic.
```Bash
apt-get update & apt-get upgrade
```
### Setting up apt-get to use a http-proxy
```Bash
export http_proxy=http://yourproxyaddress:proxyport
```

--------------
--------------

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
- Ficheros necesarios para el arranque de los principales sistemas operativos.
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
- Actualización y mantenimiento de controladores de dispositivos.
  - Automatizar la actualización de controladores.
  - Volver a una versión anterior de un controlador.
  - Actualización manual de los controladores.
  
------------------

# Linux

## Variables
https://www.jesusninoc.com/2015/01/04/curso-de-bash-scripting-con-ejemplos/

### Variables 1: enteros, caracteres y cadenas de caracteres
https://www.jesusninoc.com/2014/10/28/variables-1-enteros-caracteres-y-cadenas-de-caracteres/
### Variables 2: concatenar, extraer, medir cadenas
https://www.jesusninoc.com/2014/10/24/variables-2-concatenar-extraer-elementos-y-medir-la-longitud-de-un-array/
### Variables 3: almacenar la ejecución de un comando
https://www.jesusninoc.com/2014/10/23/variables-3-almacenar-la-ejecucion-de-un-comando/
### Variables 4: almacenar en fichero
https://www.jesusninoc.com/2014/10/22/variables-4-almacenar-en-fichero/
### Variables 5: leer de un fichero
https://www.jesusninoc.com/2014/10/21/variables-5-leer-de-un-fichero/
### Variables 6: etiquetas HTML
https://www.jesusninoc.com/2014/10/20/variables-6-etiquetas-html/
### Variables 7: ordenar y eliminar elementos duplicados
https://www.jesusninoc.com/2014/10/19/variables-7-ordenar-y-eliminar-elementos-duplicados-2/
### Variables 8: eliminar caracteres en blanco
https://www.jesusninoc.com/2014/10/18/variables-8-eliminar-caracteres-en-blanco/

## Bucle
Example C for loop syntax
```Bash
for (( i=1; i <= 10; i++ ))
do
echo "Number $i"
done
```

## Ejercicio: ejecutar el comando almacenado en un fichero
* https://github.com/jesusninoc/Bash/blob/master/Introduccion/EjemplosIntroducci%C3%B3n.sh

```Bash
echo "ps" > fichero
echo "ls" >> fichero
`cat fichero | head -n 1`
```

```Bash
echo "ps" > fichero
echo "ls" >> fichero

while read linea
do
echo $linea
`echo $linea` >> resultado
done < fichero

cat resultado
```

------------------

# PowerShell
## Repaso bucle ForEach
* https://github.com/jesusninoc/PowerShell/blob/master/Bucles/RepasoBucleForEach.ps1

------------------

# Linux + PowerShell

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Instalar y ejecutar SSH para PowerShell
```PowerShell
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
New-SSHSession -ComputerName 10.20.104.35 -Credential (Get-Credential)

$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```

## SSH sobre PowerShell
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```

## SSH en Windows 10
* https://www.illuminiastudios.com/dev-diaries/ssh-on-windows-subsystem-for-linux/

------------------

# Examen mes de noviembre (obtener información sobre hilos en Linux y PowerShell)

## Linux

### Leer nombre de proceso de un fichero y mostrar hilos
* https://www.jesusninoc.com/03/11/ejercicios-de-bash-leer-nombre-de-proceso-de-un-fichero-y-mostrar-hilos/

### Mostrar el nombre de los procesos leyendo de un fichero el identificador de proceso
* https://www.jesusninoc.com/03/11/ejercicios-de-bash-mostrar-el-nombre-de-los-procesos-leyendo-de-un-fichero-el-identificador-de-proceso/

### Sacar los hilos de los procesos leyendo el nombre del proceso de un fichero
* https://www.jesusninoc.com/10/29/ejercicios-de-bash-sacar-los-hilos-de-los-procesos-leyendo-el-nombre-del-proceso-de-un-fichero/

## PowerShell

### Leer nombre de proceso de un fichero y mostrar hilos
* https://www.jesusninoc.com/11/21/ejercicios-de-powershell-leer-nombres-de-procesos-de-un-fichero-y-mostrar-hilos-de-cada-proceso/

### Mostrar el nombre de los procesos leyendo de un fichero el identificador de proceso
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-mostrar-el-nombre-de-los-procesos-leyendo-de-un-fichero-el-identificador-de-proceso/

### Sacar los hilos de los procesos leyendo el nombre del proceso de un fichero
* https://www.jesusninoc.com/11/23/ejercicios-de-powershell-listar-los-hilos-de-los-procesos-leyendo-el-nombre-del-proceso-de-un-fichero/

### Analizar hilos (solución)
https://www.jesusninoc.com/02/06/analizar-hilos-con-powershell/

### Otra más
```PowerShell
# Listar identificadores de hilos
(Get-Process -name notepad | select threads).threads.id

# Listar información de un hilo en concreto
Get-WmiObject -Class win32_thread -Filter "Handle = 6248" | Out-File

# Sirve para analizar la información de hilos en función del proceso que los crea (Notepad)
(Get-Process -name notepad).id
$var=(Get-Process -name notepad).id
Get-WmiObject -Class win32_thread -Filter "ProcessHandle = $var"

# (Leyenda) Sirve para analizar información de hilos en función de los identificadores de cada hilo del proceso que los crea (Notepad)
$var=(Get-Process -name notepad | select threads).threads.id
$var | %{$_}
Get-WmiObject -Class win32_thread -Filter "ProcessHandle = $var"
$var | %{Get-WmiObject -Class win32_thread -Filter "Handle = $_"}
```

### Otra posible solución
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-mostrar-el-proceso-que-creo-el-hilo/

### Solución para entender la solución de Linux
```PowerShell
echo "ps@notepad" > fichero

foreach ($linea in gc fichero)
{
    $ejecutar = $linea.split("@")[0] + " -name " + $linea.split("@")[1]
    $ejecutar | iex
}
```

------------
------------

# Resolver ejercicio propuesto: listar los procesos cuyo identificador de hilo se encuentre en una lista (el listado de procesos aparece escrito en un fichero y se tiene que ejecutar con IEX) (el fichero fichero.txt tiene Get-Process como contenido y el fichero hilo.txt tiene un número como contenido)
```PowerShell
(Get-Content .\fichero.txt) + " -id (Get-WmiObject win32_thread | where handle -eq (Get-Content .\hilo.txt)).ProcessHandle" | iex
```

-----------------
-----------------

# Examen mes de noviembre (obtener información sobre hilos en Linux y PowerShell)

## Linux

### Leer nombre de proceso de un fichero y mostrar hilos
```Bash
echo "ps -fL -C @sh" > fichero
echo "ps -fL -C @sh" >> fichero

while read linea
do
echo $linea
`echo $linea | cut -d '@' -f1 ; echo $linea | cut -d '@' -f2` >> resultado
done < fichero

cat resultado
```

### Mostrar el nombre de los procesos leyendo de un fichero el identificador de proceso
```Bash
echo "323@232@8888" > fichero

while read linea
do
echo $linea
ps -f -p `echo $linea | cut -d '@' -f1` >> resultado
done < fichero

cat resultado
```

### Sacar los hilos de los procesos leyendo el nombre del proceso de un fichero
```Bash
echo "nano" > fichero
echo "sh" >> fichero

while read linea
do
echo $linea
ps -fL -C `echo $linea | cut -d '@' -f1` >> resultado
done < fichero

cat resultado
```

## PowerShell

### Leer nombre de proceso de un fichero y mostrar hilos
```PowerShell
echo "ps @notepad" > fichero
echo "ps @notepad" >> fichero
Get-Content .\fichero

foreach($linea in Get-Content .\fichero)
{
    $ejecutar = $linea.split("@")[0] + $linea.split("@")[1]
    $ejecutar + " | select threads" | iex
}
```

### Mostrar el nombre de los procesos leyendo de un fichero el identificador de proceso
```PowerShell
echo "1288" > fichero
echo "1200" >> fichero
Get-Content .\fichero

foreach($linea in Get-Content .\fichero)
{
    Get-Process -Id $linea | select name
}
```

### Sacar los hilos de los procesos leyendo el nombre del proceso de un fichero
```PowerShell
echo "notepad" > fichero
echo "chrome" >> fichero
Get-Content .\fichero

foreach($linea in Get-Content .\fichero)
{
    Get-Process -name $linea | select name,threads
}
```

### Analizar hilos (solución)
https://www.jesusninoc.com/02/06/analizar-hilos-con-powershell/

### Otrá más
```PowerShell
# Listar identificadores de hilos
(Get-Process -name notepad | select threads).threads.id

# Listar información de un hilo en concreto
Get-WmiObject -Class win32_thread -Filter "Handle = 6248" | Out-File

# Sirve para analizar la información de hilos en función del proceso que los crea (Notepad)
(Get-Process -name notepad).id
$var=(Get-Process -name notepad).id
Get-WmiObject -Class win32_thread -Filter "ProcessHandle = $var"

# (Leyenda) Sirve para analizar información de hilos en función de los identificadores de cada hilo del proceso que los crea (Notepad)
$var=(Get-Process -name notepad | select threads).threads.id
$var | %{$_}
Get-WmiObject -Class win32_thread -Filter "ProcessHandle = $var"
$var | %{Get-WmiObject -Class win32_thread -Filter "Handle = $_"}
```

### Otra posible solución
```PowerShell
#Mostrar el proceso que creó el hilo
Get-WmiObject -Class Win32_Thread | %{
    if((Get-Process -Id $_.ProcessHandle).name -eq "notepad")
    {
        write-host $_.ProcessHandle,$_.handle
        Get-Process -Id $_.ProcessHandle | select name,id
    }
}
```

### Solución para entender la solución de Linux
```PowerShell
echo "ps@notepad" > fichero

foreach ($linea in gc fichero)
{
    $ejecutar = $linea.split("@")[0] + " -name " + $linea.split("@")[1]
    $ejecutar | iex
}
```

----------------
----------------

# Ejercicios repaso

## Instalar un paquete MSI junto con información sobre la instalación
```PowerShell
cd ~
msiexec /i C:\Windows\Installer\42014f.msi /Liwearucmopvx log.txt
msiexec /i C:\Windows\Installer\42014f.msi /Li logi.txt
Start-Sleep -Seconds 5
msiexec /i C:\Windows\Installer\42014f.msi /Lw logw.txt
```

## Ver el número de serie de un equipo
```PowerShell
(Get-WmiObject Win32_SystemEnclosure).SerialNumber
```

## Ver controladores
```PowerShell 
gwmi Win32_USBControllerDevice |%{[wmi]($_.Dependent)} | Sort Manufacturer,Description,DeviceID | Ft -GroupBy Manufacturer Description,Service,DeviceID
 
Get-PnpDevice
```
  
## Ver actualizaciones
```PowerShell
$Sesion = New-Object -ComObject Microsoft.Update.Session
$actualizacion = $Sesion.CreateUpdateSearcher().Search("IsInstalled=1").Updates
$actualizacion | Select-Object Title
```
  
## Obtener información sobre las actualizaciones
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-obtener-informacion-sobre-las-actualizaciones/

---------------
---------------

# Examen (PID, cut, hilos, saber si hay una versión instalada)

# Ver por dónde vamos del temario

----------------
----------------

# Apartado pendiente tema anterior
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.

---------
---------

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------------

# Sistema de archivos

## Introducción a sistema de archivos
https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

# Sistema de archivos: discos

## Comandos para trabajar con discos en PowerShell
https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

# Ejercicio
- Crear varios discos virtuales leyendo desde un fichero la información (nombre), los discos hay que particionarlos y formatearlos. Añadir a cada disco duro información sobre los procesos e hilos que se están ejecutando.
## Ayuda
* https://docs.microsoft.com/es-es/windows/deployment/windows-10-poc 
* https://github.com/jesusninoc/ClasesSOM/blob/master/2019-02-26.md#crear-un-disco-virtual-en-windows
* https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-server-2012-R2-and-2012/gg252593%28v%3dws.11%29
* https://docs.microsoft.com/es-es/windows/deployment/windows-10-poc
* https://github.com/jesusninoc/ClasesSOM/blob/master/2019-02-26.md#ejercicios

## Script
* https://www.jesusninoc.com/11/05/ejercicios-de-powershell-crear-varios-discos-virtuales-leyendo-desde-un-fichero-la-informacion-nombre-los-discos-hay-que-particionarlos-y-formatearlos-anadir-a-cada-disco-duro-informacion-sobre-l/

-------------
-------------

| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Bajo | 1º ASIR | Informática | Primera evaluación |

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------------

# Ejercicio sobre discos en Windows de forma automática (hablar de Hyper-V)

---------------------

# Sistema de archivos

## Introducción a sistema de archivos
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

# Sistema de archivos: discos
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Discos

## Comandos para trabajar con discos en Linux
* https://www.jesusninoc.com/10/28/comandos-para-trabajar-con-discos-en-linux-2/

----------------
----------------

# Examen de noviembre (repaso)

## Tener en cuenta:
- Utilizar ficheros para leer la información
- Almacenar información en ficheros de log
- Utilizar variables
- Foreach

## Preguntas:
### - Leer identificadores de procesos y comprobar que tienen un proceso
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-leer-identificadores-de-procesos-y-comprobar-que-tienen-un-proceso/

### - Detectar si hay un tipo de proceso y producto de software que se llame "Acrobat"
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-detectar-si-hay-un-tipo-de-proceso-y-producto-de-software-que-se-llame-acrobat/

### - Detectar que se está consumiendo tráfico de red por parte de un proceso
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-detectar-que-se-esta-consumiendo-trafico-de-red-por-parte-de-un-proceso/

### - Detectar que un proceso está utilizando el posicionamiento GPS
```PowerShell
Get-Process | select *
Get-Process -name chrome | Select-Object path
Get-WmiObject win32_process | select *
(Get-WmiObject win32_process | select CommandLine).CommandLine | Select-String "gp"
(Get-WmiObject win32_process | select CommandLine).CommandLine | Select-String "gps"
```

-------------
-------------

# Repaso de examen
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-11-05.md#examen-de-noviembre
## Solución complicada
* https://github.com/jesusninoc/ClasesSAD/blob/master/2020-11-06.md#caso-me-est%C3%A1n-espiando

-----------
-----------

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------------

# Sistema de archivos

## Introducción a sistema de archivos
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

# Sistema de archivos: discos
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Discos

## Comandos para trabajar con discos en Linux
* https://www.jesusninoc.com/10/28/comandos-para-trabajar-con-discos-en-linux-2/

---------------
---------------

# Examen de octubre corrección

1. Crear una carpeta cuyo nombre sea la fecha de hoy y meter dentro de la carpeta un fichero con información sobre el proceso Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-una-carpeta-cuyo-nombre-sea-la-fecha-de-hoy-y-meter-dentro-de-la-carpeta-un-fichero-con-informacion-sobre-el-proceso-notepad/

 - 1.1. Crear una carpeta cuyo nombre sea la fecha de hoy https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-una-carpeta-cuyo-nombre-sea-la-fecha-de-hoy/

 - 1.2. Crear un fichero con información sobre el proceso Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-un-fichero-con-informacion-sobre-el-proceso-notepad/

2. Mostrar los hilos que tiene Notepad y almacenar los números de identificador de hilo en un fichero https://www.jesusninoc.com/10/28/ejercicios-de-powershell-mostrar-los-hilos-que-tiene-notepad-y-almacenar-los-numeros-de-identificador-de-hilo-en-un-fichero/

 - 2.1. Mostrar los hilos que tiene Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-mostrar-los-hilos-que-tiene-notepad/

3. Abrir 5 veces Notepad y almacenar información sobre el proceso Notepad en un fichero https://www.jesusninoc.com/10/28/ejercicios-de-powershell-abrir-5-veces-notepad-y-almacenar-informacion-sobre-el-proceso-notepad-en-un-fichero/

 - 3.1. Abrir 5 veces Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-abrir-5-veces-notepad/

 - 3.2. Almacenar información sobre el proceso Notepad en un fichero https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-un-fichero-con-informacion-sobre-el-proceso-notepad/

-----------
-----------

#  IF en PowerShell
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Sentencias_condicionales

# Ejemplos con IF

## Pedir al usuario un nombre de usuario y un password
* https://www.jesusninoc.com/11/23/ejercicios-de-powershell-pedir-al-usuario-un-nombre-de-usuario-y-un-password/

## Pedir al usuario un nombre de usuario y un password y comprobar si es "juan"
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-pedir-al-usuario-un-nombre-de-usuario-y-un-password-y-comprobar-si-es-juan/

## Pedir al usuario un nombre de usuario y un password y comprobar si es "juan". Introducir pass y ver si es correcto
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-pedir-al-usuario-un-nombre-de-usuario-y-un-password-y-comprobar-si-es-juan-introducir-pass-y-ver-si-es-correcto/

---------------

# Switch en PowerShell
* https://www.jesusninoc.com/2016/08/09/sentencia-condicional-switch/

# Ejemplos
## Ejemplos sobre operaciones con switch
```PowerShell
$a=Read-Host "Introduzca operación"
switch($a){
'+'{
echo Suma
break
}
}
```
## Pedir una operación y si es "suma" realizar una suma
```PowerShell
$a=Read-Host "Introduzca operación"
switch($a){
'+'{
suma
break
}
}

function suma()
{
2+3
}
```

-----------
-----------

# Ejercicios

## Crear dos ficheros TXT, convertirlos a PDF y juntarlos con Poppler
* https://www.jesusninoc.com/11/26/ejercicios-de-powershell-crear-dos-ficheros-txt-convertirlos-a-pdf-y-juntarlos-con-poppler-utilizando-wsl/

## Crear cinco directorios y dentro de cada directorio crear 10 ficheros
* https://www.jesusninoc.com/11/28/ejercicios-de-powershell-crear-cinco-directorios-y-dentro-de-cada-directorio-crear-10-ficheros/

## Crear una estructura de directorios
* https://www.jesusninoc.com/11/28/ejercicios-de-powershell-crear-una-estructura-de-directorios/

## Crear una estructura de directorios (pero solo los números pares)
* https://www.jesusninoc.com/11/28/ejercicios-de-powershell-crear-una-estructura-de-directorios-pero-solo-los-numeros-pares/

## Crear una estructura de directorios (pero solo los números impares)
* https://www.jesusninoc.com/11/30/ejercicios-de-powershell-crear-una-estructura-de-directorios-pero-solo-los-numeros-impares/

## Leer operaciones de un fichero y realizarlas

### Estructura del fichero asignaturas.txt (0 crear fichero, 1 crear directorio)
```
iso,0
aso,1
```

### Leer del fichero que tiene las asignaturas
```PowerShell
$fichero=get-content asignaturas.txt
$fichero | % {
$_
}
```

### Leer del fichero que tiene las asignaturas y obtener solo la operación que hay que realizar
```PowerShell
$fichero=get-content asignaturas.txt
$fichero | % {
$_.split(',')[1]
}
```

### Leer el fichero y detectar la operación a realizar utilizando el switch
```PowerShell
$fichero = Get-Content asignaturas.txt
$fichero | % {
    $operacion = $_.split(",")
    switch($operacion[1]){
        '0'{
            echo "crear fichero"
            New-Item -Name $operacion[0] -ItemType File -Force
            break
        }
        '1'{
            echo "crear directorio"
            mkdir $operacion[0] -Force
            break
        }
    }
}
```

-------------
-------------

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.

---------------

# Linux

## A First Script
* https://www.shellscript.sh/first.html

## Ejercicios con ficheros y directorios (Bash)

```Bash
#Crear o modificar un archivo
vi nombre
```
```Bash
#Crear un directorio
mkdir
```
```Bash
#Ver el contenido de un archivo
cat
```
```Bash
#Acceder al contenido de un directorio
cd
```
```Bash
#Listar el contenido de un directorio
ls
```
```Bash
#Ver la estructura de un directorio
tree
```
```Bash
#Eliminar un archivo
rm
```
```Bash
#Eliminar un directorio
rmdir
```
```Bash
#Copiar un archivo o un directorio
cp
```
```Bash
#Mover un archivo o un directorio
mv
```
```Bash
#Renombrar un archivo o un directorio
mv
```
```Bash
#Establecer permisos en un archivo o un directorio
chmod
```
```Bash
#Comprimir y descomprimir un archivo o un directorio
gzip
```
```Bash
#Imprimir un archivo
lpr
```

## Ejercicios propuestos con ficheros y directorios (Bash)

- Crear un directorio para cada usuario
- Crear un fichero para cada usuario
- Añadir contenido a cada fichero creado para cada usuario
- Eliminar un directorio
- Renombrar un directorio
- Mover archivos de una carpeta a otra

## Ejercicios resueltos con ficheros y directorios (Bash)

1. Crear fichero que tenga tu nombre
```Bash	
 	echo Alejandro > fichero.txt
	#-------------------------
	who | awk '{print $1}' > fichero.txt
```
2. Ver el contenido de un fichero cuyo nombre esta guardado en otro fichero
```Bash
	cat `cat fichero.txt`
	#--------------------
	fich1= cat fichero
	cat $fich1
```
3. Listar contenido de un directorio y almacenarlo en un fichero
```Bash	
	ls directorio > listaDeDirectorio.txt
	cat listadeDirectorio.txt
```
4. Eliminar un fichero leyendo el nombre de este desde otro fichero
```Bash
	echo fichero1.txt > fichero2.txt

	rm `cat ficher2.txt`
	#------------------------------
	fic=cat ficher2.txt
	rm $fic
```
5. Eliminar directorio leyendo el nombre desde este desde otro fichero.	
```Bash
	echo directorio > fichero.txt
	
	mkdir `cat fichero.txt`
	
	rm -r `cat fichero.txt`
	#------------------------------
	direc=cat fichero.txt
	
	mkdir $direc
	rm -r $direc
```
6. Comprimir un directorio
```Bash
	gzip fichero
```

---------------
---------------

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

------------------

# Ejercicios resueltos con ficheros y directorios (PowerShell)

## Crear directorios con los meses del año
* https://www.jesusninoc.com/12/01/ejercicios-de-powershell-crear-directorios-con-los-meses-del-ano/

## Crear directorios con los años desde 2020 hasta 2030 (opción 1)
* https://www.jesusninoc.com/12/02/ejercicios-de-powershell-crear-directorios-con-los-anos-desde-2020-hasta-2030-opcion-1/

## Crear directorios con los años desde 2020 hasta 2030 (opción 2)
* https://www.jesusninoc.com/12/03/ejercicios-de-powershell-crear-directorios-con-los-anos-desde-2020-hasta-2030-opcion-2/

## Crear directorios con los años desde 2020 hasta 2030 (opción 3)
* https://www.jesusninoc.com/12/04/ejercicios-de-powershell-crear-directorios-con-los-anos-desde-2020-hasta-2030-opcion-3/

## En cada uno de los directorios anteriores, crea un subdirectorio con los meses del año
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio)
    cd $anio
    foreach($mes in 1..12)
    {
        mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes)
    }
    cd ..
}
```

## En cada mes, crear un directorio con cada día del mes
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio)
    cd $anio
    foreach($mes in 1..12)
    {
        mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes)
        cd $mes
        1..31 | %{mkdir $_}
        cd ..
    }
    cd ..
}
```

## Trabajar con fechas
```PowerShell
$mes = (get-date).Month
$ano = (get-date).year
$dia = (get-date).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (día anterior)
```PowerShell
$mes = (get-date).AddDays(-1).Month
$ano = (get-date).AddDays(-1).Year
$dia = (get-date).AddDays(-1).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (listar varios días)
```PowerShell
-1..-7
 
foreach($dias in (-1..-7))
{
    $dias
}
 
foreach($dias in (-1..-7))
{
    (Get-Date).AddDays($dias)
}
 
foreach($dias in (-1..-7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
}
```

## Hay un proceso que falla, revisad la información sobre servicios, procesos e hilos durante una semana (creando ficheros de registro varias veces al día)
 
### Parte 1
### -Crear la carpeta para cada día y para varios momentos del día

#### Solución rara (o no), calculando el número de horas
```PowerShell
foreach($dias in (1..168))
{
    $mes = (get-date).AddHours($dias).Month
    $ano = (get-date).AddHours($dias).Year
    $dia = (get-date).AddHours($dias).Day
    $horas = (get-date).AddHours($dias).Hour
    mkdir $ano$mes$dia$horas -WhatIf
}
```
#### Solución medio buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    foreach($horas in 0..23)
    {
        mkdir $ano$mes$dia$horas -WhatIf
    }
}
```
#### Solución bastante buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
   
    foreach($horas in 0..23)
    {
        $ruta = [String]$ano+[String]$mes+[String]$dia
        $ruta
        New-Item -Name $horas -Path $ruta -ItemType Directory -WhatIf
    }
}
```
#### Solución mucha locura
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta0 = $ano+"\"+$mes+"\"+$dia
    mkdir $ruta0 -WhatIf
   
    foreach($horas in 0..23)
    {
        New-Item -Name $horas -Path $ruta0 -ItemType Directory -WhatIf
    }
}
```

### Parte 2
#### -Listar procesos
#### -Listar hilos
#### -Listar servicios

#### Solución que se ejecuta durante una semana (168 horas)
```PowerShell
foreach($veces in 168)
{
    $fecha = (Get-Date).ToString("yyyy\\MM\\dd")
    mkdir $fecha -Force
 
    $hora = (Get-Date).Hour
    New-Item -Name $hora -Path $fecha -ItemType Directory -Force
 
    (Get-Process).Name > ([String]($fecha+"\"+$hora+"\procesos.txt"))
    (Get-Service).Name > ([String]($fecha+"\"+$hora+"\servicios.txt"))
    (Get-Process).Threads > ([String]($fecha+"\"+$hora+"\hilos.txt"))
 
    Start-Sleep -Seconds 3600
}
```

#### Solución de Daniel Cebrián
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta = $ano+"\"+$mes+"\"+$dia

    mkdir $ruta -Force

    foreach($horas in 0..23)
    {   
        New-Item -Name $horas -Path $ruta -ItemType Directory -Force
        [String]$procesos = (gps).name
        [String]$ruta1= ($ruta+"\"+$horas)
        New-Item -Name procesos.txt -Path $ruta1 -ItemType File -value $procesos -Force
    }
}
```

--------------
--------------

# Examen liberatorio
- Copiar
- Login
- Crear carpetas
- Poner nombre a lo que más se usa en tu equipo

-------------
-------------

# Examen de evaluación

## Posibles preguntas
- Crear un script que mediante un login (que lee de un fichero) el usuario introduzca una opción y si es 1 añada un fichero a un fichero comprimido.

## Exámenes para repasar

* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-03.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-04.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-05.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-12.md

## Temario que entra en el examen de evaluación

### Instalación de software libre y propietario

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.
- Arquitectura de un sistema operativo. Sistemas por lotes (batch). Sistemas por lotes con multiprogramación. Sistemas de tiempo compartido. Sistemas distribuidos.
- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.
- Tipos de sistemas operativos.
  - Monousuario o multiusuario
  - Centralizado o distribuido
  - Monotarea o multitarea
  - Uniprocesador o multiprocesador
  - Instalables y/o autoarrancables.
- Sistemas operativos libres.
- Sistemas operativos propietarios.
- Tipos de aplicaciones. Software de sistema. Software de programación. Software de aplicación.
- Licencias y tipos de licencias. Según los derechos que cada autor se reserva sobre su obra. Según su destinatario.
- Máquinas virtuales (M.V.)
  - Concepto de virtualización del hardware y características de los principales productos software libre y propietario, para el uso de máquinas virtuales.
  - Creación y personalización de M.V.
  - Ventajas e inconvenientes de la virtualización.
- Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
  - Particionado del disco duro.
  - En sistemas Windows determinar la partición donde instalaremos el S.O.
  - En sistemas Linux determinar las particiones para los distintos puntos de montaje.
  - Controladores (drivers) de almacenamiento necesarios.
- Instalación de sistemas operativos.
  - Requisitos hardware, versiones y licencias.
  - Soporte utilizado para la instalación: CD/DVD, Pendrive, LAN.
  - Datos necesarios para la instalación: usuarios, contraseñas, nombre del equipo, direcciones IP, número de licencia, etc.
- Gestión de varios sistemas operativos en un ordenador.
  - Requisitos previos. Administración del espacio del disco. Particionado y redimensionado.
  - Problemas con el registro maestro de arranque (MBR). Elegir un gestor de arranque compatible con todos los sistemas operativos a instalar.
  - Preparar las particiones de los S.O. para permitir su arranque.
  - Analizar el orden en la instalación de los sistemas operativos.
- Gestores de arranque.
  - Código de arranque maestro (Master Boot Code).
  - Formatos tabla de particiones. Master Boot Record (MBR) y Guid Partition Table (GPT).
  - Configuración de los gestores de arranque de los sistemas operativos libres y propietarios.
  - Reparación del gestor de arranque.
  - Sustitución del gestor de arranque estándar por otro más completo.
- Instalación/desinstalación de aplicaciones. Requisitos hardware y software, versiones y licencias.
- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
- Ficheros necesarios para el arranque de los principales sistemas operativos.
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
- Actualización y mantenimiento de controladores de dispositivos.
  - Automatizar la actualización de controladores.
  - Volver a una versión anterior de un controlador.
  - Actualización manual de los controladores.
  
 ### Administración y aseguramiento de la información
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

--------------
--------------

# Correción del examen
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-12-03.md#preguntas-examen-liberatorio
* https://github.com/jesusninoc/ISO-1/blob/main/Examen%20liberatorio
## Soluciones
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-1-con-where/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-2-con-foreach/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-3-creando-una-carpeta-con-la-informacion-obtenida-cada-24-horas/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-4-pasando-como-parametro-el-proceso-a-monitorizar/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-5-pasando-como-parametro-cada-proceso-que-se-ejecuta-y-monitorizando-cada-24-horas/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-obtener-informacion-sobre-los-procesos-que-se-estan-ejecutando-que-hace-un-proceso/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-obtener-informacion-sobre-los-procesos-que-se-estan-ejecutando-analizando-las-dll-que-ejecuta-que-hace-un-proceso/

## Examen subida de nota: realizar un ejercicio sobre copias de seguridad en Linux, utilizando como idea la solución en PowerShell (primer enlace)
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-12-10.md#ejercicio-sobre-copias-de-seguridad-con-integridad-comprobar-que-los-ficheros-que-tengo-en-una-carpeta-son-correctos-en-la-copia-de-seguridad-mediante-la-integridad
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-12-10.md#ejercicios-sobre-copias-de-seguridad

# Administración y aseguramiento de la información
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------

# Ficheros en Linux

## Introducción a buscar ficheros
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjerciciosFicherosBuscar.sh

## Conocer la extensión de un fichero en Linux
```Bash
file fichero
```

## Ejercicio calcular hash en Linux
```Bash
proceso=`ps -C nano -o cmd --no-headers`
ruta=`whereis $proceso`
sha512sum $ruta
```

## Introducción a bucles en Linux
* https://www.jesusninoc.com/2015/07/13/bucles-2/
* https://www.jesusninoc.com/2016/01/02/for-loop-examples/

## Bucle for en Linux
```Bash
for i in $(pgrep application.x); do ps -mo pid,tid,fname,user,psr -p $i;done
```

## Ver funcionamiento de awk
```Bash
echo "hola amigo" | awk '{print $1}'
echo "hola amigo" | awk '{print $2}'
echo "touch amigo" | awk '{print $1}'; echo "touch amigo" | awk '{print $2}'
```

## Calcular el hash SHA512 de todos los procesos que se están ejecutando en Linux
```Bash
for procesos in $(ps -aux | awk '{print $11}');do ruta=`whereis $procesos`; sha512sum $ruta;done
```

-------------

# Ficheros en PowerShell

## Listar ficheros cuya fecha de última escritura de ficheros sea de mayor que menos un día
```PowerShell
Get-ChildItem | where LastWriteTime -gt (Get-Date).AddDays(-1)
```
## Listar ficheros cuyo tamaño sea mayor de 1MB
```PowerShell
Get-ChildItem -Recurse | where Length -Gt 1MB
```
## Listar la ruta de los programas que se están ejecutando
```PowerShell
foreach($procesos in (Get-Process | select path))
{
    Get-FileHash $procesos.path
}
```
## Listar la ruta del programa Chrome que se está ejecutando
```PowerShell
foreach($id in Get-Process -Name chrome)
{
    Get-FileHash $id.Path
}
```

---------------

# Linux

## Copias de seguridad
* http://www.developandsys.es/copias-seguridad-linux/

## Programar la copia de seguridad
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh

## Ejercicios sobre copias de seguridad
- Listar archivos por fecha
  ```Bash
  ls -lt
  ls -ltr
  ls -l --sort=size
  ```
- Copia de seguridad para cada día de la semana y ser capaz de recuperar
  * https://www.youtube.com/watch?v=aDCfL9Pk3TQ&feature=youtu.be
  * https://github.com/jesnino/Bash/blob/master/Ficheros/EjercicioCalendario.sh
- Copiar cada fichero listado de un directorio en un nuevo directorio
  * https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-22.md#utilizar-xargs
- Comprimir las copias de seguridad que se han realizado
  * https://linuxzone.es/metodos-de-compresion-y-descompresion-en-linux/
- Enviar un mail cuando se haya realizado la copia de seguridad
  * https://www.interserver.net/tips/kb/linux-mail-command-usage-examples/

## Copias de seguridas de bases de datos

### MySQL dump ignorando tablas
* https://github.com/jesusninoc/Scripts/blob/master/MySQL%20dump%20ignorando%20tablas.sh

### MySQL dump completo
* https://github.com/jesusninoc/Scripts/blob/master/MySQL%20dump%20completo.sh

### Borrar copias de seguridad de bases de datos en MySQL.sh
* https://github.com/jesusninoc/Scripts/blob/master/Borrar%20copias%20de%20seguridad%20de%20bases%20de%20datos%20en%20MySQL.sh

### Database Backup Program (examples)
* https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/

-----------------

# PowerShell

## Ejercicio sobre copias de seguridad con integridad: comprobar que los ficheros que tengo en una carpeta son correctos en la copia de seguridad mediante la integridad

```PowerShell
# Ideas

# Probar la integridad de las copias de seguridad:
# - Crear un plan de pruebas. 
# - Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
# - Comprobar si los tiempos de restauración son asumibles.

# Ficheros que se van a copiar
# fichero1.txt
# fichero2.txt
# fichero3.txt
# fichero4.txt

# Ficheros que tienen las integridades de los ficheros 1,2,3,4
# fichero1integridad.txt
# fichero2integridad.txt
# fichero3integridad.txt
# fichero4integridad.txt

# crear el zip 1,2,3,4

# -------------------- RECUPERACIÓN

# descomprimir zip 1,2,3,4

# ver integridad fichero que tiene los hashes 1,2,3,4

# fichero1 si abro si la integridad es correcta

"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt

# zip meter fichero1.txt más integridades.txt (se puede separar en dos archivos)

# hay fallo y tengo que recuperar la copia

# descomprimir y ver si el fichero1.txt lo puedo ver

# porque la integridad de fichero1 es correcta

# h(f1) == f1*

if((gc .\fichero1integridad.txt) -eq (Get-FileHash .\fichero1.txt).hash)
{
    "El hash coincide"
}
else
{
    "El hash no coincide"
}

# Ver si el hash coincide para todos los ficheros

mkdir ficheros
cd .\ficheros
"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt
"holas" > fichero2.txt
(Get-FileHash .\fichero2.txt).hash
(Get-FileHash .\fichero2.txt).hash > fichero2integridad.txt

# Se supone que se ha comprimido

# Hay fallo
 
# Verificar que todos los hashes son correctos

ls fichero?.txt | %{
    $ficherointeg = $_.FullName
    $ficherointeg2 = $ficherointeg.replace(".txt","")
    $ficherofinal = ([String]$ficherointeg2+"integridad.txt")

    if(((Get-FileHash $_).hash) -eq (gc $ficherofinal))
    {
        "El hash coincide"
    }
    else
    {
        "El hash no coincide"
    }
}
```

-------------
-------------

# Repaso evaluación
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-05.md#resolver-las-siguientes-situaciones

----------

# Administración y aseguramiento de la información
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------

# PowerShell

## Ejercicio sobre copias de seguridad con integridad: comprobar que los ficheros que tengo en una carpeta son correctos en la copia de seguridad mediante la integridad

```PowerShell
# Ideas

# Probar la integridad de las copias de seguridad:
# - Crear un plan de pruebas. 
# - Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
# - Comprobar si los tiempos de restauración son asumibles.

# Ficheros que se van a copiar
# fichero1.txt
# fichero2.txt
# fichero3.txt
# fichero4.txt

# Ficheros que tienen las integridades de los ficheros 1,2,3,4
# fichero1integridad.txt
# fichero2integridad.txt
# fichero3integridad.txt
# fichero4integridad.txt

# crear el zip 1,2,3,4

# -------------------- RECUPERACIÓN

# descomprimir zip 1,2,3,4

# ver integridad fichero que tiene los hashes 1,2,3,4

# fichero1 si abro si la integridad es correcta

"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt

# zip meter fichero1.txt más integridades.txt (se puede separar en dos archivos)

# hay fallo y tengo que recuperar la copia

# descomprimir y ver si el fichero1.txt lo puedo ver

# porque la integridad de fichero1 es correcta

# h(f1) == f1*

if((gc .\fichero1integridad.txt) -eq (Get-FileHash .\fichero1.txt).hash)
{
    "El hash coincide"
}
else
{
    "El hash no coincide"
}

# Ver si el hash coincide para todos los ficheros

mkdir ficheros
cd .\ficheros
"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt
"holas" > fichero2.txt
(Get-FileHash .\fichero2.txt).hash
(Get-FileHash .\fichero2.txt).hash > fichero2integridad.txt

# Se supone que se ha comprimido

# Hay fallo
 
# Verificar que todos los hashes son correctos

ls fichero?.txt | %{
    $ficherointeg = $_.FullName
    $ficherointeg2 = $ficherointeg.replace(".txt","")
    $ficherofinal = ([String]$ficherointeg2+"integridad.txt")

    if(((Get-FileHash $_).hash) -eq (gc $ficherofinal))
    {
        "El hash coincide"
    }
    else
    {
        "El hash no coincide"
    }
}
```

## Programar la copia de seguridad
* https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/
* https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1

## Ejercicio: crear una tarea programada que ejecuta un script en PowerShell que realiza una copia de seguridad
### Crear una copia de seguridad
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-26.md#ejercicio-sobre-copias-de-seguridad-con-integridad-comprobar-que-los-ficheros-que-tengo-en-una-carpeta-son-correctos-en-la-copia-de-seguridad-mediante-la-integridad
* https://www.jesusninoc.com/12/08/crear-una-tarea-programada-en-windows-que-ejecute-un-script-de-powershell-cada-10-minutos-de-forma-indefinida-aunque-el-porcentaje-de-bateria-sea-bajo/
### Tener en cuenta a la hora de programar la tarea que ejecuta el script
```PowerShell
# Cambiar la política de ejecución de scripts para poder ejecutar
Set-ExecutionPolicy -ExecutionPolicy Unrestricted -Scope CurrentUser

# Ecribir un mensaje por pantalla
echo "hola"

# Mostrar la ruta
pwd

# Parar el script
pause

# Almacenar en un fichero la hora a la que se ejecuta el script junto con el porcentaje de batería
echo (Get-Date).Hour >> C:\xampp\mysql\bin\fichero.txt
```
### Repetir cada 1 hora indefinidamente la ejecución de un script en PowerShell
```PowerShell
$Sta = New-ScheduledTaskAction -Execute "powershell"
$Stt = New-ScheduledTaskTrigger -Once -At 19pm -RepetitionInterval (New-TimeSpan -hour 1)
Register-ScheduledTask Task01 -Action $Sta -Trigger $Stt
```

--------------------
--------------------

# Resumen de todo lo que hemos visto

## Instalación de software libre y propietario

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.
  * https://github.com/jesusninoc/ClasesISO/blob/master/2019-09-17.md#n%C3%BAcleo
  ```PowerShell
  # Mostrar información sobre el núcleo
  [System.Environment]::OSVersion.Version
  wsl uname -r
  ```
  ```PowerShell
  # Mostrar información sobre el núcleo mediante una función
  function mostrarinformacion()
  {
      # Mostrar información sobre el núcleo
      [System.Environment]::OSVersion.Version
      wsl uname -r
  }
  mostrarinformacion
  ```
- Arquitectura de un sistema operativo. Sistemas por lotes (batch). Sistemas por lotes con multiprogramación. Sistemas de tiempo compartido. Sistemas distribuidos.
  * https://www.jesusninoc.com/07/03/3-gestion-del-hardware-en-powershell/#Procesador
- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
    * https://www.jesusninoc.com/07/03/3-gestion-del-hardware-en-powershell
    ```PowerShell
    # Mostrar la carga del procesador
     Get-WmiObject win32_processor | Select-Object LoadPercentage
    ```
    ```PowerShell
    function mostrarcargaprocesador()
    {
        # Mostrar la carga del procesador
        Get-WmiObject win32_processor | Select-Object LoadPercentage
    }
    mostrarcargaprocesador
    ```
  - Administrar la ejecución de los procesos. Planificación.
    * https://www.jesusninoc.com/07/07/7-gestion-de-procesos-en-powershell/
    * https://github.com/jesusninoc/Scripts/blob/master/Ver%20si%20Apache%20est%C3%A1%20encendido.sh
    * https://github.com/jesusninoc/Scripts/blob/master/Ver%20si%20MySQL%20est%C3%A1%20encendido.sh
    * https://github.com/jesusninoc/Scripts/blob/master/Ver%20si%20Apache%20est%C3%A1%20encendido%20y%20enviar%20un%20mail.sh
    * https://github.com/jesnino/Bash/blob/master/Procesos/EjerciciosProcesos.sh
    
    ```PowerShell
    # Crear una carpeta con la fecha de hoy que contenga los procesos que se están ejecutando junto con información sobre los hilos (solución 1)

    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir $fecha
    cd $fecha

    mkdir (Get-Process | select Name -Unique).name

    foreach($carpeta in (Get-ChildItem).Name)
    {
        $carpeta
        (Get-Process -Name $carpeta).Threads >> ($carpeta+"\informacion.txt")
    }
    ```
    ```PowerShell
    # Crear una carpeta con la fecha de hoy que contenga los procesos que se están ejecutando junto con información sobre los hilos (solución 2)

    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir $fecha
    cd $fecha

    foreach($carpeta in (Get-Process | select Name -Unique).name)
    {
        $carpeta
        mkdir $carpeta
        (Get-Process -Name $carpeta).Threads >> ($carpeta+"\informacion.txt")
    }
    ```
    ```PowerShell
    # Crear una carpeta con la fecha de hoy que contenga los procesos que se están ejecutando junto con información sobre los hilos (solución mediante funciones)

    function infohilos ($proceso)
    {
        # Valores que necesita: proceso
        # Valores que devuelve: hilos
        (Get-Process -Name $proceso).Threads >> ($proceso+"\informacion.txt")
    }

    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir $fecha
    cd $fecha

    foreach($proceso in (Get-Process | select Name -Unique).name)
    {
        $proceso
        mkdir $proceso -force
        infohilos $proceso
    }
    ```
    ```PowerShell
    # Crear una carpeta con la fecha de hoy que contenga los procesos que se están ejecutando junto el número de hilos (solución mediante funciones)

    function contarhilos ($proceso)
    {
        # Valores que necesita: proceso
        # Valores que devuelve: hilos
        (Get-Process -Name $proceso).Threads.Count
    }

    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir $fecha
    cd $fecha

    foreach($proceso in (Get-Process | select Name -Unique).name)
    {
        $proceso
        mkdir $proceso -force
        contarhilos $proceso
    }
    ```
    ```PowerShell
    # Arrancar un servicio
    New-Service -Name "Tes2" -BinaryPathName '"C:\Program Files\MySQL\MySQL Server 5.1\bin\mysqld" --defaults-file="C:\Program Files\MySQL\MySQL Server 5.1\my.ini" MySQL'

    Start-Service tes2
    Stop-Service tes2
    ```
    ```Bash
    # Eliminar un proceso o un servicio
    kill -9 `pidof apache2`
    ```
      
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
    * https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Archivos
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  ```Bash
  ps -U root -u root u
  ps -eo user,comm
  ```
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.
    * https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/#Actualizaciones
    * https://www.jesusninoc.com/07/07/7-gestion-de-procesos-en-powershell/
    * https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-15.md#ver-actualizaciones
    * https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-15.md#obtener-informaci%C3%B3n-sobre-las-actualizaciones
    ```PowerShell
    # Crear carpetas para cada tipo de ProviderName y dentro de cada carpeta meter los paquetes de cada ProviderName
    
    foreach($programa in Get-Package | select ProviderName, name)
    {
        mkdir $programa.ProviderName -Force
        $programa.Name >> ($programa.ProviderName+"\informacion.txt")
    }
    ```
    ```PowerShell
    # Crear carpetas para cada tipo de ProviderName y dentro de cada carpeta meter los paquetes de cada ProviderName (mediante funciones)

    function clasificarporProviderName($programa)
    {
        $programa.Name >> ($programa.ProviderName+"\informacion.txt")
    }

    foreach($programa in Get-Package | select ProviderName, name)
    {
        mkdir $programa.ProviderName -Force
        clasificarporProviderName $programa
    }
    ```
- Tipos de sistemas operativos.
  - Monousuario o multiusuario
  - Centralizado o distribuido
  - Monotarea o multitarea
  - Uniprocesador o multiprocesador
  - Instalables y/o autoarrancables.
- Sistemas operativos libres.
- Sistemas operativos propietarios.
- Tipos de aplicaciones. Software de sistema. Software de programación. Software de aplicación.
- Licencias y tipos de licencias. Según los derechos que cada autor se reserva sobre su obra. Según su destinatario.
- Máquinas virtuales (M.V.)
  - Concepto de virtualización del hardware y características de los principales productos software libre y propietario, para el uso de máquinas virtuales.
    * https://www.jesusninoc.com/07/06/6-virtualizacion-en-powershell/ 
  - Creación y personalización de M.V.
    * https://www.jesusninoc.com/07/06/6-virtualizacion-en-powershell/#Crear_host_virtual
  - Ventajas e inconvenientes de la virtualización.
- Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
  - Particionado del disco duro.
    * https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-04.md
    * https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-17.md#comandos-para-trabajar-con-discos-en-linux
  - En sistemas Windows determinar la partición donde instalaremos el S.O.
  - En sistemas Linux determinar las particiones para los distintos puntos de montaje.
  - Controladores (drivers) de almacenamiento necesarios.
    * https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosProcesosAvanzado.ps1
    * https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-15.md#ver-controladores 
- Instalación de sistemas operativos.
  - Requisitos hardware, versiones y licencias.
    * https://www.jesusninoc.com/07/03/3-gestion-del-hardware-en-powershell/
    * https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-12.md
    * https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware.ps1
    * https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware2.ps1
    * https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-20.md#1-realizar-un-inventario-de-tu-equipo-a-nivel-hardware-y-software-ten-en-cuenta-c%C3%B3mo-clasificar-la-informaci%C3%B3n-y-no-olvides-temas-importantes-como-por-ejemplo-controladores
  - Soporte utilizado para la instalación: CD/DVD, Pendrive, LAN.
  - Datos necesarios para la instalación: usuarios, contraseñas, nombre del equipo, direcciones IP, número de licencia, etc.
- Gestión de varios sistemas operativos en un ordenador.
  - Requisitos previos. Administración del espacio del disco. Particionado y redimensionado.
  - Problemas con el registro maestro de arranque (MBR). Elegir un gestor de arranque compatible con todos los sistemas operativos a instalar.
  - Preparar las particiones de los S.O. para permitir su arranque.
  - Analizar el orden en la instalación de los sistemas operativos.
- Gestores de arranque.
  - Código de arranque maestro (Master Boot Code).
    * https://github.com/jesusninoc/ClasesISO/blob/master/2018-10-08.md#arranque 
  - Formatos tabla de particiones. Master Boot Record (MBR) y Guid Partition Table (GPT).
  - Configuración de los gestores de arranque de los sistemas operativos libres y propietarios.
  - Reparación del gestor de arranque.
  - Sustitución del gestor de arranque estándar por otro más completo.
- Instalación/desinstalación de aplicaciones. Requisitos hardware y software, versiones y licencias.
  * https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-15.md#instalar-un-paquete-msi-junto-con-informaci%C3%B3n-sobre-la-instalaci%C3%B3n
- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
    * https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/#Actualizaciones
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
- Ficheros necesarios para el arranque de los principales sistemas operativos.
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
    * https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/#Registros_del_sistema
    ```PowerShell
    # Almacenar el número de procesos que se están ejecutando y el número de hilos de cada proceso

    $procesos = gps
    $procesos.count | Out-File log.log -Append

    foreach($proceso in $procesos)
    {
        $proceso.Name | Out-File log.log -Append
        $proceso.threads.Count | Out-File log.log -Append
    }
    ```
    ```PowerShell
    # Almacenar el número de procesos que se están ejecutando y el número de hilos de cada proceso (mediante funciones, cutre)

    function guardarnombre()
    {
        $proceso.Name | Out-File log.log -Append
    }
    function guardarhilos()
    {
        $proceso.threads.Count | Out-File log.log -Append
    }

    $procesos = gps
    $procesos.count | Out-File log.log -Append

    foreach($proceso in $procesos)
    {
        guardarnombre
        guardarhilos
    }
    ```
    ```PowerShell
    # Almacenar el número de procesos que se están ejecutando y el número de hilos de cada proceso (mediante funciones)

    function guardarnombre($proceso)
    {
        $proceso.Name | Out-File log.log -Append
    }
    function guardarhilos($proceso)
    {
        $proceso.threads.Count | Out-File log.log -Append
    }

    $procesos = gps
    $procesos.count | Out-File log.log -Append

    foreach($proceso in $procesos)
    {
        guardarnombre $proceso
        guardarhilos $proceso
    }
    ```
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
- Actualización y mantenimiento de controladores de dispositivos.
  - Automatizar la actualización de controladores.
  - Volver a una versión anterior de un controlador.
  - Actualización manual de los controladores.

## Administración y aseguramiento de la información
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
    * https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#La_ruta
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
  * https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjerciciosFicherosBuscar.sh
- Identificación del software instalado mediante comandos y herramientas gráficas.
  * https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/
- Gestión de la información del sistema. Rendimiento. Estadísticas.
  * https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/#Rendimiento
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
  * https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Discos
- En sistemas Windows montar un volumen en una o más carpetas.
  * https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Montar_un_disco_virtual
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
  * https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Discos
- Permisos locales de acceso a ficheros y directorios.
  * https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-05.md#permisos-en-linux
  * https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-07.md#permisos-en-linux
  * https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Permisos-2
  * https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-26.md
  * https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md
  * https://www.jesusninoc.com/03/30/eliminar-permisos-explicitos/

---------
---------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Soluciones examen simulacro (y ver funciones)
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-11-19.md#simulacro-examen-liberatorio

# Soluciones con funciones

## Información sobre servicios (pero no se obtiene información sobre procesos)
```PowerShell
(Get-Service -Name Audiosrv,CryptSvc) | select *
```

## Información sobre servicios (buscar dos nombres de servicios, atentos al .name)
```PowerShell
foreach ($servicio in Get-WmiObject -Class win32_service)
{
    if($servicio.Name -eq "Audiosrv")
    {
        $servicio
    }
    if($servicio.Name -eq "CryptSvc")
    {
        $servicio
    }
}
```

---------
---------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Soluciones examen simulacro (y ver funciones)
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-11-19.md#simulacro-examen-liberatorio

# Soluciones con funciones

## Información sobre servicios (pero no se obtiene información sobre procesos)
```PowerShell
(Get-Service -Name Audiosrv,CryptSvc) | select *
```

## Información sobre servicios (buscar dos nombres de servicios, atentos al .name)
```PowerShell
foreach ($servicio in Get-WmiObject -Class win32_service)
{
    if($servicio.Name -eq "Audiosrv")
    {
        $servicio
    }
    if($servicio.Name -eq "CryptSvc")
    {
        $servicio
    }
}
```

## Información sobre los procesos de los servicios
```PowerShell
foreach ($servicio in Get-WmiObject -Class win32_service)
{
    if($servicio.Name -eq "Audiosrv")
    {
        Get-Process -id $servicio.ProcessId
    }
    if($servicio.Name -eq "CryptSvc")
    {
        Get-Process -id $servicio.ProcessId
    }
}
```

## Información sobre los hilos de los procesos de los servicios
```PowerShell
foreach ($servicio in Get-WmiObject -Class win32_service)
{
    if($servicio.Name -eq "Audiosrv")
    {
        (Get-Process -id $servicio.ProcessId).Threads.id
        "----------------------------------"
    }
    if($servicio.Name -eq "CryptSvc")
    {
        (Get-Process -id $servicio.ProcessId).Threads.id
    }
}
```

## Juntar los dos if para obtener información sobre los servicios
```PowerShell
foreach ($servicio in Get-WmiObject -Class win32_service)
{
    if($servicio.Name -eq "Audiosrv" -or $servicio.Name -eq "CryptSvc")
    {
        $servicio
    }
}
```
 
## Preguntar al usuario mediante una función por la operación que quiera realizar:
- 1. Información sobre servicio
- 2. Información sobre procesos relacionados con los servicios
- 3. Información sobre hilos relacionados con los procesos de los servicios
```PowerShell
function comprobar()
{
    $opcion = Read-Host "¿Qué información quiere obtener sobre Audiosrv y CryptSvc?"
    switch($opcion)
    {
        "1"{
            foreach ($servicio in Get-WmiObject -Class win32_service)
            {
                if($servicio.Name -eq "Audiosrv" -or $servicio.Name -eq "CryptSvc")
                {
                    $servicio
                }
            }
        }
        "2"{
            foreach ($servicio in Get-WmiObject -Class win32_service)
            {
                if($servicio.Name -eq "Audiosrv" -or $servicio.Name -eq "CryptSvc")
                {
                    Get-Process -id $servicio.ProcessId
                }
            }
        }
        "3"{
            foreach ($servicio in Get-WmiObject -Class win32_service)
            {
                if($servicio.Name -eq "Audiosrv" -or $servicio.Name -eq "CryptSvc")
                {
                    (Get-Process -id $servicio.ProcessId).Threads.id
                }
            }
        }
    }
}

for(1)
{
    comprobar
}
```

## Función que se dedica a comprobar operaciones
```PowerShell
function comprobar($numero)
{
    foreach ($servicio in Get-WmiObject -Class win32_service)
    {
        if($servicio.Name -eq "Audiosrv" -or $servicio.Name -eq "CryptSvc")
        {
            switch($numero)
            {
                "1"{$servicio}
                "2"{Get-Process -id $servicio.ProcessId}
                "3"{(Get-Process -id $servicio.ProcessId).Threads.id}
            }
        }
    }
}
```

## Probar aleatoriamente operaciones
```PowerShell
for(1)
{
    comprobar (Get-Random(1..3))
    Start-Sleep -Seconds 5
}
```

## Probar operaciones leyendo de un fichero
```PowerShell
foreach ($operacionautomatica in gc .\operaciones.txt)
{
     comprobar $operacionautomatica
}
```

## Crear una función en la que pasas una fecha, te crea un directorio (año/mes/día) y también le pasas la palabra procesos, hilos o servicios y te crea ese contenido dentro de la carpeta que acabas de crear
```PowerShell
function pasarfecha($fecha,$palabra)
{
    mkdir $fecha.ToString("yyyyMMdd")
    cd $fecha.ToString("yyyyMMdd")
    switch($palabra)
    {
        "procesos"{Get-Process | Out-File procesos.txt}
        "servicios"{Get-Service | Out-File servicios.txt}
        "hilo"{(Get-Process).Threads.id | Out-File servicios.txt}
    }
    cd ..
}

pasarfecha (Get-Date) procesos
```

-------------

# Funciones en PowerShell
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Funciones
* https://www.jesusninoc.com/10/14/funciones-con-parametros-y-sin-parametros/

## Ejemplos sobre funciones

### Mediante una función mostrar un mensaje para cada usuario y pedirle un valor
```PowerShell
function pedirymostrar($i)
{
    $valor = Read-Host ("Introduzca valor" + "usuario" + $i)
    Write-Host ("El valor es " + $valor)
}

foreach($i in 1..10)
{
    pedirymostrar $i
}
```

### Mediante una función crear una carpeta para cada proceso que se está ejecutando
```PowerShell
# mkdir (ps).Name -WhatIf

function crearcarpeta($procesos)
{
    mkdir $procesos -WhatIf
}

crearcarpeta (ps).Name
```

### Crear una función que sume dos número que pedimos al usuario
```PowerShell
function suma([Int]$valor1,[Int]$valor2)
{
    ($valor1)+($valor2)
}

$valor1 = Read-Host "Introduzca número 1"
$valor2 = Read-Host "Introduzca número 2"
suma $valor1 $valor2
```

## Ejercicios sobre funciones: mediante la utilización de funciones en PowerShell resolver las siguientes situaciones:
- Mostrar todos los procesos.
- Mostrar los X primeros procesos.
- Mostrar los X últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Mostrar los X procesos cuyo consumo (el parámetro que quieras utilizar) sea mayor que el valor que quieras monitorizar.
- Agrupar los procesos y muestra los que sean XXXXX.
- Abrir una página web las veces que quiera el usuario.
- Realizar un login.

### Función para mostrar todos los procesos
```PowerShell
function Procesos
{
Get-Process
}
Procesos
```

### Función para mostrar los X primeros procesos
```PowerShell
function ProcesosPrimeros($numero)
{
Get-Process | Select-Object -First $numero
}
ProcesosPrimeros 5
```

### Función para mostrar los X primeros procesos utilizando Mandatory
```PowerShell
function ProcesosUltimosM
{
param
(
[Parameter(Mandatory=$true)]
$numero
)
Get-Process | Select-Object -Last $numero
}
ProcesosUltimosM 5
```

### Función para mostrar los X últimos procesos
```PowerShell
function ProcesosUltimos($numero)
{
Get-Process | Select-Object -Last $numero
}
ProcesosUltimos 5
```

### Función para ordenar todos los procesos por CPU de forma descendente
```PowerShell
function ProcesosCPU
{
Get-Process | Sort-Object CPU -Descending
}
ProcesosCPU
```

### Función para mostrar los X procesos cuyo consumo (el parámetro que quieras utilizar) sea mayor que el valor que quieras monitorizar
```PowerShell
function ProcesosConsumo([String]$parametro,[Int]$valor,[Int]$numerovalores)
{
$parametro
$valor
$numerovalores
Get-Process | Where-Object $parametro -GT $valor | Select-Object -First $numerovalores
}
ProcesosConsumo CPU 30 5
```

### Función para agrupa los procesos y muestra los que sean XXXXX
```PowerShell
function ProcesoConcreto($nombreproceso)
{
Get-Process -Name $nombreproceso | Group-Object
}
ProcesoConcreto svchost
```

### Abrir una página web las veces que quiera el usuario
```PowerShell
function abrirweb ($numero,$url)
{
    1..$numero | %{
        start $url
        [System.Console]::Beep(261,500)
    }
}

abrirweb 3 http://www.jesusninoc.com
```

### Realizar un login mediante una función
```PowerShell
#Login de user y pass
#El user y pass correcto se escriben en el bloque BEGIN
#Ejecutar la función: login0
login0 -User jaime -Pass hola

function login0
{
  param([Parameter(Mandatory=$true, ValueFromPipeline=$true)][String[]][AllowEmptyString()]$User,$Pass)

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="user"
    $passcorrecto="pass"
  }

  process
  {
   if($User -eq $usercorrecto -and $Pass -eq $passcorrecto)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
        $User,$Pass | Out-File log.txt -Append
    }
    Write-Host "Fin de login"
  }
}
```

---------------

# Ejercicio PowerShell

## Ejercicio con if UN NÚMERO ES PAR O IMPAR POWERSHELL

### Un número es par?, si el resto es 0. La operación del resto es %
```PowerShell
$numero=5
$numero%2
```

### Comprobar si un número es par
```PowerShell
$numero=5
if($numero%2 -eq 0)
{
"Número par"
}
else
{
"Número impar"
}
```

### Mover a una carpeta los ficheros pares y borrar los ficheros impares
```PowwerShell
-2..-8 | % {ni ((Get-Date).AddDays($_).ToString("yyyyMMdd")+".txt")}
```

## Eliminar el contenido de las carpetas impares de un servidor web
```PowerShell
# Crear un fichero dentro de todos los directorios
-2..-8 | % {mkdir (Get-Date).AddDays($_).ToString("yyyyMM-dd")}
ni -Path (ls).name -Name fichero -ItemType File

(ls | select name).name | %{
    $resultado = $_.split("-")[1] % 2
    if ($resultado -eq 1)
    {
        cd $_
        rm * -WhatIf
    }
    else
    {

    }
}
```

# Ejercicio Bash

## Eliminar el contenido de las carpetas impares de un servidor web
```Bash
echo "hola" > 201811-7
echo "hola" > 201811-8
echo "hola" > 201811-9

for i in $( ls *-? ); do
    echo "---------"
    resultado=`echo $i | cut -d "-" -f2`
    let result=resultado%2
    echo $result
    if [ $result -eq 1 ]; then
        echo "mover"
    fi
done
```

---------
---------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Linux

## Compressing files
* https://www.cyberciti.biz/howto/question/general/compress-file-unix-linux-cheat-sheet.php

## Sumar en Linux
* https://www.jesusninoc.com/11/28/como-realizar-operaciones-aritmeticas-en-linux/

## Crear calendario en Linux
* https://www.youtube.com/watch?v=aDCfL9Pk3TQ&feature=youtu.be
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjercicioCalendario.sh

## Ejemplos en Bash (con repaso sobre comandos)

### Crea  directorios con los años desde 2020 hasta 2030
```Bash
mkdir {2020..2030}
```

### En cada uno de los directorios, crea un subdirectorio con los meses del año
```Bash
mkdir -p {2020..2030}/{Enero,Febrero,Marzo,Abril,Mayo,Junio,Julio,Agosto,Septiembre,Octubre,Noviembre,Diciembre}
```

### En cada mes, crear un directorio con cada día de la semana
```Bash
mkdir -p {2020..2030}/{Enero,Febrero,Marzo,Abril,Mayo,Junio,Julio,Agosto,Septiembre,Octubre,Noviembre,Diciembre}/{Lunes, Martes,Miercoles,Jueves,Viernes,Sabado,Domingo}
```

### Borrar todos los directorios Julio y Agosto de todos los años
```Bash
rm -r {2020..2030}/{Julio,Agosto}
```

### Crear un alias del comando "rm" que se llame borrar y que permita borrar el directorio Ejercicio1 (con su contenido)
```Bash
alias borrar='rm -r -f ejercicio1'
```

----------
----------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Repaso
## Eliminar el contenido de las carpetas impares de un servidor web
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-05.md#eliminar-el-contenido-de-las-carpetas-impares-de-un-servidor-web-1

## Estamos viendo sistema de archivos
* https://github.com/jesnino/PowerShell/blob/master/Ficheros/EjemplosLeerOperacionesTareasBasicasII.ps1

## TAREAS BÁSICAS II (SISTEMA DE ARCHIVOS)
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

|Tarea|Cmdlet
|---|---
|Crear o modificar un archivo|New-item
|Crear un directorio|New-item
|Ver el contenido de un archivo|Get-Content
|Acceder al contenido de un directorio|Set-Location
|Listar el contenido de un directorio|Get-Childitem
|Eliminar un archivo|Remove-Item
|Eliminar un directorio|Remove-Item
|Copiar un archivo o un directorio|Copy-Item
|Mover un archivo o un directorio|Move-Item
|Renombrar un archivo o un directorio|Rename-Item
|Imprimir un archivo|Out-Printer

## Fechas
https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Fechas

## Tienen atributos que se pueden listar (show hidden files)
https://www.jesusninoc.com/2014/11/23/show-hidden-files/

## Creación de directorios
* https://github.com/jesnino/PowerShell/blob/master/Ficheros/SolucionEjerciosFicherosProcesos.ps1
* https://www.youtube.com/watch?v=CibNbK9sp8A&list=PL89qBrmFzAa34fM6OEMLV6ybDk3Y34qud&index=3

## If
* https://www.jesusninoc.com/2016/08/05/sentencia-condicional-if/
* https://www.jesusninoc.com/2015/04/26/sentencia-condicional-if-else/
* https://www.jesusninoc.com/2016/08/07/sentencia-condicional-if-elseif-else/

## BUCLE EN POWERSHELL
* https://www.jesusninoc.com/2017/10/08/listar-todos-los-caracteres-ascii-en-powershell/
* https://www.jesusninoc.com/2017/10/05/listar-todos-los-caracteres-ascii-en-bash/

---------------

# Ejercicios

## Repaso eliminar ficheros impares
```PowerShell
"hola" | out-file 2020-11-26.txt
"hola" | out-file 2020-11-25.txt

foreach($nombre in Get-ChildItem)
{
    if($nombre.Name.Split("-")[2].replace(".txt","") % 2 -eq 1)
    {
        Remove-Item $nombre -WhatIf
    }
}
```

## Repaso elminar ficheros impares (con alias de foreach: %)
```PowerShell
Get-ChildItem | %{
    if($_.Name.Split("-")[2].replace(".txt","") % 2 -eq 1)
    {
        Remove-Item $_ -WhatIf
    }
} 
```

## Crear para varios días de la semana (desde lunes pasado hasta hoy jueves) una estructura de directorios con los procesos que se están ejecutando en el sistema
```PowerShell
-3..0 | %{
    mkdir (Get-Date).AddDays($_).ToString("yyyyMMdd")
    cd (Get-Date).AddDays($_).ToString("yyyyMMdd")
    mkdir (Get-Process).Name
    cd ..
}
```

## Preguntar al usuario por la operación que quiere realizar y el nombre del fichero que sobre el que quiere realizar las siguientes operaciones que tenemos que programar son:
## - comprimir un archivo
## - descomprimir un archivo
```PowerShell
$operacion = Read-Host "Introduzca operación"
if ($operacion -eq "comprimir")
{
    $ficheroparacomprimir = Read-Host "Introduzca fichero para comprimir"
    Compress-Archive $ficheroparacomprimir -DestinationPath $ficheroparacomprimir.Replace(".txt",".zip")
}
elseif ($operacion -eq "descomprimir")
{
    $ficheroparadescomprimir = Read-Host "Introduzca fichero para descomprimir"
    Expand-Archive $ficheroparadescomprimir
}
```


## Obtener el hash de los programas que se están ejecutando en el sistema
## 1. Obtener la ruta de los programas que se están ejecutando
## 2. Hacer el hash a esos programas
```PowerShell
foreach($ruta in (Get-Process))
{
    $ruta.name
    Get-FileHash $ruta.Path
}
```

## Realizar tareas leyendo de un fichero
```PowerShell
#Añadir operaciones al fichero
"fecha" | Out-File operaciones.txt -Append
"hilos" | Out-File operaciones.txt -Append
"crear" | Out-File operaciones.txt -Append
"imprimir" | Out-File operaciones.txt -Append
"comprimir" | Out-File operaciones.txt -Append

gc .\operaciones.txt

foreach($operaciones in gc .\operaciones.txt)
{
    switch($operaciones)
    {
        "fecha"{get-date}
        "hilos"{Get-Process | select Threads}
        "crear"{New-Item -Name elque -ItemType File}
        "imprimir"{echo "hola" | Out-Printer "Microsoft Print to PDF"}
        "comprimir"{Compress-Archive -LiteralPath .\123-11.txt –CompressionLevel Optimal -DestinationPath 123.zip}
    }
}
```

---------------

# Preguntas examen liberatorio
- Opción 1
    - Realizar una función que monitoriza
    - Función que explica qué hace un proceso
    - Hacer una copia de seguridad de las dll del proceso Notepad junto con información de la integridad
- Opción 2
    - Crear una función que indique el proceso que más tiempo de CPU consume
    - Pasar un nombre de proceso a una función e indicar si se está ejecutando
    - Crear carpetas con nombres pares (5 carpetas)

--------------
--------------

# Posibles preguntas examen liberatorio
- Asignar varios permisos a una carpeta
  - https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md#asignar-varios-permisos-a-una-carpeta
- Asignar varios permisos a distintas carpetas
  - https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md#asignar-varios-permisos-a-distintas-carpetas
- Crear carpetas con información sobre los datos obtenidos del hardware.
  - https://www.jesusninoc.com/07/03/3-gestion-del-hardware-en-powershell/#Obtener_informacion_sobre_el_hardware_creando_un_objeto_con_todos_los_datos
```PowerShell
$objeto | Get-Member -MemberType NoteProperty | Select -ExpandProperty definition
$objeto | Get-Member -MemberType NoteProperty | Select -ExpandProperty name

$objeto | Get-Member -MemberType NoteProperty | %{
    $_ | Select -ExpandProperty name
    $_ | Select -ExpandProperty definition
}
```
- Carpeta sistemaoperativo con un fichero que tiene la partición donde se ha instalado.
- Carpeta placa_base y dentro de la carpeta un fichero con información.
- Analizar la información de un servicio con capturas de pantalla y comandos de PowerShell.
- Explica la relación entre servicios, procesos y algo más?
- Qué te permite realizar la virtualización en sistemas heterogéneos.
- Cómo harías un script para instalar un gestor virtual y una máquina virtual.
- Es lo mismo ordenar en PowerShell y luego seleccionar que seleccionar y ordenar.
- Qué cantidad de memoria tienes en GB en tu equipo?
- Analiza por qué un proceso tiene tanto consumo de CPU.
- Listar un proceso en Linux desde Powershell.
- Convierte el comando systeminfo a cmdlets en PowerShell.
- Guarda un fichero con la siguiente información: procesos que se están ejecutando, añade una línea con tu nombre al fichero y la hora en que has comprobado los procesos (hazlo tres veces y comprueba que se añaden los datos de las tres ejecuciones).
- Realizar un script que almacene información de cada proceso que se está ejecutando, piensa qué información puede ser interesante.
- Un equipo de la red comienza a realizar comportamientos extraños, realiza un script que pueda detectar qué ocurre y a qué hora.
- Mostrar los servicios que representan comportamientos extraños.
- ¿Cómo puedes darte cuenta de que hay un proceso que consume toda la memoria RAM del equipo?
- Realiza una función de login que almacene los intentos fallidos y correctos.
- Crea una función para hacer un login con dos factores de verificación (incluye comprobar el nombre de usuario).
- Crea una función que intente localizar los hilos que se crean para un proceso.
- Guardar un listado con los ficheros que tenemos en la unidad Q.
- Crear carpetas para cada extensión.
- Carpeta doc y dentro de la carpeta copiar ficheros con extensión doc.
- Añadir a cada carpeta doc, txt un listado con los ficheros y además añadir un listado de permisos.
- Como usuario pedro Crea un fichero con nombre secreto.txt al que únicamente él tenga acceso, tanto de lectura como de escritura.
- Crea otro fichero, también como usuario juan, con nombre datos.txt al que tengan acceso, tanto para leer como para escribir todos los usuarios que pertenezcan al mismo grupo.  Comprueba como usuario pablo que puedes modificar el fichero.
- Como usuario juan, crea un fichero con nombre datos.txt al que pueda acceder cualquier usuario para leer su contenido, y cualquier usuario del mismo grupo para leer o escribir.
- Como usuario pedro, copia un programa del directorio /usr/bin al directorio de trabajo con un nombre diferente. Mira los permisos de este programa. Comprueba que se puede ejecutar.
- Cambia los permisos de un fichero de tal forma que sólo lo pueda ejecutar el propietario del archivo.
- Aparecen unas capturas que se han realizado con la webcam, la webcam esta en estado activo, ¿qué ha ocurrido en el sistema?
- Un empleado sabe que va a ser despedido...
- Realizar la firma de todos los programas que se están ejecutando
- Verificación de contraseña utilizando ficheros en Linux

------------------------

# Examen liberatorio
- Las preguntas que implican respuestas por scripts se pueden hacer en PowerShell, Linux o WSL (o en todos a la vez).
- Utiliza bucles, condiciones, ficheros, funciones, etc.
 
## 1. Realizar un inventario de tu equipo a nivel hardware y software, ten en cuenta cómo clasificar la información y no olvides temas importantes como por ejemplo controladores.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-12.md
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware2.ps1

## 2. Crear una estructura de ficheros en Linux y establece permisos, los permisos tienen que estar establecidos con el mayor criterio posible.
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjercicioPermisos.sh

## 3. Explicar todo lo que sepas sobre virtualización y qué relación tiene con las clases de los jueves.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-30.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-23.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-16.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-09.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-02.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-26.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-19.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-28.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-21.md

## 4. Analizar tu equipo desde el punto de vista de los programas, procesos, servicios e hilos.
* https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

## 5. Monitorizar un valor de tu equipo.
* https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosFuncionesProcesos2.ps1

## 6. Realizar un login implementando autenticación de segundo factor y almacena los intentos de login fallido.
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

## 7. Crear carpetas con información sobre los datos obtenidos del hardware.
* https://www.jesusninoc.com/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/
```PowerShell
$objeto | Get-Member -MemberType NoteProperty | %{
    [String]$dire=$_ | Select -ExpandProperty name
    mkdir $dire -Force
    cd $dire
    ni -name informacion.txt -Value ($_ | Select -ExpandProperty definition) -Force
    cd ..
}
```
## 8. Realizar la firma de todos los programas que se están ejecutando.
### Linux
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-11-13.md#calcular-el-hash-sha512-de-todos-los-procesos-que-se-est%C3%A1n-ejecutando-en-linux
### PowerShell función simple
```PowerShell
function hashear($ruta){
    Get-FileHash $ruta
}

Get-Process | select Path | %{
    hashear $_.Path
}
```
### PowerShell función compleja
```PowerShell
function hasheo
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    [AllowEmptyString()] 
    $ruta
  )

  begin
  {
    Write-Host "Principio de hasheo"
  }

  process
  {
    Get-FileHash $ruta
  }
  end
  {
    Write-Host "Final de hasheo"
  }
}

Get-Process | select Path | %{
    hashear $_.Path
}
```
## 9. Analiza por qué un proceso tiene tanto consumo de CPU.
### PowerShell función simple
```PowerShell
function consumo ($nombre,$valor)
{
   if((Get-Process -Name $nombre | select cpu).cpu -gt $valor)
    {
        "$nombre Consume mucho"
    }
    else
    {
        "$nombre No consume mucho"
    }
}

consumo -nombre powershell_ise -valor 10

Get-Process | %{
    consumo -nombre $_.Name -valor 10
}
```
### PowerShell función compleja
```PowerShell
function consumo
{
  param
  (
    [String[]]$nombre,$valor
  )

  begin
  {
    Write-Host "Principio de analizar"
    if($nombre -eq $null)
    {
        "Tiene que introducir un nombre de proceso, majo!"
        break
    }
  }

  process
  {
    if((Get-Process -Name $nombre | select cpu).cpu -gt $valor)
    {
        "$nombre Consume mucho"
    }
    else
    {
        "$nombre No consume mucho"
    }
  }
  end
  {
    Write-Host "Final de analizar"
  }
}

consumo -nombre notepad -valor 10
```
## 10. Simula un login, ten en cuenta que el password se encuentra en SHA512
```Powershell
[Reflection.Assembly]::LoadWithPartialName("System.Web")
[System.Web.Security.FormsAuthentication]::HashPasswordForStoringInConfigFile("Hola", "SHA512")
```
```Powershell
#################################################################################
#Función login de user y pass
#El user y pass (hash en SHA512) correcto se escriben en el bloque BEGIN

#Ejecutar la función
#PS C:\Users\usuario> loginH user pass

function loginH
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    [AllowEmptyString()] 
    $User,$Pass
  )

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="user"
    #El pass en SHA512
    #$passcorrecto="pass"
    $passcorrecto="5B722B307FCE6C944905D132691D5E4A2214B7FE92B738920EB3FCE3A90420A19511C3010A0E7712B054DAEF5B57BAD
59ECBD93B3280F210578F547F4AED4D25"
  }

  process
  {
   #Realizar el SHA512 del pass introducido por el usuariO
   [Reflection.Assembly]::LoadWithPartialName("System.Web")
   $Pass
   if($User -eq $usercorrecto -and [System.Web.Security.FormsAuthentication]::HashPasswordForStoringInConfigFile($Pass, "SHA512") -eq $passcorrecto)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
    }
    Write-Host "Fin de login"
  }
}
#################################################################################
```

------------
------------

# Examen liberatorio
- Las preguntas que implican respuestas por scripts se pueden hacer en PowerShell o Linux (o en los dos a la vez).
- Utiliza bucles, condiciones, ficheros, funciones, etc.
 
## 1. Realizar un inventario de tu equipo a nivel hardware y software, ten en cuenta cómo clasificar la información y no olvides temas importantes como por ejemplo controladores.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-12.md
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware2.ps1

```PowerShell
#Llamadas WMI
$ComputerSystem=Get-WmiObject Win32_ComputerSystem
$BaseBoard=Get-WmiObject Win32_BaseBoard
$BIOS=Get-WmiObject Win32_BIOS
$Processor=Get-WmiObject Win32_Processor
$Battery=Get-WmiObject Win32_Battery
$programas=Get-Package
$controladores=Get-Process -Module
 
#Crear un objeto con todos los datos sobre el hardware
$equipo=[PSCustomObject]@{
 Model = $ComputerSystem.Model
 ManufacturerBoard = $BaseBoard.Manufacturer
 BIOSVersion = $BIOS.SMbiosbiosversion
 BIOSSerialNumber = $BIOS.serialnumber
 ManufacturerProcessor=$Processor.Manufacturer
 MaxClockSpeed=$Processor.MaxClockSpeed
 Cargadelprcesador=$Processor.LoadPercentage
 programas=$programas.name
 conontroladores=$controladores
}

$equipo.programas
$equipo.conontroladores
```

## 2. Crear una estructura de ficheros en Linux y establece permisos, los permisos tienen que estar establecidos con el mayor criterio posible.
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjercicioPermisos.sh

## 3. Explicar todo lo que sepas sobre virtualización y qué relación tiene con las clases de los jueves.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-30.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-23.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-16.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-09.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-02.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-26.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-19.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-28.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-21.md

## 4. Analizar tu equipo desde el punto de vista de los programas, procesos, servicios e hilos.
https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

## 5. Monitorizar un valor de tu equipo.
https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosFuncionesProcesos2.ps1
```PowerShell
Get-Process | Where-Object PM -GT 50MB
Get-Process | Where-Object CPU -GT 1 | Where-Object PM -GT 50MB
```

## 6. Realizar un login implementando autenticación de segundo factor y almacena los intentos de login fallido.
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

```PowerShell
#Login de user y pass
#El user y pass correcto se escriben en el bloque BEGIN

function login0
{
  param([Parameter(Mandatory=$true, ValueFromPipeline=$true)][String[]][AllowEmptyString()]$User,$Pass,$Pass2)

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="jaime"
    $passcorrecto="hola"
    $passcorrecto2=gc .\pin.txt
  }

  process
  {
   if($User -eq $usercorrecto -and $Pass -eq $passcorrecto -and $Pass2 -eq $passcorrecto2)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
        $User,$Pass,$Pass2 | Out-File log.txt -Append
    }
    Write-Host "Fin de login"
  }
}

#Ejecutar la función: login0
login0 -User jaime -Pass hola -Pass2 1234
```

-------------------------

# Examen liberatorio II

## Realizar una función de muestre el consumo de procesador analizando dos valores (consumo -cpu 20 -id 6000)

```PowerShell
# Sirve para ir de uno en uno
(Get-Process | select $proceso).cpu -gt $valor

# Varios valores
Get-Process | Where-Object cpu -gt 10 | Where-Object id -gt 6000
```

## Realizar una función que permita detectar que hay una firma igual a otra

```PowerShell
# Función simple para almacenar un hash de un programa
function hashear($ruta){
    Get-FileHash $ruta
}

(hashear 'C:\Windows\System32\notepad.exe' | select hash).hash | Out-File hash.txt

(gc hash.txt)

Get-Process | select Path | %{
    hashear $_.Path
}

Get-Process | select Path | %{
    (hashear $_.Path).hash
}

Get-Process | select Path | %{
    if ((hashear $_.Path).hash -match (gc hash.txt))
    {
        "Igual",$_.path
    }
}
```

## Realizar una función que muestre información sobre los hilos de un proceso

```PowerShell
function hilos($name){
    $processHandle = (Get-Process -Name $name).id
    $Threads = Get-WmiObject -Class Win32_Thread |
    Where-Object { $_.ProcessHandle -eq $processHandle }
    "The $name process has $($threads.count) threads"
    $threads | Format-Table -Property priority, thread*, User*Time, kernel*Time
}

hilos notepad
```

## Realizar una función que muestre los procesos que utilizan un controlador
```PowerShell
Get-Process -Module | select-string "OLEAUT32.dll"

Get-Process -Module | %{
    $_ | select-string "OLEAUT32.dll"
}

Get-Process | select name,Modules  | %{
    $_.name
    $_.Modules.ModuleName | select-string "OLEAUT32.dll"
}

Get-Process | select name,Modules | %{
    if($_.Modules.ModuleName -eq "OLEAUT32.dll")
    {
        $_.Name,$_.Modules.ModuleName
    }
}
```

------------------

# Examen de la primera evaluación

## Crear carpetas para cada extensión
```PowerShell
# Crear carpetas para cada extensión.

function extensiones
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    $ruta
  )

  begin
  {
    Write-Host "Begin de extensión"
    $var = ls $ruta | select Extension
  }

  process
  {
    $var | %{
        mkdir $_.Extension
    }
  }
  end
  {
    Write-Host "Final de extensión"
    Get-ChildItem
  }
}

extensiones ../
```
## Carpeta txt y dentro de la carpeta copiar ficheros con extensión txt
```PowerShell
function txt
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    $ruta
  )

  begin
  {
    Write-Host "Begin de txt"
    mkdir txt
  }

  process
  {
    Copy-Item -Path $ruta -Destination txt -Force -WhatIf
  }
  end
  {
    Write-Host "Final de txt"
    Get-ChildItem
  }
}

txt ../*.txt
```
## Realiza una función de login que almacene los intentos fallidos y correctos
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

## Mostrar los servicios que representan comportamientos extraños
* https://www.jesusninoc.com/11/10/analizar-servicios-con-powershell/

------------------

# Repaso operaciones básicas en Bash y PowerShell
* https://github.com/jesnino/Bash/blob/master/Introduccion/EjemplosOperacionesCadenas.sh
* https://www.jesusninoc.com/2008/09/29/ejemplos-de-ejecucion-de-comandos-en-bash-y-powershell-parte-1/
* https://www.jesusninoc.com/2008/09/30/ejemplos-de-ejecucion-de-comandos-en-bash-y-powershell-parte-2/
* https://www.jesusninoc.com/2008/10/01/ejemplos-de-ejecucion-de-comandos-en-bash-y-powershell-parte-3/

# Hacer ejercicios en PowerShell
## Ejercicio de PowerShell | Crear diccionario
* https://www.youtube.com/watch?v=Pl2lK4urW3Q&list=PL89qBrmFzAa34fM6OEMLV6ybDk3Y34qud&index=2
* https://www.jesusninoc.com/2016/06/07/ejercicios-de-powershell-crear-un-diccionario/

# Enviar un mensaje entres varios equipos
### Cliente
```PowerShell
    ##Client
    $ip=[IPAddress]"127.0.0.1"
    $TcpClient=New-Object System.Net.Sockets.TcpClient($ip, "2050")
    $mensaje=New-Object System.IO.StreamWriter $TcpClient.GetStream()
    $mensaje.Write("echo hol2222a")
    $mensaje.Dispose()
```
### Servidor y cliente
```PowerShell
##Server
$ip=[IPAddress]"0.0.0.0"
$TcpListener=New-Object System.Net.Sockets.TcpListener (New-Object System.Net.IPEndPoint($ip,"2050"))
$TcpListener.Start()
 
while($true)
{
$mensaje2=(New-Object System.IO.StreamReader ($TcpListener.AcceptTcpClient().GetStream())).ReadLine()
$mensaje2
##Client
$ip=[IPAddress]"192.168.204.222"
$TcpClient=New-Object System.Net.Sockets.TcpClient($ip, "2051")
$mensaje=New-Object System.IO.StreamWriter $TcpClient.GetStream()
$mensaje.Write($mensaje2)
$mensaje.Dispose()
}
$TcpListener.Stop()
```
### Servidor que ejecuta
```PowerShell
##Server
$ip=[IPAddress]"0.0.0.0"
$TcpListener=New-Object System.Net.Sockets.TcpListener (New-Object System.Net.IPEndPoint($ip,"2051"))
$TcpListener.Start()
 
while($true)
{
$mensaje=(New-Object System.IO.StreamReader ($TcpListener.AcceptTcpClient().GetStream())).ReadLine()
$mensaje | iex
}
$TcpListener.Stop()
```

-------------
-------------

# Examen liberatorio
- Las preguntas que implican respuestas por scripts se pueden hacer en PowerShell o Linux (o en los dos a la vez).
- Utiliza bucles, condiciones, ficheros, funciones, etc.

# Preguntas
- Realizar una función que compare dos hashes.
- Obtener información sobre el sistema operativo.
- Guardar en un fichero comprimido información sobre el sistema operativo.
- Hacer un login registrando los intentos (el password se tiene que almacenar hash).
- ¿Cómo puedes detectar un problema en un sistema operativo relacionado con la ejecución de procesos?
- Mover carpetas impares
- Crear una copia de sguriad y restaurar

# Resolver las siguientes situaciones
- Hacer un login (registrar los intentos fallidos) que permita acceder a un sistema que realiza una copia de seguridad comprimida sobre información sobre el sistema (realizar la copia de seguridad).
```PowerShell
function copia()
{
    Get-Process > procesos.txt
    Compress-Archive -Path .\procesos.txt -DestinationPath aqui.zip -CompressionLevel Fastest -Force
}

$usuario = "juan"
$pass = "juan"
if($usuario -eq "juan" -and $pass -eq "juan")
{
    copia
}
```
- El sistema de copia de seguridad está fallando. ¿Cómo puedes detectar un problema en un sistema operativo relacionado con la ejecución de procesos? Haz una simulación de la situación.
```PowerShell
# Función que simula copia de seguridad
function copiaseguridad()
{
    Start-Sleep -Seconds 8
    Compress-Archive -Path .\123-10.txt -DestinationPath aqui.zip -CompressionLevel Fastest -Force
}

copiaseguridad

# En PowerShell distintos
(Get-Process -Name powershell_ise).Threads.Count
```

# Soluciones avanzadas

## Obtener información sobre el sistema operativo y enviarla por la red

### Servidor
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Dispose()
```

### Cliente
```PowerShell
Function menu {
    Clear-Host
    Write-Host "Iniciando el menu..."
    Write-Host "1. Información del hardware"
    Write-Host "2. Información de procesos"
    Write-Host "3. Ver registros de usuarios"
    Write-Host "4. Ver actualizaciones del sistema"
    Write-Host "5. Ver programas instalados"
    Write-Host "6. Salir"
}
1
menu

while($inp = Read-Host -Prompt "Escoge una accion"){

switch($inp){
        1{  $extension = Read-Host -Prompt "Pulse para analizar los componentes hardware de su pc"
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('$ComputerSystem=Get-WmiObject Win32_ComputerSystem
            $BaseBoard=Get-WmiObject Win32_BaseBoard
            $BIOS=Get-WmiObject Win32_BIOS
            $Processor=Get-WmiObject Win32_Processor
            $Battery=Get-WmiObject Win32_Battery
            [PSCustomObject]@{
             Nombre=$Processor.Name
             Model = $ComputerSystem.Model
             Name = $ComputerSystem.Name
             PrimaryOwnerName = $ComputerSystem.primaryownername
             Totalphysicalmemory = $ComputerSystem.totalphysicalmemory
             ManufacturerBoard = $BaseBoard.Manufacturer
             BIOSVersion = $BIOS.SMbiosbiosversion
             BIOSSerialNumber = $BIOS.serialnumber
             version = $BaseBoard.version
             ManufacturerProcessor=$Processor.Manufacturer
             MaxClockSpeed=$Processor.MaxClockSpeed
             DeviceIDBattery=$Battery.DeviceID.trim()
             Designvoltaje=$Battery.designvoltage
             NumberOfCores=$Processor.NumberOfCores
             NumberOfLogicalProcessors=$Processor.NumberOfLogicalProcessors
             NumberOfEnabledCore=$Processor.NumberOfEnabledCore
             LoadPercentage=$Processor.LoadPercentage
             }')
             $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
             $udpclient.Close()
            pause;
            break
        }
        2       
        {  
            $extension = Read-Host -Prompt "Pulse para analizar los procesos de su pc"
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process | select name, Path, ExecutablePath, CommandLine | Format-Custom')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            pause; 
            break
        }
        3
        {
         
            $extension = Read-Host -Prompt "Introduzca el nombre del equipo"
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('$logs = get-eventlog system -ComputerName "$extension" -source Microsoft-Windows-Winlogon -After (Get-Date).AddDays(-7);
            $res = @(); ForEach ($log in $logs) {if($log.instanceid -eq 7001) {$type = "Logon"} Elseif ($log.instanceid -eq 7002){$type="Logoff"} Else {Continue} $res += New-Object PSObject -Property @{Time = $log.TimeWritten; "Event" = $type; User = (New-Object System.Security.Principal.SecurityIdentifier $Log.ReplacementStrings[1]).Translate([System.Security.Principal.NTAccount])}};
            $res')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        }

      
      
        6 {"Exit"; break}
        default {Write-Host -ForegroundColor red -BackgroundColor white "Invalid option. Please select another option";pause}
        
    }

menu
}
```

----------------
----------------

# Examen subida de nota

## Utilizando funciones, resolver la siguiente situación: 

- Solo puedes utilizar el script si eres un usuario reconocido
- Si eres un usuario reconocido preguntas al usuario qué quiere, opciones:
    - Opción 1. Te indica si se ha ejecutado una compresión en el sistema
    - Opción 2. Te cuenta el número de hilos que se están ejecutando en el sistema

## Solución
```PowerShell
$usuario = "juan"
$password = "1234"

if($usuario -eq (Read-Host "Intro usuario") -and $password -eq (Read-Host "Intro pass"))
{
    "Estás dentro"
    switch(Read-Host "- Opción 1. Te indica si se ha ejecutado una compresión en el sistema
- Opción 2. Te cuenta el número de hilos que se están ejecutando en el sistema" 
)
    {
        "1"{
            #while(1)
            #{
                Get-Process -Name WinRAR -OutVariable resultado
                if($resultado)
                {
                    "Se ha comprimido"
                }
                else
                {
                    "No se ha comprimido"
                }
            #}
        }
        "2"{(Get-Process).Threads.Count}
    }
}
```

------------------

# Cliente-Servidor

## Comunicación entre cliente y servidor
* https://www.jesusninoc.com/2015/02/25/creating-reverse-shell/
* https://www.jesusninoc.com/2015/02/26/creating-shell/
* https://www.jesusninoc.com/2017/10/18/crear-una-comunicacion-entre-un-cliente-en-bash-de-linux-y-un-servidor-en-powershell-de-windows-utilizando-tcpip/
* https://www.jesusninoc.com/2017/10/26/crear-una-comunicacion-entre-un-cliente-en-powershell-de-windows-y-un-servidor-en-bash-de-linux-utilizando-tcpip/
* https://www.jesusninoc.com/2016/04/30/simular-el-funcionamiento-de-un-servidor-web-utilizando-netcat-en-linux/
* https://www.jesusninoc.com/2009/06/06/ejecutar-nc-exe-cmd-exe-remotamente/

## Servidor desde PowerShell
https://www.jesusninoc.com/2017/05/06/crear-un-servidor-web-al-que-se-pueda-acceder-desde-cualquier-parte-de-la-red-privada-con-powershell/

## Utilizando la comunicación remota entre cliente y servidor simular una conexión a una shell y una reverse shell
* https://www.jesusninoc.com/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
* https://www.jesusninoc.com/2015/02/25/creating-reverse-shell/
* https://www.jesusninoc.com/2015/02/26/creating-shell/

## Ejecutar un comando remotamente utilizando un servidor web creado en PowerShell
* https://www.jesusninoc.com/12/18/ejercicios-de-powershell-ejecutar-un-comando-remotamente-utilizando-un-servidor-web-creado-en-powershell/

# Posibles preguntas
- Leer de fichero
- Foreach, if y funciones
- Procesos (hilos, procesos y servicios) y sistema de archivos (copias de seguridad y hash)

-------------------

# Examen liberatorio
- Las preguntas que implican respuestas por scripts se pueden hacer en PowerShell, Linux o WSL (o en todos a la vez).
- Utiliza bucles, condiciones, ficheros, funciones, etc.
 
## 1. Realizar un inventario de tu equipo a nivel hardware y software, ten en cuenta cómo clasificar la información y no olvides temas importantes como por ejemplo controladores.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-12.md
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware2.ps1

## 2. Crear una estructura de ficheros en Linux y establece permisos, los permisos tienen que estar establecidos con el mayor criterio posible.
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjercicioPermisos.sh

## 3. Explicar todo lo que sepas sobre virtualización y qué relación tiene con las clases de los jueves.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-30.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-23.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-16.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-09.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-02.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-26.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-19.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-28.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-21.md

## 4. Analizar tu equipo desde el punto de vista de los programas, procesos, servicios e hilos.
* https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

## 5. Monitorizar un valor de tu equipo.
* https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosFuncionesProcesos2.ps1

## 6. Realizar un login implementando autenticación de segundo factor y almacena los intentos de login fallido.
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

## 7. Crear carpetas con información sobre los datos obtenidos del hardware.
* https://www.jesusninoc.com/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/
```PowerShell
$objeto | Get-Member -MemberType NoteProperty | %{
    [String]$dire=$_ | Select -ExpandProperty name
    mkdir $dire -Force
    cd $dire
    ni -name informacion.txt -Value ($_ | Select -ExpandProperty definition) -Force
    cd ..
}
```
## 8. Realizar la firma de todos los programas que se están ejecutando.
### Linux
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-11-13.md#calcular-el-hash-sha512-de-todos-los-procesos-que-se-est%C3%A1n-ejecutando-en-linux
### PowerShell función simple
```PowerShell
function hashear($ruta){
    Get-FileHash $ruta
}

Get-Process | select Path | %{
    hashear $_.Path
}
```
### PowerShell función compleja
```PowerShell
function hasheo
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    [AllowEmptyString()] 
    $ruta
  )

  begin
  {
    Write-Host "Principio de hasheo"
  }

  process
  {
    Get-FileHash $ruta
  }
  end
  {
    Write-Host "Final de hasheo"
  }
}

Get-Process | select Path | %{
    hashear $_.Path
}
```
## 9. Analiza por qué un proceso tiene tanto consumo de CPU.
### PowerShell función simple
```PowerShell
function consumo ($nombre,$valor)
{
   if((Get-Process -Name $nombre | select cpu).cpu -gt $valor)
    {
        "$nombre Consume mucho"
    }
    else
    {
        "$nombre No consume mucho"
    }
}

consumo -nombre powershell_ise -valor 10

Get-Process | %{
    consumo -nombre $_.Name -valor 10
}
```
### PowerShell función compleja
```PowerShell
function consumo
{
  param
  (
    [String[]]$nombre,$valor
  )

  begin
  {
    Write-Host "Principio de analizar"
    if($nombre -eq $null)
    {
        "Tiene que introducir un nombre de proceso, majo!"
        break
    }
  }

  process
  {
    if((Get-Process -Name $nombre | select cpu).cpu -gt $valor)
    {
        "$nombre Consume mucho"
    }
    else
    {
        "$nombre No consume mucho"
    }
  }
  end
  {
    Write-Host "Final de analizar"
  }
}

consumo -nombre notepad -valor 10
```
## 10. Simula un login, ten en cuenta que el password se encuentra en SHA512
```Powershell
[Reflection.Assembly]::LoadWithPartialName("System.Web")
[System.Web.Security.FormsAuthentication]::HashPasswordForStoringInConfigFile("Hola", "SHA512")
```
```Powershell
#################################################################################
#Función login de user y pass
#El user y pass (hash en SHA512) correcto se escriben en el bloque BEGIN

#Ejecutar la función
#PS C:\Users\usuario> loginH user pass

function loginH
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    [AllowEmptyString()] 
    $User,$Pass
  )

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="user"
    #El pass en SHA512
    #$passcorrecto="pass"
    $passcorrecto="5B722B307FCE6C944905D132691D5E4A2214B7FE92B738920EB3FCE3A90420A19511C3010A0E7712B054DAEF5B57BAD
59ECBD93B3280F210578F547F4AED4D25"
  }

  process
  {
   #Realizar el SHA512 del pass introducido por el usuariO
   [Reflection.Assembly]::LoadWithPartialName("System.Web")
   $Pass
   if($User -eq $usercorrecto -and [System.Web.Security.FormsAuthentication]::HashPasswordForStoringInConfigFile($Pass, "SHA512") -eq $passcorrecto)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
    }
    Write-Host "Fin de login"
  }
}
#################################################################################
```

# Administración y aseguramiento de la información
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# PowerShell
¿Por qué un proceso ocupa tanto en memoria si el tamaño del .exe es menor?

-------------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

# Administración y aseguramiento de la información
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# PowerShell
¿Por qué un proceso ocupa tanto en memoria si el tamaño del .exe es menor?

-------------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

------------
------------

# Permisos en PowerShell
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Permisos-2
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-26.md
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md
* https://www.jesusninoc.com/03/30/eliminar-permisos-explicitos/

------------------
------------------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

## Discos
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-04.md

# Administración y aseguramiento de la información:
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.

## Instalar Windows Server
* https://www.microsoft.com/es-es/evalcenter/evaluate-windows-server-2016

## Repasar discos en Linux y Windows
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-17.md#comandos-para-trabajar-con-discos-en-linux
### Montar unidades en Windows
* http://www.vicente-navarro.com/blog/2010/10/28/unidades-montadas-y-enlaces-simbolicos-en-windows/

## RAID
* http://www.developandsys.es/aseguramiento-la-informacion/

### Crear un volumen distribuido y un RAID 5
- Un volumen distribuido combina áreas de espacio sin asignar de varios discos en un volumen lógico, lo que le permite usar de forma más eficaz todo el -espacio y todas las letras de unidad en un sistema de varios discos.
- Un RAID 5 es una matriz de tres o más discos duros que funcionan como una unidad lógica y que supera considerablemente a los soportes de datos individuales en términos de seguridad ante los fallos y velocidad de lectura.

--------------------
--------------------

# Permisos en Linux
## Permisos especiales en Linux
http://rm-rf.es/permisos-especiales-setuid-setgid-sticky-bit/

|Permiso|Explicación
|---|---
|- - - - - - - - -	= 0|Predeterminado, sin permisos especiales. No se requiere indicar.
|- - - - - - - - t	= 1|Bit de persistencia, sticky bit
|- - - - - s - - -	= 2|Bit sgid de grupo
|- - - - - s - - t	= 3|Bit sgid y sticky
|- - s - - - - - -	= 4|Bit suid
|- - s - - - - - t	= 5|Bit suid y sticky
|- - s - - s - - -	= 6|Bit suid y sgid
|- - s - - s - - t	= 7|Bit suid, sgid y sticky

- sticky: se utiliza para permitir que cualquiera pueda escribir y modificar sobre un archivo o directorio, pero que solo su propietario o root pueda eliminarlo. 
- suid: el bit SUID activo en un archivo significa que el que lo ejecute va a tener los mismos permisos que el que creó el archivo.
- sgid: el SGID es lo mismo que en el SUID, pero a nivel de grupo. Es decir, todo archivo que tenga activo el SGID, al ser ejecutado, tendrá los privilegios del grupo al que pertenece.

## Permisos en Linux (EJERCICOS AVANZADOS SOBRE PERMISOS)

### Permisos en Linux avanzados
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

### Asignar permisos mediante llamada a sistema chmod en C
* https://www.jesusninoc.com/2014/12/01/chmod-system-call-example/

---------
---------

# Ejercicios
## Logs
* https://www.jesusninoc.com/05/05/ejercicios-de-powershell-crear-una-funcion-que-valide-un-usuario-leyendo-el-nombre-y-el-password-en-hash-correcto-de-un-fichero-en-el-caso-de-que-el-login-sea-correcto-se-almacena-la-palabra-cor/

## Hash
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Realizar_funcion_hash_sobre_un_archivo

## Permisos
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Permisos

--------------
--------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

## Ejercicios propuestos con ficheros y directorios (Bash)

- Asignar permisos para una carpeta para cada usuario
- Asignar permisos para un fichero para cada usuario
- Asignar permisos para una carpeta para cada grupo
- Asignar permisos para un fichero para cada grupo

## Script con tareas sobre permisos (script.sh)

- Crear un directorio (directorio) y un fichero (fichero)
```Bash
    mkdir directorio
    touch fichero
```
- Asignar permisos a directorio y fichero iniciales
```Bash
    chmod 611 directorio -> chmod u=rw,go=x directorio
    chmod 611 fichero -> chmod u=rw,go=x fichero
```
- Asignar permisos a directorio y fichero de cambio
```Bash
    chmod 742 directorio
    chmod 742 fichero
```
- Cambiar el usuario dueño del fichero
```Bash
    chown root fichero
```
- Cambiar el grupo dueño del directorio
```Bash
    chgrp root directorio
```

------------
------------

# Administración y aseguramiento de la información:
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.
  
# Introducción a las copias de seguridad
## Incremental
* https://github.com/jesusninoc/PowerShell/blob/master/CopiasSeguridad/EjemplosCopiasSeguridad1.ps1
## Diferencial
* https://github.com/jesusninoc/PowerShell/blob/master/CopiasSeguridad/EjemplosCopiasSeguridad2.ps1
    
# PowerShell
## 10. Gestión del rendimiento en PowerShell para administradores de sistemas (nivel básico)
* https://www.jesusninoc.com/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/

## Ayuda para copias de seguridad
### Comprimir y descomprimir
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Comprimir
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Descomprimir
```PowerShell
Compress-Archive -LiteralPath C:\powershell\example.txt –CompressionLevel Optimal -DestinationPath C:\powershell\comprimido.zip
Expand-Archive -LiteralPath C:\powershell\comprimido.zip -DestinationPath C:\powershell\descomprimir
Compress-Archive -LiteralPath C:\powershell\example2.txt -Update -DestinationPath C:\powershell\comprimido.zip
```
### Cifrar
* https://www.jesusninoc.com/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

## Ejercicios sobre copias de seguridad
- Listar archivos por fecha
  * https://www.jesusninoc.com/12/01/ejercicios-de-powershell-listar-ficheros-cuya-fecha-de-ultima-escritura-de-ficheros-sea-de-mayor-que-menos-un-dia/

- Crear una función que realiza una copia de seguridad en el día de hoy
  * https://www.jesusninoc.com/12/14/ejercicios-de-powershell-crear-una-funcion-que-realiza-una-copia-de-seguridad-en-el-dia-de-hoy/

- Crear una función que realiza una copia de seguridad en el día de hoy de los archivos que se han modificado respecto del día de ayer
  * https://www.jesusninoc.com/12/15/ejercicios-de-powershell-crear-una-funcion-que-realiza-una-copia-de-seguridad-en-el-dia-de-hoy-de-los-archivos-que-se-han-modificado-respecto-del-dia-de-ayer/

- Copia de seguridad para cada día de la semana y ser capaz de recuperar
  ```PowerShell
  # Restaurar
  mkdir tuscosasperdidas
  cd .\tuscosasperdidas
  Get-ChildItem ../ | Copy-Item
  ```
- Crear una función que realiza una restauración de una copia de seguridad
  ```PowerShell
  function restaurar($fechahoy,$donderestaurar)
  {
      cd $donderestaurar
      Get-ChildItem ("..\"+$fechahoy) | Copy-Item
  }

  restaurar -fechahoy (Get-Date).ToString("yyyyMMdd") -donderestaurar restaurar
  ```
- Ser capaz de recuperar en función de lo que pide el usuario
  ```PowerShell
  # Restaurar en función de lo que pide el usuario
  $datosusar = Read-Host "Dime el nombre del arhcivo que tengo que recuperar"
  ls $datosusar* | Copy-Item
    ```
- Comprimir las copias de seguridad que se han realizado
  ```PowerShell
  # Comprimir el directorio con la fecha
  $fecha = (Get-Date).ToString("yyyyMMdd") + ".zip"
  Compress-Archive -LiteralPath .\20181119 –CompressionLevel Optimal -DestinationPath $fecha
  Compress-Archive -LiteralPath virus.exe -Update -DestinationPath $fecha
  ```

-------------------
-------------------

# Introducción a tareas de administración
https://www.jesusninoc.com/2017/09/01/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

## Agregar/Eliminar software
https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
## Actualización
https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
## Gestión de procesos
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/
## Programación de tareas
https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
## Usuarios
https://www.jesusninoc.com/2017/07/08/8-gestion-de-usuarios-en-powershell/
## Grupos
https://www.jesusninoc.com/2017/07/08/8-gestion-de-usuarios-en-powershell/
## Gestión del almacenamiento
* https://www.jesusninoc.com/2017/07/03/3-gestion-del-hardware-en-powershell/
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
## Gestión de la red
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
## Copias de seguridad
https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
## Reparación del sistema
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/
## Rendimiento del sistema
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

------------
------------

# Repaso
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-09-01.md (cómo vamos)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-01.md (proyectos)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-02.md (multimedia)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-03.md (virtualización)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-09.md#examen-1%C2%AA-recuperaci%C3%B3n (examen recuperación)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-09.md#introducci%C3%B3n-a-tareas-de-administraci%C3%B3n (tareas de administración)

---------------
---------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## ¿Qué es el número de sesiones de usuario?
* https://www.jesusninoc.com/01/12/introduccion-a-los-sistemas-operativos/#El_numero_de_sesiones

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## ¿Qué es el número de sesiones de usuario?
* https://www.jesusninoc.com/01/12/introduccion-a-los-sistemas-operativos/#El_numero_de_sesiones

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

-------------
-------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Ejercicios

### Crear una función que indica si existe o no un usuario
* https://www.jesusninoc.com/01/13/ejercicios-de-powershell-crear-una-funcion-que-indica-si-existe-o-no-un-usuario/

### Verificar que existe un usuario mediante el cmdlet Get-LocalUser
* https://www.jesusninoc.com/01/13/ejercicios-de-powershell-verificar-que-existe-un-usuario-mediante-el-cmdlet-get-localuser/
  
### Crear una función que dice si un usuario existe o no (mostrando si existe o no)
* https://www.jesusninoc.com/01/09/ejercicios-de-powershell-crear-una-funcion-que-dice-si-un-usuario-existe-o-no-mostrando-si-existe-o-no-con-read-host/

### Crear una función que dice si un usuario existe o no (mostrando si existe o no, con Read-Host y aceptar minúsculas)
* https://www.jesusninoc.com/01/10/ejercicios-de-powershell-crear-una-funcion-que-dice-si-un-usuario-existe-o-no-mostrando-si-existe-o-no-con-read-host-y-aceptar-minusculas/

### Crear una función que indica el SID de los usuarios
* https://www.jesusninoc.com/01/06/ejercicios-de-powershell-crear-una-funcion-que-indica-el-sid-de-los-usuarios/

### Iniciar un programa siendo otro usuario
* https://www.jesusninoc.com/01/11/ejercicios-de-powershell-iniciar-un-programa-siendo-otro-usuario/

### Crear una función que indique el nombre del usuario leyendo un SID
* https://www.jesusninoc.com/01/13/ejercicios-de-powershell-crear-una-funcion-que-indique-el-nombre-del-usuario-leyendo-un-sid/

### Crear una función que lea SID de un fichero e indique el nombre del usuario
* https://www.jesusninoc.com/01/13/ejercicios-de-powershell-crear-una-funcion-que-lea-sid-de-un-fichero-e-indique-el-nombre-del-usuario/

### Crear una función que lea los nombres de usuarios en un fichero e indique el SID de cada uno de ellos
* https://www.jesusninoc.com/01/13/ejercicios-de-powershell-crear-una-funcion-que-lea-los-nombres-de-usuarios-en-un-fichero-e-indique-el-sid-de-cada-uno-de-ellos/

-----------
-----------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## DESHABILITAR UAC DESDE POWERSHELL
* https://www.jesusninoc.com/01/15/deshabilitar-uac-desde-powershell/

## Ejercicios sobre usuarios en PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1

## Ejercicio para clase
### Buscar un usuario dentro del ordenador (o del Directorio Activo), el nombre del usuario se transmite por radio y llega a un sistema Linux (al que hay que conectarse por SSH)
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/#Ver_o_listar_usuarios
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1
* https://github.com/jesusninoc/ClasesSOM/blob/master/2019-02-14.md#ssh
* https://www.jesusninoc.com/09/24/ssh-desde-powershell/

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Ejercicios sobre usuarios en PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuariosFicheros.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjemplosCrearUsuariosGruposCarpetaCompartida.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjemplosCrearUsuariosGruposCarpetaCompartida2.ps1
* https://www.jesusninoc.com/2012/12/30/add-users-xml/
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
* https://www.jesusninoc.com/users/

## Crear usuarios leyendo de un fichero el user y password
```PowerShell
gc .\usuarios.txt | %{
    $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
    New-LocalUser $_.split(",")[0] -Password $pass
}
```

## Crear y eliminar usuarios
```PowerShell
"asir1,p@ssword1" > usuarios.txt
"asir2,p@ssword2" >> usuarios.txt
"asir3"  >> usuarios.txt

#####

gc .\usuarios.txt | %{
    $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
    New-LocalUser $_.split(",")[0] -Password $pass
}

######

gc .\fichero.txt | %{
    if($_.split(",").count -eq 1)
    {
        Remove-LocalUser $_.split(",")[0] -WhatIf
    }
    else
    {
        $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
        New-LocalUser $_.split(",")[0] -Password $pass -WhatIf
    }
}
```

## Analizar información sobre usuarios con PowerShell (1ª parte)
* https://www.youtube.com/watch?v=bZWs08BBjDc
## Analizar información sobre usuarios con PowerShell (2ª parte)
* https://www.youtube.com/watch?v=CCipPiIUVFY
## Crear, modificar y borrar usuarios con PowerShell
* https://www.youtube.com/watch?v=7sxxCnyRwcg
## Analizar información sobre grupos con PowerShell (1ª parte)
* https://www.youtube.com/watch?v=jaIQHD9Jlgc
## Analizar información sobre grupos con PowerShell (2ª parte)
* https://www.youtube.com/watch?v=qprY8B6uI50
## Crear, modificar, añadir usuario, quitar usuario y borrar grupo con PowerShell
* https://www.youtube.com/watch?v=eudt3H2o8z0

## Perfiles
* https://www.jesusninoc.com/07/22/listar-las-rutas-de-los-perfiles-de-los-usuarios/

## UTILIZAR JSON CON NOMBRES Y APELLIDOS ALEATORIOS
* https://www.jesusninoc.com/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

--------------
--------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Más ejercicios sobre usuarios en PowerShell

  - Ver el SID (Security Identifier) de un usuario en Windows con PowerShell
  - Verificar si existe un usuario en Windows 10 con PowerShell
  - Obtener los SID de las cuentas de usuario en Windows 10
  - Cmdlets relacionados con la gestión de cuentas locales en Windows 10
  - Creates a local user account
  - Creates a local security group
  - Gets local user accounts
  - Gets members from a local group
  - Gets the local security groups
  - Añadir usuarios a un grupo local en Windows 10 con PowerShell 5.1
  - Listar miembros de un grupo local en Windows 10 con PowerShell 5.1
  - Cambiar la contraseña a un usuario local en Windows 10 con PowerShell 5.1
  - Listar grupos locales en Windows 10 con PowerShell 5.1
  - Listar usuarios locales en Windows 10 con PowerShell 5.1
  - Eliminar un grupo local en Windows 10 con PowerShell 5.1
  - Crear un grupo local en Windows 10 con PowerShell 5.1
  - Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
  - Eliminar un usuario local en Windows 10 con PowerShell 5.1
  - Crear un usuario local en Windows 10 con PowerShell 5.1
  - Crear un usuario con contraseña leyendo los datos de un fichero
  - Cambiar contraseña a un usuario
  - Contar el número de grupos que hay en el sistema
  - Contar el número de usuarios que hay en el sistema
  - List local groups
  - List local users
  - Añadir un usuario a un grupo
  - Crear un grupo
  - Crear un usuario con contraseña
  - Usuario actual
  - Information about group accounts
  - Information about user accounts
  - Cmdlets relacionados con tareas básicas y de administración en el sistema operativo Windows
  - Reading username and password from file and do a login
  - Create users and groups, add a user to a group and share directory
  - Create users with passwords
  - Information about remote user

## CONVERTIR A JSON EL LISTADO DE USUARIOS QUE HAY EN EL SISTEMA EJECUTANDO UN CMDLET CON POWERSHELL
* https://www.jesusninoc.com/02/05/convertir-a-json-el-listado-de-usuarios-que-hay-en-el-sistema-ejecutando-un-cmdlet-con-powershell/

## UTILIZAR JSON CON NOMBRES Y APELLIDOS ALEATORIOS
* https://www.jesusninoc.com/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

## REGISTRAR Y MOSTRAR UN EVENTO EN POWERSHELL CUANDO SE CREA UN USUARIO
* https://www.jesusninoc.com/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

---------------------
---------------------

# Script para crear usuario automáticamente (y password generado aleatorio)

# Repaso a usuarios
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

# Preguntas examen
- Crear usuarios desde otro cmdlet
- Crear usuarios añadiendo algo
- Crear, exportar, crear en otra máquina
- Leer operaciones

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Gestión de usuarios en Windows (Server)

## Instalación de servicios de directorio

------------------
------------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Gestión de usuarios en Windows (Server)

## Instalación de servicios de directorio

--------------

# Administración de servicio de directorio

## Active Directory
* http://sec.cs.kent.ac.uk/x500book/
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-18.md
* http://www.developandsys.es/category/windows-server/active-directory/
* http://www.developandsys.es/gestion-objetos-active-directory/

### Instalación, configuración, objetos, relaciones de confianza, gpos, rodc, dc secundario (versión core)
* http://www.developandsys.es/category/windows-server/active-directory/

## OpenLDAP, Samba y Samba DC
* http://www.developandsys.es/?s=open+ldap
* http://www.developandsys.es/nfs-y-samba/

## Filtros LDAP

### UTILIZAR UN FILTRO LDAP PARA LOCALIZAR UN USUARIO
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
### UTILIZAR UN FILTRO LDAP PARA VERIFICAR LA HORA DEL ÚLTIMO INICIO DE SESIÓN DE LOS USUARIOS DEL ACTIVE DIRECTORY
* https://www.jesusninoc.com/07/05/utilizar-un-filtro-ldap-para-verificar-la-hora-del-ultimo-inicio-de-sesion-de-los-usuarios-del-active-directory/

## Crear usuarios leyendo desde un fichero (explicar fichero y bucle foreach)
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Ficheros
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Bucle_Foreach

## Cmdlets para Active Directory
* http://www.developandsys.es/gestion-objetos-active-directory/

## Crear en AD usuarios y OU leyendo de un fichero
```PowerShell
foreach($elemento in Get-Content .\crear.txt)
{
    $elemento
    New-ADUSer -Name $elemento -Sam $elemento -Path "OU=Localizacion,DC=Dominio,DC=Local" -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
    Start-Sleep -Seconds 5
}

foreach($elemento in Get-Content .\crear.txt)
{
    $elemento.split(",")[0]
}

foreach($elemento in Get-Content .\crear.txt)
{
    if($elemento.split(",")[0] -eq 1)
    {
        "crear ou " + $elemento.split(",")[1]
    }
    
    if($elemento.split(",")[0] -eq 2)
    {
        "crear user " + $elemento.split(",")[1]
        New-ADUSer -Name $elemento.split(",")[1] -Sam $elemento.split(",")[1] -Path "OU=Localizacion,DC=Dominio,DC=Local" -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
    }
}
```

--------------

# Passwords

## ENCONTRAR UN PASSWORD QUE CONTIENE LOS NÚMEROS DE LA PRIMERA FILA DEL TECLADO QWERTY GENERANDO COMBINACIONES ALEATORIAS
https://www.jesusninoc.com/01/20/encontrar-un-password-que-contiene-los-numeros-de-la-primera-fila-del-teclado-qwerty-generando-combinaciones-aleatorias/

## Contraseñas seguras con PowerShell
https://www.jesusninoc.com/contrasenas-seguras-con-powershell/

## Cracking Passwords Version 1.1
https://repo.zenk-security.com/Reversing%20.%20cracking/Cracking_Passwords_Guide.pdf

## Privilege Escalation without Automated Tools - InfoSec Resources
https://securitydocs.com/privilege-escalation-without-automated-tools-infosec-resources/38418/

--------------

# Random

## Ejercicio PowerShell: adivinar un número aleatorio que genera PowerShell

```PowerShell
#Generar un número aleatorio entre 1 y 100
Get-Random (1..100)
```
```PowerShell
#Pedir al usuario un número una vez e intentar adivinar el número aleatorio que se ha generado
$numeroadivinar=Get-Random (1..100)
$a=Read-Host "Intentar adivinar un número, introduzca número"
if($numeroadivinar -eq $a)
{
"Número adivinado"
}
```
```PowerShell
#Pedir al usuario números para intentar adivinar un número aleatorio entre 1 y 100
$numeroadivinar=Get-Random (1..100)
while($true)
{
$a=Read-Host "Intentar adivinar un número, introduzca número"
if($numeroadivinar -eq $a)
{
"Número adivinado"
#Si se adivina el número salir del bucle while con break
break
}
}
```
```PowerShell
#Pedir al usuario números para intentar adivinar un número aleatorio entre 1 y 100, ofrecer ayuda al usuario para adivinar el número
$numeroadivinar=Get-Random (1..100)
do
{
$a=Read-Host "Intentar adivinar un número, introduzca número"
switch($numeroadivinar)
{
{$_ -le $a -and $_ -ge 1}{Write-Host "No adivinado, el número es menor que $a" -ForegroundColor red}
{$_ -eq $a}{Write-Host "Número adivinado" -BackgroundColor Blue;break}
{$_ -ge $a -and $_ -le 100}{Write-Host "No adivinado, el número es mayor que $a" -ForegroundColor red}
}
#Si el número está adivinado acabar de preguntar al usuario
}while(!($numeroadivinar -eq $a))
```

## Más sobre random
### Generar letras aleatorias
https://www.jesusninoc.com/2017/10/11/generar-letras-aleatorias/

### Generate Random Text based on Length
https://www.commandlinefu.com/commands/view/24101/generate-random-text-based-on-length

### Ejercicios de PowerShell: mostrar y escribir una letra aleatoria por consola en el menor tiempo posible con PowerShell
https://www.jesusninoc.com/2017/09/02/ejercicios-de-powershell-mostrar-y-escribir-una-letra-aleatoria-por-consola-en-el-menor-tiempo-posible-con-powershell/

### Generar palabras aleatorias con letras aleatorias
https://www.jesusninoc.com/2017/01/07/generar-palabras-aleatorias-con-letras-aleatorias/

### Ejercicios de PowerShell: mostrar y escribir una palabra aleatoria por consola en el menor tiempo posible con PowerShell
https://www.jesusninoc.com/2017/09/05/ejercicios-de-powershell-mostrar-y-escribir-una-palabra-aleatoria-por-consola-en-el-menor-tiempo-posible-con-powershell/

### Ejercicios de PowerShell: crear el juego de piedra, papel o tijera
https://www.jesusninoc.com/2017/03/01/ejercicios-de-powershell-crear-el-juego-de-piedra-papel-o-tijera/

### Ejercicios de PowerShell: crear el juego de piedra, papel o tijera (script en una línea)
https://www.jesusninoc.com/2017/03/02/ejercicios-de-powershell-crear-el-juego-de-piedra-papel-o-tijera-script-en-una-linea/

### Tres en raya
```Java
private int[][] lineaGanadora = new int[][] { { 0, 1, 2 }, { 3, 4, 5 }, { 6, 7, 8 }, { 0, 3, 6 }, { 1, 4, 7 }, { 2, 5, 8 }, { 0, 4, 8 }, { 2, 4, 6 } };
```

--------------

# Ejercicio de password y random
## Crear usuarios con un password random e intentar adivinarlo con Cain y Abel
```PowerShell
(((1..9) | Get-Random -Count 4) -join "") + (((97..99) | Get-Random -Count 2 | % {[char]$_}) -join "") + (((65..67) | Get-Random -Count 2 | % {[char]$_}) -join "")
```
## Cain y Abel
* https://github.com/xchwarze/Cain

--------------

# Generar hash NTLM
* https://www.jesusninoc.com/01/26/creacion-de-hashes-de-contrasena-nt4/

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

------------

# Ejercicio de password y random
## Crear usuarios con un password random e intentar adivinarlo con Cain y Abel
```PowerShell
(((1..9) | Get-Random -Count 4) -join "") + (((97..99) | Get-Random -Count 2 | % {[char]$_}) -join "") + (((65..67) | Get-Random -Count 2 | % {[char]$_}) -join "")
```
## Cain y Abel
* https://github.com/xchwarze/Cain

--------------

# Generar hash NTLM
* https://www.jesusninoc.com/01/26/creacion-de-hashes-de-contrasena-nt4/

------------------
------------------

# Examen repaso de usuarios
- Crear usuarios leyendo de un fichero y después añadir la fecha al nombre
- Crear usuarios aleatorios en los que la primera letra sea la a y el resto aleatorio
- Adivinar un hash
- El jueves examen sobre qué hace el siguiente fragmento de código

-----------
-----------

# Gestión de usuarios en Linux

## Por pasos dentro de un script
```Bash
nano
```
## Ver si está creado un usuario
```Bash
grep usuario1 /etc/passwd | wc -l
```
## Crear una carpeta en /home 
```Bash
sudo mkdir nombreusuario
```
## Dar permisos a la carpeta del usuario 
```Bash
sudo chmod 764
```
## Crear el usuario y se le asigna el directorio donde va a trabajar y la shell 
```Bash
useradd -d /home/usuarionuevo -s /bin/bash Usuario
```
## Crear la contraseña a el usuario
```Bash
sudo passwd usuario
```
## Cambiar a la carpeta del nuevo usuario de propietario de usuario y grupo
```Bash
chgrp Usuario /home/usuarionuevo
chown Usuario /home/usuarionuevo
```
## Asignar los permisos heredados a la carpeta de el usuario para que tenga los permisos necesarios para trabajar 
```Bash
cd nombreusuario, umask 0011
```

---------------

# Repaso para realizar scripts en Linux

## Repaso scripting (extraer caracteres de cadenas)
```Bash
short=$(echo "${long}" | cut -c1-2)
short=$(echo "${long}" | head -c2)
short=$(echo "${long}" | awk '{print substr ($0, 0, 2)}')
short=$(echo "${long}" | sed 's/^\(..\).*/\1/')
```

## Partir una cadena por un cáracter determinado
```bash
echo 'hola:adios' | cut -d ':' -f1
```
## Mostrar campos específicos del fichero
```bash
echo "1 Juan Director Tecnología 3000€" > empleados.txt
echo "2 Pedro Becario Web 1000€" >> empleados.txt
awk '{print $2,$5;}' empleados.txt
```
## Sumar los valores de las columnas de un fichero
```bash
echo "1 100" > valor.txt
echo "2 300" >> valor.txt
cat valor.txt  | awk '{ sum += $2 } END { print sum }'
```
## Sumar los valores de las columnas de un fichero si se cumple una condición
```bash
echo "1 nivel1 100" > valor.txt
echo "2 nivel2 300" >> valor.txt
echo "3 nivel1 300" >> valor.txt
cat valor.txt  | awk ' $2 == "nivel1" { sum += $3 } END { print sum }'
```

## Ejemplos y trucos para el lenguaje de programación AWK
http://wiki.woop.es/AWK

--------------

# Utilizar xargs
Definir donde se van a definir los parámetros
```bash
ls | xargs -I ARG echo fichero ARG fichero
```
Definir donde se van a definir los parámetros
```bash
echo "después" | xargs echo "antes"
echo "antes" | xargs -i echo {} "después"
```
Mostrar los parámetros 1 y 2
```bash
cat fichero.txt | xargs -l bash -c 'echo this is first:$0 second:$1'
```
Asignar permisos leyendo desde un fichero el nombre y el permiso en octal
```bash
cat fichero.txt | xargs bash -c 'chmod $0 $1'
```

--------------
--------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Seguridad en Linux

## Linux Shell script to add a user with a password to the system
https://www.cyberciti.biz/tips/howto-write-shell-script-to-add-user.html

--------------

# Permisos en Windows

## Obtener los descriptores de seguridad de todos los ficheros de una unidad
https://www.jesusninoc.com/2016/09/10/obtener-los-descriptores-de-seguridad-de-todos-los-ficheros-de-una-unidad/

## Eliminar permisos explícitos
https://www.jesusninoc.com/2016/03/30/eliminar-permisos-explicitos/

## Añadir permiso NTFS a una carpeta
https://www.jesusninoc.com/2015/08/19/anadir-permiso-ntfs-a-una-carpeta/

## Crear un recurso compartido y asignar permisos al recurso
https://www.jesusninoc.com/2015/06/09/crear-un-recurso-compartido-y-asignar-permisos-al-recurso/

## Clonar permisos NTFS
https://www.jesusninoc.com/2015/01/23/clonar-permisos-ntfs/

## PENTESTER’S WINDOWS NTFS TRICKS COLLECTION
https://www.sec-consult.com/en/blog/2018/06/pentesters-windows-ntfs-tricks-collection/
  
--------------

# Examen

## Crear usuarios

### En PowerShell (en Windows Server leyendo los usarios de la configuración actual del Directorio Activo del Centro con Win32_UserAccount)
```PowerShell
Get-WmiObject Win32_UserAccount | % {
    Invoke-Command -ScriptBlock {New-LocalUser $_.name -WhatIf} -ComputerName .
}
```
### Leyendo los usuarios desde un fichero en Linux
```PowerShell
wsl cat /root/usuarios.txt | %{
    New-LocalUser $_ -whatif
}
```

### Crear usuarios en Linux, leyendo de un fichero
```Bash
cat usuarios.txt | xargs -I{} useradd {}
```

----------------
----------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Repaso ejercicios de usuarios en Linux
* https://www.jesusninoc.com/12/03/ejercicios-de-bash-ver-el-funcionamiento-de-awk/
* https://www.jesusninoc.com/11/16/ejercicios-de-bash-leer-contenido-de-un-fichero/
* https://www.jesusninoc.com/12/24/ejercicios-de-bash-sacar-solo-el-nombre-del-usuario-y-al-lado-cuantos-caracteres-tiene-ese-nombre/
* https://www.jesusninoc.com/02/06/ejercicios-de-bash-crear-usuarios-leyendo-desde-un-fichero/
* https://www.jesusninoc.com/01/04/ejercicios-de-bash-crear-usuarios-en-ubuntu-leyendo-de-un-fichero/

-------------
-------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Ejercicio de repaso sobre creación de usuarios
* https://www.jesusninoc.com/11/29/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-crear-un-usuario-desde-powershell/

----------------------

# Teoría de redes
* https://www.jesusninoc.com/04/26/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

------------------
------------------

# Tarea, hacer ping entre dos máquinas virtuales configurando la IP por comandos

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Teoría de redes
* https://www.jesusninoc.com/04/26/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

# Repaso básico de red

## Convertir a binario las direcciones MAC de los dispositivos de red
* https://www.jesusninoc.com/01/25/convertir-a-binario-las-direcciones-mac-de-los-dispositivos-de-red/

## Configurar IP en Windows
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Bash
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Conectar con Linux por SSH
https://www.jesusninoc.com/2017/09/26/ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/

## Guardar un fichero html preguntando al usuario qué título quiere
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html

start chrome .\web.html

## Crear y ejecutar un script de Bash realizando una conexión SSH desde PowerShell en Windows
https://www.jesusninoc.com/2017/09/22/crear-y-ejecutar-un-script-de-bash-realizando-una-conexion-ssh-desde-powershell-en-windows/

## Crear y ejecutar un script de Bash realizando una conexión SSH a un contenedor Docker desde PowerShell en Windows
https://www.jesusninoc.com/2017/10/21/crear-y-ejecutar-un-script-de-bash-realizando-una-conexion-ssh-a-un-contenedor-docker-desde-powershell-en-windows/

-----------------
-----------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Teoría red
* https://www.jesusninoc.com/04/26/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

# Conceptos de red
## TTL
Para evitar que una petición ping viaje de forma ilimitada por internet, en cada una de ellas se establece un Time To Live (TTL), que representa el número de saltos que ha dado el paquete de host en host por internet hasta alcanzar su destino. En cada salto, el TTL se decrementa en una unidad, y si en algún momento llega a 0 entonces el paquete se descarta y el host devuelve un error al origen.
## ¿Por que me cambia el valor TTL dependiendo de a quien haga ping?
https://foro.elhacker.net/redes/duda_iquestpor_que_me_cambia_el_valor_ttl_dependiendo_de_a_quien_haga_ping-t69071.0.html
## Cómo usar TRACERT para solucionar problemas de TCP/IP en Windows
https://support.microsoft.com/es-es/help/314868/how-to-use-tracert-to-troubleshoot-tcp-ip-problems-in-windows
## Ping continuado a servidores de tarificación por byte consumido
https://www.jesusninoc.com/2004/06/02/ping-continuado-a-servidores-de-tarificacion-por-byte-consumido/
## Modificar TTL para un solo registro en la zona DNS
http://nextadmin.blogspot.com.es/2014/10/modificar-ttl-para-un-solo-registro-en.html
## Cmdlets for TCP/IP Model Layers (Windows)
https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-11.md
## ifconfig vs ip (Linux) 
https://p5r.uk/blog/2010/ifconfig-ip-comparison.html
## Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
## Almacenar la información enviada entre un cliente y un servidor en una base de datos MySQL con PowerShell
https://www.jesusninoc.com/2017/01/15/almacenar-la-informacion-enviada-entre-un-cliente-y-un-servidor-en-una-base-de-datos-mysql-con-powershell/
## Modificar datagramas UDP con SoftPerfect Network Protocol Analyzer
https://www.jesusninoc.com/2016/03/19/modificar-datagramas-udp-con-softperfect-network-protocol-analyzer/
## Network
https://www.jesusninoc.com/network

---------
---------

# Ejercicio global

-------------
-------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Router
## Ideas para hacer con un router
- Ejecutar scripts
- Instalar aplicaciones
- Analizar información sobre llamadas (recibidas, realizadas, etc.)
- Enviar información desde el router (mail)
- Ver ficheros modificados
- Ver la IP asignada por el proveedor
- Ver la arquitectura del router
- Ejecutar scripts de Python
- Ejecutar código PHP
- Desensamblar aplicaciones

## busybox
For all the standard Unix utilities that the system didn't have.
https://busybox.net/downloads/BusyBox.html

## Binarios busybox
https://www.busybox.net/downloads/binaries/

## The Buildroot user manual
https://buildroot.org/downloads/manual/manual.html

## Busybox container and rootfs builder for minimal Docker base images with Python
https://github.com/odise/busybox-python

## Binario para mips
https://www.busybox.net/downloads/binaries/1.28.1-defconfig-multiarch/busybox-mips.log

## Router Mitrastar HGW-2501GN-R2: Shell e Ingeniería inversa (para crear firmwares modificadas, por ejemplo) (Actualizado)
http://blog.theliel.es/2015/10/router-mitrastar-hgw-2501gn-r2-shell-e-ingenieria-inversa-para-crear-firmwares-modificadas-por-ejemplo.html

## MitraStar DSL-100HN-T1/GPT-2541GNAC - Privilege Escalation
https://www.exploit-db.com/exploits/43061/

## Elevando privilegios en routers domésticos
http://jolama.es/temas/router-attack/index.php

## Enviar binario por SCP
### To copy files from the local system to a remote system:
```Bash
scp file... user@host.domain:path
```
### To copy files from a remote system to your local system:
```Bash
scp user@host.domain:path ... dest
```

----------
----------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Análisis de conexiones de red
https://www.jesusninoc.com/2017/05/01/analisis-de-conexiones-de-red/

--------------------

# Antivirus y virus
* https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
* https://www.jesusninoc.com/antivirus/

## Vulnerability
* https://www.jesusninoc.com/vulnerability/

## Una aproximación a los virus en PowerShell
* https://github.com/jesusninoc/Seguridad/blob/master/Una%20aproximaci%C3%B3n%20a%20los%20virus%20en%20PowerShell.md

## Virus examples
* https://www.symantec.com/security_response/landing/threats.jsp
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-012722-4614-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-031313-1110-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-112410-5327-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051114-5305-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052722-4205-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051817-0655-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052017-5535-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051210-1139-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052615-4530-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-012722-4614-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-111216-5350-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2009-061215-3706-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2009-063005-3448-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2010-100614-5201-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-031313-1110-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-112410-5327-99

## VirusTotal
* https://www.virustotal.com/#/home/upload

## Upload a suspected infected file (Retail)
* https://submit.symantec.com/websubmit/retail.cgi

# Ideas sobre comportamientos de troyanos
## Grabar audio
* http://www.jesusninoc.com/2015/06/27/grabar-audio-desde-la-linea-de-comandos/

## Keylogger
* https://www.jesusninoc.com/03/11/keylogger-sencillo-con-powershell/

# Enviar un cmdlet a un servidor y ejecutarlo
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()
```

## Cliente (manda un cmdlet al servidor)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

# Enviar un cmdlet a un servidor, ejecutarlo y mostrar el resultado de la ejecucción en el cliente
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente y devuelve el resultado de la ejecución al cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$respuesta=[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes($respuesta)
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

## Cliente (manda un cmdlet al servidor y muestra la respuesta que manda el servidor de lo que ha ejecutado)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Dispose()
```

# Repaso de PowerShell y red
* https://www.jesusninoc.com/02/13/iniciar-un-trabajo-en-segundo-plano-que-crea-un-formulario-desde-powershell-llamando-a-powershell-exe/
* https://www.jesusninoc.com/02/16/iniciar-varios-trabajos-en-segundo-plano-start-job-de-powershell-usando-una-variable-como-argumento-argumentlist/
* https://www.jesusninoc.com/12/23/crear-un-trabajo-start-job-en-powershell-y-recibirlo-receive-job/
* https://www.jesusninoc.com/02/16/iniciar-varios-formularios-como-trabajos-en-segundo-plano-start-job-de-powershell-usando-una-variable-como-argumento-argumentlist/
* https://www.jesusninoc.com/02/17/enviar-un-mensaje-udp-a-varios-ordenador-mediante-broadcast-desde-powershell-en-macos-hacerlo-de-forma-simple/
* https://www.jesusninoc.com/07/09/9-gestion-de-la-red-en-powershell/#Capa_de_transporte

------------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Análisis de conexiones de red
https://www.jesusninoc.com/2017/05/01/analisis-de-conexiones-de-red/

## Equivalencias entre comandos de red de Windows y cmdlets de PowerShell
https://www.jesusninoc.com/2016/02/04/equivalencias-entre-comandos-de-red-de-windows-y-cmdlets-de-powershell/

## Cmdlets for TCP/IP Model Layers
https://www.jesusninoc.com/2015/11/13/cmdlets-for-tcpip-model-layers/

## Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

# Ejercicio: enviar un mensaje entre todos los usuarios de clase
* https://www.jesusninoc.com/01/30/enviar-un-mensaje-udp-a-un-ordenador-desde-powershell/
* https://www.jesusninoc.com/08/26/enviar-un-mensaje-udp-a-un-ordenador-desde-powershell-en-macos-hacerlo-de-forma-simple/

-----------
-----------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Continuar con ejercicio enviar mensajes entre cliente y servidor
- Enviar algo entre Windows y Linux
- Enviar algo a todos los equipos

------------------
------------------

# Instalación silenciosa
* https://www.jesusninoc.com/02/17/realizar-la-instalacion-silenciosa-de-teamviewer-y-capturar-el-id-de-teamviewer-necesario-para-conectarse-al-equipo-desde-otro-equipo/
# Saber dónde me tengo que conectar
* https://www.jesusninoc.com/02/17/pasos-para-crear-un-servidor-y-un-cliente-en-powershell/
# Puerto abierto
* https://www.jesusninoc.com/02/20/ejercicios-de-powershell-comprobar-si-un-puerto-esta-abierto-o-no/
# Enviar credenciales
* https://www.jesusninoc.com/02/19/ejercicios-de-powershell-enviar-credenciales-entre-un-cliente-y-un-servidor-por-udp-y-ejecutar-una-aplicacion-en-el-servidor-con-dichos-credenciales/

---------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Ejemplos de redes básicos

```PowerShell
1..254|%{$_}
1..254|%{"192.168.1."+$_}
1..254|%{$ip="192.168.1."+$_;$ip}
1..254|%{$ip="192.168.1."+$_;ping $ip}
1..254|%{$ip="192.168.1."+$_;ping $ip;arp -a $ip}
1..254|%{$ip="192.168.1."+$_;$ip;arp -a | Select-String $ip}
```
```PowerShell
Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress
```
```PowerShell
[String]$a=(Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress)
$a.Substring(3,3)
```

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

------------------

# Instalación silenciosa
* https://www.jesusninoc.com/02/17/realizar-la-instalacion-silenciosa-de-teamviewer-y-capturar-el-id-de-teamviewer-necesario-para-conectarse-al-equipo-desde-otro-equipo/
# Saber dónde me tengo que conectar
* https://www.jesusninoc.com/02/17/pasos-para-crear-un-servidor-y-un-cliente-en-powershell/
# Puerto abierto
* https://www.jesusninoc.com/02/20/ejercicios-de-powershell-comprobar-si-un-puerto-esta-abierto-o-no/
# Enviar credenciales
* https://www.jesusninoc.com/02/19/ejercicios-de-powershell-enviar-credenciales-entre-un-cliente-y-un-servidor-por-udp-y-ejecutar-una-aplicacion-en-el-servidor-con-dichos-credenciales/

---------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Ejemplos de redes básicos

```PowerShell
1..254|%{$_}
1..254|%{"192.168.1."+$_}
1..254|%{$ip="192.168.1."+$_;$ip}
1..254|%{$ip="192.168.1."+$_;ping $ip}
1..254|%{$ip="192.168.1."+$_;ping $ip;arp -a $ip}
1..254|%{$ip="192.168.1."+$_;$ip;arp -a | Select-String $ip}
```
```PowerShell
Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress
```
```PowerShell
[String]$a=(Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress)
$a.Substring(3,3)
```

## Ejercicio sobre la red

Analizar la siguiente información utilizando la red:
- Aplicaciones instaladas
- Ver si hay IP repetida
- Comprobar si hay fallo en red por culpa de IP repetida
- Comprobar que los equipos se han creado correctamente con el nombre de dominio correcto
- Ver rango de IP en Wifi
- Ver rango de IP en VDI
- ¿Qué usuario ha iniciado sesión?
- Realizar un inventario de la red (PDQ Inventory Tracks It All https://www.pdq.com/pdq-inventory/)

```PowerShell
Invoke-Command -ScriptBlock{([System.Security.Principal.WindowsIdentity]::GetCurrent()).name} -ComputerName 192.168.1.56 -Credential (Get-Credential)
```
```PowerShell
$p = Get-WmiObject win32_process -filter "name='explorer.exe'" -ComputerName 192.168.1.56 -Credential (Get-Credential)
$p.getowner().user
```

--------------------

# Configurar un túnel utilizando un servidor SSH
https://www.jesusninoc.com/2016/02/08/configurar-un-tunel-utilizando-un-servidor-ssh/

--------------------

# Post Exploitation
## Post Exploitation Command List Wiki
https://github.com/mubix/post-exploitation/wiki

## Linux Post Exploitation Command List
https://github.com/mubix/post-exploitation/wiki/Linux-Post-Exploitation-Command-List

## Post Exploitation without Automated Tools (pdf) - InfoSec Resources
This book acts as an introduction to those who know how to use Metasploit and do not know what happens behind the screens.
http://resources.infosecinstitute.com/wp-content/uploads/Post-Exploitation-without-Automated-Tools1.pdf

--------------------

# Ejecutar PHP
## Ejecutar código PHP desde PowerShell
https://www.jesusninoc.com/2017/03/01/ejecutar-codigo-php-desde-powershell/
## Ejecutar un cmdlet de PowerShell desde PHP
https://www.jesusninoc.com/2018/01/06/ejecutar-un-cmdlet-de-powershell-desde-php/
## Ejecutar en PHP un cmdlet de PowerShell en Base64
https://www.jesusninoc.com/2018/02/21/ejecutar-en-php-un-cmdlet-de-powershell-en-base64/

--------
--------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Asuntos pendientes
- Enviar credenciales
  - https://www.jesusninoc.com/02/19/ejercicios-de-powershell-enviar-credenciales-entre-un-cliente-y-un-servidor-por-udp-y-ejecutar-una-aplicacion-en-el-servidor-con-dichos-credenciales/
- Resolver ejercicio servidor-cliente, realizar una petición desde el cliente y que el servidor devuelva una página web para cada usuario cliente
  - Enviar un mensaje UDP entre dos equipos desde PowerShell https://www.jesusninoc.com/01/30/enviar-un-mensaje-udp-entre-dos-equipos-desde-powershell/
  - Realizar una comunicación entre dos ordenadores por UDP desde PowerShell https://www.jesusninoc.com/01/30/realizar-una-comunicacion-entre-dos-ordenadores-por-udp-desde-powershell/
  - https://www.jesusninoc.com/02/03/enviar-el-nombre-un-usuario-al-servidor-por-udp/
  - https://www.jesusninoc.com/02/03/enviar-el-nombre-un-usuario-al-servidor-por-udp-y-que-el-servidor-abra-una-pagina-web-con-el-nombre-recibido/
  - https://www.jesusninoc.com/02/03/enviar-un-mensaje-a-un-servidor-con-udp-y-que-el-servidor-responda-con-hola-cliente-independientemente-del-nombre-del-usuario/
  - https://www.jesusninoc.com/02/03/enviar-un-nombre-usuario-a-un-servidor-con-udp-y-si-es-correcto-el-servidor-responde-al-cliente-con-el-contenido-de-una-pagina-web-que-el-cliente-abre-con-google-chrome/
- Tarea programada que escucha
  - https://www.jesusninoc.com/03/21/crear-una-tarea-programada-en-la-que-un-servidor-escucha-los-mensajes-que-se-convierten-en-audio-y-que-son-mandados-por-parte-de-los-cliente-con-powershell-la-comunicacion-entre-el-servidor-y-el-clie/
- Ejemplos de preguntas https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-13.md
- Ejemplos de situaciones https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-12.md

--------------------

# Acceso remoto

Utilities like Telnet and remote control programs like Symantec's PC Anywhere let you execute programs on remote systems, but they can be a pain to set up and require that you install client software on the remote systems that you wish to access. PsExec is a light-weight telnet-replacement that lets you execute processes on other systems, complete with full interactivity for console applications, without having to manually install client software. PsExec's most powerful uses include launching interactive command-prompts on remote systems and remote-enabling tools like IpConfig that otherwise do not have the ability to show information about remote systems.

https://docs.microsoft.com/en-us/sysinternals/downloads/psexec

## Ejemplo psexec
```PowerShell
psexec -u jesusninoc\administrador \\2017lti1-19 -i -d cmd /c notepad
psexec -u jesusninoc\administrador \\192.168.104.122 -i -d cmd /c powershell -encodedcommand RwBlAHQALQBEAGEAdABlAA=="
psExec.exe -i \\192.168.1.56 powershell f:\script.ps1 #script.ps1 tiene que existir en el equipo remoto
```

## Powershell + psExec
http://bertdotself.com/powershell-psexec/

## Acceso remoto desde Powershell
```PowerShell
Invoke-Command -Credential administrador -ComputerName 192.168.1.56 -ScriptBlock{hostname} 
```

## Netcat Cheat Sheet
https://www.sans.org/security-resources/sec560/netcat_cheat_sheet_v1.pdf

## Starts an interactive session with a remote computer (PowerShell)
```PowerShell
Enter-PSSession -ComputerName 2017lti1-19
```

## Crear una tarea programada en un equipo remoto
```PowerShell
1..254 | %{Invoke-Command -ComputerName ('192.168.1.'+$_) {Register-ScheduledTask Task01 -Action (New-ScheduledTaskAction -Execute "Cmd") -Principal (New-ScheduledTaskPrincipal -GroupId "BUILTIN\administradores" -RunLevel Highest) -Settings (New-ScheduledTaskSettingsSet -RestartCount 5 -RestartInterval 60)}}
```

## Copssh - OpenSSH for Windows
* https://itefix.net/copssh

--------------------

## Introducción a la automatización en PowerShell
https://www.jesusninoc.com/2017/03/06/introduccion-a-la-automatizacion-en-powershell/

## Automation
https://www.jesusninoc.com/automation/

## Mover el ratón a varias posiciones
https://www.jesusninoc.com/2015/01/18/mover-el-raton-a-varias-posiciones/

## Mover Notepad de una posición de la pantalla a otra y escribir un texto dentro del proceso
https://www.jesusninoc.com/2016/03/23/mover-notepad-de-una-posicion-de-la-pantalla-a-otra-y-escribir-un-texto-dentro-del-proceso/

## Mover un proceso en diagonal de una posición de la pantalla a otra y que siempre permanezca en primer plano
https://www.jesusninoc.com/2016/04/11/mover-un-proceso-en-diagonal-de-una-posicion-de-la-pantalla-a-otra-y-que-siempre-permanezca-en-primer-plano/

## Mover un proceso en horizontal de una posición de la pantalla a otra y que siempre permanezca en primer plano
https://www.jesusninoc.com/2016/02/28/mover-un-proceso-en-horizontal-de-una-posicion-de-la-pantalla-a-otra-y-que-siempre-permanezca-en-primer-plano/

## Activar y mover un proceso de una posición de la pantalla a otra
https://www.jesusninoc.com/2016/02/20/activar-y-mover-un-proceso-de-una-posicion-de-la-pantalla-a-otra/

## Mover un proceso de una posición de la pantalla a otra
https://www.jesusninoc.com/2016/02/03/mover-un-proceso-de-una-posicion-de-la-pantalla-a-otra/

--------------------

# Servidor de correo

## SMTP
https://www.jesusninoc.com/2015/01/12/instalar-hmailserver-imap-smtp-y-pop3/

--------------------

# Ideas sobre los comportamientos de los troyanos
## Grabar audio
* http://www.jesusninoc.com/2015/06/27/grabar-audio-desde-la-linea-de-comandos/

## Keylogger
* https://www.jesusninoc.com/03/11/keylogger-sencillo-con-powershell/

# Enviar un cmdlet a un servidor y ejecutarlo
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()
```

## Cliente (manda un cmdlet al servidor)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

# Enviar un cmdlet a un servidor, ejecutarlo y mostrar el resultado de la ejecución en el cliente
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente y devuelve el resultado de la ejecución al cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$respuesta=[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes($respuesta)
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

## Cliente (manda un cmdlet al servidor y muestra la respuesta que manda el servidor de lo que ha ejecutado)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Dispose()
```

--------------

# Simular ransomware
## Algoritmo de cifrado sencillo
https://www.jesusninoc.com/2016/03/06/algoritmo-de-cifrado-sencillo-2/
## Algoritmo de descifrado sencillo
https://www.jesusninoc.com/2016/03/07/algoritmo-de-descifrado-sencillo-2/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto
https://www.jesusninoc.com/2017/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto (enviar la clave utilizada en el algoritmo mediante una petición web a un servidor)
https://www.jesusninoc.com/2017/05/16/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto-enviar-la-clave-utilizada-en-el-algoritmo-mediante-una-peticion-web-a-un-servidor/
## Descifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto
https://www.jesusninoc.com/2017/05/18/descifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
## Cifrar utilizando una clave secreta
https://www.jesusninoc.com/2015/08/18/cifrar-utilizando-una-clave-secreta/
## Descifrar utilizando una clave secreta
https://www.jesusninoc.com/2015/08/20/descifrar-utilizando-una-clave-secreta/
## Aproximación al cifrado y descifrado en PowerShell
https://www.jesusninoc.com/2017/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

# Simular ransomware y subir por SSH
## Subir un fichero por SSH a un servidor Linux desde PowerShell en Windows
https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto y subirlo por SSH a un servidor Linux
https://www.jesusninoc.com/2017/11/13/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto-y-subirlo-por-ssh-a-un-servidor-linux/
## Utilizar tail -f en Windows Server 2003 con Copssh
https://www.jesusninoc.com/2009/05/21/utilizar-tail-f-en-windows-server-2003-con-copssh/

# SSH
## Configurar un túnel utilizando un servidor SSH
https://www.jesusninoc.com/2016/02/08/configurar-un-tunel-utilizando-un-servidor-ssh/
## Configurar Firefox para utilizar un túnel SSH como un proxy SOCKS
https://www.jesusninoc.com/2016/02/09/configurar-firefox-para-utilizar-un-tunel-ssh-como-un-proxy-socks/
## Realizar conexión con WinSCP utilizando un túnel SSH
https://www.jesusninoc.com/2016/02/12/realizar-conexion-con-winscp-utilizando-un-tunel-ssh/
## Conexión entre Bash Bunny y el equipo con PuTTY a través de la conexión de red IBM USB Remote NDIS Network Device
https://www.jesusninoc.com/2017/04/14/conexion-entre-bash-bunny-y-el-equipo-con-putty-a-traves-de-la-conexion-de-red-ibm-usb-remote-ndis-network-device/

---------------
---------------

# Administración de software de base

 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Sort IPv4 Addresses Correctly
http://community.idera.com/powershell/powertips/b/tips/posts/sort-ipv4-addresses-correctly

# Recorrer rango direcciones IP
* https://www.jesusninoc.com/2017/07/14/recorrer-un-rango-de-direcciones-ip/
* https://www.jesusninoc.com/2017/07/06/recorrer-direcciones-ip/
* https://github.com/jesusninoc/PowerShell/blob/master/Red/EjemplosRed.ps1

# Puertos abiertos
## Si está abierto parece que no hay resultado
```PowerShell
$tcpobject = New-Object System.Net.Sockets.TcpClient 
$connect = $tcpobject.BeginConnect("127.0.0.1",25,$null,$null)
    
# wait for the connection no longer than $timeoutMilliseconds 
$wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false)
$tcpobject.EndConnect($connect) 
```
## Si no está abierto hay resultado
```PowerShell
$tcpobject = New-Object System.Net.Sockets.TcpClient 
$connect = $tcpobject.BeginConnect("127.0.0.1",215,$null,$null)
    
# wait for the connection no longer than $timeoutMilliseconds 
$wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false)
$tcpobject.EndConnect($connect) 
```
## Scanning Ports
* https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/scanning-ports
```PowerShell
function Get-PortInfo
{
    param
    (
        [Parameter(Mandatory)]
        [Int]
        $Port,
    
        [Parameter(Mandatory)]
        [Int]
        $TimeoutMilliseconds,
        
        [String]
        $ComputerName = $env:COMPUTERNAME
    )
  
    # try and establish a connection to port async
    $tcpobject = New-Object System.Net.Sockets.TcpClient 
    $connect = $tcpobject.BeginConnect($computername,$port,$null,$null)
    
    # wait for the connection no longer than $timeoutMilliseconds 
    $wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false) 
    
    # return rich information
    $result = @{
        ComputerName = $ComputerName
    }
    
    if(!$wait) { 
        # timeout
        $tcpobject.Close() 
        $result.Online = $false
        $result.Error = 'Timeout'
    } else { 
        try { 
            # try and complete the connection
            $null = $tcpobject.EndConnect($connect)
            $result.Online = $true
        }
        catch { 
            $result.Online = $false
        } 
        $tcpobject.Close() 
    } 
    $tcpobject.Dispose()
    
    [PSCustomObject]$result
} 
```
--------------

# Ejercicios realizados
- https://www.jesusninoc.com/02/04/ejercicios-de-powershell-sacar-los-nombre-de-los-procesos-de-cada-conexion-de-red-tcp/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-sacar-el-nombre-del-proceso-que-abre-cada-conexion-de-red-tcp-junto-con-la-direccion-ip-remota/
- https://www.jesusninoc.com/02/05/sacar-el-nombre-del-proceso-que-abre-cada-conexion-de-red-udp-junto-con-la-direccion-ip-local/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-ver-los-puertos-locales-que-estan-abiertos-en-nuestro-equipo-tcp-y-udp/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-comprobar-los-puertos-tcp-abiertos-de-un-rango-a-otro-mediante-un-try-y-un-catch-e-indicar-si-esta-abierto-o-no-el-puerto-si-hace-lo-que-queremos/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-listar-las-direcciones-ip-remotas-que-utilizan-el-protocolo-tcp-e-indicar-la-resolucion-dns/

# Ejercicios propuestos
- Analizar la red del Centro, ¿qué detectas?, ¿DNS?
- Se puede comunicar dentro del la red por UDP, enviar el movimiento del ratón entre dos equipos.

------------------
------------------

# Tunel SSH
# Acceso remoto PowerShell
- Asegúrese de que el equipo remoto y el equipo local estén en la misma red y que la conexión entre ellos no esté bloqueada por ningún firewall o enrutador.
# Almacenar credenciales
* https://www.jesusninoc.com/03/01/ejercicios-de-powershell-almacenar-varios-credenciales-en-un-fichero-xml-y-utilizarlos-para-arrancar-un-proceso/

--------------
--------------

# Simular ransomware
## Algoritmo de cifrado sencillo
https://www.jesusninoc.com/2016/03/06/algoritmo-de-cifrado-sencillo-2/
## Algoritmo de descifrado sencillo
https://www.jesusninoc.com/2016/03/07/algoritmo-de-descifrado-sencillo-2/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto
https://www.jesusninoc.com/2017/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto (enviar la clave utilizada en el algoritmo mediante una petición web a un servidor)
https://www.jesusninoc.com/2017/05/16/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto-enviar-la-clave-utilizada-en-el-algoritmo-mediante-una-peticion-web-a-un-servidor/
## Descifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto
https://www.jesusninoc.com/2017/05/18/descifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
## Cifrar utilizando una clave secreta
https://www.jesusninoc.com/2015/08/18/cifrar-utilizando-una-clave-secreta/
## Descifrar utilizando una clave secreta
https://www.jesusninoc.com/2015/08/20/descifrar-utilizando-una-clave-secreta/
## Aproximación al cifrado y descifrado en PowerShell
https://www.jesusninoc.com/2017/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

# Simular ransomware y subir por SSH
## Subir un fichero por SSH a un servidor Linux desde PowerShell en Windows
https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto y subirlo por SSH a un servidor Linux
https://www.jesusninoc.com/2017/11/13/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto-y-subirlo-por-ssh-a-un-servidor-linux/
## Utilizar tail -f en Windows Server 2003 con Copssh
https://www.jesusninoc.com/2009/05/21/utilizar-tail-f-en-windows-server-2003-con-copssh/

# Administración de software de base

 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Repaso de ficheros de configuración en Linux

## Network
http://www.yolinux.com/TUTORIALS/LinuxTutorialNetworking.html

## Netplan configuration examples
https://netplan.io/examples

### To instead set a static IP address, use the addresses key, which takes a list of (IPv4 or IPv6), addresses along with the subnet prefix length (e.g. /24). Gateway and DNS information can be provided as well:

```Bash
network:
  version: 2
  renderer: networkd
  ethernets:
    enp3s0:
      addresses:
        - 10.10.10.2/24
      gateway4: 10.10.10.1
      nameservers:
          search: [mydomain, otherdomain]
          addresses: [10.10.10.1, 1.1.1.1]
```

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Firewall
## Enable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/16/enable-the-microsoft-windows-firewall/
## Disable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/15/disable-the-microsoft-windows-firewall/
## Ejemplos de reglas de firewall
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-deshabilitadas/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-en-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-no-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-de-salida-del-firewall-desde-powershell-de-windows-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-de-entrada-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
## Log del Firewall
```Cmd
%systemroot%\system32\LogFiles\Firewall\pfirewall.log
```

--------------
--------------

# Ejercicios de red
## Crear una función en la que le pasas una conexión de red y te dice qué proceso ejecuta (le puedes pasar una IP o un puerto)
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-crear-una-funcion-en-la-que-se-pasa-una-conexion-de-red-y-te-dice-proceso-ejecuta-se-puede-pasar-una-ip-o-un-puerto/
## Crear una función que agrupa los nombre obtenidos mediante una resolución DNS (sin mostrar errores)
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-crear-una-funcion-que-agrupa-los-nombre-obtenidos-mediante-una-resolucion-dns-sin-mostrar-errores/
## Mostrar los hilos que se están ejecutando y deducir si se pueden relacionar con sockets abiertos
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-mostrar-los-hilos-que-se-estan-ejecutando-y-deducir-si-se-pueden-relacionar-con-sockets-abiertos-tcp-o-udp/

# Ejercicios avanzados de red
## Simular el uso de certificado
* https://www.jesusninoc.com/01/23/enviar-un-mensajes-cifrado-con-cryptographic-message-syntax-cms-entre-un-cliente-y-un-servidor-mediante-udp-desde-powershell/
## Uso de certificado en conexión cliente servidor
* https://www.jesusninoc.com/03/11/cifrar-el-trafico-entre-un-cliente-y-un-servidor-mediante-el-protocolo-tcp-ip-con-un-certificado-x509-autofirmado-en-powershell/

--------------

# Scripting

## Repaso básico de Linux para la parte de scripting
* http://www.freeos.com/guides/lsst/ch02.html
* http://www.freeos.com/guides/lsst/ch02sec20.html

## Repaso básico de Windows para la parte de scripting
### Snippets in Windows PowerShell
https://www.jesusninoc.com/2014/03/19/snippets-in-windows-powershell/

------------------
------------------

# Administración de recursos compartidos:
- Instalación y configuración de servicios
- Administración del acceso a recursos. SMB/CIFS. SAMBA. NFS.
- Grupos de trabajo.
- Permisos de red. Permisos locales. Herencia. Permisos efectivos.

--------------

# Repaso discos

## LVM (Logical Volume Manager)

Un LVM se descompone en tres partes:
- Volúmenes físicos (PV): Son las particiones del disco duro con sistema de archivos LVM. (raid's)
- Grupos de volúmenes (VG): es la parte superior de la LVM. Es la "caja" en la que tenemos nuestros volúmenes lógicos (LV) y nuestros volúmenes físicos (PV). Se puede ver como una unidad administrativa en la que se engloban nuestros recursos. Hay que hacer notar que mientras un PV no se añada al VG, no podemos comenzar a usarlo.
- Volúmenes lógicos (LV): es el equivalente a una partición en un sistema tradicional. El LV es visible como un dispositivo estándar de bloques, por lo que puede contener un sistema de archivos (por ejemplo /home)

```Dibujo
               sda1        sdb    (PV:s, particiones o discos completos)
                     /
                    /
               linuxvg            (VG)
             /    |    
           /      |      
       ubuntu   arch     home     (LV:s)
         |        |       |
       ext4      ext4    xfs      (sistemas de archivos)
```

## Operaciones sobre discos en Windows:
- Crear particiones
- Borrar particiones
- Recuperar particiones eliminadas
- Cifrar
- Comprimir
- Convertir entre sistemas de archivos

## Discos dinámicos
http://windows.microsoft.com/es-es/windows-vista/what-are-basic-and-dynamic-disks

--------------

# Arranque
- BIOS
- POST
- Arranque (dual, BCD, BCDEdit, etc.)
- Arranque de procesos

## Arranque en Linux
### Proceso de arranque en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Arranque en Windows
### Proteger el proceso de arranque de Windows 10
https://docs.microsoft.com/es-es/windows/security/hardware-protection/secure-the-windows-10-boot-process
### Procesos de credenciales de autenticación de Windows
https://docs.microsoft.com/es-es/windows-server/security/windows-authentication/credentials-processes-in-windows-authentication

--------------

# Permisos en PowerShell

## 4. Gestión de archivos en PowerShell para administradores de sistemas
https://www.jesusninoc.com/2016/11/10/4-gestion-de-archivos-en-powershell-para-administradores-de-sistemas/

## Obtener los descriptores de seguridad de todos los ficheros de una unidad
https://www.jesusninoc.com/2016/09/10/obtener-los-descriptores-de-seguridad-de-todos-los-ficheros-de-una-unidad/

## Enumeración FileSystemRights: Define los derechos de acceso que se utilizará al crear reglas de acceso y auditoría
https://msdn.microsoft.com/es-es/library/system.security.accesscontrol.filesystemrights(v=vs.110).aspx

## Clonar permisos NTFS
https://www.jesusninoc.com/2015/01/23/clonar-permisos-ntfs/

## Eliminar permisos explícitos
https://www.jesusninoc.com/2016/03/30/eliminar-permisos-explicitos/

## Añadir permiso NTFS a una carpeta
https://www.jesusninoc.com/2015/08/19/anadir-permiso-ntfs-a-una-carpeta/

## Weekend Scripter: Use PowerShell to Get, Add, and Remove NTFS Permissions
https://blogs.technet.microsoft.com/heyscriptingguy/2014/11/22/weekend-scripter-use-powershell-to-get-add-and-remove-ntfs-permissions/

## Ejemplo de asignación de permisos
```PowerShell
New-Item -type directory -path C:\MyFolder
$Acl = Get-Acl "C:\MyFolder"
$Ar = New-Object  system.security.accesscontrol.filesystemaccessrule("username","FullControl","Allow")
$Acl.SetAccessRule($Ar)
Set-Acl "C:\MyFolder" $Acl
```

--------------

# Permisos en Linux
Why does the default umask value contains 4 digits?
The first digit in 0022 defines the special permission value. In case you want to set any special permission to every file/directory to be created then you can define the value accordingly.

For understanding all the special permission and their value follow the below link
- Understanding Special Permission SGID in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-sgid.html
- Understanding Special Permission SUID in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-suid.html
- Understanding Special Permission Sticky Bit in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-sticky.html

## Comando para ver permisos de un fichero
```Bash
stat -f "%Sp -> owner=%SHp group=%SMp other=%SLp" fichero.txt  
```

## Ejemplo sobre asignación de permisos al crear carpetas
### Creates a new directory called mydir whose parent is the current directory.
```Bash
mkdir examples
mkdir mydir
```
Create the mydir directory, and set its permissions such that all users may read, write, and execute the contents.
```Bash
mkdir -m a=rwx mydir
```
Creates the directory /home/chope/a/b/c. If the parent directory /home/chope/a/b does not already exist, mkdir will create that directory first.
```Bash
mkdir -p /home/chope/a/b/c
```

## Permisos avanzados en C
http://www.jesusninoc.com/2015/01/19/programacion-de-permisos/

--------------

# Integridad
## PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosProcesosAvanzado.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Ficheros/EjemploIntegridad.ps1
## Linux
* https://www.jesusninoc.com/2016/01/02/for-loop-examples/
* https://www.jesusninoc.com/2015/07/14/sentencia-condicional-if-else-2/
* https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

--------------

# Copias de seguridad

## En Windows
### 10. Gestión del rendimiento en PowerShell para administradores de sistemas
https://www.jesusninoc.com/2016/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/
### Copias de seguridad (explicación básica del concepto de copia de seguridad incremental y diferencial)
https://github.com/jesusninoc/PowerShell/tree/master/CopiasSeguridad

## En Linux
https://www.ochobitshacenunbyte.com/2017/07/10/copias-de-seguridad-con-dump-y-restore-en-linux/

--------------

# USB

## Memorias USB: riesgos, protección y acceso a los datos
https://www.securityartwork.es/2018/01/24/memoricas-usb-riesgos-proteccion-acceso-los-datos/

## Detectar si hay un dispositivo USB conectado y copiar el contenido en una carpeta temporal
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Detectar%20si%20hay%20un%20dispositivo%20USB%20conectado%20y%20copiar%20el%20contenido%20en%20una%20carpeta%20temporal.ps1


--------------

# ISO, WIM

## Crear ISO
https://gallery.technet.microsoft.com/scriptcenter/New-ISOFile-function-a8deeffd

## Crear una imagen WIM de un disco duro y expandirla después en un disco duro
https://www.jesusninoc.com/2015/08/02/crear-una-imagen-wim-de-un-disco-duro-y-expandirla-despues-en-un-disco-duro/

## Crear un WIM de un USB (copia de seguridad) copiarlo a una carpeta compartida (controlar los permisos de red y NTFS), tener en cuenta:
- Crear WIM
- Ver ficheros USB
- Crear carpeta compartida
- Copia de seguridad
- Realizar firma del fichero obtenido

--------------

# Posibles preguntas para el examen

- Pedir un proceso
  - Comprobar la ruta y el hash (hay un listado de hash para los programas que hay en el sistema)
  - Comprobar si hay algún drivers cambiado (hay un listado de hash para los drivers)
- Instalar programas en Ubuntu leyendo desde un fichero
- Ver versión de programas instalados, los antiguos hay que actualizarlos
- Actualización
- Control de acceso a programas
- Controladores, drivers
- Instalar y actualizar
- Qué proceso realizas para crear un usuario
- Crear y añadir usuarios
- El usuario con más privilegios
- Habilitar usuarios
- Seguridad en contraseñas
- Permisos, herencia, permisos efectivos
- Cambiar dueño usuario
- Carpetas compartidas

------------------
------------------

# Examen liberatorio

## Pregunta 1. Crear usuarios leyendo de un fichero el nombre de los usuarios que se van a crear y los credenciales que se van a utilizar
* https://www.jesusninoc.com/03/13/ejercicios-de-powershell-restaurar-usuarios-que-se-han-creado-anteriormente-se-almacenan-en-un-fichero-y-se-vuelven-a-crear/
* https://www.jesusninoc.com/04/08/almacenar-y-utilizar-credenciales-mediante-json/
* https://www.jesusninoc.com/12/08/utilizar-credenciales-en-formato-json-que-han-sido-exportados-con-get-credential-y-arrancar-el-programa-notepad-en-powershell/
* https://www.jesusninoc.com/12/07/exportar-credenciales-con-get-credential-en-un-fichero-json-con-powershell/
* https://www.jesusninoc.com/03/01/ejercicios-de-powershell-almacenar-varios-credenciales-en-un-fichero-xml-y-utilizarlos-para-arrancar-un-proceso/
* https://www.jesusninoc.com/06/24/verificar-si-existe-un-usuario-en-windows-10-con-powershell/
* https://www.jesusninoc.com/02/27/validar-usuarios-en-el-directorio-activo-pidiendo-al-usuario-el-nombre-y-la-contrasena/

## Pregunta 2. Realizar una copia de seguridad comprimida en una carpeta compartida con las dll que utilza un proceso
* https://www.jesusninoc.com/03/05/create-a-share-on-linux-and-access-it-from-windows/
* https://www.jesusninoc.com/04/30/ejercicios-de-powershell-crear-una-carpeta-compartida-mapearla-y-utilizarla/
* https://www.jesusninoc.com/06/14/conectarse-a-una-carpeta-compartida-con-powershell/
* https://www.jesusninoc.com/05/27/ejercicios-de-powershell-analizar-ficheros-dll-en-todos-los-equipos-de-la-red-comprobar-que-ha-cambiado-una-integridad-y-copiar-el-fichero-que-ha-cambiado/

--------------
--------------

# Corrección del examen liberatorio
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-03-11.md#pregunta-1-crear-usuarios-leyendo-de-un-fichero-el-nombre-de-los-usuarios-que-se-van-a-crear-y-los-credenciales-que-se-van-a-utilizar

# Ejercicios sobre corrección del examen liberatorio
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-una-funcion-que-almacene-los-usuarios-que-estan-en-el-equipo-y-los-guarde-en-formato-qr/
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-un-qr-con-los-nombres-de-los-usuarios-que-hay-en-el-sistema-y-crear-los-usuarios-nuevamente-leyendo-el-codigo-qr-generado-anteriormente/
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-usuarios-en-linux-leyendo-desde-un-codigo-qr-en-powershell-el-nombre-de-los-usuarios-se-obtiene-listando-usuarios-en-el-sistema-desde-powershell-y-convirtiendo-a-codig/

------------
------------

# Linux

## Repaso de usuarios
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#listar-informaci%C3%B3n-sobre-usuarios-y-grupos-en-bash-con-repaso-sobre-comandos
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-04.md#crear-usuarios-en-ubuntu-mediante-wsl
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-09.md#crear-usuarios-en-ubuntu

## Repaso scripting Linux
* https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjerciciosFicherosBuscar.sh
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-05-24-Enunciado.sh
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-22.md#repaso-para-realizar-scripts-en-linux
* https://blog.carreralinux.com.ar/2016/07/unir-y-ordenar-lineas-en-archivos-de-texto/
* https://likegeeks.com/es/comando-awk/

## Repaso enlaces duros y simbólicos
* https://geekland.eu/que-son-para-que-sirven-enlaces-duros-y-simbolicos/

## Más repaso scripts
* https://github.com/jesusninoc/Scripts

------------
------------

# Corrección del examen liberatorio
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-03-11.md#pregunta-2-realizar-una-copia-de-seguridad-comprimida-en-una-carpeta-compartida-con-las-dll-que-utilza-un-proceso

# Ejercicios sobre corrección del examen liberatorio
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-realizar-una-copia-de-seguridad-de-las-dll-que-utiliza-un-proceso-y-comprimir-la-copia-dentro-de-una-carpeta-compartida/

------------
------------

# Linux (vamos por la parte de valores $* en la presentación)

## Ejercios resueltos
* https://www.jesusninoc.com/03/18/ejercicios-wsl-crear-en-windows-con-powershell-y-wsl-los-mismos-usuarios-que-tenemos-en-linux/
* https://www.jesusninoc.com/03/18/ejercicios-de-wsl-realizar-una-suma-en-wsl-llamando-a-un-script-de-bash-donde-le-pasamos-dos-valores/
* https://www.jesusninoc.com/03/18/ejercicios-de-wsl-realizar-una-suma-en-wsl-llamando-a-un-script-donde-le-pasamos-dos-valores-desde-powershell/
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-crear-un-interfaz-simple-que-realice-la-operacion-de-suma-resta-y-multiplicacion/
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-crear-un-interfaz-simple-que-realice-la-operacion-de-suma-resta-y-multiplicacion-mediante-la-llamada-a-un-script-en-bash-utilizando-wsl/

## Más repaso scripts
* https://github.com/jesusninoc/Scripts

-----------
-----------

# Examen segunda evaluación

1. Leer un usuario desde un servidor web (HTML, XML, JSON) crearlo y meterlo en el grupo de administradores (no te olvides del password).
2. Detectar mediante una función que el usuario pertenece al grupo de administradores.
```PowerShell
Get-LocalGroupMember administradores
```
El siguiente enlace es una solución de monitorización algo compleja: registrar y mostrar un evento en PowerShell cuando se crea un usuario
https://www.jesusninoc.com/2018/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

3. Detectar en el perfil de usuario algún fichero que contenga información (guarda y comprime el fichero).
```PowerShell
Get-ChildItem C:\Users\juan\NTUSER.DAT
```
4. Intentar utilizar las credenciales de un usuario y verificar que funciona (guarda en un fichero la captura).
* https://www.jesusninoc.com/2016/08/16/almacenar-credenciales/
* https://www.jesusninoc.com/2016/09/20/almacenar-y-utilizar-credenciales/
* https://www.jesusninoc.com/2017/04/08/almacenar-y-utilizar-credenciales-mediante-json/
5. Realizar alguna tarea como administrador y verificar que funciona (guarda en un fichero).
* https://www.jesusninoc.com/2016/08/17/utilizar-credenciales-almacenados/
6. Dejar una puerta trasera para poder conectarse desde SSH en Linux.
* https://itefix.net/copssh

--------------------------

# Simulacro de examen segunda evaluación

# Parte 1
## Crear un usuario utilizando el protocolo UDP
### Server
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Close()
```
### Client
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('New-LocalUser usuario2 -Password (ConvertTo-SecureString "11234aaa@@€dsf" -asplaintext -force)')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

## Ayuda
### Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
* https://www.jesusninoc.com/11/23/crear-un-usuario-local-con-contrasena-en-windows-10-con-powershell-5-1/
### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
* https://www.jesusninoc.com/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
### Lanzar una excepción en la función si algo va mal
```PowerShell
function Copy-Log
{
  "Doing prerequisites"
  "Testing whether target path exists"
  "If target path does not exist, bail out"
  throw "Target path does not exist"
  "Copy log files to target path"
  "Delete log files in original location"
}
```
# Parte 2
## Detectar que se ha creado un usuario sin darnos cuenta
- Por red
- Por IP
```PowerShell
Get-NetUDPEndpoint | %{
    if(($_ -match "192.168.104.39") -or ($_ -match "10.0.2.13") -or ($_ -match "127.0.0.1"))
    {
    }
    else
    {
        $_
    }
}
```
- Registro de la acción de crear usuarios
```PowerShell
#Ejecutar PowerShell como administrador
Register-WmiEvent -Query "select * from __InstanceCreationEvent where TargetInstance isa 'Win32_NtLogEvent' and TargetInstance.logfile = 'Security' and (TargetInstance.EventCode = '4720')" -Action {Write-Host $event.SourceEventArgs.NewEvent.TargetInstance.insertionstrings}
```
- Listar la fecha de creación de usuarios
```PowerShell
$checktime = (get-date).adddays(-1000)
get-aduser -searchbase "CN=Users ,DC=retared,DC=local" -Properties whencreated -filter {whencreated -ge $checktime}
```
- Contar número de usuarios
```PowerShell
(Get-LocalUser).count
```

------------
------------

# Repaso examen 2ª evaluación

## Posibles preguntas

- Crear un sistema para realizar instalaciones de programas en Linux desde PowerShell
  - El sistema tiene que comprobar si hay que realizar instalaciones al arrancar el sistema operativo

- Crear un sistema que da de alta usuarios en el sistema operativo
  - El sistema tiene que ser una tarea programada

- Ejemplos de preguntas rápidas
  - ¿Cómo bloqueas un programa en Windows para que no pueda ejecutarlo un usuario?
  - ¿Qué contiene el fichero ntuser.dat?

- Script OWASP
  - WordPress username enumeration with PowerShell https://jesusninoc.com/wp-json/wp/v2/users/
  - WordPress https://www.jesusninoc.com/wordpress/

------------
------------

# Examen segunda evaluación

## Tener en cuenta
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-26.md

## Configurar al usuario todo lo que necesita leyendo de un fichero (programas, carpetas, etc.), realizar el siguiente proceso:
- Copiar la información y configuración que hay sobre un usuario
	- Programas
	- DLL
- Crear para cada nuevo usuario que entra en el sistema (teniendo en cuenta el punto anterior):
	- Usuario
	- Grupo
	- Carpeta compartida
	
## Teniendo en cuenta la pregunta anterior, realizar un script que permita enviar información desde los clientes (no depender del servidor)
  
### Ayuda
- Guardar información sobre usuarios para hacer una recuperación
- Guardar información sobre programas y paquetes
- Configuración IP, DNS
- Tener en cuenta funciones complejas
- Se puede mejorar el script con Linux
- Tener en cuenta el AD
- Filtro LDAP
- Comunicar por UDP
- Información sobre programas
	- C:\Program Files
	- C:\Users\administrador.RETARED\AppData\Local
	- C:\Windows\prefetch
- Carpetas compartidas para guardar información de una copia de seguridad
 	- https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-16.md
 	- https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-11.md
- UDP
	- https://www.jesusninoc.com/11/10/realizar-conexiones-tcp-udp-con-powershell/

-----------

# Examen segunda evaluación

## Realizar un programa que permita utilizar el siguiente fichero
```
juan|ventas,compras|office|\\servidor1\ventas\juan|Total
```

## Ideas
### Perfiles móviles
http://www.developandsys.es/perfiles-moviles-server/
### Mapeo de unidades red Windows Server
http://www.developandsys.es/mapeo-unidades-red-windows-server/

-----------

# Resolver la siguiente situación mediante scripts

## Los usuarios de una red funcionan con un sistema muy básico, tienen usuarios creados en cada equipo y comparten archivos mediante carpetas compartidas. Tu tarea es extraer los usuarios de los equipos y centralizar todo en un solo servidor con un Directorio Activo.

### Ayuda
- Crear una carpeta compartida, mapearla y utilizarla
```PowerShell
New-SmbShare -Name asir -Path c:/asir1 –FullAccess juan -ReadAccess todos
New-PSDrive -Name “asir” -PSProvider FileSystem -Root \\localhost\asir
cd asir:/ 
```

### Soluciones
* https://github.com/AlexRivero14/COVID-19
* https://github.com/PabloQueipo/ISO/blob/master/Pr%C3%A1ctica%2026%20MARZO.md
* https://github.com/DanielCebri/ISO-/blob/master/31032020.md

------------------
------------------

# Examen liberatorio

- Carpeta caliente que recibe un fichero comprimido y crea los usuarios, grupos y OU que están en dicho fichero.

# Repaso del mes
## Script para realizar tareas básicas y avanzadas
https://github.com/jesusninoc/Scripts/blob/master/Realizar%20tareas%20b%C3%A1sicas%20y%20avanzadas.sh
## Cmdlets relacionados con tareas básicas y de administración en el sistema operativo Windows
https://www.jesusninoc.com/2015/04/28/cmdlets-relacionados-con-tareas-basicas-y-de-administracion-en-el-sistema-operativo-windows/

# Repaso del BOE
- Administración de software de base
- Administración de recursos compartidos

# Repaso de las tareas de administración III
### Gestión del almacenamiento
* https://www.jesusninoc.com/2017/07/03/3-gestion-del-hardware-en-powershell/
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
### Gestión de la red
* https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
### Copias de seguridad
* https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

---------------------

# Realizar un script que sea una tarea programada que almacene información sobre la situación actual del sistema operativo (Windows y Linux), teniendo en cuenta:
- Programas instalados
- Actualizaciones
- Usuarios y grupos

## Además de almacenar información, el script tiene que permitir hacer una recuperación con la información almacenada, por ejemplo restaurar usuarios leyendo de un fichero los usuarios y grupos a los que pertenecen.

## Ideas que se pueden aplicar al script:
- Almacenar los .exe de los programas
- Almacenar los ficheros .dll de los programas
- Almacenar los instaladores .msi de los programas instalados
- Realizar un proceso de firma (hash) a los programas instalados
- Utilizar expresiones regulares

----------------------

# Hyper-V: Backup VMs to a shared folder with Windows Server Backup and a Scheduled Task-
https://sid-500.com/2018/03/11/hyper-v-backup-vms-to-a-shared-folder-with-windows-server-backup-and-a-scheduled-task/
```PowerShell
$Action=New-ScheduledTaskAction -Execute 'C:\Temp\backupVM.bat'
$Trigger=New-ScheduledTaskTrigger -Weekly -DaysOfWeek Saturday -At 11am
$Set=New-ScheduledTaskSettingsSet
$Principal=New-ScheduledTaskPrincipal -UserId 'sid-500\administrator' -LogonType S4U
$Task=New-ScheduledTask -Action $Action -Trigger $Trigger -Settings $Set -Principal $Principal
Register-ScheduledTask -TaskName "Backup VM" -InputObject $Task -Force
```

# Linux – Tigger commands and tasks during file system changes
https://www.capatek-tutorials.com/linux/linux-tigger-commands-tasks-file-system-changes/

# Scheduled Task with Daily Trigger and Repetition Interval
https://stackoverflow.com/questions/20108886/scheduled-task-with-daily-trigger-and-repetition-interval
```PowerShell
$trigger = New-ScheduledTaskTrigger `
    -Once `
    -At (Get-Date) `
    -RepetitionInterval (New-TimeSpan -Minutes 5) `
    -RepetitionDuration ([System.TimeSpan]::MaxValue)
```

---------------------

# ¿Cómo detectar que ha aparecido un equipo en la red WIFI?
- Mostrar un mensaje en PowerShell cuando aparece un equipo WIFI en la red
```PowerShell
```

---------------------

# ¿Cómo detectar que se está ejecutando un proceso?
- Conocer procesos
- Firmas de procesos
- Mostrar un mensaje en PowerShell cuando se ejecuta y se para un programa (por ejemplo se ejecuta powershell)
```PowerShell
Start-Process powershell.exe "-command ps"
```
- Localizar el proceso que está relacionado con el puerto de carpetas compartidas
```PowerShell
netstat -ano
```
- Contar procesos
- Contar hilos
- Analizar la red
- Auditar
- Registro
- Registro y logs de carpetas compartida
- Explorer
- Keylogger
- Volcado de procesos
- Capturar la pantalla
- Get-Counter

-------------------

# PowerShell
## Detectar si hay un dispositivo USB conectado y copiar el contenido en una carpeta temporal
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Detectar%20si%20hay%20un%20dispositivo%20USB%20conectado%20y%20copiar%20el%20contenido%20en%20una%20carpeta%20temporal.ps1

## Discover a webcam
https://www.jesusninoc.com/2017/10/17/discover-a-webcam/

## Ver los teléfonos móviles que se han conectado al sistema operativo
https://www.jesusninoc.com/2016/12/01/ver-los-telefonos-moviles-que-se-han-conectado-al-sistema-operativo/

## Conocer el estado del ratón
https://www.jesusninoc.com/2016/10/05/conocer-el-estado-del-raton/

## Activar un dispositivo Plug and Play con PowerShell
https://www.jesusninoc.com/2018/03/08/activar-un-dispositivo-plug-and-play-con-powershell/

## Desactivar un dispositivo Plug and Play con PowerShell
https://www.jesusninoc.com/2018/02/08/desactivar-un-dispositivo-plug-and-play-con-powershell/

## Show UDID of iPhone
https://www.commandlinefu.com/commands/view/15421/show-udid-of-iphone

# Linux
## Setting Up NFS Share on Windows
https://support.microfocus.com/kb/doc.php?id=7020834

## Montar una carpeta compartida de Windows en Linux
https://blog.desdelinux.net/montar-unidades-smb-desde-consola/

## dd command
https://www.computerhope.com/unix/dd.htm

Caution: Use dd cautiously — improper usage or entering the wrong values could inadvertently wipe, destroy, or overwrite the data on your hard drive.

### Create a ISO disc image from the CD in the computer
```Bash
dd if=/dev/sr0 of=/home/hope/exampleCD.iso bs=2048 conv=noerror,sync
```

### Create an img file of the /dev/sda hard drive. To restore that image type: dd if=disk1.img of=/dev/sda
```Bash
dd if=/dev/sda of=~/disk1.img
```

### Copy the contents from the if= drive /dev/sda to the of= drive /dev/sdb.
```Bash
dd if=/dev/sda of=/dev/sdb
```

## How to dd a remote disk using SSH on local machine and save to a local disk
https://unix.stackexchange.com/questions/132797/how-to-dd-a-remote-disk-using-ssh-on-local-machine-and-save-to-a-local-disk

### run from remote computer
```Bash
$ dd if=/dev/sda | gzip -1 - | ssh user@local dd of=image.gz
```

### run from local computer
```Bash
$ ssh user@remote "dd if=/dev/sda | gzip -1 -" | dd of=image.gz
```

-----------
-----------

# Repaso

## Registrar y mostrar un evento en PowerShell cuando se ejecuta un programa
https://www.jesusninoc.com/2018/02/14/registrar-y-mostrar-un-evento-en-powershell-cuando-se-ejecuta-un-programa/

## Registrar y mostrar un evento en PowerShell cuando se crea un usuario
https://www.jesusninoc.com/2018/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

# Registry

A central hierarchical database used in Microsoft Windows, used to store information that is necessary to configure the system for one or more users, applications and hardware devices.

https://www.jesusninoc.com/registry/

## Ejemplos en PowerShell de gestión del registro de Windows

### Ver información en el Registro de Windows sobre las Variables de entorno
https://www.jesusninoc.com/2015/03/23/ver-informacion-en-el-registro-de-windows-sobre-las-variables-de-entorno/
### Ver información en el Registro de Windows sobre el estado de los servicios
https://www.jesusninoc.com/2015/03/22/ver-informacion-en-el-registro-de-windows-sobre-el-estado-de-los-servicios/

## Ejercicios en PowerShell de gestión del registro de Windows
https://github.com/jesusninoc/PowerShell/tree/master/Registro

## Herramienta para analizar el registro (Process Monitor v3.40)
Process Monitor is an advanced monitoring tool for Windows that shows real-time file system, Registry and process/thread activity. It combines the features of two legacy Sysinternals utilities, Filemon and Regmon, and adds an extensive list of enhancements including rich and non-destructive filtering, comprehensive event properties such session IDs and user names, reliable process information, full thread stacks with integrated symbol support for each operation, simultaneous logging to a file, and much more. Its uniquely powerful features will make Process Monitor a core utility in your system troubleshooting and malware hunting toolkit.
https://www.jesusninoc.com/2018/02/11/process-monitor-v3-40/

# Expresiones regulares
https://ss64.com/ps/syntax-regex.html

## Regular Expressions Unfettered
https://developer.apple.com/library/content/documentation/OpenSource/Conceptual/ShellScripting/RegularExpressionsUnfettered/RegularExpressionsUnfettered.html

## Ejemplos de utilización de expresiones regulars
https://www.regular-expressions.info/examples.html

## Searching IP addresses in text files
https://www.jesusninoc.com/2014/11/24/searching-ip-addresses-in-text-files/

## Searching URLs in text files
https://www.jesusninoc.com/2014/11/19/searching-urls-text-files/

## Searching the Registry: IP addresses
https://www.jesusninoc.com/2014/11/12/searching-registry-ip-addresses/

## Searching the Registry: URLs
https://www.jesusninoc.com/2014/11/14/searching-registry-urls/

## Online regex tester
https://regex101.com/

# Registry

A central hierarchical database used in Microsoft Windows, used to store information that is necessary to configure the system for one or more users, applications and hardware devices.

https://www.jesusninoc.com/registry/

## Ejemplos en PowerShell de gestión del registro de Windows

### Ver información en el Registro de Windows sobre las Variables de entorno
https://www.jesusninoc.com/2015/03/23/ver-informacion-en-el-registro-de-windows-sobre-las-variables-de-entorno/
### Ver información en el Registro de Windows sobre el estado de los servicios
https://www.jesusninoc.com/2015/03/22/ver-informacion-en-el-registro-de-windows-sobre-el-estado-de-los-servicios/

## Ejercicios en PowerShell de gestión del registro de Windows
https://github.com/jesusninoc/PowerShell/tree/master/Registro

## Herramienta para analizar el registro (Process Monitor v3.40)
Process Monitor is an advanced monitoring tool for Windows that shows real-time file system, Registry and process/thread activity. It combines the features of two legacy Sysinternals utilities, Filemon and Regmon, and adds an extensive list of enhancements including rich and non-destructive filtering, comprehensive event properties such session IDs and user names, reliable process information, full thread stacks with integrated symbol support for each operation, simultaneous logging to a file, and much more. Its uniquely powerful features will make Process Monitor a core utility in your system troubleshooting and malware hunting toolkit.
https://www.jesusninoc.com/2018/02/11/process-monitor-v3-40/

# Expresiones regulares
https://ss64.com/ps/syntax-regex.html

## Regular Expressions Unfettered
https://developer.apple.com/library/content/documentation/OpenSource/Conceptual/ShellScripting/RegularExpressionsUnfettered/RegularExpressionsUnfettered.html

## Ejemplos de utilización de expresiones regulars
https://www.regular-expressions.info/examples.html

## Searching IP addresses in text files
https://www.jesusninoc.com/2014/11/24/searching-ip-addresses-in-text-files/

## Searching URLs in text files
https://www.jesusninoc.com/2014/11/19/searching-urls-text-files/

## Searching the Registry: IP addresses
https://www.jesusninoc.com/2014/11/12/searching-registry-ip-addresses/

## Searching the Registry: URLs
https://www.jesusninoc.com/2014/11/14/searching-registry-urls/

## Online regex tester
https://regex101.com/

------------------

# Converting PowerShell to Batch
http://community.idera.com/powershell/powertips/b/tips/posts/converting-powershell-to-batch

# Formas de descargar y ejecutar ficheros desde un servidor en PowerShell
https://www.jesusninoc.com/2016/11/15/formas-de-descargar-y-ejecutar-ficheros-desde-un-servidor-en-powershell/

# Permitir conexiones remotas
https://www.jesusninoc.com/2016/05/08/permitir-conexiones-remotas/

# Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
https://www.jesusninoc.com/2016/11/23/crear-un-usuario-local-con-contrasena-en-windows-10-con-powershell-5-1/

# Conectarse por SSH al router de fibra óptica MitraStar de Movistar desde PowerShell
https://www.jesusninoc.com/2017/11/16/conectarse-por-ssh-al-router-de-fibra-optica-mitrastar-de-movistar-desde-powershell/

# Datos URIs
https://developer.mozilla.org/es/docs/Web/HTTP/Basics_of_HTTP/Datos_URIs

# Bash Bunny Phishing Attack With Hamsters - Hak5 2306
https://www.youtube.com/watch?v=TYR2a2XoK3A

# Realizar una redirección con JavaScript utilizando Start-Process y Google Chrome
https://www.jesusninoc.com/2017/02/06/realizar-una-redireccion-con-javascript-utilizando-start-process-y-google-chrome-2/

# Ejecutar un Batch que descarga un script desde una URL, el script ejecuta un payload de ejecución de comandos arbitrarios que permite realizar un volcado de memoria RAM

* Converting PowerShell to Batch
http://community.idera.com/powershell/powertips/b/tips/posts/converting-powershell-to-batch

* Formas de descargar y ejecutar ficheros desde un servidor en PowerShell
https://www.jesusninoc.com/2016/11/15/formas-de-descargar-y-ejecutar-ficheros-desde-un-servidor-en-powershell/

* Cargar en memoria y ejecutar un payload de ejecución de comandos arbitrarios en PowerShell
https://www.jesusninoc.com/2017/02/16/cargar-en-memoria-y-ejecutar-un-payload-de-ejecucion-de-comandos-arbitrarios-en-powershell/

* Crear un fichero de volcado de memoria de un proceso
https://www.jesusninoc.com/2016/03/04/crear-un-fichero-de-volcado-de-memoria-de-un-proceso/

## Más ideas

* Keylogger sencillo con PowerShell
https://www.jesusninoc.com/2017/03/11/keylogger-sencillo-con-powershell/

* Enviar datos a un formulario de Google Docs desde PowerShell
https://www.jesusninoc.com/2017/03/11/enviar-datos-a-un-formulario-de-google-docs-desde-powershell/

# Recuperación del sistema operativo
- Copia del sistema operativo en red (carpeta compartida).
- Crear disco de recuperación.

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Introducción

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Introducción

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

## Encontrarse a uno mismo
```PowerShell
Get-EventLog Security | Where-Object Message -Match "asir1joselui"
```

## Ejemplos de introducción a monitorizar
```PowerShell
# (INCORRECTO) Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
Get-CimInstance -ClassName Win32_StartupCommand  | select Caption, @{n='NombreP';e={(Get-Process -name $_.Caption | Select Name).name}}

# Comprobar que se está ejecutando un programa que se arranca al inicio del arranque del sistema operativo
Get-Process -Name MSOSYNC

# (CORRECTO 1) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

Get-Process -Name $acumul

# (CORRECTO 2) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
function comprobar($programa){
    Get-Process -Name $programa -ErrorAction Ignore
}

Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        comprobar $temperal[$temperal.Count-1]

}

# (CORRECTO 3) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

$acumul | %{
    $_
    ((Get-Process).name.toupper()).contains($_.toupper())
}
```

## Ejercicio: registrar un evento cuando se logre realizar una conexión entre un cliente y un servidor mediante UDP (almacenar la dirección IP de la conexión del cliente o del servidor)
* https://www.jesusninoc.com/05/08/ejercicios-de-powershell-registrar-un-evento-cuando-se-logre-realizar-una-conexion-entre-un-cliente-y-un-servidor-mediante-udp-almacenar-la-direccion-ip-de-la-conexion-del-cliente-o-del-servidor/

### Solución (otra forma de verlo, el cliente manda crear un log al servidor)

#### Cliente
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "192.168.43.108" -Category 2 -RawData 10,20')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
#### Servidor
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
Invoke-Expression ([Text.Encoding]::ASCII.GetString($content))
```

-------------------
-------------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------------

# Monitorizar procesos
## 7. Gestión de procesos en PowerShell
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

## System Monitor
System Monitor (Sysmon) is a Windows system service and device driver that, once installed on a system, remains resident across system reboots to monitor and log system activity to the Windows event log. It provides detailed information about process creations, network connections, and changes to file creation time. By collecting the events it generates using Windows Event Collection or SIEM agents and subsequently analyzing them, you can identify malicious or anomalous activity and understand how intruders and malware operate on your network.
* https://www.fwhibbit.es/sysmon-el-gran-hermano-de-windows-y-el-super-sysmonview

Install with default settings (process images hashed with sha1 and no network monitoring)
```MD-DOS
sysmon -accepteula –i
```
Install with md5 and sha256 hashing of process created and monitoring network connections
```MD-DOS
sysmon -accepteula –i –h md5,sha256 –n
```
Install Sysmon with a configuration file (as described below)
```MD-DOS
sysmon –accepteula –i c:\windows\config.xml
```
Uninstall
```MD-DOS
sysmon –u
```
Dump the current configuration
```MD-DOS
sysmon –c
```
Change the configuration to use all hashes, no network monitoring and monitoring of DLLs in Lsass
```MD-DOS
sysmon –c –h * –l lsass.exe
```
Change the configuration of sysmon with a configuration file (as described below)
```MD-DOS
sysmon –c c:\windows\config.xml
```
Change the configuration to default settings
```MD-DOS
sysmon –c --
```
Show the configuration schema
```MD-DOS
sysmon -s
```

## Sources, configuration and how to detect evil things utilizing Microsoft Sysmon
https://github.com/MHaggis/sysmon-dfir

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------

# Logs

## Logs en Windows

### PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

### List event log
https://www.jesusninoc.com/2018/03/27/list-event-log

### Write-EventLog
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/write-eventlog?view=powershell-5.1

### Escribir y ver un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Almacenar información convertida a byte en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/05/almacenar-informacion-convertida-a-byte-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Ejecutar la información que se encuentra en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/06/ejecutar-la-informacion-que-se-encuentra-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Windows Event Log to the Dark Side — Storing Payloads and Configurations
https://medium.com/@5yx/windows-event-log-to-the-dark-side-storing-payloads-and-configurations-9c8ad92637f2

### Active Directory: Configuring Event Log Subscriptions (Forwarding)
https://sid-500.com/2018/04/23/active-directory-configuring-event-log-subscriptions-forwarding/

### HOW TO DETECT PASS-THE-HASH ATTACKS
https://blog.stealthbits.com/how-to-detect-pass-the-hash-attacks/

## Logs en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-13.md#registros-de-sucesos

```Bash
cd /var/log
ls
```

- /var/log/message: registro de mensajes generales del sistema
- /var/log/auth.log: log de autenticación
- /var/log/kern.log: registro del kernel
- /var/log/cron.log: registro de cron
- /var/log/maillog: registro del servidor de mails
- /var/log/qmail/ : registro de Qmail
- /var/log/httpd/: registro de errores y accesos a Apache
- /var/log/lighttpd: registro de errores y accesos a Lighttpd
- /var/log/boot.log : registro de inicio del sistema
- /var/log/mysqld.log: registro de la base de datos MySQL
- /var/log/secure: log de autenticación
- /var/log/utmp or /var/log/wtmp : registro de logins

### Analizar logs en Linux
#### Regular Expressions
```Bash
 grep -a "user juanito" /var/log/auth.log
```
#### Tail
```Bash
$ tail -f /var/log/auth.log | grep -a 'invalid'
```
#### Cut
```Bash
grep "authentication failure" /var/log/auth.log | cut -d '=' -f 8
```
#### Awk
```Bash
awk '/sshd.*invalid user/ { print $9 }' /var/log/auth.log
```

------------------
------------------

# Repaso Linux

* https://www.jesusninoc.com/02/03/curso-de-bash-scripting-con-ejemplos/
* https://github.com/jesusninoc/Bash/blob/master/Introduccion/EjemplosIntroducci%C3%B3n.sh
* https://github.com/jesusninoc/Bash/blob/master/Introduccion/EjemplosOperacionesCadenas.sh
* https://github.com/jesusninoc/Bash/tree/master/Examenes
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-15.md
* https://github.com/jesusninoc/Bash/tree/master/Permisos
* https://github.com/jesusninoc/Bash/tree/master/Ficheros
* https://github.com/jesusninoc/Bash/tree/master/Repaso
* https://github.com/jesusninoc/Bash/tree/master/Monitorizacion
* https://github.com/jesusninoc/Bash

---------
---------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Introducción

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

## Encontrarse a uno mismo
```PowerShell
Get-EventLog Security | Where-Object Message -Match "asir1joselui"
```

## Ejemplos de introducción a monitorizar
```PowerShell
# (INCORRECTO) Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
Get-CimInstance -ClassName Win32_StartupCommand  | select Caption, @{n='NombreP';e={(Get-Process -name $_.Caption | Select Name).name}}

# Comprobar que se está ejecutando un programa que se arranca al inicio del arranque del sistema operativo
Get-Process -Name MSOSYNC

# (CORRECTO 1) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

Get-Process -Name $acumul

# (CORRECTO 2) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
function comprobar($programa){
    Get-Process -Name $programa -ErrorAction Ignore
}

Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        comprobar $temperal[$temperal.Count-1]

}

# (CORRECTO 3) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

$acumul | %{
    $_
    ((Get-Process).name.toupper()).contains($_.toupper())
}
```

## Ejercicio: registrar un evento cuando se logre realizar una conexión entre un cliente y un servidor mediante UDP (almacenar la dirección IP de la conexión del cliente o del servidor)
* https://www.jesusninoc.com/05/08/ejercicios-de-powershell-registrar-un-evento-cuando-se-logre-realizar-una-conexion-entre-un-cliente-y-un-servidor-mediante-udp-almacenar-la-direccion-ip-de-la-conexion-del-cliente-o-del-servidor/

### Solución (otra forma de verlo, el cliente manda crear un log al servidor)

#### Cliente
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "192.168.43.108" -Category 2 -RawData 10,20')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
#### Servidor
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
Invoke-Expression ([Text.Encoding]::ASCII.GetString($content))
```

-------------------
-------------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------------

# Monitorizar procesos
## 7. Gestión de procesos en PowerShell
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

## System Monitor
System Monitor (Sysmon) is a Windows system service and device driver that, once installed on a system, remains resident across system reboots to monitor and log system activity to the Windows event log. It provides detailed information about process creations, network connections, and changes to file creation time. By collecting the events it generates using Windows Event Collection or SIEM agents and subsequently analyzing them, you can identify malicious or anomalous activity and understand how intruders and malware operate on your network.
* https://www.fwhibbit.es/sysmon-el-gran-hermano-de-windows-y-el-super-sysmonview

Install with default settings (process images hashed with sha1 and no network monitoring)
```MD-DOS
sysmon -accepteula –i
```
Install with md5 and sha256 hashing of process created and monitoring network connections
```MD-DOS
sysmon -accepteula –i –h md5,sha256 –n
```
Install Sysmon with a configuration file (as described below)
```MD-DOS
sysmon –accepteula –i c:\windows\config.xml
```
Uninstall
```MD-DOS
sysmon –u
```
Dump the current configuration
```MD-DOS
sysmon –c
```
Change the configuration to use all hashes, no network monitoring and monitoring of DLLs in Lsass
```MD-DOS
sysmon –c –h * –l lsass.exe
```
Change the configuration of sysmon with a configuration file (as described below)
```MD-DOS
sysmon –c c:\windows\config.xml
```
Change the configuration to default settings
```MD-DOS
sysmon –c --
```
Show the configuration schema
```MD-DOS
sysmon -s
```

## Sources, configuration and how to detect evil things utilizing Microsoft Sysmon
https://github.com/MHaggis/sysmon-dfir

# Introducción al examen liberatorio

## Opción 1

### El departamento de recursos humanos envía el siguiente fichero...
```
nombre;apellido;password;grupo;ou;appbloqueada
juan;sinmiedo;P@ss1wordA;asir;asir;notepad
laura;valiente;P@ss1wordA;af;af;mspaint
```

#### - Nivel 1: crear un script que permita realizar todas las tareas que aparecen en el fichero.
#### - Nivel 2: crear un script que permita realizar las operaciones de forma ordenada.
#### - Nivel 3: crear un script que permita realizar las operaciones utilizando UDP.

## Opción 2

### Crear la estructura de red del Centro leyendo de un fichero, teniendo en cuenta:
- Hay seis grupos de clases, seis unidades organizativas
- Hay que crear usuarios y grupos para cada clase
- Hay que deshabilitar usuarios y moverlos a la unidad organizativa de los deshabilitados
- Borrar unidades organizativas
- Crear una carpeta para cada usuario

------------
------------

# Trabajo para optar al 10 y a MH
### Utilizando sockets comunicar un cliente con un servidor y aplicar el mayor número de conceptos vistos durante el curso:
- Crear una herramienta de control remoto.
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

--------------

## Ayuda
### Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

## Ayuda avanzada
### Pedir el nombre de un proceso y mostrar información del proceso mediante PowerShell con Node-PowerShell, EJS (Embedded JavaScript), Body-parser y Express
https://www.jesusninoc.com/2018/06/10/pedir-el-nombre-de-un-proceso-y-mostrar-informacion-del-proceso-mediante-powershell-con-node-powershell-ejs-body-parser-y-express-node-js/

### Build a Weather Website in 30 minutes with Node.js + Express + OpenWeather
https://codeburst.io/build-a-weather-website-in-30-minutes-with-node-js-express-openweather-a317f904897b

--------------

## Ejemplo de trabajo

### Realizar operaciones en un equipo remoto

```PowerShell
cls
write-host "Ip del ordenador remoto"
$ipR=read-host

##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('cls')"
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

while (1)
{

cls

Write-Host "Seleccione una opcion"

echo "1 - Sistema de archivos"
echo "2 - Agregar/eliminar software"
echo "3 - Actualizacion"
echo "4 - Gestion de procesos"
echo "5 - Programacion de tareas"
echo "6 - Gestion de usuarios"
echo "7 - Gestion de almacenamiento"
echo "8 - Gestion de red"
echo "9 - Copias de seguridad"
echo "10 - Reparacion del sistema"
echo "11 - Rendimiento del sistema"
echo "12 - Salir"

$prue1 = Read-Host
switch ( $prue1 )
    {
        1{
            cls
            Write-Host "Seleccione una opcion"
            echo "1 - Listar"
            echo "2 - Crear"
            echo "3 - Abrir"
            echo "4 - Eliminar"
            $selcec=Read-Host
            switch ( $selcec )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=[Text.Encoding]::ASCII.GetBytes('Get-ChildItem')
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                2{
                    $type=Read-Host "Escriba que tipo desea crear (File o Directory)"
                    $name=Read-Host "Escriba el nombre del $type"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Item -ItemType $type -Name $name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                3{
                    $name1=Read-Host "Nombre del archivo que desea abrir"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('start $name1')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                4{
                    ls
                    $name2=Read-Host "¿Qué desea eliminar?"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-Item $name2')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }                   
        }
        2{
            cls
            $nombre=Read-Host "Introduzca nombre del .msi que desee instalar"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('msiexec.exe /package C:\windows\Installer\($nombre)')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        Pause
        }
        3{
            cls
            echo "1 - Instalar"
            echo "2 - Desinstalar"
            Write-Host "Seleccione una opción"
            $actuali=Read-Host
            switch ($actuali)
            {
                1{
                    Write-Host "Como desea que se realize"
                    echo "1 - Normal"
                    echo "2 - En silencio"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            Write-Host "Escriba el nombre de la actualizacion"
                            $nombre=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                           
                        }
                        2{
                            Write-Host "Eliga la opción desea"
                            echo "1 - No reiniciarse al terminar"
                            echo "2 - Pedir confirmación antes de reiniciar"
                            echo "3 - Obligar a que se cierren todas las aplicaciones y se reinicie"
                            $Smodo=Read-Host
                            $Nombre=Read-Host
                            switch($Smodo)
                            {
                                1{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()
                                    
                                }
                                2{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /warnrestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                                3{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /forcerestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                            }
                        }
                    }
                }
                2{
                    cls
                    echo "1 - Normal"
                    echo "2 - Paquete asociado con el número de actualización"
                    Write-Host "Seleccione una opción"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                        2{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall /kb')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                    }
            }
            }
            puase
        }
        4{
            cls
            echo "1 - Iniciar un proceso"
            echo "2 - Mostrar solo Nombres"
            echo "3 - Mostrar proceso de cierto programa"

            $sele=Read-Host
            switch ( $sele )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                } 
                2 {
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | select Name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3 {
                    $selprog=Read-Host "Escriba el nombre del programa"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | Select-String $selprog')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
        5{
            cls
            $program=Read-Host "que programa desea abrir"
            $time=Read-Host "a que hora"
            $nomre=Read-Host "escriba el nombre de la tarea"
            $action=New-ScheduledTaskAction -Execute $program
            $trigger=New-ScheduledTaskTrigger -Daily -At $time
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Register-ScheduledTask -Action $action -Trigger $trigger -TaskName $nomre')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()           
            Pause
            
        }
        6{
            cls
            echo "1 - Crear usuario"
            echo "2 - Eliminar usuario"
            echo "3 - Crear grupo"
            echo "4 - Ver miembros de un grupo"
            echo "5 - Eliminar grupo"
            $opcion=Read-Host "Eliga una opcion"
            switch ($opcion)
            {
            1{
                $nameuser=Read-Host "Nomre del nuevo usuario"
                $pass=Read-Host "Introduzca contraseña"
                $pass1=ConvertTo-SecureString $pass -asplaintext -force
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalUser $nameuser -Password $pass1')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            2{
                $usuer=Read-Host "Nombre del usuario"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-LocalUser -Name $usuer')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            3{
                $group=Read-Host "Nombre para el grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalGroup -Name $group')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            4{
                $Ngroup=Read-Host "Nombre del grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Ngroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            5{
                $Rgroup=Read-Host "Nombre del grupo que vaya a eliminar"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Rgroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            }
        }
        7{
            cls
            echo "1 - Particionar"
            echo "2 - Desfragmentar"
            echo "3 - Convertir sistemas de archivo"
            echo "4 - Cifrar"
            echo "5 - Descifrar"
            Write-Host  "Seleccione una opción"
            $almacenamiento=Read-Host
            switch ($almacenamiento)
            {
                1{
                    Write-Host "ADVERTENCIA: Nunca poner el numero '0'"
                    $NumeroD=Read-Host "Introduzca número del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Partition -DiskNumber $NumeroD -UseMaximumSize -AssignDriveLetter')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    $letra=Read-Host "Letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Optimize-Volume $letra -Defrag')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Disable-BitLocker 
                    Pause
                }
                3{
                    $letra=Read-Host "Letra del disco"
                    $tipo=Read-Host "Que formato desea"                    
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Format-Volume -DriveLetter $letra -FileSystem $tipo')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                4{
                    $letra=Read-Host "Inroduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Enable-BitLocker -MountPoint $letra -RecoveryPasswordProtector -UsedSpaceOnly -Verbose')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                5{
                    $letra=Read-Host "Introduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Disable-BitLocker -MountPoint $letra')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
            }
              
        }
        }
        8{
            cls
            echo "1 - Saber ip"
            echo "2 - Hacer ping"
            $op=Read-Host "Seleccione una opcion"
            Switch ( $op )
            {
            1{
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ipconfig')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            2{
                $ip=Read-Host "Introduzca IPv4"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ping $ip')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            }
        }
        9{
            cls
            Write-Host "Se recomienda que ponga la ruta y para quedarsela usted la meta en una carpeta compartida"
            $namea=Read-Host "Nombre del archivo que desea hacer copia de seguridad"
            $ruta=Read-Host "Ruta donde desea que este la copia de seguridad"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Copy-Item $namea $ruta')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()            
            Pause
        }
        10{
            cls
            Write-Host "Seleccione una opción"
            echo "1 - Ver puntos de restauracion"
            echo "2 - Restaurar un punto"
            $opcion=Read-Host
            switch ($opcion)
            {
                1{        
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                }
                2{
                    Write-Host "Seleccione una opción"
                    echo "1 - Ultimo punto"
                    echo "2 - Restaura cierto punto"
                    $opcion=Read-Host
                    switch ($opcion)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint -LastStatus')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }

                        2{
                            Write-Host "Ponga el numero de restauración"
                            $punto=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Restore-Computer -RestorePoint $punto')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()                   
                        }
                    }
                }
            }
            Pause
        }
        11{
            cls
            echo "1 - Monitorizar procesos"
            echo "2 - Monitorizar procesos Avanzado"
            echo "3 - Ver todos los nombres de los contadores de rendimiento"
            $seleccionar=Read-Host "Seleccione una opción"
            switch ( $seleccionar )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port
                    )
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Counter -ListSet * | Sort-Object CounterSetName | Format-Table CounterSetName')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
}
if( $prue1 -eq "12" )
        {
            cls
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('break')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            break
        }
}
```

-----------
-----------

# Modelos de examen de la asignatura de Implantación de Sistemas Operativos (ISO) de 1º de Administración de Sistemas Informáticos en Red (ASIR) tercera evaluación
- Modelo 1 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-1
- Modelo 2 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-2
- Modelo 3 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-3
- Modelo 4 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-4
- Modelo 5 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-5
- Modelo 6 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-6

-----------------

# Modelo 1

## Tener en cuenta:
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## 1. Analizar ficheros DLL en todos los equipos de la red
```PowerShell
123..125 | %{"192.168.104." + $_}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
$ruta
}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.jes"
ls $ruta
}

1..40 |  %{Invoke-Command -ComputerName ("192.168.204." + $_) -ScriptBlock {hostname}}

Invoke-Command -ComputerName dc1 -ScriptBlock {hostname}

gc .\equipos1.txt | % {
    $llistar="\\"+$_+"\c$"
    ls $llistar | select name,FullName
} | Group-Object name | select Count,Group | where count -eq 1
```
### Enable and Use Remote Commands in Windows PowerShell
https://technet.microsoft.com/en-us/library/ff700227.aspx
### How to Add a Computer to the TrustedHosts List
```PowerShell
set-item wsman:\localhost\Client\TrustedHosts -value "ABANTO"
```
### Listar funciones exportadas de un archivo DLL con DUMPBIN desde PowerShell
https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/

## 2. Analizar ficheros DLL en todos los equipos de la red, comprobar que ha cambiado una integridad y copiar el fichero que ha cambiado
### En PowerShell
```PowerShell
mkdir dlls

cd dlls

"dll1" | Out-File dll1.dll
"dll2" | Out-File dll2.dll

# Recorrrer una a una dll
ls *.dll | %{$_}

# Hacer hash de cada dll
ls *.dll | %{Get-FileHash $_.FullName | Select-Object Hash}

# Hacer hash de cada dll ruta por red
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path}

# Guardar hash
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path | Out-File listado.txt -Append}

# Ver listado
gc .\listado.txt

# Modificar dll y detectar el cambio, después mover la dll, solución: el hash de cada dll no se encuentra en el fichero listado.txt, eso quiere decir que se ha modificado y hay que copiar a la carpeta compartida en Linux
# Modificar dll
"dll6" | Out-File dll1.dll

ls '\\localhost\c$\Users\juan\dlls' *.dll | %{
    if((gc .\listado.txt) -match (Get-FileHash $_.FullName | Select-Object Hash).hash)
    {
    }
    else
    {
        $_.Name
        "Dll se ha modificado"
    }
}


# Meter el código anterior en el recorrido que cada alumno tenga
123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
ls $ruta -recurse
}

# Almacenar el hash de la dll para todos los equipos de la red
foreach($equipo in gc .\equipos1.txt) {
    $llistar="\\"+$equipo+"\c$"
    ls $llistar -recurse *.dll | %{
        $valorse = Get-FileHash ($_ | select FullName).FullName
        $valorse.path+"|"+$valorse.Hash | Out-File hasehees.txt
    }
}

# Verificar si una dll no ha cambiado su hash
gc .\hasehees.txt | %{
    if($_.split("|")[0].contains("jawt.dll"))
    {
        if($_.split("|")[1] -eq (Get-FileHash "\\ABANTOS21\c$\Cache\pc-client.exe-16.3.0.37857\runtime\jre\bin\jawt.dll" | select hash).hash)
        {
            "CORRECTO"
        }
    }
}
```
#### Se puede crear una dll y modificar una función para comprobar que la integridad falla
* https://www.jesusninoc.com/11/26/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-ejecute-un-cmdlet-de-powershell/
* https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/
* https://www.jesusninoc.com/04/21/obtener-los-nombres-de-las-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell-explicacion-paso-a-paso-del-script/

### En Linux
https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

## 3. Puedes saber qué fichero DLL están funcionando en el equipo utilizando la red
```PowerShell
(Get-Process -ComputerName .).Modules
(Get-Process -ComputerName .).Modules | where ModuleName -eq  sxs.dll
```

## 4. Detectar que una aplicación tiene tráfico de red (filtro por puerto)
### Tshark Command Examples
https://linuxsimba.com/tshark-examples

```PowerShell
$filterUDP = ''
$filterTCP = ''
ps | where ProcessName -eq 'chrome' | %{
    Get-NetUDPEndpoint | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterUDP = $filterUDP+'(udp.port == '+$_.LocalPort+') or'
    }
    
    Get-NetTCPConnection | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterTCP = $filterTCP+'(tcp.port == '+$_.LocalPort+') or'
    }
    
    
}
$filterUDP = $filterUDP.substring(0, $filterUDP.Length-3)
$filterTCP = $filterTCP.substring(0, $filterTCP.Length-3)

$filter = $filterUDP+' or '+$filterTCP

net use \\192.168.104.129\Prueba-share-samba /user:root 1234

.\tshark.exe -i 'ethernet 2' -Y $filter > \\192.168.104.129\Prueba-share-samba\test.txt
```

-----------------

# Modelo 2

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web periódico

### Eres el nuevo administrador de sistemas del diario el Universo. El diario funciona así: los periodistas sus ficheros HTML a sus carpetas en la red mediante un interfaz web (una Intranet). Cada periodista ve sus propios ficheros y no ve los de sus compañeros. Por ejemplo: Juan crea la página 1 del periódico y sube dicha página al servidor web.

## Resuelve lo siguiente:
1) Junta todas las páginas del periódico de todos los periodistas.
```PowerShell
mkdir usuario1; cd usuario1
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina1.html
cd ..
mkdir usuario2; cd usuario2
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina2.html
cd ..

ls *.html -recurse | %{
    $periodidcocomp = $periodidcocomp + (gc $_)
}

$periodidcocomp | out-file periodicocompleto.html
```
2) Haz copias de seguridad para diferentes momentos del día y al final del día haz copia de todo el periódico completo.
```PowerShell
(Get-Date).ToString("yyyyMMddhh")

$fecha = (Get-Date).ToString("yyyyMMddhh")
mkdir ($fecha) -force
cd $fecha

ls *.html -recurse | %{
    copy $_ $fecha
}
```
3) Incidencia. Alguien ha mandado imprimir el periódico entero. Tienes que pararlo porque no es el momento de imprimirlo.
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
#$perio = gc .\periodicocompleto.html
$b=[Text.Encoding]::ASCII.GetBytes("gc perio.html | out-printer")
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
##Server
while(1)
{
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
if([Text.Encoding]::ASCII.GetString($content) | select-string "print")
{
    "ha mandado imprimir"
}
}
```
4) Opcional. El periódico automático. Crear cada página HTML utilizando una base de datos
* https://www.jesusninoc.com/09/20/crear-un-fichero-html-con-el-contenido-de-la-tabla-posts-de-wordpress-con-powershell/

-----------------

# Modelo 3

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
- Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
```PowerShell
Get-EventLog -LogName security | select Message | select-string "\\localhost\ejemplo"
```
- Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
    - https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/
    - https://www.jesusninoc.com/03/12/select-files-between-two-dates-and-copy-them/
  - Dejar programada la acción.
    - https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
  - Comprimir y descomprimir
    - https://www.jesusninoc.com/03/15/create-new-compress-archive-file/
    - https://www.jesusninoc.com/02/14/descomprimir-archivos/
  - Cifrar el contenido, método sencillo o complicado.
    - https://www.jesusninoc.com/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación
  - Funciones simples y complejas
```PowerShell
##########################
# Funciones simples
##########################
function crearestructura()
{
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force

    $fecha = (Get-Date).ToString("yyyyMMdd")
    cd copia
    mkdir ($fecha) -force
}

crearestructura

function copiararchivos()
{
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha -force
    }
}

copiararchivos

function recuperar
{
  param($fichero)
  begin
  {
  }
  process
  {
    Expand-Archive -LiteralPath $fichero -DestinationPath desco\
  }
  end
  {
  }
}

recuperar .\comprimido.zip

##############################################################################

##########################
# Función compleja
##########################
function copiaseguridad
{
  param()
  begin
  {
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force
    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir copia\$fecha -force
  }
  process
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha\ -force
    }
  }
  end
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls copia\$fecha
    Compress-Archive -LiteralPath copia\$fecha –CompressionLevel Optimal -DestinationPath comprimido.zip -Force
  }
}
copiaseguridad
```
- Se ha producido una infección en un sistema operativo Windows,
  - ¿qué elementos comprobarías para detectar dicha infección?
      - https://www.jesusninoc.com/07/11/analisis-de-procesos-y-conexiones-de-red-con-powershell/
  - ¿cómo impides que se produzcan infecciones el sistema operativo?
  - ¿Windows dispone de herramientas centralizadas para evitarlo?

```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```
  
- Explica todo el proceso para realizar una clonación.
- Explica todo lo que sepas sobre permisos en Windows.
- ¿Cómo puedes hacer una sincronización en Linux?, ¿puedes hacerla entre equipos?, ¿cómo?
- ¿Un driver falla, qué haces para arrancar el sistema?
- ¿Un componente gráfico, qué haces para arrancar el sistema?
- Se puede lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
- Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
    - https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
- Explica para qué sirven las auditoría y qué relación tiene con los permisos.
- ¿Qué hace el siguiente script? (explica en detalle el código)
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

-----------------

# Modelo 4

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 5

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 6


## Explicar y realizar un script para cada una de las siguientes situaciones:

1. Cómo puedes saber quién accede a una carpeta compartida en Linux.
2. Realiza un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
    - Windows o Linux.
    - Dejar programada la acción.
    - Cifrar el contenido, método sencillo o complicado.
    - Dejar la carpeta oculta, comando attrib.
    - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
3. Puedes explicar algún sistema distribuido que relacione las cosas que hemos visto en clase.
4. ¿Cómo puedes hacer una sincronización en Linux?, ¿cómo?
5. Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?

## Ayuda
### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS)
https://www.jesusninoc.com/06/04/listar-procesos-de-powershell-con-node-powershell-nodejs/

### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS) Y MOSTRARLOS EN UNA WEB CON EXPRESS
https://www.jesusninoc.com/07/15/listar-procesos-de-powershell-con-node-powershell-node-js-y-mostrarlos-en-una-web-con-express/

### Ejemplo de NODE.JS (Crear una página web con información sobre cada equipo)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()
 
let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('$ComputerSystem=Get-WmiObject Win32_ComputerSystem;$BaseBoard=Get-WmiObject Win32_BaseBoard;$BIOS=Get-WmiObject Win32_BIOS;$Processor=Get-WmiObject Win32_Processor;[PSCustomObject]@{ Model = $ComputerSystem.Model; ManufacturerBoard = $BaseBoard.Manufacturer; BIOSVersion = $BIOS.SMbiosbiosversion; BIOSSerialNumber = $BIOS.serialnumber; ManufacturerProcessor=$Processor.Manufacturer; MaxClockSpeed=$Processor.MaxClockSpeed} | ConvertTo-Html')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});
 
app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

### Ejemplo de NODE.JS (Crear una página web con información sobre procesos)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()

let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('Get-Process | ConvertTo-Html -Property Name, Path, Company')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/procesos', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});

let ps2 = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps2.addCommand('Get-Service | ConvertTo-Html -Property Name, Path, Company')
ps2.invoke()
.then(output => {
  console.log(output);
  app.get('/servicios', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps2.dispose();
});

app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

------------
------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------

# PCAP (container of PCAP captures mapped to the relevant attack tactic)
* https://github.com/sbousseaden/PCAP-ATTACK

--------------------

# USB
## USBPcap – USB Packet capture for Windows
https://www.jesusninoc.com/2016/05/01/usbpcap-usb-packet-capture-for-windows/
## Wireshark and USB
https://isc.sans.edu/forums/diary/Wireshark+and+USB/23457/
## Hackers exploit casino's smart thermometer to steal database info
https://mashable.com/2018/04/15/casino-smart-thermometer-hacked/
## Logran robar datos de un ordenador a través del cableado eléctrico
https://www.redeszone.net/2018/04/13/logran-robar-datos-ordenador-traves-del-cableado-electrico/

----------
----------

# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Rendimiento del hardware
* https://www.jesusninoc.com/02/27/obtener-un-informe-detallado-del-consumo-de-la-bateria-en-windows-desde-powershell/

---------
---------

# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Casos de introducción
## - Preparar un equipo
* https://www.jesusninoc.com/04/22/instalacion-de-sistemas-operativos/
## - Analizar licencias
* https://www.jesusninoc.com/12/02/obtener-serial-de-windows-con-powershell/
## - Administración remota
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-01-16.md
## - Inventario
* https://www.jesusninoc.com/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/
## - Reemplazar espacios en fichero JPG
## - Detectar un problema de red
## - Detectar en los logs que hay intentos de obtener el fichero passwd
* https://www.jesusninoc.com/05/08/consulta-para-ver-intentos-de-obtener-el-fichero-passwd/
### Solución con una query
```PowerShell
.\LogParser.exe "SELECT * FROM 'C:\xampp\apache\logs\access.log' where text like '%passwd%'"
```

------------
------------

# Introducción al examen liberatorio

## Opción 1

### El departamento de recursos humanos envía el siguiente fichero...
```
nombre;apellido;password;grupo;ou;appbloqueada
juan;sinmiedo;P@ss1wordA;asir;asir;notepad
laura;valiente;P@ss1wordA;af;af;mspaint
```

#### - Nivel 1: crear un script que permita realizar todas las tareas que aparecen en el fichero.
#### - Nivel 2: crear un script que permita realizar las operaciones de forma ordenada.
#### - Nivel 3: crear un script que permita realizar las operaciones utilizando UDP.

## Opción 2

### Crear la estructura de red del Centro leyendo de un fichero, teniendo en cuenta:
- Hay seis grupos de clases, seis unidades organizativas
- Hay que crear usuarios y grupos para cada clase
- Hay que deshabilitar usuarios y moverlos a la unidad organizativa de los deshabilitados
- Borrar unidades organizativas
- Crear una carpeta para cada usuario

------------
------------

# Trabajo para optar al 10 y a MH
### Utilizando sockets comunicar un cliente con un servidor y aplicar el mayor número de conceptos vistos durante el curso:
- Crear una herramienta de control remoto.
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

--------------

## Ayuda
### Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

## Ayuda avanzada
### Pedir el nombre de un proceso y mostrar información del proceso mediante PowerShell con Node-PowerShell, EJS (Embedded JavaScript), Body-parser y Express
https://www.jesusninoc.com/2018/06/10/pedir-el-nombre-de-un-proceso-y-mostrar-informacion-del-proceso-mediante-powershell-con-node-powershell-ejs-body-parser-y-express-node-js/

### Build a Weather Website in 30 minutes with Node.js + Express + OpenWeather
https://codeburst.io/build-a-weather-website-in-30-minutes-with-node-js-express-openweather-a317f904897b

--------------

## Ejemplo de trabajo

### Realizar operaciones en un equipo remoto

```PowerShell
cls
write-host "Ip del ordenador remoto"
$ipR=read-host

##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('cls')"
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

while (1)
{

cls

Write-Host "Seleccione una opcion"

echo "1 - Sistema de archivos"
echo "2 - Agregar/eliminar software"
echo "3 - Actualizacion"
echo "4 - Gestion de procesos"
echo "5 - Programacion de tareas"
echo "6 - Gestion de usuarios"
echo "7 - Gestion de almacenamiento"
echo "8 - Gestion de red"
echo "9 - Copias de seguridad"
echo "10 - Reparacion del sistema"
echo "11 - Rendimiento del sistema"
echo "12 - Salir"

$prue1 = Read-Host
switch ( $prue1 )
    {
        1{
            cls
            Write-Host "Seleccione una opcion"
            echo "1 - Listar"
            echo "2 - Crear"
            echo "3 - Abrir"
            echo "4 - Eliminar"
            $selcec=Read-Host
            switch ( $selcec )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=[Text.Encoding]::ASCII.GetBytes('Get-ChildItem')
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                2{
                    $type=Read-Host "Escriba que tipo desea crear (File o Directory)"
                    $name=Read-Host "Escriba el nombre del $type"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Item -ItemType $type -Name $name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                3{
                    $name1=Read-Host "Nombre del archivo que desea abrir"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('start $name1')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                4{
                    ls
                    $name2=Read-Host "¿Qué desea eliminar?"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-Item $name2')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }                   
        }
        2{
            cls
            $nombre=Read-Host "Introduzca nombre del .msi que desee instalar"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('msiexec.exe /package C:\windows\Installer\($nombre)')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        Pause
        }
        3{
            cls
            echo "1 - Instalar"
            echo "2 - Desinstalar"
            Write-Host "Seleccione una opción"
            $actuali=Read-Host
            switch ($actuali)
            {
                1{
                    Write-Host "Como desea que se realize"
                    echo "1 - Normal"
                    echo "2 - En silencio"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            Write-Host "Escriba el nombre de la actualizacion"
                            $nombre=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                           
                        }
                        2{
                            Write-Host "Eliga la opción desea"
                            echo "1 - No reiniciarse al terminar"
                            echo "2 - Pedir confirmación antes de reiniciar"
                            echo "3 - Obligar a que se cierren todas las aplicaciones y se reinicie"
                            $Smodo=Read-Host
                            $Nombre=Read-Host
                            switch($Smodo)
                            {
                                1{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()
                                    
                                }
                                2{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /warnrestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                                3{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /forcerestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                            }
                        }
                    }
                }
                2{
                    cls
                    echo "1 - Normal"
                    echo "2 - Paquete asociado con el número de actualización"
                    Write-Host "Seleccione una opción"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                        2{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall /kb')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                    }
            }
            }
            puase
        }
        4{
            cls
            echo "1 - Iniciar un proceso"
            echo "2 - Mostrar solo Nombres"
            echo "3 - Mostrar proceso de cierto programa"

            $sele=Read-Host
            switch ( $sele )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                } 
                2 {
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | select Name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3 {
                    $selprog=Read-Host "Escriba el nombre del programa"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | Select-String $selprog')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
        5{
            cls
            $program=Read-Host "que programa desea abrir"
            $time=Read-Host "a que hora"
            $nomre=Read-Host "escriba el nombre de la tarea"
            $action=New-ScheduledTaskAction -Execute $program
            $trigger=New-ScheduledTaskTrigger -Daily -At $time
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Register-ScheduledTask -Action $action -Trigger $trigger -TaskName $nomre')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()           
            Pause
            
        }
        6{
            cls
            echo "1 - Crear usuario"
            echo "2 - Eliminar usuario"
            echo "3 - Crear grupo"
            echo "4 - Ver miembros de un grupo"
            echo "5 - Eliminar grupo"
            $opcion=Read-Host "Eliga una opcion"
            switch ($opcion)
            {
            1{
                $nameuser=Read-Host "Nomre del nuevo usuario"
                $pass=Read-Host "Introduzca contraseña"
                $pass1=ConvertTo-SecureString $pass -asplaintext -force
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalUser $nameuser -Password $pass1')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            2{
                $usuer=Read-Host "Nombre del usuario"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-LocalUser -Name $usuer')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            3{
                $group=Read-Host "Nombre para el grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalGroup -Name $group')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            4{
                $Ngroup=Read-Host "Nombre del grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Ngroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            5{
                $Rgroup=Read-Host "Nombre del grupo que vaya a eliminar"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Rgroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            }
        }
        7{
            cls
            echo "1 - Particionar"
            echo "2 - Desfragmentar"
            echo "3 - Convertir sistemas de archivo"
            echo "4 - Cifrar"
            echo "5 - Descifrar"
            Write-Host  "Seleccione una opción"
            $almacenamiento=Read-Host
            switch ($almacenamiento)
            {
                1{
                    Write-Host "ADVERTENCIA: Nunca poner el numero '0'"
                    $NumeroD=Read-Host "Introduzca número del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Partition -DiskNumber $NumeroD -UseMaximumSize -AssignDriveLetter')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    $letra=Read-Host "Letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Optimize-Volume $letra -Defrag')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Disable-BitLocker 
                    Pause
                }
                3{
                    $letra=Read-Host "Letra del disco"
                    $tipo=Read-Host "Que formato desea"                    
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Format-Volume -DriveLetter $letra -FileSystem $tipo')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                4{
                    $letra=Read-Host "Inroduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Enable-BitLocker -MountPoint $letra -RecoveryPasswordProtector -UsedSpaceOnly -Verbose')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                5{
                    $letra=Read-Host "Introduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Disable-BitLocker -MountPoint $letra')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
            }
              
        }
        }
        8{
            cls
            echo "1 - Saber ip"
            echo "2 - Hacer ping"
            $op=Read-Host "Seleccione una opcion"
            Switch ( $op )
            {
            1{
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ipconfig')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            2{
                $ip=Read-Host "Introduzca IPv4"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ping $ip')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            }
        }
        9{
            cls
            Write-Host "Se recomienda que ponga la ruta y para quedarsela usted la meta en una carpeta compartida"
            $namea=Read-Host "Nombre del archivo que desea hacer copia de seguridad"
            $ruta=Read-Host "Ruta donde desea que este la copia de seguridad"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Copy-Item $namea $ruta')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()            
            Pause
        }
        10{
            cls
            Write-Host "Seleccione una opción"
            echo "1 - Ver puntos de restauracion"
            echo "2 - Restaurar un punto"
            $opcion=Read-Host
            switch ($opcion)
            {
                1{        
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                }
                2{
                    Write-Host "Seleccione una opción"
                    echo "1 - Ultimo punto"
                    echo "2 - Restaura cierto punto"
                    $opcion=Read-Host
                    switch ($opcion)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint -LastStatus')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }

                        2{
                            Write-Host "Ponga el numero de restauración"
                            $punto=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Restore-Computer -RestorePoint $punto')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()                   
                        }
                    }
                }
            }
            Pause
        }
        11{
            cls
            echo "1 - Monitorizar procesos"
            echo "2 - Monitorizar procesos Avanzado"
            echo "3 - Ver todos los nombres de los contadores de rendimiento"
            $seleccionar=Read-Host "Seleccione una opción"
            switch ( $seleccionar )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port
                    )
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Counter -ListSet * | Sort-Object CounterSetName | Format-Table CounterSetName')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
}
if( $prue1 -eq "12" )
        {
            cls
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('break')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            break
        }
}
```

-----------
-----------

# Modelos de examen de la asignatura de Implantación de Sistemas Operativos (ISO) de 1º de Administración de Sistemas Informáticos en Red (ASIR) tercera evaluación
- Modelo 1 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-1
- Modelo 2 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-2
- Modelo 3 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-3
- Modelo 4 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-4
- Modelo 5 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-5
- Modelo 6 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-6

-----------------

# Modelo 1

## Tener en cuenta:
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## 1. Analizar ficheros DLL en todos los equipos de la red
```PowerShell
123..125 | %{"192.168.104." + $_}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
$ruta
}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.jes"
ls $ruta
}

1..40 |  %{Invoke-Command -ComputerName ("192.168.204." + $_) -ScriptBlock {hostname}}

Invoke-Command -ComputerName dc1 -ScriptBlock {hostname}

gc .\equipos1.txt | % {
    $llistar="\\"+$_+"\c$"
    ls $llistar | select name,FullName
} | Group-Object name | select Count,Group | where count -eq 1
```
### Enable and Use Remote Commands in Windows PowerShell
https://technet.microsoft.com/en-us/library/ff700227.aspx
### How to Add a Computer to the TrustedHosts List
```PowerShell
set-item wsman:\localhost\Client\TrustedHosts -value "ABANTO"
```
### Listar funciones exportadas de un archivo DLL con DUMPBIN desde PowerShell
https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/

## 2. Analizar ficheros DLL en todos los equipos de la red, comprobar que ha cambiado una integridad y copiar el fichero que ha cambiado
### En PowerShell
```PowerShell
mkdir dlls

cd dlls

"dll1" | Out-File dll1.dll
"dll2" | Out-File dll2.dll

# Recorrrer una a una dll
ls *.dll | %{$_}

# Hacer hash de cada dll
ls *.dll | %{Get-FileHash $_.FullName | Select-Object Hash}

# Hacer hash de cada dll ruta por red
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path}

# Guardar hash
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path | Out-File listado.txt -Append}

# Ver listado
gc .\listado.txt

# Modificar dll y detectar el cambio, después mover la dll, solución: el hash de cada dll no se encuentra en el fichero listado.txt, eso quiere decir que se ha modificado y hay que copiar a la carpeta compartida en Linux
# Modificar dll
"dll6" | Out-File dll1.dll

ls '\\localhost\c$\Users\juan\dlls' *.dll | %{
    if((gc .\listado.txt) -match (Get-FileHash $_.FullName | Select-Object Hash).hash)
    {
    }
    else
    {
        $_.Name
        "Dll se ha modificado"
    }
}


# Meter el código anterior en el recorrido que cada alumno tenga
123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
ls $ruta -recurse
}

# Almacenar el hash de la dll para todos los equipos de la red
foreach($equipo in gc .\equipos1.txt) {
    $llistar="\\"+$equipo+"\c$"
    ls $llistar -recurse *.dll | %{
        $valorse = Get-FileHash ($_ | select FullName).FullName
        $valorse.path+"|"+$valorse.Hash | Out-File hasehees.txt
    }
}

# Verificar si una dll no ha cambiado su hash
gc .\hasehees.txt | %{
    if($_.split("|")[0].contains("jawt.dll"))
    {
        if($_.split("|")[1] -eq (Get-FileHash "\\ABANTOS21\c$\Cache\pc-client.exe-16.3.0.37857\runtime\jre\bin\jawt.dll" | select hash).hash)
        {
            "CORRECTO"
        }
    }
}
```
#### Se puede crear una dll y modificar una función para comprobar que la integridad falla
* https://www.jesusninoc.com/11/26/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-ejecute-un-cmdlet-de-powershell/
* https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/
* https://www.jesusninoc.com/04/21/obtener-los-nombres-de-las-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell-explicacion-paso-a-paso-del-script/

### En Linux
https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

## 3. Puedes saber qué fichero DLL están funcionando en el equipo utilizando la red
```PowerShell
(Get-Process -ComputerName .).Modules
(Get-Process -ComputerName .).Modules | where ModuleName -eq  sxs.dll
```

## 4. Detectar que una aplicación tiene tráfico de red (filtro por puerto)
### Tshark Command Examples
https://linuxsimba.com/tshark-examples

```PowerShell
$filterUDP = ''
$filterTCP = ''
ps | where ProcessName -eq 'chrome' | %{
    Get-NetUDPEndpoint | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterUDP = $filterUDP+'(udp.port == '+$_.LocalPort+') or'
    }
    
    Get-NetTCPConnection | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterTCP = $filterTCP+'(tcp.port == '+$_.LocalPort+') or'
    }
    
    
}
$filterUDP = $filterUDP.substring(0, $filterUDP.Length-3)
$filterTCP = $filterTCP.substring(0, $filterTCP.Length-3)

$filter = $filterUDP+' or '+$filterTCP

net use \\192.168.104.129\Prueba-share-samba /user:root 1234

.\tshark.exe -i 'ethernet 2' -Y $filter > \\192.168.104.129\Prueba-share-samba\test.txt
```

------------
------------

# Modelo 2

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web periódico

### Eres el nuevo administrador de sistemas del diario el Universo. El diario funciona así: los periodistas crean sus ficheros HTML en sus carpetas en la red mediante un interfaz web (una Intranet). Cada periodista ve sus propios ficheros y no ve los de sus compañeros. Por ejemplo: Juan crea la página 1 del periódico y sube dicha página al servidor web.

## Resuelve lo siguiente:
1) Junta todas las páginas del periódico de todos los periodistas.
```PowerShell
mkdir usuario1; cd usuario1
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina1.html
cd ..
mkdir usuario2; cd usuario2
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina2.html
cd ..

ls *.html -recurse | %{
    $periodidcocomp = $periodidcocomp + (gc $_)
}

$periodidcocomp | out-file periodicocompleto.html
```
2) Haz copias de seguridad para diferentes momentos del día y al final del día haz copia de todo el periódico completo.
```PowerShell
(Get-Date).ToString("yyyyMMddhh")

$fecha = (Get-Date).ToString("yyyyMMddhh")
mkdir ($fecha) -force
cd $fecha

ls *.html -recurse | %{
    copy $_ $fecha
}
```
3) Incidencia. Alguien ha mandado imprimir el periódico entero. Tienes que pararlo porque no es el momento de imprimirlo.
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
#$perio = gc .\periodicocompleto.html
$b=[Text.Encoding]::ASCII.GetBytes("gc perio.html | out-printer")
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
##Server
while(1)
{
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
if([Text.Encoding]::ASCII.GetString($content) | select-string "print")
{
    "ha mandado imprimir"
}
}
```
4) Opcional. El periódico automático. Crear cada página HTML utilizando una base de datos
* https://www.jesusninoc.com/09/20/crear-un-fichero-html-con-el-contenido-de-la-tabla-posts-de-wordpress-con-powershell/

-----------------

# Modelo 3

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
- Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
```PowerShell
Get-EventLog -LogName security | select Message | select-string "\\localhost\ejemplo"
```
- Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
    - https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/
    - https://www.jesusninoc.com/03/12/select-files-between-two-dates-and-copy-them/
  - Dejar programada la acción.
    - https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
  - Comprimir y descomprimir
    - https://www.jesusninoc.com/03/15/create-new-compress-archive-file/
    - https://www.jesusninoc.com/02/14/descomprimir-archivos/
  - Cifrar el contenido, método sencillo o complicado.
    - https://www.jesusninoc.com/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación
  - Funciones simples y complejas
```PowerShell
##########################
# Funciones simples
##########################
function crearestructura()
{
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force

    $fecha = (Get-Date).ToString("yyyyMMdd")
    cd copia
    mkdir ($fecha) -force
}

crearestructura

function copiararchivos()
{
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha -force
    }
}

copiararchivos

function recuperar
{
  param($fichero)
  begin
  {
  }
  process
  {
    Expand-Archive -LiteralPath $fichero -DestinationPath desco\
  }
  end
  {
  }
}

recuperar .\comprimido.zip

##############################################################################

##########################
# Función compleja
##########################
function copiaseguridad
{
  param()
  begin
  {
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force
    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir copia\$fecha -force
  }
  process
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha\ -force
    }
  }
  end
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls copia\$fecha
    Compress-Archive -LiteralPath copia\$fecha –CompressionLevel Optimal -DestinationPath comprimido.zip -Force
  }
}
copiaseguridad
```
- Se ha producido una infección en un sistema operativo Windows,
  - ¿qué elementos comprobarías para detectar dicha infección?
      - https://www.jesusninoc.com/07/11/analisis-de-procesos-y-conexiones-de-red-con-powershell/
  - ¿cómo impides que se produzcan infecciones el sistema operativo?
  - ¿Windows dispone de herramientas centralizadas para evitarlo?

```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```
  
- Explica todo el proceso para realizar una clonación.
- Explica todo lo que sepas sobre permisos en Windows.
- ¿Cómo puedes hacer una sincronización en Linux?, ¿puedes hacerla entre equipos?, ¿cómo?
- ¿Un driver falla, qué haces para arrancar el sistema?
- ¿Un componente gráfico, qué haces para arrancar el sistema?
- Se puede lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
- Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
    - https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
- Explica para qué sirven las auditoría y qué relación tiene con los permisos.
- ¿Qué hace el siguiente script? (explica en detalle el código)
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

-----------------

# Modelo 4

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 5

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 6


## Explicar y realizar un script para cada una de las siguientes situaciones:

1. Cómo puedes saber quién accede a una carpeta compartida en Linux.
2. Realiza un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
    - Windows o Linux.
    - Dejar programada la acción.
    - Cifrar el contenido, método sencillo o complicado.
    - Dejar la carpeta oculta, comando attrib.
    - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
3. Puedes explicar algún sistema distribuido que relacione las cosas que hemos visto en clase.
4. ¿Cómo puedes hacer una sincronización en Linux?, ¿cómo?
5. Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?

## Ayuda
### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS)
https://www.jesusninoc.com/06/04/listar-procesos-de-powershell-con-node-powershell-nodejs/

### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS) Y MOSTRARLOS EN UNA WEB CON EXPRESS
https://www.jesusninoc.com/07/15/listar-procesos-de-powershell-con-node-powershell-node-js-y-mostrarlos-en-una-web-con-express/

### Ejemplo de NODE.JS (Crear una página web con información sobre cada equipo)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()
 
let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('$ComputerSystem=Get-WmiObject Win32_ComputerSystem;$BaseBoard=Get-WmiObject Win32_BaseBoard;$BIOS=Get-WmiObject Win32_BIOS;$Processor=Get-WmiObject Win32_Processor;[PSCustomObject]@{ Model = $ComputerSystem.Model; ManufacturerBoard = $BaseBoard.Manufacturer; BIOSVersion = $BIOS.SMbiosbiosversion; BIOSSerialNumber = $BIOS.serialnumber; ManufacturerProcessor=$Processor.Manufacturer; MaxClockSpeed=$Processor.MaxClockSpeed} | ConvertTo-Html')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});
 
app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

### Ejemplo de NODE.JS (Crear una página web con información sobre procesos)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()

let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('Get-Process | ConvertTo-Html -Property Name, Path, Company')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/procesos', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});

let ps2 = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps2.addCommand('Get-Service | ConvertTo-Html -Property Name, Path, Company')
ps2.invoke()
.then(output => {
  console.log(output);
  app.get('/servicios', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps2.dispose();
});

app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

------------
------------

# Examen liberatorio

- El proceso que más consume tiene un cambio de integridad, crear una función que realiza dicha comprobación.
- Crear un log de sistema cuando hay un cambio de integridad.
- Un software que se va a instalar tiene un ejecutable cuya integridad es errónea.
- Detectar que un equipo no se ha añadido a un Dominio.
- Mostrar un objeto con toda la información de todos los elementos que hay en un Directorio Activo.
- Detectar cómo se ha propagado un virus en carpetas compartidas generando una entrada en un log del sistema.
- Comprobar que ha cambiado un permiso utlizando auditoría.
- Mostrar un mensaje si el tamaño de una carpeta compatida supera el 80%.
- Crear una entrada en un registro del visor de eventos si hay un intento de acceso a un puerto que está cerrado.

------------
------------

# Correción examen liberatorio

- El proceso que más consume tiene un cambio de integridad, crear una función que realiza dicha comprobación.
```PowerShell
(Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash | Out-File inte.txt

$resultado = (Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash
if((Get-Content .\inte.txt) -eq $resultado)
{
    "es igual"
}
else
{
    "no es igual"
}
```
- Crear un log de sistema cuando hay un cambio de integridad.
```PowerShell
(Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash | Out-File inte.txt

function comprobar ($integridadbuena)
{
    $resultado = (Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash
    if($integridadbuena -eq $resultado)
    {
        "es igual"
    }
    else
    {
       Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" 
       -EventID 916 -EntryType Information -Message "Cambio integridad" 
       -Category 2 -RawData 10,20
    }
}

comprobar (Get-Content .\inte.txt)
```
- Un software que se va a instalar tiene un ejecutable cuya integridad es errónea.
```PowerShell
foreach($programa in ls "C:\Program Files (x86)\Cisco Packet Tracer 6.1.1sv\bin\*.exe")
{
    (Get-FileHash $programa).path+","+(Get-FileHash $programa).hash | Out-File resultahas.txt -Append
}
```
- Detectar que un equipo no se ha añadido a un Dominio.
```PowerShell
$equipo = ""

function comprobar ($equipo)
{
    $ComputerName = $env:COMPUTERNAME
    $computer = [ADSI]"WinNT://$($ComputerName),computer"
    foreach($equipito in $computer)
    {
        if($equipito.Path -match $equipo)
        {
            "es igual"
        }
    }
}

comprobar FP_LHR_19
```
- Mostrar un objeto con toda la información de todos los elementos que hay en un Directorio Activo.
```PowerShell
[PSCustomObject]@{
 usuarios = Get-LocalUser
 grupos = Get-LocalGroup
}
```
- Detectar cómo se ha propagado un virus en carpetas compartidas generando una entrada en un log del sistema.
- Comprobar que ha cambiado un permiso utlizando auditoría.
- Mostrar un mensaje si el tamaño de una carpeta compatida supera el 80%.
```PowerShell
$total = 100

if((Get-ChildItem C:\Users\adminfp\Desktop\fallo | Measure-Object Length -Sum).Sum -lt $total*0.8)
{
    "menor"
}
```
- Crear una entrada en un registro del visor de eventos si hay un intento de acceso a un puerto que está cerrado.

------------------
------------------

# Examen liberatorio

- Leer fichero
- Clasificación de informes

------------
------------

# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Casos de introducción
## - Preparar un equipo
* https://www.jesusninoc.com/04/22/instalacion-de-sistemas-operativos/
## - Analizar licencias
* https://www.jesusninoc.com/12/02/obtener-serial-de-windows-con-powershell/
## - Administración remota
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-01-16.md
## - Inventario
* https://www.jesusninoc.com/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/
## - Batería
* https://www.jesusninoc.com/02/27/obtener-un-informe-detallado-del-consumo-de-la-bateria-en-windows-desde-powershell/
## - Reemplazar espacios en fichero JPG
## - Detectar un problema de red
## - Detectar en los logs que hay intentos de obtener el fichero passwd
* https://www.jesusninoc.com/05/08/consulta-para-ver-intentos-de-obtener-el-fichero-passwd/
### Solución con una query
```PowerShell
.\LogParser.exe "SELECT * FROM 'C:\xampp\apache\logs\access.log' where text like '%passwd%'"
```

------------------
------------------

# Introducción al examen final

## Opción 1

### El departamento de recursos humanos envía el siguiente fichero...
```
nombre;apellido;password;grupo;ou;appbloqueada
juan;sinmiedo;P@ss1wordA;asir;asir;notepad
laura;valiente;P@ss1wordA;af;af;mspaint
```

#### - Nivel 1: crear un script que permita realizar todas las tareas que aparecen en el fichero.
#### - Nivel 2: crear un script que permita realizar las operaciones de forma ordenada.
#### - Nivel 3: crear un script que permita realizar las operaciones utilizando UDP.

## Opción 2

### Crear la estructura de red del Centro leyendo de un fichero, teniendo en cuenta:
- Hay seis grupos de clases, seis unidades organizativas
- Hay que crear usuarios y grupos para cada clase
- Hay que deshabilitar usuarios y moverlos a la unidad organizativa de los deshabilitados
- Borrar unidades organizativas
- Crear una carpeta para cada usuario

------------
------------

# Trabajo para optar al 10 y a MH
### Utilizando sockets comunicar un cliente con un servidor y aplicar el mayor número de conceptos vistos durante el curso:
- Crear una herramienta de control remoto.
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

--------------

## Ayuda
### Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

## Ayuda avanzada
### Pedir el nombre de un proceso y mostrar información del proceso mediante PowerShell con Node-PowerShell, EJS (Embedded JavaScript), Body-parser y Express
https://www.jesusninoc.com/2018/06/10/pedir-el-nombre-de-un-proceso-y-mostrar-informacion-del-proceso-mediante-powershell-con-node-powershell-ejs-body-parser-y-express-node-js/

### Build a Weather Website in 30 minutes with Node.js + Express + OpenWeather
https://codeburst.io/build-a-weather-website-in-30-minutes-with-node-js-express-openweather-a317f904897b

--------------

## Ejemplo de trabajo

### Realizar operaciones en un equipo remoto

```PowerShell
cls
write-host "Ip del ordenador remoto"
$ipR=read-host

##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('cls')"
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

while (1)
{

cls

Write-Host "Seleccione una opcion"

echo "1 - Sistema de archivos"
echo "2 - Agregar/eliminar software"
echo "3 - Actualizacion"
echo "4 - Gestion de procesos"
echo "5 - Programacion de tareas"
echo "6 - Gestion de usuarios"
echo "7 - Gestion de almacenamiento"
echo "8 - Gestion de red"
echo "9 - Copias de seguridad"
echo "10 - Reparacion del sistema"
echo "11 - Rendimiento del sistema"
echo "12 - Salir"

$prue1 = Read-Host
switch ( $prue1 )
    {
        1{
            cls
            Write-Host "Seleccione una opcion"
            echo "1 - Listar"
            echo "2 - Crear"
            echo "3 - Abrir"
            echo "4 - Eliminar"
            $selcec=Read-Host
            switch ( $selcec )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=[Text.Encoding]::ASCII.GetBytes('Get-ChildItem')
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                2{
                    $type=Read-Host "Escriba que tipo desea crear (File o Directory)"
                    $name=Read-Host "Escriba el nombre del $type"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Item -ItemType $type -Name $name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                3{
                    $name1=Read-Host "Nombre del archivo que desea abrir"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('start $name1')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                4{
                    ls
                    $name2=Read-Host "¿Qué desea eliminar?"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-Item $name2')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }                   
        }
        2{
            cls
            $nombre=Read-Host "Introduzca nombre del .msi que desee instalar"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('msiexec.exe /package C:\windows\Installer\($nombre)')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        Pause
        }
        3{
            cls
            echo "1 - Instalar"
            echo "2 - Desinstalar"
            Write-Host "Seleccione una opción"
            $actuali=Read-Host
            switch ($actuali)
            {
                1{
                    Write-Host "Como desea que se realize"
                    echo "1 - Normal"
                    echo "2 - En silencio"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            Write-Host "Escriba el nombre de la actualizacion"
                            $nombre=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                           
                        }
                        2{
                            Write-Host "Eliga la opción desea"
                            echo "1 - No reiniciarse al terminar"
                            echo "2 - Pedir confirmación antes de reiniciar"
                            echo "3 - Obligar a que se cierren todas las aplicaciones y se reinicie"
                            $Smodo=Read-Host
                            $Nombre=Read-Host
                            switch($Smodo)
                            {
                                1{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()
                                    
                                }
                                2{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /warnrestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                                3{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /forcerestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                            }
                        }
                    }
                }
                2{
                    cls
                    echo "1 - Normal"
                    echo "2 - Paquete asociado con el número de actualización"
                    Write-Host "Seleccione una opción"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                        2{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall /kb')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                    }
            }
            }
            puase
        }
        4{
            cls
            echo "1 - Iniciar un proceso"
            echo "2 - Mostrar solo Nombres"
            echo "3 - Mostrar proceso de cierto programa"

            $sele=Read-Host
            switch ( $sele )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                } 
                2 {
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | select Name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3 {
                    $selprog=Read-Host "Escriba el nombre del programa"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | Select-String $selprog')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
        5{
            cls
            $program=Read-Host "que programa desea abrir"
            $time=Read-Host "a que hora"
            $nomre=Read-Host "escriba el nombre de la tarea"
            $action=New-ScheduledTaskAction -Execute $program
            $trigger=New-ScheduledTaskTrigger -Daily -At $time
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Register-ScheduledTask -Action $action -Trigger $trigger -TaskName $nomre')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()           
            Pause
            
        }
        6{
            cls
            echo "1 - Crear usuario"
            echo "2 - Eliminar usuario"
            echo "3 - Crear grupo"
            echo "4 - Ver miembros de un grupo"
            echo "5 - Eliminar grupo"
            $opcion=Read-Host "Eliga una opcion"
            switch ($opcion)
            {
            1{
                $nameuser=Read-Host "Nomre del nuevo usuario"
                $pass=Read-Host "Introduzca contraseña"
                $pass1=ConvertTo-SecureString $pass -asplaintext -force
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalUser $nameuser -Password $pass1')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            2{
                $usuer=Read-Host "Nombre del usuario"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-LocalUser -Name $usuer')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            3{
                $group=Read-Host "Nombre para el grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalGroup -Name $group')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            4{
                $Ngroup=Read-Host "Nombre del grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Ngroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            5{
                $Rgroup=Read-Host "Nombre del grupo que vaya a eliminar"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Rgroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            }
        }
        7{
            cls
            echo "1 - Particionar"
            echo "2 - Desfragmentar"
            echo "3 - Convertir sistemas de archivo"
            echo "4 - Cifrar"
            echo "5 - Descifrar"
            Write-Host  "Seleccione una opción"
            $almacenamiento=Read-Host
            switch ($almacenamiento)
            {
                1{
                    Write-Host "ADVERTENCIA: Nunca poner el numero '0'"
                    $NumeroD=Read-Host "Introduzca número del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Partition -DiskNumber $NumeroD -UseMaximumSize -AssignDriveLetter')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    $letra=Read-Host "Letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Optimize-Volume $letra -Defrag')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Disable-BitLocker 
                    Pause
                }
                3{
                    $letra=Read-Host "Letra del disco"
                    $tipo=Read-Host "Que formato desea"                    
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Format-Volume -DriveLetter $letra -FileSystem $tipo')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                4{
                    $letra=Read-Host "Inroduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Enable-BitLocker -MountPoint $letra -RecoveryPasswordProtector -UsedSpaceOnly -Verbose')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                5{
                    $letra=Read-Host "Introduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Disable-BitLocker -MountPoint $letra')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
            }
              
        }
        }
        8{
            cls
            echo "1 - Saber ip"
            echo "2 - Hacer ping"
            $op=Read-Host "Seleccione una opcion"
            Switch ( $op )
            {
            1{
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ipconfig')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            2{
                $ip=Read-Host "Introduzca IPv4"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ping $ip')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            }
        }
        9{
            cls
            Write-Host "Se recomienda que ponga la ruta y para quedarsela usted la meta en una carpeta compartida"
            $namea=Read-Host "Nombre del archivo que desea hacer copia de seguridad"
            $ruta=Read-Host "Ruta donde desea que este la copia de seguridad"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Copy-Item $namea $ruta')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()            
            Pause
        }
        10{
            cls
            Write-Host "Seleccione una opción"
            echo "1 - Ver puntos de restauracion"
            echo "2 - Restaurar un punto"
            $opcion=Read-Host
            switch ($opcion)
            {
                1{        
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                }
                2{
                    Write-Host "Seleccione una opción"
                    echo "1 - Ultimo punto"
                    echo "2 - Restaura cierto punto"
                    $opcion=Read-Host
                    switch ($opcion)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint -LastStatus')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }

                        2{
                            Write-Host "Ponga el numero de restauración"
                            $punto=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Restore-Computer -RestorePoint $punto')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()                   
                        }
                    }
                }
            }
            Pause
        }
        11{
            cls
            echo "1 - Monitorizar procesos"
            echo "2 - Monitorizar procesos Avanzado"
            echo "3 - Ver todos los nombres de los contadores de rendimiento"
            $seleccionar=Read-Host "Seleccione una opción"
            switch ( $seleccionar )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port
                    )
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Counter -ListSet * | Sort-Object CounterSetName | Format-Table CounterSetName')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
}
if( $prue1 -eq "12" )
        {
            cls
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('break')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            break
        }
}
```

-----------
-----------

# Modelos de examen de la asignatura de Implantación de Sistemas Operativos (ISO) de 1º de Administración de Sistemas Informáticos en Red (ASIR) tercera evaluación
- Modelo 1 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-1
- Modelo 2 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-2
- Modelo 3 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-3
- Modelo 4 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-4
- Modelo 5 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-5
- Modelo 6 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-6

-----------------

# Modelo 1

## Tener en cuenta:
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## 1. Analizar ficheros DLL en todos los equipos de la red
```PowerShell
123..125 | %{"192.168.104." + $_}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
$ruta
}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.jes"
ls $ruta
}

1..40 |  %{Invoke-Command -ComputerName ("192.168.204." + $_) -ScriptBlock {hostname}}

Invoke-Command -ComputerName dc1 -ScriptBlock {hostname}

gc .\equipos1.txt | % {
    $llistar="\\"+$_+"\c$"
    ls $llistar | select name,FullName
} | Group-Object name | select Count,Group | where count -eq 1
```
### Enable and Use Remote Commands in Windows PowerShell
https://technet.microsoft.com/en-us/library/ff700227.aspx
### How to Add a Computer to the TrustedHosts List
```PowerShell
set-item wsman:\localhost\Client\TrustedHosts -value "ABANTO"
```
### Listar funciones exportadas de un archivo DLL con DUMPBIN desde PowerShell
https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/

## 2. Analizar ficheros DLL en todos los equipos de la red, comprobar que ha cambiado una integridad y copiar el fichero que ha cambiado
### En PowerShell
```PowerShell
mkdir dlls

cd dlls

"dll1" | Out-File dll1.dll
"dll2" | Out-File dll2.dll

# Recorrrer una a una dll
ls *.dll | %{$_}

# Hacer hash de cada dll
ls *.dll | %{Get-FileHash $_.FullName | Select-Object Hash}

# Hacer hash de cada dll ruta por red
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path}

# Guardar hash
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path | Out-File listado.txt -Append}

# Ver listado
gc .\listado.txt

# Modificar dll y detectar el cambio, después mover la dll, solución: el hash de cada dll no se encuentra en el fichero listado.txt, eso quiere decir que se ha modificado y hay que copiar a la carpeta compartida en Linux
# Modificar dll
"dll6" | Out-File dll1.dll

ls '\\localhost\c$\Users\juan\dlls' *.dll | %{
    if((gc .\listado.txt) -match (Get-FileHash $_.FullName | Select-Object Hash).hash)
    {
    }
    else
    {
        $_.Name
        "Dll se ha modificado"
    }
}


# Meter el código anterior en el recorrido que cada alumno tenga
123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
ls $ruta -recurse
}

# Almacenar el hash de la dll para todos los equipos de la red
foreach($equipo in gc .\equipos1.txt) {
    $llistar="\\"+$equipo+"\c$"
    ls $llistar -recurse *.dll | %{
        $valorse = Get-FileHash ($_ | select FullName).FullName
        $valorse.path+"|"+$valorse.Hash | Out-File hasehees.txt
    }
}

# Verificar si una dll no ha cambiado su hash
gc .\hasehees.txt | %{
    if($_.split("|")[0].contains("jawt.dll"))
    {
        if($_.split("|")[1] -eq (Get-FileHash "\\ABANTOS21\c$\Cache\pc-client.exe-16.3.0.37857\runtime\jre\bin\jawt.dll" | select hash).hash)
        {
            "CORRECTO"
        }
    }
}
```
#### Se puede crear una dll y modificar una función para comprobar que la integridad falla
* https://www.jesusninoc.com/11/26/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-ejecute-un-cmdlet-de-powershell/
* https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/
* https://www.jesusninoc.com/04/21/obtener-los-nombres-de-las-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell-explicacion-paso-a-paso-del-script/

### En Linux
https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

## 3. Puedes saber qué fichero DLL están funcionando en el equipo utilizando la red
```PowerShell
(Get-Process -ComputerName .).Modules
(Get-Process -ComputerName .).Modules | where ModuleName -eq  sxs.dll
```

## 4. Detectar que una aplicación tiene tráfico de red (filtro por puerto)
### Tshark Command Examples
https://linuxsimba.com/tshark-examples

```PowerShell
$filterUDP = ''
$filterTCP = ''
ps | where ProcessName -eq 'chrome' | %{
    Get-NetUDPEndpoint | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterUDP = $filterUDP+'(udp.port == '+$_.LocalPort+') or'
    }
    
    Get-NetTCPConnection | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterTCP = $filterTCP+'(tcp.port == '+$_.LocalPort+') or'
    }
    
    
}
$filterUDP = $filterUDP.substring(0, $filterUDP.Length-3)
$filterTCP = $filterTCP.substring(0, $filterTCP.Length-3)

$filter = $filterUDP+' or '+$filterTCP

net use \\192.168.104.129\Prueba-share-samba /user:root 1234

.\tshark.exe -i 'ethernet 2' -Y $filter > \\192.168.104.129\Prueba-share-samba\test.txt
```

-----------------

# Modelo 2

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web periódico

### Eres el nuevo administrador de sistemas del diario el Universo. El diario funciona así: los periodistas sus ficheros HTML a sus carpetas en la red mediante un interfaz web (una Intranet). Cada periodista ve sus propios ficheros y no ve los de sus compañeros. Por ejemplo: Juan crea la página 1 del periódico y sube dicha página al servidor web.

## Resuelve lo siguiente:
1) Junta todas las páginas del periódico de todos los periodistas.
```PowerShell
mkdir usuario1; cd usuario1
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina1.html
cd ..
mkdir usuario2; cd usuario2
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina2.html
cd ..

ls *.html -recurse | %{
    $periodidcocomp = $periodidcocomp + (gc $_)
}

$periodidcocomp | out-file periodicocompleto.html
```
2) Haz copias de seguridad para diferentes momentos del día y al final del día haz copia de todo el periódico completo.
```PowerShell
(Get-Date).ToString("yyyyMMddhh")

$fecha = (Get-Date).ToString("yyyyMMddhh")
mkdir ($fecha) -force
cd $fecha

ls *.html -recurse | %{
    copy $_ $fecha
}
```
3) Incidencia. Alguien ha mandado imprimir el periódico entero. Tienes que pararlo porque no es el momento de imprimirlo.
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
#$perio = gc .\periodicocompleto.html
$b=[Text.Encoding]::ASCII.GetBytes("gc perio.html | out-printer")
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
##Server
while(1)
{
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
if([Text.Encoding]::ASCII.GetString($content) | select-string "print")
{
    "ha mandado imprimir"
}
}
```
4) Opcional. El periódico automático. Crear cada página HTML utilizando una base de datos
* https://www.jesusninoc.com/09/20/crear-un-fichero-html-con-el-contenido-de-la-tabla-posts-de-wordpress-con-powershell/

-----------------

# Modelo 3

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
- Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
```PowerShell
Get-EventLog -LogName security | select Message | select-string "\\localhost\ejemplo"
```
- Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
    - https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/
    - https://www.jesusninoc.com/03/12/select-files-between-two-dates-and-copy-them/
  - Dejar programada la acción.
    - https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
  - Comprimir y descomprimir
    - https://www.jesusninoc.com/03/15/create-new-compress-archive-file/
    - https://www.jesusninoc.com/02/14/descomprimir-archivos/
  - Cifrar el contenido, método sencillo o complicado.
    - https://www.jesusninoc.com/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación
  - Funciones simples y complejas
```PowerShell
##########################
# Funciones simples
##########################
function crearestructura()
{
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force

    $fecha = (Get-Date).ToString("yyyyMMdd")
    cd copia
    mkdir ($fecha) -force
}

crearestructura

function copiararchivos()
{
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha -force
    }
}

copiararchivos

function recuperar
{
  param($fichero)
  begin
  {
  }
  process
  {
    Expand-Archive -LiteralPath $fichero -DestinationPath desco\
  }
  end
  {
  }
}

recuperar .\comprimido.zip

##############################################################################

##########################
# Función compleja
##########################
function copiaseguridad
{
  param()
  begin
  {
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force
    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir copia\$fecha -force
  }
  process
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha\ -force
    }
  }
  end
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls copia\$fecha
    Compress-Archive -LiteralPath copia\$fecha –CompressionLevel Optimal -DestinationPath comprimido.zip -Force
  }
}
copiaseguridad
```
- Se ha producido una infección en un sistema operativo Windows,
  - ¿qué elementos comprobarías para detectar dicha infección?
      - https://www.jesusninoc.com/07/11/analisis-de-procesos-y-conexiones-de-red-con-powershell/
  - ¿cómo impides que se produzcan infecciones el sistema operativo?
  - ¿Windows dispone de herramientas centralizadas para evitarlo?

```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```
  
- Explica todo el proceso para realizar una clonación.
- Explica todo lo que sepas sobre permisos en Windows.
- ¿Cómo puedes hacer una sincronización en Linux?, ¿puedes hacerla entre equipos?, ¿cómo?
- ¿Un driver falla, qué haces para arrancar el sistema?
- ¿Un componente gráfico, qué haces para arrancar el sistema?
- Se puede lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
- Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
    - https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
- Explica para qué sirven las auditoría y qué relación tiene con los permisos.
- ¿Qué hace el siguiente script? (explica en detalle el código)
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

-----------------

# Modelo 4

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 5

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 6


## Explicar y realizar un script para cada una de las siguientes situaciones:

1. Cómo puedes saber quién accede a una carpeta compartida en Linux.
2. Realiza un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
    - Windows o Linux.
    - Dejar programada la acción.
    - Cifrar el contenido, método sencillo o complicado.
    - Dejar la carpeta oculta, comando attrib.
    - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
3. Puedes explicar algún sistema distribuido que relacione las cosas que hemos visto en clase.
4. ¿Cómo puedes hacer una sincronización en Linux?, ¿cómo?
5. Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?

## Ayuda
### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS)
https://www.jesusninoc.com/06/04/listar-procesos-de-powershell-con-node-powershell-nodejs/

### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS) Y MOSTRARLOS EN UNA WEB CON EXPRESS
https://www.jesusninoc.com/07/15/listar-procesos-de-powershell-con-node-powershell-node-js-y-mostrarlos-en-una-web-con-express/

### Ejemplo de NODE.JS (Crear una página web con información sobre cada equipo)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()
 
let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('$ComputerSystem=Get-WmiObject Win32_ComputerSystem;$BaseBoard=Get-WmiObject Win32_BaseBoard;$BIOS=Get-WmiObject Win32_BIOS;$Processor=Get-WmiObject Win32_Processor;[PSCustomObject]@{ Model = $ComputerSystem.Model; ManufacturerBoard = $BaseBoard.Manufacturer; BIOSVersion = $BIOS.SMbiosbiosversion; BIOSSerialNumber = $BIOS.serialnumber; ManufacturerProcessor=$Processor.Manufacturer; MaxClockSpeed=$Processor.MaxClockSpeed} | ConvertTo-Html')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});
 
app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

### Ejemplo de NODE.JS (Crear una página web con información sobre procesos)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()

let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('Get-Process | ConvertTo-Html -Property Name, Path, Company')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/procesos', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});

let ps2 = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps2.addCommand('Get-Service | ConvertTo-Html -Property Name, Path, Company')
ps2.invoke()
.then(output => {
  console.log(output);
  app.get('/servicios', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps2.dispose();
});

app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

------------
------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------

# PCAP (container of PCAP captures mapped to the relevant attack tactic)
* https://github.com/sbousseaden/PCAP-ATTACK

--------------------

# USB
## USBPcap – USB Packet capture for Windows
https://www.jesusninoc.com/2016/05/01/usbpcap-usb-packet-capture-for-windows/
## Wireshark and USB
https://isc.sans.edu/forums/diary/Wireshark+and+USB/23457/
## Hackers exploit casino's smart thermometer to steal database info
https://mashable.com/2018/04/15/casino-smart-thermometer-hacked/
## Logran robar datos de un ordenador a través del cableado eléctrico
https://www.redeszone.net/2018/04/13/logran-robar-datos-ordenador-traves-del-cableado-electrico/

----------
----------

# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Rendimiento del hardware
* https://www.jesusninoc.com/02/27/obtener-un-informe-detallado-del-consumo-de-la-bateria-en-windows-desde-powershell/

---------
---------

# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Casos de introducción
## - Preparar un equipo
* https://www.jesusninoc.com/04/22/instalacion-de-sistemas-operativos/
## - Analizar licencias
* https://www.jesusninoc.com/12/02/obtener-serial-de-windows-con-powershell/
## - Administración remota
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-01-16.md
## - Inventario
* https://www.jesusninoc.com/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/
## - Reemplazar espacios en fichero JPG
## - Detectar un problema de red
## - Detectar en los logs que hay intentos de obtener el fichero passwd
* https://www.jesusninoc.com/05/08/consulta-para-ver-intentos-de-obtener-el-fichero-passwd/
### Solución con una query
```PowerShell
.\LogParser.exe "SELECT * FROM 'C:\xampp\apache\logs\access.log' where text like '%passwd%'"
```

------------
------------

# Introducción al examen liberatorio

## Opción 1

### El departamento de recursos humanos envía el siguiente fichero...
```
nombre;apellido;password;grupo;ou;appbloqueada
juan;sinmiedo;P@ss1wordA;asir;asir;notepad
laura;valiente;P@ss1wordA;af;af;mspaint
```

#### - Nivel 1: crear un script que permita realizar todas las tareas que aparecen en el fichero.
#### - Nivel 2: crear un script que permita realizar las operaciones de forma ordenada.
#### - Nivel 3: crear un script que permita realizar las operaciones utilizando UDP.

## Opción 2

### Crear la estructura de red del Centro leyendo de un fichero, teniendo en cuenta:
- Hay seis grupos de clases, seis unidades organizativas
- Hay que crear usuarios y grupos para cada clase
- Hay que deshabilitar usuarios y moverlos a la unidad organizativa de los deshabilitados
- Borrar unidades organizativas
- Crear una carpeta para cada usuario

------------
------------

# Trabajo para optar al 10 y a MH
### Utilizando sockets comunicar un cliente con un servidor y aplicar el mayor número de conceptos vistos durante el curso:
- Crear una herramienta de control remoto.
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

--------------

## Ayuda
### Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

## Ayuda avanzada
### Pedir el nombre de un proceso y mostrar información del proceso mediante PowerShell con Node-PowerShell, EJS (Embedded JavaScript), Body-parser y Express
https://www.jesusninoc.com/2018/06/10/pedir-el-nombre-de-un-proceso-y-mostrar-informacion-del-proceso-mediante-powershell-con-node-powershell-ejs-body-parser-y-express-node-js/

### Build a Weather Website in 30 minutes with Node.js + Express + OpenWeather
https://codeburst.io/build-a-weather-website-in-30-minutes-with-node-js-express-openweather-a317f904897b

--------------

## Ejemplo de trabajo

### Realizar operaciones en un equipo remoto

```PowerShell
cls
write-host "Ip del ordenador remoto"
$ipR=read-host

##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('cls')"
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

while (1)
{

cls

Write-Host "Seleccione una opcion"

echo "1 - Sistema de archivos"
echo "2 - Agregar/eliminar software"
echo "3 - Actualizacion"
echo "4 - Gestion de procesos"
echo "5 - Programacion de tareas"
echo "6 - Gestion de usuarios"
echo "7 - Gestion de almacenamiento"
echo "8 - Gestion de red"
echo "9 - Copias de seguridad"
echo "10 - Reparacion del sistema"
echo "11 - Rendimiento del sistema"
echo "12 - Salir"

$prue1 = Read-Host
switch ( $prue1 )
    {
        1{
            cls
            Write-Host "Seleccione una opcion"
            echo "1 - Listar"
            echo "2 - Crear"
            echo "3 - Abrir"
            echo "4 - Eliminar"
            $selcec=Read-Host
            switch ( $selcec )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=[Text.Encoding]::ASCII.GetBytes('Get-ChildItem')
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                2{
                    $type=Read-Host "Escriba que tipo desea crear (File o Directory)"
                    $name=Read-Host "Escriba el nombre del $type"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Item -ItemType $type -Name $name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                3{
                    $name1=Read-Host "Nombre del archivo que desea abrir"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('start $name1')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                4{
                    ls
                    $name2=Read-Host "¿Qué desea eliminar?"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-Item $name2')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }                   
        }
        2{
            cls
            $nombre=Read-Host "Introduzca nombre del .msi que desee instalar"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('msiexec.exe /package C:\windows\Installer\($nombre)')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        Pause
        }
        3{
            cls
            echo "1 - Instalar"
            echo "2 - Desinstalar"
            Write-Host "Seleccione una opción"
            $actuali=Read-Host
            switch ($actuali)
            {
                1{
                    Write-Host "Como desea que se realize"
                    echo "1 - Normal"
                    echo "2 - En silencio"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            Write-Host "Escriba el nombre de la actualizacion"
                            $nombre=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                           
                        }
                        2{
                            Write-Host "Eliga la opción desea"
                            echo "1 - No reiniciarse al terminar"
                            echo "2 - Pedir confirmación antes de reiniciar"
                            echo "3 - Obligar a que se cierren todas las aplicaciones y se reinicie"
                            $Smodo=Read-Host
                            $Nombre=Read-Host
                            switch($Smodo)
                            {
                                1{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()
                                    
                                }
                                2{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /warnrestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                                3{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /forcerestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                            }
                        }
                    }
                }
                2{
                    cls
                    echo "1 - Normal"
                    echo "2 - Paquete asociado con el número de actualización"
                    Write-Host "Seleccione una opción"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                        2{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall /kb')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                    }
            }
            }
            puase
        }
        4{
            cls
            echo "1 - Iniciar un proceso"
            echo "2 - Mostrar solo Nombres"
            echo "3 - Mostrar proceso de cierto programa"

            $sele=Read-Host
            switch ( $sele )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                } 
                2 {
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | select Name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3 {
                    $selprog=Read-Host "Escriba el nombre del programa"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | Select-String $selprog')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
        5{
            cls
            $program=Read-Host "que programa desea abrir"
            $time=Read-Host "a que hora"
            $nomre=Read-Host "escriba el nombre de la tarea"
            $action=New-ScheduledTaskAction -Execute $program
            $trigger=New-ScheduledTaskTrigger -Daily -At $time
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Register-ScheduledTask -Action $action -Trigger $trigger -TaskName $nomre')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()           
            Pause
            
        }
        6{
            cls
            echo "1 - Crear usuario"
            echo "2 - Eliminar usuario"
            echo "3 - Crear grupo"
            echo "4 - Ver miembros de un grupo"
            echo "5 - Eliminar grupo"
            $opcion=Read-Host "Eliga una opcion"
            switch ($opcion)
            {
            1{
                $nameuser=Read-Host "Nomre del nuevo usuario"
                $pass=Read-Host "Introduzca contraseña"
                $pass1=ConvertTo-SecureString $pass -asplaintext -force
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalUser $nameuser -Password $pass1')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            2{
                $usuer=Read-Host "Nombre del usuario"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-LocalUser -Name $usuer')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            3{
                $group=Read-Host "Nombre para el grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalGroup -Name $group')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            4{
                $Ngroup=Read-Host "Nombre del grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Ngroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            5{
                $Rgroup=Read-Host "Nombre del grupo que vaya a eliminar"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Rgroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            }
        }
        7{
            cls
            echo "1 - Particionar"
            echo "2 - Desfragmentar"
            echo "3 - Convertir sistemas de archivo"
            echo "4 - Cifrar"
            echo "5 - Descifrar"
            Write-Host  "Seleccione una opción"
            $almacenamiento=Read-Host
            switch ($almacenamiento)
            {
                1{
                    Write-Host "ADVERTENCIA: Nunca poner el numero '0'"
                    $NumeroD=Read-Host "Introduzca número del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Partition -DiskNumber $NumeroD -UseMaximumSize -AssignDriveLetter')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    $letra=Read-Host "Letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Optimize-Volume $letra -Defrag')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Disable-BitLocker 
                    Pause
                }
                3{
                    $letra=Read-Host "Letra del disco"
                    $tipo=Read-Host "Que formato desea"                    
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Format-Volume -DriveLetter $letra -FileSystem $tipo')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                4{
                    $letra=Read-Host "Inroduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Enable-BitLocker -MountPoint $letra -RecoveryPasswordProtector -UsedSpaceOnly -Verbose')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                5{
                    $letra=Read-Host "Introduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Disable-BitLocker -MountPoint $letra')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
            }
              
        }
        }
        8{
            cls
            echo "1 - Saber ip"
            echo "2 - Hacer ping"
            $op=Read-Host "Seleccione una opcion"
            Switch ( $op )
            {
            1{
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ipconfig')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            2{
                $ip=Read-Host "Introduzca IPv4"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ping $ip')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            }
        }
        9{
            cls
            Write-Host "Se recomienda que ponga la ruta y para quedarsela usted la meta en una carpeta compartida"
            $namea=Read-Host "Nombre del archivo que desea hacer copia de seguridad"
            $ruta=Read-Host "Ruta donde desea que este la copia de seguridad"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Copy-Item $namea $ruta')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()            
            Pause
        }
        10{
            cls
            Write-Host "Seleccione una opción"
            echo "1 - Ver puntos de restauracion"
            echo "2 - Restaurar un punto"
            $opcion=Read-Host
            switch ($opcion)
            {
                1{        
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                }
                2{
                    Write-Host "Seleccione una opción"
                    echo "1 - Ultimo punto"
                    echo "2 - Restaura cierto punto"
                    $opcion=Read-Host
                    switch ($opcion)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint -LastStatus')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }

                        2{
                            Write-Host "Ponga el numero de restauración"
                            $punto=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Restore-Computer -RestorePoint $punto')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()                   
                        }
                    }
                }
            }
            Pause
        }
        11{
            cls
            echo "1 - Monitorizar procesos"
            echo "2 - Monitorizar procesos Avanzado"
            echo "3 - Ver todos los nombres de los contadores de rendimiento"
            $seleccionar=Read-Host "Seleccione una opción"
            switch ( $seleccionar )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port
                    )
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Counter -ListSet * | Sort-Object CounterSetName | Format-Table CounterSetName')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
}
if( $prue1 -eq "12" )
        {
            cls
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('break')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            break
        }
}
```

-----------
-----------

# Modelos de examen de la asignatura de Implantación de Sistemas Operativos (ISO) de 1º de Administración de Sistemas Informáticos en Red (ASIR) tercera evaluación
- Modelo 1 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-1
- Modelo 2 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-2
- Modelo 3 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-3
- Modelo 4 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-4
- Modelo 5 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-5
- Modelo 6 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-6

-----------------

# Modelo 1

## Tener en cuenta:
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## 1. Analizar ficheros DLL en todos los equipos de la red
```PowerShell
123..125 | %{"192.168.104." + $_}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
$ruta
}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.jes"
ls $ruta
}

1..40 |  %{Invoke-Command -ComputerName ("192.168.204." + $_) -ScriptBlock {hostname}}

Invoke-Command -ComputerName dc1 -ScriptBlock {hostname}

gc .\equipos1.txt | % {
    $llistar="\\"+$_+"\c$"
    ls $llistar | select name,FullName
} | Group-Object name | select Count,Group | where count -eq 1
```
### Enable and Use Remote Commands in Windows PowerShell
https://technet.microsoft.com/en-us/library/ff700227.aspx
### How to Add a Computer to the TrustedHosts List
```PowerShell
set-item wsman:\localhost\Client\TrustedHosts -value "ABANTO"
```
### Listar funciones exportadas de un archivo DLL con DUMPBIN desde PowerShell
https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/

## 2. Analizar ficheros DLL en todos los equipos de la red, comprobar que ha cambiado una integridad y copiar el fichero que ha cambiado
### En PowerShell
```PowerShell
mkdir dlls

cd dlls

"dll1" | Out-File dll1.dll
"dll2" | Out-File dll2.dll

# Recorrrer una a una dll
ls *.dll | %{$_}

# Hacer hash de cada dll
ls *.dll | %{Get-FileHash $_.FullName | Select-Object Hash}

# Hacer hash de cada dll ruta por red
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path}

# Guardar hash
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path | Out-File listado.txt -Append}

# Ver listado
gc .\listado.txt

# Modificar dll y detectar el cambio, después mover la dll, solución: el hash de cada dll no se encuentra en el fichero listado.txt, eso quiere decir que se ha modificado y hay que copiar a la carpeta compartida en Linux
# Modificar dll
"dll6" | Out-File dll1.dll

ls '\\localhost\c$\Users\juan\dlls' *.dll | %{
    if((gc .\listado.txt) -match (Get-FileHash $_.FullName | Select-Object Hash).hash)
    {
    }
    else
    {
        $_.Name
        "Dll se ha modificado"
    }
}


# Meter el código anterior en el recorrido que cada alumno tenga
123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
ls $ruta -recurse
}

# Almacenar el hash de la dll para todos los equipos de la red
foreach($equipo in gc .\equipos1.txt) {
    $llistar="\\"+$equipo+"\c$"
    ls $llistar -recurse *.dll | %{
        $valorse = Get-FileHash ($_ | select FullName).FullName
        $valorse.path+"|"+$valorse.Hash | Out-File hasehees.txt
    }
}

# Verificar si una dll no ha cambiado su hash
gc .\hasehees.txt | %{
    if($_.split("|")[0].contains("jawt.dll"))
    {
        if($_.split("|")[1] -eq (Get-FileHash "\\ABANTOS21\c$\Cache\pc-client.exe-16.3.0.37857\runtime\jre\bin\jawt.dll" | select hash).hash)
        {
            "CORRECTO"
        }
    }
}
```
#### Se puede crear una dll y modificar una función para comprobar que la integridad falla
* https://www.jesusninoc.com/11/26/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-ejecute-un-cmdlet-de-powershell/
* https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/
* https://www.jesusninoc.com/04/21/obtener-los-nombres-de-las-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell-explicacion-paso-a-paso-del-script/

### En Linux
https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

## 3. Puedes saber qué fichero DLL están funcionando en el equipo utilizando la red
```PowerShell
(Get-Process -ComputerName .).Modules
(Get-Process -ComputerName .).Modules | where ModuleName -eq  sxs.dll
```

## 4. Detectar que una aplicación tiene tráfico de red (filtro por puerto)
### Tshark Command Examples
https://linuxsimba.com/tshark-examples

```PowerShell
$filterUDP = ''
$filterTCP = ''
ps | where ProcessName -eq 'chrome' | %{
    Get-NetUDPEndpoint | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterUDP = $filterUDP+'(udp.port == '+$_.LocalPort+') or'
    }
    
    Get-NetTCPConnection | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterTCP = $filterTCP+'(tcp.port == '+$_.LocalPort+') or'
    }
    
    
}
$filterUDP = $filterUDP.substring(0, $filterUDP.Length-3)
$filterTCP = $filterTCP.substring(0, $filterTCP.Length-3)

$filter = $filterUDP+' or '+$filterTCP

net use \\192.168.104.129\Prueba-share-samba /user:root 1234

.\tshark.exe -i 'ethernet 2' -Y $filter > \\192.168.104.129\Prueba-share-samba\test.txt
```

------------
------------

# Modelo 2

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web periódico

### Eres el nuevo administrador de sistemas del diario el Universo. El diario funciona así: los periodistas crean sus ficheros HTML en sus carpetas en la red mediante un interfaz web (una Intranet). Cada periodista ve sus propios ficheros y no ve los de sus compañeros. Por ejemplo: Juan crea la página 1 del periódico y sube dicha página al servidor web.

## Resuelve lo siguiente:
1) Junta todas las páginas del periódico de todos los periodistas.
```PowerShell
mkdir usuario1; cd usuario1
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina1.html
cd ..
mkdir usuario2; cd usuario2
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina2.html
cd ..

ls *.html -recurse | %{
    $periodidcocomp = $periodidcocomp + (gc $_)
}

$periodidcocomp | out-file periodicocompleto.html
```
2) Haz copias de seguridad para diferentes momentos del día y al final del día haz copia de todo el periódico completo.
```PowerShell
(Get-Date).ToString("yyyyMMddhh")

$fecha = (Get-Date).ToString("yyyyMMddhh")
mkdir ($fecha) -force
cd $fecha

ls *.html -recurse | %{
    copy $_ $fecha
}
```
3) Incidencia. Alguien ha mandado imprimir el periódico entero. Tienes que pararlo porque no es el momento de imprimirlo.
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
#$perio = gc .\periodicocompleto.html
$b=[Text.Encoding]::ASCII.GetBytes("gc perio.html | out-printer")
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
##Server
while(1)
{
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
if([Text.Encoding]::ASCII.GetString($content) | select-string "print")
{
    "ha mandado imprimir"
}
}
```
4) Opcional. El periódico automático. Crear cada página HTML utilizando una base de datos
* https://www.jesusninoc.com/09/20/crear-un-fichero-html-con-el-contenido-de-la-tabla-posts-de-wordpress-con-powershell/

-----------------

# Modelo 3

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
- Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
```PowerShell
Get-EventLog -LogName security | select Message | select-string "\\localhost\ejemplo"
```
- Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
    - https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/
    - https://www.jesusninoc.com/03/12/select-files-between-two-dates-and-copy-them/
  - Dejar programada la acción.
    - https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
  - Comprimir y descomprimir
    - https://www.jesusninoc.com/03/15/create-new-compress-archive-file/
    - https://www.jesusninoc.com/02/14/descomprimir-archivos/
  - Cifrar el contenido, método sencillo o complicado.
    - https://www.jesusninoc.com/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación
  - Funciones simples y complejas
```PowerShell
##########################
# Funciones simples
##########################
function crearestructura()
{
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force

    $fecha = (Get-Date).ToString("yyyyMMdd")
    cd copia
    mkdir ($fecha) -force
}

crearestructura

function copiararchivos()
{
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha -force
    }
}

copiararchivos

function recuperar
{
  param($fichero)
  begin
  {
  }
  process
  {
    Expand-Archive -LiteralPath $fichero -DestinationPath desco\
  }
  end
  {
  }
}

recuperar .\comprimido.zip

##############################################################################

##########################
# Función compleja
##########################
function copiaseguridad
{
  param()
  begin
  {
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force
    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir copia\$fecha -force
  }
  process
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha\ -force
    }
  }
  end
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls copia\$fecha
    Compress-Archive -LiteralPath copia\$fecha –CompressionLevel Optimal -DestinationPath comprimido.zip -Force
  }
}
copiaseguridad
```
- Se ha producido una infección en un sistema operativo Windows,
  - ¿qué elementos comprobarías para detectar dicha infección?
      - https://www.jesusninoc.com/07/11/analisis-de-procesos-y-conexiones-de-red-con-powershell/
  - ¿cómo impides que se produzcan infecciones el sistema operativo?
  - ¿Windows dispone de herramientas centralizadas para evitarlo?

```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```
  
- Explica todo el proceso para realizar una clonación.
- Explica todo lo que sepas sobre permisos en Windows.
- ¿Cómo puedes hacer una sincronización en Linux?, ¿puedes hacerla entre equipos?, ¿cómo?
- ¿Un driver falla, qué haces para arrancar el sistema?
- ¿Un componente gráfico, qué haces para arrancar el sistema?
- Se puede lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
- Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
    - https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
- Explica para qué sirven las auditoría y qué relación tiene con los permisos.
- ¿Qué hace el siguiente script? (explica en detalle el código)
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

-----------------

# Modelo 4

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 5

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 6


## Explicar y realizar un script para cada una de las siguientes situaciones:

1. Cómo puedes saber quién accede a una carpeta compartida en Linux.
2. Realiza un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
    - Windows o Linux.
    - Dejar programada la acción.
    - Cifrar el contenido, método sencillo o complicado.
    - Dejar la carpeta oculta, comando attrib.
    - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
3. Puedes explicar algún sistema distribuido que relacione las cosas que hemos visto en clase.
4. ¿Cómo puedes hacer una sincronización en Linux?, ¿cómo?
5. Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?

## Ayuda
### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS)
https://www.jesusninoc.com/06/04/listar-procesos-de-powershell-con-node-powershell-nodejs/

### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS) Y MOSTRARLOS EN UNA WEB CON EXPRESS
https://www.jesusninoc.com/07/15/listar-procesos-de-powershell-con-node-powershell-node-js-y-mostrarlos-en-una-web-con-express/

### Ejemplo de NODE.JS (Crear una página web con información sobre cada equipo)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()
 
let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('$ComputerSystem=Get-WmiObject Win32_ComputerSystem;$BaseBoard=Get-WmiObject Win32_BaseBoard;$BIOS=Get-WmiObject Win32_BIOS;$Processor=Get-WmiObject Win32_Processor;[PSCustomObject]@{ Model = $ComputerSystem.Model; ManufacturerBoard = $BaseBoard.Manufacturer; BIOSVersion = $BIOS.SMbiosbiosversion; BIOSSerialNumber = $BIOS.serialnumber; ManufacturerProcessor=$Processor.Manufacturer; MaxClockSpeed=$Processor.MaxClockSpeed} | ConvertTo-Html')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});
 
app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

### Ejemplo de NODE.JS (Crear una página web con información sobre procesos)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()

let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('Get-Process | ConvertTo-Html -Property Name, Path, Company')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/procesos', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});

let ps2 = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps2.addCommand('Get-Service | ConvertTo-Html -Property Name, Path, Company')
ps2.invoke()
.then(output => {
  console.log(output);
  app.get('/servicios', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps2.dispose();
});

app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

------------
------------

# Examen liberatorio

- El proceso que más consume tiene un cambio de integridad, crear una función que realiza dicha comprobación.
- Crear un log de sistema cuando hay un cambio de integridad.
- Un software que se va a instalar tiene un ejecutable cuya integridad es errónea.
- Detectar que un equipo no se ha añadido a un Dominio.
- Mostrar un objeto con toda la información de todos los elementos que hay en un Directorio Activo.
- Detectar cómo se ha propagado un virus en carpetas compartidas generando una entrada en un log del sistema.
- Comprobar que ha cambiado un permiso utlizando auditoría.
- Mostrar un mensaje si el tamaño de una carpeta compatida supera el 80%.
- Crear una entrada en un registro del visor de eventos si hay un intento de acceso a un puerto que está cerrado.

------------
------------

# Correción examen liberatorio

- El proceso que más consume tiene un cambio de integridad, crear una función que realiza dicha comprobación.
```PowerShell
(Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash | Out-File inte.txt

$resultado = (Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash
if((Get-Content .\inte.txt) -eq $resultado)
{
    "es igual"
}
else
{
    "no es igual"
}
```
- Crear un log de sistema cuando hay un cambio de integridad.
```PowerShell
(Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash | Out-File inte.txt

function comprobar ($integridadbuena)
{
    $resultado = (Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash
    if($integridadbuena -eq $resultado)
    {
        "es igual"
    }
    else
    {
       Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" 
       -EventID 916 -EntryType Information -Message "Cambio integridad" 
       -Category 2 -RawData 10,20
    }
}

comprobar (Get-Content .\inte.txt)
```
- Un software que se va a instalar tiene un ejecutable cuya integridad es errónea.
```PowerShell
foreach($programa in ls "C:\Program Files (x86)\Cisco Packet Tracer 6.1.1sv\bin\*.exe")
{
    (Get-FileHash $programa).path+","+(Get-FileHash $programa).hash | Out-File resultahas.txt -Append
}
```
- Detectar que un equipo no se ha añadido a un Dominio.
```PowerShell
$equipo = ""

function comprobar ($equipo)
{
    $ComputerName = $env:COMPUTERNAME
    $computer = [ADSI]"WinNT://$($ComputerName),computer"
    foreach($equipito in $computer)
    {
        if($equipito.Path -match $equipo)
        {
            "es igual"
        }
    }
}

comprobar FP_LHR_19
```
- Mostrar un objeto con toda la información de todos los elementos que hay en un Directorio Activo.
```PowerShell
[PSCustomObject]@{
 usuarios = Get-LocalUser
 grupos = Get-LocalGroup
}
```
- Detectar cómo se ha propagado un virus en carpetas compartidas generando una entrada en un log del sistema.
- Comprobar que ha cambiado un permiso utlizando auditoría.
- Mostrar un mensaje si el tamaño de una carpeta compatida supera el 80%.
```PowerShell
$total = 100

if((Get-ChildItem C:\Users\adminfp\Desktop\fallo | Measure-Object Length -Sum).Sum -lt $total*0.8)
{
    "menor"
}
```
- Crear una entrada en un registro del visor de eventos si hay un intento de acceso a un puerto que está cerrado.

# Aplicación en Python con Flask para gestión de archivos mediante comandos del sistema
* https://www.jesusninoc.com/05/20/aplicacion-en-python-con-flask-para-gestion-de-archivos-mediante-comandos-del-sistema/

# Aplicación en Python con Flask y Bootstrap para la gestión de procesos mediante comandos del sistema
* https://www.jesusninoc.com/05/21/aplicacion-en-python-con-flask-y-bootstrap-para-la-gestion-de-procesos-mediante-comandos-del-sistema/

# Servidor en Python con Flask para recibir y almacenar credenciales (con método GET)
* https://www.jesusninoc.com/05/22/servidor-en-python-con-flask-para-recibir-y-almacenar-credenciales-con-metodo-get/

# Servidor en Python con Flask para recibir y almacenar credenciales (con método POST)
* https://www.jesusninoc.com/05/22/servidor-en-python-con-flask-para-recibir-y-almacenar-credenciales-con-metodo-post/
