# Repaso del mes
## Script para realizar tareas básicas y avanzadas
https://github.com/jesusninoc/Scripts/blob/master/Realizar%20tareas%20b%C3%A1sicas%20y%20avanzadas.sh
## Cmdlets relacionados con tareas básicas y de administración en el sistema operativo Windows
https://www.jesusninoc.com/2015/04/28/cmdlets-relacionados-con-tareas-basicas-y-de-administracion-en-el-sistema-operativo-windows/

# Repaso del BOE
- Administración de software de base
- Administración de recursos compartidos

# Repaso de las tareas de administración III
### Gestión del almacenamiento
* https://www.jesusninoc.com/2017/07/03/3-gestion-del-hardware-en-powershell/
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
### Gestión de la red
* https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
### Copias de seguridad
* https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

---------------------

# Realizar un script que sea una tarea programada que almacene información sobre la situación actual del sistema operativo (Windows y Linux), teniendo en cuenta:
- Programas instalados
- Actualizaciones
- Usuarios y grupos

## Además de almacenar información, el script tiene que permitir hacer una recuperación con la información almacenada, por ejemplo restaurar usuarios leyendo de un fichero los usuarios y grupos a los que pertenecen.

## Ideas que se pueden aplicar al script:
- Almacenar los .exe de los programas
- Almacenar los ficheros .dll de los programas
- Almacenar los instaladores .msi de los programas instalados
- Realizar un proceso de firma (hash) a los programas instalados
- Utilizar expresiones regulares

----------------------

# Hyper-V: Backup VMs to a shared folder with Windows Server Backup and a Scheduled Task-
https://sid-500.com/2018/03/11/hyper-v-backup-vms-to-a-shared-folder-with-windows-server-backup-and-a-scheduled-task/
```PowerShell
$Action=New-ScheduledTaskAction -Execute 'C:\Temp\backupVM.bat'
$Trigger=New-ScheduledTaskTrigger -Weekly -DaysOfWeek Saturday -At 11am
$Set=New-ScheduledTaskSettingsSet
$Principal=New-ScheduledTaskPrincipal -UserId 'sid-500\administrator' -LogonType S4U
$Task=New-ScheduledTask -Action $Action -Trigger $Trigger -Settings $Set -Principal $Principal
Register-ScheduledTask -TaskName "Backup VM" -InputObject $Task -Force
```

# Linux – Tigger commands and tasks during file system changes
https://www.capatek-tutorials.com/linux/linux-tigger-commands-tasks-file-system-changes/

# Scheduled Task with Daily Trigger and Repetition Interval
https://stackoverflow.com/questions/20108886/scheduled-task-with-daily-trigger-and-repetition-interval
```PowerShell
$trigger = New-ScheduledTaskTrigger `
    -Once `
    -At (Get-Date) `
    -RepetitionInterval (New-TimeSpan -Minutes 5) `
    -RepetitionDuration ([System.TimeSpan]::MaxValue)
```

---------------------

# ¿Cómo detectar que ha aparecido un equipo en la red WIFI?
- Mostrar un mensaje en PowerShell cuando aparece un equipo WIFI en la red
```PowerShell
```

---------------------

# ¿Cómo detectar que se está ejecutando un proceso?
- Conocer procesos
- Firmas de procesos
- Mostrar un mensaje en PowerShell cuando se ejecuta y se para un programa (por ejemplo se ejecuta powershell)
```PowerShell
Start-Process powershell.exe "-command ps"
```
- Localizar el proceso que está relacionado con el puerto de carpetas compartidas
```PowerShell
netstat -ano
```
- Contar procesos
- Contar hilos
- Analizar la red
- Auditar
- Registro
- Registro y logs de carpetas compartida
- Explorer
- Keylogger
- Volcado de procesos
- Capturar la pantalla
- Get-Counter

-------------------

# PowerShell
## Detectar si hay un dispositivo USB conectado y copiar el contenido en una carpeta temporal
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Detectar%20si%20hay%20un%20dispositivo%20USB%20conectado%20y%20copiar%20el%20contenido%20en%20una%20carpeta%20temporal.ps1

## Discover a webcam
https://www.jesusninoc.com/2017/10/17/discover-a-webcam/

## Ver los teléfonos móviles que se han conectado al sistema operativo
https://www.jesusninoc.com/2016/12/01/ver-los-telefonos-moviles-que-se-han-conectado-al-sistema-operativo/

## Conocer el estado del ratón
https://www.jesusninoc.com/2016/10/05/conocer-el-estado-del-raton/

## Activar un dispositivo Plug and Play con PowerShell
https://www.jesusninoc.com/2018/03/08/activar-un-dispositivo-plug-and-play-con-powershell/

## Desactivar un dispositivo Plug and Play con PowerShell
https://www.jesusninoc.com/2018/02/08/desactivar-un-dispositivo-plug-and-play-con-powershell/

## Show UDID of iPhone
https://www.commandlinefu.com/commands/view/15421/show-udid-of-iphone
