# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Firewall
## Enable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/16/enable-the-microsoft-windows-firewall/
## Disable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/15/disable-the-microsoft-windows-firewall/
## Ejemplos de reglas de firewall
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-deshabilitadas/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-en-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-no-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-de-salida-del-firewall-desde-powershell-de-windows-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-de-entrada-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
## Log del Firewall
```Cmd
%systemroot%\system32\LogFiles\Firewall\pfirewall.log
```

--------------
--------------

# Ejercicios de red
## Crear una función en la que le pasas una conexión de red y te dice qué proceso ejecuta (le puedes pasar una IP o un puerto)
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-crear-una-funcion-en-la-que-se-pasa-una-conexion-de-red-y-te-dice-proceso-ejecuta-se-puede-pasar-una-ip-o-un-puerto/
## Crear una función que agrupa los nombre obtenidos mediante una resolución DNS (sin mostrar errores)
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-crear-una-funcion-que-agrupa-los-nombre-obtenidos-mediante-una-resolucion-dns-sin-mostrar-errores/
## Mostrar los hilos que se están ejecutando y deducir si se pueden relacionar con sockets abiertos
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-mostrar-los-hilos-que-se-estan-ejecutando-y-deducir-si-se-pueden-relacionar-con-sockets-abiertos-tcp-o-udp/

# Ejercicios avanzados de red
## Simular el uso de certificado
* https://www.jesusninoc.com/01/23/enviar-un-mensajes-cifrado-con-cryptographic-message-syntax-cms-entre-un-cliente-y-un-servidor-mediante-udp-desde-powershell/
## Uso de certificado en conexión cliente servidor
* https://www.jesusninoc.com/03/11/cifrar-el-trafico-entre-un-cliente-y-un-servidor-mediante-el-protocolo-tcp-ip-con-un-certificado-x509-autofirmado-en-powershell/

--------------

# Scripting

## Repaso básico de Linux para la parte de scripting
* http://www.freeos.com/guides/lsst/ch02.html
* http://www.freeos.com/guides/lsst/ch02sec20.html

## Repaso básico de Windows para la parte de scripting
### Snippets in Windows PowerShell
https://www.jesusninoc.com/2014/03/19/snippets-in-windows-powershell/

------------------
------------------

# Administración de recursos compartidos:
- Instalación y configuración de servicios
- Administración del acceso a recursos. SMB/CIFS. SAMBA. NFS.
- Grupos de trabajo.
- Permisos de red. Permisos locales. Herencia. Permisos efectivos.

--------------

# Repaso discos

## LVM (Logical Volume Manager)

Un LVM se descompone en tres partes:
- Volúmenes físicos (PV): Son las particiones del disco duro con sistema de archivos LVM. (raid's)
- Grupos de volúmenes (VG): es la parte superior de la LVM. Es la "caja" en la que tenemos nuestros volúmenes lógicos (LV) y nuestros volúmenes físicos (PV). Se puede ver como una unidad administrativa en la que se engloban nuestros recursos. Hay que hacer notar que mientras un PV no se añada al VG, no podemos comenzar a usarlo.
- Volúmenes lógicos (LV): es el equivalente a una partición en un sistema tradicional. El LV es visible como un dispositivo estándar de bloques, por lo que puede contener un sistema de archivos (por ejemplo /home)

```Dibujo
               sda1        sdb    (PV:s, particiones o discos completos)
                     /
                    /
               linuxvg            (VG)
             /    |    
           /      |      
       ubuntu   arch     home     (LV:s)
         |        |       |
       ext4      ext4    xfs      (sistemas de archivos)
```

## Operaciones sobre discos en Windows:
- Crear particiones
- Borrar particiones
- Recuperar particiones eliminadas
- Cifrar
- Comprimir
- Convertir entre sistemas de archivos

## Discos dinámicos
http://windows.microsoft.com/es-es/windows-vista/what-are-basic-and-dynamic-disks

--------------

# Arranque
- BIOS
- POST
- Arranque (dual, BCD, BCDEdit, etc.)
- Arranque de procesos

## Arranque en Linux
### Proceso de arranque en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Arranque en Windows
### Proteger el proceso de arranque de Windows 10
https://docs.microsoft.com/es-es/windows/security/hardware-protection/secure-the-windows-10-boot-process
### Procesos de credenciales de autenticación de Windows
https://docs.microsoft.com/es-es/windows-server/security/windows-authentication/credentials-processes-in-windows-authentication

--------------

# Permisos en PowerShell

## 4. Gestión de archivos en PowerShell para administradores de sistemas
https://www.jesusninoc.com/2016/11/10/4-gestion-de-archivos-en-powershell-para-administradores-de-sistemas/

## Obtener los descriptores de seguridad de todos los ficheros de una unidad
https://www.jesusninoc.com/2016/09/10/obtener-los-descriptores-de-seguridad-de-todos-los-ficheros-de-una-unidad/

## Enumeración FileSystemRights: Define los derechos de acceso que se utilizará al crear reglas de acceso y auditoría
https://msdn.microsoft.com/es-es/library/system.security.accesscontrol.filesystemrights(v=vs.110).aspx

## Clonar permisos NTFS
https://www.jesusninoc.com/2015/01/23/clonar-permisos-ntfs/

## Eliminar permisos explícitos
https://www.jesusninoc.com/2016/03/30/eliminar-permisos-explicitos/

## Añadir permiso NTFS a una carpeta
https://www.jesusninoc.com/2015/08/19/anadir-permiso-ntfs-a-una-carpeta/

## Weekend Scripter: Use PowerShell to Get, Add, and Remove NTFS Permissions
https://blogs.technet.microsoft.com/heyscriptingguy/2014/11/22/weekend-scripter-use-powershell-to-get-add-and-remove-ntfs-permissions/

## Ejemplo de asignación de permisos
```PowerShell
New-Item -type directory -path C:\MyFolder
$Acl = Get-Acl "C:\MyFolder"
$Ar = New-Object  system.security.accesscontrol.filesystemaccessrule("username","FullControl","Allow")
$Acl.SetAccessRule($Ar)
Set-Acl "C:\MyFolder" $Acl
```

--------------

# Permisos en Linux
Why does the default umask value contains 4 digits?
The first digit in 0022 defines the special permission value. In case you want to set any special permission to every file/directory to be created then you can define the value accordingly.

For understanding all the special permission and their value follow the below link
- Understanding Special Permission SGID in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-sgid.html
- Understanding Special Permission SUID in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-suid.html
- Understanding Special Permission Sticky Bit in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-sticky.html

## Comando para ver permisos de un fichero
```Bash
stat -f "%Sp -> owner=%SHp group=%SMp other=%SLp" fichero.txt  
```

## Ejemplo sobre asignación de permisos al crear carpetas
### Creates a new directory called mydir whose parent is the current directory.
```Bash
mkdir examples
mkdir mydir
```
Create the mydir directory, and set its permissions such that all users may read, write, and execute the contents.
```Bash
mkdir -m a=rwx mydir
```
Creates the directory /home/chope/a/b/c. If the parent directory /home/chope/a/b does not already exist, mkdir will create that directory first.
```Bash
mkdir -p /home/chope/a/b/c
```

## Permisos avanzados en C
http://www.jesusninoc.com/2015/01/19/programacion-de-permisos/

--------------

# Integridad
## PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosProcesosAvanzado.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Ficheros/EjemploIntegridad.ps1
## Linux
* https://www.jesusninoc.com/2016/01/02/for-loop-examples/
* https://www.jesusninoc.com/2015/07/14/sentencia-condicional-if-else-2/
* https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

--------------

# Copias de seguridad

## En Windows
### 10. Gestión del rendimiento en PowerShell para administradores de sistemas
https://www.jesusninoc.com/2016/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/
### Copias de seguridad (explicación básica del concepto de copia de seguridad incremental y diferencial)
https://github.com/jesusninoc/PowerShell/tree/master/CopiasSeguridad

## En Linux
https://www.ochobitshacenunbyte.com/2017/07/10/copias-de-seguridad-con-dump-y-restore-en-linux/

--------------

# USB

## Memorias USB: riesgos, protección y acceso a los datos
https://www.securityartwork.es/2018/01/24/memoricas-usb-riesgos-proteccion-acceso-los-datos/

## Detectar si hay un dispositivo USB conectado y copiar el contenido en una carpeta temporal
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Detectar%20si%20hay%20un%20dispositivo%20USB%20conectado%20y%20copiar%20el%20contenido%20en%20una%20carpeta%20temporal.ps1


--------------

# ISO, WIM

## Crear ISO
https://gallery.technet.microsoft.com/scriptcenter/New-ISOFile-function-a8deeffd

## Crear una imagen WIM de un disco duro y expandirla después en un disco duro
https://www.jesusninoc.com/2015/08/02/crear-una-imagen-wim-de-un-disco-duro-y-expandirla-despues-en-un-disco-duro/

## Crear un WIM de un USB (copia de seguridad) copiarlo a una carpeta compartida (controlar los permisos de red y NTFS), tener en cuenta:
- Crear WIM
- Ver ficheros USB
- Crear carpeta compartida
- Copia de seguridad
- Realizar firma del fichero obtenido

--------------

# Posibles preguntas para el examen

- Pedir un proceso
  - Comprobar la ruta y el hash (hay un listado de hash para los programas que hay en el sistema)
  - Comprobar si hay algún drivers cambiado (hay un listado de hash para los drivers)
- Instalar programas en Ubuntu leyendo desde un fichero
- Ver versión de programas instalados, los antiguos hay que actualizarlos
- Actualización
- Control de acceso a programas
- Controladores, drivers
- Instalar y actualizar
- Qué proceso realizas para crear un usuario
- Crear y añadir usuarios
- El usuario con más privilegios
- Habilitar usuarios
- Seguridad en contraseñas
- Permisos, herencia, permisos efectivos
- Cambiar dueño usuario
- Carpetas compartidas

------------------
------------------

# Examen liberatorio

## Pregunta 1. Crear usuarios leyendo de un fichero el nombre de los usuarios que se van a crear y los credenciales que se van a utilizar
* https://www.jesusninoc.com/03/13/ejercicios-de-powershell-restaurar-usuarios-que-se-han-creado-anteriormente-se-almacenan-en-un-fichero-y-se-vuelven-a-crear/
* https://www.jesusninoc.com/04/08/almacenar-y-utilizar-credenciales-mediante-json/
* https://www.jesusninoc.com/12/08/utilizar-credenciales-en-formato-json-que-han-sido-exportados-con-get-credential-y-arrancar-el-programa-notepad-en-powershell/
* https://www.jesusninoc.com/12/07/exportar-credenciales-con-get-credential-en-un-fichero-json-con-powershell/
* https://www.jesusninoc.com/03/01/ejercicios-de-powershell-almacenar-varios-credenciales-en-un-fichero-xml-y-utilizarlos-para-arrancar-un-proceso/
* https://www.jesusninoc.com/06/24/verificar-si-existe-un-usuario-en-windows-10-con-powershell/
* https://www.jesusninoc.com/02/27/validar-usuarios-en-el-directorio-activo-pidiendo-al-usuario-el-nombre-y-la-contrasena/

## Pregunta 2. Realizar una copia de seguridad comprimida en una carpeta compartida con las dll que utilza un proceso
* https://www.jesusninoc.com/03/05/create-a-share-on-linux-and-access-it-from-windows/
* https://www.jesusninoc.com/04/30/ejercicios-de-powershell-crear-una-carpeta-compartida-mapearla-y-utilizarla/
* https://www.jesusninoc.com/06/14/conectarse-a-una-carpeta-compartida-con-powershell/
* https://www.jesusninoc.com/05/27/ejercicios-de-powershell-analizar-ficheros-dll-en-todos-los-equipos-de-la-red-comprobar-que-ha-cambiado-una-integridad-y-copiar-el-fichero-que-ha-cambiado/

--------------
--------------

# Corrección del examen liberatorio
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-03-11.md#pregunta-1-crear-usuarios-leyendo-de-un-fichero-el-nombre-de-los-usuarios-que-se-van-a-crear-y-los-credenciales-que-se-van-a-utilizar

# Ejercicios sobre corrección del examen liberatorio
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-una-funcion-que-almacene-los-usuarios-que-estan-en-el-equipo-y-los-guarde-en-formato-qr/
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-un-qr-con-los-nombres-de-los-usuarios-que-hay-en-el-sistema-y-crear-los-usuarios-nuevamente-leyendo-el-codigo-qr-generado-anteriormente/
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-usuarios-en-linux-leyendo-desde-un-codigo-qr-en-powershell-el-nombre-de-los-usuarios-se-obtiene-listando-usuarios-en-el-sistema-desde-powershell-y-convirtiendo-a-codig/

------------
------------

# Linux

## Repaso de usuarios
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#listar-informaci%C3%B3n-sobre-usuarios-y-grupos-en-bash-con-repaso-sobre-comandos
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-04.md#crear-usuarios-en-ubuntu-mediante-wsl
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-09.md#crear-usuarios-en-ubuntu

## Repaso scripting Linux
* https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjerciciosFicherosBuscar.sh
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-05-24-Enunciado.sh
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-22.md#repaso-para-realizar-scripts-en-linux
* https://blog.carreralinux.com.ar/2016/07/unir-y-ordenar-lineas-en-archivos-de-texto/
* https://likegeeks.com/es/comando-awk/

## Repaso enlaces duros y simbólicos
* https://geekland.eu/que-son-para-que-sirven-enlaces-duros-y-simbolicos/

## Más repaso scripts
* https://github.com/jesusninoc/Scripts

------------
------------

# Corrección del examen liberatorio
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-03-11.md#pregunta-2-realizar-una-copia-de-seguridad-comprimida-en-una-carpeta-compartida-con-las-dll-que-utilza-un-proceso

# Ejercicios sobre corrección del examen liberatorio
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-realizar-una-copia-de-seguridad-de-las-dll-que-utiliza-un-proceso-y-comprimir-la-copia-dentro-de-una-carpeta-compartida/

------------
------------

# Linux (vamos por la parte de valores $* en la presentación)

## Ejercios resueltos
* https://www.jesusninoc.com/03/18/ejercicios-wsl-crear-en-windows-con-powershell-y-wsl-los-mismos-usuarios-que-tenemos-en-linux/
* https://www.jesusninoc.com/03/18/ejercicios-de-wsl-realizar-una-suma-en-wsl-llamando-a-un-script-de-bash-donde-le-pasamos-dos-valores/
* https://www.jesusninoc.com/03/18/ejercicios-de-wsl-realizar-una-suma-en-wsl-llamando-a-un-script-donde-le-pasamos-dos-valores-desde-powershell/
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-crear-un-interfaz-simple-que-realice-la-operacion-de-suma-resta-y-multiplicacion/
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-crear-un-interfaz-simple-que-realice-la-operacion-de-suma-resta-y-multiplicacion-mediante-la-llamada-a-un-script-en-bash-utilizando-wsl/

## Más repaso scripts
* https://github.com/jesusninoc/Scripts

-----------
-----------

# Examen segunda evaluación

1. Leer un usuario desde un servidor web (HTML, XML, JSON) crearlo y meterlo en el grupo de administradores (no te olvides del password).
2. Detectar mediante una función que el usuario pertenece al grupo de administradores.
```PowerShell
Get-LocalGroupMember administradores
```
El siguiente enlace es una solución de monitorización algo compleja: registrar y mostrar un evento en PowerShell cuando se crea un usuario
https://www.jesusninoc.com/2018/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

3. Detectar en el perfil de usuario algún fichero que contenga información (guarda y comprime el fichero).
```PowerShell
Get-ChildItem C:\Users\juan\NTUSER.DAT
```
4. Intentar utilizar las credenciales de un usuario y verificar que funciona (guarda en un fichero la captura).
* https://www.jesusninoc.com/2016/08/16/almacenar-credenciales/
* https://www.jesusninoc.com/2016/09/20/almacenar-y-utilizar-credenciales/
* https://www.jesusninoc.com/2017/04/08/almacenar-y-utilizar-credenciales-mediante-json/
5. Realizar alguna tarea como administrador y verificar que funciona (guarda en un fichero).
* https://www.jesusninoc.com/2016/08/17/utilizar-credenciales-almacenados/
6. Dejar una puerta trasera para poder conectarse desde SSH en Linux.
* https://itefix.net/copssh

--------------------------

# Simulacro de examen segunda evaluación

# Parte 1
## Crear un usuario utilizando el protocolo UDP
### Server
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Close()
```
### Client
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('New-LocalUser usuario2 -Password (ConvertTo-SecureString "11234aaa@@€dsf" -asplaintext -force)')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

## Ayuda
### Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
* https://www.jesusninoc.com/11/23/crear-un-usuario-local-con-contrasena-en-windows-10-con-powershell-5-1/
### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
* https://www.jesusninoc.com/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
### Lanzar una excepción en la función si algo va mal
```PowerShell
function Copy-Log
{
  "Doing prerequisites"
  "Testing whether target path exists"
  "If target path does not exist, bail out"
  throw "Target path does not exist"
  "Copy log files to target path"
  "Delete log files in original location"
}
```
# Parte 2
## Detectar que se ha creado un usuario sin darnos cuenta
- Por red
- Por IP
```PowerShell
Get-NetUDPEndpoint | %{
    if(($_ -match "192.168.104.39") -or ($_ -match "10.0.2.13") -or ($_ -match "127.0.0.1"))
    {
    }
    else
    {
        $_
    }
}
```
- Registro de la acción de crear usuarios
```PowerShell
#Ejecutar PowerShell como administrador
Register-WmiEvent -Query "select * from __InstanceCreationEvent where TargetInstance isa 'Win32_NtLogEvent' and TargetInstance.logfile = 'Security' and (TargetInstance.EventCode = '4720')" -Action {Write-Host $event.SourceEventArgs.NewEvent.TargetInstance.insertionstrings}
```
- Listar la fecha de creación de usuarios
```PowerShell
$checktime = (get-date).adddays(-1000)
get-aduser -searchbase "CN=Users ,DC=retared,DC=local" -Properties whencreated -filter {whencreated -ge $checktime}
```
- Contar número de usuarios
```PowerShell
(Get-LocalUser).count
```

------------
------------

# Repaso examen 2ª evaluación

## Posibles preguntas

- Crear un sistema para realizar instalaciones de programas en Linux desde PowerShell
  - El sistema tiene que comprobar si hay que realizar instalaciones al arrancar el sistema operativo

- Crear un sistema que da de alta usuarios en el sistema operativo
  - El sistema tiene que ser una tarea programada

- Ejemplos de preguntas rápidas
  - ¿Cómo bloqueas un programa en Windows para que no pueda ejecutarlo un usuario?
  - ¿Qué contiene el fichero ntuser.dat?

- Script OWASP
  - WordPress username enumeration with PowerShell https://jesusninoc.com/wp-json/wp/v2/users/
  - WordPress https://www.jesusninoc.com/wordpress/

------------
------------

# Examen segunda evaluación

## Tener en cuenta
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-26.md

## Configurar al usuario todo lo que necesita leyendo de un fichero (programas, carpetas, etc.), realizar el siguiente proceso:
- Copiar la información y configuración que hay sobre un usuario
	- Programas
	- DLL
- Crear para cada nuevo usuario que entra en el sistema (teniendo en cuenta el punto anterior):
	- Usuario
	- Grupo
	- Carpeta compartida
	
## Teniendo en cuenta la pregunta anterior, realizar un script que permita enviar información desde los clientes (no depender del servidor)
  
### Ayuda
- Guardar información sobre usuarios para hacer una recuperación
- Guardar información sobre programas y paquetes
- Configuración IP, DNS
- Tener en cuenta funciones complejas
- Se puede mejorar el script con Linux
- Tener en cuenta el AD
- Filtro LDAP
- Comunicar por UDP
- Información sobre programas
	- C:\Program Files
	- C:\Users\administrador.RETARED\AppData\Local
	- C:\Windows\prefetch
- Carpetas compartidas para guardar información de una copia de seguridad
 	- https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-16.md
 	- https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-11.md
- UDP
	- https://www.jesusninoc.com/11/10/realizar-conexiones-tcp-udp-con-powershell/

-----------

# Examen segunda evaluación

## Realizar un programa que permita utilizar el siguiente fichero
```
juan|ventas,compras|office|\\servidor1\ventas\juan|Total
```

## Ideas
### Perfiles móviles
http://www.developandsys.es/perfiles-moviles-server/
### Mapeo de unidades red Windows Server
http://www.developandsys.es/mapeo-unidades-red-windows-server/

-----------

# Resolver la siguiente situación mediante scripts

## Los usuarios de una red funcionan con un sistema muy básico, tienen usuarios creados en cada equipo y comparten archivos mediante carpetas compartidas. Tu tarea es extraer los usuarios de los equipos y centralizar todo en un solo servidor con un Directorio Activo.

### Ayuda
- Crear una carpeta compartida, mapearla y utilizarla
```PowerShell
New-SmbShare -Name asir -Path c:/asir1 –FullAccess juan -ReadAccess todos
New-PSDrive -Name “asir” -PSProvider FileSystem -Root \\localhost\asir
cd asir:/ 
```

### Soluciones
* https://github.com/AlexRivero14/COVID-19
* https://github.com/PabloQueipo/ISO/blob/master/Pr%C3%A1ctica%2026%20MARZO.md
* https://github.com/DanielCebri/ISO-/blob/master/31032020.md

------------------
------------------

# Examen liberatorio

- Carpeta caliente que recibe un fichero comprimido y crea los usuarios, grupos y OU que están en dicho fichero.
