# Repaso de PowerShell y red
* https://www.jesusninoc.com/02/13/iniciar-un-trabajo-en-segundo-plano-que-crea-un-formulario-desde-powershell-llamando-a-powershell-exe/
* https://www.jesusninoc.com/02/16/iniciar-varios-trabajos-en-segundo-plano-start-job-de-powershell-usando-una-variable-como-argumento-argumentlist/
* https://www.jesusninoc.com/12/23/crear-un-trabajo-start-job-en-powershell-y-recibirlo-receive-job/
* https://www.jesusninoc.com/02/16/iniciar-varios-formularios-como-trabajos-en-segundo-plano-start-job-de-powershell-usando-una-variable-como-argumento-argumentlist/
* https://www.jesusninoc.com/02/17/enviar-un-mensaje-udp-a-varios-ordenador-mediante-broadcast-desde-powershell-en-macos-hacerlo-de-forma-simple/
* https://www.jesusninoc.com/07/09/9-gestion-de-la-red-en-powershell/#Capa_de_transporte

------------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Análisis de conexiones de red
https://www.jesusninoc.com/2017/05/01/analisis-de-conexiones-de-red/

## Equivalencias entre comandos de red de Windows y cmdlets de PowerShell
https://www.jesusninoc.com/2016/02/04/equivalencias-entre-comandos-de-red-de-windows-y-cmdlets-de-powershell/

## Cmdlets for TCP/IP Model Layers
https://www.jesusninoc.com/2015/11/13/cmdlets-for-tcpip-model-layers/

## Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

# Ejercicio: enviar un mensaje entre todos los usuarios de clase
* https://www.jesusninoc.com/01/30/enviar-un-mensaje-udp-a-un-ordenador-desde-powershell/
* https://www.jesusninoc.com/08/26/enviar-un-mensaje-udp-a-un-ordenador-desde-powershell-en-macos-hacerlo-de-forma-simple/

-----------
-----------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Continuar con ejercicio enviar mensajes entre cliente y servidor
- Enviar algo entre Windows y Linux
- Enviar algo a todos los equipos

------------------
------------------

# Instalación silenciosa
* https://www.jesusninoc.com/02/17/realizar-la-instalacion-silenciosa-de-teamviewer-y-capturar-el-id-de-teamviewer-necesario-para-conectarse-al-equipo-desde-otro-equipo/
# Saber dónde me tengo que conectar
* https://www.jesusninoc.com/02/17/pasos-para-crear-un-servidor-y-un-cliente-en-powershell/
# Puerto abierto
* https://www.jesusninoc.com/02/20/ejercicios-de-powershell-comprobar-si-un-puerto-esta-abierto-o-no/
# Enviar credenciales
* https://www.jesusninoc.com/02/19/ejercicios-de-powershell-enviar-credenciales-entre-un-cliente-y-un-servidor-por-udp-y-ejecutar-una-aplicacion-en-el-servidor-con-dichos-credenciales/

---------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Ejemplos de redes básicos

```PowerShell
1..254|%{$_}
1..254|%{"192.168.1."+$_}
1..254|%{$ip="192.168.1."+$_;$ip}
1..254|%{$ip="192.168.1."+$_;ping $ip}
1..254|%{$ip="192.168.1."+$_;ping $ip;arp -a $ip}
1..254|%{$ip="192.168.1."+$_;$ip;arp -a | Select-String $ip}
```
```PowerShell
Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress
```
```PowerShell
[String]$a=(Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress)
$a.Substring(3,3)
```
