# Administración y aseguramiento de la información
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# PowerShell
¿Por qué un proceso ocupa tanto en memoria si el tamaño del .exe es menor?

-------------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

------------
------------

# Permisos en PowerShell
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Permisos-2
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-26.md
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md
* https://www.jesusninoc.com/03/30/eliminar-permisos-explicitos/

------------------
------------------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

## Discos
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-04.md

# Administración y aseguramiento de la información:
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.

## Instalar Windows Server
* https://www.microsoft.com/es-es/evalcenter/evaluate-windows-server-2016

## Repasar discos en Linux y Windows
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-17.md#comandos-para-trabajar-con-discos-en-linux
### Montar unidades en Windows
* http://www.vicente-navarro.com/blog/2010/10/28/unidades-montadas-y-enlaces-simbolicos-en-windows/

## RAID
* http://www.developandsys.es/aseguramiento-la-informacion/

### Crear un volumen distribuido y un RAID 5
- Un volumen distribuido combina áreas de espacio sin asignar de varios discos en un volumen lógico, lo que le permite usar de forma más eficaz todo el -espacio y todas las letras de unidad en un sistema de varios discos.
- Un RAID 5 es una matriz de tres o más discos duros que funcionan como una unidad lógica y que supera considerablemente a los soportes de datos individuales en términos de seguridad ante los fallos y velocidad de lectura.

--------------------
--------------------

# Permisos en Linux
## Permisos especiales en Linux
http://rm-rf.es/permisos-especiales-setuid-setgid-sticky-bit/

|Permiso|Explicación
|---|---
|- - - - - - - - -	= 0|Predeterminado, sin permisos especiales. No se requiere indicar.
|- - - - - - - - t	= 1|Bit de persistencia, sticky bit
|- - - - - s - - -	= 2|Bit sgid de grupo
|- - - - - s - - t	= 3|Bit sgid y sticky
|- - s - - - - - -	= 4|Bit suid
|- - s - - - - - t	= 5|Bit suid y sticky
|- - s - - s - - -	= 6|Bit suid y sgid
|- - s - - s - - t	= 7|Bit suid, sgid y sticky

- sticky: se utiliza para permitir que cualquiera pueda escribir y modificar sobre un archivo o directorio, pero que solo su propietario o root pueda eliminarlo. 
- suid: el bit SUID activo en un archivo significa que el que lo ejecute va a tener los mismos permisos que el que creó el archivo.
- sgid: el SGID es lo mismo que en el SUID, pero a nivel de grupo. Es decir, todo archivo que tenga activo el SGID, al ser ejecutado, tendrá los privilegios del grupo al que pertenece.

## Permisos en Linux (EJERCICOS AVANZADOS SOBRE PERMISOS)

### Permisos en Linux avanzados
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

### Asignar permisos mediante llamada a sistema chmod en C
* https://www.jesusninoc.com/2014/12/01/chmod-system-call-example/

---------
---------

# Ejercicios
## Logs
* https://www.jesusninoc.com/05/05/ejercicios-de-powershell-crear-una-funcion-que-valide-un-usuario-leyendo-el-nombre-y-el-password-en-hash-correcto-de-un-fichero-en-el-caso-de-que-el-login-sea-correcto-se-almacena-la-palabra-cor/

## Hash
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Realizar_funcion_hash_sobre_un_archivo

## Permisos
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Permisos

--------------
--------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

## Ejercicios propuestos con ficheros y directorios (Bash)

- Asignar permisos para una carpeta para cada usuario
- Asignar permisos para un fichero para cada usuario
- Asignar permisos para una carpeta para cada grupo
- Asignar permisos para un fichero para cada grupo

## Script con tareas sobre permisos (script.sh)

- Crear un directorio (directorio) y un fichero (fichero)
```Bash
    mkdir directorio
    touch fichero
```
- Asignar permisos a directorio y fichero iniciales
```Bash
    chmod 611 directorio -> chmod u=rw,go=x directorio
    chmod 611 fichero -> chmod u=rw,go=x fichero
```
- Asignar permisos a directorio y fichero de cambio
```Bash
    chmod 742 directorio
    chmod 742 fichero
```
- Cambiar el usuario dueño del fichero
```Bash
    chown root fichero
```
- Cambiar el grupo dueño del directorio
```Bash
    chgrp root directorio
```

------------
------------

# Administración y aseguramiento de la información:
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.
  
# Introducción a las copias de seguridad
## Incremental
* https://github.com/jesusninoc/PowerShell/blob/master/CopiasSeguridad/EjemplosCopiasSeguridad1.ps1
## Diferencial
* https://github.com/jesusninoc/PowerShell/blob/master/CopiasSeguridad/EjemplosCopiasSeguridad2.ps1
    
# PowerShell
## 10. Gestión del rendimiento en PowerShell para administradores de sistemas (nivel básico)
* https://www.jesusninoc.com/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/

## Ayuda para copias de seguridad
### Comprimir y descomprimir
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Comprimir
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Descomprimir
```PowerShell
Compress-Archive -LiteralPath C:\powershell\example.txt –CompressionLevel Optimal -DestinationPath C:\powershell\comprimido.zip
Expand-Archive -LiteralPath C:\powershell\comprimido.zip -DestinationPath C:\powershell\descomprimir
Compress-Archive -LiteralPath C:\powershell\example2.txt -Update -DestinationPath C:\powershell\comprimido.zip
```
### Cifrar
* https://www.jesusninoc.com/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

## Ejercicios sobre copias de seguridad
- Listar archivos por fecha
  * https://www.jesusninoc.com/12/01/ejercicios-de-powershell-listar-ficheros-cuya-fecha-de-ultima-escritura-de-ficheros-sea-de-mayor-que-menos-un-dia/

- Crear una función que realiza una copia de seguridad en el día de hoy
  * https://www.jesusninoc.com/12/14/ejercicios-de-powershell-crear-una-funcion-que-realiza-una-copia-de-seguridad-en-el-dia-de-hoy/

- Crear una función que realiza una copia de seguridad en el día de hoy de los archivos que se han modificado respecto del día de ayer
  * https://www.jesusninoc.com/12/15/ejercicios-de-powershell-crear-una-funcion-que-realiza-una-copia-de-seguridad-en-el-dia-de-hoy-de-los-archivos-que-se-han-modificado-respecto-del-dia-de-ayer/

- Copia de seguridad para cada día de la semana y ser capaz de recuperar
  ```PowerShell
  # Restaurar
  mkdir tuscosasperdidas
  cd .\tuscosasperdidas
  Get-ChildItem ../ | Copy-Item
  ```
- Crear una función que realiza una restauración de una copia de seguridad
  ```PowerShell
  function restaurar($fechahoy,$donderestaurar)
  {
      cd $donderestaurar
      Get-ChildItem ("..\"+$fechahoy) | Copy-Item
  }

  restaurar -fechahoy (Get-Date).ToString("yyyyMMdd") -donderestaurar restaurar
  ```
- Ser capaz de recuperar en función de lo que pide el usuario
  ```PowerShell
  # Restaurar en función de lo que pide el usuario
  $datosusar = Read-Host "Dime el nombre del arhcivo que tengo que recuperar"
  ls $datosusar* | Copy-Item
    ```
- Comprimir las copias de seguridad que se han realizado
  ```PowerShell
  # Comprimir el directorio con la fecha
  $fecha = (Get-Date).ToString("yyyyMMdd") + ".zip"
  Compress-Archive -LiteralPath .\20181119 –CompressionLevel Optimal -DestinationPath $fecha
  Compress-Archive -LiteralPath virus.exe -Update -DestinationPath $fecha
  ```

-------------------
-------------------

# Introducción a tareas de administración
https://www.jesusninoc.com/2017/09/01/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

## Agregar/Eliminar software
https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
## Actualización
https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
## Gestión de procesos
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/
## Programación de tareas
https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
## Usuarios
https://www.jesusninoc.com/2017/07/08/8-gestion-de-usuarios-en-powershell/
## Grupos
https://www.jesusninoc.com/2017/07/08/8-gestion-de-usuarios-en-powershell/
## Gestión del almacenamiento
* https://www.jesusninoc.com/2017/07/03/3-gestion-del-hardware-en-powershell/
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
## Gestión de la red
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
## Copias de seguridad
https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
## Reparación del sistema
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/
## Rendimiento del sistema
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

------------
------------

# Repaso
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-09-01.md (cómo vamos)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-01.md (proyectos)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-02.md (multimedia)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-03.md (virtualización)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-09.md#examen-1%C2%AA-recuperaci%C3%B3n (examen recuperación)
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-09.md#introducci%C3%B3n-a-tareas-de-administraci%C3%B3n (tareas de administración)

---------------
---------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## ¿Qué es el número de sesiones de usuario?
* https://www.jesusninoc.com/01/12/introduccion-a-los-sistemas-operativos/#El_numero_de_sesiones

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/
