| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Ejercicios sobre hilos

## Almacenar información sobre los hilos
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar información sobre los hilos del proceso Notepad 
* https://www.jesusninoc.com/11/17/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-del-proceso-notepad/

## Mostrar información sobre los hilos de todos los procesos que se están ejecutando (qué proceso ejecuta el hilo)
* https://www.jesusninoc.com/11/19/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-de-todos-los-procesos-que-se-estan-ejecutando-que-proceso-ejecuta-el-hilo/

## Listar hilos de cada proceso
* https://www.jesusninoc.com/07/22/listar-los-hilos-de-un-proceso/

## Almacenar información sobre hilos de forma continuada
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar los hilos de cada proceso utilizando WMI y el cmdlet Get-Process
* https://www.jesusninoc.com/11/23/ejercicios-de-powershell-mostrar-los-hilos-de-cada-proceso-utilizando-wmi-y-el-cmdlet-get-process/

## Relación entre servicios y procesos
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

## Ayuda de servicios con procesos
```PowerShell
foreach($elementos in (Get-WmiObject -Class Win32_Service))
{
    $elementos
}
Get-WmiObject -Class Win32_Service | %{
Write-Host $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```

## Ayuda de procesos WMI con procesos
```PowerShell
Get-WmiObject Win32_Process | %{
    $_.Handles,$_.ProcessHandle,(Get-Process -Id $_.ProcessHandle).ProcessName
}
Get-WmiObject Win32_Process | %{
    (Get-Process -Id $_.ProcessId),$_.ProcessName,$_.Handle,$_.ProcessId
}
```

## Almacenar el número de procesos e hilos en un fichero junto con la fecha (el script se ejecuta cada cinco segundos)
* https://www.jesusninoc.com/11/26/ejercicios-de-powershell-almacenar-el-numero-de-procesos-e-hilos-en-un-fichero-junto-con-la-fecha-el-script-se-ejecuta-cada-cinco-segundos/

# Servicios y relación con procesos
## No funciona porque no puede convertir ProcessID
```PowerShell
Get-WmiObject -Class Win32_Service | Select-Object Name,ProcessID, (Get-Process -Id ProcessID).name
```
## Sí funciona
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

# Procesos y ruta de ejecución del proceso
* https://www.jesusninoc.com/11/29/ejercicios-de-powershell-procesos-y-ruta-de-ejecucion-del-proceso/

# Ejercicios de PowerShell: saber la ruta de los servicios que se están ejecutando
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-saber-la-ruta-de-los-servicios-que-se-estan-ejecutando/

# Ejercicios de PowerShell: de la lista de hilos que se están ejecutando indicar si alguno es un hilo de un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-hilos-que-se-estan-ejecutando-indicar-si-alguno-es-un-hilo-de-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de la lista de procesos que se están ejecutando indicar si alguno es un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-procesos-que-se-estan-ejecutando-indicar-si-alguno-es-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de los servicios que se están ejecutando indicar el nombre del proceso
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-los-servicios-que-se-estan-ejecutando-indicar-el-nombre-del-proceso/

# Ejercicios de PowerShell: mostrar el padre de un hilo
* https://www.jesusninoc.com/09/29/ejercicios-de-powershell-mostrar-el-padre-de-un-hilo/

------------
------------

# Ejecutar comandos en PowerShell y Bash
## Bash
```Bash
echo ps
echo 'ps'
echo `ps`
```
## PowerShell
```PowerShell
$hola="Get-Process -Name notepad"
Invoke-Expression ($hola)
```

## Mezcla de comandos entre PowerShell y Bash
```PowerShell
for($i=1;$i -le 5;$i=$i+1)
{
    $multi=($i*100) 
    $nombre="fichero$i"
    $resultado=Invoke-SSHCommand -Index 0 ('echo' + $multi + ' >' + $nombre)
    $resultado.Output 
}
```

---------------
---------------

# Introducción al sistema de archivos

## Ejemplos básicos sobre el sistema de archivos en PowerShell
* https://www.jesusninoc.com/11/03/ejercicios-de-powershell-ejercicios-basicos-sobre-el-sistema-de-archivos-en-powershell/

## Ejercicios sobre sistemas de archivos (mezclado con procesos)
* https://www.jesusninoc.com/11/04/ejercicios-de-powershell-ejercicios-sobre-sistemas-de-archivos-mezclado-con-procesos/

---------------
---------------

# Repaso de discos
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Discos_virtuales
* https://www.jesusninoc.com/10/25/crear-una-imagen-de-un-disco-virtual/

---------------
---------------

# Parte especial de la clase (conexión con Linux)

## SSH

### Instalar y ejecutar SSH para PowerShell
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.11 -Credential (Get-Credential)
```

### Conexión después de haber desconectado y quitado el módulo Posh-SSH (hay que volver a importarlo)
```PowerShell
Set-ExecutionPolicy -ExecutionPolicy Unrestricted

Import-Module Posh-SSH

New-SSHSession -ComputerName 10.20.104.19 -Credential (Get-Credential)

Get-SSHSession

(Invoke-SSHCommand -Index 0 "uname -r").output

(Invoke-SSHCommand -Index 0 "lscpu").output | Out-File informacionunubntu.txt -Append
(Invoke-SSHCommand -Index 0 "lshw").output | Out-File informacionunubntu.txt -Append
(Invoke-SSHCommand -Index 0 "nproc").output | Out-File informacionunubntu.txt -Append
```

### Ejemplo: obtener información sobre la versión de Linux
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.14 -Credential (Get-Credential)
Get-SSHSession
Invoke-SSHCommand -Index 0 "uname"
```

### Ejemplo: obtener información sobre la CPU
```PowerShell
# Realizar la conexión SSH
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -Computer
# Obtener información sobre el procesador desde Linux mediante una conexión SSH
(Invoke-SSHCommand -Index 0 "bash -c lscpu | grep '32-bit'")
(Invoke-SSHCommand -Index 0 "bash -c lscpu | grep '32-bit' | cut -d':' -f2  | cut -d'-' -f1 ").output
# ¿Es intel?
(Invoke-SSHCommand -Index 0 "lscpu").output
if((Invoke-SSHCommand -Index 0 "lscpu").output -match "Intel"){"Intel"}else{"No es Intel"}
(Invoke-SSHCommand -Index 0 "lscpu").output | select-string "cache"
```

### JuiceSSH - SSH Client
https://play.google.com/store/apps/details?id=com.sonelli.juicessh

### JuiceSSH Performance Plugin
https://play.google.com/store/apps/details?id=com.sonelli.juicessh.performancemonitor

### Guardar un fichero html preguntando al usuario qué título quiere
```PowerShell
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html
start chrome .\web.html
```

### Configurar IP en Windows
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

### Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## WSL
### Obtener información sobre la versión de Linux con WSL
```PowerShell
wsl uname -r
wsl uname -a
wsl cat /proc/version
```

### Información sobre la arquitectura
```PowerShell
(Invoke-SSHCommand -Index 0 "bash -c ""lscpu | grep 'Architecture'""").output
```

### Almacenar en un fichero información sobre la CPU mediante WSL desde PowerShell
```PowerShell
bash -c lscpu | Select-String "Architecture:","Model name:" | Out-File bonito.txt
[String]$var = bash -c lscpu | Select-String "Model name:"
$var.split("@")[1] | Out-File bonito.txt -Append
notepad .\bonito.txt
```

### 3. Gestión del hardware en Linux (nivel intermedio)
https://www.jesusninoc.com/03/03/3-gestion-del-hardware-en-linux-nivel-intermedio/
