# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

---------------

# Práctica final de la asignatura: crear mediante scripts una estructura de una red con un dominio y las configuraciones de GPOS que necesites

## Ayuda
* https://www.jesusninoc.com/05/03/creacion-masiva-de-usuarios-en-el-directorio-activo-con-powershell-parte-1/
* https://www.jesusninoc.com/03/05/create-users-add-into-a-group-and-share-directory-with-permissions-in-active-directory/
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-05-12.md#configurar-con-powershell

## Solución del alumno Alejandro Aracil

```PowerShell
# Crear una Unidades Organizativas:
New-ADOrganizationalUnit -Name "ESO" -Path "dc=red,dc=local"
New-ADOrganizationalUnit -Name "1ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "2ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "3ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "4ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "Equipos" -Path "ou=ESO,dc=red,dc=local"

New-ADOrganizationalUnit -Name "BACH" -Path "dc=red,dc=local"
New-ADOrganizationalUnit -Name "1ºBACH" -Path "ou=BACH,dc=red,dc=local"
New-ADOrganizationalUnit -Name "2ºBACH" -Path "ou=BACH,dc=red,dc=local"
New-ADOrganizationalUnit -Name "Equipos" -Path "ou=BACH,dc=red,dc=local"

Start-Sleep -Seconds 1

# Crear GRUPOS A PARTIR DE UN FICHERO
gc Z:\GruposExamen.txt | %{
    New-ADGroup -name (($_).split(",")[0]) -GroupScope Global
}
Start-Sleep -Seconds 1

# Crear usuarios y meterlos en un grupo
gc Z:\UsuariosExamen.txt | %{
    new-aduser -name (($_).split(",")[0]) -sam (($_).split(",")[0]) -accountpassword (convertto-securestring "Retamar1a" -asplaintext -force) -enable $true
    Add-ADGroupMember (($_).split(",")[1]) -Members (($_).split(",")[0])
    }
Start-Sleep -Seconds 1

# Mover usuarios a una OU
Move-ADObject "cn=juan,cn=users,dc=red,dc=local" -TargetPath "ou=1ºESO,ou=ESO,dc=red,dc=local"
Move-ADObject "cn=pedro,cn=users,dc=red,dc=local" -TargetPath "ou=1ºESO,ou=ESO,dc=red,dc=local"
Move-ADObject "cn=lucia,cn=users,dc=red,dc=local" -TargetPath "ou=2ºBACH,ou=BACH,dc=red,dc=local"
Move-ADObject "cn=Pepito,cn=users,dc=red,dc=local" -TargetPath "ou=2ºBACH,ou=BACH,dc=red,dc=local"
Start-Sleep -Seconds 1

# Linkar GPOs
New-GPLink -name "QuitarCMD" -Target "ou=1ºESO,ou=ESO,dc=red,dc=local" -Enforced Yes
New-GPLink -name "QuitarPanel" -Target "ou=1ºESO,ou=ESO,dc=red,dc=local" -Enforced Yes
New-GPLink -name "FondoDeEscritorio" -Target "ou=Equipos,ou=ESO,dc=red,dc=local" -Enforced Yes

New-GPLink -name "QuitarCMD" -Target "ou=2ºBACH,ou=BACH,dc=red,dc=local" -Enforced Yes
New-GPLink -name "QuitarPanel" -Target "ou=2ºBACH,ou=BACH,dc=red,dc=local" -Enforced Yes
New-GPLink -name "FondoDeEscritorio" -Target "ou=Equipos,ou=BACH,dc=red,dc=local" -Enforced Yes
```

## Solución con ejemplos de creación de políticas de grupo del alumno Ignacio Barranquero

```PowerShell
#Estructura, usuarios y políticas del AD

#Unidades Organizativas

    #Equipos

    New-ADOrganizationalUnit -Name "Ordenadores Colegio" -Path "DC=red,DC=local"
    New-ADOrganizationalUnit -Name "LTI" -Path "OU=Ordenadores Colegio,DC=red,DC=local"
    New-ADOrganizationalUnit -Name "LTIALUMNOS" -Path "OU=LTI,OU=Ordenadores Colegio,DC=red,DC=local"
    New-ADOrganizationalUnit -Name "LTINOALUMNOS" -Path "OU=LTI,OU=Ordenadores Colegio,DC=red,DC=local"

    (1..3) | %{
        New-ADOrganizationalUnit -Name $_ -Path "OU=LTIALUMNOS,OU=LTI,OU=Ordenadores Colegio,DC=red,DC=local"
    }

    #Alumnos

    New-ADOrganizationalUnit -Name "Usuarios" -Path "DC=red,DC=local"
    New-ADOrganizationalUnit -Name "Alumnos" -Path "OU=Usuarios,DC=red,DC=local"

    Set-ADDefaultDomainPasswordPolicy -ComplexityEnabled $False -Identity red.local #Deshabilitar complejidad de contraseña

    Import-Csv C:\Users\Administrator\Desktop\alumnos.txt | %{
        
        $curso=$_.curso

        New-ADOrganizationalUnit -Name $curso -Path "OU=Alumnos,OU=Usuarios,DC=red,DC=local"

#Usuarios y grupos

        New-ADGroup -Name $curso -GroupScope DomainLocal -Path "OU=$curso,OU=Alumnos,OU=Usuarios,DC=red,DC=local"

        New-ADUser -Name $_.nombre -SamAccountName $_.nombre -DisplayName $_.nombre `
        -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.password -AsPlainText -force) `
        -PassThru -UserPrincipalName $_.nombre -Path "OU=$curso,OU=Alumnos,OU=Usuarios,DC=red,DC=local"

        Add-ADGroupMember -Identity "CN=$curso,OU=$curso,OU=alumnos,OU=Usuarios,DC=red,DC=local" $_.nombre
    }


#Políticas de grupo


#Deshabilitar Windows Defender

New-GPO -Name "Windows Defender" -Comment "Deshabilita Windows Defender Antivirus"
Set-GPRegistryValue -Name "Windows Defender" -Key "HKLM\Software\Policies\Microsoft\Windows Defender" -ValueName DisableAntiSpyware -Type DWord -Value 1
New-GPLink -Name "Windows Defender" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar Cortana

New-GPO -Name "Cortana" -Comment "Deshabilita las funciones de Cortana"
Set-GPRegistryValue -Name "Cortana" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" -ValueName AllowCortana -Type DWord -Value 0
Set-GPRegistryValue -Name "Cortana" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" -ValueName AllowCortanaAboveLock -Type DWord -Value 0
Set-GPRegistryValue -Name "Cortana" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" -ValueName AllowSearchToUseLocation -Type DWord -Value 0
New-GPLink -Name "Cortana" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar animación del primer inicio de sesión

New-GPO -Name "Animación de inicio" -Comment "Deshabilita la animación del primer inicio de sesión"
Set-GPRegistryValue -Name "Animación de inicio" -Key "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System" -ValueName EnableFirstLogonAnimation -Type DWord -Value 0
New-GPLink -Name "Animación de inicio" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar Firewall

New-GPO -Name "Firewall" -Comment "Deshabilita el Firewall"
Set-GPRegistryValue -Name "Firewall" -Key "HKLM\SOFTWARE\Policies\Microsoft\WindowsFirewall\DomainProfile" -ValueName EnableFirewall -Type DWord -Value 0
Set-GPRegistryValue -Name "Firewall" -Key "HKLM\SOFTWARE\Policies\Microsoft\WindowsFirewall\StandardProfile" -ValueName EnableFirewall -Type DWord -Value 0
New-GPLink -Name "Firewall" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar Notificaciones

New-GPO -Name "Notificaciones equipo" -Comment "Deshabilita las notificaciones"
Set-GPRegistryValue -Name "Notificaciones equipo" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows Defender Security Center\Notifications" -ValueName DisableNotifications -Type DWord -Value 1
New-GPLink -Name "Notificaciones equipo" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

New-GPO -Name "Notificaciones usuario" -Comment "Deshabilita las notificaciones"
Set-GPRegistryValue -Name "Notificaciones usuario" -Key "HKCU\Software\Policies\Microsoft\Windows\CurrentVersion\PushNotifications" -ValueName NoToastApplicationNotification -Type DWord -Value 1
Set-GPRegistryValue -Name "Notificaciones usuario" -Key "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer" -ValueName TaskbarNoNotification -Type DWord -Value 1
Set-GPRegistryValue -Name "Notificaciones usuario" -Key "HKCU\Software\Policies\Microsoft\Windows\Explorer" -ValueName DisableNotificationCenter -Type DWord -Value 1
New-GPLink -Name "Notificaciones usuario" -Target "OU=Usuarios,DC=red,DC=local"
```

-------------
-------------

# Linux (repaso)
* https://devdocs.io/bash/

## WSL
* https://www.jesusninoc.com/05/24/interoperabilidad-wsl-con-windows-llamar-a-powershell-desde-ubuntu/
* https://www.jesusninoc.com/12/07/crear-y-leer-un-codigo-de-barras-con-un-comando-en-bash-mediante-wsl-desde-powershell/
* https://www.jesusninoc.com/03/17/convertir-en-formato-json-un-objeto-de-powershell-y-despues-convertirlo-nuevamente-a-un-codigo-qr-mediante-un-comando-en-bash-con-wsl-comprobar-que-se-lee-correctamente-el-codigo-qr/

## Ejercicios heterogéneos
* https://www.jesusninoc.com/03/27/ejercicios-de-bash-realizar-tareas-basicas-y-avanzadas/
* https://www.jesusninoc.com/node-js/
* https://www.jesusninoc.com/04/08/obtener-las-coordenadas-gps-mediante-adb/
* https://www.jesusninoc.com/03/25/ejecutar-google-chrome-en-android-mediante-adb-a-traves-de-powershell/
* https://www.jesusninoc.com/03/24/realizar-un-script-mezclando-python-y-powershell-que-detecte-las-coordenadas-de-un-texto-o-una-imagen-dentro-de-una-captura-de-pantalla-y-hacer-clic-en-dicha-posicion-hacerlo-de-forma-indefinida/
* https://ehmatthes.github.io/pcc/cheatsheets/README.html

------------
------------

# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

--------------------------

# Saltar restricciones
* https://www.jesusninoc.com/04/24/ejecutar-la-calculadora-a-traves-de-explorer/
* https://www.jesusninoc.com/06/04/ejecutar-la-informacion-que-se-encuentra-en-un-valor-dentro-de-la-clave-clsid-del-registro-de-windows/
* https://www.jesusninoc.com/02/01/explicacion-sobre-el-uso-de-funciones-que-estan-en-dll-del-sistema-operativo-en-powershell/
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-04-05.md

# Auditoría

## Enumeración FileSystemRights: Define los derechos de acceso que se utilizará al crear reglas de acceso y auditoría
https://msdn.microsoft.com/es-es/library/system.security.accesscontrol.filesystemrights(v=vs.110).aspx
```PowerShell
[Enum]::GetNames([System.Security.AccessControl.FileSystemRights]) 
```

## Eventos
### 10. Gestión del rendimiento en PowerShell (nivel intermedio)
https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
### EventLog
https://www.jesusninoc.com/eventlog/
### Saber quién inició sesión en el sistema operativo de forma detallada analizando el registro de eventos de Windows (se requieren privilegios de administrador)
https://www.jesusninoc.com/07/23/saber-quien-inicio-sesion-en-el-sistema-operativo-de-forma-detallada-analizando-el-registro-de-eventos-de-windows-se-requieren-privilegios-de-administrador/
### Windows EVTX Samples [More than 160 EVTX examples]
https://github.com/sbousseaden/EVTX-ATTACK-SAMPLES
### Crear eventos
* https://www.jesusninoc.com/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/
* https://www.jesusninoc.com/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

## Auditoría de proceso de línea de comandos
https://docs.microsoft.com/es-es/windows-server/identity/ad-ds/manage/component-updates/command-line-process-auditing

-------------
-------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Introducción

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

## Encontrarse a uno mismo
```PowerShell
Get-EventLog Security | Where-Object Message -Match "asir1joselui"
```

## Ejemplos de introducción a monitorizar
```PowerShell
# (INCORRECTO) Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
Get-CimInstance -ClassName Win32_StartupCommand  | select Caption, @{n='NombreP';e={(Get-Process -name $_.Caption | Select Name).name}}

# Comprobar que se está ejecutando un programa que se arranca al inicio del arranque del sistema operativo
Get-Process -Name MSOSYNC

# (CORRECTO 1) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

Get-Process -Name $acumul

# (CORRECTO 2) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
function comprobar($programa){
    Get-Process -Name $programa -ErrorAction Ignore
}

Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        comprobar $temperal[$temperal.Count-1]

}

# (CORRECTO 3) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

$acumul | %{
    $_
    ((Get-Process).name.toupper()).contains($_.toupper())
}
```

## Ejercicio: registrar un evento cuando se logre realizar una conexión entre un cliente y un servidor mediante UDP (almacenar la dirección IP de la conexión del cliente o del servidor)
* https://www.jesusninoc.com/05/08/ejercicios-de-powershell-registrar-un-evento-cuando-se-logre-realizar-una-conexion-entre-un-cliente-y-un-servidor-mediante-udp-almacenar-la-direccion-ip-de-la-conexion-del-cliente-o-del-servidor/

### Solución (otra forma de verlo, el cliente manda crear un log al servidor)

#### Cliente
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "192.168.43.108" -Category 2 -RawData 10,20')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
#### Servidor
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
Invoke-Expression ([Text.Encoding]::ASCII.GetString($content))
```

-------------------
-------------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------------

# Monitorizar procesos
## 7. Gestión de procesos en PowerShell
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

## System Monitor
System Monitor (Sysmon) is a Windows system service and device driver that, once installed on a system, remains resident across system reboots to monitor and log system activity to the Windows event log. It provides detailed information about process creations, network connections, and changes to file creation time. By collecting the events it generates using Windows Event Collection or SIEM agents and subsequently analyzing them, you can identify malicious or anomalous activity and understand how intruders and malware operate on your network.
* https://www.fwhibbit.es/sysmon-el-gran-hermano-de-windows-y-el-super-sysmonview

Install with default settings (process images hashed with sha1 and no network monitoring)
```MD-DOS
sysmon -accepteula –i
```
Install with md5 and sha256 hashing of process created and monitoring network connections
```MD-DOS
sysmon -accepteula –i –h md5,sha256 –n
```
Install Sysmon with a configuration file (as described below)
```MD-DOS
sysmon –accepteula –i c:\windows\config.xml
```
Uninstall
```MD-DOS
sysmon –u
```
Dump the current configuration
```MD-DOS
sysmon –c
```
Change the configuration to use all hashes, no network monitoring and monitoring of DLLs in Lsass
```MD-DOS
sysmon –c –h * –l lsass.exe
```
Change the configuration of sysmon with a configuration file (as described below)
```MD-DOS
sysmon –c c:\windows\config.xml
```
Change the configuration to default settings
```MD-DOS
sysmon –c --
```
Show the configuration schema
```MD-DOS
sysmon -s
```

## Sources, configuration and how to detect evil things utilizing Microsoft Sysmon
https://github.com/MHaggis/sysmon-dfir

--------------
--------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------

# Logs

## Logs en Windows

### PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

### List event log
https://www.jesusninoc.com/2018/03/27/list-event-log

### Write-EventLog
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/write-eventlog?view=powershell-5.1

### Escribir y ver un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Almacenar información convertida a byte en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/05/almacenar-informacion-convertida-a-byte-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Ejecutar la información que se encuentra en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/06/ejecutar-la-informacion-que-se-encuentra-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Windows Event Log to the Dark Side — Storing Payloads and Configurations
https://medium.com/@5yx/windows-event-log-to-the-dark-side-storing-payloads-and-configurations-9c8ad92637f2

### Active Directory: Configuring Event Log Subscriptions (Forwarding)
https://sid-500.com/2018/04/23/active-directory-configuring-event-log-subscriptions-forwarding/

### HOW TO DETECT PASS-THE-HASH ATTACKS
https://blog.stealthbits.com/how-to-detect-pass-the-hash-attacks/

## Logs en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-13.md#registros-de-sucesos

```Bash
cd /var/log
ls
```

- /var/log/message: registro de mensajes generales del sistema
- /var/log/auth.log: log de autenticación
- /var/log/kern.log: registro del kernel
- /var/log/cron.log: registro de cron
- /var/log/maillog: registro del servidor de mails
- /var/log/qmail/ : registro de Qmail
- /var/log/httpd/: registro de errores y accesos a Apache
- /var/log/lighttpd: registro de errores y accesos a Lighttpd
- /var/log/boot.log : registro de inicio del sistema
- /var/log/mysqld.log: registro de la base de datos MySQL
- /var/log/secure: log de autenticación
- /var/log/utmp or /var/log/wtmp : registro de logins

### Analizar logs en Linux
#### Regular Expressions
```Bash
 grep -a "user juanito" /var/log/auth.log
```
#### Tail
```Bash
$ tail -f /var/log/auth.log | grep -a 'invalid'
```
#### Cut
```Bash
grep "authentication failure" /var/log/auth.log | cut -d '=' -f 8
```
#### Awk
```Bash
awk '/sshd.*invalid user/ { print $9 }' /var/log/auth.log
```
