# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

-----------------

# Ejemplos

## Tener en cuenta
 - IP
 - ping
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

## Configurar
- Requisitos de seguridad del sistema y de los datos (CONFIGURAR LA DIRECTIVA DE SEGURIDAD DE BLOQUEO)
- Derechos de usuario (DERECHO QUE OS PAREZCA)
- Directivas de seguridad (DIRECTIVA DE SEGURIDAD PARA TODOS LOS CASOS + DERECHO DE USUARIO):
  - Locales
  - Del controlador de dominio
  - Del dominio.

---------

# Práctica
- Directivas de grupo:
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión (CREAR SCRIPT QUE ALMACENA LA HORA DE INICIO, APAGADO, INICIO Y CIERRE DE SESIÓN)

-----------------

# Teoría

## GPOs

### Creación y manejo de GPO
http://www.developandsys.es/creacion-manejo-gpo/
### Mapeo de unidades red Windows Server
http://www.developandsys.es/mapeo-unidades-red-windows-server/
### Cómo Funcionan las Directivas de Grupo (GPOs)
https://windowserver.wordpress.com/2011/02/10/como-funcionan-las-directivas-de-grupo-gpos/
### Directivas de Grupo (GPO) – Herencia, Forzado y Resolución de Conflictos
https://windowserver.wordpress.com/2017/07/11/directivas-de-grupo-gpo-herencia-forzado-y-resolucin-de-conflictos/
### Directivas de Grupo (GPO) – Filtrado de Seguridad
https://windowserver.wordpress.com/2017/07/11/directivas-de-grupo-gpo-filtrado-de-seguridad/

## Orden de aplicación de las directivas
Tener en cuenta:
- Más abajo la última que se ejecuta
- Administrador decide la aplicación
Niveles de aplicación:
- Sitio
- Dominio
- GPO

----------
----------

# Repaso
- Acceso remoto
- Github
- PowerShell introducción
  - Buscar cmdlets
    - https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/
  - WSL
    - https://www.jesusninoc.com/03/26/libro-de-powershell-nivel-avanzado-libro-gratis-de-powershell-tutorial-gratis-de-powershell/
  - AD
    - https://www.jesusninoc.com/07/11/11-gestion-del-directorio-activo-nivel-intermedio/
  - Cmdlets de red
    - https://www.jesusninoc.com/07/09/9-gestion-de-la-red-en-powershell/
  - Pipe
    - https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/#Canalizaciones
  - PSProvider (funciones)
    - https://www.jesusninoc.com/03/17/ejercicios-de-powershell-mapear-varias-unidades-que-se-encuentran-en-un-fichero/
  - PSDrive
    - https://www.jesusninoc.com/get-psdrive/
  - WMI
    - https://www.jesusninoc.com/wmi/
  - Datos
    - https://www.jesusninoc.com/07/02/2-programacion-en-powershell/
  - Scripting
    - https://www.jesusninoc.com/08/03/3-creacion-de-scripts-en-powershell-nivel-avanzado/
  - Funciones complejas
    - https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Funciones
  - PowerShell remoto
    - https://www.jesusninoc.com/01/10/enable-psremoting/
    - https://www.jesusninoc.com/enter-pssession/
    - https://www.jesusninoc.com/invoke-command/
  - Segundo plano
    - https://www.jesusninoc.com/12/23/crear-un-trabajo-start-job-en-powershell-y-recibirlo-receive-job/
  - Tareas programadas
    - https://www.jesusninoc.com/12/08/crear-una-tarea-programada-en-windows-que-ejecute-un-script-de-powershell-cada-10-minutos-de-forma-indefinida-aunque-el-porcentaje-de-bateria-sea-bajo/
    - https://www.jesusninoc.com/schedule-tasks/
  - Scripts de perfil
    - https://www.jesusninoc.com/07/15/cargar-un-mensaje-de-bienvenida-en-el-perfil-de-usuario-en-powershell/

-------

# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

-----------------

# Práctica

## Tener en cuenta
 - IP
 - ping
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

## Configurar
- Directivas de grupo:
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión (REALIZAR UN LOG SI EL USUARIO ES usuario1 Y HA INICIADO SESIÓN) (REALIZAR UN LOG SI EL USUARIO ES usuario1, HA INICIADO SESIÓN ENTRE LAS 20:00 Y LAS 21:00)
    - https://www.jesusninoc.com/04/15/ejercicios-de-powershell-detectar-si-un-usuario-tiene-iniciada-la-sesion-entre-un-rango-de-horas/

-------------
-------------

# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

-----------------

# Teoría

## GPOs

### Directivas de Grupo (GPO) – Filtrado de Seguridad
https://windowserver.wordpress.com/2017/07/11/directivas-de-grupo-gpo-filtrado-de-seguridad/

## Orden de aplicación de las directivas
Tener en cuenta:
- Más abajo la última que se ejecuta
- Administrador decide la aplicación
Niveles de aplicación:
- Sitio
- Dominio
- GPO

---------

# Práctica

## Tener en cuenta
 - IP
 - ping
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

## Ejercicios de PowerShell
- Crear usuarios, carpetas NTFS y compartidas
  * https://www.jesusninoc.com/05/03/creacion-masiva-de-usuarios-en-el-directorio-activo-con-powershell-parte-1/
  * https://www.jesusninoc.com/05/09/creacion-masiva-de-usuarios-en-el-directorio-activo-con-powershell-parte-2/

- Crear usuarios en AD, carpeta compartida y asignar permisos
```PowerShell
  foreach($usuario in Get-Content .\usuarios.txt)
  {
      $usuario
      $password = (ConvertTo-SecureString "Alum4dos" -AsPlainText -force)
      New-ADUSer -Name $usuario -Sam $usuario -Path "OU=asir,DC=andel,DC=local" -AccountPassword $password -Enable $true
      $HomeDirectory = ("\\localhost\log\" + $usuario)
      mkdir $HomeDirectory
      $usuariomaspermiso = $usuario + ":F"
      $rutantfs = "C:\Users\Administrador\Desktop\log\" + $usuario
      icacls $rutantfs /grant $usuariomaspermiso
      Start-Sleep -Seconds 5
  }
```

## Configurar
- Directivas de grupo:
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión (REALIZAR UN LOG SI EL USUARIO ES usuario1 Y HA INICIADO SESIÓN) (REALIZAR UN LOG SI EL USUARIO ES usuario1, HA INICIADO SESIÓN ENTRE LAS 20:00 Y LAS 21:00)
- Directivas de grupo:
  - Redirección de carpetas (CARPETA DOCUMENTOS REDIRECCIONADA A LA CARPETA COMPARTIDA) https://www.youtube.com/watch?v=hSALOgf7SwY
  - Orden de aplicación de las directivas (CONFIGURAR GPOS PARA VER EL ORDEN)
  - Conjunto resultante de directivas (ANALIZAR EL CONJUNTO RESULTANTE DE DIRECTIVAS)
  - Especificar las opciones de seguridad 
- Filtrar la directiva en función de la pertenencia a grupos de seguridad

# Tarea sobre directivas
- MAPEAR DOS UNIDADES PARA UN USUARIO Y OCULTAR LAS UNIDADES LOCALES MEDIANTE GPO
- BLOQUEAR UNA APLICACIÓN MEDIANTE GPO

-------------------
-------------------

# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

----------------------

# Tener en cuenta
 - IP
 - ping
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

----------------------

# Algo de teoría
## Manual del editor de GPO local en Windows 10
https://www.solvetic.com/tutoriales/article/2655-manual-del-editor-de-gpo-local-en-windows-10/

## How to Disable PowerShell with Software Restriction Policies GPO
https://www.top-password.com/blog/disable-powershell-with-software-restriction-policies-gpo

## Exportar información de una GPO (para ver referencia al registro)
https://www.jesusninoc.com/05/05/exportar-informacion-sobre-una-gpo-en-formato-xml/

-----------
-----------

# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

----------------------

# Directivas de grupo con PowerShell

## Configuración gráfica de repaso
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-05-07.md#tarea-sobre-directivas
* https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/
* https://docs.microsoft.com/en-us/powershell/module/applocker/Get-AppLockerPolicy?view=win10-ps

## Configurar con PowerShell
* https://sid-500.com/2017/08/25/configuring-group-policies-by-using-windows-powershell/

```PowerShell
Get-Command -Module GroupPolicy
New-GPO -Name "ScreenSaverTimeOut" -Comment "Sets the time to 900 seconds"
Set-GPRegistryValue -Name "ScreenSaverTimeOut" -Key "HKCU\Control Panel\Desktop" -ValueName ScreenSaveTimeOut -Type DWord -Value 900
New-GPLink -Name "ScreenSaverTimeOut" -Target "ou=people,dc=pagr,dc=inet"

Get-GPO -Name "ScreenSaverTimeOut" | Get-GPOReport -ReportType HTML -Path $Home\report.html
Invoke-Item $Home\report.html

# Configure Advanced Settings
## Inherited Group Policies
Get-GPInheritance -Target "ou=people,dc=pagr,dc=inet"

## Blocking inheritance
Set-GPInheritance -Target "ou=people,dc=pagr,dc=inet" -IsBlocked 1

## Enforcing Group Policies
Set-GPLink -Name "Default Domain Policy" -Target "dc=pagr,dc=inet" -Enforced Yes

## Configure Security Settings
Set-GPPermission -Name "ScreenSaverTimeOut" -TargetName "Authenticated Users" -TargetType User -PermissionLevel None
Set-GPPermission -Name "ScreenSaverTimeOut" -TargetName "Authenticated Users" -TargetType User -PermissionLevel GPORead
Set-GPPermission -Name "ScreenSaverTimeOut" -TargetName "Petra" -TargetType User -PermissionLevel GPOApply
```

----------------------

# Directivas de grupo

## Configurar
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas
  - No reemplazar
  
## Teoría
- Bloquear herencia.
- Forzar una directiva: al haber forzado la aplicación de la GPO, en este caso sobrepasará el bloqueo de herencia https://windowserver.wordpress.com/2017/07/11/directivas-de-grupo-gpo-herencia-forzado-y-resolucin-de-conflictos/.

## Práctica
```PowerShell
Get-GPO -Name "ScreenSaverTimeOut" | Get-GPOReport -ReportType HTML -Path $Home\report.html
Invoke-Item $Home\report.html

# Configure Advanced Settings
## Inherited Group Policies
Get-GPInheritance -Target "ou=people,dc=pagr,dc=inet"

## Blocking inheritance
Set-GPInheritance -Target "ou=people,dc=pagr,dc=inet" -IsBlocked 1

## Enforcing Group Policies
Set-GPLink -Name "Default Domain Policy" -Target "dc=pagr,dc=inet" -Enforced Yes
```

----------------------

# Directivas de grupo

## Configurar
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
  
## Teoría
- Filtrado de seguridad (permisos) https://windowserver.wordpress.com/2017/07/11/directivas-de-grupo-gpo-filtrado-de-seguridad/

## Práctica
```PowerShell
# Configure Advanced Settings
## Configure Security Settings
Set-GPPermission -Name "ScreenSaverTimeOut" -TargetName "Authenticated Users" -TargetType User -PermissionLevel None
Set-GPPermission -Name "ScreenSaverTimeOut" -TargetName "Authenticated Users" -TargetType User -PermissionLevel GPORead
Set-GPPermission -Name "ScreenSaverTimeOut" -TargetName "Petra" -TargetType User -PermissionLevel GPOApply
```

--------------------------

# Práctica final de la asignatura: crear mediante scripts una estructura de una red con un dominio y las configuraciones de GPOS que necesites

## Ayuda
* https://www.jesusninoc.com/05/03/creacion-masiva-de-usuarios-en-el-directorio-activo-con-powershell-parte-1/
* https://www.jesusninoc.com/03/05/create-users-add-into-a-group-and-share-directory-with-permissions-in-active-directory/
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-05-12.md#configurar-con-powershell

## Solución del alumno Alejandro Aracil

```PowerShell
# Crear una Unidades Organizativas:
New-ADOrganizationalUnit -Name "ESO" -Path "dc=red,dc=local"
New-ADOrganizationalUnit -Name "1ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "2ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "3ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "4ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "Equipos" -Path "ou=ESO,dc=red,dc=local"

New-ADOrganizationalUnit -Name "BACH" -Path "dc=red,dc=local"
New-ADOrganizationalUnit -Name "1ºBACH" -Path "ou=BACH,dc=red,dc=local"
New-ADOrganizationalUnit -Name "2ºBACH" -Path "ou=BACH,dc=red,dc=local"
New-ADOrganizationalUnit -Name "Equipos" -Path "ou=BACH,dc=red,dc=local"

Start-Sleep -Seconds 1

# Crear GRUPOS A PARTIR DE UN FICHERO
gc Z:\GruposExamen.txt | %{
    New-ADGroup -name (($_).split(",")[0]) -GroupScope Global
}
Start-Sleep -Seconds 1

# Crear usuarios y meterlos en un grupo
gc Z:\UsuariosExamen.txt | %{
    new-aduser -name (($_).split(",")[0]) -sam (($_).split(",")[0]) -accountpassword (convertto-securestring "Retamar1a" -asplaintext -force) -enable $true
    Add-ADGroupMember (($_).split(",")[1]) -Members (($_).split(",")[0])
    }
Start-Sleep -Seconds 1

# Mover usuarios a una OU
Move-ADObject "cn=juan,cn=users,dc=red,dc=local" -TargetPath "ou=1ºESO,ou=ESO,dc=red,dc=local"
Move-ADObject "cn=pedro,cn=users,dc=red,dc=local" -TargetPath "ou=1ºESO,ou=ESO,dc=red,dc=local"
Move-ADObject "cn=lucia,cn=users,dc=red,dc=local" -TargetPath "ou=2ºBACH,ou=BACH,dc=red,dc=local"
Move-ADObject "cn=Pepito,cn=users,dc=red,dc=local" -TargetPath "ou=2ºBACH,ou=BACH,dc=red,dc=local"
Start-Sleep -Seconds 1

# Linkar GPOs
New-GPLink -name "QuitarCMD" -Target "ou=1ºESO,ou=ESO,dc=red,dc=local" -Enforced Yes
New-GPLink -name "QuitarPanel" -Target "ou=1ºESO,ou=ESO,dc=red,dc=local" -Enforced Yes
New-GPLink -name "FondoDeEscritorio" -Target "ou=Equipos,ou=ESO,dc=red,dc=local" -Enforced Yes

New-GPLink -name "QuitarCMD" -Target "ou=2ºBACH,ou=BACH,dc=red,dc=local" -Enforced Yes
New-GPLink -name "QuitarPanel" -Target "ou=2ºBACH,ou=BACH,dc=red,dc=local" -Enforced Yes
New-GPLink -name "FondoDeEscritorio" -Target "ou=Equipos,ou=BACH,dc=red,dc=local" -Enforced Yes
```

## Solución con ejemplos de creación de políticas de grupo del alumno Ignacio Barranquero

```PowerShell
#Estructura, usuarios y políticas del AD

#Unidades Organizativas

    #Equipos

    New-ADOrganizationalUnit -Name "Ordenadores Colegio" -Path "DC=red,DC=local"
    New-ADOrganizationalUnit -Name "LTI" -Path "OU=Ordenadores Colegio,DC=red,DC=local"
    New-ADOrganizationalUnit -Name "LTIALUMNOS" -Path "OU=LTI,OU=Ordenadores Colegio,DC=red,DC=local"
    New-ADOrganizationalUnit -Name "LTINOALUMNOS" -Path "OU=LTI,OU=Ordenadores Colegio,DC=red,DC=local"

    (1..3) | %{
        New-ADOrganizationalUnit -Name $_ -Path "OU=LTIALUMNOS,OU=LTI,OU=Ordenadores Colegio,DC=red,DC=local"
    }

    #Alumnos

    New-ADOrganizationalUnit -Name "Usuarios" -Path "DC=red,DC=local"
    New-ADOrganizationalUnit -Name "Alumnos" -Path "OU=Usuarios,DC=red,DC=local"

    Set-ADDefaultDomainPasswordPolicy -ComplexityEnabled $False -Identity red.local #Deshabilitar complejidad de contraseña

    Import-Csv C:\Users\Administrator\Desktop\alumnos.txt | %{
        
        $curso=$_.curso

        New-ADOrganizationalUnit -Name $curso -Path "OU=Alumnos,OU=Usuarios,DC=red,DC=local"

#Usuarios y grupos

        New-ADGroup -Name $curso -GroupScope DomainLocal -Path "OU=$curso,OU=Alumnos,OU=Usuarios,DC=red,DC=local"

        New-ADUser -Name $_.nombre -SamAccountName $_.nombre -DisplayName $_.nombre `
        -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.password -AsPlainText -force) `
        -PassThru -UserPrincipalName $_.nombre -Path "OU=$curso,OU=Alumnos,OU=Usuarios,DC=red,DC=local"

        Add-ADGroupMember -Identity "CN=$curso,OU=$curso,OU=alumnos,OU=Usuarios,DC=red,DC=local" $_.nombre
    }


#Políticas de grupo


#Deshabilitar Windows Defender

New-GPO -Name "Windows Defender" -Comment "Deshabilita Windows Defender Antivirus"
Set-GPRegistryValue -Name "Windows Defender" -Key "HKLM\Software\Policies\Microsoft\Windows Defender" -ValueName DisableAntiSpyware -Type DWord -Value 1
New-GPLink -Name "Windows Defender" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar Cortana

New-GPO -Name "Cortana" -Comment "Deshabilita las funciones de Cortana"
Set-GPRegistryValue -Name "Cortana" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" -ValueName AllowCortana -Type DWord -Value 0
Set-GPRegistryValue -Name "Cortana" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" -ValueName AllowCortanaAboveLock -Type DWord -Value 0
Set-GPRegistryValue -Name "Cortana" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" -ValueName AllowSearchToUseLocation -Type DWord -Value 0
New-GPLink -Name "Cortana" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar animación del primer inicio de sesión

New-GPO -Name "Animación de inicio" -Comment "Deshabilita la animación del primer inicio de sesión"
Set-GPRegistryValue -Name "Animación de inicio" -Key "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System" -ValueName EnableFirstLogonAnimation -Type DWord -Value 0
New-GPLink -Name "Animación de inicio" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar Firewall

New-GPO -Name "Firewall" -Comment "Deshabilita el Firewall"
Set-GPRegistryValue -Name "Firewall" -Key "HKLM\SOFTWARE\Policies\Microsoft\WindowsFirewall\DomainProfile" -ValueName EnableFirewall -Type DWord -Value 0
Set-GPRegistryValue -Name "Firewall" -Key "HKLM\SOFTWARE\Policies\Microsoft\WindowsFirewall\StandardProfile" -ValueName EnableFirewall -Type DWord -Value 0
New-GPLink -Name "Firewall" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar Notificaciones

New-GPO -Name "Notificaciones equipo" -Comment "Deshabilita las notificaciones"
Set-GPRegistryValue -Name "Notificaciones equipo" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows Defender Security Center\Notifications" -ValueName DisableNotifications -Type DWord -Value 1
New-GPLink -Name "Notificaciones equipo" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

New-GPO -Name "Notificaciones usuario" -Comment "Deshabilita las notificaciones"
Set-GPRegistryValue -Name "Notificaciones usuario" -Key "HKCU\Software\Policies\Microsoft\Windows\CurrentVersion\PushNotifications" -ValueName NoToastApplicationNotification -Type DWord -Value 1
Set-GPRegistryValue -Name "Notificaciones usuario" -Key "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer" -ValueName TaskbarNoNotification -Type DWord -Value 1
Set-GPRegistryValue -Name "Notificaciones usuario" -Key "HKCU\Software\Policies\Microsoft\Windows\Explorer" -ValueName DisableNotificationCenter -Type DWord -Value 1
New-GPLink -Name "Notificaciones usuario" -Target "OU=Usuarios,DC=red,DC=local"
```
