# Administración del acceso al dominio:
- Equipos del dominio.
- Permisos y derechos.
- Delegación de permisos / autoridad.
  - Asistente para la delegación de control.
  - Herramientas de línea de comandos: dsacls.exe y dsrevoke.exe.	🤦
- Listas de control de acceso.

## Tener en cuenta
 - IP fija
 - ping
 - DNS
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

# Usuarios y grupos
## Añadir usuarios y grupos desde el AD (GPO)
* https://www.cesarherrada.com/2014/07/que-son-y-para-que-sirven-los-grupos-restringidos.html

# Ejercicios
## Ejercicios con scripts
- Analizar GPO (en remoto y local)
  - Local
    * https://www.jesusninoc.com/05/12/view-group-policy-objects/
    ```PowerShell
      $resulta = gpresult /z
      foreach($lineas in $resulta)
      {
          if($lineas -match "CMD")
          {
              $lineas
          }
      } 
    ```
  - Remoto
    * https://www.jesusninoc.com/04/23/obtener-gpos-objetos-de-directiva-de-grupo-que-no-se-estan-utilizando/
    ```PowerShell
    Get-GPO -All | %{
      $_ | Get-GPOReport -ReportType XML | Select-String "Impedir el acceso al símbolo del sistema"
    }
    ```
    
------------------
------------------

# Linux scripting
- Vamos por el if

# WSL
* https://www.jesusninoc.com/05/24/interoperabilidad-wsl-con-windows-llamar-a-powershell-desde-ubuntu/

-------------
-------------

# Bloquear lo que diga
- Compartir en el server que se vea en el cliente
- Permisos correctos de NTFS y compartir
- GPO de inicio
- Script de PowerShell que abre un proceso y lee un fichero (todo compartido)

-----------------
-----------------

# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

-----------------

# Teoría sobre directivas (Registro + tareas programadas + GPO)

## Registro

### EJECUTAR SOLO UNA VEZ UN PROGRAMA AL INICIAR LA SESIÓN DE UN USUARIO
* https://www.jesusninoc.com/04/13/ejecutar-solo-una-vez-un-programa-al-iniciar-la-sesion-de-un-usuario/
### EjemplosRegistroHardware.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Registro/EjemplosRegistroHardware.ps1
### ¿CÓMO SABER SI ALGUIEN HA UTILIZADO MI ORDENADOR?
* https://www.jesusninoc.com/04/20/como-saber-si-alguien-ha-utilizado-mi-ordenador/
### REGISTRY
* https://www.jesusninoc.com/registry/
### WINDOWS REGISTRY AUDITING CHEAT SHEET - Win 7/Win 2008 or later
* https://static1.squarespace.com/static/552092d5e4b0661088167e5c/t/5a00963153450a8779b23489/1509987890282/Windows+Registry+Auditing+Cheat+Sheet+ver+Nov+2017.pdf

------------
------------

# Prueba sobre carpetas compartidas (NETLOGON)

--------------
--------------

# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

-----------------

## Tareas programadas

### CREAR TAREAS LEYENDO DE UN JSON
* https://www.jesusninoc.com/03/05/leer-un-fichero-json-desde-powershell/
* https://www.jesusninoc.com/04/19/crear-una-tarea-programada/
* https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
* https://www.jesusninoc.com/12/08/crear-una-tarea-programada-en-windows-que-ejecute-un-script-de-powershell-cada-10-minutos-de-forma-indefinida-aunque-el-porcentaje-de-bateria-sea-bajo/

## GPOs

### GPO y registro
* https://www.jesusninoc.com/05/05/exportar-informacion-sobre-una-gpo-en-formato-xml/
### DIRECTIVAS DE GRUPO
* https://www.jesusninoc.com/07/11/11-gestion-del-directorio-activo-nivel-intermedio/#Directivas_de_Grupo
### Aplicación GPOs
* http://www.developandsys.es/aplicacion_de_gpos/
### Asignación de derechos de usuario
* https://docs.microsoft.com/es-es/windows/security/threat-protection/security-policy-settings/user-rights-assignment
### Orden de aplicación de las directivas
- Tener en cuenta:
  - Más abajo la última que se ejecuta
  - Administrador decide la aplicación
- Niveles de aplicación:
  - Sitio
  - Dominio
  - GPO

----------------
----------------

# Trabajo sobre Directorio Activo: aplicar GPO
* http://www.developandsys.es/aplicacion_de_gpos/
