# Comunicación entre dos clientes que se validan en un servidor

---------------
---------------

# Situación crítica 1 (resolver la siguiente situación con scripts)

## Los hospitales están habilitando zonas nuevas para poder atender a pacientes, eso quiere decir que van a utilizar equipos clientes y servidores, tu tarea es ser capaz de poner odenadores nuevos con la misma configuración que tienen los anteriores (usuarios, programas, actualizaciones, carpetas compartidas) y no solo es clonar y ya. Crea un procedimiento con scripts para resolver la situación.

## Ejemplos de cómo se puede resolver la situación:

- Sacar los usuarios de un equipo y crearlos en otro leyendo de un fichero.
- Ver los programas que hay instalados en un equipo e instalarlos en otro leyendo de un fichero.
- Ver las carpetas compartidas que hay en un equipo y crearlas en otro leyendo de un fichero.

## Ideas que se pueden aplicar:
- Tareas programadas https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#hyper-v-backup-vms-to-a-shared-folder-with-windows-server-backup-and-a-scheduled-task-
- WMI Query Language https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#wmi-query-language
- Ejercicios curso MySQL con PowerShell https://www.jesusninoc.com/2017/02/20/ejercicios-curso-mysql-con-powershell/
- Leer un usuario desde un servidor web (HTML, XML, JSON) crearlo y meterlo en el grupo de administradores (no te olvides del password).
- Detectar mediante una función que el usuario pertenece al grupo de administradores.
- Intentar utilizar las credenciales de un usuario y verificar que funciona (guarda en un fichero la captura).
- Expresiones regulares https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-13.md#expresiones-regulares

-----------------

# Solución a la situación crítica 1

## Seleccionar usuarios que empiezan por una letra (con una expresión regular)
* https://www.jesusninoc.com/04/12/ejercicios-de-powershell-seleccionar-usuarios-que-empiezan-por-una-letra-con-una-expresion-regular/

## Restaurar usuarios creados anteriormente
* https://www.jesusninoc.com/03/13/ejercicios-de-powershell-restaurar-usuarios-que-se-han-creado-anteriormente-se-almacenan-en-un-fichero-y-se-vuelven-a-crear/

## Ver los progrmas que hay instalados en un equipo e instalarlos en otro leyendo de un fichero
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-ver-los-programas-que-hay-instalados-en-un-equipo-e-instalarlos-en-otro-guardar-el-nombre-de-los-programas-en-un-fichero/

## Mapear unidades
* https://www.jesusninoc.com/03/17/ejercicios-de-powershell-mapear-varias-unidades-que-se-encuentran-en-un-fichero/
* https://www.jesusninoc.com/02/16/ejercicios-de-powershell-mapear-varios-recursos-unidades-creando-tambien-las-carpetas-y-compartiendo-leyendo-de-un-fichero-el-nombre-el-mismo-nombre-para-todas-las-operaciones-de-la-carpeta-que/

## Poner bonito
* https://www.jesusninoc.com/02/25/ejercicios-de-powershell-crear-un-menu-sencillo/

# Solución a la situación crítica 2 (muy avanzada)

## Instalar software en cualquier equipo de la red desde PowerShell leyendo desde un archivo la información para instalar utilizando credenciales almacenados (solución de Diego A.)
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-09.md#instalar-software-en-cualquier-equipo-de-la-red-desde-powershell-leyendo-desde-un-archivo-la-informaci%C3%B3n-para-instalar-utilizando-credenciales-almacenados-soluci%C3%B3n-de-diego-a

-----------
-----------

# Situación crítica 2 (resolver la siguiente situación con scripts)

## Dentro de una empresa se está ejecutando una aplicación de forma anómala, utiliza todo lo que sabes para crear funciones en un script que permitan detectar la aplicación.

### Ideas que se pueden aplicar:
- ¿Cómo detectar que se está ejecutando un proceso? https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#c%C3%B3mo-detectar-que-se-est%C3%A1-ejecutando-un-proceso
- Mostrar un mensaje en PowerShell cuando se ejecuta y se para un programa https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#mostrar-un-mensaje-en-powershell-cuando-se-ejecuta-y-para-un-programa

-----------------

# Solución a la situación crítica 2

## Vamos a tener en cuenta:
- Un proceso que no se comporta como siempre es raro.
- Un proceso que abre muchos hilos es raro.
- Analizar los hilos de un proceso en concreto
- Un proceso que abre muchas comunicaciones es raro.
- Un proceso que consume fuera de normal es raro.
- Un proceso que se activa a una hora extraña es raro.
- Un proceso cuya firma ha cambiado es extraño.
- Mostrar los procesos que utiliza un controlador

## Scripts para cada uno de los apartados anteriores
* https://www.jesusninoc.com/03/02/ejercicios-de-seguridad-analizar-informacion-sobre-procesos-de-forma-detallada-en-windows-con-powershell/

----------
----------

# Situación crítica 3 (resolver la siguiente situación con scripts)

## Crear para cada usuario lo necesario para funcionar en un puesto de trabajo teniendo en cuenta:
- Los usuarios se crean en el Directorio Activo.
- La información se lee de un fichero que cada línea contiene la siguiente información nombre de usuario, grupo al que pertenece, nombre de carpeta compartida, permisos.
- Cada usuario tiene una carpeta compartida con su nombre (y solo ese usuario tiene permisos tanto NTFS como permisos de compartir).

### Ideas que se pueden aplicar:
- Teoría sobre AD https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-18.md
- Crear usuarios en AD https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-24.md#crear-en-ad-usuarios-y-ou-leyendo-de-un-fichero
- Crear recurso compartido https://www.jesusninoc.com/02/21/crear-un-recurso-compartido/

-----------------

# Solución a la situación crítica 3
- Solución de Pablo https://github.com/PabloQueipo/ISO/blob/master/19%20MARZO

-------------
-------------

# Situación crítica 4 (resolver la siguiente situación con scripts)

## Crear una estructa en el dominio del Directorio Activo con los departamentos de un hospital, junto con usuarios que se leen de un fichero (crear unidades organizativas y meter dentro usuarios).

### Utilizar los siguientes scripts como ayuda:
- https://github.com/jesusninoc/ClasesISO/blob/master/2019-04-03.md#crear-mediante-scripts-una-estructura-de-dominio-parecida-a-la-que-tenemos-en-el-centro-soluci%C3%B3n-alejandro-aracil
- https://github.com/jesusninoc/ClasesISO/blob/master/2019-04-03.md#otra-soluci%C3%B3n-con-ejemplos-de-creaci%C3%B3n-de-pol%C3%ADticas-de-grupo-ignacio-barranquero

-----------------

# Solución a la situación crítica 4 (solución de Pablo)
* https://github.com/PabloQueipo/ISO/blob/master/24%20MARZO%202020.md

--------------
--------------

# Administración de dominios:
- Estructura grupo de trabajo.
- Estructura cliente-servidor.
- Protocolo LDAP.
- Estructura lógica del directorio activo (DA):
  - Concepto de dominio. Subdominios.
  - Unidades organizativas. Objetos.
  - Árboles y bosques.
  - Catálogo global. Esquema.
  - Funciones de los maestros de operaciones.
- Estructura física del DA:
  - Concepto de sitio (Site). Optimización del tráfico de red.
- Configurar la replicación entre Sites.
- Requisitos necesarios para montar un dominio.
- Administración de cuentas. Cuentas predeterminadas.
- Contraseñas. Bloqueos de cuenta.
- Cuentas de usuarios y equipos.
- Perfiles móviles y obligatorios.
- Carpetas personales.
- Plantillas de usuario. Variables de entorno.
- Restringir el inicio de sesión de una cuenta:
  - A ciertas horas y días.
  - En determinados ordenadores.
- Scripts de inicio de sesión.
- Administración de grupos. Tipos. Estrategias de anidamiento. Grupos predeterminados.
- Unidades Organizativas (UO).
  - Estrategias de administración.
  
------------------------

## Ejercicios sobre el AD
* https://www.jesusninoc.com/02/22/ejercicios-de-powershell-crear-una-ou-unidad-organizativa-en-un-directorio-activo/
* https://www.jesusninoc.com/02/22/ejercicios-de-powershell-crea-un-usuario-en-un-directorio-activo/

---------------------

# Credenciales almacenados
* https://www.jesusninoc.com/05/22/sistema-que-permite-almacenar-en-un-fichero-los-credenciales-de-usuario-de-windows-haciendo-una-peticion-a-un-servidor-web-mediante-el-metodo-post-despues-obtener-el-password-en-texto-plano/

-------------------
-------------------

# Administración de dominios:
- Estructura grupo de trabajo.
- Estructura cliente-servidor.
- Protocolo LDAP.
- Estructura lógica del directorio activo (DA):
  - Concepto de dominio. Subdominios.
  - Unidades organizativas. Objetos.
  - Árboles y bosques.
  - Catálogo global. Esquema.
  - Funciones de los maestros de operaciones.
- Estructura física del DA:
  - Concepto de sitio (Site). Optimización del tráfico de red.
- Configurar la replicación entre Sites.
- Requisitos necesarios para montar un dominio.
- Administración de cuentas. Cuentas predeterminadas.
- Contraseñas. Bloqueos de cuenta.
- Cuentas de usuarios y equipos.
- Perfiles móviles y obligatorios.
- Carpetas personales.
- Plantillas de usuario. Variables de entorno.
- Restringir el inicio de sesión de una cuenta:
  - A ciertas horas y días.
  - En determinados ordenadores.
- Scripts de inicio de sesión.
- Administración de grupos. Tipos. Estrategias de anidamiento. Grupos predeterminados.
- Unidades Organizativas (UO).
  - Estrategias de administración.

------------------------

# Teoría
- Servicios de directorio
  - Centralizar
  - Base de datos https://www.jesusninoc.com/12/27/conectar-powershell-con-mysql/
  - X.500
  - DAP
  - LDAP
  - OpenLDAP
  - AD
  - Dominio (árbol, bosque). Controlador de dominio. Miembro del servidor. Nivel funcional. Objetos (OU, grupos, usuarios, equipos)
    - Árbol: red.local y despachos.red.local
    - Bosque: red.local y alumnos.local
    - Controlador de dominio adicional: para tener más de un Controlador de Dominio, simplemente debemos ejecutar el mismo proceso anterior, sólo que en este caso durante el asistente le diremos que es Controlador de Dominio adicional, en un Dominio ya existente. En este caso toda la información de Active Directory que está en el primero se replicará en el segundo Controlador de Dominio.
    - Diferenciar entre Dominio y Controlador de Dominio: debemos tener en claro la diferencia entre “Dominio”, y “Controlador de Dominio”. Un “Dominio” es un concepto lógico, no es físico como el “Controlador de Dominio”.
    - Los registros DNS de servicio de Active Directory https://www.elladodelmal.com/2011/05/los-registros-dns-de-servicio-de-active.html
    - Funciones del Catálogo Global (Global Catalog): esta función es necesaria para que los usuarios normales puedan iniciar sesión. Aunque recordemos que por omisión el cliente si puede utiliza “cached credentials” que permiten el acceso local, esto no funcionará cuando el usuario quiera acceder a un recurso de red ya que en ese caso el Controlador de Dominio que lo autentica debe poder consultar a un Catálogo Global.
    - Replicación https://windowserver.wordpress.com/2014/12/02/windows-server-2012-r2-crear-un-dominio-instalacin-y-configuracin-del-segundo-controlador-de-dominio/
  - DNS.

------------------

# Un poco de DNS

------------------

# Ataques DNS

## DNS Spoofing

https://tools.ietf.org/html/rfc5452

When certain steps are taken, it is feasible to "spoof" the current
   deployed majority of resolvers with carefully crafted and timed DNS
   packets.  Once spoofed, a caching server will repeat the data it
   wrongfully accepted, and make its clients contact the wrong, and
   possibly malicious, servers.

   To understand how this process works it is important to know what
   makes a resolver accept a response.

   The following sentence in Section 5.3.3 of [RFC1034] presaged the
   present problem:

     The resolver should be highly paranoid in its parsing of responses.
     It should also check that the response matches the query it sent
     using the ID field in the response.

   DNS data is to be accepted by a resolver if and only if:

   1.  The question section of the reply packet is equivalent to that of
       a question packet currently waiting for a response.

   2.  The ID field of the reply packet matches that of the question
       packet.

   3.  The response comes from the same network address to which the
       question was sent.

   4.  The response comes in on the same network address, including port
       number, from which the question was sent.

   In general, the first response matching these four conditions is
   accepted.
   
   If a third party succeeds in meeting the four conditions before the
   response from the authentic nameserver does so, it is in a position
   to feed a resolver fabricated data.  When it does so, we dub it an
   "attacker", attempting to spoof in fake data.

   All conditions mentioned above can theoretically be met by a third
   party, with the difficulty being a function of the resolver

## Informe sobre ataque en DNS

Enom Central Customers:

I want to inform you that Enom recently became the subject of what appears to be a very sophisticated attack by a group that targets large internet infrastructure companies. Within hours of this attack, we were in contact with federal law enforcement and the affected parties. This attack hijacked the DNS traffic of 4 domains for a very short period of time before we mitigated the situation.

You have not been impacted by this incident and you are not required to take any action to ensure your future security. However, in an effort to continue to strive for transparency and best in class services, I wanted to inform you of this unfortunate situation.

To be clear, no domain names were stolen, and after exhaustive analysis, with the exception of the DNS of the domains specifically targeted, we do not have any evidence or reason to believe that these malicious actors accessed any customer accounts, customer personal information, or any of Enom’s secured and encrypted data. Your security is a leading priority at Enom and we continue to work both with federal law enforcement and industry leading security forensic companies to protect your online presence.

I know you trust Enom Central with your domain names and services and we take this responsibility very seriously. We appreciate your business and you have our commitment to continue to do what it takes to protect your assets.

------------------

# Ataques DoS

## Peticiones a recursos
* https://www.jesusninoc.com/03/01/ejercicios-de-seguridad-realizar-peticiones-de-carga-de-forma-indefinida-a-un-sitio-web/

## TCP SYN Flooding Attacks and Common Mitigations
https://tools.ietf.org/html/rfc4987

## XERXES – Most Powerful Tool For DoS Attack using Kali Linux
* https://gbhackers.com/xerxes-kali-linux-tutorial/
* https://github.com/zanyarjamal/xerxes

## Un poco DDoS y herramientas para detener los ataques
https://www.elevenpaths.com/es/noticias-y-eventos/elevenpaths-talks/un-poco-ddos-y-herramientas-para-detener-los-ataques/index.html

## LOIC
### Low Orbit Ion Cannon
An open source network stress tool, written in C#. Based on Praetox's LOIC project. USE ON YOUR OWN RISK. WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

https://github.com/NewEraCracker/LOIC

### Java LOIC. Low Orbit Ion Cannon. 
A Java based network stress testing application

https://www.kitploit.com/2015/05/java-loic-low-orbit-ion-cannon-java.html

## Fail2ban
Fail2ban scans log files (e.g. /var/log/apache/error_log) and bans IPs that show the malicious signs -- too many password failures, seeking for exploits, etc. Generally Fail2Ban is then used to update firewall rules to reject the IP addresses for a specified amount of time, although any arbitrary other action (e.g. sending an email) could also be configured. Out of the box Fail2Ban comes with filters for various services (apache, courier, ssh, etc).

https://www.fail2ban.org/wiki/index.php/Main_Page

## How To Protect SSH and Apache Using Fail2Ban on Ubuntu Linux
https://blog.rapid7.com/2017/02/13/how-to-protect-ssh-and-apache-using-fail2ban-on-ubuntu-linux/

---------
---------

# Administración de dominios:
- Estructura grupo de trabajo.
- Estructura cliente-servidor.
- Protocolo LDAP.
- Estructura lógica del directorio activo (DA):
  - Concepto de dominio. Subdominios.
  - Unidades organizativas. Objetos.
  - Árboles y bosques.
  - Catálogo global. Esquema.
  - Funciones de los maestros de operaciones.
- Estructura física del DA:
  - Concepto de sitio (Site). Optimización del tráfico de red.
- Configurar la replicación entre Sites.
- Requisitos necesarios para montar un dominio.
- Administración de cuentas. Cuentas predeterminadas.
- Contraseñas. Bloqueos de cuenta.
- Cuentas de usuarios y equipos.
- Perfiles móviles y obligatorios.
- Carpetas personales.
- Plantillas de usuario. Variables de entorno.
- Restringir el inicio de sesión de una cuenta:
  - A ciertas horas y días.
  - En determinados ordenadores.
- Scripts de inicio de sesión.
- Administración de grupos. Tipos. Estrategias de anidamiento. Grupos predeterminados.
- Unidades Organizativas (UO).
  - Estrategias de administración.

------------------------

# Teoría
- Servicios de directorio
  - Contraseñas. Bloqueos de cuenta https://www.jesusninoc.com/contrasenas-seguras-con-powershell/
  - Cuentas de usuarios y equipos https://www.jesusninoc.com/03/05/create-users-add-into-a-group-and-share-directory-with-permissions-in-active-directory/
  - Perfiles móviles y obligatorios.
  - Carpetas personales.
  - Plantillas de usuario. Variables de entorno.
  - Restringir el inicio de sesión de una cuenta.
  - Scripts de inicio de sesión.

------------------

# Ejercicio
## Hay un problema de seguridad en el hospital, un ransomware ha sido capaz de crear usuarios (no administradores) que pueden crear otros usuarios mediante un script que se ha ejecutado (haciendo clicks) en la cuenta del administrador. Explica mediante capturas y scripts cómo se ha realizado (no te agobies, haz lo que sepas).

### Pasos (por ejemplo):
- Crear usuarios leyendo de un fichero
- Script gráfico que hace clicks en determinadas zonas de la configuración de Windows Server
- Dejar el script programado mediante una GPO

### Ayuda
#### Crear OU, usuarios, buscar
* https://www.jesusninoc.com/02/22/ejercicios-de-powershell-crea-un-usuario-en-un-directorio-activo/
* https://www.jesusninoc.com/02/22/ejercicios-de-powershell-crear-una-ou-unidad-organizativa-en-un-directorio-activo/
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
* https://www.jesusninoc.com/07/05/utilizar-un-filtro-ldap-para-verificar-la-hora-del-ultimo-inicio-de-sesion-de-los-usuarios-del-active-directory/

#### Más ayuda
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-24.md#crear-usuarios-leyendo-desde-un-fichero-explicar-fichero-y-bucle-foreach
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-25.md#utilizar-un-filtro-ldap-para-localizar-un-usuario
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-25.md#utilizar-un-filtro-ldap-para-verificar-la-hora-del-%C3%BAltimo-inicio-de-sesi%C3%B3n-de-los-usuarios-del-active-directory
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-27.md#crear-usuarios-grupos-ous-y-todo-lo-que-quieras-leyendo-de-una-p%C3%A1gina-web
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-01.md#instalaci%C3%B3n-configuraci%C3%B3n-objetos-relaciones-de-confianza-gpos-rodc-dc-secundario
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-02.md#funci%C3%B3n-comprobar-con-filtro-ldap-soluci%C3%B3n-de-enrique-carreras

-------------
-------------

# Tareas liberatorias
- Poner en bonito el siguiente conjunto de scripts de la solución a la tarea 1: https://github.com/jesusninoc/ClasesISO/blob/master/2021-02-22.md#soluci%C3%B3n-a-la-situaci%C3%B3n-cr%C3%ADtica-1
- Crear un segundo controlador de dominio: https://windowserver.wordpress.com/2014/12/02/windows-server-2012-r2-crear-un-dominio-instalacin-y-configuracin-del-segundo-controlador-de-dominio/

---------------
---------------

# Caso para resolver
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-02-22.md#situaci%C3%B3n-cr%C3%ADtica-1-resolver-la-siguiente-situaci%C3%B3n-con-scripts

--------------
--------------

# Administración de dominios:
- Estructura grupo de trabajo.
- Estructura cliente-servidor.
- Protocolo LDAP.
- Estructura lógica del directorio activo (DA):
  - Concepto de dominio. Subdominios.
  - Unidades organizativas. Objetos.
  - Árboles y bosques.
  - Catálogo global. Esquema.
  - Funciones de los maestros de operaciones.
- Estructura física del DA:
  - Concepto de sitio (Site). Optimización del tráfico de red.
- Configurar la replicación entre Sites.
- Requisitos necesarios para montar un dominio.
- Administración de cuentas. Cuentas predeterminadas.
- Contraseñas. Bloqueos de cuenta.
- Cuentas de usuarios y equipos.
- Perfiles móviles y obligatorios.
- Carpetas personales.
- Plantillas de usuario. Variables de entorno.
- Restringir el inicio de sesión de una cuenta:
  - A ciertas horas y días.
  - En determinados ordenadores.
- Scripts de inicio de sesión.
- Administración de grupos. Tipos. Estrategias de anidamiento. Grupos predeterminados.
- Unidades Organizativas (UO).
  - Estrategias de administración.

------------------------

# Teoría
- Servicios de directorio
  - Perfiles móviles y obligatorios https://docs.microsoft.com/es-es/windows/client-management/mandatory-user-profile
  - Unidades Organizativas (UO).
    - Estrategias de administración.
  
------------------

# Administración del acceso al dominio:
- Equipos del dominio.
- Permisos y derechos.
- Delegación de permisos / autoridad.
  - Asistente para la delegación de control.
  - Herramientas de línea de comandos: dsacls.exe y dsrevoke.exe.	🤦
- Listas de control de acceso.

# Joining Computers

## Tener en cuenta
 - IP fija
 - ping
 - DNS
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

## Joining Computers to a Domain (PowerShell)
http://community.idera.com/powershell/powertips/b/tips/posts/joining-computers-to-a-domain

## Joining Computers to a Domain (GUI)
 
# Ejercicios

## Ejercicios sin scripts
- INSTALAR UN EQUIPO Y METERLO EN EL DOMINIO

## Ejercicios con scripts
- Acceso remoto desde Powershell https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-01-16.md

------------
------------

# Administración del acceso al dominio:
- Equipos del dominio.
- Permisos y derechos.
- Delegación de permisos / autoridad.
  - Asistente para la delegación de control.
  - Herramientas de línea de comandos: dsacls.exe y dsrevoke.exe.	🤦
- Listas de control de acceso.

# Joining Computers

## Tener en cuenta
 - IP fija
 - ping
 - DNS
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

## Joining Computers to a Domain (PowerShell)
http://community.idera.com/powershell/powertips/b/tips/posts/joining-computers-to-a-domain

## Joining Computers to a Domain (GUI)
 
# Ejercicios

## Ejercicios sin scripts
- INSTALAR UN EQUIPO Y METERLO EN EL DOMINIO

## Ejercicios con scripts
- Acceso remoto desde Powershell https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-01-16.md

-----------
-----------

# Repaso de casos
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-02-22.md#situaci%C3%B3n-cr%C3%ADtica-3-resolver-la-siguiente-situaci%C3%B3n-con-scripts
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-02-22.md#situaci%C3%B3n-cr%C3%ADtica-4-resolver-la-siguiente-situaci%C3%B3n-con-scripts

------------------------------------
------------------------------------

# Administración del acceso al dominio:
- Equipos del dominio.
- Permisos y derechos.
- Delegación de permisos / autoridad.
  - Asistente para la delegación de control.
  - Herramientas de línea de comandos: dsacls.exe y dsrevoke.exe.	🤦
- Listas de control de acceso.

## Tener en cuenta
 - IP fija
 - ping
 - DNS
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

# Listas de control de acceso
## Permisos desde PowerShell
* https://www.jesusninoc.com/01/23/clonar-permisos-ntfs/
* https://www.jesusninoc.com/08/19/anadir-permiso-ntfs-a-una-carpeta/
* https://www.jesusninoc.com/03/30/eliminar-permisos-explicitos/

# Ejercicios
## Ejercicios con scripts
- Crear un usuario en el AD, delegar la tarea de "Unir un equipo al dominio" a ese usuario y ejecutar el script para que el equipo se meta en el dominio (desde el equipo que queremos meter en el dominio)
  - Local
  - Remoto
    * http://community.idera.com/powershell/powertips/b/tips/posts/joining-computers-to-a-domain

# Práctica compleja
## Añadir un controlador de dominio adicional
  - Controlador de dominio adicional: Para tener más de un Controlador de Dominio, simplemente debemos ejecutar el mismo proceso anterior, sólo que en este caso durante el asistente le diremos que es Controlador de Dominio adicional, en un Dominio ya existente. En este caso toda la información de Active Directory que está en el primero se replicará en el segundo Controlador de Dominio
  - Replicación https://windowserver.wordpress.com/2014/12/02/windows-server-2012-r2-crear-un-dominio-instalacin-y-configuracin-del-segundo-controlador-de-dominio/
