# Examen liberatorio

## Pregunta 1. Crear usuarios leyendo de un fichero el nombre de los usuarios que se van a crear y los credenciales que se van a utilizar
* https://www.jesusninoc.com/03/13/ejercicios-de-powershell-restaurar-usuarios-que-se-han-creado-anteriormente-se-almacenan-en-un-fichero-y-se-vuelven-a-crear/
* https://www.jesusninoc.com/04/08/almacenar-y-utilizar-credenciales-mediante-json/
* https://www.jesusninoc.com/12/08/utilizar-credenciales-en-formato-json-que-han-sido-exportados-con-get-credential-y-arrancar-el-programa-notepad-en-powershell/
* https://www.jesusninoc.com/12/07/exportar-credenciales-con-get-credential-en-un-fichero-json-con-powershell/
* https://www.jesusninoc.com/03/01/ejercicios-de-powershell-almacenar-varios-credenciales-en-un-fichero-xml-y-utilizarlos-para-arrancar-un-proceso/
* https://www.jesusninoc.com/06/24/verificar-si-existe-un-usuario-en-windows-10-con-powershell/
* https://www.jesusninoc.com/02/27/validar-usuarios-en-el-directorio-activo-pidiendo-al-usuario-el-nombre-y-la-contrasena/

## Pregunta 2. Realizar una copia de seguridad comprimida en una carpeta compartida con las dll que utilza un proceso
* https://www.jesusninoc.com/03/05/create-a-share-on-linux-and-access-it-from-windows/
* https://www.jesusninoc.com/04/30/ejercicios-de-powershell-crear-una-carpeta-compartida-mapearla-y-utilizarla/
* https://www.jesusninoc.com/06/14/conectarse-a-una-carpeta-compartida-con-powershell/
* https://www.jesusninoc.com/05/27/ejercicios-de-powershell-analizar-ficheros-dll-en-todos-los-equipos-de-la-red-comprobar-que-ha-cambiado-una-integridad-y-copiar-el-fichero-que-ha-cambiado/

--------------
--------------

# Corrección del examen liberatorio
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-03-11.md#pregunta-1-crear-usuarios-leyendo-de-un-fichero-el-nombre-de-los-usuarios-que-se-van-a-crear-y-los-credenciales-que-se-van-a-utilizar

# Ejercicios sobre corrección del examen liberatorio
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-una-funcion-que-almacene-los-usuarios-que-estan-en-el-equipo-y-los-guarde-en-formato-qr/
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-un-qr-con-los-nombres-de-los-usuarios-que-hay-en-el-sistema-y-crear-los-usuarios-nuevamente-leyendo-el-codigo-qr-generado-anteriormente/
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-crear-usuarios-en-linux-leyendo-desde-un-codigo-qr-en-powershell-el-nombre-de-los-usuarios-se-obtiene-listando-usuarios-en-el-sistema-desde-powershell-y-convirtiendo-a-codig/

------------
------------

# Linux

## Repaso de usuarios
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#listar-informaci%C3%B3n-sobre-usuarios-y-grupos-en-bash-con-repaso-sobre-comandos
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-04.md#crear-usuarios-en-ubuntu-mediante-wsl
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-09.md#crear-usuarios-en-ubuntu

## Repaso scripting Linux
* https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjerciciosFicherosBuscar.sh
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-05-24-Enunciado.sh
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-22.md#repaso-para-realizar-scripts-en-linux
* https://blog.carreralinux.com.ar/2016/07/unir-y-ordenar-lineas-en-archivos-de-texto/
* https://likegeeks.com/es/comando-awk/

## Repaso enlaces duros y simbólicos
* https://geekland.eu/que-son-para-que-sirven-enlaces-duros-y-simbolicos/

## Más repaso scripts
* https://github.com/jesusninoc/Scripts

------------
------------

# Corrección del examen liberatorio
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-03-11.md#pregunta-2-realizar-una-copia-de-seguridad-comprimida-en-una-carpeta-compartida-con-las-dll-que-utilza-un-proceso

# Ejercicios sobre corrección del examen liberatorio
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-realizar-una-copia-de-seguridad-de-las-dll-que-utiliza-un-proceso-y-comprimir-la-copia-dentro-de-una-carpeta-compartida/

------------
------------

# Linux (vamos por la parte de valores $* en la presentación)

## Ejercios resueltos
* https://www.jesusninoc.com/03/18/ejercicios-wsl-crear-en-windows-con-powershell-y-wsl-los-mismos-usuarios-que-tenemos-en-linux/
* https://www.jesusninoc.com/03/18/ejercicios-de-wsl-realizar-una-suma-en-wsl-llamando-a-un-script-de-bash-donde-le-pasamos-dos-valores/
* https://www.jesusninoc.com/03/18/ejercicios-de-wsl-realizar-una-suma-en-wsl-llamando-a-un-script-donde-le-pasamos-dos-valores-desde-powershell/
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-crear-un-interfaz-simple-que-realice-la-operacion-de-suma-resta-y-multiplicacion/
* https://www.jesusninoc.com/03/18/ejercicios-de-powershell-crear-un-interfaz-simple-que-realice-la-operacion-de-suma-resta-y-multiplicacion-mediante-la-llamada-a-un-script-en-bash-utilizando-wsl/

## Más repaso scripts
* https://github.com/jesusninoc/Scripts

-----------
-----------

# Examen segunda evaluación

1. Leer un usuario desde un servidor web (HTML, XML, JSON) crearlo y meterlo en el grupo de administradores (no te olvides del password).
2. Detectar mediante una función que el usuario pertenece al grupo de administradores.
```PowerShell
Get-LocalGroupMember administradores
```
El siguiente enlace es una solución de monitorización algo compleja: registrar y mostrar un evento en PowerShell cuando se crea un usuario
https://www.jesusninoc.com/2018/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

3. Detectar en el perfil de usuario algún fichero que contenga información (guarda y comprime el fichero).
```PowerShell
Get-ChildItem C:\Users\juan\NTUSER.DAT
```
4. Intentar utilizar las credenciales de un usuario y verificar que funciona (guarda en un fichero la captura).
* https://www.jesusninoc.com/2016/08/16/almacenar-credenciales/
* https://www.jesusninoc.com/2016/09/20/almacenar-y-utilizar-credenciales/
* https://www.jesusninoc.com/2017/04/08/almacenar-y-utilizar-credenciales-mediante-json/
5. Realizar alguna tarea como administrador y verificar que funciona (guarda en un fichero).
* https://www.jesusninoc.com/2016/08/17/utilizar-credenciales-almacenados/
6. Dejar una puerta trasera para poder conectarse desde SSH en Linux.
* https://itefix.net/copssh

--------------------------

# Simulacro de examen segunda evaluación

# Parte 1
## Crear un usuario utilizando el protocolo UDP
### Server
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Close()
```
### Client
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('New-LocalUser usuario2 -Password (ConvertTo-SecureString "11234aaa@@€dsf" -asplaintext -force)')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

## Ayuda
### Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
* https://www.jesusninoc.com/11/23/crear-un-usuario-local-con-contrasena-en-windows-10-con-powershell-5-1/
### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
* https://www.jesusninoc.com/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
### Lanzar una excepción en la función si algo va mal
```PowerShell
function Copy-Log
{
  "Doing prerequisites"
  "Testing whether target path exists"
  "If target path does not exist, bail out"
  throw "Target path does not exist"
  "Copy log files to target path"
  "Delete log files in original location"
}
```
# Parte 2
## Detectar que se ha creado un usuario sin darnos cuenta
- Por red
- Por IP
```PowerShell
Get-NetUDPEndpoint | %{
    if(($_ -match "192.168.104.39") -or ($_ -match "10.0.2.13") -or ($_ -match "127.0.0.1"))
    {
    }
    else
    {
        $_
    }
}
```
- Registro de la acción de crear usuarios
```PowerShell
#Ejecutar PowerShell como administrador
Register-WmiEvent -Query "select * from __InstanceCreationEvent where TargetInstance isa 'Win32_NtLogEvent' and TargetInstance.logfile = 'Security' and (TargetInstance.EventCode = '4720')" -Action {Write-Host $event.SourceEventArgs.NewEvent.TargetInstance.insertionstrings}
```
- Listar la fecha de creación de usuarios
```PowerShell
$checktime = (get-date).adddays(-1000)
get-aduser -searchbase "CN=Users ,DC=retared,DC=local" -Properties whencreated -filter {whencreated -ge $checktime}
```
- Contar número de usuarios
```PowerShell
(Get-LocalUser).count
```

--------------------------

# Repaso

## Registrar y mostrar un evento en PowerShell cuando se ejecuta un programa
https://www.jesusninoc.com/2018/02/14/registrar-y-mostrar-un-evento-en-powershell-cuando-se-ejecuta-un-programa/

## Registrar y mostrar un evento en PowerShell cuando se crea un usuario
https://www.jesusninoc.com/2018/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

# Registry

A central hierarchical database used in Microsoft Windows, used to store information that is necessary to configure the system for one or more users, applications and hardware devices.

https://www.jesusninoc.com/registry/

## Ejemplos en PowerShell de gestión del registro de Windows

### Ver información en el Registro de Windows sobre las Variables de entorno
https://www.jesusninoc.com/2015/03/23/ver-informacion-en-el-registro-de-windows-sobre-las-variables-de-entorno/
### Ver información en el Registro de Windows sobre el estado de los servicios
https://www.jesusninoc.com/2015/03/22/ver-informacion-en-el-registro-de-windows-sobre-el-estado-de-los-servicios/

## Ejercicios en PowerShell de gestión del registro de Windows
https://github.com/jesusninoc/PowerShell/tree/master/Registro

## Herramienta para analizar el registro (Process Monitor v3.40)
Process Monitor is an advanced monitoring tool for Windows that shows real-time file system, Registry and process/thread activity. It combines the features of two legacy Sysinternals utilities, Filemon and Regmon, and adds an extensive list of enhancements including rich and non-destructive filtering, comprehensive event properties such session IDs and user names, reliable process information, full thread stacks with integrated symbol support for each operation, simultaneous logging to a file, and much more. Its uniquely powerful features will make Process Monitor a core utility in your system troubleshooting and malware hunting toolkit.
https://www.jesusninoc.com/2018/02/11/process-monitor-v3-40/

# Expresiones regulares
https://ss64.com/ps/syntax-regex.html

## Regular Expressions Unfettered
https://developer.apple.com/library/content/documentation/OpenSource/Conceptual/ShellScripting/RegularExpressionsUnfettered/RegularExpressionsUnfettered.html

## Ejemplos de utilización de expresiones regulars
https://www.regular-expressions.info/examples.html

## Searching IP addresses in text files
https://www.jesusninoc.com/2014/11/24/searching-ip-addresses-in-text-files/

## Searching URLs in text files
https://www.jesusninoc.com/2014/11/19/searching-urls-text-files/

## Searching the Registry: IP addresses
https://www.jesusninoc.com/2014/11/12/searching-registry-ip-addresses/

## Searching the Registry: URLs
https://www.jesusninoc.com/2014/11/14/searching-registry-urls/

## Online regex tester
https://regex101.com/

------------------

# Converting PowerShell to Batch
http://community.idera.com/powershell/powertips/b/tips/posts/converting-powershell-to-batch

# Formas de descargar y ejecutar ficheros desde un servidor en PowerShell
https://www.jesusninoc.com/2016/11/15/formas-de-descargar-y-ejecutar-ficheros-desde-un-servidor-en-powershell/

# Permitir conexiones remotas
https://www.jesusninoc.com/2016/05/08/permitir-conexiones-remotas/

# Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
https://www.jesusninoc.com/2016/11/23/crear-un-usuario-local-con-contrasena-en-windows-10-con-powershell-5-1/

# Conectarse por SSH al router de fibra óptica MitraStar de Movistar desde PowerShell
https://www.jesusninoc.com/2017/11/16/conectarse-por-ssh-al-router-de-fibra-optica-mitrastar-de-movistar-desde-powershell/

# Datos URIs
https://developer.mozilla.org/es/docs/Web/HTTP/Basics_of_HTTP/Datos_URIs

# Bash Bunny Phishing Attack With Hamsters - Hak5 2306
https://www.youtube.com/watch?v=TYR2a2XoK3A

# Realizar una redirección con JavaScript utilizando Start-Process y Google Chrome
https://www.jesusninoc.com/2017/02/06/realizar-una-redireccion-con-javascript-utilizando-start-process-y-google-chrome-2/

# Ejecutar un Batch que descarga un script desde una URL, el script ejecuta un payload de ejecución de comandos arbitrarios que permite realizar un volcado de memoria RAM

* Converting PowerShell to Batch
http://community.idera.com/powershell/powertips/b/tips/posts/converting-powershell-to-batch

* Formas de descargar y ejecutar ficheros desde un servidor en PowerShell
https://www.jesusninoc.com/2016/11/15/formas-de-descargar-y-ejecutar-ficheros-desde-un-servidor-en-powershell/

* Cargar en memoria y ejecutar un payload de ejecución de comandos arbitrarios en PowerShell
https://www.jesusninoc.com/2017/02/16/cargar-en-memoria-y-ejecutar-un-payload-de-ejecucion-de-comandos-arbitrarios-en-powershell/

* Crear un fichero de volcado de memoria de un proceso
https://www.jesusninoc.com/2016/03/04/crear-un-fichero-de-volcado-de-memoria-de-un-proceso/

## Más ideas

* Keylogger sencillo con PowerShell
https://www.jesusninoc.com/2017/03/11/keylogger-sencillo-con-powershell/

* Enviar datos a un formulario de Google Docs desde PowerShell
https://www.jesusninoc.com/2017/03/11/enviar-datos-a-un-formulario-de-google-docs-desde-powershell/

------------
------------

# Repaso examen 2ª evaluación

## Posibles preguntas

- Crear un sistema para realizar instalaciones de programas en Linux desde PowerShell
  - El sistema tiene que comprobar si hay que realizar instalaciones al arrancar el sistema operativo

- Crear un sistema que da de alta usuarios en el sistema operativo
  - El sistema tiene que ser una tarea programada

- Ejemplos de preguntas rápidas
  - ¿Cómo bloqueas un programa en Windows para que no pueda ejecutarlo un usuario?
  - ¿Qué contiene el fichero ntuser.dat?

- Script OWASP
  - WordPress username enumeration with PowerShell https://jesusninoc.com/wp-json/wp/v2/users/
  - WordPress https://www.jesusninoc.com/wordpress/

------------
------------

# Examen segunda evaluación

## Tener en cuenta
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-26.md

## Configurar al usuario todo lo que necesita leyendo de un fichero (programas, carpetas, etc.), realizar el siguiente proceso:
- Copiar la información y configuración que hay sobre un usuario
	- Programas
	- DLL
- Crear para cada nuevo usuario que entra en el sistema (teniendo en cuenta el punto anterior):
	- Usuario
	- Grupo
	- Carpeta compartida
	
## Teniendo en cuenta la pregunta anterior, realizar un script que permita enviar información desde los clientes (no depender del servidor)
  
### Ayuda
- Guardar información sobre usuarios para hacer una recuperación
- Guardar información sobre programas y paquetes
- Configuración IP, DNS
- Tener en cuenta funciones complejas
- Se puede mejorar el script con Linux
- Tener en cuenta el AD
- Filtro LDAP
- Comunicar por UDP
- Información sobre programas
	- C:\Program Files
	- C:\Users\administrador.RETARED\AppData\Local
	- C:\Windows\prefetch
- Carpetas compartidas para guardar información de una copia de seguridad
 	- https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-16.md
 	- https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-11.md
- UDP
	- https://www.jesusninoc.com/11/10/realizar-conexiones-tcp-udp-con-powershell/

-----------

# Examen segunda evaluación

## Realizar un programa que permita utilizar el siguiente fichero
```
juan|ventas,compras|office|\\servidor1\ventas\juan|Total
```

## Ideas
### Perfiles móviles
http://www.developandsys.es/perfiles-moviles-server/
### Mapeo de unidades red Windows Server
http://www.developandsys.es/mapeo-unidades-red-windows-server/

-----------

# Resolver la siguiente situación mediante scripts

## Los usuarios de una red funcionan con un sistema muy básico, tienen usuarios creados en cada equipo y comparten archivos mediante carpetas compartidas. Tu tarea es extraer los usuarios de los equipos y centralizar todo en un solo servidor con un Directorio Activo.

### Ayuda
- Crear una carpeta compartida, mapearla y utilizarla
```PowerShell
New-SmbShare -Name asir -Path c:/asir1 –FullAccess juan -ReadAccess todos
New-PSDrive -Name “asir” -PSProvider FileSystem -Root \\localhost\asir
cd asir:/ 
```

### Soluciones
* https://github.com/AlexRivero14/COVID-19
* https://github.com/PabloQueipo/ISO/blob/master/Pr%C3%A1ctica%2026%20MARZO.md
* https://github.com/DanielCebri/ISO-/blob/master/31032020.md
