# Examen de noviembre (repaso)

## Tener en cuenta:
- Utilizar ficheros para leer la información
- Almacenar información en ficheros de log
- Utilizar variables
- Foreach

## Preguntas:
### - Leer identificadores de procesos y comprobar que tienen un proceso
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-leer-identificadores-de-procesos-y-comprobar-que-tienen-un-proceso/

### - Detectar si hay un tipo de proceso y producto de software que se llame "Acrobat"
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-detectar-si-hay-un-tipo-de-proceso-y-producto-de-software-que-se-llame-acrobat/

### - Detectar que se está consumiendo tráfico de red por parte de un proceso
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-detectar-que-se-esta-consumiendo-trafico-de-red-por-parte-de-un-proceso/

### - Detectar que un proceso está utilizando el posicionamiento GPS
```PowerShell
Get-Process | select *
Get-Process -name chrome | Select-Object path
Get-WmiObject win32_process | select *
(Get-WmiObject win32_process | select CommandLine).CommandLine | Select-String "gp"
(Get-WmiObject win32_process | select CommandLine).CommandLine | Select-String "gps"
```

-------------
-------------

# Repaso de examen
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-11-05.md#examen-de-noviembre
## Solución complicada
* https://github.com/jesusninoc/ClasesSAD/blob/master/2020-11-06.md#caso-me-est%C3%A1n-espiando

-----------
-----------

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------------

# Sistema de archivos

## Introducción a sistema de archivos
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

# Sistema de archivos: discos
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Discos

## Comandos para trabajar con discos en Linux
* https://www.jesusninoc.com/10/28/comandos-para-trabajar-con-discos-en-linux-2/

---------------
---------------

# Examen de octubre corrección

1. Crear una carpeta cuyo nombre sea la fecha de hoy y meter dentro de la carpeta un fichero con información sobre el proceso Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-una-carpeta-cuyo-nombre-sea-la-fecha-de-hoy-y-meter-dentro-de-la-carpeta-un-fichero-con-informacion-sobre-el-proceso-notepad/

 - 1.1. Crear una carpeta cuyo nombre sea la fecha de hoy https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-una-carpeta-cuyo-nombre-sea-la-fecha-de-hoy/

 - 1.2. Crear un fichero con información sobre el proceso Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-un-fichero-con-informacion-sobre-el-proceso-notepad/

2. Mostrar los hilos que tiene Notepad y almacenar los números de identificador de hilo en un fichero https://www.jesusninoc.com/10/28/ejercicios-de-powershell-mostrar-los-hilos-que-tiene-notepad-y-almacenar-los-numeros-de-identificador-de-hilo-en-un-fichero/

 - 2.1. Mostrar los hilos que tiene Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-mostrar-los-hilos-que-tiene-notepad/

3. Abrir 5 veces Notepad y almacenar información sobre el proceso Notepad en un fichero https://www.jesusninoc.com/10/28/ejercicios-de-powershell-abrir-5-veces-notepad-y-almacenar-informacion-sobre-el-proceso-notepad-en-un-fichero/

 - 3.1. Abrir 5 veces Notepad https://www.jesusninoc.com/10/28/ejercicios-de-powershell-abrir-5-veces-notepad/

 - 3.2. Almacenar información sobre el proceso Notepad en un fichero https://www.jesusninoc.com/10/28/ejercicios-de-powershell-crear-un-fichero-con-informacion-sobre-el-proceso-notepad/

-----------
-----------

#  IF en PowerShell
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Sentencias_condicionales

# Ejemplos con IF

## Pedir al usuario un nombre de usuario y un password
* https://www.jesusninoc.com/11/23/ejercicios-de-powershell-pedir-al-usuario-un-nombre-de-usuario-y-un-password/

## Pedir al usuario un nombre de usuario y un password y comprobar si es "juan"
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-pedir-al-usuario-un-nombre-de-usuario-y-un-password-y-comprobar-si-es-juan/

## Pedir al usuario un nombre de usuario y un password y comprobar si es "juan". Introducir pass y ver si es correcto
* https://www.jesusninoc.com/10/28/ejercicios-de-powershell-pedir-al-usuario-un-nombre-de-usuario-y-un-password-y-comprobar-si-es-juan-introducir-pass-y-ver-si-es-correcto/

---------------

# Switch en PowerShell
* https://www.jesusninoc.com/2016/08/09/sentencia-condicional-switch/

# Ejemplos
## Ejemplos sobre operaciones con switch
```PowerShell
$a=Read-Host "Introduzca operación"
switch($a){
'+'{
echo Suma
break
}
}
```
## Pedir una operación y si es "suma" realizar una suma
```PowerShell
$a=Read-Host "Introduzca operación"
switch($a){
'+'{
suma
break
}
}

function suma()
{
2+3
}
```

-----------
-----------

# Ejercicios

## Crear dos ficheros TXT, convertirlos a PDF y juntarlos con Poppler
* https://www.jesusninoc.com/11/26/ejercicios-de-powershell-crear-dos-ficheros-txt-convertirlos-a-pdf-y-juntarlos-con-poppler-utilizando-wsl/

## Crear cinco directorios y dentro de cada directorio crear 10 ficheros
* https://www.jesusninoc.com/11/28/ejercicios-de-powershell-crear-cinco-directorios-y-dentro-de-cada-directorio-crear-10-ficheros/

## Crear una estructura de directorios
* https://www.jesusninoc.com/11/28/ejercicios-de-powershell-crear-una-estructura-de-directorios/

## Crear una estructura de directorios (pero solo los números pares)
* https://www.jesusninoc.com/11/28/ejercicios-de-powershell-crear-una-estructura-de-directorios-pero-solo-los-numeros-pares/

## Crear una estructura de directorios (pero solo los números impares)
* https://www.jesusninoc.com/11/30/ejercicios-de-powershell-crear-una-estructura-de-directorios-pero-solo-los-numeros-impares/

## Leer operaciones de un fichero y realizarlas

### Estructura del fichero asignaturas.txt (0 crear fichero, 1 crear directorio)
```
iso,0
aso,1
```

### Leer del fichero que tiene las asignaturas
```PowerShell
$fichero=get-content asignaturas.txt
$fichero | % {
$_
}
```

### Leer del fichero que tiene las asignaturas y obtener solo la operación que hay que realizar
```PowerShell
$fichero=get-content asignaturas.txt
$fichero | % {
$_.split(',')[1]
}
```

### Leer el fichero y detectar la operación a realizar utilizando el switch
```PowerShell
$fichero = Get-Content asignaturas.txt
$fichero | % {
    $operacion = $_.split(",")
    switch($operacion[1]){
        '0'{
            echo "crear fichero"
            New-Item -Name $operacion[0] -ItemType File -Force
            break
        }
        '1'{
            echo "crear directorio"
            mkdir $operacion[0] -Force
            break
        }
    }
}
```

-------------
-------------

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.

---------------

# Linux

## A First Script
* https://www.shellscript.sh/first.html

## Ejercicios con ficheros y directorios (Bash)

```Bash
#Crear o modificar un archivo
vi nombre
```
```Bash
#Crear un directorio
mkdir
```
```Bash
#Ver el contenido de un archivo
cat
```
```Bash
#Acceder al contenido de un directorio
cd
```
```Bash
#Listar el contenido de un directorio
ls
```
```Bash
#Ver la estructura de un directorio
tree
```
```Bash
#Eliminar un archivo
rm
```
```Bash
#Eliminar un directorio
rmdir
```
```Bash
#Copiar un archivo o un directorio
cp
```
```Bash
#Mover un archivo o un directorio
mv
```
```Bash
#Renombrar un archivo o un directorio
mv
```
```Bash
#Establecer permisos en un archivo o un directorio
chmod
```
```Bash
#Comprimir y descomprimir un archivo o un directorio
gzip
```
```Bash
#Imprimir un archivo
lpr
```

## Ejercicios propuestos con ficheros y directorios (Bash)

- Crear un directorio para cada usuario
- Crear un fichero para cada usuario
- Añadir contenido a cada fichero creado para cada usuario
- Eliminar un directorio
- Renombrar un directorio
- Mover archivos de una carpeta a otra

## Ejercicios resueltos con ficheros y directorios (Bash)

1. Crear fichero que tenga tu nombre
```Bash	
 	echo Alejandro > fichero.txt
	#-------------------------
	who | awk '{print $1}' > fichero.txt
```
2. Ver el contenido de un fichero cuyo nombre esta guardado en otro fichero
```Bash
	cat `cat fichero.txt`
	#--------------------
	fich1= cat fichero
	cat $fich1
```
3. Listar contenido de un directorio y almacenarlo en un fichero
```Bash	
	ls directorio > listaDeDirectorio.txt
	cat listadeDirectorio.txt
```
4. Eliminar un fichero leyendo el nombre de este desde otro fichero
```Bash
	echo fichero1.txt > fichero2.txt

	rm `cat ficher2.txt`
	#------------------------------
	fic=cat ficher2.txt
	rm $fic
```
5. Eliminar directorio leyendo el nombre desde este desde otro fichero.	
```Bash
	echo directorio > fichero.txt
	
	mkdir `cat fichero.txt`
	
	rm -r `cat fichero.txt`
	#------------------------------
	direc=cat fichero.txt
	
	mkdir $direc
	rm -r $direc
```
6. Comprimir un directorio
```Bash
	gzip fichero
```

---------------
---------------

# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

------------------

# Ejercicios resueltos con ficheros y directorios (PowerShell)

## Crear directorios con los meses del año
* https://www.jesusninoc.com/12/01/ejercicios-de-powershell-crear-directorios-con-los-meses-del-ano/

## Crear directorios con los años desde 2020 hasta 2030 (opción 1)
* https://www.jesusninoc.com/12/02/ejercicios-de-powershell-crear-directorios-con-los-anos-desde-2020-hasta-2030-opcion-1/

## Crear directorios con los años desde 2020 hasta 2030 (opción 2)
* https://www.jesusninoc.com/12/03/ejercicios-de-powershell-crear-directorios-con-los-anos-desde-2020-hasta-2030-opcion-2/

## Crear directorios con los años desde 2020 hasta 2030 (opción 3)
* https://www.jesusninoc.com/12/04/ejercicios-de-powershell-crear-directorios-con-los-anos-desde-2020-hasta-2030-opcion-3/

## En cada uno de los directorios anteriores, crea un subdirectorio con los meses del año
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio)
    cd $anio
    foreach($mes in 1..12)
    {
        mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes)
    }
    cd ..
}
```

## En cada mes, crear un directorio con cada día del mes
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio)
    cd $anio
    foreach($mes in 1..12)
    {
        mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes)
        cd $mes
        1..31 | %{mkdir $_}
        cd ..
    }
    cd ..
}
```

## Trabajar con fechas
```PowerShell
$mes = (get-date).Month
$ano = (get-date).year
$dia = (get-date).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (día anterior)
```PowerShell
$mes = (get-date).AddDays(-1).Month
$ano = (get-date).AddDays(-1).Year
$dia = (get-date).AddDays(-1).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (listar varios días)
```PowerShell
-1..-7
 
foreach($dias in (-1..-7))
{
    $dias
}
 
foreach($dias in (-1..-7))
{
    (Get-Date).AddDays($dias)
}
 
foreach($dias in (-1..-7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
}
```

## Hay un proceso que falla, revisad la información sobre servicios, procesos e hilos durante una semana (creando ficheros de registro varias veces al día)
 
### Parte 1
### -Crear la carpeta para cada día y para varios momentos del día

#### Solución rara (o no), calculando el número de horas
```PowerShell
foreach($dias in (1..168))
{
    $mes = (get-date).AddHours($dias).Month
    $ano = (get-date).AddHours($dias).Year
    $dia = (get-date).AddHours($dias).Day
    $horas = (get-date).AddHours($dias).Hour
    mkdir $ano$mes$dia$horas -WhatIf
}
```
#### Solución medio buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    foreach($horas in 0..23)
    {
        mkdir $ano$mes$dia$horas -WhatIf
    }
}
```
#### Solución bastante buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
   
    foreach($horas in 0..23)
    {
        $ruta = [String]$ano+[String]$mes+[String]$dia
        $ruta
        New-Item -Name $horas -Path $ruta -ItemType Directory -WhatIf
    }
}
```
#### Solución mucha locura
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta0 = $ano+"\"+$mes+"\"+$dia
    mkdir $ruta0 -WhatIf
   
    foreach($horas in 0..23)
    {
        New-Item -Name $horas -Path $ruta0 -ItemType Directory -WhatIf
    }
}
```

### Parte 2
#### -Listar procesos
#### -Listar hilos
#### -Listar servicios

#### Solución que se ejecuta durante una semana (168 horas)
```PowerShell
foreach($veces in 168)
{
    $fecha = (Get-Date).ToString("yyyy\\MM\\dd")
    mkdir $fecha -Force
 
    $hora = (Get-Date).Hour
    New-Item -Name $hora -Path $fecha -ItemType Directory -Force
 
    (Get-Process).Name > ([String]($fecha+"\"+$hora+"\procesos.txt"))
    (Get-Service).Name > ([String]($fecha+"\"+$hora+"\servicios.txt"))
    (Get-Process).Threads > ([String]($fecha+"\"+$hora+"\hilos.txt"))
 
    Start-Sleep -Seconds 3600
}
```

#### Solución de Daniel Cebrián
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta = $ano+"\"+$mes+"\"+$dia

    mkdir $ruta -Force

    foreach($horas in 0..23)
    {   
        New-Item -Name $horas -Path $ruta -ItemType Directory -Force
        [String]$procesos = (gps).name
        [String]$ruta1= ($ruta+"\"+$horas)
        New-Item -Name procesos.txt -Path $ruta1 -ItemType File -value $procesos -Force
    }
}
```
