| Nivel | Curso | Área | Secuencia |
|-----------|-----------|-----------|-----------|
| Medio| 1º ASIR | Informática | Primera evaluación |

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Ejercicios sobre hilos

## Almacenar información sobre los hilos
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar información sobre los hilos del proceso Notepad 
* https://www.jesusninoc.com/11/17/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-del-proceso-notepad/

## Mostrar información sobre los hilos de todos los procesos que se están ejecutando (qué proceso ejecuta el hilo)
* https://www.jesusninoc.com/11/19/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-de-todos-los-procesos-que-se-estan-ejecutando-que-proceso-ejecuta-el-hilo/

## Listar hilos de cada proceso
* https://www.jesusninoc.com/07/22/listar-los-hilos-de-un-proceso/

## Almacenar información sobre hilos de forma continuada
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar los hilos de cada proceso utilizando WMI y el cmdlet Get-Process
* https://www.jesusninoc.com/11/23/ejercicios-de-powershell-mostrar-los-hilos-de-cada-proceso-utilizando-wmi-y-el-cmdlet-get-process/

## Relación entre servicios y procesos
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

## Ayuda de servicios con procesos
```PowerShell
foreach($elementos in (Get-WmiObject -Class Win32_Service))
{
    $elementos
}
Get-WmiObject -Class Win32_Service | %{
Write-Host $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```

## Ayuda de procesos WMI con procesos
```PowerShell
Get-WmiObject Win32_Process | %{
    $_.Handles,$_.ProcessHandle,(Get-Process -Id $_.ProcessHandle).ProcessName
}
Get-WmiObject Win32_Process | %{
    (Get-Process -Id $_.ProcessId),$_.ProcessName,$_.Handle,$_.ProcessId
}
```

## Almacenar el número de procesos e hilos en un fichero junto con la fecha (el script se ejecuta cada cinco segundos)
* https://www.jesusninoc.com/11/26/ejercicios-de-powershell-almacenar-el-numero-de-procesos-e-hilos-en-un-fichero-junto-con-la-fecha-el-script-se-ejecuta-cada-cinco-segundos/

# Servicios y relación con procesos
## No funciona porque no puede convertir ProcessID
```PowerShell
Get-WmiObject -Class Win32_Service | Select-Object Name,ProcessID, (Get-Process -Id ProcessID).name
```
## Sí funciona
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

# Procesos y ruta de ejecución del proceso
* https://www.jesusninoc.com/11/29/ejercicios-de-powershell-procesos-y-ruta-de-ejecucion-del-proceso/

# Ejercicios de PowerShell: saber la ruta de los servicios que se están ejecutando
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-saber-la-ruta-de-los-servicios-que-se-estan-ejecutando/

# Ejercicios de PowerShell: de la lista de hilos que se están ejecutando indicar si alguno es un hilo de un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-hilos-que-se-estan-ejecutando-indicar-si-alguno-es-un-hilo-de-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de la lista de procesos que se están ejecutando indicar si alguno es un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-procesos-que-se-estan-ejecutando-indicar-si-alguno-es-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de los servicios que se están ejecutando indicar el nombre del proceso
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-los-servicios-que-se-estan-ejecutando-indicar-el-nombre-del-proceso/

# Ejercicios de PowerShell: mostrar el padre de un hilo
* https://www.jesusninoc.com/09/29/ejercicios-de-powershell-mostrar-el-padre-de-un-hilo/

-------------
-------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Repasar tema PowerShell
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/

# ¿Me están espiando?
* https://www.jesusninoc.com/me-estan-espiando/

--------------------

# Memoria

## Adjunto ejercicio visto en mi equipo sobre compartir memoria
- Utilizar zonas de memoria compartida en Linux mediante WSL desde PowerShell
https://www.jesusninoc.com/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/
- Uso de las funciones ftok(), shmget(), shmat() y shmctl() (ejemplo)
https://www.jesusninoc.com/11/22/uso-de-las-funciones-ftok-shmget-shmat-y-shmctl-ejemplo/
- Uso de las funciones ftok(), shmget(), shmat() y shmctl()
https://www.jesusninoc.com/2014/11/22/uso-de-las-funciones-ftok-shmget-shmat-y-shmctl/

### Listar los procesos leyendo de una zona de memoria (almacenar un valor que se utiliza para listar un número de procesos)
#### Código para crear la zona de memoria y almacenar el valor, por ejemplo introducir 5
* https://www.jesusninoc.com/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/

#### Código para leer la zona de memoria (se listan los procesos, si se ha introducido un 5, se listan 5 procesos)
* https://www.jesusninoc.com/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/

-----------------
-----------------

# Instalación de software libre y propietario

- Máquinas virtuales (M.V.)
  - Concepto de virtualización del hardware y características de los principales productos software libre y propietario, para el uso de máquinas virtuales.
  - Creación y personalización de M.V.
  - Ventajas e inconvenientes de la virtualización.

------------------
------------------

# Instalación de software libre y propietario

- Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
  - Particionado del disco duro.
  - En sistemas Windows determinar la partición donde instalaremos el S.O.
  - En sistemas Linux determinar las particiones para los distintos puntos de montaje.
  - Controladores (drivers) de almacenamiento necesarios.
- Instalación de sistemas operativos.
  - Requisitos hardware, versiones y licencias.
  - Soporte utilizado para la instalación: CD/DVD, Pendrive, LAN.
  - Datos necesarios para la instalación: usuarios, contraseñas, nombre del equipo, direcciones IP, número de licencia, etc.

----------------

# Obtener información sobre el pocesador en PowerShell

## Información sobre el procesador
* https://www.jesusninoc.com/12/22/ejercicios-de-powershell-obtener-informacion-sobre-el-procesador/

## Información sobre la arquitectura
* https://www.jesusninoc.com/12/01/ejercicios-de-powershell-obtener-informacion-sobre-la-arquitectura/

## Información sobre la organización
* https://www.jesusninoc.com/12/02/ejercicios-de-powershell-obtener-informacion-sobre-la-organizacion/

## Información sobre la realización
* https://www.jesusninoc.com/12/07/ejercicios-de-powershell-obtener-informacion-sobre-la-realizacion/

## Información sobre los procesadores
* https://www.jesusninoc.com/10/13/mostrar-informacion-sobre-los-procesadores/

## Número de cores
* https://www.jesusninoc.com/10/02/ejercicios-de-powershell-informacion-sobre-el-numero-de-cores/

## Carga del procesador
* https://www.jesusninoc.com/10/03/ejercicios-de-powershell-ver-la-carga-del-procesador/

## Ejercicios
### Información sobre el procesador
* https://www.jesusninoc.com/01/13/ver-informacion-del-procesador-en-windows-desde-powershell/

### Procesador es Intel o no?
* https://www.jesusninoc.com/10/16/ejercicios-de-powershell-saber-si-un-procesador-es-intel-o-no/

----------------

# Prueba detectar proceso infectado

-----------------
-----------------

# ¿Cómo detectar un proceso que tiene un comportamiento extraño? (Solución examen)
- Consumo de CPU
- Nombre de fabricante
- https://www.jesusninoc.com/07/07/7-gestion-de-procesos-en-powershell/

# Parte especial de la clase (conexión con Linux)

## SSH

### Instalar y ejecutar SSH para PowerShell
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-ssh/

### Conexión después de haber desconectado y quitado el módulo Posh-SSH (hay que volver a importarlo)
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-ssh/

### Ejemplo: obtener información sobre la versión de Linux
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-ssh/

### JuiceSSH - SSH Client
* https://play.google.com/store/apps/details?id=com.sonelli.juicessh

### JuiceSSH Performance Plugin
* https://play.google.com/store/apps/details?id=com.sonelli.juicessh.performancemonitor

--------------
--------------

--------------
--------------

# Parte especial de la clase (conexión con Linux)

## SSH

### Instalar y ejecutar SSH para PowerShell
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.11 -Credential (Get-Credential)
```

### Conexión después de haber desconectado y quitado el módulo Posh-SSH (hay que volver a importarlo)
```PowerShell
Set-ExecutionPolicy -ExecutionPolicy Unrestricted
Import-Module Posh-SSH
New-SSHSession -ComputerName 10.20.104.19 -Credential (Get-Credential)
Get-SSHSession
(Invoke-SSHCommand -Index 0 "uname -r").output
(Invoke-SSHCommand -Index 0 "lscpu").output | Out-File informacionunubntu.txt -Append
(Invoke-SSHCommand -Index 0 "lshw").output | Out-File informacionunubntu.txt -Append
(Invoke-SSHCommand -Index 0 "nproc").output | Out-File informacionunubntu.txt -Append
```

### Ejemplo: obtener información sobre la versión de Linux
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.14 -Credential (Get-Credential)
Get-SSHSession
Invoke-SSHCommand -Index 0 "uname"
```

### Ejemplo: obtener información sobre la CPU
```PowerShell
# Realizar la conexión SSH
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -Computer
# Obtener información sobre el procesador desde Linux mediante una conexión SSH
(Invoke-SSHCommand -Index 0 "bash -c lscpu | grep '32-bit'")
(Invoke-SSHCommand -Index 0 "bash -c lscpu | grep '32-bit' | cut -d':' -f2  | cut -d'-' -f1 ").output
# ¿Es intel?
(Invoke-SSHCommand -Index 0 "lscpu").output
if((Invoke-SSHCommand -Index 0 "lscpu").output -match "Intel"){"Intel"}else{"No es Intel"}
(Invoke-SSHCommand -Index 0 "lscpu").output | select-string "cache"
```

### JuiceSSH - SSH Client
https://play.google.com/store/apps/details?id=com.sonelli.juicessh

### JuiceSSH Performance Plugin
https://play.google.com/store/apps/details?id=com.sonelli.juicessh.performancemonitor

### Guardar un fichero html preguntando al usuario qué título quiere
```PowerShell
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html
start chrome .\web.html
```

### Configurar IP en Windows
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

### Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## WSL
### Obtener información sobre la versión de Linux con WSL
```PowerShell
wsl uname -r
wsl uname -a
wsl cat /proc/version
```

### Información sobre la arquitectura
```PowerShell
(Invoke-SSHCommand -Index 0 "bash -c ""lscpu | grep 'Architecture'""").output
```

### Almacenar en un fichero información sobre la CPU mediante WSL desde PowerShell
```PowerShell
bash -c lscpu | Select-String "Architecture:","Model name:" | Out-File bonito.txt
[String]$var = bash -c lscpu | Select-String "Model name:"
$var.split("@")[1] | Out-File bonito.txt -Append
notepad .\bonito.txt
```

### 3. Gestión del hardware en Linux (nivel intermedio)
https://www.jesusninoc.com/03/03/3-gestion-del-hardware-en-linux-nivel-intermedio/

---------------------
---------------------

# Instalación de software libre y propietario

- Gestión de varios sistemas operativos en un ordenador.
  - Requisitos previos. Administración del espacio del disco. Particionado y redimensionado.
  - Problemas con el registro maestro de arranque (MBR). Elegir un gestor de arranque compatible con todos los sistemas operativos a instalar.
  - Preparar las particiones de los S.O. para permitir su arranque.
  - Analizar el orden en la instalación de los sistemas operativos.
- Gestores de arranque.
  - Código de arranque maestro (Master Boot Code).
  - Formatos tabla de particiones. Master Boot Record (MBR) y Guid Partition Table (GPT).
  - Configuración de los gestores de arranque de los sistemas operativos libres y propietarios.
  - Reparación del gestor de arranque.
  - Sustitución del gestor de arranque estándar por otro más completo.

---------------------

# Arranque
- BIOS
- POST
- Arranque (dual, BCD, BCDEdit, etc.)
- Arranque de procesos

## Arranque en Linux
### Proceso de arranque en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Arranque en Windows
### Master Boot Record
https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-2000-server/cc976786(v=technet.10)
### Proteger el proceso de arranque de Windows 10
https://docs.microsoft.com/es-es/windows/security/hardware-protection/secure-the-windows-10-boot-process
### Procesos de credenciales de autenticación de Windows
https://docs.microsoft.com/es-es/windows-server/security/windows-authentication/credentials-processes-in-windows-authentication
