# Correción examen liberatorio

- El proceso que más consume tiene un cambio de integridad, crear una función que realiza dicha comprobación.
```PowerShell
(Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash | Out-File inte.txt

$resultado = (Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash
if((Get-Content .\inte.txt) -eq $resultado)
{
    "es igual"
}
else
{
    "no es igual"
}
```
- Crear un log de sistema cuando hay un cambio de integridad.
```PowerShell
(Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash | Out-File inte.txt

function comprobar ($integridadbuena)
{
    $resultado = (Get-FileHash (Get-Process | sort cpu | select -last 1).path).hash
    if($integridadbuena -eq $resultado)
    {
        "es igual"
    }
    else
    {
       Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" 
       -EventID 916 -EntryType Information -Message "Cambio integridad" 
       -Category 2 -RawData 10,20
    }
}

comprobar (Get-Content .\inte.txt)
```
- Un software que se va a instalar tiene un ejecutable cuya integridad es errónea.
```PowerShell
foreach($programa in ls "C:\Program Files (x86)\Cisco Packet Tracer 6.1.1sv\bin\*.exe")
{
    (Get-FileHash $programa).path+","+(Get-FileHash $programa).hash | Out-File resultahas.txt -Append
}
```
- Detectar que un equipo no se ha añadido a un Dominio.
```PowerShell
$equipo = ""

function comprobar ($equipo)
{
    $ComputerName = $env:COMPUTERNAME
    $computer = [ADSI]"WinNT://$($ComputerName),computer"
    foreach($equipito in $computer)
    {
        if($equipito.Path -match $equipo)
        {
            "es igual"
        }
    }
}

comprobar FP_LHR_19
```
- Mostrar un objeto con toda la información de todos los elementos que hay en un Directorio Activo.
```PowerShell
[PSCustomObject]@{
 usuarios = Get-LocalUser
 grupos = Get-LocalGroup
}
```
- Detectar cómo se ha propagado un virus en carpetas compartidas generando una entrada en un log del sistema.
- Comprobar que ha cambiado un permiso utlizando auditoría.
- Mostrar un mensaje si el tamaño de una carpeta compatida supera el 80%.
```PowerShell
$total = 100

if((Get-ChildItem C:\Users\adminfp\Desktop\fallo | Measure-Object Length -Sum).Sum -lt $total*0.8)
{
    "menor"
}
```
- Crear una entrada en un registro del visor de eventos si hay un intento de acceso a un puerto que está cerrado.
