# Modelo 2

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web periódico

### Eres el nuevo administrador de sistemas del diario el Universo. El diario funciona así: los periodistas crean sus ficheros HTML en sus carpetas en la red mediante un interfaz web (una Intranet). Cada periodista ve sus propios ficheros y no ve los de sus compañeros. Por ejemplo: Juan crea la página 1 del periódico y sube dicha página al servidor web.

## Resuelve lo siguiente:
1) Junta todas las páginas del periódico de todos los periodistas.
```PowerShell
mkdir usuario1; cd usuario1
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina1.html
cd ..
mkdir usuario2; cd usuario2
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina2.html
cd ..

ls *.html -recurse | %{
    $periodidcocomp = $periodidcocomp + (gc $_)
}

$periodidcocomp | out-file periodicocompleto.html
```
2) Haz copias de seguridad para diferentes momentos del día y al final del día haz copia de todo el periódico completo.
```PowerShell
(Get-Date).ToString("yyyyMMddhh")

$fecha = (Get-Date).ToString("yyyyMMddhh")
mkdir ($fecha) -force
cd $fecha

ls *.html -recurse | %{
    copy $_ $fecha
}
```
3) Incidencia. Alguien ha mandado imprimir el periódico entero. Tienes que pararlo porque no es el momento de imprimirlo.
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
#$perio = gc .\periodicocompleto.html
$b=[Text.Encoding]::ASCII.GetBytes("gc perio.html | out-printer")
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
##Server
while(1)
{
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
if([Text.Encoding]::ASCII.GetString($content) | select-string "print")
{
    "ha mandado imprimir"
}
}
```
4) Opcional. El periódico automático. Crear cada página HTML utilizando una base de datos
* https://www.jesusninoc.com/09/20/crear-un-fichero-html-con-el-contenido-de-la-tabla-posts-de-wordpress-con-powershell/

-----------------

# Modelo 3

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
- Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
```PowerShell
Get-EventLog -LogName security | select Message | select-string "\\localhost\ejemplo"
```
- Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
    - https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/
    - https://www.jesusninoc.com/03/12/select-files-between-two-dates-and-copy-them/
  - Dejar programada la acción.
    - https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
  - Comprimir y descomprimir
    - https://www.jesusninoc.com/03/15/create-new-compress-archive-file/
    - https://www.jesusninoc.com/02/14/descomprimir-archivos/
  - Cifrar el contenido, método sencillo o complicado.
    - https://www.jesusninoc.com/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación
  - Funciones simples y complejas
```PowerShell
##########################
# Funciones simples
##########################
function crearestructura()
{
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force

    $fecha = (Get-Date).ToString("yyyyMMdd")
    cd copia
    mkdir ($fecha) -force
}

crearestructura

function copiararchivos()
{
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha -force
    }
}

copiararchivos

function recuperar
{
  param($fichero)
  begin
  {
  }
  process
  {
    Expand-Archive -LiteralPath $fichero -DestinationPath desco\
  }
  end
  {
  }
}

recuperar .\comprimido.zip

##############################################################################

##########################
# Función compleja
##########################
function copiaseguridad
{
  param()
  begin
  {
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force
    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir copia\$fecha -force
  }
  process
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha\ -force
    }
  }
  end
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls copia\$fecha
    Compress-Archive -LiteralPath copia\$fecha –CompressionLevel Optimal -DestinationPath comprimido.zip -Force
  }
}
copiaseguridad
```
- Se ha producido una infección en un sistema operativo Windows,
  - ¿qué elementos comprobarías para detectar dicha infección?
      - https://www.jesusninoc.com/07/11/analisis-de-procesos-y-conexiones-de-red-con-powershell/
  - ¿cómo impides que se produzcan infecciones el sistema operativo?
  - ¿Windows dispone de herramientas centralizadas para evitarlo?

```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```
  
- Explica todo el proceso para realizar una clonación.
- Explica todo lo que sepas sobre permisos en Windows.
- ¿Cómo puedes hacer una sincronización en Linux?, ¿puedes hacerla entre equipos?, ¿cómo?
- ¿Un driver falla, qué haces para arrancar el sistema?
- ¿Un componente gráfico, qué haces para arrancar el sistema?
- Se puede lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
- Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
    - https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
- Explica para qué sirven las auditoría y qué relación tiene con los permisos.
- ¿Qué hace el siguiente script? (explica en detalle el código)
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

-----------------

# Modelo 4

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 5

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
### Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
### Explica qué herramientas conoces para monitorizar en Windows y en Linux.
### Qué hay que hacer para lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
### Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
### Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
  - Dejar programada la acción.
  - Cifrar el contenido, método sencillo o complicado.
  - Dejar la carpeta oculta, comando attrib.
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
### Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?
#### Preparar un script que haga una correcta monitorización del sistema, teniendo en cuenta:
##### - Un proceso que no se comporta como siempre es raro.
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
 ##### - Un proceso que abre muchos hilos es raro.
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
 ##### - Un proceso que abre muchas comunicaciones es raro.
 ##### - Un proceso que consume fuera de lo normal es raro.
 ##### - Un proceso que se activa a una hora extraña es raro.
  ```PowerShell
  Get-EventLog -LogName Security -InstanceId 4688
  Get-EventLog Application | Where-Object Message -Match "explore" 
  ```
 ##### - Caso práctico: “RATas inminentes” (I) https://www.securityartwork.es/2018/05/28/caso-practico-ratas-inminentes-i/?utm_source=dlvr.it&utm_medium=twitter
### Script para simular una infección y una posterior desinfección.
### Puedes explicarme algún sistema distribuido que relacione las cosas que hemos visto en clase.

-----------------

# Modelo 6


## Explicar y realizar un script para cada una de las siguientes situaciones:

1. Cómo puedes saber quién accede a una carpeta compartida en Linux.
2. Realiza un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
    - Windows o Linux.
    - Dejar programada la acción.
    - Cifrar el contenido, método sencillo o complicado.
    - Dejar la carpeta oculta, comando attrib.
    - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación.
3. Puedes explicar algún sistema distribuido que relacione las cosas que hemos visto en clase.
4. ¿Cómo puedes hacer una sincronización en Linux?, ¿cómo?
5. Se ha producido una infección en un sistema operativo Windows, ¿qué elementos comprobarías para detectar dicha infección?, ¿cómo impides que se produzcan infecciones el sistema operativo?, ¿Windows dispone de herramientas centralizadas para evitarlo?

## Ayuda
### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS)
https://www.jesusninoc.com/06/04/listar-procesos-de-powershell-con-node-powershell-nodejs/

### LISTAR PROCESOS DE POWERSHELL CON NODE-POWERSHELL (NODE.JS) Y MOSTRARLOS EN UNA WEB CON EXPRESS
https://www.jesusninoc.com/07/15/listar-procesos-de-powershell-con-node-powershell-node-js-y-mostrarlos-en-una-web-con-express/

### Ejemplo de NODE.JS (Crear una página web con información sobre cada equipo)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()
 
let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('$ComputerSystem=Get-WmiObject Win32_ComputerSystem;$BaseBoard=Get-WmiObject Win32_BaseBoard;$BIOS=Get-WmiObject Win32_BIOS;$Processor=Get-WmiObject Win32_Processor;[PSCustomObject]@{ Model = $ComputerSystem.Model; ManufacturerBoard = $BaseBoard.Manufacturer; BIOSVersion = $BIOS.SMbiosbiosversion; BIOSSerialNumber = $BIOS.serialnumber; ManufacturerProcessor=$Processor.Manufacturer; MaxClockSpeed=$Processor.MaxClockSpeed} | ConvertTo-Html')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});
 
app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```

### Ejemplo de NODE.JS (Crear una página web con información sobre procesos)
```JavaScript
const shell = require('node-powershell');
const express = require('express')
const app = express()

let ps = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps.addCommand('Get-Process | ConvertTo-Html -Property Name, Path, Company')
ps.invoke()
.then(output => {
  console.log(output);
  app.get('/procesos', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps.dispose();
});

let ps2 = new shell({
  executionPolicy: 'Bypass',
  noProfile: true
});
 
ps2.addCommand('Get-Service | ConvertTo-Html -Property Name, Path, Company')
ps2.invoke()
.then(output => {
  console.log(output);
  app.get('/servicios', function (req, res) {
    res.send(output);
  })  
})
.catch(err => {
  console.log(err);
  ps2.dispose();
});

app.listen(3000, function () {
  console.log('Example app listening on port 3000!')
})
```
