# Introducción al examen liberatorio

## Opción 1

### El departamento de recursos humanos envía el siguiente fichero...
```
nombre;apellido;password;grupo;ou;appbloqueada
juan;sinmiedo;P@ss1wordA;asir;asir;notepad
laura;valiente;P@ss1wordA;af;af;mspaint
```

#### - Nivel 1: crear un script que permita realizar todas las tareas que aparecen en el fichero.
#### - Nivel 2: crear un script que permita realizar las operaciones de forma ordenada.
#### - Nivel 3: crear un script que permita realizar las operaciones utilizando UDP.

## Opción 2

### Crear la estructura de red del Centro leyendo de un fichero, teniendo en cuenta:
- Hay seis grupos de clases, seis unidades organizativas
- Hay que crear usuarios y grupos para cada clase
- Hay que deshabilitar usuarios y moverlos a la unidad organizativa de los deshabilitados
- Borrar unidades organizativas
- Crear una carpeta para cada usuario

------------
------------

# Trabajo para optar al 10 y a MH
### Utilizando sockets comunicar un cliente con un servidor y aplicar el mayor número de conceptos vistos durante el curso:
- Crear una herramienta de control remoto.
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

--------------

## Ayuda
### Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

## Ayuda avanzada
### Pedir el nombre de un proceso y mostrar información del proceso mediante PowerShell con Node-PowerShell, EJS (Embedded JavaScript), Body-parser y Express
https://www.jesusninoc.com/2018/06/10/pedir-el-nombre-de-un-proceso-y-mostrar-informacion-del-proceso-mediante-powershell-con-node-powershell-ejs-body-parser-y-express-node-js/

### Build a Weather Website in 30 minutes with Node.js + Express + OpenWeather
https://codeburst.io/build-a-weather-website-in-30-minutes-with-node-js-express-openweather-a317f904897b

--------------

## Ejemplo de trabajo

### Realizar operaciones en un equipo remoto

```PowerShell
cls
write-host "Ip del ordenador remoto"
$ipR=read-host

##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('cls')"
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

while (1)
{

cls

Write-Host "Seleccione una opcion"

echo "1 - Sistema de archivos"
echo "2 - Agregar/eliminar software"
echo "3 - Actualizacion"
echo "4 - Gestion de procesos"
echo "5 - Programacion de tareas"
echo "6 - Gestion de usuarios"
echo "7 - Gestion de almacenamiento"
echo "8 - Gestion de red"
echo "9 - Copias de seguridad"
echo "10 - Reparacion del sistema"
echo "11 - Rendimiento del sistema"
echo "12 - Salir"

$prue1 = Read-Host
switch ( $prue1 )
    {
        1{
            cls
            Write-Host "Seleccione una opcion"
            echo "1 - Listar"
            echo "2 - Crear"
            echo "3 - Abrir"
            echo "4 - Eliminar"
            $selcec=Read-Host
            switch ( $selcec )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=[Text.Encoding]::ASCII.GetBytes('Get-ChildItem')
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                2{
                    $type=Read-Host "Escriba que tipo desea crear (File o Directory)"
                    $name=Read-Host "Escriba el nombre del $type"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Item -ItemType $type -Name $name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                3{
                    $name1=Read-Host "Nombre del archivo que desea abrir"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('start $name1')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                4{
                    ls
                    $name2=Read-Host "¿Qué desea eliminar?"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-Item $name2')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }                   
        }
        2{
            cls
            $nombre=Read-Host "Introduzca nombre del .msi que desee instalar"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('msiexec.exe /package C:\windows\Installer\($nombre)')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        Pause
        }
        3{
            cls
            echo "1 - Instalar"
            echo "2 - Desinstalar"
            Write-Host "Seleccione una opción"
            $actuali=Read-Host
            switch ($actuali)
            {
                1{
                    Write-Host "Como desea que se realize"
                    echo "1 - Normal"
                    echo "2 - En silencio"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            Write-Host "Escriba el nombre de la actualizacion"
                            $nombre=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                           
                        }
                        2{
                            Write-Host "Eliga la opción desea"
                            echo "1 - No reiniciarse al terminar"
                            echo "2 - Pedir confirmación antes de reiniciar"
                            echo "3 - Obligar a que se cierren todas las aplicaciones y se reinicie"
                            $Smodo=Read-Host
                            $Nombre=Read-Host
                            switch($Smodo)
                            {
                                1{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()
                                    
                                }
                                2{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /warnrestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                                3{
                                    ##Client
                                    $port=2020
                                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                                    $udpclient=new-Object System.Net.Sockets.UdpClient
                                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /forcerestart')"
                                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                                    $udpclient.Close()                                    
                                }
                            }
                        }
                    }
                }
                2{
                    cls
                    echo "1 - Normal"
                    echo "2 - Paquete asociado con el número de actualización"
                    Write-Host "Seleccione una opción"
                    $modo=Read-Host
                    switch ($modo)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                        2{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /unistall /kb')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }
                    }
            }
            }
            puase
        }
        4{
            cls
            echo "1 - Iniciar un proceso"
            echo "2 - Mostrar solo Nombres"
            echo "3 - Mostrar proceso de cierto programa"

            $sele=Read-Host
            switch ( $sele )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('wusa $nombre /quiet /norestart')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                } 
                2 {
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | select Name')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3 {
                    $selprog=Read-Host "Escriba el nombre del programa"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process | Select-String $selprog')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
        5{
            cls
            $program=Read-Host "que programa desea abrir"
            $time=Read-Host "a que hora"
            $nomre=Read-Host "escriba el nombre de la tarea"
            $action=New-ScheduledTaskAction -Execute $program
            $trigger=New-ScheduledTaskTrigger -Daily -At $time
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Register-ScheduledTask -Action $action -Trigger $trigger -TaskName $nomre')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()           
            Pause
            
        }
        6{
            cls
            echo "1 - Crear usuario"
            echo "2 - Eliminar usuario"
            echo "3 - Crear grupo"
            echo "4 - Ver miembros de un grupo"
            echo "5 - Eliminar grupo"
            $opcion=Read-Host "Eliga una opcion"
            switch ($opcion)
            {
            1{
                $nameuser=Read-Host "Nomre del nuevo usuario"
                $pass=Read-Host "Introduzca contraseña"
                $pass1=ConvertTo-SecureString $pass -asplaintext -force
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalUser $nameuser -Password $pass1')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            2{
                $usuer=Read-Host "Nombre del usuario"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Remove-LocalUser -Name $usuer')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            3{
                $group=Read-Host "Nombre para el grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-LocalGroup -Name $group')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            4{
                $Ngroup=Read-Host "Nombre del grupo"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Ngroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            5{
                $Rgroup=Read-Host "Nombre del grupo que vaya a eliminar"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-LocalGroupMember -Name $Rgroup')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()                
            }
            }
        }
        7{
            cls
            echo "1 - Particionar"
            echo "2 - Desfragmentar"
            echo "3 - Convertir sistemas de archivo"
            echo "4 - Cifrar"
            echo "5 - Descifrar"
            Write-Host  "Seleccione una opción"
            $almacenamiento=Read-Host
            switch ($almacenamiento)
            {
                1{
                    Write-Host "ADVERTENCIA: Nunca poner el numero '0'"
                    $NumeroD=Read-Host "Introduzca número del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('New-Partition -DiskNumber $NumeroD -UseMaximumSize -AssignDriveLetter')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    $letra=Read-Host "Letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Optimize-Volume $letra -Defrag')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Disable-BitLocker 
                    Pause
                }
                3{
                    $letra=Read-Host "Letra del disco"
                    $tipo=Read-Host "Que formato desea"                    
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Format-Volume -DriveLetter $letra -FileSystem $tipo')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                    Pause
                }
                4{
                    $letra=Read-Host "Inroduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Enable-BitLocker -MountPoint $letra -RecoveryPasswordProtector -UsedSpaceOnly -Verbose')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                5{
                    $letra=Read-Host "Introduzca letra del disco"
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Disable-BitLocker -MountPoint $letra')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
            }
              
        }
        }
        8{
            cls
            echo "1 - Saber ip"
            echo "2 - Hacer ping"
            $op=Read-Host "Seleccione una opcion"
            Switch ( $op )
            {
            1{
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ipconfig')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            2{
                $ip=Read-Host "Introduzca IPv4"
                ##Client
                $port=2020
                $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                $udpclient=new-Object System.Net.Sockets.UdpClient
                $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('ping $ip')"
                $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                $udpclient.Close()
                Pause
            }
            }
        }
        9{
            cls
            Write-Host "Se recomienda que ponga la ruta y para quedarsela usted la meta en una carpeta compartida"
            $namea=Read-Host "Nombre del archivo que desea hacer copia de seguridad"
            $ruta=Read-Host "Ruta donde desea que este la copia de seguridad"
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Copy-Item $namea $ruta')"
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()            
            Pause
        }
        10{
            cls
            Write-Host "Seleccione una opción"
            echo "1 - Ver puntos de restauracion"
            echo "2 - Restaurar un punto"
            $opcion=Read-Host
            switch ($opcion)
            {
                1{        
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()
                }
                2{
                    Write-Host "Seleccione una opción"
                    echo "1 - Ultimo punto"
                    echo "2 - Restaura cierto punto"
                    $opcion=Read-Host
                    switch ($opcion)
                    {
                        1{
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-ComputerRestorePoint -LastStatus')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()
                        }

                        2{
                            Write-Host "Ponga el numero de restauración"
                            $punto=Read-Host
                            ##Client
                            $port=2020
                            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                            $udpclient=new-Object System.Net.Sockets.UdpClient
                            $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Restore-Computer -RestorePoint $punto')"
                            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                            $udpclient.Close()                   
                        }
                    }
                }
            }
            Pause
        }
        11{
            cls
            echo "1 - Monitorizar procesos"
            echo "2 - Monitorizar procesos Avanzado"
            echo "3 - Ver todos los nombres de los contadores de rendimiento"
            $seleccionar=Read-Host "Seleccione una opción"
            switch ( $seleccionar )
            {
                1{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port
                    )
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                2{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
                3{
                    ##Client
                    $port=2020
                    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
                    $udpclient=new-Object System.Net.Sockets.UdpClient
                    $b=Invoke-Expression -Command "[Text.Encoding]::ASCII.GetBytes('Get-Counter -ListSet * | Sort-Object CounterSetName | Format-Table CounterSetName')"
                    $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
                    $udpclient.Close()                    
                    Pause
                }
            }
        }
}
if( $prue1 -eq "12" )
        {
            cls
            ##Client
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]$ipR,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('break')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            break
        }
}
```

-----------
-----------

# Modelos de examen de la asignatura de Implantación de Sistemas Operativos (ISO) de 1º de Administración de Sistemas Informáticos en Red (ASIR) tercera evaluación
- Modelo 1 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-1
- Modelo 2 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-2
- Modelo 3 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-3
- Modelo 4 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-4
- Modelo 5 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-5
- Modelo 6 https://github.com/jesusninoc/ClasesISO/blob/master/2021-05-27.md#modelo-6

-----------------

# Modelo 1

## Tener en cuenta:
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## 1. Analizar ficheros DLL en todos los equipos de la red
```PowerShell
123..125 | %{"192.168.104." + $_}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
$ruta
}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.jes"
ls $ruta
}

1..40 |  %{Invoke-Command -ComputerName ("192.168.204." + $_) -ScriptBlock {hostname}}

Invoke-Command -ComputerName dc1 -ScriptBlock {hostname}

gc .\equipos1.txt | % {
    $llistar="\\"+$_+"\c$"
    ls $llistar | select name,FullName
} | Group-Object name | select Count,Group | where count -eq 1
```
### Enable and Use Remote Commands in Windows PowerShell
https://technet.microsoft.com/en-us/library/ff700227.aspx
### How to Add a Computer to the TrustedHosts List
```PowerShell
set-item wsman:\localhost\Client\TrustedHosts -value "ABANTO"
```
### Listar funciones exportadas de un archivo DLL con DUMPBIN desde PowerShell
https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/

## 2. Analizar ficheros DLL en todos los equipos de la red, comprobar que ha cambiado una integridad y copiar el fichero que ha cambiado
### En PowerShell
```PowerShell
mkdir dlls

cd dlls

"dll1" | Out-File dll1.dll
"dll2" | Out-File dll2.dll

# Recorrrer una a una dll
ls *.dll | %{$_}

# Hacer hash de cada dll
ls *.dll | %{Get-FileHash $_.FullName | Select-Object Hash}

# Hacer hash de cada dll ruta por red
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path}

# Guardar hash
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path | Out-File listado.txt -Append}

# Ver listado
gc .\listado.txt

# Modificar dll y detectar el cambio, después mover la dll, solución: el hash de cada dll no se encuentra en el fichero listado.txt, eso quiere decir que se ha modificado y hay que copiar a la carpeta compartida en Linux
# Modificar dll
"dll6" | Out-File dll1.dll

ls '\\localhost\c$\Users\juan\dlls' *.dll | %{
    if((gc .\listado.txt) -match (Get-FileHash $_.FullName | Select-Object Hash).hash)
    {
    }
    else
    {
        $_.Name
        "Dll se ha modificado"
    }
}


# Meter el código anterior en el recorrido que cada alumno tenga
123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
ls $ruta -recurse
}

# Almacenar el hash de la dll para todos los equipos de la red
foreach($equipo in gc .\equipos1.txt) {
    $llistar="\\"+$equipo+"\c$"
    ls $llistar -recurse *.dll | %{
        $valorse = Get-FileHash ($_ | select FullName).FullName
        $valorse.path+"|"+$valorse.Hash | Out-File hasehees.txt
    }
}

# Verificar si una dll no ha cambiado su hash
gc .\hasehees.txt | %{
    if($_.split("|")[0].contains("jawt.dll"))
    {
        if($_.split("|")[1] -eq (Get-FileHash "\\ABANTOS21\c$\Cache\pc-client.exe-16.3.0.37857\runtime\jre\bin\jawt.dll" | select hash).hash)
        {
            "CORRECTO"
        }
    }
}
```
#### Se puede crear una dll y modificar una función para comprobar que la integridad falla
* https://www.jesusninoc.com/11/26/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-ejecute-un-cmdlet-de-powershell/
* https://www.jesusninoc.com/04/19/listar-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell/
* https://www.jesusninoc.com/04/21/obtener-los-nombres-de-las-funciones-exportadas-de-un-archivo-dll-con-dumpbin-desde-powershell-explicacion-paso-a-paso-del-script/

### En Linux
https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

## 3. Puedes saber qué fichero DLL están funcionando en el equipo utilizando la red
```PowerShell
(Get-Process -ComputerName .).Modules
(Get-Process -ComputerName .).Modules | where ModuleName -eq  sxs.dll
```

## 4. Detectar que una aplicación tiene tráfico de red (filtro por puerto)
### Tshark Command Examples
https://linuxsimba.com/tshark-examples

```PowerShell
$filterUDP = ''
$filterTCP = ''
ps | where ProcessName -eq 'chrome' | %{
    Get-NetUDPEndpoint | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterUDP = $filterUDP+'(udp.port == '+$_.LocalPort+') or'
    }
    
    Get-NetTCPConnection | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterTCP = $filterTCP+'(tcp.port == '+$_.LocalPort+') or'
    }
    
    
}
$filterUDP = $filterUDP.substring(0, $filterUDP.Length-3)
$filterTCP = $filterTCP.substring(0, $filterTCP.Length-3)

$filter = $filterUDP+' or '+$filterTCP

net use \\192.168.104.129\Prueba-share-samba /user:root 1234

.\tshark.exe -i 'ethernet 2' -Y $filter > \\192.168.104.129\Prueba-share-samba\test.txt
```
