# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Introducción

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

## Encontrarse a uno mismo
```PowerShell
Get-EventLog Security | Where-Object Message -Match "asir1joselui"
```

## Ejemplos de introducción a monitorizar
```PowerShell
# (INCORRECTO) Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
Get-CimInstance -ClassName Win32_StartupCommand  | select Caption, @{n='NombreP';e={(Get-Process -name $_.Caption | Select Name).name}}

# Comprobar que se está ejecutando un programa que se arranca al inicio del arranque del sistema operativo
Get-Process -Name MSOSYNC

# (CORRECTO 1) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

Get-Process -Name $acumul

# (CORRECTO 2) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
function comprobar($programa){
    Get-Process -Name $programa -ErrorAction Ignore
}

Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        comprobar $temperal[$temperal.Count-1]

}

# (CORRECTO 3) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

$acumul | %{
    $_
    ((Get-Process).name.toupper()).contains($_.toupper())
}
```

## Ejercicio: registrar un evento cuando se logre realizar una conexión entre un cliente y un servidor mediante UDP (almacenar la dirección IP de la conexión del cliente o del servidor)
* https://www.jesusninoc.com/05/08/ejercicios-de-powershell-registrar-un-evento-cuando-se-logre-realizar-una-conexion-entre-un-cliente-y-un-servidor-mediante-udp-almacenar-la-direccion-ip-de-la-conexion-del-cliente-o-del-servidor/

### Solución (otra forma de verlo, el cliente manda crear un log al servidor)

#### Cliente
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "192.168.43.108" -Category 2 -RawData 10,20')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
#### Servidor
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
Invoke-Expression ([Text.Encoding]::ASCII.GetString($content))
```

-------------------
-------------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------------

# Monitorizar procesos
## 7. Gestión de procesos en PowerShell
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

## System Monitor
System Monitor (Sysmon) is a Windows system service and device driver that, once installed on a system, remains resident across system reboots to monitor and log system activity to the Windows event log. It provides detailed information about process creations, network connections, and changes to file creation time. By collecting the events it generates using Windows Event Collection or SIEM agents and subsequently analyzing them, you can identify malicious or anomalous activity and understand how intruders and malware operate on your network.
* https://www.fwhibbit.es/sysmon-el-gran-hermano-de-windows-y-el-super-sysmonview

Install with default settings (process images hashed with sha1 and no network monitoring)
```MD-DOS
sysmon -accepteula –i
```
Install with md5 and sha256 hashing of process created and monitoring network connections
```MD-DOS
sysmon -accepteula –i –h md5,sha256 –n
```
Install Sysmon with a configuration file (as described below)
```MD-DOS
sysmon –accepteula –i c:\windows\config.xml
```
Uninstall
```MD-DOS
sysmon –u
```
Dump the current configuration
```MD-DOS
sysmon –c
```
Change the configuration to use all hashes, no network monitoring and monitoring of DLLs in Lsass
```MD-DOS
sysmon –c –h * –l lsass.exe
```
Change the configuration of sysmon with a configuration file (as described below)
```MD-DOS
sysmon –c c:\windows\config.xml
```
Change the configuration to default settings
```MD-DOS
sysmon –c --
```
Show the configuration schema
```MD-DOS
sysmon -s
```

## Sources, configuration and how to detect evil things utilizing Microsoft Sysmon
https://github.com/MHaggis/sysmon-dfir

--------------
--------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------

# Logs

## Logs en Windows

### PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

### List event log
https://www.jesusninoc.com/2018/03/27/list-event-log

### Write-EventLog
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/write-eventlog?view=powershell-5.1

### Escribir y ver un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Almacenar información convertida a byte en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/05/almacenar-informacion-convertida-a-byte-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Ejecutar la información que se encuentra en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/06/ejecutar-la-informacion-que-se-encuentra-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Windows Event Log to the Dark Side — Storing Payloads and Configurations
https://medium.com/@5yx/windows-event-log-to-the-dark-side-storing-payloads-and-configurations-9c8ad92637f2

### Active Directory: Configuring Event Log Subscriptions (Forwarding)
https://sid-500.com/2018/04/23/active-directory-configuring-event-log-subscriptions-forwarding/

### HOW TO DETECT PASS-THE-HASH ATTACKS
https://blog.stealthbits.com/how-to-detect-pass-the-hash-attacks/

## Logs en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-13.md#registros-de-sucesos

```Bash
cd /var/log
ls
```

- /var/log/message: registro de mensajes generales del sistema
- /var/log/auth.log: log de autenticación
- /var/log/kern.log: registro del kernel
- /var/log/cron.log: registro de cron
- /var/log/maillog: registro del servidor de mails
- /var/log/qmail/ : registro de Qmail
- /var/log/httpd/: registro de errores y accesos a Apache
- /var/log/lighttpd: registro de errores y accesos a Lighttpd
- /var/log/boot.log : registro de inicio del sistema
- /var/log/mysqld.log: registro de la base de datos MySQL
- /var/log/secure: log de autenticación
- /var/log/utmp or /var/log/wtmp : registro de logins

### Analizar logs en Linux
#### Regular Expressions
```Bash
 grep -a "user juanito" /var/log/auth.log
```
#### Tail
```Bash
$ tail -f /var/log/auth.log | grep -a 'invalid'
```
#### Cut
```Bash
grep "authentication failure" /var/log/auth.log | cut -d '=' -f 8
```
#### Awk
```Bash
awk '/sshd.*invalid user/ { print $9 }' /var/log/auth.log
```
