# Administración del acceso al dominio:
- Equipos del dominio.
- Permisos y derechos.
- Delegación de permisos / autoridad.
  - Asistente para la delegación de control.
  - Herramientas de línea de comandos: dsacls.exe y dsrevoke.exe.	🤦
- Listas de control de acceso.

# Joining Computers

## Tener en cuenta
 - IP fija
 - ping
 - DNS
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

## Joining Computers to a Domain (PowerShell)
http://community.idera.com/powershell/powertips/b/tips/posts/joining-computers-to-a-domain

## Joining Computers to a Domain (GUI)
 
# Ejercicios

## Ejercicios sin scripts
- INSTALAR UN EQUIPO Y METERLO EN EL DOMINIO

## Ejercicios con scripts
- Acceso remoto desde Powershell https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-01-16.md

-----------
-----------

# Repaso de casos
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-02-22.md#situaci%C3%B3n-cr%C3%ADtica-3-resolver-la-siguiente-situaci%C3%B3n-con-scripts
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-02-22.md#situaci%C3%B3n-cr%C3%ADtica-4-resolver-la-siguiente-situaci%C3%B3n-con-scripts

------------------------------------
------------------------------------

# Administración del acceso al dominio:
- Equipos del dominio.
- Permisos y derechos.
- Delegación de permisos / autoridad.
  - Asistente para la delegación de control.
  - Herramientas de línea de comandos: dsacls.exe y dsrevoke.exe.	🤦
- Listas de control de acceso.

## Tener en cuenta
 - IP fija
 - ping
 - DNS
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

# Listas de control de acceso
## Permisos desde PowerShell
* https://www.jesusninoc.com/01/23/clonar-permisos-ntfs/
* https://www.jesusninoc.com/08/19/anadir-permiso-ntfs-a-una-carpeta/
* https://www.jesusninoc.com/03/30/eliminar-permisos-explicitos/

# Ejercicios
## Ejercicios con scripts
- Crear un usuario en el AD, delegar la tarea de "Unir un equipo al dominio" a ese usuario y ejecutar el script para que el equipo se meta en el dominio (desde el equipo que queremos meter en el dominio)
  - Local
  - Remoto
    * http://community.idera.com/powershell/powertips/b/tips/posts/joining-computers-to-a-domain

# Práctica compleja
## Añadir un controlador de dominio adicional
  - Controlador de dominio adicional: Para tener más de un Controlador de Dominio, simplemente debemos ejecutar el mismo proceso anterior, sólo que en este caso durante el asistente le diremos que es Controlador de Dominio adicional, en un Dominio ya existente. En este caso toda la información de Active Directory que está en el primero se replicará en el segundo Controlador de Dominio
  - Replicación https://windowserver.wordpress.com/2014/12/02/windows-server-2012-r2-crear-un-dominio-instalacin-y-configuracin-del-segundo-controlador-de-dominio/

-------------------
-------------------

# Administración del acceso al dominio:
- Equipos del dominio.
- Permisos y derechos.
- Delegación de permisos / autoridad.
  - Asistente para la delegación de control.
  - Herramientas de línea de comandos: dsacls.exe y dsrevoke.exe.	🤦
- Listas de control de acceso.

## Tener en cuenta
 - IP fija
 - ping
 - DNS
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

# Usuarios y grupos
## Añadir usuarios y grupos desde el AD (GPO)
* https://www.cesarherrada.com/2014/07/que-son-y-para-que-sirven-los-grupos-restringidos.html

# Ejercicios
## Ejercicios con scripts
- Analizar GPO (en remoto y local)
  - Local
    * https://www.jesusninoc.com/05/12/view-group-policy-objects/
    ```PowerShell
      $resulta = gpresult /z
      foreach($lineas in $resulta)
      {
          if($lineas -match "CMD")
          {
              $lineas
          }
      } 
    ```
  - Remoto
    * https://www.jesusninoc.com/04/23/obtener-gpos-objetos-de-directiva-de-grupo-que-no-se-estan-utilizando/
    ```PowerShell
    Get-GPO -All | %{
      $_ | Get-GPOReport -ReportType XML | Select-String "Impedir el acceso al símbolo del sistema"
    }
    ```
    
------------------
------------------

# Linux scripting
- Vamos por el if

# WSL
* https://www.jesusninoc.com/05/24/interoperabilidad-wsl-con-windows-llamar-a-powershell-desde-ubuntu/
