# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuario SYSTEM en Windows
* [https://windowstips.wordpress.com/2011/01/10/system-causa-y-efecto-i-de-iv/](https://windowstips.wordpress.com/2011/01/10/system-causa-y-efecto-i-de-iv/)
* [https://windowstips.wordpress.com/2011/01/11/system-causa-y-efecto-ii-de-iv/](https://windowstips.wordpress.com/2011/01/11/system-causa-y-efecto-ii-de-iv/)

## Ejercicio script de creación de usuarios en AD
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

## Más sobre usuarios en AD
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-24.md

--------------

# Passwords

## ENCONTRAR UN PASSWORD QUE CONTIENE LOS NÚMEROS DE LA PRIMERA FILA DEL TECLADO QWERTY GENERANDO COMBINACIONES ALEATORIAS
https://www.jesusninoc.com/01/20/encontrar-un-password-que-contiene-los-numeros-de-la-primera-fila-del-teclado-qwerty-generando-combinaciones-aleatorias/

## Contraseñas seguras con PowerShell
https://www.jesusninoc.com/contrasenas-seguras-con-powershell/

## Cracking Passwords Version 1.1
https://repo.zenk-security.com/Reversing%20.%20cracking/Cracking_Passwords_Guide.pdf

## Privilege Escalation without Automated Tools - InfoSec Resources
https://securitydocs.com/privilege-escalation-without-automated-tools-infosec-resources/38418/

--------------

# Random

## Ejercicio PowerShell: adivinar un número aleatorio que genera PowerShell

```PowerShell
#Generar un número aleatorio entre 1 y 100
Get-Random (1..100)
```
```PowerShell
#Pedir al usuario un número una vez e intentar adivinar el número aleatorio que se ha generado
$numeroadivinar=Get-Random (1..100)
$a=Read-Host "Intentar adivinar un número, introduzca número"
if($numeroadivinar -eq $a)
{
"Número adivinado"
}
```
```PowerShell
#Pedir al usuario números para intentar adivinar un número aleatorio entre 1 y 100
$numeroadivinar=Get-Random (1..100)
while($true)
{
$a=Read-Host "Intentar adivinar un número, introduzca número"
if($numeroadivinar -eq $a)
{
"Número adivinado"
#Si se adivina el número salir del bucle while con break
break
}
}
```
```PowerShell
#Pedir al usuario números para intentar adivinar un número aleatorio entre 1 y 100, ofrecer ayuda al usuario para adivinar el número
$numeroadivinar=Get-Random (1..100)
do
{
$a=Read-Host "Intentar adivinar un número, introduzca número"
switch($numeroadivinar)
{
{$_ -le $a -and $_ -ge 1}{Write-Host "No adivinado, el número es menor que $a" -ForegroundColor red}
{$_ -eq $a}{Write-Host "Número adivinado" -BackgroundColor Blue;break}
{$_ -ge $a -and $_ -le 100}{Write-Host "No adivinado, el número es mayor que $a" -ForegroundColor red}
}
#Si el número está adivinado acabar de preguntar al usuario
}while(!($numeroadivinar -eq $a))
```

## Más sobre random
### Generar letras aleatorias
https://www.jesusninoc.com/2017/10/11/generar-letras-aleatorias/

### Generate Random Text based on Length
https://www.commandlinefu.com/commands/view/24101/generate-random-text-based-on-length

### Ejercicios de PowerShell: mostrar y escribir una letra aleatoria por consola en el menor tiempo posible con PowerShell
https://www.jesusninoc.com/2017/09/02/ejercicios-de-powershell-mostrar-y-escribir-una-letra-aleatoria-por-consola-en-el-menor-tiempo-posible-con-powershell/

### Generar palabras aleatorias con letras aleatorias
https://www.jesusninoc.com/2017/01/07/generar-palabras-aleatorias-con-letras-aleatorias/

### Ejercicios de PowerShell: mostrar y escribir una palabra aleatoria por consola en el menor tiempo posible con PowerShell
https://www.jesusninoc.com/2017/09/05/ejercicios-de-powershell-mostrar-y-escribir-una-palabra-aleatoria-por-consola-en-el-menor-tiempo-posible-con-powershell/

### Ejercicios de PowerShell: crear el juego de piedra, papel o tijera
https://www.jesusninoc.com/2017/03/01/ejercicios-de-powershell-crear-el-juego-de-piedra-papel-o-tijera/

### Ejercicios de PowerShell: crear el juego de piedra, papel o tijera (script en una línea)
https://www.jesusninoc.com/2017/03/02/ejercicios-de-powershell-crear-el-juego-de-piedra-papel-o-tijera-script-en-una-linea/

### Tres en raya
```Java
private int[][] lineaGanadora = new int[][] { { 0, 1, 2 }, { 3, 4, 5 }, { 6, 7, 8 }, { 0, 3, 6 }, { 1, 4, 7 }, { 2, 5, 8 }, { 0, 4, 8 }, { 2, 4, 6 } };
```

--------------

# Ejercicio de password y random
## Crear usuarios con un password random e intentar adivinarlo con Cain y Abel
```PowerShell
(((1..9) | Get-Random -Count 4) -join "") + (((97..99) | Get-Random -Count 2 | % {[char]$_}) -join "") + (((65..67) | Get-Random -Count 2 | % {[char]$_}) -join "")
```
## Cain y Abel
* https://github.com/xchwarze/Cain

--------------
--------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Repaso random PowerShell
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-14.md#random

# Chuletas
* https://www.jesusninoc.com/05/02/chuleta-resumen-de-operaciones-en-el-sistema-operativo-con-archivos-y-directorios-en-modo-texto-comandos-en-linux-y-windows-y-cmdlets-en-powershell-y-modo-grafico/
* https://www.jesusninoc.com/05/03/chuleta-resumen-de-tareas-de-administracion-en-el-sistema-operativo-en-modo-texto-comandos-en-linux-y-windows-y-cmdlets-en-powershell-y-modo-grafico/
