# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Gestión de usuarios en Windows (Server)

## Instalación de servicios de directorio

# Administración de servicio de directorio

## Active Directory
* http://sec.cs.kent.ac.uk/x500book/
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-18.md
* http://www.developandsys.es/category/windows-server/active-directory/
* http://www.developandsys.es/gestion-objetos-active-directory/

### Instalación, configuración, objetos, relaciones de confianza, gpos, rodc, dc secundario (versión core)
* http://www.developandsys.es/category/windows-server/active-directory/

## OpenLDAP, Samba y Samba DC
* http://www.developandsys.es/?s=open+ldap
* http://www.developandsys.es/nfs-y-samba/

## Filtros LDAP

### UTILIZAR UN FILTRO LDAP PARA LOCALIZAR UN USUARIO
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
### UTILIZAR UN FILTRO LDAP PARA VERIFICAR LA HORA DEL ÚLTIMO INICIO DE SESIÓN DE LOS USUARIOS DEL ACTIVE DIRECTORY
* https://www.jesusninoc.com/07/05/utilizar-un-filtro-ldap-para-verificar-la-hora-del-ultimo-inicio-de-sesion-de-los-usuarios-del-active-directory/

## Crear usuarios leyendo desde un fichero (explicar fichero y bucle foreach)
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Ficheros
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Bucle_Foreach

## Cmdlets para Active Directory
* http://www.developandsys.es/gestion-objetos-active-directory/

## Crear en AD usuarios y OU leyendo de un fichero
```PowerShell
foreach($elemento in Get-Content .\crear.txt)
{
    $elemento
    New-ADUSer -Name $elemento -Sam $elemento -Path "OU=Localizacion,DC=Dominio,DC=Local" -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
    Start-Sleep -Seconds 5
}

foreach($elemento in Get-Content .\crear.txt)
{
    $elemento.split(",")[0]
}

foreach($elemento in Get-Content .\crear.txt)
{
    if($elemento.split(",")[0] -eq 1)
    {
        "crear ou " + $elemento.split(",")[1]
    }
    
    if($elemento.split(",")[0] -eq 2)
    {
        "crear user " + $elemento.split(",")[1]
        New-ADUSer -Name $elemento.split(",")[1] -Sam $elemento.split(",")[1] -Path "OU=Localizacion,DC=Dominio,DC=Local" -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
    }
}
```
