# Examen de evaluación

## Posibles preguntas
- Crear un script que mediante un login (que lee de un fichero) el usuario introduzca una opción y si es 1 añada un fichero a un fichero comprimido.

## Exámenes para repasar

* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-03.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-04.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-05.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-12.md

## Temario que entra en el examen de evaluación

### Instalación de software libre y propietario

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.
- Arquitectura de un sistema operativo. Sistemas por lotes (batch). Sistemas por lotes con multiprogramación. Sistemas de tiempo compartido. Sistemas distribuidos.
- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.
- Tipos de sistemas operativos.
  - Monousuario o multiusuario
  - Centralizado o distribuido
  - Monotarea o multitarea
  - Uniprocesador o multiprocesador
  - Instalables y/o autoarrancables.
- Sistemas operativos libres.
- Sistemas operativos propietarios.
- Tipos de aplicaciones. Software de sistema. Software de programación. Software de aplicación.
- Licencias y tipos de licencias. Según los derechos que cada autor se reserva sobre su obra. Según su destinatario.
- Máquinas virtuales (M.V.)
  - Concepto de virtualización del hardware y características de los principales productos software libre y propietario, para el uso de máquinas virtuales.
  - Creación y personalización de M.V.
  - Ventajas e inconvenientes de la virtualización.
- Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
  - Particionado del disco duro.
  - En sistemas Windows determinar la partición donde instalaremos el S.O.
  - En sistemas Linux determinar las particiones para los distintos puntos de montaje.
  - Controladores (drivers) de almacenamiento necesarios.
- Instalación de sistemas operativos.
  - Requisitos hardware, versiones y licencias.
  - Soporte utilizado para la instalación: CD/DVD, Pendrive, LAN.
  - Datos necesarios para la instalación: usuarios, contraseñas, nombre del equipo, direcciones IP, número de licencia, etc.
- Gestión de varios sistemas operativos en un ordenador.
  - Requisitos previos. Administración del espacio del disco. Particionado y redimensionado.
  - Problemas con el registro maestro de arranque (MBR). Elegir un gestor de arranque compatible con todos los sistemas operativos a instalar.
  - Preparar las particiones de los S.O. para permitir su arranque.
  - Analizar el orden en la instalación de los sistemas operativos.
- Gestores de arranque.
  - Código de arranque maestro (Master Boot Code).
  - Formatos tabla de particiones. Master Boot Record (MBR) y Guid Partition Table (GPT).
  - Configuración de los gestores de arranque de los sistemas operativos libres y propietarios.
  - Reparación del gestor de arranque.
  - Sustitución del gestor de arranque estándar por otro más completo.
- Instalación/desinstalación de aplicaciones. Requisitos hardware y software, versiones y licencias.
- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
- Ficheros necesarios para el arranque de los principales sistemas operativos.
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
- Actualización y mantenimiento de controladores de dispositivos.
  - Automatizar la actualización de controladores.
  - Volver a una versión anterior de un controlador.
  - Actualización manual de los controladores.
  
 ### Administración y aseguramiento de la información
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

--------------
--------------

# Correción del examen
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-12-03.md#preguntas-examen-liberatorio
* https://github.com/jesusninoc/ISO-1/blob/main/Examen%20liberatorio
## Soluciones
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-1-con-where/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-2-con-foreach/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-3-creando-una-carpeta-con-la-informacion-obtenida-cada-24-horas/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-4-pasando-como-parametro-el-proceso-a-monitorizar/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-5-pasando-como-parametro-cada-proceso-que-se-ejecuta-y-monitorizando-cada-24-horas/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-obtener-informacion-sobre-los-procesos-que-se-estan-ejecutando-que-hace-un-proceso/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-obtener-informacion-sobre-los-procesos-que-se-estan-ejecutando-analizando-las-dll-que-ejecuta-que-hace-un-proceso/

## Examen subida de nota: realizar un ejercicio sobre copias de seguridad en Linux, utilizando como idea la solución en PowerShell (primer enlace)
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-12-10.md#ejercicio-sobre-copias-de-seguridad-con-integridad-comprobar-que-los-ficheros-que-tengo-en-una-carpeta-son-correctos-en-la-copia-de-seguridad-mediante-la-integridad
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-12-10.md#ejercicios-sobre-copias-de-seguridad

--------
--------

# Administración y aseguramiento de la información
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------

# Ficheros en Linux

## Introducción a buscar ficheros
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjerciciosFicherosBuscar.sh

## Conocer la extensión de un fichero en Linux
```Bash
file fichero
```

## Ejercicio calcular hash en Linux
```Bash
proceso=`ps -C nano -o cmd --no-headers`
ruta=`whereis $proceso`
sha512sum $ruta
```

## Introducción a bucles en Linux
* https://www.jesusninoc.com/2015/07/13/bucles-2/
* https://www.jesusninoc.com/2016/01/02/for-loop-examples/

## Bucle for en Linux
```Bash
for i in $(pgrep application.x); do ps -mo pid,tid,fname,user,psr -p $i;done
```

## Ver funcionamiento de awk
```Bash
echo "hola amigo" | awk '{print $1}'
echo "hola amigo" | awk '{print $2}'
echo "touch amigo" | awk '{print $1}'; echo "touch amigo" | awk '{print $2}'
```

## Calcular el hash SHA512 de todos los procesos que se están ejecutando en Linux
```Bash
for procesos in $(ps -aux | awk '{print $11}');do ruta=`whereis $procesos`; sha512sum $ruta;done
```

-------------

# Ficheros en PowerShell

## Listar ficheros cuya fecha de última escritura de ficheros sea de mayor que menos un día
```PowerShell
Get-ChildItem | where LastWriteTime -gt (Get-Date).AddDays(-1)
```
## Listar ficheros cuyo tamaño sea mayor de 1MB
```PowerShell
Get-ChildItem -Recurse | where Length -Gt 1MB
```
## Listar la ruta de los programas que se están ejecutando
```PowerShell
foreach($procesos in (Get-Process | select path))
{
    Get-FileHash $procesos.path
}
```
## Listar la ruta del programa Chrome que se está ejecutando
```PowerShell
foreach($id in Get-Process -Name chrome)
{
    Get-FileHash $id.Path
}
```

---------------

# Linux

## Copias de seguridad
* http://www.developandsys.es/copias-seguridad-linux/

## Programar la copia de seguridad
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh

## Ejercicios sobre copias de seguridad
- Listar archivos por fecha
  ```Bash
  ls -lt
  ls -ltr
  ls -l --sort=size
  ```
- Copia de seguridad para cada día de la semana y ser capaz de recuperar
  * https://www.youtube.com/watch?v=aDCfL9Pk3TQ&feature=youtu.be
  * https://github.com/jesnino/Bash/blob/master/Ficheros/EjercicioCalendario.sh
- Copiar cada fichero listado de un directorio en un nuevo directorio
  * https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-22.md#utilizar-xargs
- Comprimir las copias de seguridad que se han realizado
  * https://linuxzone.es/metodos-de-compresion-y-descompresion-en-linux/
- Enviar un mail cuando se haya realizado la copia de seguridad
  * https://www.interserver.net/tips/kb/linux-mail-command-usage-examples/

## Copias de seguridas de bases de datos

### MySQL dump ignorando tablas
* https://github.com/jesusninoc/Scripts/blob/master/MySQL%20dump%20ignorando%20tablas.sh

### MySQL dump completo
* https://github.com/jesusninoc/Scripts/blob/master/MySQL%20dump%20completo.sh

### Borrar copias de seguridad de bases de datos en MySQL.sh
* https://github.com/jesusninoc/Scripts/blob/master/Borrar%20copias%20de%20seguridad%20de%20bases%20de%20datos%20en%20MySQL.sh

### Database Backup Program (examples)
* https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/

-----------------

# PowerShell

## Ejercicio sobre copias de seguridad con integridad: comprobar que los ficheros que tengo en una carpeta son correctos en la copia de seguridad mediante la integridad

```PowerShell
# Ideas

# Probar la integridad de las copias de seguridad:
# - Crear un plan de pruebas. 
# - Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
# - Comprobar si los tiempos de restauración son asumibles.

# Ficheros que se van a copiar
# fichero1.txt
# fichero2.txt
# fichero3.txt
# fichero4.txt

# Ficheros que tienen las integridades de los ficheros 1,2,3,4
# fichero1integridad.txt
# fichero2integridad.txt
# fichero3integridad.txt
# fichero4integridad.txt

# crear el zip 1,2,3,4

# -------------------- RECUPERACIÓN

# descomprimir zip 1,2,3,4

# ver integridad fichero que tiene los hashes 1,2,3,4

# fichero1 si abro si la integridad es correcta

"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt

# zip meter fichero1.txt más integridades.txt (se puede separar en dos archivos)

# hay fallo y tengo que recuperar la copia

# descomprimir y ver si el fichero1.txt lo puedo ver

# porque la integridad de fichero1 es correcta

# h(f1) == f1*

if((gc .\fichero1integridad.txt) -eq (Get-FileHash .\fichero1.txt).hash)
{
    "El hash coincide"
}
else
{
    "El hash no coincide"
}

# Ver si el hash coincide para todos los ficheros

mkdir ficheros
cd .\ficheros
"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt
"holas" > fichero2.txt
(Get-FileHash .\fichero2.txt).hash
(Get-FileHash .\fichero2.txt).hash > fichero2integridad.txt

# Se supone que se ha comprimido

# Hay fallo
 
# Verificar que todos los hashes son correctos

ls fichero?.txt | %{
    $ficherointeg = $_.FullName
    $ficherointeg2 = $ficherointeg.replace(".txt","")
    $ficherofinal = ([String]$ficherointeg2+"integridad.txt")

    if(((Get-FileHash $_).hash) -eq (gc $ficherofinal))
    {
        "El hash coincide"
    }
    else
    {
        "El hash no coincide"
    }
}
```

-------------
-------------

# Repaso evaluación
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-05.md#resolver-las-siguientes-situaciones

----------

# Administración y aseguramiento de la información
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------

# PowerShell

## Ejercicio sobre copias de seguridad con integridad: comprobar que los ficheros que tengo en una carpeta son correctos en la copia de seguridad mediante la integridad

```PowerShell
# Ideas

# Probar la integridad de las copias de seguridad:
# - Crear un plan de pruebas. 
# - Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
# - Comprobar si los tiempos de restauración son asumibles.

# Ficheros que se van a copiar
# fichero1.txt
# fichero2.txt
# fichero3.txt
# fichero4.txt

# Ficheros que tienen las integridades de los ficheros 1,2,3,4
# fichero1integridad.txt
# fichero2integridad.txt
# fichero3integridad.txt
# fichero4integridad.txt

# crear el zip 1,2,3,4

# -------------------- RECUPERACIÓN

# descomprimir zip 1,2,3,4

# ver integridad fichero que tiene los hashes 1,2,3,4

# fichero1 si abro si la integridad es correcta

"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt

# zip meter fichero1.txt más integridades.txt (se puede separar en dos archivos)

# hay fallo y tengo que recuperar la copia

# descomprimir y ver si el fichero1.txt lo puedo ver

# porque la integridad de fichero1 es correcta

# h(f1) == f1*

if((gc .\fichero1integridad.txt) -eq (Get-FileHash .\fichero1.txt).hash)
{
    "El hash coincide"
}
else
{
    "El hash no coincide"
}

# Ver si el hash coincide para todos los ficheros

mkdir ficheros
cd .\ficheros
"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt
"holas" > fichero2.txt
(Get-FileHash .\fichero2.txt).hash
(Get-FileHash .\fichero2.txt).hash > fichero2integridad.txt

# Se supone que se ha comprimido

# Hay fallo
 
# Verificar que todos los hashes son correctos

ls fichero?.txt | %{
    $ficherointeg = $_.FullName
    $ficherointeg2 = $ficherointeg.replace(".txt","")
    $ficherofinal = ([String]$ficherointeg2+"integridad.txt")

    if(((Get-FileHash $_).hash) -eq (gc $ficherofinal))
    {
        "El hash coincide"
    }
    else
    {
        "El hash no coincide"
    }
}
```

## Programar la copia de seguridad
* https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/
* https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1

## Ejercicio: crear una tarea programada que ejecuta un script en PowerShell que realiza una copia de seguridad
### Crear una copia de seguridad
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-26.md#ejercicio-sobre-copias-de-seguridad-con-integridad-comprobar-que-los-ficheros-que-tengo-en-una-carpeta-son-correctos-en-la-copia-de-seguridad-mediante-la-integridad
* https://www.jesusninoc.com/12/08/crear-una-tarea-programada-en-windows-que-ejecute-un-script-de-powershell-cada-10-minutos-de-forma-indefinida-aunque-el-porcentaje-de-bateria-sea-bajo/
### Tener en cuenta a la hora de programar la tarea que ejecuta el script
```PowerShell
# Cambiar la política de ejecución de scripts para poder ejecutar
Set-ExecutionPolicy -ExecutionPolicy Unrestricted -Scope CurrentUser

# Ecribir un mensaje por pantalla
echo "hola"

# Mostrar la ruta
pwd

# Parar el script
pause

# Almacenar en un fichero la hora a la que se ejecuta el script junto con el porcentaje de batería
echo (Get-Date).Hour >> C:\xampp\mysql\bin\fichero.txt
```
### Repetir cada 1 hora indefinidamente la ejecución de un script en PowerShell
```PowerShell
$Sta = New-ScheduledTaskAction -Execute "powershell"
$Stt = New-ScheduledTaskTrigger -Once -At 19pm -RepetitionInterval (New-TimeSpan -hour 1)
Register-ScheduledTask Task01 -Action $Sta -Trigger $Stt
```

-------------
-------------

# Clase especial

## Instalar Icecast is free server software for streaming multimedia
```Bash
sudo apt-get install icecast2 darkice
```

## Descargar un mp4 y un mp3 en la carpeta /usr/share/icecast2/web
```Bash
wget https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3
```

## Reproducir ficheros desde el móvil
http://192.168.1.162:8000/sound.mp3

## Download videos from YouTube (youtube-dl)
https://www.jesusninoc.com/2014/10/18/download-videos-youtube/

## Subir a un servidor el contenido generado en PowerShell
https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/

## Descargar ficheros de un servidor Linux desde PowerShell
https://www.jesusninoc.com/2017/11/04/descargar-un-fichero-por-ssh-de-un-servidor-linux-desde-powershell-en-windows/

## Cortar un vídeo
https://github.com/jesusninoc/Scripts/blob/master/Cortar%20un%20v%C3%ADdeo.sh

## Convertir a texto un audio en formato WAV
https://www.jesusninoc.com/08/15/convertir-audio-en-formato-wav-a-texto-version-15-08-2015/

## Reconocimiento de voz a texto
https://www.jesusninoc.com/06/26/reconocimiento-de-patrones-utilizando-powershell/#Reconocimiento_de_voz_a_texto

---------------------

# Clase especial

## Instalar Icecast is free server software for streaming multimedia
```Bash
sudo apt-get install icecast2 darkice
```

## Descargar un mp4 y un mp3 en la carpeta /usr/share/icecast2/web
```Bash
wget https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3
```

## Reproducir ficheros desde el móvil
http://192.168.1.162:8000/sound.mp3

## Download videos from YouTube (youtube-dl)
https://www.jesusninoc.com/2014/10/18/download-videos-youtube/

## Subir a un servidor el contenido generado en PowerShell
https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/

## Descargar ficheros de un servidor Linux desde PowerShell
https://www.jesusninoc.com/2017/11/04/descargar-un-fichero-por-ssh-de-un-servidor-linux-desde-powershell-en-windows/

## Cortar un vídeo
https://github.com/jesusninoc/Scripts/blob/master/Cortar%20un%20v%C3%ADdeo.sh

## Convertir a texto un audio en formato WAV
https://www.jesusninoc.com/08/15/convertir-audio-en-formato-wav-a-texto-version-15-08-2015/

## Reconocimiento de voz a texto
https://www.jesusninoc.com/06/26/reconocimiento-de-patrones-utilizando-powershell/#Reconocimiento_de_voz_a_texto

---------------------

# Ejercicio 

## Partir en trozos un audio en MP3, convertirlos en WAV y después convertir a texto el audio

### Partir en trozos un audio en MP3 y convertirlos en WAV
```CMD
ffmpeg -i audio.mp3 -ss 70 -t 113 miaudio_cortado.mp3
ffmpeg -i song.mp3 -acodec pcm_u8 -ar 22050 song.wav
```

#### Versión 1
```PowerShell
[void][reflection.assembly]::LoadWithPartialName(‘system.speech’)

$rec = New-Object ‘System.Speech.Recognition.SpeechRecognitionEngine’
$rec.LoadGrammar((New-Object ‘System.Speech.Recognition.DictationGrammar’))
$rec.SetInputToWaveFile("C:\Users\ajnino\Downloads\ffmpeg-20191120-d73f062-win32-static\ffmpeg-20191120-d73f062-win32-static\bin\song.wav")
[String]$almacenarcadena=''
[String]$cadenaconvert=''

do
{
$cadena=$rec.Recognize().Text
$cadenaconvert=[String]$cadena.ToString()
$cadenaconvert
}while($rec.AudioFormat)
```

---------------------

# Otros enlaces interesantes

## Expresiones regulares
https://www.regular-expressions.info/tutorial.html
http://www.vicente-navarro.com/blog/2007/04/13/expresiones-regulares-en-la-shell-ejemplos-de-uso-con-grep-awk-y-sed/

## DEJAVU: AUDIO FINGERPRINTING AND RECOGNITION IN PYTHON
https://www.jesusninoc.com/02/06/dejavu-audio-fingerprinting-and-recognition-in-python/

## Número de hilos que ejecuta Icecast
https://github.com/jesnino/Bash/blob/master/Procesos/EjerciciosHilos.sh

## Simular la transmisión de vídeo entre un cliente y un servidor (streaming)
https://www.jesusninoc.com/2016/03/12/simular-la-transmision-de-video-entre-un-cliente-y-un-servidor-streaming/

## Enviar un vídeo MP4 entre dos Linux mediante Netcat
https://www.jesusninoc.com/2017/11/12/enviar-un-video-mp4-entre-dos-linux-mediante-netcat/

## Livestreamer is a command-line utility that pipes video streams from various services into a video player, such as VLC
https://www.jesusninoc.com/2017/10/07/livestreamer/

## Conectarse por SSH al router de fibra óptica MitraStar de Movistar desde PowerShell
https://www.jesusninoc.com/2017/11/16/conectarse-por-ssh-al-router-de-fibra-optica-mitrastar-de-movistar-desde-powershell/

## Ver los procesos que se están ejecutando en el router de fibra óptica MitraStar de Movistar desde PowerShell
https://www.jesusninoc.com/2017/11/17/ver-los-procesos-que-se-estan-ejecutando-en-el-router-de-fibra-optica-mitrastar-de-movistar-desde-powershell/

## Autenticarse en un router de fibra óptica MitraStar de Movistar y ver una lista de llamadas perdidas
https://www.jesusninoc.com/2017/04/10/autenticarse-en-un-router-de-fibra-optica-mitrastar-de-movistar-y-ver-una-lista-de-llamadas-perdidas/

## Autenticarse en un router de fibra óptica MitraStar de Movistar y ver las reglas del firewall
https://www.jesusninoc.com/2017/04/13/autenticarse-en-un-router-de-fibra-optica-mitrastar-de-movistar-y-ver-las-reglas-del-firewall/

## Autenticarse en un router de fibra óptica MitraStar de Movistar y ver las asignaciones DHCP
https://www.jesusninoc.com/2017/05/14/autenticarse-en-un-router-de-fibra-optica-mitrastar-de-movistar-y-ver-las-asignaciones-dhcp/

## Autenticarse en un router de fibra óptica MitraStar de Movistar y ver la tabla ARP
https://www.jesusninoc.com/2017/05/10/autenticarse-en-un-router-de-fibra-optica-mitrastar-de-movistar-y-ver-la-tabla-arp/

-----------------

# Clase especial

## REPRODUCIR TRÁILERES DE PELÍCULAS
* https://www.jesusninoc.com/11/21/reproducir-traileres-de-peliculas/

## ENVIAR LA REPRODUCCIÓN DE LOS TRÁILERES DE PELÍCULAS A LA SMART TV
* https://www.jesusninoc.com/11/22/enviar-la-reproduccion-de-los-traileres-de-peliculas-a-la-smart-tv/

-----------------

# Clase especial

## Crear un audio que vamos a mandar mediante señales de radio

```PowerShell
#Convertir una frase en audio con la voz del sistema operativo desde PowerShell

Add-Type -AssemblyName System.Speech
$synthesizer = New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer
$synthesizer.SetOutputToWaveFile("saludo.wav")
$synthesizer.Speak("Hola amigo Pedro")
$synthesizer.SetOutputToDefaultAudioDevice()
Get-ChildItem .\saludo.wav
```

## Subir el audio a Raspberry Pi realizando una conexión SCP
```PowerShell
#Iniciar una sesión SCP
#Para iniciar sesión SSH es necesario indicar la dirección IP del equipo al que nos vamos a conectar y también hay que introducir los credenciales (usuario y contraseña).

$Pass = ConvertTo-SecureString -String "raspberry" -AsPlainText -Force
$Credential = New-Object -TypeName "System.Management.Automation.PSCredential" -ArgumentList "pi", $Pass

#Para configurar Set-SCPFile
#Indicar el fichero que vamos a subir -LocalFile
#Indicar el equipo al que nos vamos a conectar -ComputerName
#Indicar la ruta en la que vamos a subir el audio -RemotePath
#Forzar la conexión para evitar fallo "Key exchange negotiation failed."
#Indicar los credenciales que hemos creado anteriormente

Set-SCPFile -LocalFile .\saludo.wav -ComputerName 192.168.1.161 -RemotePath ./fmm/fm_transmitter-master -Force -Credential $Credential
```

-----------------

# Más clases especiales
* https://www.jesusninoc.com/02/16/muneco-bailando/
* https://github.com/jesusninoc/ClasesIAW/blob/master/2019-11-25.md#proyectos-de-la-semana
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-01-01.md

--------------
--------------

# Examen de ISO

## Función que crear una estructura de directorios sobre la información que hay de servicios, procesos e hilos
## Copia de seguridad (realizar una función)
