# Falta por ver:
- Permisos

---------
---------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Linux

## Compressing files
* https://www.cyberciti.biz/howto/question/general/compress-file-unix-linux-cheat-sheet.php

## Sumar en Linux
* https://www.jesusninoc.com/11/28/como-realizar-operaciones-aritmeticas-en-linux/

## Crear calendario en Linux
* https://www.youtube.com/watch?v=aDCfL9Pk3TQ&feature=youtu.be
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjercicioCalendario.sh

## Ejemplos en Bash (con repaso sobre comandos)

### Crea  directorios con los años desde 2020 hasta 2030
```Bash
mkdir {2020..2030}
```

### En cada uno de los directorios, crea un subdirectorio con los meses del año
```Bash
mkdir -p {2020..2030}/{Enero,Febrero,Marzo,Abril,Mayo,Junio,Julio,Agosto,Septiembre,Octubre,Noviembre,Diciembre}
```

### En cada mes, crear un directorio con cada día de la semana
```Bash
mkdir -p {2020..2030}/{Enero,Febrero,Marzo,Abril,Mayo,Junio,Julio,Agosto,Septiembre,Octubre,Noviembre,Diciembre}/{Lunes, Martes,Miercoles,Jueves,Viernes,Sabado,Domingo}
```

### Borrar todos los directorios Julio y Agosto de todos los años
```Bash
rm -r {2020..2030}/{Julio,Agosto}
```

### Crear un alias del comando "rm" que se llame borrar y que permita borrar el directorio Ejercicio1 (con su contenido)
```Bash
alias borrar='rm -r -f ejercicio1'
```

----------
----------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# ¿Server instalado?

---------------

# Repaso
## Eliminar el contenido de las carpetas impares de un servidor web
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-05.md#eliminar-el-contenido-de-las-carpetas-impares-de-un-servidor-web-1

## Estamos viendo sistema de archivos
* https://github.com/jesnino/PowerShell/blob/master/Ficheros/EjemplosLeerOperacionesTareasBasicasII.ps1

## TAREAS BÁSICAS II (SISTEMA DE ARCHIVOS)
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

|Tarea|Cmdlet
|---|---
|Crear o modificar un archivo|New-item
|Crear un directorio|New-item
|Ver el contenido de un archivo|Get-Content
|Acceder al contenido de un directorio|Set-Location
|Listar el contenido de un directorio|Get-Childitem
|Eliminar un archivo|Remove-Item
|Eliminar un directorio|Remove-Item
|Copiar un archivo o un directorio|Copy-Item
|Mover un archivo o un directorio|Move-Item
|Renombrar un archivo o un directorio|Rename-Item
|Imprimir un archivo|Out-Printer

## Fechas
https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Fechas

## Tienen atributos que se pueden listar (show hidden files)
https://www.jesusninoc.com/2014/11/23/show-hidden-files/

## Creación de directorios
* https://github.com/jesnino/PowerShell/blob/master/Ficheros/SolucionEjerciosFicherosProcesos.ps1
* https://www.youtube.com/watch?v=CibNbK9sp8A&list=PL89qBrmFzAa34fM6OEMLV6ybDk3Y34qud&index=3

## If
* https://www.jesusninoc.com/2016/08/05/sentencia-condicional-if/
* https://www.jesusninoc.com/2015/04/26/sentencia-condicional-if-else/
* https://www.jesusninoc.com/2016/08/07/sentencia-condicional-if-elseif-else/

## BUCLE EN POWERSHELL
* https://www.jesusninoc.com/2017/10/08/listar-todos-los-caracteres-ascii-en-powershell/
* https://www.jesusninoc.com/2017/10/05/listar-todos-los-caracteres-ascii-en-bash/

---------------

# Ejercicios

## Repaso eliminar ficheros impares
```PowerShell
"hola" | out-file 2020-11-26.txt
"hola" | out-file 2020-11-25.txt

foreach($nombre in Get-ChildItem)
{
    if($nombre.Name.Split("-")[2].replace(".txt","") % 2 -eq 1)
    {
        Remove-Item $nombre -WhatIf
    }
}
```

## Repaso elminar ficheros impares (con alias de foreach: %)
```PowerShell
Get-ChildItem | %{
    if($_.Name.Split("-")[2].replace(".txt","") % 2 -eq 1)
    {
        Remove-Item $_ -WhatIf
    }
} 
```

## Crear para varios días de la semana (desde lunes pasado hasta hoy jueves) una estructura de directorios con los procesos que se están ejecutando en el sistema
```PowerShell
-3..0 | %{
    mkdir (Get-Date).AddDays($_).ToString("yyyyMMdd")
    cd (Get-Date).AddDays($_).ToString("yyyyMMdd")
    mkdir (Get-Process).Name
    cd ..
}
```

## Preguntar al usuario por la operación que quiere realizar y el nombre del fichero que sobre el que quiere realizar las siguientes operaciones que tenemos que programar son:
## - comprimir un archivo
## - descomprimir un archivo
```PowerShell
$operacion = Read-Host "Introduzca operación"
if ($operacion -eq "comprimir")
{
    $ficheroparacomprimir = Read-Host "Introduzca fichero para comprimir"
    Compress-Archive $ficheroparacomprimir -DestinationPath $ficheroparacomprimir.Replace(".txt",".zip")
}
elseif ($operacion -eq "descomprimir")
{
    $ficheroparadescomprimir = Read-Host "Introduzca fichero para descomprimir"
    Expand-Archive $ficheroparadescomprimir
}
```


## Obtener el hash de los programas que se están ejecutando en el sistema
## 1. Obtener la ruta de los programas que se están ejecutando
## 2. Hacer el hash a esos programas
```PowerShell
foreach($ruta in (Get-Process))
{
    $ruta.name
    Get-FileHash $ruta.Path
}
```

## Realizar tareas leyendo de un fichero
```PowerShell
#Añadir operaciones al fichero
"fecha" | Out-File operaciones.txt -Append
"hilos" | Out-File operaciones.txt -Append
"crear" | Out-File operaciones.txt -Append
"imprimir" | Out-File operaciones.txt -Append
"comprimir" | Out-File operaciones.txt -Append

gc .\operaciones.txt

foreach($operaciones in gc .\operaciones.txt)
{
    switch($operaciones)
    {
        "fecha"{get-date}
        "hilos"{Get-Process | select Threads}
        "crear"{New-Item -Name elque -ItemType File}
        "imprimir"{echo "hola" | Out-Printer "Microsoft Print to PDF"}
        "comprimir"{Compress-Archive -LiteralPath .\123-11.txt –CompressionLevel Optimal -DestinationPath 123.zip}
    }
}
```

---------------

# Permisos en PowerShell
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Permisos-2
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-26.md
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md
* https://www.jesusninoc.com/03/30/eliminar-permisos-explicitos/

---------------

# Permisos en Linux
## Permisos especiales en Linux
http://rm-rf.es/permisos-especiales-setuid-setgid-sticky-bit/

|Permiso|Explicación
|---|---
|- - - - - - - - -	= 0|Predeterminado, sin permisos especiales. No se requiere indicar.
|- - - - - - - - t	= 1|Bit de persistencia, sticky bit
|- - - - - s - - -	= 2|Bit sgid de grupo
|- - - - - s - - t	= 3|Bit sgid y sticky
|- - s - - - - - -	= 4|Bit suid
|- - s - - - - - t	= 5|Bit suid y sticky
|- - s - - s - - -	= 6|Bit suid y sgid
|- - s - - s - - t	= 7|Bit suid, sgid y sticky

- sticky: se utiliza para permitir que cualquiera pueda escribir y modificar sobre un archivo o directorio, pero que solo su propietario o root pueda eliminarlo. 
- suid: el bit SUID activo en un archivo significa que el que lo ejecute va a tener los mismos permisos que el que creó el archivo.
- sgid: el SGID es lo mismo que en el SUID, pero a nivel de grupo. Es decir, todo archivo que tenga activo el SGID, al ser ejecutado, tendrá los privilegios del grupo al que pertenece.

## Permisos en Linux (EJERCICOS AVANZADOS SOBRE PERMISOS)

### Permisos en Linux avanzados
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

### Asignar permisos mediante llamada a sistema chmod en C
* https://www.jesusninoc.com/2014/12/01/chmod-system-call-example/
