# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

------------------

# Ejercicios resueltos con ficheros y directorios (PowerShell)

## Crear directorios con los meses del año
* https://www.jesusninoc.com/12/01/ejercicios-de-powershell-crear-directorios-con-los-meses-del-ano/

## Crear directorios con los años desde 2020 hasta 2030 (opción 1)
* https://www.jesusninoc.com/12/02/ejercicios-de-powershell-crear-directorios-con-los-anos-desde-2020-hasta-2030-opcion-1/

## Crear directorios con los años desde 2020 hasta 2030 (opción 2)
* https://www.jesusninoc.com/12/03/ejercicios-de-powershell-crear-directorios-con-los-anos-desde-2020-hasta-2030-opcion-2/

## Crear directorios con los años desde 2020 hasta 2030 (opción 3)
* https://www.jesusninoc.com/12/04/ejercicios-de-powershell-crear-directorios-con-los-anos-desde-2020-hasta-2030-opcion-3/

## En cada uno de los directorios anteriores, crea un subdirectorio con los meses del año
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio)
    cd $anio
    foreach($mes in 1..12)
    {
        mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes)
    }
    cd ..
}
```

## En cada mes, crear un directorio con cada día del mes
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio)
    cd $anio
    foreach($mes in 1..12)
    {
        mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes)
        cd $mes
        1..31 | %{mkdir $_}
        cd ..
    }
    cd ..
}
```

## Trabajar con fechas
```PowerShell
$mes = (get-date).Month
$ano = (get-date).year
$dia = (get-date).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (día anterior)
```PowerShell
$mes = (get-date).AddDays(-1).Month
$ano = (get-date).AddDays(-1).Year
$dia = (get-date).AddDays(-1).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (listar varios días)
```PowerShell
-1..-7
 
foreach($dias in (-1..-7))
{
    $dias
}
 
foreach($dias in (-1..-7))
{
    (Get-Date).AddDays($dias)
}
 
foreach($dias in (-1..-7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
}
```

## Hay un proceso que falla, revisad la información sobre servicios, procesos e hilos durante una semana (creando ficheros de registro varias veces al día)
 
### Parte 1
### -Crear la carpeta para cada día y para varios momentos del día

#### Solución rara (o no), calculando el número de horas
```PowerShell
foreach($dias in (1..168))
{
    $mes = (get-date).AddHours($dias).Month
    $ano = (get-date).AddHours($dias).Year
    $dia = (get-date).AddHours($dias).Day
    $horas = (get-date).AddHours($dias).Hour
    mkdir $ano$mes$dia$horas -WhatIf
}
```
#### Solución medio buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    foreach($horas in 0..23)
    {
        mkdir $ano$mes$dia$horas -WhatIf
    }
}
```
#### Solución bastante buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
   
    foreach($horas in 0..23)
    {
        $ruta = [String]$ano+[String]$mes+[String]$dia
        $ruta
        New-Item -Name $horas -Path $ruta -ItemType Directory -WhatIf
    }
}
```
#### Solución mucha locura
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta0 = $ano+"\"+$mes+"\"+$dia
    mkdir $ruta0 -WhatIf
   
    foreach($horas in 0..23)
    {
        New-Item -Name $horas -Path $ruta0 -ItemType Directory -WhatIf
    }
}
```

### Parte 2
#### -Listar procesos
#### -Listar hilos
#### -Listar servicios

#### Solución que se ejecuta durante una semana (168 horas)
```PowerShell
foreach($veces in 168)
{
    $fecha = (Get-Date).ToString("yyyy\\MM\\dd")
    mkdir $fecha -Force
 
    $hora = (Get-Date).Hour
    New-Item -Name $hora -Path $fecha -ItemType Directory -Force
 
    (Get-Process).Name > ([String]($fecha+"\"+$hora+"\procesos.txt"))
    (Get-Service).Name > ([String]($fecha+"\"+$hora+"\servicios.txt"))
    (Get-Process).Threads > ([String]($fecha+"\"+$hora+"\hilos.txt"))
 
    Start-Sleep -Seconds 3600
}
```

#### Solución de Daniel Cebrián
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta = $ano+"\"+$mes+"\"+$dia

    mkdir $ruta -Force

    foreach($horas in 0..23)
    {   
        New-Item -Name $horas -Path $ruta -ItemType Directory -Force
        [String]$procesos = (gps).name
        [String]$ruta1= ($ruta+"\"+$horas)
        New-Item -Name procesos.txt -Path $ruta1 -ItemType File -value $procesos -Force
    }
}
```

--------
--------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO
