# Resolver ejercicio propuesto: listar los procesos cuyo identificador de hilo se encuentre en una lista (el listado de procesos aparece escrito en un fichero y se tiene que ejecutar con IEX) (el fichero fichero.txt tiene Get-Process como contenido y el fichero hilo.txt tiene un número como contenido)
```PowerShell
(Get-Content .\fichero.txt) + " -id (Get-WmiObject win32_thread | where handle -eq (Get-Content .\hilo.txt)).ProcessHandle" | iex
```

-----------------
-----------------

# Examen mes de noviembre (obtener información sobre hilos en Linux y PowerShell)

## Linux

### Leer nombre de proceso de un fichero y mostrar hilos
```Bash
echo "ps -fL -C @sh" > fichero
echo "ps -fL -C @sh" >> fichero

while read linea
do
echo $linea
`echo $linea | cut -d '@' -f1 ; echo $linea | cut -d '@' -f2` >> resultado
done < fichero

cat resultado
```

### Mostrar el nombre de los procesos leyendo de un fichero el identificador de proceso
```Bash
echo "323@232@8888" > fichero

while read linea
do
echo $linea
ps -f -p `echo $linea | cut -d '@' -f1` >> resultado
done < fichero

cat resultado
```

### Sacar los hilos de los procesos leyendo el nombre del proceso de un fichero
```Bash
echo "nano" > fichero
echo "sh" >> fichero

while read linea
do
echo $linea
ps -fL -C `echo $linea | cut -d '@' -f1` >> resultado
done < fichero

cat resultado
```

## PowerShell

### Leer nombre de proceso de un fichero y mostrar hilos
```PowerShell
echo "ps @notepad" > fichero
echo "ps @notepad" >> fichero
Get-Content .\fichero

foreach($linea in Get-Content .\fichero)
{
    $ejecutar = $linea.split("@")[0] + $linea.split("@")[1]
    $ejecutar + " | select threads" | iex
}
```

### Mostrar el nombre de los procesos leyendo de un fichero el identificador de proceso
```PowerShell
echo "1288" > fichero
echo "1200" >> fichero
Get-Content .\fichero

foreach($linea in Get-Content .\fichero)
{
    Get-Process -Id $linea | select name
}
```

### Sacar los hilos de los procesos leyendo el nombre del proceso de un fichero
```PowerShell
echo "notepad" > fichero
echo "chrome" >> fichero
Get-Content .\fichero

foreach($linea in Get-Content .\fichero)
{
    Get-Process -name $linea | select name,threads
}
```

### Analizar hilos (solución)
https://www.jesusninoc.com/02/06/analizar-hilos-con-powershell/

### Otra más
```PowerShell
# Listar identificadores de hilos
(Get-Process -name notepad | select threads).threads.id

# Listar información de un hilo en concreto
Get-WmiObject -Class win32_thread -Filter "Handle = 6248" | Out-File

# Sirve para analizar la información de hilos en función del proceso que los crea (Notepad)
(Get-Process -name notepad).id
$var=(Get-Process -name notepad).id
Get-WmiObject -Class win32_thread -Filter "ProcessHandle = $var"

# (Leyenda) Sirve para analizar información de hilos en función de los identificadores de cada hilo del proceso que los crea (Notepad)
$var=(Get-Process -name notepad | select threads).threads.id
$var | %{$_}
Get-WmiObject -Class win32_thread -Filter "ProcessHandle = $var"
$var | %{Get-WmiObject -Class win32_thread -Filter "Handle = $_"}
```

### Otra posible solución
```PowerShell
#Mostrar el proceso que creó el hilo
Get-WmiObject -Class Win32_Thread | %{
    if((Get-Process -Id $_.ProcessHandle).name -eq "notepad")
    {
        write-host $_.ProcessHandle,$_.handle
        Get-Process -Id $_.ProcessHandle | select name,id
    }
}
```

### Solución para entender la solución de Linux
```PowerShell
echo "ps@notepad" > fichero

foreach ($linea in gc fichero)
{
    $ejecutar = $linea.split("@")[0] + " -name " + $linea.split("@")[1]
    $ejecutar | iex
}
```

------------------

# Ejercicios

## Instalar un paquete MSI junto con información sobre la instalación
```PowerShell
cd ~
msiexec /i C:\Windows\Installer\42014f.msi /Liwearucmopvx log.txt
msiexec /i C:\Windows\Installer\42014f.msi /Li logi.txt
Start-Sleep -Seconds 5
msiexec /i C:\Windows\Installer\42014f.msi /Lw logw.txt
```

## Ver el número de serie de un equipo
```PowerShell
(Get-WmiObject Win32_SystemEnclosure).SerialNumber
```

## Ver controladores
```PowerShell 
gwmi Win32_USBControllerDevice |%{[wmi]($_.Dependent)} | Sort Manufacturer,Description,DeviceID | Ft -GroupBy Manufacturer Description,Service,DeviceID
 
Get-PnpDevice
```
  
## Ver actualizaciones
```PowerShell
$Sesion = New-Object -ComObject Microsoft.Update.Session
$actualizacion = $Sesion.CreateUpdateSearcher().Search("IsInstalled=1").Updates
$actualizacion | Select-Object Title
```
  
## Obtener información sobre las actualizaciones
* https://www.jesusninoc.com/03/11/ejercicios-de-powershell-obtener-informacion-sobre-las-actualizaciones/

---------------
---------------

# Ver por dónde vamos del temario
