# Rasp y RTL2832U
* https://www.amazon.es/NinkBox-Actualizada-Alimentaci%C3%B3n-Interruptor-Ventilador/dp/B07ZV9C6QF?adgrpid=85854335224&dchild=1&gclid=CjwKCAjwtfqKBhBoEiwAZuesiGld85BhhJI0JnsCXQBvpLbIHLC5HSKLhRpgEj6t2mTrVxB5d7WTjRoC564QAvD_BwE&hvadid=386797104615&hvdev=c&hvlocphy=1005493&hvnetw=g&hvqmt=e&hvrand=9720134279721877312&hvtargid=kwd-296166530780&hydadcr=13835_1743485&keywords=amazon+raspberry+pi&qid=1633620944&sr=8-4&linkCode=ll1&tag=secci-21&linkId=4dd687791469668d84367abb6f040c5c&language=es_ES&ref_=as_li_ss_tl
* https://www.amazon.es/Sintonizador-Compatible-paquetes-ESD-segura-Garantizado/dp/B009U7WZCA?dchild=1&keywords=RTL&qid=1633620843&sr=8-5&linkCode=ll1&tag=secci-21&linkId=a2456d8dc355f6541704c950c1682c45&language=es_ES&ref_=as_li_ss_tl

--------------
--------------

# Parte especial de la clase (conexión con Linux)

## SSH

### Instalar y ejecutar SSH para PowerShell
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.11 -Credential (Get-Credential)
```

### Conexión después de haber desconectado y quitado el módulo Posh-SSH (hay que volver a importarlo)
```PowerShell
Set-ExecutionPolicy -ExecutionPolicy Unrestricted

Import-Module Posh-SSH

New-SSHSession -ComputerName 10.20.104.19 -Credential (Get-Credential)

Get-SSHSession

(Invoke-SSHCommand -Index 0 "uname -r").output

(Invoke-SSHCommand -Index 0 "lscpu").output | Out-File informacionunubntu.txt -Append
(Invoke-SSHCommand -Index 0 "lshw").output | Out-File informacionunubntu.txt -Append
(Invoke-SSHCommand -Index 0 "nproc").output | Out-File informacionunubntu.txt -Append
```

### Ejemplo: obtener información sobre la versión de Linux
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.14 -Credential (Get-Credential)
Get-SSHSession
Invoke-SSHCommand -Index 0 "uname"
```

### Ejemplo: obtener información sobre la CPU
```PowerShell
# Realizar la conexión SSH
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -Computer
# Obtener información sobre el procesador desde Linux mediante una conexión SSH
(Invoke-SSHCommand -Index 0 "bash -c lscpu | grep '32-bit'")
(Invoke-SSHCommand -Index 0 "bash -c lscpu | grep '32-bit' | cut -d':' -f2  | cut -d'-' -f1 ").output
# ¿Es intel?
(Invoke-SSHCommand -Index 0 "lscpu").output
if((Invoke-SSHCommand -Index 0 "lscpu").output -match "Intel"){"Intel"}else{"No es Intel"}
(Invoke-SSHCommand -Index 0 "lscpu").output | select-string "cache"
```

### JuiceSSH - SSH Client
https://play.google.com/store/apps/details?id=com.sonelli.juicessh

### JuiceSSH Performance Plugin
https://play.google.com/store/apps/details?id=com.sonelli.juicessh.performancemonitor

### Guardar un fichero html preguntando al usuario qué título quiere
```PowerShell
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html
start chrome .\web.html
```

### Configurar IP en Windows
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

### Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## WSL
### Obtener información sobre la versión de Linux con WSL
```PowerShell
wsl uname -r
wsl uname -a
wsl cat /proc/version
```

### Información sobre la arquitectura
```PowerShell
(Invoke-SSHCommand -Index 0 "bash -c ""lscpu | grep 'Architecture'""").output
```

### Almacenar en un fichero información sobre la CPU mediante WSL desde PowerShell
```PowerShell
bash -c lscpu | Select-String "Architecture:","Model name:" | Out-File bonito.txt
[String]$var = bash -c lscpu | Select-String "Model name:"
$var.split("@")[1] | Out-File bonito.txt -Append
notepad .\bonito.txt
```

### 3. Gestión del hardware en Linux (nivel intermedio)
https://www.jesusninoc.com/03/03/3-gestion-del-hardware-en-linux-nivel-intermedio/

---------------------
---------------------

# Instalación de software libre y propietario

- Gestión de varios sistemas operativos en un ordenador.
  - Requisitos previos. Administración del espacio del disco. Particionado y redimensionado.
  - Problemas con el registro maestro de arranque (MBR). Elegir un gestor de arranque compatible con todos los sistemas operativos a instalar.
  - Preparar las particiones de los S.O. para permitir su arranque.
  - Analizar el orden en la instalación de los sistemas operativos.
- Gestores de arranque.
  - Código de arranque maestro (Master Boot Code).
  - Formatos tabla de particiones. Master Boot Record (MBR) y Guid Partition Table (GPT).
  - Configuración de los gestores de arranque de los sistemas operativos libres y propietarios.
  - Reparación del gestor de arranque.
  - Sustitución del gestor de arranque estándar por otro más completo.

---------------------

# Arranque
- BIOS
- POST
- Arranque (dual, BCD, BCDEdit, etc.)
- Arranque de procesos

## Arranque en Linux
### Proceso de arranque en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Arranque en Windows
### Master Boot Record
https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-2000-server/cc976786(v=technet.10)
### Proteger el proceso de arranque de Windows 10
https://docs.microsoft.com/es-es/windows/security/hardware-protection/secure-the-windows-10-boot-process
### Procesos de credenciales de autenticación de Windows
https://docs.microsoft.com/es-es/windows-server/security/windows-authentication/credentials-processes-in-windows-authentication

-------------
-------------

# Repaso de comunicación por red entre Windows y Linux
* https://www.jesusninoc.com/10/26/crear-una-comunicacion-entre-un-cliente-en-powershell-de-windows-y-un-servidor-en-bash-de-linux-utilizando-tcpip/
