# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Memoria

## Ejercicios PowerShell sobre variables

### Mostrar un char desde un int
```PowerShell
[Int]'A'[0]
```
### Mostrar un int desde un char
```PowerShell
[Char]65
```
### Ejecutar un cmdlet leyendo desde un fichero el cmdlet
```PowerShell
"gps" | Out-File ejecutar.txt
Invoke-Expression (gc .\ejecutar.txt)
```
### Modificar el contenido de un fichero
```PowerShell
1 | Out-File ejemplo1.txt
(gc ejemplo1.txt)+"modificado" | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
### Modificar el contenido de un fichero (leer un número de un fichero y sumar un número, después almacenar el valor)
* https://www.jesusninoc.com/11/13/ejercicios-de-powershell-modificar-el-contenido-de-un-fichero-leer-un-numero-de-un-fichero-y-sumar-un-numero-despues-almacenar-el-valor/
### Modificar el contenido de un fichero (leer un número de un fichero y restar un número, después almacenar el valor)
* https://www.jesusninoc.com/11/15/ejercicios-de-powershell-modificar-el-contenido-de-un-fichero-utilizando-variables-leer-un-numero-de-un-fichero-y-restar-un-numero-despues-almacenar-el-valor/
### Modificar el contenido de un fichero utilizando variables (leer un número de un fichero y restar un número, después almacenar el valor)
* https://www.jesusninoc.com/11/15/ejercicios-de-powershell-modificar-el-contenido-de-un-fichero-utilizando-variables-leer-un-numero-de-un-fichero-y-restar-un-numero-despues-almacenar-el-valor/
### Listar la mitad de un número de procesos y ordenarlos (el usuario introduce los valores en variables y los almacena en ficheros)
```PowerShell
$first = Read-Host "intro first"
$first | Out-File first.txt

$orden = Read-Host "intro orden"
$orden | Out-File orden.txt
gps | select -First ([Int ]$first / 2) | sort $orden
```

### Guardar un valor aleatorio en un fichero
```PowerShell
(Get-Random (1..5)) | Out-File aleatorio.txt
```

---------------
---------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Ejercicios sobre hilos

## Almacenar información sobre los hilos
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar información sobre los hilos del proceso Notepad 
* https://www.jesusninoc.com/11/17/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-del-proceso-notepad/

## Mostrar información sobre los hilos de todos los procesos que se están ejecutando (qué proceso ejecuta el hilo)
* https://www.jesusninoc.com/11/19/ejercicios-de-powershell-mostrar-informacion-sobre-los-hilos-de-todos-los-procesos-que-se-estan-ejecutando-que-proceso-ejecuta-el-hilo/

## Listar hilos de cada proceso
* https://www.jesusninoc.com/07/22/listar-los-hilos-de-un-proceso/

## Almacenar información sobre hilos de forma continuada
* https://www.jesusninoc.com/11/22/ejercicios-de-powershell-almacenar-informacion-sobre-hilos-de-forma-continuada/

## Mostrar los hilos de cada proceso utilizando WMI y el cmdlet Get-Process
* https://www.jesusninoc.com/11/23/ejercicios-de-powershell-mostrar-los-hilos-de-cada-proceso-utilizando-wmi-y-el-cmdlet-get-process/

## Relación entre servicios y procesos
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

## Ayuda de servicios con procesos
```PowerShell
foreach($elementos in (Get-WmiObject -Class Win32_Service))
{
    $elementos
}

Get-WmiObject -Class Win32_Service | %{
Write-Host $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```

## Ayuda de procesos WMI con procesos
```PowerShell
Get-WmiObject Win32_Process | %{
    $_.Handles,$_.ProcessHandle,(Get-Process -Id $_.ProcessHandle).ProcessName
}

Get-WmiObject Win32_Process | %{
    (Get-Process -Id $_.ProcessId),$_.ProcessName,$_.Handle,$_.ProcessId
}
```

## Almacenar el número de procesos e hilos en un fichero junto con la fecha (el script se ejecuta cada cinco segundos)
* https://www.jesusninoc.com/11/26/ejercicios-de-powershell-almacenar-el-numero-de-procesos-e-hilos-en-un-fichero-junto-con-la-fecha-el-script-se-ejecuta-cada-cinco-segundos/

# Servicios y relación con procesos
## No funciona porque no puede convertir ProcessID
```PowerShell
Get-WmiObject -Class Win32_Service | Select-Object Name,ProcessID, (Get-Process -Id ProcessID).name
```
## Sí funciona
* https://www.jesusninoc.com/10/11/mostrar-la-relacion-entre-servicios-y-procesos-con-powershell/

# Procesos y ruta de ejecución del proceso
* https://www.jesusninoc.com/11/29/ejercicios-de-powershell-procesos-y-ruta-de-ejecucion-del-proceso/

# Ejercicios de PowerShell: saber la ruta de los servicios que se están ejecutando
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-saber-la-ruta-de-los-servicios-que-se-estan-ejecutando/

# Ejercicios de PowerShell: de la lista de hilos que se están ejecutando indicar si alguno es un hilo de un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-hilos-que-se-estan-ejecutando-indicar-si-alguno-es-un-hilo-de-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de la lista de procesos que se están ejecutando indicar si alguno es un proceso de un servicio
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-la-lista-de-procesos-que-se-estan-ejecutando-indicar-si-alguno-es-un-proceso-de-un-servicio/

# Ejercicios de PowerShell: de los servicios que se están ejecutando indicar el nombre del proceso
* https://www.jesusninoc.com/10/01/ejercicios-de-powershell-de-los-servicios-que-se-estan-ejecutando-indicar-el-nombre-del-proceso/

# Ejercicios de PowerShell: mostrar el padre de un hilo
* https://www.jesusninoc.com/09/29/ejercicios-de-powershell-mostrar-el-padre-de-un-hilo/
