# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

------------------

# Ejercicios propuestos

## Juntar dos ficheros con información (fichero con fecha y fichero con procesos que se ejecutan):
* https://www.jesusninoc.com/11/02/ejercicios-de-powershell-juntar-dos-ficheros-con-informacion-fichero-con-fecha-y-fichero-con-procesos-que-se-ejecutan/

## Ejecutar un comando que se encuentra escrito en una cadena:
* https://www.jesusninoc.com/11/03/ejercicios-de-powershell-ejecutar-un-comando-que-se-encuentra-escrito-en-una-cadena/

## Mostrar los procesos con un Where:
* https://www.jesusninoc.com/11/04/ejercicios-de-powershell-mostrar-informacion-sobre-un-proceso-que-se-esta-ejecutando-con-un-where/

## Abrir procesos leyendo desde un fichero (en un fichero aparece el número de veces que se abre el proceso y en otro fichero aparece el nombre del proceso que queremos abrir)
* https://www.jesusninoc.com/11/05/ejercicios-de-powershell-abrir-procesos-leyendo-desde-un-fichero-en-un-fichero-aparece-el-numero-de-veces-que-se-abre-el-proceso-y-en-otro-fichero-aparece-el-nombre-del-proceso-que-queremos-abrir/

## Parar el proceso leyendo desde un fichero el nombre del proceso que vamos a parar (el nombre del proceso que vamos a parar se almacena mediante un Out-File siendo el primer proceso)
* https://www.jesusninoc.com/11/06/ejercicios-de-powershell-parar-el-proceso-leyendo-desde-un-fichero-el-nombre-del-proceso-que-vamos-a-parar-el-nombre-del-proceso-que-vamos-a-parar-se-almacena-mediante-un-out-file-siendo-el-primer-p/

------------------

# Ejercicios básicos sobre procesos en PowerShell (con alias)
* https://www.jesusninoc.com/09/22/ejercicios-de-powershell-ejercicios-basicos-sobre-procesos-en-powershell-con-alias/

-----------

# Ejercicios básicos sobre procesos en Linux
* https://www.jesusninoc.com/03/11/ejercicios-basicos-sobre-procesos-en-linux/

# Ejercicios avanzados
* Convertir 1. Introducción a PowerShell (nivel intermedio) en WSL
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario y almacena en un fichero

### Ayuda:
```PowerShell
ps | sort cpu
```
```PowerShell
ps | sort cpu | select -First 5
ps | sort cpu -Descending | select -First 5
```
```PowerShell
ps | select -First 5 | sort cpu
ps | select -First 5 | sort cpu -Descending
```
```PowerShell
ps | select -First (Read-Host) | sort (Read-Host)
ps | select -First (gc numero) | sort (gc buscar)
```
```PowerShell
$guardarnumero = Read-Host "Dime número de procesos a listar"
$guardarnumero | Out-File numerodeprocesos.txt
Get-Content .\numerodeprocesos.txt

$guardarvalor = Read-Host "Dime por qué valor ordenar"
$guardarvalor | Out-File numerodevalores.txt
Get-Content .\numerodevalores.txt

Get-Process | Select-Object -First (Get-Content .\numerodeprocesos.txt) | Sort-Object (Get-Content .\numerodevalores.txt)
```
