# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

--------------

# Logs

## Logs en Windows

### PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

### List event log
https://www.jesusninoc.com/2018/03/27/list-event-log

### Write-EventLog
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/write-eventlog?view=powershell-5.1

### Escribir y ver un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Almacenar información convertida a byte en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/05/almacenar-informacion-convertida-a-byte-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Ejecutar la información que se encuentra en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/06/ejecutar-la-informacion-que-se-encuentra-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

### Windows Event Log to the Dark Side — Storing Payloads and Configurations
https://medium.com/@5yx/windows-event-log-to-the-dark-side-storing-payloads-and-configurations-9c8ad92637f2

### Active Directory: Configuring Event Log Subscriptions (Forwarding)
https://sid-500.com/2018/04/23/active-directory-configuring-event-log-subscriptions-forwarding/

### HOW TO DETECT PASS-THE-HASH ATTACKS
https://blog.stealthbits.com/how-to-detect-pass-the-hash-attacks/

## Logs en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-13.md#registros-de-sucesos

```Bash
cd /var/log
ls
```

- /var/log/message: registro de mensajes generales del sistema
- /var/log/auth.log: log de autenticación
- /var/log/kern.log: registro del kernel
- /var/log/cron.log: registro de cron
- /var/log/maillog: registro del servidor de mails
- /var/log/qmail/ : registro de Qmail
- /var/log/httpd/: registro de errores y accesos a Apache
- /var/log/lighttpd: registro de errores y accesos a Lighttpd
- /var/log/boot.log : registro de inicio del sistema
- /var/log/mysqld.log: registro de la base de datos MySQL
- /var/log/secure: log de autenticación
- /var/log/utmp or /var/log/wtmp : registro de logins

### Analizar logs en Linux
#### Regular Expressions
```Bash
 grep -a "user juanito" /var/log/auth.log
```
#### Tail
```Bash
$ tail -f /var/log/auth.log | grep -a 'invalid'
```
#### Cut
```Bash
grep "authentication failure" /var/log/auth.log | cut -d '=' -f 8
```
#### Awk
```Bash
awk '/sshd.*invalid user/ { print $9 }' /var/log/auth.log
```
