# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

--------------------------

# Saltar restricciones
* https://www.jesusninoc.com/04/24/ejecutar-la-calculadora-a-traves-de-explorer/
* https://www.jesusninoc.com/06/04/ejecutar-la-informacion-que-se-encuentra-en-un-valor-dentro-de-la-clave-clsid-del-registro-de-windows/
* https://www.jesusninoc.com/02/01/explicacion-sobre-el-uso-de-funciones-que-estan-en-dll-del-sistema-operativo-en-powershell/
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-04-05.md

# Auditoría

## Enumeración FileSystemRights: Define los derechos de acceso que se utilizará al crear reglas de acceso y auditoría
https://msdn.microsoft.com/es-es/library/system.security.accesscontrol.filesystemrights(v=vs.110).aspx
```PowerShell
[Enum]::GetNames([System.Security.AccessControl.FileSystemRights]) 
```

## Eventos
### 10. Gestión del rendimiento en PowerShell (nivel intermedio)
https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
### EventLog
https://www.jesusninoc.com/eventlog/
### Saber quién inició sesión en el sistema operativo de forma detallada analizando el registro de eventos de Windows (se requieren privilegios de administrador)
https://www.jesusninoc.com/07/23/saber-quien-inicio-sesion-en-el-sistema-operativo-de-forma-detallada-analizando-el-registro-de-eventos-de-windows-se-requieren-privilegios-de-administrador/
### Windows EVTX Samples [More than 160 EVTX examples]
https://github.com/sbousseaden/EVTX-ATTACK-SAMPLES
### Crear eventos
* https://www.jesusninoc.com/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/
* https://www.jesusninoc.com/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

## Auditoría de proceso de línea de comandos
https://docs.microsoft.com/es-es/windows-server/identity/ad-ds/manage/component-updates/command-line-process-auditing
