# Situación crítica 1 (resolver la siguiente situación con scripts)

## Los hospitales están habilitando zonas nuevas para poder atender a pacientes, eso quiere decir que van a utilizar equipos clientes y servidores, tu tarea es ser capaz de poner odenadores nuevos con la misma configuración que tienen los anteriores (usuarios, programas, actualizaciones, carpetas compartidas) y no solo es clonar y ya. Crea un procedimiento con scripts para resolver la situación.

## Ejemplos de cómo se puede resolver la situación:

- Sacar los usuarios de un equipo y crearlos en otro leyendo de un fichero.
- Ver los programas que hay instalados en un equipo e instalarlos en otro leyendo de un fichero.
- Ver las carpetas compartidas que hay en un equipo y crearlas en otro leyendo de un fichero.

## Ideas que se pueden aplicar:
- Tareas programadas https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#hyper-v-backup-vms-to-a-shared-folder-with-windows-server-backup-and-a-scheduled-task-
- WMI Query Language https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#wmi-query-language
- Ejercicios curso MySQL con PowerShell https://www.jesusninoc.com/2017/02/20/ejercicios-curso-mysql-con-powershell/
- Leer un usuario desde un servidor web (HTML, XML, JSON) crearlo y meterlo en el grupo de administradores (no te olvides del password).
- Detectar mediante una función que el usuario pertenece al grupo de administradores.
- Intentar utilizar las credenciales de un usuario y verificar que funciona (guarda en un fichero la captura).
- Expresiones regulares https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-13.md#expresiones-regulares

-----------------

# Solución a la situación crítica 1

## Seleccionar usuarios que empiezan por una letra (con una expresión regular)
* https://www.jesusninoc.com/04/12/ejercicios-de-powershell-seleccionar-usuarios-que-empiezan-por-una-letra-con-una-expresion-regular/

## Restaurar usuarios creados anteriormente
* https://www.jesusninoc.com/03/13/ejercicios-de-powershell-restaurar-usuarios-que-se-han-creado-anteriormente-se-almacenan-en-un-fichero-y-se-vuelven-a-crear/

## Ver los progrmas que hay instalados en un equipo e instalarlos en otro leyendo de un fichero
* https://www.jesusninoc.com/03/16/ejercicios-de-powershell-ver-los-programas-que-hay-instalados-en-un-equipo-e-instalarlos-en-otro-guardar-el-nombre-de-los-programas-en-un-fichero/

## Mapear unidades
* https://www.jesusninoc.com/03/17/ejercicios-de-powershell-mapear-varias-unidades-que-se-encuentran-en-un-fichero/
* https://www.jesusninoc.com/02/16/ejercicios-de-powershell-mapear-varios-recursos-unidades-creando-tambien-las-carpetas-y-compartiendo-leyendo-de-un-fichero-el-nombre-el-mismo-nombre-para-todas-las-operaciones-de-la-carpeta-que/

## Poner bonito
* https://www.jesusninoc.com/02/25/ejercicios-de-powershell-crear-un-menu-sencillo/

# Solución a la situación crítica 2 (muy avanzada)

## Instalar software en cualquier equipo de la red desde PowerShell leyendo desde un archivo la información para instalar utilizando credenciales almacenados (solución de Diego A.)
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-09.md#instalar-software-en-cualquier-equipo-de-la-red-desde-powershell-leyendo-desde-un-archivo-la-informaci%C3%B3n-para-instalar-utilizando-credenciales-almacenados-soluci%C3%B3n-de-diego-a

-----------
-----------

# Situación crítica 2 (resolver la siguiente situación con scripts)

## Dentro de una empresa se está ejecutando una aplicación de forma anómala, utiliza todo lo que sabes para crear funciones en un script que permitan detectar la aplicación.

### Ideas que se pueden aplicar:
- ¿Cómo detectar que se está ejecutando un proceso? https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#c%C3%B3mo-detectar-que-se-est%C3%A1-ejecutando-un-proceso
- Mostrar un mensaje en PowerShell cuando se ejecuta y se para un programa https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#mostrar-un-mensaje-en-powershell-cuando-se-ejecuta-y-para-un-programa

-----------------

# Solución a la situación crítica 2

## Vamos a tener en cuenta:
- Un proceso que no se comporta como siempre es raro.
- Un proceso que abre muchos hilos es raro.
- Analizar los hilos de un proceso en concreto
- Un proceso que abre muchas comunicaciones es raro.
- Un proceso que consume fuera de normal es raro.
- Un proceso que se activa a una hora extraña es raro.
- Un proceso cuya firma ha cambiado es extraño.
- Mostrar los procesos que utiliza un controlador

## Scripts para cada uno de los apartados anteriores
* https://www.jesusninoc.com/03/02/ejercicios-de-seguridad-analizar-informacion-sobre-procesos-de-forma-detallada-en-windows-con-powershell/

----------
----------

# Situación crítica 3 (resolver la siguiente situación con scripts)

## Crear para cada usuario lo necesario para funcionar en un puesto de trabajo teniendo en cuenta:
- Los usuarios se crean en el Directorio Activo.
- La información se lee de un fichero que cada línea contiene la siguiente información nombre de usuario, grupo al que pertenece, nombre de carpeta compartida, permisos.
- Cada usuario tiene una carpeta compartida con su nombre (y solo ese usuario tiene permisos tanto NTFS como permisos de compartir).

### Ideas que se pueden aplicar:
- Teoría sobre AD https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-18.md
- Crear usuarios en AD https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-24.md#crear-en-ad-usuarios-y-ou-leyendo-de-un-fichero
- Crear recurso compartido https://www.jesusninoc.com/02/21/crear-un-recurso-compartido/

-----------------

# Solución a la situación crítica 3
- Solución de Pablo https://github.com/PabloQueipo/ISO/blob/master/19%20MARZO

-------------
-------------

# Situación crítica 4 (resolver la siguiente situación con scripts)

## Crear una estructa en el dominio del Directorio Activo con los departamentos de un hospital, junto con usuarios que se leen de un fichero (crear unidades organizativas y meter dentro usuarios).

### Utilizar los siguientes scripts como ayuda:
- https://github.com/jesusninoc/ClasesISO/blob/master/2019-04-03.md#crear-mediante-scripts-una-estructura-de-dominio-parecida-a-la-que-tenemos-en-el-centro-soluci%C3%B3n-alejandro-aracil
- https://github.com/jesusninoc/ClasesISO/blob/master/2019-04-03.md#otra-soluci%C3%B3n-con-ejemplos-de-creaci%C3%B3n-de-pol%C3%ADticas-de-grupo-ignacio-barranquero

-----------------

# Solución a la situación crítica 4 (solución de Pablo)
* https://github.com/PabloQueipo/ISO/blob/master/24%20MARZO%202020.md
