# Administración de recursos compartidos
- Instalación y configuración de servicios
- Administración del acceso a recursos. SMB/CIFS. SAMBA. NFS.
- Grupos de trabajo.
- Permisos de red. Permisos locales. Herencia. Permisos efectivos.

-----------

# Carpetas compartidas

## PowerShell

### Introducción
* https://www.jesusninoc.com/02/11/ejercicios-de-powershell-obtener-informacion-sobre-los-dispositivos-de-almacenamiento/
* https://www.jesusninoc.com/06/14/conectarse-a-una-carpeta-compartida-con-powershell/
* https://www.jesusninoc.com/04/30/ejercicios-de-powershell-crear-una-carpeta-compartida-mapearla-y-utilizarla/

### Create a drive mapped to a network share
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/new-psdrive?view=powershell-6
```PowerShell
New-PSDrive -Name "P" -PSProvider "FileSystem" -Root "\\Server01\Public"
```

### The Win32_Share class represents a shared resource on a computer system running Windows
```PowerShell
gwmi Win32_Share
```
```PowerShell
get-WmiObject -class Win32_Share -computer dc1 -Credential dominio\administrador
```
### Network resources
```PowerShell
net view \\dc1
```
### Listing Network Drives
* https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/listing-network-drives
```PowerShell
$obj = New-Object -ComObject WScript.Network
$result = $obj.EnumNetworkDrives() 
Foreach ($entry in $result)
{
    $letter = $entry
    $null = $foreach.MoveNext()
    $path = $foreach.Current
  
  
    [PSCustomObject]@{
        DriveLetter = $letter
        UNCPath = $path
    }
}
```
### Get shares that are connected to a specific server
https://docs.microsoft.com/en-us/powershell/module/smbshare/get-smbshare?view=win10-ps
```PowerShell
Get-SmbShare -ScopeName "Contoso-FS"
```

### Ejercicios sobre carpetas compartidas
* https://www.jesusninoc.com/02/16/ejercicios-de-powershell-crear-recursos-unidades-con-new-psdrive-de-para-varias-carpetas-compartidas-leyendo-de-un-fichero-las-rutas-compartidas-y-los-nombres-de-los-recursos-que-se-van-a-crear/
* https://www.jesusninoc.com/02/16/ejercicios-de-powershell-mapear-varios-recursos-unidades-creando-tambien-las-carpetas-y-compartiendo-leyendo-de-un-fichero-el-nombre-el-mismo-nombre-para-todas-las-operaciones-de-la-carpeta-que/

## Linux

### Differences between /dev/sda and /dev/sda1
http://serverfault.com/questions/338937/differences-between-dev-sda-and-dev-sda1

### Obtener tipo de partición, UUID y el identificador del nodo. BLKID
```Bash
blkid
```
### Tip: Using UUID for mounting disks, the convenient way
https://access.redhat.com/discussions/1573543

### Muestra información referente a los dispositivos conectados a los puertos USB
```Bash
lsusb
```
### Repaso de ficheros de configuración en Linux
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-02-20.md#repaso-de-ficheros-de-configuraci%C3%B3n-en-linux

### Montar un sistema SMB
```Bash
sudo mount -t cifs //10.0.1.101/copias /mnt/backup
```

### Sincronizar carpetas montadas
```Bash
rsync -rutv --progress --bwlimit=40000 /srv/carpeta/ /mnt/backup/carpeta/
rsync -rutvl --progress --bwlimit=40000 /var/www/web/ /mnt/backup/www
```

### Conectarse desde GNU/Linux a una carpeta Windows compartida (Samba)
http://fraterneo.blogspot.com.es/2011/06/conectarse-desde-gnulinux-una-carpeta.html

### Access the Windows Share from Linux
https://www.howtogeek.com/176471/how-to-share-files-between-windows-and-linux/

```Bash
sudo apt-get install cifs-utils
mkdir ~/Desktop/Windows-Share 
sudo mount.cifs //WindowsPC/Share /home/jes/Desktop/Windows-Share -o user=jesusninoc
````

### Create a Share on Linux and Access It from Windows
```Bash
# Instalar samba
sudo apt-get install samba

# Poner password al usuario
smbpasswd -a jesusninoc

# Carpeta que vamos a compartir
mkdir ~/Desktop/Share

# Editar el fichero de configuración
sudo vi /etc/samba/smb.conf

# Añadir contenido sobre la carpeta que vamos a compartir al fichero de configuración smb.conf
[<folder_name>]
path = /home/<user_name>/<folder_name> 
available = yes 
valid users = <user_name> 
read only = no 
browsable = yes 
public = yes 
writable = yes

# Reiniciar samba
sudo service smbd restart
```

## Conectarse desde GNU/Linux a una carpeta Windows compartida (Samba)
http://fraterneo.blogspot.com.es/2011/06/conectarse-desde-gnulinux-una-carpeta.html

--------------

# Posibles preguntas para el examen

- Pedir un proceso
  - Comprobar la ruta y el hash (hay un listado de hash para los programas que hay en el sistema)
  - Comprobar si hay algún drivers cambiado (hay un listado de hash para los drivers)
- Instalar programas en Ubuntu leyendo desde un fichero
- Ver versión de programas instalados, los antiguos hay que actualizarlos
- Actualización
- Control de acceso a programas
- Controladores, drivers
- Instalar y actualizar
- Qué proceso realizas para crear un usuario
- Crear y añadir usuarios
- El usuario con más privilegios
- Habilitar usuarios
- Seguridad en contraseñas
- Permisos, herencia, permisos efectivos
- Cambiar dueño usuario
- Carpetas compartidas

------------
------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.
  
# Administración de recursos compartidos
- Instalación y configuración de servicios
- Administración del acceso a recursos. SMB/CIFS. SAMBA. NFS.
- Grupos de trabajo.
- Permisos de red. Permisos locales. Herencia. Permisos efectivos.

---------------------

# Repaso del mes
## Script para realizar tareas básicas y avanzadas
https://github.com/jesusninoc/Scripts/blob/master/Realizar%20tareas%20b%C3%A1sicas%20y%20avanzadas.sh
## Cmdlets relacionados con tareas básicas y de administración en el sistema operativo Windows
https://www.jesusninoc.com/2015/04/28/cmdlets-relacionados-con-tareas-basicas-y-de-administracion-en-el-sistema-operativo-windows/

# Repaso del BOE
- Administración de software de base
- Administración de recursos compartidos

# Repaso de las tareas de administración III
### Gestión del almacenamiento
* https://www.jesusninoc.com/2017/07/03/3-gestion-del-hardware-en-powershell/
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
### Gestión de la red
* https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
### Copias de seguridad
* https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

---------------------

# Realizar un script que sea una tarea programada que almacene información sobre la situación actual del sistema operativo (Windows y Linux), teniendo en cuenta:
- Programas instalados
- Actualizaciones
- Usuarios y grupos

## Además de almacenar información, el script tiene que permitir hacer una recuperación con la información almacenada, por ejemplo restaurar usuarios leyendo de un fichero los usuarios y grupos a los que pertenecen.

## Ideas que se pueden aplicar al script:
- Almacenar los .exe de los programas
- Almacenar los ficheros .dll de los programas
- Almacenar los instaladores .msi de los programas instalados
- Realizar un proceso de firma (hash) a los programas instalados
- Utilizar expresiones regulares

----------------------

# Hyper-V: Backup VMs to a shared folder with Windows Server Backup and a Scheduled Task-
https://sid-500.com/2018/03/11/hyper-v-backup-vms-to-a-shared-folder-with-windows-server-backup-and-a-scheduled-task/
```PowerShell
$Action=New-ScheduledTaskAction -Execute 'C:\Temp\backupVM.bat'
$Trigger=New-ScheduledTaskTrigger -Weekly -DaysOfWeek Saturday -At 11am
$Set=New-ScheduledTaskSettingsSet
$Principal=New-ScheduledTaskPrincipal -UserId 'sid-500\administrator' -LogonType S4U
$Task=New-ScheduledTask -Action $Action -Trigger $Trigger -Settings $Set -Principal $Principal
Register-ScheduledTask -TaskName "Backup VM" -InputObject $Task -Force
```

# Linux – Tigger commands and tasks during file system changes
https://www.capatek-tutorials.com/linux/linux-tigger-commands-tasks-file-system-changes/

# Scheduled Task with Daily Trigger and Repetition Interval
https://stackoverflow.com/questions/20108886/scheduled-task-with-daily-trigger-and-repetition-interval
```PowerShell
$trigger = New-ScheduledTaskTrigger `
    -Once `
    -At (Get-Date) `
    -RepetitionInterval (New-TimeSpan -Minutes 5) `
    -RepetitionDuration ([System.TimeSpan]::MaxValue)
```

---------------------

# ¿Cómo detectar que ha aparecido un equipo en la red WIFI?
- Mostrar un mensaje en PowerShell cuando aparece un equipo WIFI en la red
```PowerShell
```

---------------------

# ¿Cómo detectar que se está ejecutando un proceso?
- Conocer procesos
- Firmas de procesos
- Mostrar un mensaje en PowerShell cuando se ejecuta y se para un programa (por ejemplo se ejecuta powershell)
```PowerShell
Start-Process powershell.exe "-command ps"
```
- Localizar el proceso que está relacionado con el puerto de carpetas compartidas
```PowerShell
netstat -ano
```
- Contar procesos
- Contar hilos
- Analizar la red
- Auditar
- Registro
- Registro y logs de carpetas compartida
- Explorer
- Keylogger
- Volcado de procesos
- Capturar la pantalla
- Get-Counter

-------------------

# PowerShell
## Detectar si hay un dispositivo USB conectado y copiar el contenido en una carpeta temporal
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Detectar%20si%20hay%20un%20dispositivo%20USB%20conectado%20y%20copiar%20el%20contenido%20en%20una%20carpeta%20temporal.ps1

## Discover a webcam
https://www.jesusninoc.com/2017/10/17/discover-a-webcam/

## Ver los teléfonos móviles que se han conectado al sistema operativo
https://www.jesusninoc.com/2016/12/01/ver-los-telefonos-moviles-que-se-han-conectado-al-sistema-operativo/

## Conocer el estado del ratón
https://www.jesusninoc.com/2016/10/05/conocer-el-estado-del-raton/

## Activar un dispositivo Plug and Play con PowerShell
https://www.jesusninoc.com/2018/03/08/activar-un-dispositivo-plug-and-play-con-powershell/

## Desactivar un dispositivo Plug and Play con PowerShell
https://www.jesusninoc.com/2018/02/08/desactivar-un-dispositivo-plug-and-play-con-powershell/

## Show UDID of iPhone
https://www.commandlinefu.com/commands/view/15421/show-udid-of-iphone

-------------------

# Linux
## Setting Up NFS Share on Windows
https://support.microfocus.com/kb/doc.php?id=7020834

## Montar una carpeta compartida de Windows en Linux
https://blog.desdelinux.net/montar-unidades-smb-desde-consola/

## dd command
https://www.computerhope.com/unix/dd.htm

Caution: Use dd cautiously — improper usage or entering the wrong values could inadvertently wipe, destroy, or overwrite the data on your hard drive.

### Create a ISO disc image from the CD in the computer
```Bash
dd if=/dev/sr0 of=/home/hope/exampleCD.iso bs=2048 conv=noerror,sync
```

### Create an img file of the /dev/sda hard drive. To restore that image type: dd if=disk1.img of=/dev/sda
```Bash
dd if=/dev/sda of=~/disk1.img
```

### Copy the contents from the if= drive /dev/sda to the of= drive /dev/sdb.
```Bash
dd if=/dev/sda of=/dev/sdb
```

## How to dd a remote disk using SSH on local machine and save to a local disk
https://unix.stackexchange.com/questions/132797/how-to-dd-a-remote-disk-using-ssh-on-local-machine-and-save-to-a-local-disk

### run from remote computer
```Bash
$ dd if=/dev/sda | gzip -1 - | ssh user@local dd of=image.gz
```

### run from local computer
```Bash
$ ssh user@remote "dd if=/dev/sda | gzip -1 -" | dd of=image.gz
```
