# Corrección del examen
## Crear una función en la que le pasas una conexión de red y te dice qué proceso ejecuta (le puedes pasar una IP o un puerto)
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-crear-una-funcion-en-la-que-se-pasa-una-conexion-de-red-y-te-dice-proceso-ejecuta-se-puede-pasar-una-ip-o-un-puerto/
## Crear una función que agrupa los nombre obtenidos mediante una resolución DNS (sin mostrar errores)
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-crear-una-funcion-que-agrupa-los-nombre-obtenidos-mediante-una-resolucion-dns-sin-mostrar-errores/
## Mostrar los hilos que se están ejecutando y deducir si se pueden relacionar con sockets abiertos
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-mostrar-los-hilos-que-se-estan-ejecutando-y-deducir-si-se-pueden-relacionar-con-sockets-abiertos-tcp-o-udp/

---------------
---------------

# Configurar red con Netplan

---------------
---------------

# Administración de recursos compartidos:
- Instalación y configuración de servicios
- Administración del acceso a recursos. SMB/CIFS. SAMBA. NFS.
- Grupos de trabajo.
- Permisos de red. Permisos locales. Herencia. Permisos efectivos.

--------------

# Scripting

## Repaso básico de Linux para la parte de scripting
* http://www.freeos.com/guides/lsst/ch02.html
* http://www.freeos.com/guides/lsst/ch02sec20.html

## Repaso básico de Windows para la parte de scripting
### Snippets in Windows PowerShell
https://www.jesusninoc.com/2014/03/19/snippets-in-windows-powershell/

--------------

# Repaso discos

## LVM (Logical Volume Manager)

Un LVM se descompone en tres partes:
- Volúmenes físicos (PV): Son las particiones del disco duro con sistema de archivos LVM. (raid's)
- Grupos de volúmenes (VG): es la parte superior de la LVM. Es la "caja" en la que tenemos nuestros volúmenes lógicos (LV) y nuestros volúmenes físicos (PV). Se puede ver como una unidad administrativa en la que se engloban nuestros recursos. Hay que hacer notar que mientras un PV no se añada al VG, no podemos comenzar a usarlo.
- Volúmenes lógicos (LV): es el equivalente a una partición en un sistema tradicional. El LV es visible como un dispositivo estándar de bloques, por lo que puede contener un sistema de archivos (por ejemplo /home)

```Dibujo
               sda1        sdb    (PV:s, particiones o discos completos)
                     /
                    /
               linuxvg            (VG)
             /    |    
           /      |      
       ubuntu   arch     home     (LV:s)
         |        |       |
       ext4      ext4    xfs      (sistemas de archivos)
```

## Operaciones sobre discos en Windows:
- Crear particiones
- Borrar particiones
- Recuperar particiones eliminadas
- Cifrar
- Comprimir
- Convertir entre sistemas de archivos

## Discos dinámicos
http://windows.microsoft.com/es-es/windows-vista/what-are-basic-and-dynamic-disks

--------------

# Arranque
- BIOS
- POST
- Arranque (dual, BCD, BCDEdit, etc.)
- Arranque de procesos

## Arranque en Linux
### Proceso de arranque en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Arranque en Windows
### Proteger el proceso de arranque de Windows 10
https://docs.microsoft.com/es-es/windows/security/hardware-protection/secure-the-windows-10-boot-process
### Procesos de credenciales de autenticación de Windows
https://docs.microsoft.com/es-es/windows-server/security/windows-authentication/credentials-processes-in-windows-authentication

--------------

# Permisos en PowerShell

## 4. Gestión de archivos en PowerShell para administradores de sistemas
https://www.jesusninoc.com/2016/11/10/4-gestion-de-archivos-en-powershell-para-administradores-de-sistemas/

## Obtener los descriptores de seguridad de todos los ficheros de una unidad
https://www.jesusninoc.com/2016/09/10/obtener-los-descriptores-de-seguridad-de-todos-los-ficheros-de-una-unidad/

## Enumeración FileSystemRights: Define los derechos de acceso que se utilizará al crear reglas de acceso y auditoría
https://msdn.microsoft.com/es-es/library/system.security.accesscontrol.filesystemrights(v=vs.110).aspx

## Clonar permisos NTFS
https://www.jesusninoc.com/2015/01/23/clonar-permisos-ntfs/

## Eliminar permisos explícitos
https://www.jesusninoc.com/2016/03/30/eliminar-permisos-explicitos/

## Añadir permiso NTFS a una carpeta
https://www.jesusninoc.com/2015/08/19/anadir-permiso-ntfs-a-una-carpeta/

## Weekend Scripter: Use PowerShell to Get, Add, and Remove NTFS Permissions
https://blogs.technet.microsoft.com/heyscriptingguy/2014/11/22/weekend-scripter-use-powershell-to-get-add-and-remove-ntfs-permissions/

## Ejemplo de asignación de permisos
```PowerShell
New-Item -type directory -path C:\MyFolder
$Acl = Get-Acl "C:\MyFolder"
$Ar = New-Object  system.security.accesscontrol.filesystemaccessrule("username","FullControl","Allow")
$Acl.SetAccessRule($Ar)
Set-Acl "C:\MyFolder" $Acl
```

--------------

# Permisos en Linux
Why does the default umask value contains 4 digits?
The first digit in 0022 defines the special permission value. In case you want to set any special permission to every file/directory to be created then you can define the value accordingly.

For understanding all the special permission and their value follow the below link
- Understanding Special Permission SGID in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-sgid.html
- Understanding Special Permission SUID in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-suid.html
- Understanding Special Permission Sticky Bit in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-sticky.html

## Comando para ver permisos de un fichero
```Bash
stat -f "%Sp -> owner=%SHp group=%SMp other=%SLp" fichero.txt  
```

## Ejemplo sobre asignación de permisos al crear carpetas
### Creates a new directory called mydir whose parent is the current directory.
```Bash
mkdir examples
mkdir mydir
```
Create the mydir directory, and set its permissions such that all users may read, write, and execute the contents.
```Bash
mkdir -m a=rwx mydir
```
Creates the directory /home/chope/a/b/c. If the parent directory /home/chope/a/b does not already exist, mkdir will create that directory first.
```Bash
mkdir -p /home/chope/a/b/c
```

## Permisos avanzados en C
http://www.jesusninoc.com/2015/01/19/programacion-de-permisos/

--------------

# Integridad
## PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosProcesosAvanzado.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Ficheros/EjemploIntegridad.ps1
## Linux
* https://www.jesusninoc.com/2016/01/02/for-loop-examples/
* https://www.jesusninoc.com/2015/07/14/sentencia-condicional-if-else-2/
* https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

--------------

# Copias de seguridad

## En Windows
### 10. Gestión del rendimiento en PowerShell para administradores de sistemas
https://www.jesusninoc.com/2016/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/
### Copias de seguridad (explicación básica del concepto de copia de seguridad incremental y diferencial)
https://github.com/jesusninoc/PowerShell/tree/master/CopiasSeguridad

## En Linux
https://www.ochobitshacenunbyte.com/2017/07/10/copias-de-seguridad-con-dump-y-restore-en-linux/

--------------

# USB

## Memorias USB: riesgos, protección y acceso a los datos
https://www.securityartwork.es/2018/01/24/memoricas-usb-riesgos-proteccion-acceso-los-datos/

## Detectar si hay un dispositivo USB conectado y copiar el contenido en una carpeta temporal
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Detectar%20si%20hay%20un%20dispositivo%20USB%20conectado%20y%20copiar%20el%20contenido%20en%20una%20carpeta%20temporal.ps1


--------------

# ISO, WIM

## Crear ISO
https://gallery.technet.microsoft.com/scriptcenter/New-ISOFile-function-a8deeffd

## Crear una imagen WIM de un disco duro y expandirla después en un disco duro
https://www.jesusninoc.com/2015/08/02/crear-una-imagen-wim-de-un-disco-duro-y-expandirla-despues-en-un-disco-duro/

## Crear un WIM de un USB (copia de seguridad) copiarlo a una carpeta compartida (controlar los permisos de red y NTFS), tener en cuenta:
- Crear WIM
- Ver ficheros USB
- Crear carpeta compartida
- Copia de seguridad
- Realizar firma del fichero obtenido
