# Administración de software de base

 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Repaso de ficheros de configuración en Linux

## Network
http://www.yolinux.com/TUTORIALS/LinuxTutorialNetworking.html

## Netplan configuration examples
https://netplan.io/examples

### To instead set a static IP address, use the addresses key, which takes a list of (IPv4 or IPv6), addresses along with the subnet prefix length (e.g. /24). Gateway and DNS information can be provided as well:

```Bash
network:
  version: 2
  renderer: networkd
  ethernets:
    enp3s0:
      addresses:
        - 10.10.10.2/24
      gateway4: 10.10.10.1
      nameservers:
          search: [mydomain, otherdomain]
          addresses: [10.10.10.1, 1.1.1.1]
```

--------------

# Firewall
## Enable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/16/enable-the-microsoft-windows-firewall/
## Disable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/15/disable-the-microsoft-windows-firewall/
## Ejemplos de reglas de firewall
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-deshabilitadas/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-en-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-no-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-de-salida-del-firewall-desde-powershell-de-windows-que-estan-habilitadas-y-permiten-conexion/
* https://www.jesusninoc.com/02/09/mostrar-los-puertos-que-estan-abiertos-en-las-reglas-de-entrada-del-firewall-de-windows-desde-powershell-que-estan-habilitadas-y-permiten-conexion/
## Log del Firewall
```Cmd
%systemroot%\system32\LogFiles\Firewall\pfirewall.log
```

--------------
--------------

# Examen
## Crear una función en la que le pasas una conexión de red y te dice qué proceso ejecuta (le puedes pasar una IP o un puerto)
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-crear-una-funcion-en-la-que-se-pasa-una-conexion-de-red-y-te-dice-proceso-ejecuta-se-puede-pasar-una-ip-o-un-puerto/
## Crear una función que agrupa los nombre obtenidos mediante una resolución DNS (sin mostrar errores)
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-crear-una-funcion-que-agrupa-los-nombre-obtenidos-mediante-una-resolucion-dns-sin-mostrar-errores/
## Mostrar los hilos que se están ejecutando y deducir si se pueden relacionar con sockets abiertos
* https://www.jesusninoc.com/02/09/ejercicios-de-powershell-mostrar-los-hilos-que-se-estan-ejecutando-y-deducir-si-se-pueden-relacionar-con-sockets-abiertos-tcp-o-udp/
